option(null: hard);	

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	swap_il_zero create funcs
	--------------------------------------------------------------------			
*/


//--------
// from db
//--------
/*-----------------------------------------------------------------------
  swap_il_zero
  ----------------------------------------------------------------------*/
swap_il_zero swap_il_zero(	instrument_name 			instrument_name, 
							date option(nullable) 	trade_date 	= null<date>,
							string option(nullable) quote_side 	= null<string>,
							error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Zero Swap")
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_swap_il_zero(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_zero");
		return null<swap_il_zero>;
	}
}


/*-----------------------------------------------------------------------
  swap_il_zero
  ----------------------------------------------------------------------*/
swap_il_zero swap_il_zero(	instrument_name 			instrument_name, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Zero Swap")
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, null<date> );
		return create_swap_il_zero(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_zero");
		return null<swap_il_zero>;
	}
}


/*-----------------------------------------------------------------------
  swap_il_zero
  ----------------------------------------------------------------------*/
swap_il_zero swap_il_zero(	instr_def 					instr_def, 
							date option(nullable) 	trade_date 	= null<date>,
							string option(nullable) quote_side 	= null<string>,
							error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Zero Swap")
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_swap_il_zero(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_zero");
		return null<swap_il_zero>;
	}
}
/*-----------------------------------------------------------------------
  instrument
  ----------------------------------------------------------------------*/
swap_il_zero swap_il_zero(	instr_def 					instr_def, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Zero Swap")
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_swap_il_zero(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_zero");
		return null<swap_il_zero>;
	}
}

//----------------
// from db or not
//----------------


/*-----------------------------------------------------------------------
  func: swap_il_zero 
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name

  ----------------------------------------------------------------------*/
swap_il_zero swap_il_zero(	instr_def 				instr_def, 
								string 					instrument_name  ,			
								date option(nullable) 	trade_date ,
								date option(nullable) 	settle_date ,							
								integer 				maturity_yrs,
								number option(nullable) zero_infl_rate ,							
								..cpi_link 				cpi_link,
								..cpi_link	option(nullable)	cpi_link_fcast,
								number 	option(nullable) nominal=100,
								error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Zero Swap")
{	
	try{			

		__instrument c = __instrument_zeroswap_il_par_nodb(instr_def,instrument_name,trade_date, settle_date,
														   maturity_yrs,zero_infl_rate,cpi_link, cpi_link_fcast,nominal );
		
		/*if(!null(maturity))
			c = __instrument_zeroswap_il_par_nodb(	instr_def,instrument_name,trade_date, settle_date,
													maturity,zero_infl_rate,cpi_link, cpi_link_fcast,nominal );
		else if(!null(maturity_code))
			c = __instrument_zeroswap_il_par_nodb(instr_def,instrument_name,trade_date, settle_date,
														   maturity_code,zero_infl_rate,cpi_link, cpi_link_fcast,nominal );
		else
			QL_FAIL("invalid maturity/maturity_code");*/

		return create_swap_il_zero( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_zero");
		return null<swap_il_zero>;
	}
}

//----------------
// no db, swaplib version
// an external swap is created. Note: an external swap has no internal instr_def
// but can be created from an instr_def
//----------------

/*-----------------------------------------------------------------------
  func: swap_il_zero
  ----------------------------------------------------------------------*/
swap_il_zero swap_il_zero(ql_fixed_income_swap ql_fixed_income_swap,
						error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Zero Swap')
{	
	try{	
		QL_FAIL_COND(CORE_INT.swap_instr_type(ql_fixed_income_swap) != instr_type.IL_SWAP_ZERO, "invalid instrument type", E_INIT);

		__instrument c = __instrument_swap(ql_fixed_income_swap);

		return create_swap_il_zero(c, error);				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_zero");
		return null<swap_il_zero>;
	}
}


/*-----------------------------------------------------------------------
  func: swap_il_zero
  ----------------------------------------------------------------------*/
swap_il_zero swap_il_zero(	ql_fix_zero_leg 		ql_zero_leg, 							
							ql_zero_infl_leg 		ql_infl_leg,
							string 					id,
							error_info option(nullable) error = null<error_info>)
option (category: 'Curve and Instrument/Inflation Linked/Zero Swap')
{	
	try{			
		__instrument c = __instrument_swap(ql_zero_leg,ql_infl_leg,id);

		return create_swap_il_zero(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_zero");
		return null<swap_il_zero>;
	}
}

module CORE_INT_IL_ZERO_SWAP
{
	tenor_code swap_il_zero_maturity_helper(instr_def option(nullable)	def, 
									integer maturity_years)
	{
		if(maturity_years != err_int() && maturity_years > 0) {
			string maturity_code = strcat(str(maturity_years),"Y_NONE");		
			return tenor_code(maturity_code);
		}

		if(null(def))
			QL_FAIL("missing maturity/maturity_code", E_INIT);
		
		error_info ee = error_info(true,true);
		string mc = def.maturity_code(ee);
		if(!null(mc))
			return tenor_code(mc);
		
		QL_FAIL("missing maturity/maturity_code", E_INIT);			
	}
	
	/*-----------------------------------------------------------------------
	  func: swap_il_zero_plain_int
	  minimal constructor for single curr "screen"-swap,
	  ----------------------------------------------------------------------*/
	swap_il_zero swap_il_zero_plain_int(instr_def 					def,
										string 						instrument_name,	
										date option(nullable) 		trade_date,	
										date option(nullable) 		start_date,
										//string option(nullable) 	fwd_start_code,
										//date 	option(nullable)	maturity,
										integer						maturity_years,
										number option(nullable)		zero_infl_rate ,//if null --> will be set to par 									
										number 	 					notional,																										
										logical 					pay_infl,
										cpi_link 					cpi_l ,
										cpi_link option(nullable)	cpi_l_f,
										..disc_func option(nullable) zero_disc_func,
										..disc_func option(nullable) zero_infl_disc_func,																												
										error_info option(nullable) error )
	{	
		try{
			CORE_INT.reset_single(error);
			QL_FAIL_COND(!def.is_il_zero_swap(), "instr_def not a inflation zero swap", E_INIT);
			logical is_ccy				= def.is_ccy_swap();
			QL_FAIL_COND(is_ccy, "constructor not applicable for currency swap", E_INIT);

			date 	maturity = null<date>;
			string fwd_start_code = "";
				
			number zero_fx_rate = 1;
			number infl_fx_rate = 1;
			number zero_notional = notional;
			number infl_notional = notional;
			//---def---
			error_info ee = error_info(true,true);
			notional_exchg_style ne = def.swap_not_exchange(ee);

			if(null(ne))
				ne 	= is_ccy ? NE_NONE : NE_END;

			date_code settle_code 		= date_code(def.settle_code());		
			//coupon_freq  fix_cpn_freq 	= coupon_freq_from_int(def.coupon_freq(ee))  ;		
			calendar pmt_calendar		= def.swap_calendar_leg1(ee);
			bd_convention pmt_bus_day 	= def.swap_pmt_bus_day_leg1(ee);
			logical	end_of_month		= def.swap_eom_leg1(ee);
			number pmt_delay			= def.swap_pmt_lag_leg1(ee);
			infl_index_method index_method = def.il_index_method(ee);
			quote_style qs 				= null<quote_style>;	
			round_code pv_round_code	= null<round_code>;
			logical average_notional 	= null<logical> ;
			
			zero_rate_comp_style comp_style = zero_rate_comp_style.ZC_ANNUAL;
			logical notional_net		= null<logical> ;
			logical reverse				= null<logical> ;
			
			ql_swap_fix_zero_def zero_def 	= ql_swap_fix_zero_def("zero_def", def.swap_currency_leg1(ee), settle_code, def.swap_dc_method_leg1(ee),
																   pmt_bus_day,pmt_calendar,end_of_month,comp_style,notional_net,reverse,qs,
																   pv_round_code,pmt_delay, ne,average_notional);

			
			ql_swap_zero_infl_def infl_def 	= ql_swap_zero_infl_def("infl_def", def.swap_currency_leg2(ee), settle_code, 
																	pmt_bus_day,pmt_calendar, end_of_month,pv_round_code,pmt_delay, ne,index_method);


			date settle_date;
			CORE_INT_SWAPLIB.swap_start_date_helper(settle_code,trade_date,pmt_calendar,fwd_start_code,true,start_date,settle_date);
			QL_FAIL_COND(null(settle_date),"invalid start date", E_INIT);

			tenor_code mat_code = CORE_INT_IL_ZERO_SWAP.swap_il_zero_maturity_helper(def, maturity_years);
			
			if(null(zero_fx_rate)) 
				zero_fx_rate = 1;
			if(null(infl_notional) && !is_ccy) 
				infl_notional = zero_notional;
			if(null(infl_fx_rate)) 
				infl_fx_rate = 1;

			number init_rate 		= null(zero_infl_rate) ? 0 : zero_infl_rate;
			
			ql_fix_zero_leg zero 	= ql_fix_zero_leg(zero_def,"zero_leg", trade_date,settle_date,start_date,maturity,mat_code,!pay_infl,
													  zero_notional,init_rate,zero_disc_func,zero_fx_rate);
			ql_zero_infl_leg infl 	= ql_zero_infl_leg(infl_def, "infl_leg", trade_date,settle_date,start_date,maturity,mat_code,pay_infl,
													   infl_notional,zero_infl_disc_func,cpi_l,cpi_l_f,infl_fx_rate);
			
			ql_fixed_income_swap sw = ql_fixed_income_swap(zero,infl,instrument_name);

			if(null(zero_infl_rate)) {
				number z_r	= sw.solver(0,swap_solver_code.SS_FIX_RATE_LEG1,false);
				QL_FAIL_COND(null(z_r),"error solving for zero rate", E_INIT);

				zero 	= ql_fix_zero_leg(	zero_def,"zero_leg", trade_date,settle_date,start_date,maturity,mat_code,!pay_infl,
											zero_notional,z_r,zero_disc_func,zero_fx_rate);
				
				sw 		= ql_fixed_income_swap(zero,infl,instrument_name);

			}
			
			return swap_il_zero(sw, error);						
		}
		catch {
			CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_zero");
			return null<swap_il_zero>;
		}
	}
}
		
/*-----------------------------------------------------------------------
  func: swap_il_zero_plain
  minimal constructor for single curr "screen"-swap,
  this version: disc_func  input
  ----------------------------------------------------------------------*/
swap_il_zero swap_il_zero_plain(instr_def 					def,
								string 						instrument_name,	
								date option(nullable) 		trade_date,	
								date option(nullable) 		start_date,			//start_date has precedence over start_date_code
								//date option(nullable)		maturity,			//maturity has precedence over mat_code
								integer						maturity_years,																													
								number option(nullable)		zero_infl_rate ,//if null --> will be set to par 									
								number 	 					notional,																										
								logical 					pay_inflation,
								cpi_link 					cpi_l ,
								cpi_link option(nullable)	cpi_l_f,
								..disc_func option(nullable) fix_disc_func,
								..disc_func option(nullable) flt_disc_func,													    
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Zero Swap')
{
	return CORE_INT_IL_ZERO_SWAP.swap_il_zero_plain_int(	def,instrument_name,trade_date,start_date,maturity_years,
											zero_infl_rate ,notional, pay_inflation,cpi_l,cpi_l_f,
											fix_disc_func,flt_disc_func,error );
}


/*-----------------------------------------------------------------------
  func: swap_il_zero_plain
  minimal constructor for single curr "screen"-swap,
  ----------------------------------------------------------------------*/
swap_il_zero swap_il_zero_plain(INSTR_TMPL.swap_il_zero_def_tmpl	tmpl,
								string 						instrument_name,	
								date option(nullable) 		trade_date,								
								integer 					maturity_years,//if tmpl have a code it is ignored																												
								number option(nullable)		zero_infl_rate ,//if null --> will be set to par 									
								number 	 					notional,																										
								logical 					pay_inflation,
								cpi_link 					cpi_l ,
								cpi_link option(nullable)	cpi_l_f,
								..disc_func option(nullable) fix_disc_func,
								..disc_func option(nullable) flt_disc_func,																    
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Zero Swap')
{
	try{		
		instr_def def = instr_def_il_zero_swap(tmpl,maturity_years,error);		
		if(!CORE_INT.check_instr_def(def))
			return null<swap_il_zero>;
		return swap_il_zero_plain(	def,instrument_name,trade_date,null<date>, maturity_years,zero_infl_rate ,
									notional,pay_inflation,cpi_l,cpi_l_f,fix_disc_func,flt_disc_func,error);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_zero");
		return null<swap_il_zero>;
	}
}

/*swap_il_zero swap_il_zero_plain(INSTR_TMPL.swap_il_zero_def_tmpl	tmpl,
								string 						instrument_name,	
								date option(nullable) 		trade_date,	
								date option(nullable) 		start_date,//if tmpl have a code it is ignored
								date 						maturity,//if tmpl have a code it is ignored																												
								number option(nullable)		zero_infl_rate ,//if null --> will be set to par 									
								number 	 					notional,																										
								logical 					pay_inflation,
								cpi_link 					cpi_l ,
								cpi_link option(nullable)	cpi_l_f,
								..disc_func option(nullable) fix_disc_func,
								..disc_func option(nullable) flt_disc_func,															    
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Zero Swap')
{
	try{		
		instr_def def = instr_def_il_zero_swap(tmpl,error);		
		if(!CORE_INT.check_instr_def(def))
			return null<swap_il_zero>;
		return swap_il_zero_plain(	def,instrument_name,trade_date,start_date, maturity,null<string>,zero_infl_rate ,
									notional,pay_inflation,cpi_l,cpi_l_f,fix_disc_func,flt_disc_func,error);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_zero");
		return null<swap_il_zero>;
	}
}
*/

