option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	equity option vanilla
	--------------------------------------------------------------------
	todo: create and expired
*/


//----------------------------------------------------------------------
//  class equity_option_vanilla
//----------------------------------------------------------------------
class equity_option_vanilla: public fin_instr
option(category: "Instrument/Equity Option")
//option(allow_undeclared_mfuncs)
{
public:
	equity_option_vanilla(	string, vanilla_option_eq_def, equity,option_model_e,date option(nullable) ,date ,number option(nullable) ,
							number 	option(nullable) ,number,number,number ,number option(nullable) );
	
	override instr_type 	instr_type(error_info option(nullable) error = null<error_info>);
    //override string			instr_type_s();	
	/*override*/ fin_instr 	inst();
	
	override equity_option_vanilla 	clone();
	
	override void        	__dbg_print(__dbg_label);
    override void       	__dbg_browse(__dbg_split);

	vanilla_option_eq_def	eq_opt_def();
	vanilla_option_eq		eq_opt();

	override string 	name(error_info option(nullable) error = null<error_info> );
	override logical 	is_valid(error_info option(nullable) error= null<error_info>);
	override logical 	is_expired(error_info option(nullable) error= null<error_info>);
	override integer 	id(error_info option(nullable) error = null<error_info> );
	string 				currency(error_info option(nullable) error = null<error_info> );
	calendar 			calendar(error_info option(nullable) error = null<error_info>  );		
	override date 		trade_date(error_info option(nullable) error= null<error_info>);
	date 				settle_date(error_info option(nullable) error= null<error_info>);
	string 				settle_code(error_info option(nullable) error = null<error_info> );
	string 				deliv_settle_code(error_info option(nullable) error = null<error_info> );
	

	date 				expiry_date(error_info option(nullable) error= null<error_info>);
	date 				delivery_date(error_info option(nullable) error= null<error_info>);
	quote_style_eq_opt	quote_style_eq_opt(error_info option(nullable) error= null<error_info>);
	number 				quote(error_info option(nullable) error = null<error_info>   );
	
	number 				ttm();
	number				prem(opt_prem_type,out number fwd_prem);
	opt_type 			opt_type();
	exercise_type 		exercise_type();
	number 				delta(eq_delta_type,
							  number mult 			= EQ_DFLT_DELTA_MULT,
							  number d 				= EQ_DFLT_DELTA_DIFF,
							  logical centered 		= EQ_DFLT_DELTA_CENT);
	
	number 				vega(eq_vega_type,
							 number mult 			= EQ_DFLT_VEGA_MULT,
							 number d 				= EQ_DFLT_VEGA_DIFF,
							 logical centered 		= EQ_DFLT_VEGA_CENT) ;
	
	number 				gamma( 	eq_gamma_type,
								number mult 		= EQ_DFLT_GAMMA_MULT,
								number d 			= EQ_DFLT_GAMMA_DIFF,
								logical centered 	= EQ_DFLT_GAMMA_CENT) ;

	number 				rho(eq_rho_type,
							number mult 		= EQ_DFLT_RHO_MULT,
							number d 			= EQ_DFLT_RHO_DIFF,
							logical centered 	= EQ_DFLT_RHO_CENT ) ;

	
	number 				theta(	eq_theta_type,
								number mult 		= EQ_DFLT_THETA_MULT,
								number d 			= EQ_DFLT_THETA_DIFF ) ;

	/*number 			vanna(	eq_vanna_type,
							number mult 		= DFLT_VANNA_MULT,
							number d 			= DFLT_VANNA_DIFF,
							logical centered 	= DFLT_VANNA_CENT ) ;*/
	
	
	/*number 			volga(	eq_volga_type,
							number mult 		= DFLT_VOLGA_MULT,
							number d 			= DFLT_VOLGA_DIFF,
							logical centered 	= DFLT_VOLGA_CENT ) ;*/
	
	/*----------ADD FUNCS [PUBLIC]---------------*/	
	
	
	
	equity_option_vanilla(equity_option_vanilla);
protected:
	//override __instrument 		i();
	void 						init();
	void 						check();
	
	//override equity_option_vanilla 	create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);//pure virtual
	number 					ttm_vol();
	number 					ttm_disc();
	
	string 					name_;
	vanilla_option_eq_def	eq_opt_def_;
	vanilla_option_eq		eq_opt_;
	date 					trade_;
	date 					settle_;
	date 					expiry_;
	date 					delivery_ ;
	quote_style_eq_opt		qs_;
	equity					e_;	

	//override date 		maturity(error_info option(nullable) error = null<error_info>);
	
	/*override number 	nominal(error_info option(nullable) error = null<error_info> );
	override date 		maturity(error_info option(nullable) error = null<error_info>);
	override number 	coupon(error_info option(nullable) error = null<error_info> );
	override number 	face_amount(error_info option(nullable) error = null<error_info> );
	override integer 	coupon_freq(error_info option(nullable) error = null<error_info> );
	override date 		issue_date(error_info option(nullable) error = null<error_info> );
	override number 	issued_amount(error_info option(nullable) error = null<error_info> );
	override number 	pvbp(number option(nullable),number option(nullable),logical option(nullable),logical option(nullable),
							 error_info option(nullable) error = null<error_info>) ;

	override number 	mac_dur(number option(nullable) delta = 0.0001,error_info option(nullable) error = null<error_info>);
	override number 	mod_dur(number option(nullable) delta = 0.0001,error_info option(nullable) error = null<error_info>);
	override number 	dol_dur(number option(nullable) delta = 0.0001,error_info option(nullable) error = null<error_info>);
	override number 	pvbp(number option(nullable) nom = null<number>,number  option(nullable) delta = 0.0001,
							 error_info option(nullable) error = null<error_info>);
	override number 	convexity(number option(nullable) delta = 0.0001,error_info option(nullable) error = null<error_info>);
	override number 	dol_convexity(number option(nullable) delta = 0.0001,error_info option(nullable) error = null<error_info>);
	override number 	sensitivity(number option(nullable) delta = 0.0001,error_info option(nullable) error = null<error_info>);
	
	override vector(date)	cash_flow_dates(logical post_settle = true, logical a = true, logical k = false,
											error_info option(nullable) error = null<error_info>);
	override vector(number)	cash_flows(number option(nullable) nom = null<number>,logical posts = true,logical k = false,
									   error_info option(nullable) error = null<error_info>);	

	override vector(number)	cash_flows_cpn(number option(nullable) nom = null<number>,logical posts = true,logical k = false,
										   error_info option(nullable) error = null<error_info>);		

	override void 		cash_flow_data(	number option(nullable) ,logical ,ir_cf_code ,logical,logical ,out vector(date)   ,
											out vector(number)   ,error_info option(nullable) error = null<error_info>);
					
	override number 	yield(logical dr = false,error_info option(nullable) error = null<error_info>);				
	override number 	yield(disc_func ,logical disable_rounding = false,error_info option(nullable) error = null<error_info>);
	
	override number 	dirty_price(number option(nullable),logical disable_rounding = false,logical in_pcnt = true,error_info option(nullable) error = null<error_info>);
	
	override number  	dirty_price(disc_func,logical disable_rounding = false,logical in_pcnt = true,error_info option(nullable) error = null<error_info>);
	
	override number 	clean_price(number option(nullable),logical disable_rounding = false,logical in_pcnt = true,error_info option(nullable) error = null<error_info>);
	
	override number 	clean_price(disc_func,logical disable_rounding = false,logical in_pcnt = true,error_info option(nullable) error = null<error_info>);
	
	override number 	accrued(logical disable_rounding = false,logical in_pcnt = true,error_info option(nullable) error = null<error_info>);*/
};
//------------------------------------------------
// __dbg_print
//------------------------------------------------
void equity_option_vanilla.__dbg_print(__dbg_label l)
{
	error_info ee 	= new error_info(true,false);
    l.set_text(strcat([
						"name: ",
						name(ee) ]));
}
//------------------------------------------------
// __dbg_browse
//------------------------------------------------
void equity_option_vanilla.__dbg_browse(__dbg_split s)
{
    s.resize(1);
	error_info ee 	= new error_info(true,false);
    s.set_text(0, "name");
    s.set_value(0, this.name(ee));

}
/*-----------------------------------------------------------------------
  i  overload
  ----------------------------------------------------------------------*/
/*__instrument equity_option_vanilla.i() 	option(hidden)	
{ 
	QL_FAIL(_na_func_msg, E_INIT);	//for now
	return instrument.i();	
}*/
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string 		equity_option_vanilla.instr_type_s() 		{ return string(..instr_type.EQUITY_OPTION_VANILLA);}
/*-----------------------------------------------------------------------
  instr_type
  ----------------------------------------------------------------------*/
instr_type 	equity_option_vanilla.instr_type(error_info option(nullable) ) { return ..instr_type.EQUITY_OPTION_VANILLA; }
//------------------------------------------------
// inst
//------------------------------------------------
fin_instr 	equity_option_vanilla.inst() { return this;}
//{ return dynamic_cast<instrument>(this);}
//------------------------------------------------
// copy constructor
//------------------------------------------------
equity_option_vanilla.equity_option_vanilla(equity_option_vanilla c)
						: 	/*instrument(c),*/
							name_(c.name_), eq_opt_def_(c.eq_opt_def_), eq_opt_(c.eq_opt_),
							trade_(c.trade_),settle_(c.settle_),expiry_(c.expiry_),delivery_(c.delivery_) ,qs_(c.qs_), e_(c.e_)
{}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
equity_option_vanilla equity_option_vanilla(equity_option_vanilla b)			{ return new equity_option_vanilla(b);}
//------------------------------------------------
// clone
//------------------------------------------------
equity_option_vanilla equity_option_vanilla.clone() 	{ return new equity_option_vanilla(this);}

//-----------------------------------------------
// dynamic cast <FUNCTION>
//-----------------------------------------------
equity_option_vanilla equity_option_vanilla(fin_instr i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Equity Option')
option(com_name: 'equity_option_vanilla_dyncast') 
{ 
	try {
		equity_option_vanilla d = dynamic_cast<equity_option_vanilla>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not an equity_option_vanilla)","equity_option_vanilla" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "equity_option_vanilla");
		return null<equity_option_vanilla>;
	}
}

//------------------------------------------------
// create  [PROTECTED]
//------------------------------------------------
/*equity_option_vanilla equity_option_vanilla.create(	__instrument option(nullable) c,
													out instr_error option(nullable) error,
													error_type type )
{
	QL_FAIL("invalid function call");
}*/

//------------------------------------------------
// constructor 
//------------------------------------------------
equity_option_vanilla.equity_option_vanilla(string 			name,
											vanilla_option_eq_def def,
											equity 			eq_spot ,
											option_model_e 	pmod,										
											date option(nullable) trade,
											date 			expiry,
											number 	option(nullable) spot_price,
											number 	option(nullable) fwd_price,
											number 	 		strike,
											number 			vol_prem,											
											number 			rate_cont,
											number option(nullable) div_yld_cont )
											: name_(name), eq_opt_def_(def), trade_(trade), expiry_(expiry),qs_(..quote_style_eq_opt.VOL), e_(eq_spot)
{	
	eq_opt_ = new vanilla_option_eq(eq_opt_def_.exercise_type(),eq_opt_def_.opt_type(), strike, eq_opt_def_.contract_size());

	eq_opt_.set_model(pmod);

	if(null(spot_price))
		spot_price = eq_spot.quote();

	if(null(trade_))
		trade_ = eq_spot.trade_date();

	..calendar cal 	= eq_opt_def_.cal();	
	date_code dc	= date_code(eq_opt_def_.prem_settle_code());
	settle_ 		= dc.apply_fwd(trade_,cal);
	dc				= date_code(eq_opt_def_.deliv_settle_code());	
	delivery_ 		= dc.apply_fwd(expiry_,cal);

	number q;
	option_qs_e qs;
	switch(eq_opt_def_.qs()){
	case ..quote_style_eq_opt.VOL:
		q = vol_prem;
		qs = option_qs_e.VOL;
		break;
	case ..quote_style_eq_opt.VOL_PCNT:
		q = vol_prem / 100.0;
		qs = option_qs_e.VOL;
		break;
	case ..quote_style_eq_opt.PREM:
		q = vol_prem;
		qs = option_qs_e.PREM_S;
		break;
	case ..quote_style_eq_opt.PREM_PCNT:	
		q = vol_prem /100.0 * spot_price;
		qs = option_qs_e.PREM_S;
		break;
	}
	
	eq_opt_.set_mkt_args(spot_price,fwd_price,strike,vol_prem,qs, rate_cont,div_yld_cont,ttm(),ttm_vol() );
	
	//init();
}

//------------------------------------------------
// initquote_date
//------------------------------------------------
void equity_option_vanilla.init()
{
	//error_info ee  	= error_info(true,true);
	
	check();
}

//------------------------------------------------
// check 
//------------------------------------------------
void equity_option_vanilla.check()
{							
	
}
//----------------------------------------------
// prem
//----------------------------------------------
number equity_option_vanilla.prem(opt_prem_type type, out number fwd_prem)
{
	
	number sp,fp;
	eq_opt_.prem(fp,  sp);

	switch(type){
	case opt_prem_type.UNIT:
		fwd_prem = fp;
		return sp;
	case opt_prem_type.PCNT:
		fwd_prem = fp/eq_opt_.args().f_*100.0;
		return sp/eq_opt_.args().s_*100.0;
	case opt_prem_type.AMNT:
		fwd_prem = fp * eq_opt_def_.contract_size();
		return sp * eq_opt_def_.contract_size();
	default:	
		QL_FAIL("premium type not supported");
	}
}
//------------------------------------------------
// quote
//------------------------------------------------
number 	equity_option_vanilla.quote(error_info option(nullable) error  )
{
	try {
		number q 		= eq_opt_.args().v_p_;
		option_qs_e qs 	= eq_opt_.args().qs_;
		
		switch(qs){
		case option_qs_e.PREM_F:
			QL_FAIL("invalid quote style");
			break;
		case option_qs_e.PREM_S:
			return eq_opt_def_.qs() == ..quote_style_eq_opt.PREM ? q : q/eq_opt_.args().s_*100.0;
			break;
		case option_qs_e.VOL:
			return eq_opt_def_.qs() == ..quote_style_eq_opt.VOL ? q : q*100.0;
			break;
		}
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "equity_option_vanilla.quote");
		return null<number>;
	}
}

//----------------------------------------------
// ttm_disc
//----------------------------------------------
number equity_option_vanilla.ttm_disc()
{
	return (delivery_ - settle_)/365.0;
}
//----------------------------------------------
// ttm_vol
//----------------------------------------------
number equity_option_vanilla.ttm_vol()
{
	return (expiry_ - trade_)/365.0;
}
//----------------------------------------------
// ttm
//----------------------------------------------
number equity_option_vanilla.ttm()
{
	return ttm_vol();
}

vanilla_option_eq_def	equity_option_vanilla.eq_opt_def() 	{ return eq_opt_def_;}
vanilla_option_eq		equity_option_vanilla.eq_opt() 		{ return eq_opt_;}

//----------------------------------------------
// exercise_type
//----------------------------------------------
exercise_type equity_option_vanilla.exercise_type()
{
	return eq_opt_.exercise_type();
}
//----------------------------------------------
// opt_type
//----------------------------------------------
opt_type equity_option_vanilla.opt_type()
{
	return eq_opt_.type();
}

//----------------------------------------------
// delta
//----------------------------------------------
number 	equity_option_vanilla.delta(eq_delta_type 	type,
									number 			mult,
									number 			d,								
									logical 		centered)
{
	switch(type){
	case eq_delta_type.SPOT:
		return eq_opt_.delta_spot(mult,d,centered);
	case eq_delta_type.SPOT_AMNT:
		return eq_opt_.delta_spot(mult,d,centered)/mult*eq_opt_.args().s_*eq_opt_def_.contract_size();		
	case eq_delta_type.FWD:
		return eq_opt_.delta_fwd(mult,d,centered);
	case eq_delta_type.FWD_AMNT:
		return eq_opt_.delta_fwd(mult,d,centered)/mult*eq_opt_.args().f_*eq_opt_def_.contract_size();
			
	default:	
		QL_FAIL("delta type not supported");
	}
}

//----------------------------------------------
// gamma
//----------------------------------------------
number 	equity_option_vanilla.gamma(eq_gamma_type 	type,
								number 			mult,
								number 			d,								
								logical 		centered)
{
	switch(type){
	case eq_gamma_type.SPOT:
		return eq_opt_.gamma_spot(mult,d,centered);
	case eq_gamma_type.FWD:
		return eq_opt_.gamma_fwd(mult,d,centered);
	case eq_gamma_type.SPOT_AMNT:
		return eq_opt_.gamma_spot(mult,d,centered)/mult*eq_opt_.args().s_*eq_opt_def_.contract_size();
	case eq_gamma_type.FWD_AMNT:
		return eq_opt_.gamma_fwd(mult,d,centered)/mult*eq_opt_.args().f_*eq_opt_def_.contract_size();
	default:	
		QL_FAIL("gamma type not supported");
	}
}

//----------------------------------------------
// vega
//----------------------------------------------
number 	equity_option_vanilla.vega(eq_vega_type 	type,
								number 			mult,
								number 			d,								
								logical 		centered)
{
	switch(type){
	case eq_vega_type.UNIT:
		return eq_opt_.vega(mult,d,centered);
	case eq_vega_type.AMNT:
		return eq_opt_.vega(mult,d,centered)/mult*eq_opt_.args().s_*eq_opt_def_.contract_size();
	default:	
		QL_FAIL("vega type not supported");
	}
}

//----------------------------------------------
// rho_dom
//----------------------------------------------
number equity_option_vanilla.rho(	eq_rho_type type,
									number mult,
									number d,								
									logical centered)
{
	switch(type){
	case eq_rho_type.UNIT:
		return eq_opt_.rho( mult, d,centered);
	case eq_rho_type.AMNT:
		return eq_opt_.rho( mult, d,centered)/mult*eq_opt_.args().s_*eq_opt_def_.contract_size();
	default:	
		QL_FAIL("rho type not supported");
	}
	
}

//----------------------------------------------
// theta
//----------------------------------------------
number equity_option_vanilla.theta(	eq_theta_type 	type,
									number 			mult,
									number 			d  )
{
	QL_FAIL_COND(eq_opt_.static(),"inapplicable function call for static instrument");
	if(d < 0)
		d = -d;

	number der,diff;
	switch(type){
	case eq_theta_type.BUS_DAY:
	{
		date next = eq_opt_def_.cal().move_bus_days(trade_,integer(d));
		der = eq_opt_.theta( mult, (next-trade_)/365.0, diff);		
		break;
	}
	case eq_theta_type.CAL_DAY:		
		der =  eq_opt_.theta( mult, d/365.0, diff);		
		break;
	default:	
		QL_FAIL("theta type not supported");
	}
	return diff;
}

integer	equity_option_vanilla.id(error_info option(nullable) error) 				{ return 0;}
string	equity_option_vanilla.name(error_info option(nullable) error) 				{ return name_;}
//date 	equity_option_vanilla.maturity(error_info option(nullable) error) 			{ return expiry_;}
string	equity_option_vanilla.currency(error_info option(nullable) error) 			{ return eq_opt_def_.ccy();}
calendar equity_option_vanilla.calendar(error_info option(nullable) error) 			{ return eq_opt_def_.cal();}
date 	equity_option_vanilla.expiry_date(error_info option(nullable) error)		{ return expiry_;}
date 	equity_option_vanilla.delivery_date(error_info option(nullable) error)		{ return delivery_;}
string equity_option_vanilla.settle_code(error_info option(nullable) error)			{ return eq_opt_def_.prem_settle_code();}
string equity_option_vanilla.deliv_settle_code(error_info option(nullable) error)	{ return eq_opt_def_.deliv_settle_code();}
quote_style_eq_opt	equity_option_vanilla.quote_style_eq_opt(error_info option(nullable) error) { return qs_;}

/*-----------------------------------------------------------------------
  is_valid
  ----------------------------------------------------------------------*/
logical equity_option_vanilla.is_valid(error_info option(nullable) error)
{	
	return !null(eq_opt_);
}

/*-----------------------------------------------------------------------
  is_expired
  ----------------------------------------------------------------------*/
logical equity_option_vanilla.is_expired(error_info option(nullable) error)
{	
	return trade_ > expiry_;
}

/*-----------------------------------------------------------------------
  trade_date
  ----------------------------------------------------------------------*/
date equity_option_vanilla.trade_date(error_info option(nullable) error)
{	
	return trade_;
}

/*-----------------------------------------------------------------------
  settle_date
  ----------------------------------------------------------------------*/
date equity_option_vanilla.settle_date(error_info option(nullable) error)
{	
	return settle_;
}