option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	fix float assetswap
	--------------------------------------------------------------------
*/


//----------------------------------------------------------------------
//  class swap_fixflt_asw
//----------------------------------------------------------------------
class swap_fixflt_asw: public instrument
option(category: "Instrument/Interest Rate Swap/Fixed vs Float ASW")
//option(allow_undeclared_mfuncs)
{
public:
	swap_fixflt_asw(string ,bond option(nullable),bond ,INSTR_TMPL.swap_fixflt_def_tmpl,
					number ,disc_func,fwd_func,number option(nullable),
					asw_type,number option(nullable) ,number option(nullable),
					number option(nullable) , number option(nullable) );
	
	swap_fixflt_asw(string ,bond option(nullable),bond,INSTR_TMPL.swap_fixflt_def_tmpl,
					number ,number option(nullable),number ,disc_func,disc_func,
					fwd_func,number option(nullable), asw_type,number option(nullable) ,number option(nullable),
					number option(nullable) , number option(nullable)  );//cross curr

	override instr_type 		instr_type(error_info option(nullable) error = null<error_info>);
//    override string				instr_type_s();
	override instrument 		inst();		
	override swap_fixflt_asw 	clone();
	
	override void               __dbg_print(__dbg_label);
    override void               __dbg_browse(__dbg_split);

	/*----------ADD FUNCS [PUBLIC]---------------*/	
	//void 						add_quote(number,..quote_style );//???i.e. means add new cpn --> should be a new instrument
	void 						add_quote(number);
	void 						add_quote(number,number);

	override number 			quote(error_info option(nullable) error = null<error_info>   );
	void 						quote(out number,out number,error_info option(nullable) error = null<error_info>   );
	
	override string 			name(error_info option(nullable) error = null<error_info>);
	bond 						bond_instr(error_info option(nullable) error = null<error_info>);
	bond 						bond_instr_start(error_info option(nullable) error = null<error_info>);
	swap_fixflt 				swap_instr(error_info option(nullable) error = null<error_info>);
	number 						accrued_adj(error_info option(nullable) error = null<error_info>);
	number 						premium_adj(error_info option(nullable) error = null<error_info>);
	number						investment(error_info option(nullable) error = null<error_info>);

	void  						cash_flow_dates(out vector(date) ,out vector(date) ,error_info option(nullable) error = null<error_info>) ;
	void  						cash_flows(	out vector(number) ,out vector(number) ,error_info option(nullable) error = null<error_info>) ;
	void  						cash_flows_net(	out vector(date) ,out vector(number) ,error_info option(nullable) error = null<error_info>) ;

	number 						delta_risk(	out number,
										out number,
										number option(nullable) delta_bond = 0.0001,
										number option(nullable) delta_disc_fix = 0.0001,
										number option(nullable) delta_disc_flt = 0.0001,
										number option(nullable) delta_fwd_flt = 0.0001,
										logical option(nullable) trade_date_pv = false,										
										error_info option(nullable) error = null<error_info>) ;

	void 						bond_sens(number, out number,out number,error_info option(nullable) error = null<error_info>);
	
	number						present_value(logical, out number,out number,out number,error_info option(nullable) error = null<error_info>);
	
	//bond
	number 						nominal_bond(error_info option(nullable) error = null<error_info> );
	void 						priced_instrument(number , out number ,error_info option(nullable) error = null<error_info>) ;
	//fix_leg
	number						upfront_fee_fix_leg(error_info option(nullable) error = null<error_info>);
	number						backend_fee_fix_leg(error_info option(nullable) error = null<error_info>);
	number						pv_backend_fee_fix_leg(error_info option(nullable) error = null<error_info>);
	number 						notional_fix_leg(error_info option(nullable) error = null<error_info> );
	//float_leg
	number						imp_spread(error_info option(nullable) error = null<error_info>);
	number						imp_spread(out number,out number,out number,out number,out number,error_info option(nullable) error = null<error_info>);
	number 						pv_flt_leg(number option(nullable) spread, error_info option(nullable) error = null<error_info> );
	number 						notional_flt_leg(error_info option(nullable) error = null<error_info> );
	
	number						fx_rate(error_info option(nullable) error = null<error_info> );
	number						fx_rate_orig(error_info option(nullable) error = null<error_info> );
	
	swap_fixflt_asw(swap_fixflt_asw);
protected:
	override __instrument 		i();
	void 						check();
	void 						init(asw_type,number option(nullable), number option(nullable));
	override swap_fixflt_asw 	create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);
	asset_swap_helper			asw();
	asset_swap_helper_ccy		asw_ccy();
	void						SWAP_ENTRY_FUNC();
	override number 			nominal(error_info option(nullable) error = null<error_info> );
	void 						ai_cp(bond, out number cp100, out number ai100 );
	
	string 					name_;
	bond					b_;	
	instr_def				fixflt_def_;
	ql_swap_fix_def 		fix_def_;
	ql_swap_float_def 		flt_def_;
	swap_fixflt 			sw_;
	number					bond_nominal_;
	disc_func 				disc_func_fix_;
	disc_func 				disc_func_flt_;	
	fwd_func  				flt_fwd_func_;	
	number  				curr_fixing_;
	number 					user_not_pcnt_;
	number					quote_spread_;	
	number 					fx_;	
	asset_swap_helper		asw_;
	logical 				ccy_swap_;
	number 					upfront_;
	number 					backend_;
	
	bond					b_orig_;
	number 					fx_orig_;
	number					quote_spread_orig_;	
	logical					is_orig_;
	//two bonds -->  one bond for the start position (orig) and one bond for the mark-to-market
};
//------------------------------------------------
// __dbg_print
//------------------------------------------------
void swap_fixflt_asw.__dbg_print(__dbg_label l)
{
	error_info ee 	= new error_info(true,false);
    l.set_text(strcat([
						"name: ",
						name(ee) ]));
}
//------------------------------------------------
// __dbg_browse
//------------------------------------------------
void swap_fixflt_asw.__dbg_browse(__dbg_split s)
{
    s.resize(1);
	error_info ee 	= new error_info(true,false);
    s.set_text(0, "name");
    s.set_value(0, this.name(ee));

}
/*-----------------------------------------------------------------------
  i
  ----------------------------------------------------------------------*/
__instrument swap_fixflt_asw.i() 	option(hidden)	option(com_name: 'INTERNAL_i')
{ 
	QL_FAIL(_na_func_msg, E_INIT);	//for now
	return instrument.i();	
}
//------------------------------------------------
// constructor single curr
//------------------------------------------------
swap_fixflt_asw.swap_fixflt_asw(string 							name,
								bond option(nullable)			b_orig,
								bond							b,								
								INSTR_TMPL.swap_fixflt_def_tmpl	tmpl,
								number 							nominal,
								disc_func 						disc_func,
								fwd_func  						flt_fwd_func,	
								number option(nullable) 		curr_fixing,								
								asw_type						type,
								number option(nullable) 		quote_spread_orig,
								number option(nullable) 		quote_spread ,
								number option(nullable) 		fund_sprd,
								number option(nullable) 		inv_sprd)
								: instrument(null(b_orig) ? b.i() : b_orig.i()),
								name_(name),b_(b), bond_nominal_(nominal), disc_func_fix_(disc_func),disc_func_flt_(disc_func),
								flt_fwd_func_(flt_fwd_func), curr_fixing_(curr_fixing),
								user_not_pcnt_(null<number>),quote_spread_(quote_spread), 
								fx_(null<number>), ccy_swap_(false), upfront_(null<number>),backend_(null<number>),
								b_orig_(null(b_orig) ? b : b_orig), fx_orig_(null<number>), quote_spread_orig_(quote_spread_orig),
								is_orig_(!null(b_orig))
{
	QL_FAIL_COND(tmpl.is_cross_curr(),"invalid fixflt template (this constructor requires a single currency template)");
	error_info ee  	= error_info(true,true);
	fixflt_def_ 	= instr_def_swap_fixflt(tmpl,ee);
	QL_FAIL_COND(null(fixflt_def_) || !fixflt_def_.is_valid(ee),"invalid fixflt template");

	init(type,fund_sprd,inv_sprd);
}
//------------------------------------------------
// constructor curr
// note:
// fx_rate:  [fixleg currency == base currency] and this should be the rate as of the settlement date(which is not necessarily equal to spot)
//------------------------------------------------
swap_fixflt_asw.swap_fixflt_asw(string 							name,
								bond option(nullable)			b_orig,
								bond							b,								
								INSTR_TMPL.swap_fixflt_def_tmpl	tmpl,
								number 							nominal,
								number 	option(nullable)		fx_rate_orig,
								number 							fx_rate,								
								disc_func 						disc_func_fix,
								disc_func 						disc_func_flt,	
								fwd_func  						flt_fwd_func,	
								number option(nullable) 		curr_fixing,								
								asw_type						type,
								number option(nullable) 		quote_spread_orig,
								number option(nullable) 		quote_spread,
								number option(nullable) 		fund_sprd,
								number option(nullable) 		inv_sprd)
								: instrument(null(b_orig) ? b.i() : b_orig.i()),
								name_(name),b_(b),bond_nominal_(nominal), disc_func_fix_(disc_func_fix),disc_func_flt_(disc_func_flt),
								flt_fwd_func_(flt_fwd_func), curr_fixing_(curr_fixing),
								user_not_pcnt_(null<number>),quote_spread_(quote_spread),
								fx_(fx_rate),  ccy_swap_(true),upfront_(null<number>),backend_(null<number>),
								b_orig_(null(b_orig) ? b : b_orig),fx_orig_(fx_rate_orig), quote_spread_orig_(quote_spread_orig),
								is_orig_(!null(b_orig))
{	
	QL_FAIL_COND(!tmpl.is_cross_curr(),"invalid fixflt template (this constructor requires a cross currency template)");
	error_info ee  	= error_info(true,true);
	fixflt_def_ 	= instr_def_swap_fixflt(tmpl,ee);
	QL_FAIL_COND(null(fixflt_def_) || !fixflt_def_.is_valid(ee),"invalid fixflt template");
	
	init(type,fund_sprd,inv_sprd);
}
//------------------------------------------------
// ai_cp
//------------------------------------------------
void swap_fixflt_asw.ai_cp(bond b, out number cp100, out number ai100 )
{
	error_info ee  	= error_info(true,false);
	number dp 		= b.dirty_price(null<number>, false,false,ee);
	CORE_INT.instr_fail_check(null(dp), "invalid dirty price (as of settle date)",b.name(),ee);

	cp100 			= b.clean_price(false,true,ee);
	CORE_INT.instr_fail_check(null(cp100), "invalid clean price (as of settle date)",b.name(),ee);
	
	ai100 			= dp/bond_nominal_*100.0 - cp100;
	CORE_INT.instr_fail_check(null(ai100), "invalid accrued (as of settle date)",b.name(),ee);
					
}
//------------------------------------------------
// init
//------------------------------------------------
void swap_fixflt_asw.init(asw_type type,number option(nullable) fund_sprd, number option(nullable) inv_sprd)
{
	error_info ee  	= error_info(true,true);
	check();
	
	date td 		= b_.trade_date(ee);
	date sd 		= b_.settle_date(ee);		

	if(b_.nominal(ee) != bond_nominal_)
		b_.add_nominal(bond_nominal_);

	date start_date;
	if(is_orig_) {
		start_date	= b_orig_.settle_date(ee);
		
		if(b_orig_.nominal(ee) != bond_nominal_)
			b_orig_.add_nominal(bond_nominal_);
	}
	else {
		start_date	= sd ;
	}
	
	QL_REQUIRE(start_date <= sd,"invalid start date (must not be a forward date)");//for now
	if(start_date < sd){
		QL_FAIL_COND(null(quote_spread_orig_),"invalid quote spread (as of start date)");
		QL_FAIL_COND(ccy_swap_ && null(fx_orig_),"invalid fx rate (as of start date)");
	}
	else if(start_date >= sd){		
		if(null(quote_spread_orig_))
			quote_spread_orig_ = quote_spread_;
		if(null(fx_orig_))
			fx_orig_ = fx_;		
	}
	
	notional_exchg_style ne = ccy_swap_? notional_exchg_style.NE_BOTH: notional_exchg_style.NE_NONE;
	
	..coupon_freq  fix_freq = coupon_freq_from_int(b_.coupon_freq(ee))  ;
	date_code	settle_code	= date_code(b_.settle_code(ee));
	fix_def_  				= ql_swap_fix_def(	"fix_def", b_.currency(ee), settle_code,
												fix_freq,b_.accr_dc_method(ee),fix_roll_method.FIR_STRAIGHT,
												b_.pmt_bus_day(ee),b_.calendar(ee),b_.eom(ee),true,fix_comp_freq.FCF_AS_FREQ,
												null<..quote_style>,null<round_code>,null<logical>,null<logical>,
												null<interest_rule>,0,0,0,0,ne,null<logical>,false);

	QL_FAIL_COND(null(fix_def_),"invalid fixed leg (def)");

	..coupon_freq  flt_freq = coupon_freq_from_int(fixflt_def_.swap_coupon_freq_leg2(ee))  ;
	..ir_index flt_ir_index = fixflt_def_.swap_ir_index_leg2(ee);		
	flt_def_ 				= ql_swap_float_def("float_def",fixflt_def_.swap_currency_leg2(ee),settle_code,flt_freq,
												null<reset_freq>,fixflt_def_.swap_dc_method_leg2(ee),fixflt_def_.swap_pmt_bus_day_leg2(ee),
												fixflt_def_.swap_calendar_leg2(ee),fixflt_def_.swap_eom_leg2(ee),null<flt_comp_avg_type>,
												null<flt_sprd_comp_method>,null<flt_avg_method>,
												null<flt_stub_fwd_style>,flt_ir_index,flt_reset_style.RS_NORM,ne);

	QL_FAIL_COND(null(flt_def_),"invalid float leg (def)");

	number cp100, ai100;
	ai_cp(b_, cp100, ai100 );
	
	tenor_surface flt_ts 	= tenor_surface(td, disc_func_flt_,[flt_fwd_func_],[flt_ir_index],false);
	
	vector(date) bond_dates;
	vector(number) bond_cpns100;
	ql_fix_leg 	fix;
	ql_float_leg flt;
	ql_fixed_income_swap sw;
	if(is_orig_) {
		//here we have two bonds, one bond for the start position (orig) and one bond for the mark-to-market

		number cp100_orig, ai100_orig;
		ai_cp(b_orig_, cp100_orig, ai100_orig );
				
		b_orig_.cash_flow_data(100,true,ir_cf_code.COUPON, true, false,bond_dates,bond_cpns100,ee);
		integer size = v_size(bond_dates);
		QL_FAIL_COND(size < 1, "invalid bond date vector (as of start date)", E_INIT);

		CORE_INT.fixflt_asw_helper(	td,sd, start_date,is_orig_,bond_nominal_,b_orig_.maturity_adj(ee), b_orig_.last_reg_cpn_date_adj(ee),
									b_orig_.next_cpn_date_adj(ee), bond_dates,bond_cpns100,
									b_orig_.roll_day(ee), ai100, cp100, ai100_orig, cp100_orig,fix_def_, flt_def_, flt_ts, fx_, fx_orig_,
									quote_spread_, quote_spread_orig_, disc_func_fix_,
									disc_func_flt_,	 flt_fwd_func_, curr_fixing_, type, name_, upfront_,backend_,fix, flt,sw);
	}
	else {

		b_.cash_flow_data(100,true,ir_cf_code.COUPON, true, false,bond_dates,bond_cpns100,ee);
		integer size = v_size(bond_dates);
		QL_FAIL_COND(size < 1, "invalid bond date vector (as of settle date)", E_INIT);

		CORE_INT.fixflt_asw_helper(	td,sd, start_date,is_orig_,bond_nominal_,b_.maturity_adj(ee), b_.last_reg_cpn_date_adj(ee),
									b_.next_cpn_date_adj(ee), bond_dates,bond_cpns100,
									b_.roll_day(ee), ai100, cp100, null<number>, null<number>,fix_def_, flt_def_, flt_ts, fx_, null<number>,
									quote_spread_, null<number>, disc_func_fix_,
									disc_func_flt_,	 flt_fwd_func_, curr_fixing_, type, name_, upfront_,backend_,fix, flt,sw);
	}

	swap_flt_leg_data flt_data 			= new swap_flt_leg_data(flt,false);			
	vector(date) 	flt_pmt_dates 		= flt_data.pmt_date_ir(sd , cut_off_type.PMT_DATE_IR_FWD );	
	vector(number) 	flt_rates 			= flt_data.fix_rate(sd , cut_off_type.PMT_DATE_IR_FWD );
	vector(number) 	flt_accr_periods 	= flt_data.accr_per(sd , cut_off_type.PMT_DATE_IR_FWD );

	//asw calc
	//number	fund_sprd 	= 0;
	//number	inv_sprd 	= 0;
		
	if(ccy_swap_) {
		asset_swap_helper_ccy aswc 	= new asset_swap_helper_ccy (type,td, sd, cp100, ai100,bond_nominal_,fx_,
																 disc_func_fix_,disc_func_flt_, fund_sprd,  inv_sprd,
																 bond_dates,bond_cpns100, flt_pmt_dates, flt_accr_periods, flt_rates);
		asw_ = aswc;
		
	}
	else {
		asw_ = new asset_swap_helper (	type,td, sd, cp100, ai100,bond_nominal_,disc_func_flt_, fund_sprd,  inv_sprd,
										bond_dates,bond_cpns100, flt_pmt_dates, flt_accr_periods, flt_rates);
	}

	number q = null<number>;
	if(start_date == sd){
		q = is_orig_  ? quote_spread_orig_ : quote_spread_;
	}
	
	if(start_date == sd && null(q)) {				
		number flt_s	= asw_.spread();//sw.solver(0,swap_solver_code.SS_FLT_SPRD_LEG1,false);
		QL_FAIL_COND(null(flt_s),"error solving for spread", E_INIT);

		date  flt_first_cpn_date 	= null<date>;
		date  flt_last_reg_date 	= null<date>;
		date flt_eff_date 			= start_date;
		number swap_nom				= notional_flt_leg(ee);
		number flt_nominal 			= swap_nom;//ccy_swap_? swap_nom * fx_ : swap_nom;
		logical pay_fixed 			= true;
		number flt_fixing_start_stub = null;
		number flt_start_stub_sprd = null;
		number flt_fixing_end_stub = null;
		number flt_end_stub_sprd = null;
		number flt_comp_spread = null;
		flt  = ql_float_leg(flt_def_,"float_leg",td,sd,start_date,b_.maturity_adj(ee),null<tenor_code>,
							!pay_fixed,flt_nominal,flt_eff_date,flt_first_cpn_date,flt_last_reg_date,flt_s,disc_func_flt_,	
							flt_ts,b_.roll_day(ee),1,null<vector(date)>,null<vector(number)>,curr_fixing_,false,
							flt_fixing_start_stub,flt_start_stub_sprd,flt_fixing_end_stub,flt_end_stub_sprd,flt_comp_spread);
		
		sw = ql_fixed_income_swap(fix,flt,name_);		
	}

	sw_ = create_swap_fixflt(__instrument_swap(sw), ee);		
	QL_FAIL_COND(null(sw_),"invalid swap");
}


//------------------------------------------------
// check 
//------------------------------------------------
void swap_fixflt_asw.check()
{							
	QL_FAIL_COND(ccy_swap_ && !fixflt_def_.is_ccy_swap(),"invalid fixflt swap (should be cross currency)");

	error_info ee 	= error_info(true,true);
	string b_ccy 	= b_.currency(ee);
	string fix_ccy 	= fixflt_def_.swap_currency_leg1(ee);
	QL_FAIL_COND(!equal_casei(b_ccy,fix_ccy),"bond currency does not match currency of fixed leg");

	if(is_orig_) {
		QL_FAIL_COND(b_orig_.name(ee) != b_.name(ee),"original bond and current bond must be the same bond");
		
	}
}

//------------------------------------------------
// copy constructor
//------------------------------------------------
swap_fixflt_asw.swap_fixflt_asw(swap_fixflt_asw c)
						: instrument(c),
						name_(c.name_),b_(c.b_),fixflt_def_(c.fixflt_def_),fix_def_(c.fix_def_),flt_def_(c.flt_def_),
						//fix_(c.fix_),flt_(c.flt_),
						sw_(c.sw_),bond_nominal_(c.bond_nominal_),disc_func_fix_(c.disc_func_fix_),disc_func_flt_(c.disc_func_flt_),	
						flt_fwd_func_(c.flt_fwd_func_),curr_fixing_(c.curr_fixing_),user_not_pcnt_(c.user_not_pcnt_),
						quote_spread_(c.quote_spread_),
						fx_(c.fx_),asw_(c.asw_), ccy_swap_(c.ccy_swap_),upfront_(c.upfront_), backend_(c.backend_),
						b_orig_(c.b_orig_),fx_orig_(c.fx_orig_),quote_spread_orig_(c.quote_spread_orig_)
{}

//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string 		swap_fixflt_asw.instr_type_s() 		{ return string(..instr_type.SWAP_FIX_FLT_ASW);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	swap_fixflt_asw.inst()				{ return this;}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
swap_fixflt_asw swap_fixflt_asw(swap_fixflt_asw b)		{ return new swap_fixflt_asw(b);}
//------------------------------------------------
// clone
//------------------------------------------------
swap_fixflt_asw swap_fixflt_asw.clone() 				{ return new swap_fixflt_asw(this);}

//------------------------------------------------
// create  [PROTECTED]
//------------------------------------------------
swap_fixflt_asw swap_fixflt_asw.create(	__instrument option(nullable) c,
										out instr_error option(nullable) error,
										error_type type )
{
	QL_FAIL("invalid function call");
}

/*-----------------------------------------------------------------------
  instr_type
  ----------------------------------------------------------------------*/
instr_type swap_fixflt_asw.instr_type(error_info option(nullable) ) { return ..instr_type.SWAP_FIX_FLT_ASW; }
/*-----------------------------------------------------------------------
  ENTRY_FUNC prot
  ----------------------------------------------------------------------*/
void	swap_fixflt_asw.SWAP_ENTRY_FUNC()
{
	/*if(!null(full_swap_) && full_swap_)
		return;
	error_info ee = new error_info(true,true);
	full_swap_ = check_full_swap(full_swap_, ee) ;	*/
}
/*-----------------------------------------------------------------------
  add_quote		
  ----------------------------------------------------------------------*/
void swap_fixflt_asw.add_quote(	number  quote_spread ) 
{	
	quote_spread_ = quote_spread;
	return ;						
}
/*-----------------------------------------------------------------------
  add_quote		
  ----------------------------------------------------------------------*/
void swap_fixflt_asw.add_quote(	number  quote_spread, number  quote_bond ) 
{
	error_info ee = error_info(true,true);
	add_quote(quote_spread );
	b_ = b_.set_quote(quote_bond,ee);
	return ;						
}

/*-----------------------------------------------------------------------
  quote   
  ----------------------------------------------------------------------*/
number  swap_fixflt_asw.quote(error_info option(nullable) error)
{	
	return quote_spread_;
}

/*-----------------------------------------------------------------------
  quote   
  ----------------------------------------------------------------------*/
void  swap_fixflt_asw.quote(out number quote_spread,
							out number bond_quote,
							error_info option(nullable) error)
{	
	quote_spread 	= quote_spread_;
	bond_quote 		= b_.quote(error);
}
/*-----------------------------------------------------------------------
  fx_rate   
  ----------------------------------------------------------------------*/
number  swap_fixflt_asw.fx_rate(error_info option(nullable) error)
{	
	return null(fx_) && !ccy_swap_ ? 1 : fx_;
}

/*-----------------------------------------------------------------------
  fx_rate_orig   
  ----------------------------------------------------------------------*/
number  swap_fixflt_asw.fx_rate_orig(error_info option(nullable) error)
{	
	return null(fx_orig_) && !ccy_swap_ ? 1 : fx_orig_;
}

/*-----------------------------------------------------------------------
  bond_instr
  ----------------------------------------------------------------------*/
bond swap_fixflt_asw.bond_instr(error_info option(nullable) error )
{
	return b_;
}
/*-----------------------------------------------------------------------
  bond_instr_start
  ----------------------------------------------------------------------*/
bond swap_fixflt_asw.bond_instr_start(error_info option(nullable) error )
{
	return b_orig_;
}
/*-----------------------------------------------------------------------
  name
  ----------------------------------------------------------------------*/
string 	swap_fixflt_asw.name(error_info option(nullable) error )
{
	return name_;
}

/*-----------------------------------------------------------------------
  swap_instrument
  ----------------------------------------------------------------------*/
swap_fixflt swap_fixflt_asw.swap_instr(error_info option(nullable) error )
{
	return sw_;
}

/*-----------------------------------------------------------------------
  imp_spread
  ----------------------------------------------------------------------*/
number swap_fixflt_asw.imp_spread(error_info option(nullable) error )
{

	//number flt_s	= sw_.solver(0,swap_solver_code.SS_FLT_SPRD_LEG1,false);

	return asw_.spread();
}

/*-----------------------------------------------------------------------
  imp_spread
  ----------------------------------------------------------------------*/
number swap_fixflt_asw.imp_spread(out number spread_upfront,
								  out number spread_backend,
								  out number spread_swap,
								  out number spread_accrued,
								  out number spread_premium,
								  error_info option(nullable) error )
{
	spread_upfront 	= asw_.spread_upfront();
	spread_backend 	= asw_.spread_backend();
	spread_swap		= asw_.spread_swap();
	spread_accrued	= asw_.spread_accrued();
	spread_premium	= asw_.spread_premium();
	return asw_.spread();
}

/*-----------------------------------------------------------------------
  notional_flt_leg
  ----------------------------------------------------------------------*/
number swap_fixflt_asw.notional_flt_leg(error_info option(nullable) error )
{
	return asw_.notional_float();
}
/*-----------------------------------------------------------------------
  notional_fix_leg
  ----------------------------------------------------------------------*/
number swap_fixflt_asw.notional_fix_leg(error_info option(nullable) error )
{
	return asw_.notional_fixed();
}
/*-----------------------------------------------------------------------
  nominal_bond
  ----------------------------------------------------------------------*/
number swap_fixflt_asw.nominal_bond(error_info option(nullable) error )
{
	return this.notional_fix_leg(error);
}
/*-----------------------------------------------------------------------
  nominal
  ----------------------------------------------------------------------*/
number swap_fixflt_asw.nominal(error_info option(nullable) error )
{
	return this.notional_fix_leg(error);
}
/*-----------------------------------------------------------------------
  pv_flt_leg
  ----------------------------------------------------------------------*/
number swap_fixflt_asw.pv_flt_leg(number option(nullable) spread, error_info option(nullable) error )
{
	if(null(spread))
		spread = quote_spread_;
	return asw_.pv_float(spread);
}
/*-----------------------------------------------------------------------
  investment
  ----------------------------------------------------------------------*/
number swap_fixflt_asw.investment(error_info option(nullable) error)
{
	try{

		error_info ee = new error_info(true,true);
		number dp100 	= b_orig_.dirty_price(null<number>,false,true,ee);
		number pv_bond 	= dp100/100*bond_nominal_;
		
		if(ccy_swap_) {				
			
			return (pv_bond - upfront_) * fx_rate_orig() ;
		}
		else {
			
			return pv_bond - upfront_;//rounding errors?
		}
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_asw.investment");
		return null<number>;
	}
}
/*
	Event 						Swap 						Bond 					Net
	
	Payments 					Pay fixed coupon;			Receive coupons 
								receive Libor plus 			and par redemption
								asset swap spread
						
	Swap rates increase 		Present value of 			Bond price 				Small increase due
	(Libor spread constant) 	swap increases 				decreases 				to larger PV01 of swap
	
	Swap rates fall (Libor 		Present value of 			Bond price 				Small decrease due
	spread constant) 			swap decreases 				increases 				to larger PV01 of swap
	
	Libor spread increases 		No change 					Bond price 				Decrease proportional
	(swap rates constant) 									falls 					to PV01 of bond
	
	Libor spread falls (swap 	No change 					Bond price 				Increase proportional to
	rates constant) 										increases 				PV01 of bond
 */
/*-----------------------------------------------------------------------
  bond_y_sens
  ----------------------------------------------------------------------*/

void swap_fixflt_asw.bond_sens(	number delta_asw_sprd,
								out number y_diff,
								out number dp_diff,
								error_info option(nullable) error)
{
	try{

		//QL_REQUIRE(!ccy_swap_,"work in progress");
		
		error_info ee = new error_info(true,true);

		number sprd = null(quote_spread_) ? asw_.spread() : quote_spread_;
		
		number imp_dp100;
		priced_instrument(sprd, imp_dp100) ;
		bond bnd_imp 	= b_.set_dirty_price(imp_dp100,null<date>, null<date>,ee);
		number imp_y	= bnd_imp.yield(false,ee);

		priced_instrument(sprd+delta_asw_sprd, imp_dp100) ;
		bond bnd_imp_d 	= b_.set_dirty_price(imp_dp100,null<date>, null<date>,ee);
		number imp_y_d	= bnd_imp_d.yield(false,ee);

		y_diff 	= imp_y_d-imp_y;
		dp_diff = b_.dirty_price_diff(y_diff,bond_nominal_,null<date> , false, ee) ;

		return ;		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_asw.bond_sens");
		return ;
	}
}
/*-----------------------------------------------------------------------
  delta_risk
  ----------------------------------------------------------------------*/
number swap_fixflt_asw.delta_risk(out number delta_risk_bond,
							out number delta_risk_swap,
							number option(nullable) delta_bond ,
							number option(nullable) delta_disc_fix,
							number option(nullable) delta_disc_flt ,
							number option(nullable) delta_fwd_flt ,
							logical option(nullable) trade_date_pv ,
							
							error_info option(nullable) error)
{
	try{

		//QL_REQUIRE(!ccy_swap_,"work in progress");
		
		error_info ee = new error_info(true,true);

		delta_risk_bond = b_.dirty_price_diff(delta_bond,bond_nominal_,null<date> , false, ee) ;

		if(ccy_swap_)
			delta_risk_bond		*= fx_;

		logical leg_indep_shift = false;
		number pv, pvdiff_fix_leg,  pvdiff_flt_leg;
		delta_risk_swap = sw_.pvdiff_curve_shift(delta_disc_fix, 
												delta_disc_flt,//not used for single ccy swaps	
												delta_fwd_flt,
												trade_date_pv,leg_indep_shift,
												pv, pvdiff_fix_leg, pvdiff_flt_leg,ee) ;
		return delta_risk_bond+delta_risk_swap;
		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_asw.investment");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  present_value
  ----------------------------------------------------------------------*/
number	swap_fixflt_asw.present_value(logical incl_upfront,
									  out number npv_fix,
									  out number npv_flt,
									  out number npv_bond,
									  error_info option(nullable) error )
{
	try{

		//QL_REQUIRE(!ccy_swap_,"work in progress");
		
		error_info ee 		= new error_info(true,true);
		date swap_settle	= sw_.settle_date(ee);
		number npv 			= sw_.present_value(null<disc_func>, null<disc_func>,npv_fix,npv_flt,
												swap_settle, swap_settle,incl_upfront,true,ee);
		npv_bond			= b_.dirty_price(null<number>,false,true,ee)/100.0*bond_nominal_;
		if(ccy_swap_)
			npv_bond		*= fx_;
		number tot			= npv + npv_bond;
		return  tot;
		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_asw.present_value");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  asw
  ----------------------------------------------------------------------*/
asset_swap_helper swap_fixflt_asw.asw()
{
	return asw_;
}
/*-----------------------------------------------------------------------
  asw_ccy
  ----------------------------------------------------------------------*/
asset_swap_helper_ccy swap_fixflt_asw.asw_ccy()
{
	if(ccy_swap_)
		return dynamic_cast<asset_swap_helper_ccy>(asw_);
	else
		return null<asset_swap_helper_ccy>;
}
	
/*-----------------------------------------------------------------------
  upfront_fee_fix_leg
  ----------------------------------------------------------------------*/
number swap_fixflt_asw.upfront_fee_fix_leg(error_info option(nullable) error )
{	
	number upfront_fix;
	if(ccy_swap_) {		
		number u;
		asw_ccy().upfront(upfront_fix, u);		
	}
	else {
		upfront_fix = asw_.upfront();
	}

	return upfront_fix;
}
/*-----------------------------------------------------------------------
  backend_fee_fix_leg
  ----------------------------------------------------------------------*/
number swap_fixflt_asw.backend_fee_fix_leg(error_info option(nullable) error )
{	
	number backend_fix;
	if(ccy_swap_) {
		number b;
		asw_ccy().backend(backend_fix, b);		
	}
	else {
		backend_fix = asw_.backend();
	}
	return backend_fix;
}
/*-----------------------------------------------------------------------
  pv_backend_fee_fix_leg
  ----------------------------------------------------------------------*/
number swap_fixflt_asw.pv_backend_fee_fix_leg(error_info option(nullable) error )
{	
	number backend_fix;
	if(ccy_swap_) {
		number b;
		asw_ccy().pv_backend(backend_fix, b);		
	}
	else {
		backend_fix = asw_.pv_backend();
	}
	return backend_fix;
}
/*-----------------------------------------------------------------------
  accrued_adj
  ----------------------------------------------------------------------*/
number swap_fixflt_asw.accrued_adj(error_info option(nullable) error )
{
	return asw_.accrued_adj();
}
/*-----------------------------------------------------------------------
  premium_adj
  ----------------------------------------------------------------------*/
number swap_fixflt_asw.premium_adj(error_info option(nullable) error )
{
	return asw_.premium_adj();
}

/*-----------------------------------------------------------------------
  cash_flow_dates	
  ----------------------------------------------------------------------*/
void  swap_fixflt_asw.cash_flow_dates(	out vector(date) 	pmt_dates_fix_leg,									
										out vector(date) 	pmt_dates_flt_leg,
										error_info option(nullable) error ) 
{	
	try{

		error_info ee = new error_info(true,true);
		swap_flt_leg_data flt_data;
		swap_fix_leg_data fix_data;		
		sw_.data(fix_data,flt_data,ee);
		pmt_dates_fix_leg	= fix_data.pmt_date_ir(null<date> , cut_off_type.ALL );
		pmt_dates_flt_leg	= flt_data.pmt_date_ir(null<date> , cut_off_type.ALL );
			
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_asw.cash_flow_dates");
		pmt_dates_fix_leg = pmt_dates_flt_leg = null<vector(date)>; 
		return ;
	}
}

/*-----------------------------------------------------------------------
  cash_flows	
  ----------------------------------------------------------------------*/
void  swap_fixflt_asw.cash_flows(	out vector(number) 	cf_fix_leg,									
									out vector(number) 	cf_flt_leg,
									error_info option(nullable) error ) 
{	
	try{

		error_info ee = new error_info(true,true);
		swap_flt_leg_data flt_data;
		swap_fix_leg_data fix_data;		
		sw_.data(fix_data,flt_data,ee);
		cf_fix_leg	= fix_data.cf(null<date> ,cut_off_type.ALL );
		cf_flt_leg	= flt_data.cf(null<date> , cut_off_type.ALL );

		if(ccy_swap_) {
			vector(number) p_fix_leg	= fix_data.cf_prin(null<date> ,cut_off_type.ALL );
			cf_fix_leg[0] += p_fix_leg[0]; 
			cf_fix_leg[v_size(cf_fix_leg)-1] += p_fix_leg[1];
				
			vector(number) p_flt_leg	= flt_data.cf_prin(null<date> , cut_off_type.ALL );
			cf_flt_leg[0] += p_flt_leg[0]; 
			cf_flt_leg[v_size(cf_flt_leg)-1] += p_flt_leg[1];
		}
		
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_asw.cash_flow_dates");
		cf_fix_leg = cf_flt_leg = null<vector(number)>; 
		return ;
	}
}

/*-----------------------------------------------------------------------
  cash_flows	
  ----------------------------------------------------------------------*/
void  swap_fixflt_asw.cash_flows_net(out vector(date) 	cf_date,									
									out vector(number) 	cf,
									error_info option(nullable) error ) 
{
	try{

		error_info ee = new error_info(true,true);
		swap_flt_leg_data flt_data;
		swap_fix_leg_data fix_data;		
		sw_.data(fix_data,flt_data,ee);
		
		vector(number) cf_fix_leg	= fix_data.cf(null<date> ,cut_off_type.ALL );
		vector(number) cf_flt_leg	= flt_data.cf(null<date> , cut_off_type.ALL );

		if(ccy_swap_) {
			vector(number) p_fix_leg	= fix_data.cf_prin(null<date> ,cut_off_type.ALL );
			cf_fix_leg[0] += p_fix_leg[0]; 
			cf_fix_leg[v_size(cf_fix_leg)-1] += p_fix_leg[1];
				
			vector(number) p_flt_leg	= flt_data.cf_prin(null<date> , cut_off_type.ALL );
			cf_flt_leg[0] += p_flt_leg[0]; 
			cf_flt_leg[v_size(cf_flt_leg)-1] += p_flt_leg[1];
		}
		
		vector(number) 	cf_bond 	= b_.cash_flows(bond_nominal_,true,false,ee);
		number dp100 				= b_.dirty_price(null<number>,false,true,ee);

		integer s_b 		= v_size(cf_bond);
		integer s_fix 		= v_size(cf_fix_leg);
		integer s_flt 		= v_size(cf_flt_leg);
		cf_flt_leg[0] 		-= (dp100/100.0 * bond_nominal_ - cf_fix_leg[0] )*fx_rate();
		cf_flt_leg[s_flt-1] += (cf_bond[s_b-1] + cf_fix_leg[s_fix-1])*fx_rate();

		cf_date				= flt_data.pmt_date_ir(null<date> , cut_off_type.ALL );
		cf 					= cf_flt_leg;
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_asw.cash_flows_net");
		cf = null<vector(number)>;
		cf_date  = null<vector(date)>; 
		return ;
	}
}

//---------------------------------------
// priced_instrument
//---------------------------------------
void swap_fixflt_asw.priced_instrument(	number spread,
										out number dp100,
										error_info option(nullable) error)
{
	try{

		asw_.priced_instrument(spread,dp100);
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_asw.priced_instrument");
		dp100 = null<number>;
		return ;
	}
}