option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	fix ois assetswap
	--------------------------------------------------------------------
*/

//----------------------------------------------------------------------
//  class swap_fixflt_asw
//----------------------------------------------------------------------
class swap_fixois_asw: public instrument
option(category: "Instrument/Interest Rate Swap/Fixed vs ONIndex ASW")
//option(allow_undeclared_mfuncs)
{
public:
	//swap_fixois_asw(string ,bond,INSTR_TMPL.swap_fixois_def_tmpl,number option(nullable),disc_func,disc_func,number option(nullable),asw_type );
	override instr_type 		instr_type(error_info option(nullable) error = null<error_info>);
    //override string				instr_type_s();
	override instrument 		inst();		
	override swap_fixois_asw 	clone();
	
	override void               __dbg_print(__dbg_label);
    override void              	__dbg_browse(__dbg_split);

	override string 			name(error_info option(nullable) error = null<error_info>);

	swap_fixois_asw(swap_fixois_asw);
protected:
	override 					__instrument i();
	void 						check();
	override swap_fixois_asw 	create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);//pure virtual
	void						SWAP_ENTRY_FUNC();
	
	string 					name_;
	bond					b_;								
	instr_def				fixois_def_;
	ql_swap_fix_def 		fix_def_;
	ql_swap_ois_def 		ois_def_;
	ql_fix_leg 				fix_;
	ql_ois_leg 				ois_;
	ql_fixed_income_swap 	sw_;
	number					bond_nominal_;
	disc_func 				disc_func_;									
	disc_func  				flt_fwd_disc_func_;		
	number 					user_not_pcnt_;	
	asset_swap_helper		asw_;
};

//------------------------------------------------
// __dbg_print
//------------------------------------------------
void swap_fixois_asw.__dbg_print(__dbg_label l)
{
	error_info ee 	= new error_info(true,false);
    l.set_text(strcat([
						"name: ",
						name(ee) ]));
}
//------------------------------------------------
// __dbg_browse
//------------------------------------------------
void swap_fixois_asw.__dbg_browse(__dbg_split s)
{
    s.resize(1);
	error_info ee 	= new error_info(true,false);
    s.set_text(0, "name");
    s.set_value(0, this.name(ee));

}
/*-----------------------------------------------------------------------
  i
  ----------------------------------------------------------------------*/
__instrument swap_fixois_asw.i() 	option(hidden)	option(com_name: 'INTERNAL_i')
{ 
	QL_FAIL(_na_func_msg, E_INIT);	//for now
	return instrument.i();
}
//------------------------------------------------
// copy constructor
//------------------------------------------------
swap_fixois_asw.swap_fixois_asw(swap_fixois_asw c)
						: instrument(c)
{}

//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string 		swap_fixois_asw.instr_type_s() 		{ return string(..instr_type.SWAP_FIX_OIS_ASW);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	swap_fixois_asw.inst()				{ return this;}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
swap_fixois_asw swap_fixois_asw(swap_fixois_asw b)			{ return new swap_fixois_asw(b);}
//------------------------------------------------
// clone
//------------------------------------------------
swap_fixois_asw swap_fixois_asw.clone() 		{ return new swap_fixois_asw(this);}

//------------------------------------------------
// create  [PROTECTED]
//------------------------------------------------
swap_fixois_asw swap_fixois_asw.create(	__instrument option(nullable) c,
										out instr_error option(nullable) error,
										error_type type )
{
	QL_FAIL("invalid function call");
}

/*-----------------------------------------------------------------------
  instr_type
  ----------------------------------------------------------------------*/
instr_type swap_fixois_asw.instr_type(error_info option(nullable) ) { return ..instr_type.SWAP_FIX_OIS_ASW; }

/*-----------------------------------------------------------------------
  ENTRY_FUNC prot
  ----------------------------------------------------------------------*/
void	swap_fixois_asw.SWAP_ENTRY_FUNC()
{
	/*if(!null(full_swap_) && full_swap_)
		return;
	error_info ee = new error_info(true,true);
	full_swap_ = check_full_swap(full_swap_, ee) ;*/	
}
/*-----------------------------------------------------------------------
  name
  ----------------------------------------------------------------------*/
string 	swap_fixois_asw.name(error_info option(nullable) error )
{
	return name_;
}

//------------------------------------------------
// check 
//------------------------------------------------
void swap_fixois_asw.check()
{
	error_info ee 				= error_info(true,true);
	string curr 				= b_.currency(ee);
	logical is_ccy				= fixois_def_.is_ccy_swap();						
	QL_FAIL_COND(is_ccy,"constructor not applicable for currency swaps");
	string c1 = fixois_def_.swap_currency_leg1(ee);
	QL_FAIL_COND(!equal_casei(curr,c1),"bond currency does not match currency of fixed leg");

}