/*	
	instr_def wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	

module CORE_INT
{
	logical is_idx_link(..instr_type type, logical incl_swap) 
	{
		switch(type){   
		case ..instr_type.IL_REAL_BILL:
		case ..instr_type.IL_REAL_FIXED_CPN_BOND:
		case ..instr_type.IL_REAL_ZERO_CPN_BOND:
			return true;
		case ..instr_type.IL_SWAP_REAL_FIXFLT:
		case ..instr_type.IL_SWAP_REAL_FIXOIS:
		case ..instr_type.IL_SWAP_FIX_Y_Y:
		case ..instr_type.IL_SWAP_FLT_Y_Y:
		case ..instr_type.IL_SWAP_OIS_Y_Y:
		case ..instr_type.IL_SWAP_ZERO:
			return incl_swap;		
		default:
			return false;
		}
	}
}
//***----------INSTR_DEF MEMBERS-----------***
instr_type instr_def.instr_type()  option(com_name: 'instr_type_f')
{
	..__instr_type t = this.__instr_type();
	string s = string(t);	
	return instr_type_map(s) ;
}
/*-----------------------------------------------------------------------
  instr_def: is_xxx  
  ----------------------------------------------------------------------*/
logical instr_def.is_inflation_linked() option(hidden)
{
	..instr_type type = this.instr_type();
	return CORE_INT.is_idx_link( type, true) ;
}

logical instr_def.is_il_bond() 	option(hidden)				{ return this.instr_type() == ..instr_type.IL_REAL_FIXED_CPN_BOND;}
logical instr_def.is_il_fix_cpn_bond() 	option(hidden)		{ return this.instr_type() == ..instr_type.IL_REAL_FIXED_CPN_BOND;}
logical instr_def.is_il_zero_bond() 	option(hidden)		{ return this.instr_type() == ..instr_type.IL_REAL_ZERO_CPN_BOND;}
logical instr_def.is_il_zero_swap() 	option(hidden)		{ return this.instr_type() == ..instr_type.IL_SWAP_ZERO;}
logical instr_def.is_il_rr_swap_fixflt() option(hidden)		{ return this.instr_type() == ..instr_type.IL_SWAP_REAL_FIXFLT;}
logical instr_def.is_il_rr_swap_fixois() option(hidden)		{ return this.instr_type() == ..instr_type.IL_SWAP_REAL_FIXOIS;}
logical instr_def.is_frn() 			option(hidden)			{ return this.instr_type() == ..instr_type.FRN;}
logical instr_def.is_frn_rfr() 		option(hidden)			{ return this.__is_frn_rfr();}
logical instr_def.is_frn_rfr_idx() 		option(hidden)		{ return this.__is_frn_rfr_idx();}
logical instr_def.is_swap_fixflt() 	option(hidden)			{ return this.instr_type() == ..instr_type.SWAP_FIXFLT;}
logical instr_def.is_swap_fltflt() 	option(hidden)			{ return this.instr_type() == ..instr_type.SWAP_FLTFLT;}
logical instr_def.is_swap_fltflt_mtm() 	option(hidden)		{ return this.__ccbs_is_mtm();}
logical instr_def.is_swap_fltflt_mtm_leg1() option(hidden) 	{ return this.__ccbs_is_mtm_leg1();}
logical instr_def.is_swap_fltflt_mtm_leg2() option(hidden)	{ return this.__ccbs_is_mtm_leg2();}
logical instr_def.is_swap_oisois_mtm() 	option(hidden)		{ return this.__ccbs_is_mtm();}
logical instr_def.is_swap_oisois_mtm_leg1() option(hidden) 	{ return this.__ccbs_is_mtm_leg1();}
logical instr_def.is_swap_oisois_mtm_leg2() option(hidden)	{ return this.__ccbs_is_mtm_leg2();}
logical instr_def.is_swap_fltois_mtm() 	option(hidden)		{ return this.__ccbs_is_mtm();}
logical instr_def.is_swap_fltois_mtm_leg1() option(hidden) 	{ return this.__ccbs_is_mtm_leg1();}
logical instr_def.is_swap_fltois_mtm_leg2() option(hidden)	{ return this.__ccbs_is_mtm_leg2();}

logical instr_def.is_swap_fltois() 	option(hidden)	{ return this.instr_type() == ..instr_type.SWAP_FLTOIS;}
logical instr_def.is_swap_oisois() 	option(hidden)  { return this.instr_type() == ..instr_type.SWAP_OISOIS;}
logical instr_def.is_swap_fixois() 	option(hidden)	{ return this.instr_type() == ..instr_type.SWAP_FIXOIS;}
logical instr_def.is_swap_zeroois() option(hidden)	{ return this.instr_type() == ..instr_type.SWAP_ZEROOIS;}
logical instr_def.is_swap_fixfix() 	option(hidden)	{ return this.instr_type() == ..instr_type.SWAP_FIXFIX;}

logical instr_def.is_il_swap_fix_yy() 	option(hidden){ return this.instr_type() == ..instr_type.IL_SWAP_FIX_Y_Y;}
logical instr_def.is_il_swap_flt_yy() 	option(hidden) { return this.instr_type() == ..instr_type.IL_SWAP_FLT_Y_Y;}
logical instr_def.is_il_swap_ois_yy() 	option(hidden)	{ return this.instr_type() == ..instr_type.IL_SWAP_OIS_Y_Y;}

logical instr_def.is_swap_fltflt2s() 	option(hidden)	{ return this.instr_type() == ..instr_type.SWAP_FLTFLT2S;}
logical instr_def.is_swap_fltois2s() 	option(hidden)	{ return this.instr_type() == ..instr_type.SWAP_FLTOIS2S;}
logical instr_def.is_fix_cpn_bond() 	option(hidden)	{ return this.instr_type() == ..instr_type.FIXED_CPN_BOND;}
logical instr_def.is_zero_bond() 		option(hidden)	{ return this.instr_type() == ..instr_type.ZERO_CPN_BOND;}
logical instr_def.is_swap_zeroflt() 	option(hidden)	{ return this.instr_type() == ..instr_type.SWAP_ZEROFLT;}
logical instr_def.is_fra() 				option(hidden)	{ return this.instr_type() == ..instr_type.FRA;}
logical instr_def.is_ir_future() 		option(hidden)	{ return this.instr_type() == ..instr_type.IR_FUTURE;}
logical instr_def.is_on_future() 		option(hidden)	{ return this.instr_type() == ..instr_type.OVERNIGHT_FUTURE;}
logical instr_def.is_deposit() 			option(hidden)	{ return this.instr_type() == ..instr_type.DEPOSIT || this.instr_type() == ..instr_type.DEPOSIT_INDEX;}
logical instr_def.is_deposit_index() 	option(hidden)	{ return this.instr_type() == ..instr_type.DEPOSIT_INDEX;}
logical instr_def.is_depo() option(hidden)		option(com_name: 'LEGACY_is_depo')			{ return this.instr_type() == ..instr_type.DEPOSIT || this.instr_type() == ..instr_type.DEPOSIT_INDEX;}
logical instr_def.is_riba() 			option(hidden)	{ return this.instr_type() == ..instr_type.RIBA;}
logical instr_def.is_ois() option(hidden)		option(com_name: 'LEGACY_is_ois')			{ return this.is_swap_fixois();}
logical instr_def.is_nois() 		option(hidden)	{ return this.instr_type() == ..instr_type.NOIS;}
logical instr_def.is_bill() 		option(hidden)	{ return this.instr_type() == ..instr_type.BILL;}
logical instr_def.is_bill_future() 	option(hidden)	{ return this.instr_type() == ..instr_type.BILL_FUTURE;}
logical instr_def.is_bond_future() 	option(hidden)	{ return this.instr_type() == ..instr_type.BOND_FUTURE;}
logical instr_def.is_fx_spot() 		option(hidden)	{ return this.instr_type() == ..instr_type.FX_SPOT;}
logical instr_def.is_fx_swap() 		option(hidden)	{ return this.instr_type() == ..instr_type.FX_SWAP;}
logical instr_def.is_fx_fwd() 		option(hidden)	{ return this.instr_type() == ..instr_type.FX_FORWARD;}
logical instr_def.is_generic() 		option(hidden)	{ return this.instr_type() == ..instr_type.GENERIC;}
logical instr_def.is_equity() 		option(hidden)	{ return this.instr_type() == ..instr_type.EQUITY;}
logical instr_def.is_complete() option(hidden) 	option(com_name: 'INTERNAL_is_complete')	{ return this.__is_complete();}
logical instr_def.is_instr_type(..instr_type it)
{
	try {
		return this.__is_instr_type(CORE_INT.conv_rev_instr_type(it));
	}
	catch {
		return false;
	}
}
integer instr_def.id() 								{ return this.__id();}
//instr_type instr_def.__instr_type() 				{ return this.__instr_type();}
string instr_def.name() 							{ return this.__name();}
string instr_def.class_name() 						{ return this.__class_name();}
string instr_def.issuer() 							{ return this.__issuer();}
string instr_def.currency() 						{ return this.__currency();}
string instr_def.err_msg() 							{ string c = this.__err_msg(); return null(c) ? "" : c; }
string instr_def.settle_code() 						{ return this.__settle_code();}
string instr_def.value_code() option(hidden) 	option(com_name: 'LEGACY_value_code')		{ return this.__settle_code();}
string instr_def.quote_style() 					option(com_name: 'quote_style_f')			{ return this.__quote_style();}
quote_style instr_def.quote_style_e()			{ return this.__quote_style_e();}



/*-----------------------------------------------------------------------
  instr_def: fwd_start_code
  ----------------------------------------------------------------------*/
string instr_def.fwd_start_code(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__fwd_start_code(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fwd_start_code");
		return e ? null<string>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fwd_start_code");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_leg1_is_quote
  ----------------------------------------------------------------------*/
logical instr_def.swap_leg1_is_quote(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = this.__swap_leg1_is_quote(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_leg1_is_quote");	
		return e ? false : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_leg1_is_quote");
		return false;
	}
}
/*-----------------------------------------------------------------------
  instr_def: swap_leg2_is_quote
  ----------------------------------------------------------------------*/
logical instr_def.swap_leg2_is_quote(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = this.__swap_leg2_is_quote(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_leg2_is_quote");	
		return e ? false : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_leg2_is_quote");
		return false;
	}
}

/*-----------------------------------------------------------------------
  instr_def: is_ccy_swap
  ----------------------------------------------------------------------*/
logical instr_def.is_ccy_swap() 	option(hidden)	{ return this.__is_ccy_swap();}//old version

logical instr_def.is_ccy_swap(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = this.__is_ccy_swap(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.is_ccy_swap");	
		return e ? false : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.is_ccy_swap");
		return false;
	}
}
/*-----------------------------------------------------------------------
  instr_def: is_valid
  ----------------------------------------------------------------------*/
logical instr_def.is_valid(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = this.__is_valid(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.is_valid");	
		return e ? false : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.is_valid");
		return false;
	}
}

/*-----------------------------------------------------------------------
  check_instr_def
  ----------------------------------------------------------------------*/
module CORE_INT {
	
	logical check_instr_def(..instr_def option(nullable) def)
	{	
		try{
			if(null(def)) return false;
			instr_error_type t;
			string 			s;	
			return def.__is_valid(t, s);							
		}
		catch {
			return false;
		}
	}
}
/*-----------------------------------------------------------------------
  instr_def: onfut_dates
  ----------------------------------------------------------------------*/
void instr_def.onfut_dates(	out vector(date)   dates, 
							out vector(date)   publish_dates, 
							out vector(date)   on_start, 
							out vector(date)   on_end,
							out vector(integer) option(nullable) weight,
							error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		this.__onfut_dates(dates, publish_dates, on_start, on_end,weight, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.onfut_dates");
		if(e)
			dates = publish_dates = on_start = on_end = null<vector(date)>;
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.onfut_dates");
		dates = publish_dates = on_start = on_end = null<vector(date)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  instr_def: riba_repo_data
  ----------------------------------------------------------------------*/
void instr_def.riba_repo_data(	out vector(date)   announce_dates, 
								out vector(date)   start_dates, 
								out vector(date)   end_dates, 
								out vector(number)   repo_rates,
								error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		this.__riba_repo_data(announce_dates, start_dates, end_dates, repo_rates, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.riba_repo_data");
		if(e) {
			announce_dates = start_dates = end_dates = null<vector(date)>;
			repo_rates = null<vector(number)>;
		}
		return;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.riba_repo_data");
		announce_dates = start_dates = end_dates = null<vector(date)>;
		repo_rates = null<vector(number)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  instr_def: frn_coupon_data
  ----------------------------------------------------------------------*/
void instr_def.frn_coupon_data(	out vector(date)   fixing_date, 
								out vector(date)   cpn_payment_date, 
								out vector(number)   fixing_rate, 
								out vector(number)   coupon_rate,
								error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		this.__frn_coupon_data(fixing_date, cpn_payment_date, fixing_rate, coupon_rate, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.frn_coupon_data");
		if(e) {
			fixing_date = cpn_payment_date = null<vector(date)>;
			fixing_rate = coupon_rate = null<vector(number)>;
		}
		return;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.frn_coupon_data");
		fixing_date = cpn_payment_date = null<vector(date)>;
		fixing_rate = coupon_rate = null<vector(number)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  instr_def: cash_flow_dates
  ----------------------------------------------------------------------*/
vector(date) instr_def.cash_flow_dates(logical adj_dates ,
									   error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;
		vector(date) c;
		if(adj_dates)
			c = this.__cash_flow_dates( t, s);
		else			
			c = this.__cash_flow_dates_noadj( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.cash_flow_dates");	
		return e ? null<vector(date)> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.cash_flow_dates");
		return null<vector(date)>;
	}
}
/*-----------------------------------------------------------------------
  instr_def: cash_flow_dates
  ----------------------------------------------------------------------*/
vector(date) instr_def.cash_flow_dates(error_info option(nullable) error = null<error_info>)
option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(date) c = this.__cash_flow_dates( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.cash_flow_dates");	
		return e ? null<vector(date)> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.cash_flow_dates");
		return null<vector(date)>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: cash_flow_dates_noadj
  ----------------------------------------------------------------------*/
vector(date) instr_def.cash_flow_dates_noadj(error_info option(nullable) error = null<error_info>)
option(hidden)	
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(date) c = this.__cash_flow_dates_noadj( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.cash_flow_dates_noadj");	
		return e ? null<vector(date)> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.cash_flow_dates_noadj");
		return null<vector(date)>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_cash_flow_dates_leg1
  ----------------------------------------------------------------------*/
vector(date) instr_def.swap_cash_flow_dates_leg1(error_info option(nullable) error = null<error_info>)
option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(date) c = this.__swap_cash_flow_dates_leg1( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_cash_flow_dates_leg1");	
		return e ? null<vector(date)> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_cash_flow_dates_leg1");
		return null<vector(date)>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_cash_flow_dates_noadj_leg1
  ----------------------------------------------------------------------*/
vector(date) instr_def.swap_cash_flow_dates_noadj_leg1(error_info option(nullable) error = null<error_info>)
option(hidden)	
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(date) c = this.__swap_cash_flow_dates_noadj_leg1( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_cash_flow_dates_noadj_leg1");	
		return e ? null<vector(date)> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_cash_flow_dates_noadj_leg1");
		return null<vector(date)>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_cash_flow_dates_leg2
  ----------------------------------------------------------------------*/
vector(date) instr_def.swap_cash_flow_dates_leg2(error_info option(nullable) error = null<error_info>)
option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(date) c = this.__swap_cash_flow_dates_leg2( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_cash_flow_dates_leg2");	
		return e ? null<vector(date)> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_cash_flow_dates_leg2");
		return null<vector(date)>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: 2
  ----------------------------------------------------------------------*/
vector(date) instr_def.swap_cash_flow_dates_noadj_leg2(error_info option(nullable) error = null<error_info>)
option(hidden)	
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(date) c = this.__swap_cash_flow_dates_noadj_leg2( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_cash_flow_dates_noadj_leg2");	
		return e ? null<vector(date)> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_cash_flow_dates_noadj_leg2");
		return null<vector(date)>;
	}
}
/*-----------------------------------------------------------------------
  instr_def: get_quote_num
  ----------------------------------------------------------------------*/
number instr_def.get_quote_num(	date date, 
								string quote_side, 
								error_info option(nullable) error = null<error_info>)
{	
	try{
		quote_side = conv_null_string_com(quote_side) ;
		number c = this.__get_quote_num(date,quote_side );
		CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.get_quote_num");
		return null<number >;
	}
}

number instr_def.get_quote(date date, string quote_side) option(hidden)
option(com_name: 'LEGACY_get_quote')
{
	return this.get_quote_num(date, quote_side);
}
/*-----------------------------------------------------------------------
  instr_def: realtime_feed
  ----------------------------------------------------------------------*/
string instr_def.realtime_feed(string option(nullable) quote_side,
							   error_info option(nullable) error = null<error_info>)
{	
	try{	
		quote_side = conv_null_string_com(quote_side) ;
		string  c = this.__realtime_feed(quote_side );
		CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.realtime_feed");
		return null<string >;
	}
}
/*-----------------------------------------------------------------------
  instr_def: realtime_feed
  ----------------------------------------------------------------------*/
void instr_def.realtime_feed(	string option(nullable) quote_side,
								out vector(string) result,
								error_info option(nullable) error = null<error_info>)
{	
	try{	
		quote_side = conv_null_string_com(quote_side) ;
		this.__realtime_feed_v(quote_side, result );
		CORE_INT.reset_single(error);
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.realtime_feed");
		result = null<vector(string) >;
		return ;
	}
}
/*-----------------------------------------------------------------------
  instr_def: realtime_ric
  ----------------------------------------------------------------------*/
string instr_def.realtime_ric(string option(nullable) quote_side,
							  error_info option(nullable) error = null<error_info>)
{	
	try{	
		quote_side = conv_null_string_com(quote_side) ;
		string  c = this.__realtime_ric(quote_side );
		CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.realtime_ric");
		return null<string >;
	}
}
/*-----------------------------------------------------------------------
  instr_def: realtime_ric
  ----------------------------------------------------------------------*/
void instr_def.realtime_ric(string option(nullable) quote_side,							
							out vector(string) result,
							error_info option(nullable) error = null<error_info>)
{	
	try{	
		quote_side = conv_null_string_com(quote_side) ;
		this.__realtime_ric_v(quote_side, result );
		CORE_INT.reset_single(error);
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.realtime_ric");
		result = null<vector(string) >;
		return ;
	}
}
/*-----------------------------------------------------------------------
  instr_def: realtime_fid
  ----------------------------------------------------------------------*/
string instr_def.realtime_fid(string option(nullable) quote_side,
							  error_info option(nullable) error = null<error_info>)
{	
	try{	
		quote_side = conv_null_string_com(quote_side) ;
		string  c = this.__realtime_fid(quote_side );
		CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.realtime_fid");
		return null<string >;
	}
}

/*-----------------------------------------------------------------------
  instr_def: realtime_fid
  ----------------------------------------------------------------------*/
void instr_def.realtime_fid(string option(nullable) quote_side,
							out vector(string) result,
							error_info option(nullable) error = null<error_info>)
{	
	try{	
		quote_side = conv_null_string_com(quote_side) ;
		this.__realtime_fid_v(quote_side, result );
		CORE_INT.reset_single(error);
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.realtime_fid");
		result = null<vector(string) >;
		return ;
	}
}
/*-----------------------------------------------------------------------
  instr_def: quote_side_is_comp
  ----------------------------------------------------------------------*/
/*quote_side_is_comp(	string option(nullable) quote_side,
					out string quote_side1,
					out string quote_side2)
{	
	try{	
		quote_side = conv_null_string_com(quote_side) ;
		logical  c = __quote_side_is_comp(quote_side,quote_side1,quote_side2 );
		CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.quote_side_is_comp");
		return null<logical >;
	}
}*/

/*-----------------------------------------------------------------------
  instr_def: quote_key
  ----------------------------------------------------------------------*/
string instr_def.quote_key(date 	date,
						   string 	quote_side,
						   error_info option(nullable) error = null<error_info>)
{	
	try{
		quote_side 	= conv_null_string_com(quote_side) ;
		date 		= conv_null_date_com(date) ;
		string  c = this.__quote_key(date, quote_side );
		CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.quote_key");
		return null<string >;
	}
}

/*-----------------------------------------------------------------------
  instr_def: quote_table
  ----------------------------------------------------------------------*/
string instr_def.quote_table(	date date, 
								string quote_side, 
								error_info option(nullable) error = null<error_info>)
{	
	try{
		quote_side 	= conv_null_string_com(quote_side) ;
		date 		= conv_null_date_com(date) ;
		string  c = this.__quote_table(date, quote_side );
		CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.quote_table");
		return null<string >;
	}
}

/*-----------------------------------------------------------------------
  instr_def: assoc_instrs
  ----------------------------------------------------------------------*/
vector(string) instr_def.assoc_instrs(error_info option(nullable) error = null<error_info>)
{	
	try{	
		vector(string) c = this.__assoc_instrs();
		CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.assoc_instrs");
		return null<vector(string)>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: assoc_factors
  ----------------------------------------------------------------------*/
vector(number) instr_def.assoc_factors(error_info option(nullable) error = null<error_info>)
{	
	try{	
		vector(number) c = this.__assoc_factors();
		CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.assoc_factors");
		return null<vector(number)>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: bondfut_deliverables
  ----------------------------------------------------------------------*/
vector(string) instr_def.bondfut_deliverables(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(string) c = this.__bondfut_deliverables(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.bondfut_deliverables");	
		return e ? null<vector(string)> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.bondfut_deliverables");
		return null<vector(string)>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: bondfut_price_factors
  ----------------------------------------------------------------------*/
vector(number) instr_def.bondfut_price_factors(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(number) c = this.__bondfut_price_factors(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.bondfut_price_factors");	
		return e ? null<vector(number)> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.bondfut_price_factors");
		return null<vector(number)>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: ir_index
  ----------------------------------------------------------------------*/
ir_index instr_def.ir_index(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..ir_index c = this.__ir_index( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.ir_index");	
		return e ? null<..ir_index > : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.ir_index");
		return null<..ir_index>;
	}
}

/*-----------------------------------------------------------------------
  swap_not_exchange
  ----------------------------------------------------------------------*/
notional_exchg_style instr_def.swap_not_exchange(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		notional_exchg_style c = this.__swap_not_exchange( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_not_exchange");	
		return e ? null<notional_exchg_style> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_not_exchange");
		return null<notional_exchg_style>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_ir_index_leg1
  ----------------------------------------------------------------------*/
ir_index instr_def.swap_ir_index_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..ir_index c = this.__swap_ir_index_leg1( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_ir_index_leg1");	
		return e ? null<..ir_index> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_ir_index_leg1");
		return null<..ir_index>;
	}
}
/*-----------------------------------------------------------------------
  swap_index_tenor_code_leg1
  ----------------------------------------------------------------------*/
tenor_code instr_def.swap_index_tenor_code_leg1(error_info option(nullable) error) 
{	
	try{
		..ir_index ir = this.swap_ir_index_leg1(error) ;
		if(null(ir)) return null<tenor_code>;
		return ir.tenor_code();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_index_tenor_code_leg1");
		return null<tenor_code>;
	}
}

/*-----------------------------------------------------------------------
  swap_index_tenor_leg1
  ----------------------------------------------------------------------*/
string instr_def.swap_index_tenor_leg1(error_info option(nullable) error) 
{	
	try{
		..ir_index ir = this.swap_ir_index_leg1(error) ;
		if(null(ir)) return null<string>;
		return ir.tenor();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_index_tenor_leg1");
		return null<string>;
	}
}
/*-----------------------------------------------------------------------
  instr_def: swap_ir_index_leg2
  ----------------------------------------------------------------------*/
ir_index instr_def.swap_ir_index_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..ir_index c = this.__swap_ir_index_leg2( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_ir_index_leg2");	
		return e ? null<..ir_index> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_ir_index_leg2");
		return null<..ir_index>;
	}
}

/*-----------------------------------------------------------------------
  swap_index_tenor_code_leg2
  ----------------------------------------------------------------------*/
tenor_code instr_def.swap_index_tenor_code_leg2(error_info option(nullable) error) 
{	
	try{
		..ir_index ir = this.swap_ir_index_leg2(error) ;
		if(null(ir)) return null<tenor_code>;
		return ir.tenor_code();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_index_tenor_code_leg2");
		return null<tenor_code>;
	}
}

/*-----------------------------------------------------------------------
  swap_index_tenor_leg2
  ----------------------------------------------------------------------*/
string instr_def.swap_index_tenor_leg2(error_info option(nullable) error) 
{	
	try{
		..ir_index ir = this.swap_ir_index_leg2(error) ;
		if(null(ir)) return null<string>;
		return ir.tenor();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_index_tenor_leg2");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: il_cpi_link
  ----------------------------------------------------------------------*/
cpi_link instr_def.il_cpi_link(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		cpi_link c = this.__il_cpi_link( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.il_cpi_link");	
		return e ? null<..cpi_link> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.il_cpi_link");
		return null<..cpi_link>;
	}
}

cpi_link instr_def.cpi_link() option(hidden)
option(com_name: 'LEGACY_cpi_link')
{
	return this.il_cpi_link();
}

/*-----------------------------------------------------------------------
  instr_def: il_cpi_link_idx2
  ----------------------------------------------------------------------*/
cpi_link instr_def.il_cpi_link_idx2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..cpi_link c = this.__il_cpi_link_idx2( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.il_cpi_link_idx2");	
		return e ? null<..cpi_link> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.il_cpi_link_idx2");
		return null<..cpi_link>;
	}
}

cpi_link instr_def.cpi_link_idx2() option(hidden)
option(com_name: 'LEGACY_cpi_link_idx2')
{
	return this.il_cpi_link_idx2();
}

/*-----------------------------------------------------------------------
  instr_def: il_index_freq
  ----------------------------------------------------------------------*/
integer instr_def.il_index_freq(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__il_index_freq(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.il_index_freq");	
		return e ? err_freq() : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.il_index_freq");
		return err_freq();
	}
}

/*-----------------------------------------------------------------------
  instr_def: bondfut_delivery_style
  ----------------------------------------------------------------------*/
bond_fut_style instr_def.bondfut_style(error_info option(nullable) error = null<error_info>)
option(com_name: 'bondfut_style_f')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		bond_fut_style c = this.__bondfut_delivery_style( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.bondfut_style");	
		return e ? null<bond_fut_style> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.bondfut_style");
		return null<bond_fut_style>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: frn_neg_floor_rule
  ----------------------------------------------------------------------*/
frn_neg_rate_rule instr_def.frn_neg_rate_rule(error_info option(nullable) error = null<error_info>)
option(com_name: 'frn_neg_rate_rule_f')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..frn_neg_rate_rule c = this.__frn_neg_floor_rule( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.frn_neg_rate_rule");	
		return e ? null<..frn_neg_rate_rule> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.frn_neg_rate_rule");
		return null<..frn_neg_rate_rule>;
	}
}

frn_neg_rate_rule instr_def.frn_neg_rate_style() option(hidden)
option(com_name: 'LEGACY_frn_neg_rate_style')
{
	return this.frn_neg_rate_rule();
}
/*-----------------------------------------------------------------------
  instr_def: fx_spot_rule
  ----------------------------------------------------------------------*/
fx_spot_rule instr_def.fx_spot_rule(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..fx_spot_rule c = this.__fx_rule( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fx_spot_rule");	
		return e ? null<..fx_spot_rule> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fx_spot_rule");
		return null<..fx_spot_rule>;
	}
}

fx_spot_rule instr_def.fx_rule(error_info option(nullable) error = null<error_info>) option(hidden)
{	
	return fx_spot_rule(error);
}


/*-----------------------------------------------------------------------
  instr_def: first_cpn_date
  ----------------------------------------------------------------------*/
date instr_def.first_cpn_date(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = this.__first_cpn_date( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.first_cpn_date");	
		return e ? null<date> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.first_cpn_date");
		return null<date >;
	}
}

/*-----------------------------------------------------------------------
  instr_def: first_settle_date
  ----------------------------------------------------------------------*/
date instr_def.first_settle_date(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = this.__first_settle_date( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.first_settle_date");	
		return e ? null<date> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.first_settle_date");
		return null<date >;
	}
}

/*-----------------------------------------------------------------------
  instr_def: settle_date
  ----------------------------------------------------------------------*/
date instr_def.settle_date(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = this.__settle_date( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.settle_date");	
		return e ? null<date> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.settle_date");
		return null<date >;
	}
}

/*-----------------------------------------------------------------------
  instr_def: last_reg_cpn_date
  ----------------------------------------------------------------------*/
date instr_def.last_reg_cpn_date(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = this.__last_reg_cpn_date( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.last_reg_cpn_date");	
		return e ? null<date> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.last_reg_cpn_date");
		return null<date >;
	}
}

/*-----------------------------------------------------------------------
  instr_def: maturity
  ----------------------------------------------------------------------*/
date instr_def.maturity(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = this.__maturity( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.maturity");	
		return e ? null<date> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.maturity");
		return null<date >;
	}
}

/*-----------------------------------------------------------------------
  instr_def: issue_date
  ----------------------------------------------------------------------*/
date instr_def.issue_date(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = this.__issue_date( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.issue_date");	
		return e ? null<date> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.issue_date");
		return null<date >;
	}
}

/*-----------------------------------------------------------------------
  instr_def: cpn_start_date
  ----------------------------------------------------------------------*/
date instr_def.cpn_start_date(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = this.__cpn_start_date( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.cpn_start_date");	
		return e ? null<date> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.cpn_start_date");
		return null<date >;
	}
}

/*-----------------------------------------------------------------------
  instr_def: il_cpi_date
  ----------------------------------------------------------------------*/
date instr_def.il_cpi_date(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = this.__il_cpi_date( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.il_cpi_date");	
		return e ? null<date> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.il_cpi_date");
		return null<date >;
	}
}

date instr_def.cpi_date() option(hidden)
option(com_name: 'LEGACY_cpi_date')
{
	return this.il_cpi_date();
}
/*-----------------------------------------------------------------------
  instr_def: il_cpi_date_idx2
  ----------------------------------------------------------------------*/
date instr_def.il_cpi_date_idx2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = this.__il_cpi_date_idx2( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.il_cpi_date_idx2");	
		return e ? null<date> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.il_cpi_date_idx2");
		return null<date >;
	}
}

date instr_def.cpi_date_idx2() option(hidden)
option(com_name: 'LEGACY_cpi_date_idx2')
{
	return this.il_cpi_date_idx2();
}
/*-----------------------------------------------------------------------
  instr_def: index_maturity
  ----------------------------------------------------------------------*/
date instr_def.index_maturity(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = this.__index_maturity( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.index_maturity");	
		return e ? null<date> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.index_maturity");
		return null<date >;
	}
}

/*-----------------------------------------------------------------------
  instr_def: calc_method
  ----------------------------------------------------------------------*/
string instr_def.calc_method(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__calc_method( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.__calc_method");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.__calc_method");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: fx_spot_name
  ----------------------------------------------------------------------*/
string instr_def.fx_spot_name(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__fx_spot_name( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fx_spot_name");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fx_spot_name");
		return null<string>;
	}
}


string instr_def.ccy_spot_name() option(hidden)
option(com_name: 'LEGACY_ccy_spot_name')
{
	return this.fx_spot_name();
}
/*-----------------------------------------------------------------------
  instr_def: fx_price_ccy
  ----------------------------------------------------------------------*/
string instr_def.fx_price_ccy(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__fx_price_ccy(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fx_price_ccy");	
		return e ? null<string> : c;	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fx_price_ccy");
		return null<string>;
	}
}

string instr_def.price_currency() option(hidden)
option(com_name: 'LEGACY_price_currency')
{
	return this.fx_price_ccy();
}
/*-----------------------------------------------------------------------
  instr_def: fx_base_ccy
  ----------------------------------------------------------------------*/
string instr_def.fx_base_ccy(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__fx_base_ccy(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fx_base_ccy");	
		return e ? null<string> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fx_base_ccy");
		return null<string>;
	}
}

string instr_def.base_currency() option(hidden)
option(com_name: 'LEGACY_base_currency')
{
	return this.fx_base_ccy();
}
/*-----------------------------------------------------------------------
  instr_def: fx_price_ccy_calendar_name
  ----------------------------------------------------------------------*/
string instr_def.fx_price_ccy_calendar_name(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__fx_price_ccy_calendar_name(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fx_price_ccy_calendar_name");	
		return e ? null<string> : c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fx_price_ccy_calendar_name");
		return null<string>;
	}
}

string instr_def.price_ccy_calendar_name() option(hidden)
option(com_name: 'LEGACY_price_ccy_calendar_name')
{
	return this.fx_price_ccy_calendar_name();
}
/*-----------------------------------------------------------------------
  instr_def: fx_base_ccy_calendar_name
  ----------------------------------------------------------------------*/
string instr_def.fx_base_ccy_calendar_name(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__fx_base_ccy_calendar_name(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fx_base_ccy_calendar_name");	
		return e ? null<string> : c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fx_base_ccy_calendar_name");
		return null<string>;
	}
}

string instr_def.base_ccy_calendar_name() option(hidden)
option(com_name: 'LEGACY_base_ccy_calendar_name')
{
	return this.fx_base_ccy_calendar_name();
}
/*-----------------------------------------------------------------------
  instr_def: fx_usd_calendar_name
  ----------------------------------------------------------------------*/
string instr_def.fx_usd_calendar_name(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__fx_usd_calendar_name(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fx_usd_calendar_name");	
		return e ? null<string> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fx_usd_calendar_name");
		return null<string>;
	}
}

string instr_def.usd_calendar_name() option(hidden)
option(com_name: 'LEGACY_usd_calendar_name')
{
	return this.fx_usd_calendar_name();
}
/*-----------------------------------------------------------------------
  instr_def: fixing_calendar_name
  ----------------------------------------------------------------------*/
string instr_def.fixing_calendar_name(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__fixing_calendar_name(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fixing_calendar_name");	
		return e ? null<string> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fixing_calendar_name");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: excpn_code
  ----------------------------------------------------------------------*/
string instr_def.excpn_code(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__excpn_code(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.excpn_code");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.excpn_code");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: frn_roll_method
  ----------------------------------------------------------------------*/
string instr_def.frn_roll_method(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__frn_roll_method(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.frn_roll_method");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.frn_roll_method");
		return null<string>;
	}
}

string instr_def.roll_method() option(hidden)
option(com_name: 'LEGACY_roll_method')
{
	return this.frn_roll_method();
}
/*-----------------------------------------------------------------------
  instr_def: maturity_code
  ----------------------------------------------------------------------*/
string instr_def.maturity_code(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__maturity_code(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.maturity_code");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.maturity_code");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: fixing_code
  ----------------------------------------------------------------------*/
string instr_def.fixing_code(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__fixing_code(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fixing_code");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fixing_code");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: fx_spot_code
  ----------------------------------------------------------------------*/
string instr_def.fx_spot_code(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__fx_spot_code(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fx_spot_code");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fx_spot_code");
		return null<string>;
	}
}

string instr_def.ccy_spot_code() option(hidden)
option(com_name: 'LEGACY_ccy_spot_code')
{
	return this.fx_spot_code();
}
/*-----------------------------------------------------------------------
  instr_def: rnd_price_pcnt
  ----------------------------------------------------------------------*/
string instr_def.rnd_price_pcnt(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__rnd_price_pcnt(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.rnd_price_pcnt");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.rnd_price_pcnt");
		return null<string>;
	}
}

string instr_def.price_round() option(hidden)
option(com_name: 'LEGACY_price_round')
{
	return this.rnd_price_pcnt();
}
/*-----------------------------------------------------------------------
  instr_def: rnd_dirty_price_pcnt
  ----------------------------------------------------------------------*/
string instr_def.rnd_dirty_price_pcnt(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__rnd_dirty_price_pcnt(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.rnd_dirty_price_pcnt");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.rnd_dirty_price_pcnt");
		return null<string>;
	}
}

string instr_def.dirty_price_round() option(hidden)
option(com_name: 'LEGACY_dirty_price_round')
{
	return this.rnd_dirty_price_pcnt();
}
/*-----------------------------------------------------------------------
  instr_def: rnd_yield_pcnt
  ----------------------------------------------------------------------*/
string instr_def.rnd_yield_pcnt(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__rnd_yield_pcnt(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.rnd_yield_pcnt");	
		return e ? null<string> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.rnd_yield_pcnt");
		return null<string>;
	}
}

string instr_def.yield_round() option(hidden)
option(com_name: 'LEGACY_yield_round')
{
	return this.rnd_yield_pcnt();
}
/*-----------------------------------------------------------------------
  instr_def: rnd_accr_pcnt
  ----------------------------------------------------------------------*/
string instr_def.rnd_accr_pcnt(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__rnd_accr_pcnt(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.rnd_accr_pcnt");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.rnd_accr_pcnt");
		return null<string>;
	}
}

string instr_def.accr_round() option(hidden)
option(com_name: 'LEGACY_accr_round')
{
	return this.rnd_accr_pcnt();
}
/*-----------------------------------------------------------------------
  instr_def: il_rnd_cashflow_pcnt
  ----------------------------------------------------------------------*/
string instr_def.il_rnd_cashflow_pcnt(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__il_rnd_cashflow_pcnt(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.il_rnd_cashflow_pcnt");	
		return e ? null<string> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.il_rnd_cashflow_pcnt");
		return null<string>;
	}
}

string instr_def.cash_round() option(hidden)
option(com_name: 'LEGACY_cash_round')
{
	return this.il_rnd_cashflow_pcnt();
}
string instr_def.il_cash_round() option(hidden)
option(com_name: 'LEGACY_il_cash_round')
{
	return this.il_rnd_cashflow_pcnt();
}

/*-----------------------------------------------------------------------
  instr_def: fixing_calendar
  ----------------------------------------------------------------------*/
calendar instr_def.fixing_calendar(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..calendar c = this.__fixing_calendar(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fixing_calendar");	
		return e ? null<..calendar> : c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fixing_calendar");
		return null<..calendar >;
	}
}

/*-----------------------------------------------------------------------
  instr_def: fx_usd_calendar
  ----------------------------------------------------------------------*/
calendar instr_def.fx_usd_calendar(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..calendar c = this.__fx_usd_calendar(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fx_usd_calendar");	
		return e ? null<..calendar> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fx_usd_calendar");
		return null<..calendar >;
	}
}

calendar instr_def.usd_calendar() option(hidden)
option(com_name: 'LEGACY_usd_calendar')
{
	return this.fx_usd_calendar();
}
/*-----------------------------------------------------------------------
  instr_def: fx_price_ccy_calendar
  ----------------------------------------------------------------------*/
calendar instr_def.fx_price_ccy_calendar(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..calendar c = this.__fx_price_ccy_calendar(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fx_price_ccy_calendar");	
		return e ? null<..calendar> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fx_price_ccy_calendar");
		return null<..calendar >;
	}
}

calendar instr_def.price_ccy_calendar() option(hidden)
option(com_name: 'LEGACY_price_ccy_calendar')
{
	return this.fx_price_ccy_calendar();
}
/*-----------------------------------------------------------------------
  instr_def: fx_base_ccy_calendar
  ----------------------------------------------------------------------*/
calendar instr_def.fx_base_ccy_calendar(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..calendar c = this.__fx_base_ccy_calendar(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fx_base_ccy_calendar");	
		return e ? null<..calendar> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fx_base_ccy_calendar");
		return null<..calendar >;
	}
}

calendar instr_def.base_ccy_calendar() option(hidden)
option(com_name: 'LEGACY_base_ccy_calendar')
{
	return this.fx_base_ccy_calendar();
}

/*-----------------------------------------------------------------------
  instr_def: fltflt_swap_class_sprd
  ----------------------------------------------------------------------*/
string instr_def.fltflt_swap_class_sprd(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__fltflt_swap_class_sprd(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fltflt_swap_class_sprd");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fltflt_swap_class_sprd");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: fltflt_swap_class_flat
  ----------------------------------------------------------------------*/
string instr_def.fltflt_swap_class_flat(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__fltflt_swap_class_flat(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fltflt_swap_class_flat");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fltflt_swap_class_flat");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: fltois_swap_class_flat
  ----------------------------------------------------------------------*/
string instr_def.fltois_swap_class_flat(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__fltflt_swap_class_flat(t, s);//__fltois_swap_class_flat points to same tag as __fltflt_swap_class_flat
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fltois_swap_class_flat");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fltois_swap_class_flat");
		return null<string>;
	}
}
/*-----------------------------------------------------------------------
  instr_def: fltois_swap_class_sprd
  ----------------------------------------------------------------------*/
string instr_def.fltois_swap_class_sprd(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__fltflt_swap_class_sprd(t, s);//__fltois_swap_class_sprd points to same tag as __fltflt_swap_class_sprd
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fltois_swap_class_sprd");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fltois_swap_class_sprd");
		return null<string>;
	}
}
/*-----------------------------------------------------------------------
  instr_def: swap_currency_leg1
  ----------------------------------------------------------------------*/
string instr_def.swap_currency_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__swap_currency_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_currency_leg1");
		return e ? null<string>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_currency_leg1");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_currency_leg2
  ----------------------------------------------------------------------*/
string instr_def.swap_currency_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__swap_currency_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_currency_leg2");
		return e ? null<string>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_currency_leg2");
		return null<string>;
	}
}
/*-----------------------------------------------------------------------
  instr_def: swap_calendar_leg1
  ----------------------------------------------------------------------*/
calendar instr_def.swap_calendar_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..calendar c = this.__swap_calendar_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_calendar_leg1");	
		return e ? null<..calendar> : c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_calendar_leg1");
		return null<..calendar >;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_calendar_leg2
  ----------------------------------------------------------------------*/
calendar instr_def.swap_calendar_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..calendar c = this.__swap_calendar_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_calendar_leg2");	
		return e ? null<..calendar> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_calendar_leg2");
		return null<..calendar >;
	}
}

/*-----------------------------------------------------------------------
  instr_def: calendar
  ----------------------------------------------------------------------*/
calendar instr_def.calendar(error_info option(nullable) error = null<error_info>)
{	
	try{
		..calendar c = this.__calendar(0);
		CORE_INT.reset_single(error);
		return c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.calendar");
		return null<..calendar >;
	}
}

/*-----------------------------------------------------------------------
  instr_def: calendar
  ----------------------------------------------------------------------*/
calendar instr_def.calendar(integer index, error_info option(nullable) error = null<error_info>)
{	
	try{
		..calendar c = this.__calendar(index);
		CORE_INT.reset_single(error);
		return c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.calendar");
		return null<..calendar >;
	}
}
/*-----------------------------------------------------------------------
  instr_def: calendar_name
  ----------------------------------------------------------------------*/
string instr_def.calendar_name(error_info option(nullable) error = null<error_info>)
{	
	try{
		string c = this.__calendar_name(0);
		CORE_INT.reset_single(error);
		return c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.calendar_name");
		return null<string >;
	}
}
/*-----------------------------------------------------------------------
  instr_def: calendar_name
  ----------------------------------------------------------------------*/
string instr_def.calendar_name(integer index , error_info option(nullable) error = null<error_info>)
{	
	try{				
		string c = this.__calendar_name(index);
		CORE_INT.reset_single(error);
		return c;				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.calendar_name");
		return null<string >;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_calendar_name_leg1
  ----------------------------------------------------------------------*/
string instr_def.swap_calendar_name_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__swap_calendar_name_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_calendar_name_leg1");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_calendar_name_leg1");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_calendar_name_leg2
  ----------------------------------------------------------------------*/
string instr_def.swap_calendar_name_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__swap_calendar_name_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_calendar_name_leg2");	
		return e ? null<string> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_calendar_name_leg2");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: fixing_curve
  ----------------------------------------------------------------------*/
string instr_def.fixing_curve(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__fixing_curve(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fixing_curve");	
		return e ? null<string> : c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fixing_curve");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: fixing_instr
  ----------------------------------------------------------------------*/
string instr_def.fixing_instr(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__fixing_instr(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fixing_instr");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fixing_instr");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: fixing_instr_qs
  ----------------------------------------------------------------------*/
string instr_def.fixing_instr_qs(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__fixing_instr_qs(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fixing_instr_qs");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fixing_instr_qs");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_fixing_curve_leg1
  ----------------------------------------------------------------------*/
string instr_def.swap_fixing_curve_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__swap_fixing_curve_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_fixing_curve_leg1");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_fixing_curve_leg1");
		return null<string>;
	}
}


/*-----------------------------------------------------------------------
  instr_def: swap_fixing_curve_leg2
  ----------------------------------------------------------------------*/
string instr_def.swap_fixing_curve_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__swap_fixing_curve_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_fixing_curve_leg2");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_fixing_curve_leg2");
		return null<string>;
	}
}


/*-----------------------------------------------------------------------
  instr_def: swap_fixing_instr_leg1
  ----------------------------------------------------------------------*/
string instr_def.swap_fixing_instr_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__swap_fixing_instr_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_fixing_instr_leg1");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_fixing_instr_leg1");
		return null<string>;
	}
}


/*-----------------------------------------------------------------------
  instr_def: swap_fixing_instr_leg2
  ----------------------------------------------------------------------*/
string instr_def.swap_fixing_instr_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__swap_fixing_instr_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_fixing_instr_leg2");	
		return e ? null<string> : c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_fixing_instr_leg2");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_fixing_instr_qs_leg1
  ----------------------------------------------------------------------*/
string instr_def.swap_fixing_instr_qs_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__swap_fixing_instr_qs_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_fixing_instr_qs_leg1");	
		return e ? null<string> : c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_fixing_instr_qs_leg1");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_fixing_instr_qs_leg2
  ----------------------------------------------------------------------*/
string instr_def.swap_fixing_instr_qs_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = this.__swap_fixing_instr_qs_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_fixing_instr_qs_leg2");	
		return e ? null<string> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_fixing_instr_qs_leg2");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: eom
  ----------------------------------------------------------------------*/
logical instr_def.eom(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = this.__eom(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.eom");	
		return e ? null<logical> : c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.eom");
		return null<logical>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: il_min_redemp_at_par
  ----------------------------------------------------------------------*/
logical instr_def.il_min_redemp_at_par(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = this.__il_min_redemp_at_par(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.il_min_redemp_at_par");	
		return e ? null<logical> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.il_min_redemp_at_par");
		return null<logical>;
	}
}

logical instr_def.min_redemp_at_par() option(hidden) 
option(com_name: 'LEGACY_min_redemp_at_par')
{
	return il_min_redemp_at_par();
}
/*-----------------------------------------------------------------------
  instr_def: mat_code_trd_off
  ----------------------------------------------------------------------*/
logical instr_def.mat_code_trd_off(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = this.__mat_code_trd_off(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.mat_code_trd_off");	
		return e ? null<logical> : c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.mat_code_trd_off");
		return null<logical>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: fx_reverse_ric
  ----------------------------------------------------------------------*/
logical instr_def.fx_reverse_ric(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = this.__fx_reverse_ric(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fx_reverse_ric");	
		return e ? null<logical> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fx_reverse_ric");
		return null<logical>;
	}
}

logical instr_def.ccy_reverse_ric() option(hidden) 
option(com_name: 'LEGACY_ccy_reverse_ric')
{
	return fx_reverse_ric();
}

/*-----------------------------------------------------------------------
  instr_def: swap_eom_leg1
  ----------------------------------------------------------------------*/
logical instr_def.swap_eom_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = this.__swap_eom_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_eom_leg1");	
		return e ? null<logical> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_eom_leg1");
		return null<logical>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_eom_leg2
  ----------------------------------------------------------------------*/
logical instr_def.swap_eom_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = this.__swap_eom_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_eom_leg2");	
		return e ? null<logical> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_eom_leg2");
		return null<logical>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: fut_daily_mtm
  ----------------------------------------------------------------------*/
logical instr_def.fut_daily_mtm(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = this.__fut_daily_mtm(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fut_daily_mtm");	
		return e ? null<logical> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fut_daily_mtm");
		return null<logical>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: pmt_bus_day wrapper   
  ----------------------------------------------------------------------*/
bd_convention instr_def.pmt_bus_day(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		bd_convention c = this.__pmt_bus_day(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.pmt_bus_day");	
		return e ? null<bd_convention> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.pmt_bus_day");
		return null<bd_convention>;
	}
}
/*-----------------------------------------------------------------------
  instr_def: swap_pmt_bus_day_leg1 wrapper   
  ----------------------------------------------------------------------*/
bd_convention instr_def.swap_pmt_bus_day_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		bd_convention c = this.__swap_pmt_bus_day_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_pmt_bus_day_leg1");	
		return e ? null<bd_convention> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_pmt_bus_day_leg1");
		return null<bd_convention>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_pmt_bus_day_leg2 wrapper   
  ----------------------------------------------------------------------*/
bd_convention instr_def.swap_pmt_bus_day_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		bd_convention c = this.__swap_pmt_bus_day_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_pmt_bus_day_leg2");	
		return e ? null<bd_convention> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_pmt_bus_day_leg2");
		return null<bd_convention>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: accr_dc_method wrapper   
  ----------------------------------------------------------------------*/
day_count_method instr_def.accr_dc_method(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		day_count_method c = this.__accr_dc_method(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.accr_dc_method");	
		return e ? null<day_count_method> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.accr_dc_method");
		return null<day_count_method>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: accr_last_dc_method wrapper   
  ----------------------------------------------------------------------*/
day_count_method instr_def.accr_last_dc_method(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		day_count_method c = this.__accr_last_dc_method(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.accr_last_dc_method");	
		return e ? null<day_count_method> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.accr_last_dc_method");
		return null<day_count_method>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: dc_method wrapper   
  ----------------------------------------------------------------------*/
day_count_method instr_def.dc_method(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		day_count_method c = this.__dc_method(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.dc_method");	
		return e ? null<day_count_method> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.dc_method");
		return null<day_count_method>;
	}
}
/*-----------------------------------------------------------------------
  instr_def: next_last_dc_method wrapper   
  ----------------------------------------------------------------------*/
day_count_method instr_def.next_last_dc_method(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		day_count_method c = this.__next_last_dc_method(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.next_last_dc_method");	
		return e ? null<day_count_method> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.next_last_dc_method");
		return null<day_count_method>;
	}
}
/*-----------------------------------------------------------------------
  instr_def: next_dc_method wrapper   
  ----------------------------------------------------------------------*/
day_count_method instr_def.next_dc_method(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		day_count_method c = this.__next_dc_method(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.next_dc_method");	
		return e ? null<day_count_method> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.next_dc_method");
		return null<day_count_method>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_dc_method_leg1 wrapper   
  ----------------------------------------------------------------------*/
day_count_method instr_def.swap_dc_method_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		day_count_method c = this.__swap_dc_method_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_dc_method_leg1");
		return e ? null<day_count_method>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_dc_method_leg1");
		return null<day_count_method>;
	}
}
/*-----------------------------------------------------------------------
  instr_def: swap_dc_method_leg2 wrapper   
  ----------------------------------------------------------------------*/
day_count_method instr_def.swap_dc_method_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		day_count_method c = this.__swap_dc_method_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_dc_method_leg2");
		return e ? null<day_count_method>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_dc_method_leg2");
		return null<day_count_method>;
	}
}

/*-----------------------------------------------------------------------
  swap_ir_rule
  ----------------------------------------------------------------------*/
interest_rule  instr_def.swap_ir_rule(error_info option(nullable) error)
{		
	try{	
		instr_error_type t;
   		string 			s;	
		interest_rule c = this.__swap_int_rule(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_ir_rule");
		return e ? null<interest_rule>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_ir_rule");
		return null<interest_rule>;
	}
}
/*-----------------------------------------------------------------------
  swap_ir_rule_leg1
  ----------------------------------------------------------------------*/
interest_rule  instr_def.swap_ir_rule_leg1(error_info option(nullable) error)
{		
	try{	
		instr_error_type t;
   		string 			s;	
		interest_rule c = this.__swap_int_rule_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_ir_rule_leg1");
		return e ? null<interest_rule>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_ir_rule_leg1");
		return null<interest_rule>;
	}
}
/*-----------------------------------------------------------------------
  swap_ir_rule_leg2
  ----------------------------------------------------------------------*/
interest_rule  instr_def.swap_ir_rule_leg2(error_info option(nullable) error)
{		
	try{	
		instr_error_type t;
   		string 			s;	
		interest_rule c = this.__swap_int_rule_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_ir_rule_leg2");
		return e ? null<interest_rule>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_ir_rule_leg2");
		return null<interest_rule>;
	}
}
/*-----------------------------------------------------------------------
  instr_def: coupon_rate   
  ----------------------------------------------------------------------*/
number  instr_def.coupon_rate(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = this.__coupon_rate(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.coupon_rate");	
		return e ? null<number> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.coupon_rate");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  instr_def: coupon   
  ----------------------------------------------------------------------*/
number  instr_def.coupon(error_info option(nullable) error = null<error_info>) option(hidden)
{
	return coupon_rate(error);
}
/*-----------------------------------------------------------------------
  instr_def: face_amount
  ----------------------------------------------------------------------*/
number  instr_def.face_amount(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = this.__face_amount(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.face_amount");	
		return e ? null<number> : c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.face_amount");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: fut_contract_size
  ----------------------------------------------------------------------*/
number  instr_def.fut_contract_size(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = this.__fut_contract_size(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fut_contract_size");	
		return e ? null<number> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fut_contract_size");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: issued_amount
  ----------------------------------------------------------------------*/
number  instr_def.issued_amount(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = this.__issued_amount(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.issued_amount");	
		return e ? null<number> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.issued_amount");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: capgain_tax
  ----------------------------------------------------------------------*/
number  instr_def.capgain_tax(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = this.__capgain_tax(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.capgain_tax");	
		return e ? null<number> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.capgain_tax");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: cpn_tax
  ----------------------------------------------------------------------*/
number  instr_def.cpn_tax(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = this.__cpn_tax(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.cpn_tax");	
		return e ? null<number> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.cpn_tax");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: first_coupon_rate
  ----------------------------------------------------------------------*/
number  instr_def.first_coupon_rate(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = this.__first_coupon_rate(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.first_coupon_rate");	
		return e ? null<number> : c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.first_coupon_rate");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  instr_def: first_coupon
  ----------------------------------------------------------------------*/
number  instr_def.first_coupon(error_info option(nullable) error = null<error_info>)
{
	return first_coupon_rate(error);
}
/*-----------------------------------------------------------------------
  instr_def: issue_price_tax
  ----------------------------------------------------------------------*/
number  instr_def.issue_price_tax(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = this.__issue_price_tax(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.issue_price_tax");	
		return e ? null<number> : c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.issue_price_tax");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: redemp_price
  ----------------------------------------------------------------------*/
number  instr_def.redemp_price(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = this.__redemp_price(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.redemp_price");	
		return e ? null<number> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.redemp_price");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: il_base_cpi
  ----------------------------------------------------------------------*/
number  instr_def.il_base_cpi(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = this.__il_base_cpi(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.il_base_cpi");	
		return e ? null<number> : c;	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.il_base_cpi");
		return null<number>;
	}
}

number instr_def.cpi_base_idx() option(hidden)
option(com_name: 'LEGACY_cpi_base_idx')
{
	return this.il_base_cpi();
}
/*-----------------------------------------------------------------------
  instr_def: frn_fix_margin
  ----------------------------------------------------------------------*/
number  instr_def.frn_fix_margin(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = this.__frn_fix_margin(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.frn_fix_margin");	
		return e ? null<number> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.frn_fix_margin");
		return null<number>;
	}
}

number instr_def.fix_margin() option(hidden)
option(com_name: 'LEGACY_fix_margin')
{
	return this.frn_fix_margin();
}
/*-----------------------------------------------------------------------
  instr_def: coupon_freq   
  ----------------------------------------------------------------------*/
integer  instr_def.coupon_freq(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__coupon_freq(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.coupon_freq");
		return e ? err_freq(): c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.coupon_freq");
		return err_freq();
	}
}

integer instr_def.cpn_freq() option(hidden)
option(com_name: 'LEGACY_cpn_freq')
{
	return this.coupon_freq();
}

/*-----------------------------------------------------------------------
  instr_def: swap_coupon_freq_leg1   
  ----------------------------------------------------------------------*/
integer  instr_def.swap_coupon_freq_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__swap_coupon_freq_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_coupon_freq_leg1");
		return e ? err_freq(): c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_ir_index_leg2");
		return err_freq();
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_coupon_freq_leg2   
  ----------------------------------------------------------------------*/
integer  instr_def.swap_coupon_freq_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__swap_coupon_freq_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_coupon_freq_leg2");
		return e ? err_freq(): c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_coupon_freq_leg2");
		return err_freq();
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_reset_freq_leg1   
  ----------------------------------------------------------------------*/
integer  instr_def.swap_reset_freq_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__swap_reset_freq_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_reset_freq_leg1");	
		return e ? err_freq() : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_reset_freq_leg1");
		return err_freq();
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_reset_freq_leg2   
  ----------------------------------------------------------------------*/
integer  instr_def.swap_reset_freq_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__swap_reset_freq_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_reset_freq_leg2");	
		return e ? err_freq() : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_reset_freq_leg2");
		return err_freq();
	}
}

/*-----------------------------------------------------------------------
  instr_def: frn_rfr_arr_type
  ----------------------------------------------------------------------*/
rfr_arrears_type  instr_def.frn_rfr_arr_type(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		rfr_arrears_type c = this.__frn_rfr_arr_type(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.frn_rfr_arr_type");	
		return e ? null<rfr_arrears_type> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.frn_rfr_arr_type");
		return null<rfr_arrears_type>;
	}
}
/*-----------------------------------------------------------------------
  instr_def: frn_rfr_arr_days
  ----------------------------------------------------------------------*/
integer  instr_def.frn_rfr_arr_days(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__frn_rfr_arr_days(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.frn_rfr_arr_days");	
		return e ? err_int() : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.frn_rfr_arr_days");
		return err_int();
	}
}





/*-----------------------------------------------------------------------
  instr_def: frn_rfr_pmt_lag
  ----------------------------------------------------------------------*/
integer  instr_def.frn_rfr_pmt_lag(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__frn_pmt_lag(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.frn_rfr_pmt_lag");	
		return e ? err_int() : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.frn_rfr_pmt_lag");
		return err_int();
	}
}
/*-----------------------------------------------------------------------
  instr_def: frn_rfr_pmt_lag_prin
  ----------------------------------------------------------------------*/
integer  instr_def.frn_rfr_pmt_lag_prin(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__frn_pmt_lag_prin(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.frn_rfr_pmt_lag_prin");	
		return e ? err_int() : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.frn_rfr_pmt_lag_prin");
		return err_int();
	}
}
/*-----------------------------------------------------------------------
  instr_def: swap_rfr_arr_type_leg1
  ----------------------------------------------------------------------*/
rfr_arrears_type  instr_def.swap_rfr_arr_type_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		rfr_arrears_type c = this.__swap_rfr_arr_type_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_rfr_arr_type_leg1");	
		return e ? null<rfr_arrears_type> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_rfr_arr_type_leg1");
		return null<rfr_arrears_type>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_rfr_arr_days_leg1
  ----------------------------------------------------------------------*/
integer  instr_def.swap_rfr_arr_days_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__swap_rfr_arr_days_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_rfr_arr_days_leg1");	
		return e ? err_int() : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_rfr_arr_days_leg1");
		return err_int();
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_rfr_arr_type_leg2
  ----------------------------------------------------------------------*/
rfr_arrears_type  instr_def.swap_rfr_arr_type_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		rfr_arrears_type c = this.__swap_rfr_arr_type_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_rfr_arr_type_leg2");	
		return e ? null<rfr_arrears_type> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_rfr_arr_type_leg2");
		return null<rfr_arrears_type>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_rfr_arr_days_leg2
  ----------------------------------------------------------------------*/
integer  instr_def.swap_rfr_arr_days_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__swap_rfr_arr_days_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_rfr_arr_days_leg2");	
		return e ? err_int() : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_rfr_arr_days_leg2");
		return err_int();
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_fwd_stub_style_leg1
  ----------------------------------------------------------------------*/
flt_stub_fwd_style  instr_def.swap_fwd_stub_style_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		flt_stub_fwd_style c = this.__swap_fwd_stub_style_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_fwd_stub_style_leg1");	
		return e ? null<flt_stub_fwd_style> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_fwd_stub_style_leg1");
		return null<flt_stub_fwd_style>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_fwd_stub_style_leg2
  ----------------------------------------------------------------------*/
flt_stub_fwd_style  instr_def.swap_fwd_stub_style_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		flt_stub_fwd_style c = this.__swap_fwd_stub_style_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_fwd_stub_style_leg2");	
		return e ? null<flt_stub_fwd_style> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_fwd_stub_style_leg2");
		return null<flt_stub_fwd_style>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_sprd_comp_method_leg1
  ----------------------------------------------------------------------*/
flt_avg_method  instr_def.swap_avg_method_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		flt_avg_method c = this.__swap_avg_method_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_avg_method_leg1");	
		return e ? null<flt_avg_method> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_avg_method_leg1");
		return null<flt_avg_method>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_avg_method_leg2
  ----------------------------------------------------------------------*/
flt_avg_method  instr_def.swap_avg_method_leg2(error_info option(nullable) error = null<error_info>)

{	
	try{	
		instr_error_type t;
   		string 			s;	
		flt_avg_method c = this.__swap_avg_method_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_avg_method_leg2");	
		return e ? null<flt_avg_method> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_avg_method_leg2");
		return null<flt_avg_method>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_sprd_comp_method_leg1
  ----------------------------------------------------------------------*/
flt_sprd_comp_method  instr_def.swap_sprd_comp_method_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		flt_sprd_comp_method c = this.__swap_sprd_comp_method_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_sprd_comp_method_leg1");	
		return e ? null<flt_sprd_comp_method> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_sprd_comp_method_leg1");
		return null<flt_sprd_comp_method>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_sprd_comp_method_leg2
  ----------------------------------------------------------------------*/
flt_sprd_comp_method  instr_def.swap_sprd_comp_method_leg2(error_info option(nullable) error = null<error_info>)

{	
	try{	
		instr_error_type t;
   		string 			s;	
		flt_sprd_comp_method c = this.__swap_sprd_comp_method_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_sprd_comp_method_leg2");	
		return e ? null<flt_sprd_comp_method> : c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_sprd_comp_method_leg2");
		return null<flt_sprd_comp_method>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_comp_avg_type_leg1
  ----------------------------------------------------------------------*/
flt_comp_avg_type  instr_def.swap_comp_avg_type_leg1(error_info option(nullable) error = null<error_info>)

{	
	try{	
		instr_error_type t;
   		string 			s;	
		flt_comp_avg_type c = this.__swap_comp_avg_type_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_comp_avg_type_leg1");	
		return e ? null<flt_comp_avg_type> : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_comp_avg_type_leg1");
		return null<flt_comp_avg_type>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: ois_is_endog_df_leg1
  ----------------------------------------------------------------------*/
logical  instr_def.ois_is_endog_df_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = this.__ois_endog_df_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.ois_is_endog_df_leg1");	
		return e ? null : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.ois_is_endog_df_leg1");
		return null;
	}
}

/*-----------------------------------------------------------------------
  instr_def: ois_is_endog_df_leg2
  ----------------------------------------------------------------------*/
logical  instr_def.ois_is_endog_df_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = this.__ois_endog_df_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.ois_is_endog_df_leg2");	
		return e ? null : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.ois_is_endog_df_leg2");
		return null;
	}
}

/*-----------------------------------------------------------------------
  instr_def: ois_is_approx_calc_leg1
  ----------------------------------------------------------------------*/
logical  instr_def.ois_is_approx_calc_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = this.__ois_proxycalc_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.ois_is_approx_calc_leg1");	
		return e ? null : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.ois_is_approx_calc_leg1");
		return null;
	}
}
/*-----------------------------------------------------------------------
  instr_def: ois_is_approx_calc_leg2
  ----------------------------------------------------------------------*/
logical  instr_def.ois_is_approx_calc_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = this.__ois_proxycalc_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.ois_is_approx_calc_leg2");	
		return e ? null : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.ois_is_approx_calc_leg2");
		return null;
	}
}
/*-----------------------------------------------------------------------
  instr_def: il_index_method
  ----------------------------------------------------------------------*/
infl_index_method  instr_def.il_index_method(error_info option(nullable) error = null<error_info>)

{	
	try{	
		instr_error_type t;
   		string 			s;	
		infl_index_method c = this.__il_index_method(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.il_index_method");	
		return e ? null<infl_index_method> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.il_index_method");
		return null<infl_index_method>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_comp_avg_type_leg2
  ----------------------------------------------------------------------*/
flt_comp_avg_type  instr_def.swap_comp_avg_type_leg2(error_info option(nullable) error = null<error_info>)

{	
	try{	
		instr_error_type t;
   		string 			s;	
		flt_comp_avg_type c = this.__swap_comp_avg_type_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_comp_avg_type_leg2");	
		return e ? null<flt_comp_avg_type> : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_comp_avg_type_leg2");
		return null<flt_comp_avg_type>;
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_roll_day_leg1  
  ----------------------------------------------------------------------*/
integer  instr_def.swap_roll_day_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__swap_roll_day_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_roll_day_leg1");	
		return e ? err_int() : c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_roll_day_leg1");
		return err_int();
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_roll_day_leg2  
  ----------------------------------------------------------------------*/
integer  instr_def.swap_roll_day_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__swap_roll_day_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_roll_day_leg2");	
		return e ? err_int() : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_roll_day_leg2");
		return err_int();
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_pmt_lag_leg1
  ----------------------------------------------------------------------*/
integer  instr_def.swap_pmt_lag_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__swap_pmt_lag_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_pmt_lag_leg1");
		return e ? err_int(): c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_pmt_lag_leg1");
		return err_int();
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_pmt_lag_prin_leg1
  ----------------------------------------------------------------------*/
integer  instr_def.swap_pmt_lag_prin_leg1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__swap_pmt_lag_prin_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_pmt_lag_prin_leg1");
		return e ? err_int(): c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_pmt_lag_prin_leg1");
		return err_int();
	}
}
/*-----------------------------------------------------------------------
  instr_def: swap_pmt_lag_leg2
  ----------------------------------------------------------------------*/
integer  instr_def.swap_pmt_lag_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__swap_pmt_lag_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_pmt_lag_leg2");
		return e ? err_int(): c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_pmt_lag_leg2");
		return err_int();
	}
}

/*-----------------------------------------------------------------------
  instr_def: swap_pmt_lag_prin_leg2
  ----------------------------------------------------------------------*/
integer  instr_def.swap_pmt_lag_prin_leg2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__swap_pmt_lag_prin_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_pmt_lag_prin_leg2");
		return e ? err_int(): c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_pmt_lag_prin_leg2");
		return err_int();
	}
}
/*-----------------------------------------------------------------------
  instr_def: roll_day
  ----------------------------------------------------------------------*/
integer  instr_def.roll_day(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__roll_day(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.roll_day");	
		return e ? err_int() : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.roll_day");
		return err_int();
	}
}

/*-----------------------------------------------------------------------
  instr_def: reset_freq
  ----------------------------------------------------------------------*/
integer  instr_def.reset_freq(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__reset_freq(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.reset_freq");	
		return e ? err_freq() : c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.reset_freq");
		return err_freq();
	}
}


/*-----------------------------------------------------------------------
  instr_def: il_cpi_lag1
  ----------------------------------------------------------------------*/
integer  instr_def.il_cpi_lag1(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__il_cpi_lag1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.il_cpi_lag1");
		return e ? err_int(): c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.il_cpi_lag1");
		return err_int();
	}
}

integer instr_def.cpi_lag1() option(hidden)
option(com_name: 'LEGACY_cpi_lag1')
{
	return this.il_cpi_lag1();
}
/*-----------------------------------------------------------------------
  instr_def: il_cpi_lag2
  ----------------------------------------------------------------------*/
integer  instr_def.il_cpi_lag2(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__il_cpi_lag2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.il_cpi_lag2");
		return e ? err_int(): c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.il_cpi_lag2");
		return err_int();
	}
}

integer instr_def.cpi_lag2() option(hidden)
option(com_name: 'LEGACY_cpi_lag2')
{
	return this.il_cpi_lag2();
}

/*-----------------------------------------------------------------------
  instr_def: fx_pip_value
  ----------------------------------------------------------------------*/
integer  instr_def.fx_pip_value(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__fx_pip_value(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fx_pip_value");
		return e ? err_int(): c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fx_pip_value");
		return err_int();
	}
}

integer instr_def.ccy_decimals() option(hidden)
option(com_name: 'LEGACY_ccy_decimals')
{
	return this.fx_pip_value();
}

/*-----------------------------------------------------------------------
  instr_def: fx_spot_quote_dec
  ----------------------------------------------------------------------*/
integer  instr_def.fx_spot_quote_dec(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__fx_spot_quote_dec(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fx_spot_quote_dec");
		return e ? err_int(): c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fx_spot_quote_dec");
		return err_int();
	}
}

integer instr_def.ccy_quote_decimals() option(hidden)
option(com_name: 'LEGACY_ccy_quote_decimals')
{
	return this.fx_spot_quote_dec();
}
/*-----------------------------------------------------------------------
  instr_def: fx_scale
  ----------------------------------------------------------------------*/
integer  instr_def.fx_scale(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__fx_scale(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fx_scale");
		return e ? err_int(): c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fx_scale");
		return err_int();
	}
}

integer instr_def.ccy_scale() option(hidden)
option(com_name: 'LEGACY_ccy_scale')
{
	return this.fx_scale();
}
/*-----------------------------------------------------------------------
  instr_def: fx_spot_days
  ----------------------------------------------------------------------*/
integer  instr_def.fx_spot_days(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__fx_spot_days(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fx_spot_days");
		return e ? err_int(): c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fx_spot_days");
		return err_int();
	}
}
/*-----------------------------------------------------------------------
  instr_def: fx_swap_quote_dec
  ----------------------------------------------------------------------*/
integer  instr_def.fx_swap_quote_dec(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__fx_swap_quote_dec(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fx_swap_quote_dec");
		return e ? err_int(): c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fx_swap_quote_dec");
		return err_int();
	}
}

integer instr_def.ccy_quote_dec_swap() option(hidden)
option(com_name: 'LEGACY_ccy_quote_dec_swap')
{
	return this.fx_swap_quote_dec();
}
/*-----------------------------------------------------------------------
  instr_def: fx_fwd_quote_dec
  ----------------------------------------------------------------------*/
integer  instr_def.fx_fwd_quote_dec(error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = this.__fx_fwd_quote_dec(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.fx_fwd_quote_dec");
		return e ? err_int(): c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.fx_fwd_quote_dec");
		return err_int();
	}
}


/*-----------------------------------------------------------------------
  swap_dc_method_fltois2s
  ----------------------------------------------------------------------*/
void  instr_def.swap_dc_method_fltois2s(	out day_count_method fixleg_flat_dc,
											out day_count_method fltleg_flat_dc,
											out day_count_method fixleg_sprd_dc,
											out day_count_method oisleg_sprd_dc,
											error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		this.__swap_dc_method_fltois2s(fixleg_flat_dc,
									   fltleg_flat_dc,
									   fixleg_sprd_dc,
									   oisleg_sprd_dc,
									   t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_dc_method_fltois2s");
		if(e){
			fixleg_flat_dc = fltleg_flat_dc = fixleg_sprd_dc = oisleg_sprd_dc = null;
		}
		return ;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_dc_method_fltois2s");
		fixleg_flat_dc = fltleg_flat_dc = fixleg_sprd_dc = oisleg_sprd_dc = null;
		return ;
	}
}

/*-----------------------------------------------------------------------
  swap_cpn_freq_fltois2s
  ----------------------------------------------------------------------*/
void  instr_def.swap_cpn_freq_fltois2s(	out integer fixleg_flat_cpn_freq,
										out integer fltleg_flat_cpn_freq,
										out integer fixleg_sprd_cpn_freq,
										out integer oisleg_sprd_cpn_freq,
										error_info option(nullable) error = null<error_info>)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		this.__swap_cpn_freq_fltois2s(fixleg_flat_cpn_freq,
									   fltleg_flat_cpn_freq,
									   fixleg_sprd_cpn_freq,
									   oisleg_sprd_cpn_freq,
									   t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instr_def.swap_cpn_freq_fltois2s");
		if(e){
			fixleg_flat_cpn_freq = fltleg_flat_cpn_freq = fixleg_sprd_cpn_freq = oisleg_sprd_cpn_freq = err_freq() ;
		}
		return ;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.swap_cpn_freq_fltois2s");
		fixleg_flat_cpn_freq = fltleg_flat_cpn_freq = fixleg_sprd_cpn_freq = oisleg_sprd_cpn_freq = err_freq() ;
		return ;
	}
}


integer instr_def.ccy_quote_dec_fwd() option(hidden)
option(com_name: 'LEGACY_ccy_quote_dec_fwd')
{
	return this.fx_fwd_quote_dec();
}

void   instr_def.__dbg_print(__dbg_label l)
{
    l.set_text(strcat([ "name: ",
						name(),
						",  id: ",
						string(id()),
						", valid: ",
						string(this.is_valid())]));
}
void   instr_def.__dbg_browse(__dbg_split s)
{
    s.resize(3);

    s.set_text(0, "name");
    s.set_value(0, this.name());

    s.set_text(1, "id");
    s.set_value(1, id());

	s.set_text(2, "valid");
    s.set_value(2, is_valid());
}


/*--------------------------------------------------------------------------
  ----------------experimental----------------------------------------------
  --------------------------------------------------------------------------*/
/*class __instr_def 
{
public:
    
	//virtual instr_type	type()			= 0;

	
protected:
	__instr_def(instr_def);
	instr_def def_;	  
};

__instr_def.__instr_def(instr_def def) : def_(def){}


class __fra_def : public __instr_def
{
public:
    

protected:
	__fra_def(instr_def);
	    
};

__fra_def.__fra_def(instr_def def) : __instr_def(def){}

__fra_def	__fra_def(__instr_def def) 	{ __fra_def d = dynamic_cast<__fra_def>(def); QL_FAIL_COND(null(d) , "invalid cast"); return d;}

*/
/*-----------------------------------------------------------------------
  func: __instr_def
  ----------------------------------------------------------------------*/
/*__instr_def __instr_def(string 	class_instr_name ,
						logical	is_class_name ,
						error_info option(nullable) error = null<error_info>) 
{	
	try{			
		..instr_def c = __instr_def(class_instr_name,is_class_name );

		QL_FAIL_COND(null(c), "null instr_def");//should not happen		

		if(!is_class_name || (!c.is_valid(error) && INSTR_CREATE_NULL_ERR))
			return null<__instr_def>; 


		switch(c.instr_type()){
		case INST_FRA:
			return new __fra_def(c);
		default:
			QL_FAIL("invalid instr_def type");
		}						
	}
	catch {
		set_error(error,ERR_T_INIT,err.message());
		return null<__instr_def>;
	}
}

*/

