/*	
	instr_def wrapper functions for bills
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	

//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/
/*-----------------------------------------------------------------------
  func: instr_def_bill
  ----------------------------------------------------------------------*/
instr_def instr_def_bill(	string 	name ,
							error_info option(nullable) error = null<error_info>) 
option (category: 'Instrument/Bill')
{	
	try{
		logical is_class_name ;	
		..instr_def c 	= instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_bill(), "instr_def not a bill", E_INIT);		
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_bill");
		return null<..instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_bill[NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_bill(	string					instr_def_name,									
							bill_yld_method			yld_method,
							..day_count_method 		day_count_method, 						
							string option(nullable) excpn_code, 	 								
							bill_cpn_type			cpn_type,
							string 	 				settle_code,						
							..calendar 	 			calendar,
							string					currency,									
							..quote_style			quote_style,							
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Bill')
{	
	try{
			
		instr_def c = __instr_def_bill_nodb(instr_def_name,yld_method,day_count_method, excpn_code,
											cpn_type,settle_code,calendar,currency,quote_style );

		return create_instr_def(c, error);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_bill");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_bill   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_bill(INSTR_TMPL.bill_def_tmpl	tmpl,
						error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Bill')
{	
	try{
		
		instr_def c = __instr_def_bill_nodb(tmpl.name(),tmpl.yld_method(), tmpl.day_count_method(),  
											tmpl.excpn_code(), tmpl.cpn_type(), tmpl.settle_code(), tmpl.calendar(),
											tmpl.currency(),tmpl.quote_style());


		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_bill");
		return null<instr_def>;
	}
}
 

