/*	
	instr_def wrapper functions for ir_future
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	// Throw error if a null value is used in a non-nullable context


//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/
/*-----------------------------------------------------------------------
  func: instr_def_bond_future
  ----------------------------------------------------------------------*/
instr_def instr_def_bond_future(string 	name ,
								error_info option(nullable) error = null<error_info>) 
option (category: 'Instrument/Bond Future')
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_bond_future(), "instr_def not a bond future", E_INIT);		
		return c;
					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_bond_future");
		return null<..instr_def>;
	}
}

//---------------------
// [NO DATABASE] create
//----------------------

/*-----------------------------------------------------------------------
  func: instr_def_bond_future[NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_bond_future(string 						instr_def_name,
								bond_fut_style				style,
								bond_fut_pf option(nullable) pf_method,
								string						underlying_mat_code,
								number 						coupon,
								integer 					cpn_freq,
								day_count_method 			day_count_method,
								logical						eom, 	
								calendar					calendar,
								string						currency,						
								number						contract_val,
								quote_style					quote_style,
								number 	option(nullable)	tick_size,
								string						fixing_code,						
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Bond Future')
{	
	try{	
		instr_def c = __instr_def_bondfut_nodb(	instr_def_name,style,pf_method,underlying_mat_code,coupon, cpn_freq,
												day_count_method, eom, calendar, 
												currency,contract_val,quote_style,tick_size,fixing_code );

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_bond_future");
		return null<instr_def>;
	}
}

/*
instr_def create_irfut_instr_def(day_count_method 	day_count_method, 
								string				currency,
								string				fixing_code)
{
	return instr_def_irfut("irfut_def",day_count_method, currency, fixing_code);
}*/

/*-----------------------------------------------------------------------
  func: instr_def_irfut [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_bond_future(INSTR_TMPL.bondfut_def_tmpl			tmpl,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Bond Future')
{	
	try{			
		instr_def c = __instr_def_bondfut_nodb(	tmpl.name(),tmpl.style(),tmpl.pf_method(),tmpl.underlying_mat_code(),tmpl.coupon(), 
												tmpl.cpn_freq(), tmpl.day_count_method(), tmpl.eom(), tmpl.calendar(), 
												tmpl.currency(),tmpl.contract_val(),tmpl.quote_style(),tmpl.tick_size(),
												tmpl.fixing_code());

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_bond_future");
		return null<instr_def>;
	}
}
 

