/*	
	instr_def wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	


//***----------INSTR_DEF CREATORS [FUNCTION]-----------***

/*-----------------------------------------------------------------------
  func: create_instr_def  <internal>
  ----------------------------------------------------------------------*/
instr_def create_instr_def(..instr_def option(nullable) c,
						   logical 						is_class_name,
						   error_info option(nullable) error = null<error_info>)
{
	QL_FAIL_COND(null(c), "null instr_def", E_INIT);//should not happen (since an error will be thrown before)				
					
	if(is_class_name) 
		return c;  		
	else if(!c.is_valid(error)) 
		return INSTR_CREATE_NULL_ERR ? null<instr_def> : c;					
	else
		return c;	
}

instr_def create_instr_def(..instr_def option(nullable) c,
						   error_info option(nullable) error = null<error_info>)
{
	QL_FAIL_COND(null(c), "null instr_def", E_INIT);//should not happen (since an error will be thrown before)	
		
	if(!c.is_valid(error))
		return INSTR_CREATE_NULL_ERR ? null<instr_def> : c; 
	else
		return c;	
}
/*-----------------------------------------------------------------------
  func: instr_def
  ----------------------------------------------------------------------*/
instr_def instr_def(	string 	name ,
						error_info option(nullable) error = null<error_info>) 
option(com_name: 'db_instr_def')
option (category: 'Instrument')
{	
	try{
		logical is_class_name;
			
		..instr_def c = __instr_def(name, is_class_name);
		return create_instr_def(c, is_class_name, error);
															
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def");
		return null<..instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def
  ----------------------------------------------------------------------*/
instr_def instr_def(	string 	name ,
						out logical is_class_name,
						error_info option(nullable) error = null<error_info>) 
option(com_name: 'db_instr_def_ext')
{	
	try{		
		..instr_def c = __instr_def(name, is_class_name);

		return create_instr_def(c, is_class_name, error);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def");
		return null<..instr_def>;
	}
}
/*-----------------------------------------------------------------------
  func: instr_def
  ----------------------------------------------------------------------*/
instr_def instr_def(	instr_def 				instr_def,
						string 					name ,
						date					maturity,
						number option(nullable)	face_amount	= null<number>,
						number option(nullable)	coupon		= null<number>,
						integer 				coupon_freq = err_freq(),
						date option(nullable)	issue_date  = null<date>,
						date option(nullable)	first_cpn_date = null<date>,
						number option(nullable)	il_base_cpi = null<number>,
						logical 				preserve_if_null = true,//preserve instr_def values if input is null
						error_info option(nullable) error 	= null<error_info>)
option(com_name: 'db_instr_def_arg')
option (category: 'Instrument')
{	
	try{	
		face_amount 	= conv_null_number_com(face_amount);
		coupon 			= conv_null_number_com(coupon);
		il_base_cpi 	= conv_null_number_com(il_base_cpi);
		issue_date		= conv_null_date_com(issue_date);
		first_cpn_date	= conv_null_date_com(first_cpn_date);
		if(is_null_int_com(coupon_freq))
			coupon_freq = err_freq();

		if(preserve_if_null){
			error_info ee = new error_info(true,false);
			if(null(face_amount))
				face_amount = instr_def.face_amount(ee);
			if(null(coupon))
				coupon = instr_def.coupon(ee);
			if(coupon_freq==err_freq())
				coupon_freq = instr_def.coupon_freq(ee);

			date m = instr_def.maturity(ee);
			if(!null(m) && maturity == m){//keep instr_def values only for the same mat
				if(null(issue_date))
					issue_date = instr_def.issue_date(ee);
				if(null(first_cpn_date))
					first_cpn_date = instr_def.first_cpn_date(ee);
			}
			if(null(il_base_cpi))
				il_base_cpi = instr_def.il_base_cpi(ee);
		}
			
		..instr_def c = __instr_def(instr_def, name, maturity,face_amount, coupon, 
									coupon_freq,issue_date, first_cpn_date, il_base_cpi );

		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def");
		return null<..instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def
  ----------------------------------------------------------------------*/
instr_def instr_def(	instr_def 					instr_def,
						string 						name ,
						string 						maturity_code,
						number option(nullable)		face_amount	= null<number>,
						number option(nullable)		coupon		= null<number>,
						integer 					coupon_freq = err_freq(),				
						number option(nullable)		il_base_cpi = null<number>,
						logical 					preserve_if_null = true,
						error_info option(nullable) error 		= null<error_info>)
option(com_name: 'db_instr_def_arg2')
option (category: 'Instrument')
{	
	try{	
		face_amount 	= conv_null_number_com(face_amount);
		coupon 			= conv_null_number_com(coupon);
		il_base_cpi 	= conv_null_number_com(il_base_cpi);		
		if(is_null_int_com(coupon_freq))
			coupon_freq = err_freq();

		if(preserve_if_null){
			error_info ee = new error_info(true,false);
			if(null(face_amount))
				face_amount = instr_def.face_amount(ee);
			if(null(coupon))
				coupon = instr_def.coupon(ee);
			if(coupon_freq == err_freq())
				coupon_freq = instr_def.coupon_freq(ee);
			if(null(il_base_cpi))
				il_base_cpi = instr_def.il_base_cpi(ee);
		}		
		
		..instr_def c = __instr_def(instr_def, name, maturity_code,face_amount, coupon, 
									coupon_freq,null<date>, null<date>,il_base_cpi );

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def");
		return null<..instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_cpi_link
  ----------------------------------------------------------------------*/
instr_def instr_def_cpi_link(instr_def 	instr_def,
							string 		name,
							cpi_link	cpi_link,
							error_info option(nullable) error = null<error_info>)
//option(com_name: 'db_instr_def_cpi_link')
option (category: 'Instrument/Inflation Linked')
{	
	try{			
		..instr_def c = __instr_def_cpi_link(instr_def, name,cpi_link );

		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def");
		return null<..instr_def>;
	}
}


instr_def instr_def(	instr_def 	instr_def,
						cpi_link	cpi_link )
option(com_name: 'db_instr_def_cpi_link_LEGACY')
option(warning: "This variant of instr_def(...) is deprecated")
{
	string  name = strcat(instr_def.__name(),"[modified]");
	return instr_def_cpi_link(instr_def,name,cpi_link );
}

/*-----------------------------------------------------------------------
  func: instr_def
  ----------------------------------------------------------------------*/
instr_def instr_def(	instr_def 	instr_def,
						string 		name ,
						string 		maturity_code,	
						string 		settle_code,					
						number option(nullable)	coupon = null<number>,	
						error_info option(nullable) error = null<error_info>)
option(com_name: 'db_instr_def_arg3')
option (category: 'Instrument')
{	
	try{	
		coupon 			= conv_null_number_com(coupon);	
		..instr_def c = __instr_def(instr_def, name, maturity_code,settle_code,coupon );

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def");
		return null<..instr_def>;
	}
}

module CORE_INT
{
	/*-----------------------------------------------------------------------
	  instr_prefetch
	  instrument should be created with quote_side = "" or create an instr_def from name
	  ----------------------------------------------------------------------*/
	void instr_prefetch(instr_def def,
						quote_side option(nullable) quote_side)
	{
		try {
			if(null(quote_side))
				quote_side = quote_side_default();

			error_info e 	= new error_info(true,true);
			vector(string) ric, feed_o;
			def.realtime_ric(quote_side,ric,e);
			def.realtime_feed(quote_side,feed_o,e);			
			if(null(ric) || null(feed_o) )
				return;
			integer size = v_size(ric);
			if(size != v_size(feed_o) )
				return;
			//no checking if there are duplicates
			for (integer i=0;i<size;i++){
				string source, feed;
				rt.__feed2src(feed_o[i], source, feed);
				rt.prefetch(ric[i],source, feed);
			}
		}
		catch {}
		
	}
}