/*	
	instr_def wrapper functions for deposit
	Developer: Algorithmica Research, Magnus Nyström			
*/

//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/
/*-----------------------------------------------------------------------
  func: instr_def_deposit
  ----------------------------------------------------------------------*/
instr_def instr_def_deposit(string 	name ,
							error_info option(nullable) error = null<error_info>) 
option(com_name: 'instr_def_deposit_db')
option (category: 'Instrument/Deposit')
{	
	try{			
		logical is_class_name;
		error_info ee = new error_info(true,false);
		..instr_def c 	= instr_def(name ,is_class_name ,ee);
		QL_FAIL_COND(ee.is_error(), ee.message(), E_INIT);		
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_deposit(), "instr_def not a deposit", E_INIT);
		
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_deposit");
		return null<..instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_deposit
  ----------------------------------------------------------------------*/
/*
instr_def instr_def_deposit(instr_def 	instr_def,
							string 		name ,
							date		maturity,							
							number option(nullable)		coupon,							
							date option(nullable)	issue_date ,							
							out instr_error option(nullable) error)
option (category: 'Instrument/Deposit')
{	
	try{	
		QL_FAIL_COND(!instr_def.is_depo(), "instr_def not a deposit");
		
		..instr_def c = __instr_def(instr_def, name, maturity,100, coupon, 
									-1,issue_date, null<date>, null<number> );

		QL_FAIL_COND(null(c), "null instr_def");//should not happen
		
		if(!c.is_valid(error))
			return INSTR_CREATE_NULL_ERR ? null<instr_def> : c; 
		else
			return c;						
	}
	catch {
		set_error(error,ERR_T_INIT,err.message());
		return null<..instr_def>;
	}
}

*/

/*-----------------------------------------------------------------------
  func: instr_def_deposit
  ----------------------------------------------------------------------*/

instr_def instr_def_deposit(instr_def 	instr_def,
							string 		name ,
							string 		maturity_code,							
							error_info option(nullable) error = null<error_info>)
option(com_name: 'instr_def_deposit_arg')
option (category: 'Instrument/Deposit')
{	
	try{	
		
		QL_FAIL_COND(!instr_def.is_deposit(), "instr_def not a deposit", E_INIT);
	
		..instr_def c = __instr_def(instr_def, name, maturity_code,100, null<number> );
		
		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_deposit");
		return null<..instr_def>;
	}
}


//----------------
// [NO DATABASE] create
//----------------
/*-----------------------------------------------------------------------
  func: instr_def_deposit   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_deposit(	string 				instr_def_name,
								day_count_method 	day_count_method, 
								bd_convention 		bd_convention ,
								logical				eom ,
								string				settle_code ,
								string 	option(nullable) maturity_code,
								calendar			calendar,
								string				currency,
								logical				adj_suppl_cal,
								calendar option(nullable) suppl_calendar,
								error_info option(nullable) error = null<error_info>)
option(com_name: 'instr_def_deposit')
option (category: 'Instrument/Deposit')
{	
	try{
		if(!null(maturity_code) && maturity_code == "")
			maturity_code = null<string>;
		instr_def c = __instr_def_depo_nodb(instr_def_name,day_count_method, bd_convention, eom, settle_code, 
											maturity_code,calendar, currency,adj_suppl_cal, suppl_calendar );

		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_deposit");
		return null<instr_def>;
	}
}

instr_def create_depo_instr_def(day_count_method 	day_count_method, 
								bd_convention 		bd_convention ,
								logical				eom ,
								string				settle_code ,
								calendar			calendar,
								string				currency) 
option(com_name: 'LEGACY_create_depo_instr_def')
{
	return instr_def_deposit(	"depo_def", day_count_method, bd_convention, eom, settle_code, 
								 null<string>,calendar, currency, false, null<calendar>);
}

/*-----------------------------------------------------------------------
  func: instr_def_deposit   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_deposit(	INSTR_TMPL.deposit_def_tmpl	tmpl,
								error_info option(nullable) error = null<error_info>)
option(com_name: 'instr_def_deposit_tmpl')
option (category: 'Instrument/Deposit')
{	
	try{		
		
		instr_def c = __instr_def_depo_nodb(tmpl.name(),tmpl.day_count_method(), tmpl.bd_convention(), tmpl.eom(), tmpl.settle_code(), 
											tmpl.maturity_code(),tmpl.calendar(), tmpl.currency(), tmpl.adj_suppl_cal(), tmpl.suppl_cal() );

		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_deposit");
		return null<instr_def>;
	}
}
 
