/*	
	instr_def wrapper functions for generic
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	


//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/
/*-----------------------------------------------------------------------
  func: instr_def_equity
  ----------------------------------------------------------------------*/
instr_def instr_def_equity(string name ,
							error_info option(nullable) error = null<error_info>) 
option (category: 'Instrument/Equity')
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_equity(), "instr_def not an equity", E_INIT);		
		return c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_equity");
		return null<..instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_equity[NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_equity(string 				instr_def_name,
							string 				settle_code,
							string 				currency,
							calendar 			calendar,
							..quote_style 		quote_style = ..quote_style.PRICE,							
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Equity')
{	
	try{	
		
		instr_def c = __instr_def_equity_nodb(	instr_def_name, settle_code,currency,calendar,quote_style);

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_equity");
		return null<instr_def>;
	}
}
