/*	
	instr_def wrapper functions for swaps
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	

//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/
/*-----------------------------------------------------------------------
  func: instr_def_swap_fixfix
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_fixfix(string 	name ,
							error_info option(nullable) error = null<error_info>) 
option (category: 'Instrument/Interest Rate Swap/Fixed vs Fixed')
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_swap_fixfix(), "instr_def not a fix-fix swap", E_INIT);		
		return c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fixfix");
		return null<..instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_swap_fixfix [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_fixfix(string				instr_def_name,	
								string 				settle_code,
								string option(nullable) maturity_code,	
								notional_exchg_style option(nullable) not_exchange,									
							 	integer 			fix1_cpn_freq,
							    day_count_method 	fix1_day_count_method,
							    string 				fix1_currency,
							    calendar 			fix1_calendar,
							    bd_convention 		fix1_bd_convention,
							    logical 			fix1_eom,
							    integer 			fix2_cpn_freq,
							    day_count_method 	fix2_day_count_method,
							    string 				fix2_currency,
							    calendar 			fix2_calendar,
							    bd_convention 		fix2_bd_convention,
							    logical 			fix2_eom,							    															
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Fixed')
{	
	try{	
		if(null(not_exchange)) {
			if( equal_casei(fix1_currency, fix2_currency)) 
				not_exchange = NE_NONE ;
			else 
				not_exchange = NE_BOTH;
		}
		instr_def c = __instr_def_fixfix_nodb(instr_def_name,fix1_cpn_freq,fix1_day_count_method,fix1_currency,fix1_calendar,fix1_bd_convention,
							    				fix1_eom,fix2_cpn_freq,fix2_day_count_method,fix2_currency,fix2_calendar,fix2_bd_convention,
							    				fix2_eom,settle_code,maturity_code,not_exchange);

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fixfix");
		return null<instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_swap_fixfix   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_swap_fixfix(INSTR_TMPL.swap_fixfix_def_tmpl		tmpl,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Fixed')
{	
	try{
		instr_def c = __instr_def_fixfix_nodb(	tmpl.name(),tmpl.fix1_cpn_freq(),tmpl.fix1_day_count_method(),
												tmpl.fix1_currency(),tmpl.fix1_calendar(),
							    				tmpl.fix1_bd_convention(), tmpl.fix1_eom(),tmpl.fix2_cpn_freq(),
												tmpl.fix2_day_count_method(),tmpl.fix2_currency(),tmpl.fix2_calendar(),
												tmpl.fix2_bd_convention(), tmpl.fix2_eom(),tmpl.spot_settle_code(),
												tmpl.maturity_code(),tmpl.not_exchange());


		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fixfix");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_swap_fixfix   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_swap_fixfix(	INSTR_TMPL.swap_fixfix_def_tmpl		tmpl,
								  string 	option(nullable) 			maturity_code,
									error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Fixed')
{	
	try{
		if(null(maturity_code))
			maturity_code = tmpl.maturity_code();
		instr_def c = __instr_def_fixfix_nodb(	tmpl.name(),tmpl.fix1_cpn_freq(),tmpl.fix1_day_count_method(),
												tmpl.fix1_currency(),tmpl.fix1_calendar(),
							    				tmpl.fix1_bd_convention(), tmpl.fix1_eom(),tmpl.fix2_cpn_freq(),
												tmpl.fix2_day_count_method(),tmpl.fix2_currency(),tmpl.fix2_calendar(),
												tmpl.fix2_bd_convention(), tmpl.fix2_eom(),tmpl.spot_settle_code(),
												maturity_code,tmpl.not_exchange());


		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fixfix");
		return null<instr_def>;
	}
}
 

