/*	
	instr_def wrapper functions for fixois  -single currency
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	

//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/
/*-----------------------------------------------------------------------
  func: instr_def_swap_fixois
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_fixois(string 	name ,
							error_info option(nullable) error = null<error_info>) 
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_swap_fixois(), "instr_def not an ois", E_INIT);		
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fixois");
		return null<..instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_fixois [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_fixois(string				instr_def_name,	
							    string 				settle_code,
							    string 	option(nullable) maturity_code,								
							 	integer 			cpn_freq,
							    day_count_method 	day_count_method,
							    string 				currency,
							    calendar 			calendar,
							    bd_convention 		bd_convention,
							    logical 			eom,
								rfr_arrears_type option(nullable) 		ois_arr_type,
								number option(nullable)					ois_arr_days,
								logical option(nullable)				ois_endog_df,
								flt_comp_avg_type option(nullable)		ois_comp_avg,
    							flt_sprd_comp_method option(nullable) 	ois_spread_comp_method,
    							flt_avg_method option(nullable) 		ois_avg_method,	
							    integer				payment_lag,								
								string 				idx_name,
								string 				idx_type,
								integer 			idx_value_days,
								integer 			idx_fixing_days,
								integer 			idx_spot_days,
							    day_count_method option(nullable) 	idx_day_count_method,							   
							    calendar option(nullable) 	idx_calendar,
							    string option(nullable) 	idx_currency,
							    calendar option(nullable) 	idx_suppl_calendar,
								number option(nullable)		idx_spread,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{	
	try{

		if(!equal(idx_type, "IBOR") && !equal (idx_type, "LIBOR") && !equal (idx_type, "RFR"))
			QL_FAIL("index type not applicable", E_INIT);

		ir_index idx = create_ir_index(	idx_name,idx_type,"1D", idx_value_days,idx_fixing_days, idx_day_count_method,
										BD_FOLLOWING, false,
										idx_calendar,//if libor: this is uk
										null<string>,
										idx_currency,
										idx_suppl_calendar,	//if libor: this is primary(ex.target), if ibor: this is null
										null<string>,
										idx_spot_days,idx_spread);
		
		instr_def c = __instr_def_fixois_nodb(instr_def_name,cpn_freq,day_count_method,currency,calendar,bd_convention,
							    				eom, settle_code,maturity_code,payment_lag,ois_comp_avg, ois_spread_comp_method,ois_avg_method,
												ois_arr_type,ois_arr_days,ois_endog_df,idx );

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fixois");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_fixois [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_fixois(string				instr_def_name,	
							    string 				settle_code,
							    string 	option(nullable) maturity_code,								
							 	integer 			cpn_freq,
							    day_count_method 	day_count_method,
							    string 				currency,
							    calendar 			calendar,
							    bd_convention 		bd_convention,
							    logical 			eom,
								rfr_arrears_type option(nullable) 		ois_arr_type,
								number option(nullable)					ois_arr_days,
								logical option(nullable)				ois_endog_df,
								flt_comp_avg_type option(nullable)		ois_comp_avg,
    							flt_sprd_comp_method option(nullable) 	ois_spread_comp_method,
    							flt_avg_method option(nullable) 		ois_avg_method,	
							    integer				payment_lag,								
								ir_index 			on_idx,							
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{	
	try{
		
		instr_def c = __instr_def_fixois_nodb(instr_def_name,cpn_freq,day_count_method,currency,calendar,bd_convention,
							    				eom, settle_code,maturity_code,payment_lag,ois_comp_avg, ois_spread_comp_method,ois_avg_method,
												ois_arr_type,ois_arr_days,ois_endog_df,on_idx );

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fixois");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_swap_fixois   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_swap_fixois(INSTR_TMPL.swap_fixois_def_tmpl		tmpl,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{	
	try{
		QL_REQUIRE(tmpl.fix_currency() == tmpl.ois_currency(),"cross currency fixois not supported in instr_def");
		instr_def c = __instr_def_fixois_nodb(	tmpl.name(),tmpl.fix_cpn_freq(),tmpl.fix_day_count_method(),tmpl.fix_currency(),tmpl.calendar(),
							    				tmpl.bd_convention(), tmpl.eom(),tmpl.spot_settle_code(),
												tmpl.maturity_code(),tmpl.payment_delay(),
												tmpl.ois_comp_avg(),tmpl.ois_spread_comp_method(), tmpl.ois_avg_method(),
												tmpl.ois_arr_type(),tmpl.ois_arr_days(), tmpl.ois_endog_df(),tmpl.ois_ir_index());

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fixois");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_swap_fixois   [NO DATABASE]
  this instr_def will be complete but not date_complete  	
  ----------------------------------------------------------------------*/

instr_def instr_def_swap_fixois(INSTR_TMPL.swap_fixois_def_tmpl		tmpl,
								//string option(nullable) 			fwd_start_code,//override of template value
								string option(nullable) 			maturity_code,//override of template value
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Float')
{	
	try{
		QL_REQUIRE(tmpl.fix_currency() == tmpl.ois_currency(),"cross currency fixois not supported in instr_def");
		//INSTR_TMPL.ir_index_tenor_tmpl idx = tmpl.index();
		//if(null(fwd_start_code))
			//fwd_start_code = tmpl.fwd_start_code();
		if(null(maturity_code))
			maturity_code = tmpl.maturity_code();
		instr_def c = __instr_def_fixois_nodb(	tmpl.name(),tmpl.fix_cpn_freq(),tmpl.fix_day_count_method(),tmpl.fix_currency(),tmpl.calendar(),
							    				tmpl.bd_convention(), tmpl.eom(),tmpl.spot_settle_code(),
												maturity_code,tmpl.payment_delay(),
												tmpl.ois_comp_avg(),tmpl.ois_spread_comp_method(), tmpl.ois_avg_method(),
												tmpl.ois_arr_type(),tmpl.ois_arr_days(),  tmpl.ois_endog_df(),tmpl.ois_ir_index());


		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fixois");
		return null<instr_def>;
	}
}
 

