/*	
	instr_def wrapper functions for swaps
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	


//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/
/*-----------------------------------------------------------------------
  func: instr_def_swap_fltflt
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_fltflt(string 	name ,
							error_info option(nullable) error = null<error_info>) 
option (category: 'Instrument/Interest Rate Swap/Float vs Float')
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_swap_fltflt(), "instr_def not a float-float swap", E_INIT);		
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltflt");
		return null<..instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_bond [NO DATABASE]  [LEGACY]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  use leg1 as the spread leg
  ----------------------------------------------------------------------*/
/*instr_def instr_def_swap_fltflt(string								instr_def_name,
							    string 								spot_code,
								string option(nullable) 			fwd_start_code,	
								string option(nullable) 			maturity_code,		
								notional_exchg_style option(nullable) not_exchange,
								logical option(nullable) 			is_mtm,
								logical option(nullable) 			is_mtm_leg1,	
							 	integer 							flt1_cpn_freq,
								number option(nullable) 			flt1_reset_freq,
							    day_count_method 					flt1_day_count_method,
							    string 								flt1_currency,
							    calendar 							flt1_calendar,
							    bd_convention 						flt1_bd_convention,
							    logical 							flt1_eom,
								flt_comp_avg_type option(nullable)	flt1_comp_avg,
    							flt_sprd_comp_method option(nullable) flt1_spread_comp_method,
    							flt_avg_method option(nullable) 	flt1_avg_method,
	
							    integer 							flt2_cpn_freq,
								number option(nullable) 			flt2_reset_freq,
							    day_count_method 					flt2_day_count_method,
							    string 								flt2_currency,
							    calendar 							flt2_calendar,
							    bd_convention 						flt2_bd_convention,
							    logical 							flt2_eom,
								flt_comp_avg_type option(nullable)	flt2_comp_avg,
    							flt_sprd_comp_method option(nullable) flt2_spread_comp_method,
    							flt_avg_method option(nullable) 	flt2_avg_method,	

								string 								idx1_name,
								string 								idx1_type,
								string 								idx1_tenor,
								integer 							idx1_value_days,
							    day_count_method option(nullable) 	idx1_day_count_method,
							    bd_convention option(nullable) 		idx1_bd_convention,
							    logical option(nullable) 			idx1_eom,
							    calendar option(nullable) 			idx1_calendar,
							    string option(nullable) 			idx1_currency,
							    calendar option(nullable) 			idx1_suppl_calendar,

								string 								idx2_name,
								string 								idx2_type,
								string 								idx2_tenor,
								integer 							idx2_value_days,
							    day_count_method option(nullable) 	idx2_day_count_method,
							    bd_convention option(nullable) 		idx2_bd_convention,
							    logical option(nullable) 			idx2_eom,
							    calendar option(nullable) 			idx2_calendar,
							    string option(nullable) 			idx2_currency,
							    calendar option(nullable) 			idx2_suppl_calendar,								
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float')
{	
	try{	
		if(null(not_exchange)) {
			if( equal_casei(flt2_currency, flt1_currency)) 
				not_exchange = NE_NONE ;
			else 
				not_exchange = NE_BOTH;
		}

		if(!equal(idx1_type, "IBOR") && !equal (idx1_type, "LIBOR"))
			QL_FAIL("index type not applicable", E_INIT);

		integer idx1_spot_days = idx1_value_days;
		
		ir_index idx1 = create_ir_index(idx1_name,
										idx1_type,
										idx1_tenor,
										idx1_value_days,
										null<number>,
										idx1_day_count_method,
										idx1_bd_convention,
										idx1_eom,
										idx1_calendar,//if libor: this is uk
										null<string>,
										idx1_currency,
										idx1_suppl_calendar,	//if libor: this is primary(ex.target), if ibor: this is null
										null<string>,
										idx1_spot_days,0);

		if(!equal(idx2_type, "IBOR") && !equal (idx2_type, "LIBOR"))
			QL_FAIL("index type not applicable", E_INIT);

		integer idx2_spot_days = idx2_value_days;
		
		ir_index idx2 = create_ir_index(idx2_name,
										idx2_type,
										idx2_tenor,
										idx2_value_days,
										null<number>,
										idx2_day_count_method,
										idx2_bd_convention,
										idx2_eom,
										idx2_calendar,//if libor: this is uk
										null<string>,
										idx2_currency,
										idx2_suppl_calendar,	//if libor: this is primary(ex.target), if ibor: this is null
										null<string>,
										idx2_spot_days,0);
		
		instr_def c = __instr_def_fltflt_nodb(	instr_def_name,flt1_cpn_freq,flt1_reset_freq,flt1_day_count_method,flt1_currency,
												flt1_calendar,flt1_bd_convention,
							    				flt1_eom,flt1_comp_avg,flt1_spread_comp_method,flt1_avg_method,idx1,
												
												flt2_cpn_freq,flt2_reset_freq,flt2_day_count_method,flt2_currency,flt2_calendar,
												flt2_bd_convention,flt2_eom,flt2_comp_avg,
							    				flt2_spread_comp_method,flt2_avg_method,idx2,
												spot_code,fwd_start_code,maturity_code,not_exchange,is_mtm,is_mtm_leg1 );

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltflt");
		return null<instr_def>;
	}
}*/

/*-----------------------------------------------------------------------
  func: instr_def_bond [NO DATABASE] 
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  use leg1 as the spread leg
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_fltflt(string								instr_def_name,
							    string 								spot_code,
								string option(nullable) 			fwd_start_code,	
								string option(nullable) 			maturity_code,		
								notional_exchg_style option(nullable) not_exchange,
								logical option(nullable) 			is_mtm,
								logical option(nullable) 			is_mtm_leg1,	
							 	integer 							flt1_cpn_freq,
								number option(nullable) 			flt1_reset_freq,
							    day_count_method 					flt1_day_count_method,
							    string 								flt1_currency,
							    calendar 							flt1_calendar,
							    bd_convention 						flt1_bd_convention,
							    logical 							flt1_eom,
								flt_comp_avg_type option(nullable)	flt1_comp_avg,
    							flt_sprd_comp_method option(nullable) flt1_spread_comp_method,
    							flt_avg_method option(nullable) 	flt1_avg_method,
								flt_stub_fwd_style	option(nullable) 	flt1_sprd_stub_style,
								ir_index 							flt1_idx,
								
							    integer 							flt2_cpn_freq,
								number option(nullable) 			flt2_reset_freq,
							    day_count_method 					flt2_day_count_method,
							    string 								flt2_currency,
							    calendar 							flt2_calendar,
							    bd_convention 						flt2_bd_convention,
							    logical 							flt2_eom,
								flt_comp_avg_type option(nullable)	flt2_comp_avg,
    							flt_sprd_comp_method option(nullable) flt2_spread_comp_method,
    							flt_avg_method option(nullable) 	flt2_avg_method,
								flt_stub_fwd_style	option(nullable) 	flt2_sprd_stub_style,
								ir_index 							flt2_idx,								
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float')
{	
	try{	
		if(null(not_exchange)) {
			if( equal_casei(flt2_currency, flt1_currency)) 
				not_exchange = NE_NONE ;
			else 
				not_exchange = NE_BOTH;
		}
		
		instr_def c = __instr_def_fltflt_nodb(	instr_def_name,flt1_cpn_freq,flt1_reset_freq,flt1_day_count_method,flt1_currency,
												flt1_calendar,flt1_bd_convention,
							    				flt1_eom,flt1_comp_avg,flt1_spread_comp_method,flt1_avg_method,flt1_sprd_stub_style,flt1_idx,
												
												flt2_cpn_freq,flt2_reset_freq,flt2_day_count_method,flt2_currency,flt2_calendar,
												flt2_bd_convention,flt2_eom,flt2_comp_avg,
							    				flt2_spread_comp_method,flt2_avg_method,flt2_sprd_stub_style,flt2_idx,
												spot_code,fwd_start_code,maturity_code,not_exchange,is_mtm,is_mtm_leg1 );

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltflt");
		return null<instr_def>;
	}
}
/*-----------------------------------------------------------------------
  func: instr_def_swap_fltflt   [NO DATABASE]
  this instr_def will be complete but not date_complete	
  ----------------------------------------------------------------------*/

instr_def instr_def_swap_fltflt(INSTR_TMPL.swap_fltflt_def_tmpl		tmpl,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float')
{	
	try{
		logical leg1_mtm;
		logical is_mtm = tmpl.is_mtm(leg1_mtm); 
		instr_def c = __instr_def_fltflt_nodb(	tmpl.name(),tmpl.flt1_cpn_freq(),tmpl.flt1_reset_freq(),tmpl.flt1_day_count_method(),
												tmpl.flt1_currency(),tmpl.flt1_calendar(),tmpl.flt1_bd_convention(), tmpl.flt1_eom(),
												tmpl.flt1_comp_avg(),tmpl.flt1_spread_comp_method(),tmpl.flt1_avg_method(),
												tmpl.flt1_fwd_stub_rate_style(), tmpl.flt1_ir_index(),
							    				tmpl.flt2_cpn_freq(),tmpl.flt2_reset_freq(),tmpl.flt2_day_count_method(),tmpl.flt2_currency(),
												tmpl.flt2_calendar(),tmpl.flt2_bd_convention(), tmpl.flt2_eom(),
												tmpl.flt2_comp_avg(),tmpl.flt2_spread_comp_method(),tmpl.flt2_avg_method(),
												tmpl.flt2_fwd_stub_rate_style(), tmpl.flt2_ir_index(),
												tmpl.spot_settle_code(),tmpl.fwd_start_code(),tmpl.maturity_code(),tmpl.not_exchange(),is_mtm ,leg1_mtm );


		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltflt");
		return null<instr_def>;
	}
}
 

/*-----------------------------------------------------------------------
  func: instr_def_swap_fltflt   [NO DATABASE]
  this instr_def will be complete but not date_complete	
  ----------------------------------------------------------------------*/

instr_def instr_def_swap_fltflt(INSTR_TMPL.swap_fltflt_def_tmpl		tmpl,
								string option(nullable) 			fwd_start_code,
								string 	option(nullable) 			maturity_code,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float')
{	
	try{
		if(null(fwd_start_code))
			fwd_start_code = tmpl.fwd_start_code();
		if(null(maturity_code))
			maturity_code = tmpl.maturity_code();
		
		logical leg1_mtm;
		logical is_mtm = tmpl.is_mtm(leg1_mtm); 
		instr_def c = __instr_def_fltflt_nodb(	tmpl.name(),tmpl.flt1_cpn_freq(),tmpl.flt1_reset_freq(),tmpl.flt1_day_count_method(),
												tmpl.flt1_currency(),tmpl.flt1_calendar(),tmpl.flt1_bd_convention(), tmpl.flt1_eom(),
												tmpl.flt1_comp_avg(),tmpl.flt1_spread_comp_method(),tmpl.flt1_avg_method(),
												tmpl.flt1_fwd_stub_rate_style(), tmpl.flt1_ir_index(),
							    				tmpl.flt2_cpn_freq(),tmpl.flt2_reset_freq(),tmpl.flt2_day_count_method(),tmpl.flt2_currency(),
												tmpl.flt2_calendar(),tmpl.flt2_bd_convention(), tmpl.flt2_eom(),
												tmpl.flt2_comp_avg(),tmpl.flt2_spread_comp_method(),tmpl.flt2_avg_method(),
												tmpl.flt2_fwd_stub_rate_style(), tmpl.flt2_ir_index(),
												tmpl.spot_settle_code(),fwd_start_code,maturity_code,tmpl.not_exchange(),is_mtm,leg1_mtm);


		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltflt");
		return null<instr_def>;
	}
}
 

