/*	
	instr_def wrapper functions for swaps
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	


//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/
/*-----------------------------------------------------------------------
  func: instr_def_swap_fltflt2s
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_fltflt2s(string 	name ,
							error_info option(nullable) error = null<error_info>) 
option (category: 'Instrument/Interest Rate Swap/Float vs Float (2-swap)')
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_swap_fltflt2s(), "instr_def not a float-float (2 swaps) swap", E_INIT);		
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltflt2s");
		return null<..instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_swap_fltflt2s [NO DATABASE]  [LEGACY]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_fltflt2s(string			instr_def_name,	
							    string 				settle_code,
								string option(nullable) maturity_code,									
							 	integer 			fix_cpn_freq,
							    day_count_method 	fix_day_count_method,									
								integer 			flt_sprd_cpn_freq,
								  
								number option(nullable) 			flt_sprd_reset_freq,
							    day_count_method 					flt_sprd_day_count_method,	
								flt_comp_avg_type option(nullable)	flt_sprd_comp_avg,
    							flt_sprd_comp_method option(nullable) flt_sprd_spread_comp_method,
    							flt_avg_method option(nullable) 	flt_sprd_avg_method,
							    
							    integer 							flt_flat_cpn_freq,
								number option(nullable)	 			flt_flat_reset_freq,
							    day_count_method 					flt_flat_day_count_method,
								flt_comp_avg_type option(nullable)	flt_flat_comp_avg,
    							flt_sprd_comp_method option(nullable) flt_flat_spread_comp_method,
    							flt_avg_method option(nullable) 	flt_flat_avg_method,
								  
							    string 				currency,
							    calendar 			calendar,
							    bd_convention 		bd_convention,
							    logical 			eom,
								  
								string 				idx_sprd_name,
								  string 			idx_sprd_type,
								string 				idx_sprd_tenor,
								integer 			idx_sprd_value_days,
							    day_count_method option(nullable) 	idx_sprd_day_count_method,
							    bd_convention option(nullable) 		idx_sprd_bd_convention,
							    logical option(nullable) 	idx_sprd_eom,
							    calendar option(nullable) 	idx_sprd_calendar,
							    string option(nullable) 	idx_sprd_currency,
							    calendar option(nullable) 	idx_sprd_suppl_calendar,
								  
								string 				idx_flat_name,
								 string 			idx_flat_type,
								string 				idx_flat_tenor,
								integer 			idx_flat_value_days,
							    day_count_method option(nullable) 	idx_flat_day_count_method,
							    bd_convention option(nullable) 		idx_flat_bd_convention,
							    logical option(nullable) 	idx_flat_eom,
							    calendar option(nullable) 	idx_flat_calendar,
							    string option(nullable) 	idx_flat_currency,
							    calendar option(nullable) 	idx_flat_suppl_calendar,								
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float (2-swap)')
{	
	try{
		notional_exchg_style not_exchange = NE_NONE ;

		if(!equal(idx_sprd_type, "IBOR") && !equal (idx_sprd_type, "LIBOR"))
			QL_FAIL("index type not applicable", E_INIT);

		integer idx_sprd_spot_days = idx_sprd_value_days;
		
		ir_index flt_sprd_idx = create_ir_index(	idx_sprd_name,idx_sprd_type,
										idx_sprd_tenor,
										idx_sprd_value_days,
										null<number>,
										idx_sprd_day_count_method,
										idx_sprd_bd_convention,
										idx_sprd_eom,
										idx_sprd_calendar,//if libor: this is uk
										null<string>,
										idx_sprd_currency,
										idx_sprd_suppl_calendar,	//if libor: this is primary(ex.target), if ibor: this is null
										null<string>,
										idx_sprd_spot_days,0);

		if(!equal(idx_flat_type, "IBOR") && !equal (idx_flat_type, "LIBOR"))
			QL_FAIL("index type not applicable", E_INIT);

		integer idx_flat_spot_days = idx_flat_value_days;
		
		ir_index flt_flat_idx = create_ir_index(idx_flat_name,idx_flat_type,
										idx_flat_tenor,
										idx_flat_value_days,
										null<number>,
										idx_flat_day_count_method,
										idx_flat_bd_convention,
										idx_flat_eom,
										idx_flat_calendar,//if libor: this is uk
										null<string>,
										idx_flat_currency,
										idx_flat_suppl_calendar,	//if libor: this is primary(ex.target), if ibor: this is null
										null<string>,
										idx_flat_spot_days,0);
		
		instr_def c = __instr_def_fltflt2s_nodb(instr_def_name,fix_cpn_freq, fix_day_count_method,
												calendar,bd_convention, eom,currency,
												flt_sprd_cpn_freq,
												flt_sprd_reset_freq,flt_sprd_day_count_method,
												flt_sprd_comp_avg,flt_sprd_spread_comp_method,flt_sprd_avg_method,null,
												flt_sprd_idx,
												flt_flat_cpn_freq,flt_flat_reset_freq,flt_flat_day_count_method,
												flt_flat_comp_avg,flt_flat_spread_comp_method,flt_flat_avg_method,null,
												flt_flat_idx,
												settle_code,maturity_code,not_exchange);

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltflt2s");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_swap_fltflt2s [NO DATABASE]  
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_fltflt2s(string			instr_def_name,	
							    string 				settle_code,
								string option(nullable) maturity_code,									
							 	integer 			fix_cpn_freq,
							    day_count_method 	fix_day_count_method,
							    string 				fix_currency,
							    calendar 			fix_calendar,
							    bd_convention 		fix_bd_convention,
							    logical 			fix_eom,
								  
								integer 							flt_sprd_cpn_freq,
								number option(nullable) 			flt_sprd_reset_freq,
							    day_count_method 					flt_sprd_day_count_method,	
								flt_comp_avg_type option(nullable)	flt_sprd_comp_avg,
    							flt_sprd_comp_method option(nullable) flt_sprd_spread_comp_method,
    							flt_avg_method option(nullable) 	flt_sprd_avg_method,
								flt_stub_fwd_style	option(nullable) 	flt_sprd_stub_style,
							    ir_index 							flt_sprd_idx,
								  
							    integer 							flt_flat_cpn_freq,
								number option(nullable)	 			flt_flat_reset_freq,
							    day_count_method 					flt_flat_day_count_method,
								flt_comp_avg_type option(nullable)	flt_flat_comp_avg,
    							flt_sprd_comp_method option(nullable) flt_flat_spread_comp_method,
    							flt_avg_method option(nullable) 	flt_flat_avg_method,
								flt_stub_fwd_style	option(nullable) flt_flat_stub_style,
								ir_index 							flt_flat_idx,								
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float (2-swap)')
{	
	try{
		notional_exchg_style not_exchange = NE_NONE ;
			
		instr_def c = __instr_def_fltflt2s_nodb(instr_def_name,fix_cpn_freq, fix_day_count_method,												
												fix_calendar,fix_bd_convention,
							    				fix_eom,fix_currency,
												flt_sprd_cpn_freq,
												flt_sprd_reset_freq,flt_sprd_day_count_method,
												flt_sprd_comp_avg,flt_sprd_spread_comp_method,flt_sprd_avg_method,
												flt_sprd_stub_style,flt_sprd_idx,
												flt_flat_cpn_freq,flt_flat_reset_freq,flt_flat_day_count_method,
												flt_flat_comp_avg,flt_flat_spread_comp_method,flt_flat_avg_method,
												flt_flat_stub_style,flt_flat_idx,settle_code,maturity_code,not_exchange );

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltflt2s");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_swap_fltflt2s   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_swap_fltflt2s(INSTR_TMPL.swap_fltflt2s_def_tmpl		tmpl,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float (2-swap)')
{	
	try{
		
		instr_def c = __instr_def_fltflt2s_nodb(tmpl.name(),tmpl.fix_cpn_freq(),tmpl.fix_day_count_method(),
												tmpl.calendar(),tmpl.fix_bd_convention(), tmpl.fix_eom(),tmpl.currency(),
												tmpl.flt_sprd_cpn_freq(),tmpl.flt_sprd_reset_freq(),tmpl.flt_sprd_day_count_method(),
												tmpl.flt_sprd_comp_avg(),tmpl.flt_sprd_spread_comp_method(),tmpl.flt_sprd_avg_method(),
												tmpl.flt_sprd_fwd_stub_rate_style(), tmpl.flt_sprd_ir_index(),
												tmpl.flt_flat_cpn_freq(),tmpl.flt_flat_reset_freq(),tmpl.flt_flat_day_count_method(),
												tmpl.flt_flat_comp_avg(),tmpl.flt_flat_spread_comp_method(),tmpl.flt_flat_avg_method(),
												tmpl.flt_flat_fwd_stub_rate_style(), tmpl.flt_flat_ir_index(),
												tmpl.spot_settle_code(),
												tmpl.maturity_code(),tmpl.not_exchange());


		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltflt2s");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_swap_fltflt2s   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_swap_fltflt2s(INSTR_TMPL.swap_fltflt2s_def_tmpl		tmpl,
								  string 	option(nullable) 			maturity_code,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float (2-swap)')
{	
	try{
		if(null(maturity_code))
			maturity_code = tmpl.maturity_code();
		
		instr_def c = __instr_def_fltflt2s_nodb(tmpl.name(),tmpl.fix_cpn_freq(),tmpl.fix_day_count_method(),
												tmpl.calendar(),tmpl.fix_bd_convention(), tmpl.fix_eom(),tmpl.currency(),
												tmpl.flt_sprd_cpn_freq(),tmpl.flt_sprd_reset_freq(),tmpl.flt_sprd_day_count_method(),
												tmpl.flt_sprd_comp_avg(),tmpl.flt_sprd_spread_comp_method(),tmpl.flt_sprd_avg_method(),
												tmpl.flt_sprd_fwd_stub_rate_style(), tmpl.flt_sprd_ir_index(),
												tmpl.flt_flat_cpn_freq(),tmpl.flt_flat_reset_freq(),tmpl.flt_flat_day_count_method(),
												tmpl.flt_flat_comp_avg(),tmpl.flt_flat_spread_comp_method(),tmpl.flt_flat_avg_method(),
												tmpl.flt_flat_fwd_stub_rate_style(), tmpl.flt_flat_ir_index(),
												tmpl.spot_settle_code(),
												maturity_code,tmpl.not_exchange());


		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltflt2s");
		return null<instr_def>;
	}
}
 

