/*	
	instr_def wrapper functions for fltois  -single currency
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	


//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/
/*-----------------------------------------------------------------------
  func: instr_def_swap_fltois
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_fltois(string 	name ,
								error_info option(nullable) error = null<error_info>) 
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex')
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_swap_fltois(), "instr_def not an float-ois", E_INIT);		
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltois");
		return null<..instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_fltois [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
/*instr_def instr_def_swap_fltois(string				instr_def_name,	
								string 				settle_code,
								string option(nullable) maturity_code,									
							 	integer 			cpn_freq,
							    day_count_method 	day_count_method,
							    string 				currency,
							    calendar 			calendar,
							    bd_convention 		bd_convention,
							    logical 			eom,
								rfr_arrears_type option(nullable) 		ois_arr_type,
								number option(nullable)					ois_arr_days,
								logical option(nullable)				ois_endog_df,
								logical option(nullable)				ois_approx_calc,
								flt_comp_avg_type option(nullable)		ois_comp_avg,
    							flt_sprd_comp_method option(nullable) 	ois_spread_comp_method,
    							flt_avg_method option(nullable) 		ois_avg_method,								
							    integer				payment_lag,								
								string 				idx_name,
								string 				idx_type,
								string 				idx_tenor,
								integer 			idx_value_days,
							    day_count_method option(nullable) 	idx_day_count_method,
							    bd_convention option(nullable) 		idx_bd_convention,
							    logical option(nullable) 	idx_eom,
							    calendar option(nullable) 	idx_calendar,
							    string option(nullable) 	idx_currency,
							    calendar option(nullable) 	idx_suppl_calendar,	
								string 				idx_on_name,
								string 				idx_on_type,	
								integer 			idx_on_value_days,
								integer 			idx_on_fixing_days,
								integer 			idx_on_spot_days,
							    day_count_method option(nullable) 	idx_on_day_count_method,							   
							    calendar option(nullable) 	idx_on_calendar,
							    string option(nullable) 	idx_on_currency,
							    calendar option(nullable) 	idx_on_suppl_calendar,
								number option(nullable) 	idx_spread,	
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex')
{	
	try{

		if(!equal(idx_type, "IBOR") && !equal (idx_type, "LIBOR"))
			QL_FAIL("index type not applicable", E_INIT);

		integer idx_spot_days = idx_value_days;
		integer idx_reset_days = idx_value_days;
		
		ir_index idx = create_ir_index(	idx_name,idx_type,
										idx_tenor,
										idx_value_days,
										idx_reset_days,
										idx_day_count_method,
										idx_bd_convention,
										idx_eom,
										idx_calendar,//if libor: this is uk
										null<string>,
										idx_currency,
										idx_suppl_calendar,	//if libor: this is primary(ex.target), if ibor: this is null
										null<string>,
										idx_spot_days,0);
		
		if(!equal(idx_on_type, "IBOR") && !equal (idx_on_type, "LIBOR") && !equal (idx_on_type, "RFR"))
			QL_FAIL("index type not applicable", E_INIT);

		ir_index on_idx = create_ir_index(	idx_on_name,idx_on_type,"1D", idx_on_value_days,idx_on_fixing_days, idx_on_day_count_method,
										BD_FOLLOWING, false,
										idx_on_calendar,//if libor: this is uk
										null<string>,
										idx_on_currency,
										idx_on_suppl_calendar,	//if libor: this is primary(ex.target), if ibor: this is null
										null<string>,
										idx_on_spot_days,idx_spread);
		
		instr_def c = __instr_def_fltois_nodb(instr_def_name,settle_code, maturity_code,payment_lag,payment_lag,notional_exchg_style.NE_NONE,false,false,
												cpn_freq,cpn_freq,day_count_method,currency,calendar,bd_convention, eom,null,null,null,
												null<flt_stub_fwd_style>,
												idx,
												cpn_freq,day_count_method,currency,calendar,bd_convention, eom,
												ois_comp_avg, ois_spread_comp_method,ois_avg_method,
												ois_arr_type,ois_arr_days,ois_endog_df,ois_approx_calc,
												on_idx );

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltois");
		return null<instr_def>;
	}
}*/

/*-----------------------------------------------------------------------
  func: instr_def_fltois [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_fltois(string				instr_def_name,	
								string 				settle_code,
								string option(nullable) maturity_code,							 	
							    string 				currency,
							    calendar 			calendar,
							    bd_convention 		bd_convention,
							    logical 			eom,
								integer				payment_lag,
								/*flt*/
								integer 			flt_cpn_freq,
							    day_count_method 	flt_day_count_method,
								ir_index 			flt_idx,
								/*ois*/
								integer 								ois_cpn_freq,
							    day_count_method 						ois_day_count_method,
								rfr_arrears_type option(nullable) 		ois_arr_type,
								number option(nullable)					ois_arr_days,
								logical	option(nullable)				ois_endog_df,
								logical option(nullable)				ois_approx_calc,
								flt_comp_avg_type option(nullable)		ois_comp_avg,
    							flt_sprd_comp_method option(nullable) 	ois_spread_comp_method,
    							flt_avg_method option(nullable) 		ois_avg_method,															    																	
								ir_index 								ois_idx,							
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex')
{	
	try{

		instr_def c = __instr_def_fltois_nodb(instr_def_name,settle_code, maturity_code,payment_lag,payment_lag,notional_exchg_style.NE_NONE,false,false,
												/*flt*/
											  flt_cpn_freq,flt_cpn_freq,flt_day_count_method,currency,calendar,bd_convention, eom,null,null,null,
												null<flt_stub_fwd_style>,flt_idx,
											  /*ois*/
												ois_cpn_freq,ois_day_count_method,currency,calendar,bd_convention, eom,
												ois_comp_avg, ois_spread_comp_method,ois_avg_method,
												ois_arr_type,ois_arr_days,ois_endog_df,ois_approx_calc,
												ois_idx );

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltois");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_swap_fltois   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_swap_fltois(INSTR_TMPL.swap_fltois_def_tmpl		tmpl,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex')
{	
	try{
		
		/*instr_def c = __instr_def_fltois_nodb(	tmpl.name(),tmpl.cpn_freq(),tmpl.day_count_method(),tmpl.flt_currency(),tmpl.calendar(),
							    				tmpl.bd_convention(), tmpl.eom(),tmpl.spot_settle_code(),tmpl.maturity_code(),tmpl.payment_delay(),
												tmpl.flt_ir_index(),
												tmpl.ois_comp_avg(),tmpl.ois_spread_comp_method(), tmpl.ois_avg_method(),
												tmpl.ois_arr_type(),tmpl.ois_arr_days(),tmpl.ois_endog_df(),												
												tmpl.ois_ir_index());*/
		logical leg1_mtm;
		logical is_mtm = tmpl.is_mtm(leg1_mtm); 
		instr_def c = __instr_def_fltois_nodb(	tmpl.name(),tmpl.spot_settle_code(),tmpl.maturity_code(), tmpl.payment_delay(),tmpl.payment_delay_prin(),
												tmpl.not_exchange(),is_mtm,leg1_mtm,
												
												tmpl.flt_cpn_freq(),tmpl.flt_reset_freq(),tmpl.flt_day_count_method(),tmpl.flt_currency(),tmpl.flt_calendar(),
												tmpl.flt_bd_convention(), tmpl.flt_eom() ,null,null,null,tmpl.flt_fwd_stub_rate_style(),
												tmpl.flt_ir_index(),
											  
												tmpl.ois_cpn_freq(),tmpl.ois_day_count_method(),tmpl.ois_currency(),tmpl.ois_calendar(),tmpl.ois_bd_convention(), tmpl.ois_eom(),
												tmpl.ois_comp_avg(), tmpl.ois_spread_comp_method(),tmpl.ois_avg_method(),
												tmpl.ois_arr_type(),tmpl.ois_arr_days(),tmpl.ois_endog_df(),tmpl.ois_approx_calc(),
												tmpl.ois_ir_index() );

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltois");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_swap_fltois   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_swap_fltois(INSTR_TMPL.swap_fltois_def_tmpl		tmpl,
								string option(nullable) 			maturity_code,//override of template value
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex')
{	
	try{
	
		if(null(maturity_code))
			maturity_code = tmpl.maturity_code();
		logical leg1_mtm;
		logical is_mtm = tmpl.is_mtm(leg1_mtm); 
		instr_def c = __instr_def_fltois_nodb(	tmpl.name(),tmpl.spot_settle_code(),maturity_code, tmpl.payment_delay(),tmpl.payment_delay_prin(),
												tmpl.not_exchange(),is_mtm,leg1_mtm,
												
												tmpl.flt_cpn_freq(),tmpl.flt_reset_freq(),tmpl.flt_day_count_method(),tmpl.flt_currency(),tmpl.flt_calendar(),
												tmpl.flt_bd_convention(), tmpl.flt_eom() ,null,null,null,tmpl.flt_fwd_stub_rate_style(),
												tmpl.flt_ir_index(),
											  
												tmpl.ois_cpn_freq(),tmpl.ois_day_count_method(),tmpl.ois_currency(),tmpl.ois_calendar(),tmpl.ois_bd_convention(), tmpl.ois_eom(),
												tmpl.ois_comp_avg(), tmpl.ois_spread_comp_method(),tmpl.ois_avg_method(),
												tmpl.ois_arr_type(),tmpl.ois_arr_days(),tmpl.ois_endog_df(),tmpl.ois_approx_calc(),
												tmpl.ois_ir_index());

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltois");
		return null<instr_def>;
	}
}
 

