/*	
	instr_def wrapper functions for swaps
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	


//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/
/*-----------------------------------------------------------------------
  func: instr_def_swap_fltois2s
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_fltois2s(string 	name ,
							error_info option(nullable) error = null<error_info>) 
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex (2-swap)')
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_swap_fltois2s(), "instr_def not a float-ois (2 swaps) swap", E_INIT);		
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltois2s");
		return null<..instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_swap_fltois2s [NO DATABASE]  
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_fltois2s( 	string 						instr_def_name ,
									string						settle_code,
									string	option(nullable)	maturity_code,
									calendar 					calendar,
									string 						currency,
									integer						fixf_cpn_freq,
									day_count_method			fixf_day_count_method,
									integer						fixo_cpn_freq,
									day_count_method			fixo_day_count_method,

									integer						flt_cpn_freq,
									number	option(nullable)	flt_reset_freq,
									day_count_method			flt_day_count_method,
									bd_convention				flt_bd_convention,
									logical						flt_eom,
									interest_rule				flt_ir_rule,
									..flt_comp_avg_type option(nullable)	flt_sprd_comp_avg,
									..flt_sprd_comp_method option(nullable) flt_sprd_spread_comp_method,
									..flt_avg_method option(nullable) 		flt_avg_method,
									flt_stub_fwd_style	option(nullable) 	flt_stub_style,
									integer						flt_pmt_lag,
									integer						flt_pmt_lag_prin,
									ir_index 					flt_ir_index,

									integer						ois_cpn_freq,
									day_count_method			ois_day_count_method,
									bd_convention				ois_bd_convention,
									logical						ois_eom,
									interest_rule				ois_ir_rule,
									..flt_comp_avg_type option(nullable)	ois_sprd_comp_avg,
									..flt_sprd_comp_method option(nullable) ois_sprd_spread_comp_method,
									..flt_avg_method option(nullable) 		ois_avg_method,
									integer						ois_pmt_lag,
									integer						ois_pmt_lag_prin,
									ir_index  					ois_ir_index, 								
									error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex (2-swap)')
{	
	try{
			
		instr_def c = __instr_def_fltois2s_nodb(instr_def_name ,
												settle_code,
												maturity_code,
												calendar,
												currency,
												fixf_cpn_freq,
												fixf_day_count_method,
												fixo_cpn_freq,
												fixo_day_count_method,

												flt_cpn_freq,
												flt_reset_freq,
												flt_day_count_method,
												flt_bd_convention,
												flt_eom,
												flt_ir_rule,
												flt_sprd_comp_avg,
												flt_sprd_spread_comp_method,
												flt_avg_method,flt_stub_style,
												flt_pmt_lag,
												flt_pmt_lag_prin,
												flt_ir_index,

												ois_cpn_freq,
												ois_day_count_method,
												ois_bd_convention,
												ois_eom,
												ois_ir_rule,
												ois_sprd_comp_avg,
												ois_sprd_spread_comp_method,
												ois_avg_method,
												ois_pmt_lag,
												ois_pmt_lag_prin,
												ois_ir_index);
		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltois2s");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_swap_fltois2s   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_swap_fltois2s(INSTR_TMPL.swap_fltois2s_def_tmpl		tmpl,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex (2-swap)')
{	
	try{
		
		instr_def c = __instr_def_fltois2s_nodb(tmpl.name(), tmpl.spot_settle_code(), null,tmpl.calendar(),tmpl.currency(),
												tmpl.fixf_cpn_freq(),tmpl.fixf_day_count_method(),
												tmpl.fixo_cpn_freq(),tmpl.fixo_day_count_method(),
												
												tmpl.flt_cpn_freq(),tmpl.flt_reset_freq(),tmpl.flt_day_count_method(),
												tmpl.flt_bd_convention(),tmpl.flt_eom(),tmpl.flt_ir_rule(),
												tmpl.flt_comp_avg(),tmpl.flt_spread_comp_method(),tmpl.flt_avg_method(),
												tmpl.flt_fwd_stub_rate_style(),
												tmpl.flt_payment_delay(),tmpl.flt_payment_delay_prin(),tmpl.flt_ir_index(),
																																				
												tmpl.ois_cpn_freq(),tmpl.ois_day_count_method(),
												tmpl.ois_bd_convention(),tmpl.ois_eom(),tmpl.ois_ir_rule(),
												tmpl.ois_comp_avg(),tmpl.ois_spread_comp_method(),tmpl.ois_avg_method(),
												tmpl.ois_payment_delay(),tmpl.ois_payment_delay_prin(),tmpl.ois_ir_index());


		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltois2s");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_swap_fltois2s   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_swap_fltois2s(	INSTR_TMPL.swap_fltois2s_def_tmpl		tmpl,
									string 	option(nullable) 			maturity_code,
									error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex (2-swap)')
{	
	try{
		if(null(maturity_code))
			maturity_code = tmpl.maturity_code();
		
		instr_def c = __instr_def_fltois2s_nodb(tmpl.name(), tmpl.spot_settle_code(), maturity_code,tmpl.calendar(),tmpl.currency(),
												tmpl.fixf_cpn_freq(),tmpl.fixf_day_count_method(),
												tmpl.fixo_cpn_freq(),tmpl.fixo_day_count_method(),
												
												tmpl.flt_cpn_freq(),tmpl.flt_reset_freq(),tmpl.flt_day_count_method(),
												tmpl.flt_bd_convention(),tmpl.flt_eom(),tmpl.flt_ir_rule(),
												tmpl.flt_comp_avg(),tmpl.flt_spread_comp_method(),tmpl.flt_avg_method(),
												tmpl.flt_fwd_stub_rate_style(),
												tmpl.flt_payment_delay(),tmpl.flt_payment_delay_prin(),tmpl.flt_ir_index(),
																																				
												tmpl.ois_cpn_freq(),tmpl.ois_day_count_method(),
												tmpl.ois_bd_convention(),tmpl.ois_eom(),tmpl.ois_ir_rule(),
												tmpl.ois_comp_avg(),tmpl.ois_spread_comp_method(),tmpl.ois_avg_method(),
												tmpl.ois_payment_delay(),tmpl.ois_payment_delay_prin(),tmpl.ois_ir_index() );


		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fltois2s");
		return null<instr_def>;
	}
}
 