/*	
	instr_def wrapper functions for fra
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	// Throw error if a null value is used in a non-nullable context


//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/
/*-----------------------------------------------------------------------
  func: instr_def_fra
  ----------------------------------------------------------------------*/
instr_def instr_def_fra(string 	class_instr_name ,
						error_info option(nullable) error = null<error_info>)
option(com_name: 'instr_def_fra_db')
option (category: 'Instrument/Fra')
{	
	try{
		logical is_class_name;
		..instr_def c = instr_def(class_instr_name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_fra(), "instr_def not a fra", E_INIT);		
		return c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_fra");
		return null<..instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_fra[NO DATABASE] [LEGACY]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_fra(	string 						instr_def_name,
							date option(nullable) 		expiry_settle_date,
							string option(nullable) 	expiry_settle_code,
							date option(nullable) 		underl_maturity,
							string option(nullable) 	underl_maturity_code,
							logical option(nullable) 	mat_code_off_trade,
							day_count_method 			day_count_method, 
							bd_convention 				bd_convention ,
							logical						eom ,
							calendar					calendar,
							string						currency,
							fra_calc_method				fra_style,
							string 						idx_name,
							string 						idx_type,
							string 						idx_tenor,
							integer 					idx_value_days,
						    day_count_method option(nullable) idx_day_count_method 	= null<day_count_method>,
						    bd_convention option(nullable) idx_bd_convention 		= null<bd_convention>,
						    logical option(nullable) 	idx_eom 					= null<logical>,
						    calendar option(nullable) 	idx_calendar 				= null<calendar>,
						    string option(nullable) 	idx_currency 				= null<string>,
						    calendar option(nullable) 	idx_suppl_calendar 			= null<calendar>,					   
						    //number option(nullable) 	idx_fixing_days,
							error_info option(nullable) error 						= null<error_info>)
option(com_name: 'instr_def_fra')
option (category: 'Instrument/Fra')
{	
	try{	

		if(!equal(idx_type, "IBOR") && !equal (idx_type, "LIBOR"))
			QL_FAIL("index type not applicable", E_INIT);

		integer idx_spot_days = idx_value_days;
		if(null(idx_day_count_method))  idx_day_count_method = day_count_method;
		if(null(idx_bd_convention))  	idx_bd_convention = bd_convention;
		if(null(idx_eom))  				idx_eom = eom;
		if(null(idx_calendar))  		idx_calendar = calendar;
		if(null(idx_currency))  		idx_currency = currency;
		if(null(idx_suppl_calendar))  	idx_suppl_calendar = calendar;
		
		ir_index idx = create_ir_index(	idx_name,
										idx_type,
										idx_tenor,
										idx_value_days,
										null<number>,
										idx_day_count_method,
										idx_bd_convention,
										idx_eom,
										idx_calendar,//if libor: this is uk
										null<string>,
										idx_currency,
										idx_suppl_calendar,	//if libor: this is primary(ex.target), if ibor: this is null
										null<string>,
										idx_spot_days,0);
		
		instr_def c = __instr_def_fra_nodb(	instr_def_name, expiry_settle_date,expiry_settle_code,
											underl_maturity,underl_maturity_code,mat_code_off_trade,day_count_method, bd_convention, eom,calendar,
											currency,fra_style,idx);

		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_fra");
		return null<instr_def>;
	}
}


instr_def create_fra_instr_def(	day_count_method 	day_count_method, 
								bd_convention 		bd_convention ,
								logical				eom ,
								date option(nullable) 		expiry_settle_date,
								string option(nullable) 	expiry_settle_code,
								date option(nullable) 		underl_maturity,
								string option(nullable) 	underl_maturity_code,
								logical option(nullable) 	mat_code_off_trade,								
								calendar			calendar,
								string				currency,
								string				tenor,
								integer 			fixing_days)
option(com_name: 'LEGACY_create_fra_instr_def')
{	
	return instr_def_fra(	"fra_def",expiry_settle_date,expiry_settle_code,
							underl_maturity,underl_maturity_code,mat_code_off_trade,day_count_method, 
							bd_convention, eom,calendar, currency, fra_calc_method.BBA,"IBOR","IBOR", 
							tenor,fixing_days,null<day_count_method>,null<bd_convention>,null<logical>,
							null<calendar>,null<string>,null<calendar>);
}


/*-----------------------------------------------------------------------
  func: instr_def_fra   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_fra(INSTR_TMPL.fra_def_tmpl				tmpl,
						error_info option(nullable) error = null<error_info>)
option(com_name: 'instr_def_fra_tmpl')	
option (category: 'Instrument/Fra')
{	
	try{
		/*if(!null(tmpl.index().value_days()) && !null(tmpl.index().fixing_days()) && tmpl.index().value_days() != tmpl.index().fixing_days())
			QL_FAIL("value days <> fixing days is not supported for fra");
		if(null(tmpl.index().value_days()) && !null(tmpl.index().fixing_days()))
			QL_FAIL("value days <> fixing days is not supported for fra");		
			*/	
		
		instr_def c = __instr_def_fra_nodb(	tmpl.name(),tmpl.expiry_settle_date(),tmpl.expiry_settle_code(),
											tmpl.underl_maturity(),tmpl.underl_maturity_code(),tmpl.mat_code_off_trade(),
											tmpl.day_count_method(), tmpl.bd_convention(), tmpl.eom(), 											
											tmpl.calendar(), 
											tmpl.currency(),tmpl.fra_style(), tmpl.ir_index());


		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_fra");
		return null<instr_def>;
	}
}
 
