/*	
	instr_def wrapper functions for frn
	Developer: Algorithmica Research, Magnus Nyström			
*/

//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have 
*/
/*-----------------------------------------------------------------------
  func: instr_def_frn
  ----------------------------------------------------------------------*/
instr_def instr_def_frn(string 						name ,
						error_info option(nullable) error = null<error_info>)
option(com_name: 'instr_def_frn_db')
option (category: 'Instrument/Frn')
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_frn(), "instr_def not a frn", E_INIT);		
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_frn");
		return null<..instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_frn 
  ----------------------------------------------------------------------*/
/*instr_def instr_def_frn(	instr_def 	instr_def,
							string		name,
							number 		fix_margin,
							vector(date) option(nullable)	fixing_dates,
							vector(number)	option(nullable) fixing_rates,
							number option(nullable) first_fixing,
						    number option(nullable) last_fixing,
						    number option(nullable) fix_proxy, 
						    logical  option(nullable) allow_fwd_fix,
							out instr_error option(nullable) error)
option (category: 'Curve and Instrument/Frn')
{	
	try{	
		
		..instr_def c = __instr_def_frn(instr_def, name,fix_margin,fixing_dates,fixing_rates,  
										first_fixing,last_fixing,fix_proxy, allow_fwd_fix);

		QL_FAIL_COND(null(c), "null instr_def");//should not happen
		
		if(!c.is_valid(error))
			return INSTR_CREATE_NULL_ERR ? null<instr_def> : c; 
		else
			return c;						
	}
	catch {
		set_error(error,ERR_T_INIT,err.message());
		return null<..instr_def>;
	}
}

*/

/*-----------------------------------------------------------------------
  func: instr_def_frn[NO DATABASE]
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
/*instr_def instr_def_frn(string 			instr_def_name,
						date 					issue_date,
						date option(nullable) 	first_cpn_date,
						date option(nullable) 	last_reg_cpn_date,
						date 					maturity,
						integer 				cpn_freq,
						integer 				roll_day,
						number 					fix_margin,       
						frn_roll_method 		roll_method,   
						day_count_method 		day_count_method,
						bd_convention 			bd_convention,
						calendar 				pmt_calendar,
						calendar option(nullable) fix_calendar,
						logical 				eom,  
						string 					ex_cpn_code,
						string 					settle_code,
						string 					fixing_code,
						string 					currency,
						vector(date) option(nullable)	fixing_dates,
						vector(number)	option(nullable) fixing_rates,
						out instr_error option(nullable) error)
option (category: 'Instrument/Frn')
{	
	try{	
		
		instr_def c = __instr_def_frn_nodb(instr_def_name,issue_date,first_cpn_date,last_reg_cpn_date,maturity,cpn_freq,
										roll_day,fix_margin, roll_method, day_count_method,bd_convention,pmt_calendar,
										fix_calendar, eom,  ex_cpn_code,settle_code,fixing_code,currency,
										fixing_dates,fixing_rates );

		QL_FAIL_COND(null(c), "null instr_def");//should not happen
		
		if(!c.is_valid(error))
			return null<instr_def>; 
		else
			return c;						
	}
	catch {
		set_error(error,ERR_T_INIT,err.message());
		return null<instr_def>;
	}
}
 
*/


/*-----------------------------------------------------------------------
  func: instr_def_frn[NO DATABASE]  [LEGACY]
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_frn(string 					instr_def_name,
						vector(date)			payment_dates,
						number					fix_margin,
						integer 				cpn_freq,						       						 
						day_count_method 		day_count_method,
						bd_convention 			bd_convention,
						calendar 				pmt_calendar,					
						//logical 				eom,  
						string 					ex_cpn_code,
						string 					settle_code,						
						string 					currency,
						frn_neg_rate_rule		neg_rate_rule,
						string 								idx_name,
						string 								idx_type,
						string 								idx_tenor,
						integer 							idx_value_days,
					    day_count_method option(nullable) 	idx_day_count_method,
					    bd_convention option(nullable) 		idx_bd_convention,
					    logical  							idx_eom,
					    calendar option(nullable) 			idx_calendar,
					    string option(nullable) 			idx_currency,
					    calendar option(nullable) 			idx_suppl_calendar,						    						    
						error_info option(nullable) error = null<error_info>)
option(com_name: 'instr_def_frn')
option (category: 'Instrument/Frn')
{	
	try{	

		if(!equal(idx_type, "IBOR") && !equal (idx_type, "LIBOR"))
			QL_FAIL("index type not applicable", E_INIT);

		integer idx_spot_days = idx_value_days;
		if(null(idx_day_count_method))  idx_day_count_method = day_count_method;
		if(null(idx_bd_convention))  	idx_bd_convention = bd_convention;
		//if(null(idx_eom))  				idx_eom = eom;
		if(null(idx_calendar))  		idx_calendar = pmt_calendar;
		if(null(idx_currency))  		idx_currency = currency;
		if(null(idx_suppl_calendar))  	idx_suppl_calendar = pmt_calendar;
		
		ir_index idx = create_ir_index(	idx_name,
										idx_type,
										idx_tenor,
										idx_value_days,
										null<number>,
										idx_day_count_method,
										idx_bd_convention,
										idx_eom,
										idx_calendar,//if libor: this is uk
										null<string>,
										idx_currency,
										idx_suppl_calendar,	//if libor: this is primary(ex.target), if ibor: this is null
										null<string>,
										idx_spot_days,0);
		
		instr_def c = __instr_def_frn_nodb(instr_def_name,payment_dates,fix_margin, cpn_freq,day_count_method,bd_convention,pmt_calendar,
											ex_cpn_code,settle_code,currency,neg_rate_rule,idx );
		
		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_frn");
		return null<instr_def>;
	}
}
 

/*-----------------------------------------------------------------------
  func: instr_def_frn[NO DATABASE]  [LEGACY]
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_frn(string 					instr_def_name,
						integer 				cpn_freq,						       
						frn_roll_method 		roll_method,   
						day_count_method 		day_count_method,
						bd_convention 			bd_convention,
						calendar 				pmt_calendar,					
						logical 				eom,  
						string 					ex_cpn_code,
						string 					settle_code,						
						string 					currency,
						frn_neg_rate_rule		neg_rate_rule,
						string 					idx_name,
						string 					idx_type,
						string 					idx_tenor,
						integer 				idx_value_days,
					    day_count_method option(nullable) idx_day_count_method,
					    bd_convention option(nullable) idx_bd_convention,
					    logical option(nullable) 	idx_eom,
					    calendar option(nullable) 	idx_calendar,
					    string option(nullable) 	idx_currency,
					    calendar option(nullable) 	idx_suppl_calendar,						    						    
						error_info option(nullable) error = null<error_info>)
option(com_name: 'instr_def_frn_alt')
option (category: 'Instrument/Frn')
{	
	try{	

		if(!equal(idx_type, "IBOR") && !equal (idx_type, "LIBOR"))
			QL_FAIL("index type not applicable", E_INIT);

		integer idx_spot_days = idx_value_days;
		if(null(idx_day_count_method))  idx_day_count_method = day_count_method;
		if(null(idx_bd_convention))  	idx_bd_convention = bd_convention;
		if(null(idx_eom))  				idx_eom = eom;
		if(null(idx_calendar))  		idx_calendar = pmt_calendar;
		if(null(idx_currency))  		idx_currency = currency;
		if(null(idx_suppl_calendar))  	idx_suppl_calendar = pmt_calendar;
		
		ir_index idx = create_ir_index(	idx_name,
										idx_type,
										idx_tenor,
										idx_value_days,
										null<number>,
										idx_day_count_method,
										idx_bd_convention,
										idx_eom,
										idx_calendar,//if libor: this is uk
										null<string>,
										idx_currency,
										idx_suppl_calendar,	//if libor: this is primary(ex.target), if ibor: this is null
										null<string>,
										idx_spot_days,0);
		
		instr_def c = __instr_def_frn_nodb(instr_def_name,cpn_freq, roll_method, day_count_method,bd_convention,pmt_calendar,
											eom,  ex_cpn_code,settle_code,currency,neg_rate_rule,idx );
		
		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_frn");
		return null<instr_def>;
	}
}
 

/*-----------------------------------------------------------------------
  func: instr_def_frn   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_frn(INSTR_TMPL.frn_def_tmpl			tmpl,
						error_info option(nullable) error = null<error_info>)
option(com_name: 'instr_def_frn_tmpl')
option (category: 'Instrument/Frn')
{	
	try{
		instr_def c;
		if(tmpl.is_rfr_frn()){
			c = __instr_def_frn_nodb(	tmpl.name(),tmpl.cpn_freq(), tmpl.roll_method(), tmpl.day_count_method(),  
										tmpl.bd_convention(), tmpl.calendar(), tmpl.eom(), tmpl.excpn_code(), 
										tmpl.settle_code(), tmpl.currency(),tmpl.neg_rate_rule(),tmpl.ir_index(),
										tmpl.arr_type(),tmpl.arr_days(),tmpl.comp_avg(),tmpl.payment_lag(),tmpl.payment_lag_ex_mat());
			//return null<instr_def>;
		}
		else {
			c = __instr_def_frn_nodb(	tmpl.name(),tmpl.cpn_freq(), tmpl.roll_method(), tmpl.day_count_method(),  
										tmpl.bd_convention(), tmpl.calendar(), tmpl.eom(), tmpl.excpn_code(), 
										tmpl.settle_code(), tmpl.currency(),tmpl.neg_rate_rule(),tmpl.ir_index());
		}

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_frn");
		return null<instr_def>;
	}
}
 
