/*	
	instr_def wrapper functions for fx
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	

//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have 
*/
/*-----------------------------------------------------------------------
  func: instr_def_fx_spot
  ----------------------------------------------------------------------*/
instr_def instr_def_fx_spot(string 	name ,
							error_info option(nullable) error = null<error_info>) 
option (category: 'Instrument/FX')
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_fx_spot(), "instr_def not a fx spot", E_INIT);		
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_fx_spot");
		return null<..instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_fx_spot[NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_fx_spot(string 						instr_def_name,
							string 						base_ccy,
							string  					price_ccy,							
							calendar					base_ccy_calendar,
							calendar					price_ccy_calendar,
							calendar option(nullable)	usd_calendar,
							string 						spot_settle_code,
							integer 					pip_decimals,
							integer 					scale,
							integer						quote_decimals,
							fx_spot_rule				fx_rule,
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/FX')
{	
	try{	
		
		instr_def c = __instr_def_fxspot_nodb(	instr_def_name,base_ccy,price_ccy,base_ccy_calendar,price_ccy_calendar,
												usd_calendar,spot_settle_code,pip_decimals,scale,quote_decimals,fx_rule);

		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_fx_spot");
		return null<instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_fx_spot   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_fx_spot(INSTR_TMPL.fx_spot_def_tmpl		tmpl,
						error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/FX')
{	
	try{

		instr_def c = __instr_def_fxspot_nodb(	tmpl.name(),tmpl.base_ccy(), tmpl.price_ccy(), tmpl.base_ccy_calendar(), tmpl.price_ccy_calendar(), 
												tmpl.usd_calendar(),tmpl.spot_settle_code(), tmpl.pip_decimals(),tmpl.scale(),tmpl.quote_decimals(),
												tmpl.fx_rule());


		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_fx_spot");
		return null<instr_def>;
	}
}
 

