/*	
	instr_def wrapper functions for il bonds
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	


//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/
/*-----------------------------------------------------------------------
  func: instr_def_il_bond
  ----------------------------------------------------------------------*/
instr_def instr_def_il_bond(string 	name ,
							error_info option(nullable) error = null<error_info>) 
option (category: "Instrument/Inflation Linked/Real Rate Bond")
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_il_bond(), "instr_def not an inflation linked bond", E_INIT);		
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_il_bond");
		return null<..instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_bond [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/

instr_def instr_def_il_bond(string					instr_def_name,									
							il_bond_yld_method		yld_method,
							infl_index_method		index_method,
							integer					cpn_freq,
							..day_count_method 		day_count_method, 
							logical 				eom,						
							string option(nullable) excpn_code, 
							..first_cpn_type 		option(nullable) first_cpn_type,
    						last_per_yld_method	option(nullable) last_yld_method,
    						next_per_yld_method	option(nullable) next_yld_method, 
    						..odd_last_cpn_type		option(nullable) odd_last_cpn_type, 	 															
							string 	 				settle_code,						
							..calendar 	 			calendar,
							string					currency,									
							..quote_style			quote_style,							
							error_info option(nullable) error = null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Bond")
{	
	try{	
		instr_def c = __instr_def_bondil_nodb(instr_def_name,yld_method,index_method,cpn_freq,day_count_method, eom,excpn_code, 
											first_cpn_type, last_yld_method,next_yld_method,odd_last_cpn_type,settle_code,
											calendar,currency,quote_style );

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_il_bond");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_il_bond   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_il_bond(INSTR_TMPL.il_bond_def_tmpl			tmpl,
						error_info option(nullable) error = null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Bond")
{	
	try{
		instr_def c = __instr_def_bondil_nodb(tmpl.name(),tmpl.yld_method(), tmpl.index_method(), tmpl.cpn_freq(), tmpl.day_count_method(),  
											tmpl.eom(), tmpl.excpn_code(), tmpl.first_cpn_type(), tmpl.last_yld_method(),
											tmpl.next_yld_method(),tmpl.odd_last_cpn_type(),
											tmpl.settle_code(), tmpl.calendar(),
											tmpl.currency(),tmpl.quote_style());


		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_il_bond");
		return null<instr_def>;
	}
}
 