/*	
	instr_def wrapper functions for il swaps
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	

//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/
/*-----------------------------------------------------------------------
  func: instr_def_il_rr_swap_fixflt
  ----------------------------------------------------------------------*/
instr_def instr_def_il_rr_swap_fixflt(	string 	name ,
										error_info option(nullable) error = null<error_info>) 
option (category: "Instrument/Inflation Linked/Real Rate Fixed vs Float")
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_il_rr_swap_fixflt(), "instr_def not an inflation linked fix-float swap", E_INIT);		
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_il_rr_swap_fixflt");
		return null<..instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_il_rr_swap_fixflt [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_il_rr_swap_fixflt(	string				instr_def_name,	
										string 					spot_code,
										string option(nullable) fwd_start_code,
										string option(nullable) maturity_code,	
										notional_exchg_style option(nullable) not_exchange,
										infl_index_method	index_method,
										integer 			fix_cpn_freq,
										day_count_method 	fix_day_count_method,
										string 				fix_currency,
										calendar 			fix_calendar,
										bd_convention 		fix_bd_convention,
										logical 			fix_eom,
										integer 			flt_cpn_freq,
										number option(nullable)	flt_reset_freq,
										day_count_method 	flt_day_count_method,
										string 				flt_currency,
										calendar 			flt_calendar,
										bd_convention 		flt_bd_convention,
										logical 			flt_eom,
										flt_comp_avg_type option(nullable)		flt_comp_avg,
										flt_sprd_comp_method option(nullable) 	flt_spread_comp_method,
										flt_avg_method option(nullable) 		flt_avg_method,														
										string 				idx_name,
										string 				idx_type,
										string 				idx_tenor,
										integer 			idx_value_days,
										day_count_method option(nullable) 	idx_day_count_method,
										bd_convention option(nullable) 		idx_bd_convention,
										logical option(nullable) 	idx_eom,
										calendar option(nullable) 	idx_calendar,
										string option(nullable) 	idx_currency,
										calendar option(nullable) 	idx_suppl_calendar,							
										error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Real Rate Fixed vs Float')
{	
	try{	
		if(null(not_exchange)) {
			if( equal_casei(fix_currency, flt_currency)) 
				not_exchange = NE_NONE ;
			else 
				not_exchange = NE_BOTH;
		}

		if(!equal(idx_type, "IBOR") && !equal (idx_type, "LIBOR"))
			QL_FAIL("index type not applicable", E_INIT);

		integer idx_spot_days = idx_value_days;
		
		ir_index idx = create_ir_index(	idx_name,idx_type,
										idx_tenor,
										idx_value_days,
										null<number>,
										idx_day_count_method,
										idx_bd_convention,
										idx_eom,
										idx_calendar,//if libor: this is uk
										null<string>,
										idx_currency,
										idx_suppl_calendar,	//if libor: this is primary(ex.target), if ibor: this is null
										null<string>,
										idx_spot_days,0);
		
		instr_def c = __instr_def_il_fixflt_nodb(instr_def_name,
												spot_code,fwd_start_code,maturity_code,not_exchange,index_method,
												 fix_cpn_freq,fix_day_count_method,fix_currency,fix_calendar,fix_bd_convention,
							    				fix_eom,flt_cpn_freq,flt_reset_freq,flt_day_count_method,flt_currency,flt_calendar,flt_bd_convention,
							    				flt_eom,flt_comp_avg,flt_spread_comp_method,flt_avg_method,idx );

		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_il_rr_swap_fixflt");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_il_rr_swap_fixflt [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_il_rr_swap_fixflt(	string				instr_def_name,	
										string 					spot_code,
										string option(nullable) fwd_start_code,
										string option(nullable) maturity_code,	
										notional_exchg_style option(nullable) not_exchange,
										infl_index_method	index_method,
										integer 			fix_cpn_freq,
										day_count_method 	fix_day_count_method,
										string 				fix_currency,
										calendar 			fix_calendar,
										bd_convention 		fix_bd_convention,
										logical 			fix_eom,
										integer 			flt_cpn_freq,
										number option(nullable)	flt_reset_freq,
										day_count_method 	flt_day_count_method,
										string 				flt_currency,
										calendar 			flt_calendar,
										bd_convention 		flt_bd_convention,
										logical 			flt_eom,
										flt_comp_avg_type option(nullable)		flt_comp_avg,
										flt_sprd_comp_method option(nullable) 	flt_spread_comp_method,
										flt_avg_method option(nullable) 		flt_avg_method,														
										ir_index 				idx,						
										error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Real Rate Fixed vs Float')
{	
	try{	
		if(null(not_exchange)) {
			if( equal_casei(fix_currency, flt_currency)) 
				not_exchange = NE_END ;
			else 
				not_exchange = NE_BOTH;
		}
		
		instr_def c = __instr_def_il_fixflt_nodb(instr_def_name,
												spot_code,fwd_start_code,maturity_code,not_exchange,index_method,
												 fix_cpn_freq,fix_day_count_method,fix_currency,fix_calendar,fix_bd_convention,
							    				fix_eom,flt_cpn_freq,flt_reset_freq,flt_day_count_method,flt_currency,flt_calendar,flt_bd_convention,
							    				flt_eom,flt_comp_avg,flt_spread_comp_method,flt_avg_method,idx );

		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_il_rr_swap_fixflt");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_swap_fixflt   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_il_rr_swap_fixflt(INSTR_TMPL.swap_rr_fixflt_def_tmpl		tmpl,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Real Rate Fixed vs Float')
{	
	try{
		instr_def c = __instr_def_il_fixflt_nodb(tmpl.name(),
												 tmpl.spot_settle_code(), tmpl.fwd_start_code(),tmpl.maturity_code(),tmpl.not_exchange(),tmpl.index_method(),
												 tmpl.fix_cpn_freq(),tmpl.fix_day_count_method(),tmpl.fix_currency(),tmpl.fix_calendar(),
							    				tmpl.fix_bd_convention(), tmpl.fix_eom(),tmpl.flt_cpn_freq(),tmpl.flt_reset_freq(),tmpl.flt_day_count_method(),
												tmpl.flt_currency(),tmpl.flt_calendar(),
												tmpl.flt_bd_convention(), tmpl.flt_eom(),tmpl.flt_comp_avg(),tmpl.flt_spread_comp_method(),
												tmpl.flt_avg_method(), tmpl.flt_ir_index());

		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_il_rr_swap_fixflt");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_il_rr_swap_fixflt   [NO DATABASE]
  this instr_def will be complete but not date_complete  	
  ----------------------------------------------------------------------*/

instr_def instr_def_il_rr_swap_fixflt(INSTR_TMPL.swap_rr_fixflt_def_tmpl		tmpl,
								string option(nullable) 		fwd_start_code,//override of template value
								string option(nullable)			maturity_code,//override of template value
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Real Rate Fixed vs Float')
{	
	try{
		if(null(fwd_start_code))
			fwd_start_code = tmpl.fwd_start_code();
		if(null(maturity_code))
			maturity_code = tmpl.maturity_code();
		
		//INSTR_TMPL.ir_index_tenor_tmpl idx = tmpl.index();
		instr_def c = __instr_def_il_fixflt_nodb(tmpl.name(),
												 tmpl.spot_settle_code(), fwd_start_code, maturity_code,tmpl.not_exchange(),tmpl.index_method(),
												 tmpl.fix_cpn_freq(),tmpl.fix_day_count_method(),tmpl.fix_currency(),tmpl.fix_calendar(),
							    				tmpl.fix_bd_convention(), tmpl.fix_eom(),tmpl.flt_cpn_freq(),tmpl.flt_reset_freq(),tmpl.flt_day_count_method(),
												tmpl.flt_currency(),tmpl.flt_calendar(),
												tmpl.flt_bd_convention(), tmpl.flt_eom(),tmpl.flt_comp_avg(),tmpl.flt_spread_comp_method(),
												tmpl.flt_avg_method(), tmpl.flt_ir_index());


		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_il_rr_swap_fixflt");
		return null<instr_def>;
	}
}
 
 

