/*	
	instr_def wrapper functions for il swaps
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	

//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/


/*-----------------------------------------------------------------------
  func: instr_def_il_rr_swap_fixois
  ----------------------------------------------------------------------*/
instr_def instr_def_il_rr_swap_fixois(	string 	name ,
										error_info option(nullable) error = null<error_info>) 
option (category: "Instrument/Inflation Linked/Real Rate Fixed vs ONIndex")
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_il_rr_swap_fixois(), "instr_def not an inflation linked fix-ois swap", E_INIT);		
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_il_rr_swap_fixois");
		return null<..instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_il_rr_swap_fixois [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_il_rr_swap_fixois(	string				instr_def_name,	
										string 					spot_code,
										string option(nullable) fwd_start_code,
										string option(nullable) maturity_code,										
										notional_exchg_style option(nullable) not_exchange,
										infl_index_method	index_method,
										integer 			fix_cpn_freq,
										day_count_method 	fix_day_count_method,
										string 				fix_currency,
										calendar 			fix_calendar,
										bd_convention 		fix_bd_convention,
										logical 			fix_eom,
										integer 			ois_cpn_freq,
										
										day_count_method 	ois_day_count_method,
										string 				ois_currency,
										calendar 			ois_calendar,
										bd_convention 		ois_bd_convention,
										logical 			ois_eom,
										rfr_arrears_type option(nullable) 		ois_arr_type,
										number option(nullable)					ois_arr_days,
										logical option(nullable)				ois_endog_df,
										flt_comp_avg_type option(nullable)		ois_comp_avg,
										flt_sprd_comp_method option(nullable) 	ois_spread_comp_method,
										flt_avg_method option(nullable) 		ois_avg_method,													
										integer				payment_lag,								
										ir_index 			on_idx,						
										error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Real Rate Fixed vs ONIndex')
{	
	try{	
		if(null(not_exchange)) {
			if( equal_casei(fix_currency, ois_currency)) 
				not_exchange = NE_END ;
			else 
				not_exchange = NE_BOTH;
		}
		
		instr_def c = __instr_def_il_fixois_nodb(instr_def_name,
												spot_code,fwd_start_code,maturity_code,payment_lag,not_exchange,index_method,
												 fix_cpn_freq,fix_day_count_method,fix_currency,fix_calendar,fix_bd_convention,
							    				fix_eom,ois_cpn_freq,ois_day_count_method,ois_currency,ois_calendar,ois_bd_convention,
							    				ois_eom,ois_comp_avg,ois_spread_comp_method,ois_avg_method,ois_arr_type,ois_arr_days,
												 ois_endog_df,on_idx );

		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_il_rr_swap_fixois");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_il_rr_swap_fixois   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_il_rr_swap_fixois(INSTR_TMPL.swap_rr_fixois_def_tmpl		tmpl,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Real Rate Fixed vs Float')
{	
	try{
		instr_def c = __instr_def_il_fixois_nodb(tmpl.name(),
												 tmpl.spot_settle_code(), tmpl.fwd_start_code(),tmpl.maturity_code(),tmpl.payment_lag(),tmpl.not_exchange(),tmpl.index_method(),
												 tmpl.fix_cpn_freq(),tmpl.fix_day_count_method(),tmpl.fix_currency(),tmpl.fix_calendar(),
							    				tmpl.fix_bd_convention(), tmpl.fix_eom(),tmpl.ois_cpn_freq(),tmpl.ois_day_count_method(),
												tmpl.ois_currency(),tmpl.ois_calendar(),
												tmpl.ois_bd_convention(), tmpl.ois_eom(),tmpl.ois_comp_avg(),tmpl.ois_spread_comp_method(),
												tmpl.ois_avg_method(), tmpl.ois_arr_type(),tmpl.ois_arr_days(),
												 tmpl.ois_endog_df(),tmpl.ois_ir_index());

		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_il_rr_swap_fixois");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_il_rr_swap_fixois   [NO DATABASE]
  this instr_def will be complete but not date_complete  	
  ----------------------------------------------------------------------*/

instr_def instr_def_il_rr_swap_fixois(INSTR_TMPL.swap_rr_fixois_def_tmpl		tmpl,
								string option(nullable) 		fwd_start_code,//override of template value
								string option(nullable)			maturity_code,//override of template value
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Real Rate Fixed vs Float')
{	
	try{
		if(null(fwd_start_code))
			fwd_start_code = tmpl.fwd_start_code();
		if(null(maturity_code))
			maturity_code = tmpl.maturity_code();
		
		//INSTR_TMPL.ir_index_tenor_tmpl idx = tmpl.index();
		instr_def c = __instr_def_il_fixois_nodb(tmpl.name(),
												 tmpl.spot_settle_code(), fwd_start_code, maturity_code,tmpl.payment_lag(),tmpl.not_exchange(),tmpl.index_method(),
												 tmpl.fix_cpn_freq(),tmpl.fix_day_count_method(),tmpl.fix_currency(),tmpl.fix_calendar(),
							    				tmpl.fix_bd_convention(), tmpl.fix_eom(),tmpl.ois_cpn_freq(),tmpl.ois_day_count_method(),
												tmpl.ois_currency(),tmpl.ois_calendar(),
												tmpl.ois_bd_convention(), tmpl.ois_eom(),tmpl.ois_comp_avg(),tmpl.ois_spread_comp_method(),
												tmpl.ois_avg_method(), tmpl.ois_arr_type(),tmpl.ois_arr_days(),
												 tmpl.ois_endog_df(),tmpl.ois_ir_index());


		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_il_rr_swap_fixois");
		return null<instr_def>;
	}
}
 
