/*	
	instr_def wrapper functions for il swaps
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	


//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/
/*-----------------------------------------------------------------------
  func: instr_def_il_zero_swap
  ----------------------------------------------------------------------*/
instr_def instr_def_il_zero_swap(	string 	name ,
									error_info option(nullable) error = null<error_info>) 
option (category: 'Instrument/Inflation Linked/Zero Swap')
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_il_zero_swap(), "instr_def not an inflation zero swap", E_INIT);		
		return c;				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_il_zero_swap");
		return null<..instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_il_zero_swap [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/

instr_def instr_def_il_zero_swap(	string					instr_def_name,	
									string					currency,
    								..calendar 	 			calendar,
    								..bd_convention 		bd_convention,												    				   						 															
									string 	 				settle_code,
									integer 				maturity_years,	
									infl_index_method		index_method,																							
									error_info option(nullable) error = null<error_info>)
option (category: "Instrument/Inflation Linked/Zero Swap")
{	
	try{
		instr_def c = __instr_def_zeroswap_il_nodb(instr_def_name, currency,calendar,
											bd_convention,settle_code,maturity_years,index_method );

		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_il_zero_swap");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_il_zero_swap   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_il_zero_swap(INSTR_TMPL.swap_il_zero_def_tmpl	tmpl,
								error_info option(nullable) error = null<error_info>)
option (category: "Instrument/Inflation Linked/Zero Swap")
{	
	try{

		instr_def c = __instr_def_zeroswap_il_nodb(tmpl.name(), tmpl.currency(), 
													tmpl.calendar(),tmpl.bd_convention(), tmpl.settle_code(),
													tmpl.maturity_years(),tmpl.index_method());

		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_il_zero_swap");
		return null<instr_def>;
	}
}
/*-----------------------------------------------------------------------
  func: instr_def_il_zero_swap   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_il_zero_swap(	INSTR_TMPL.swap_il_zero_def_tmpl	tmpl,
									integer 				maturity_years,	//override of template value
									error_info option(nullable) 		error = null<error_info>)
option (category: "Instrument/Inflation Linked/Zero Swap")
{	
	try{
		//if(null(fwd_start_code))
			//fwd_start_code = tmpl.fwd_start_code();
				
		instr_def c = __instr_def_zeroswap_il_nodb(tmpl.name(), tmpl.currency(), 
													tmpl.calendar(),tmpl.bd_convention(), tmpl.settle_code(),
													maturity_years,tmpl.index_method());


		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_il_zero_swap");
		return null<instr_def>;
	}
}
 

