/*	
	instr_def wrapper functions for ir_future
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	// Throw error if a null value is used in a non-nullable context

//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/
/*-----------------------------------------------------------------------
  func: instr_def_ir_future
  ----------------------------------------------------------------------*/
instr_def instr_def_ir_future(	string 	name ,
								error_info option(nullable) error = null<error_info>)
option(com_name: 'instr_def_ir_future_db')		
option (category: 'Instrument/Interest Rate Future')
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_ir_future(), "instr_def not an ir future", E_INIT);		
		return c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_ir_future");
		return null<..instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_ir_future [NO DATABASE] [LEGACY]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_ir_future(	string 						instr_def_name,
								date option(nullable) 		expiration_settle_date, 
    							string option(nullable)		expiration_settle_code,
								string	option(nullable)	underlying_mat_code,
								day_count_method 			day_count_method,
								bd_convention				bd_convention,
								logical						eom, 
								calendar					calendar,
								string						currency,
								irfut_calc_method			style,
								fut_tick_value_style 		tick_val_style,
								number						contract_val,
								quote_style					quote_style,
								number 	option(nullable)	tick_size,
								string 						idx_name,
								string 						idx_type,
								string						idx_tenor,
	    						integer						idx_value_days,							
							    day_count_method option(nullable) idx_day_count_method 	= null<day_count_method>,
							    bd_convention option(nullable) idx_bd_convention 		= null<bd_convention>,
							    logical option(nullable) 	idx_eom 					= null<logical>,
							    calendar option(nullable) 	idx_calendar 				= null<calendar>,
							    string option(nullable) 	idx_currency 				= null<string>,
							    calendar option(nullable) 	idx_suppl_calendar 			= null<calendar>,	
								error_info option(nullable) error 						= null<error_info>)
option(com_name: 'instr_def_ir_future')		
option (category: 'Instrument/Interest Rate Future')
{	
	try{
		if(!equal(idx_type, "IBOR") && !equal (idx_type, "LIBOR"))
			QL_FAIL("index type not applicable", E_INIT);

		integer idx_spot_days = idx_value_days;
		
		if(null(idx_day_count_method))  idx_day_count_method = day_count_method;
		if(null(idx_bd_convention))  	idx_bd_convention = bd_convention;
		if(null(idx_eom))  				idx_eom = eom;
		if(null(idx_calendar))  		idx_calendar = calendar;
		if(null(idx_currency))  		idx_currency = currency;
		if(null(idx_suppl_calendar))  	idx_suppl_calendar = calendar;

		ir_index idx = create_ir_index(	idx_name,
										idx_type,
										idx_tenor,
										idx_value_days,
										null<number>,
										idx_day_count_method,
										idx_bd_convention,
										idx_eom,
										idx_calendar,//if libor: this is uk
										null<string>,
										idx_currency,
										idx_suppl_calendar,	//if libor: this is primary(ex.target), if ibor: this is null
										null<string>,
										idx_spot_days,0);
		
		instr_def c = __instr_def_irfut_nodb(	instr_def_name,expiration_settle_date,expiration_settle_code,underlying_mat_code,day_count_method, 
												bd_convention, eom, calendar, currency,style,tick_val_style,
												contract_val,quote_style,tick_size,idx );

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_ir_future");
		return null<..instr_def>;
	}
}

/*
instr_def create_irfut_instr_def(day_count_method 	day_count_method, 
								string				currency,
								string				fixing_code)
{
	return instr_def_ir_future("irfut_def",day_count_method, currency, fixing_code);
}*/

/*-----------------------------------------------------------------------
  func: instr_def_ir_future [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_ir_future(	INSTR_TMPL.irfut_def_tmpl	tmpl,
								error_info option(nullable) error = null<error_info>)
option(com_name: 'instr_def_ir_future_tmpl')		
option (category: 'Instrument/Interest Rate Future')
{	
	try{
		
		if(null(tmpl.index().tenor()) )
			QL_FAIL("index tenor is required", E_INIT);
		//if(null(tmpl.index().value_days()) )
		//	QL_FAIL("value days is required");
		if(tmpl.index().value_days() != tmpl.index().fixing_days())
			QL_FAIL("value days <> fixing days is not supported for ir future", E_INIT);
		//if(!null(tmpl.index().fixing_days()))
		//	QL_FAIL("value days <> fixing days is not supported for ir future");		

		instr_def c = __instr_def_irfut_nodb(tmpl.name(),tmpl.expiration_settle_date(),tmpl.expiration_settle_code(),
											tmpl.underlying_mat_code(), tmpl.day_count_method(), tmpl.bd_convention(), 
											tmpl.eom(), tmpl.calendar(), tmpl.currency(),tmpl.style(),
											tmpl.tick_val_style(),tmpl.contract_val(),tmpl.quote_style(), 
											tmpl.tick_size(), tmpl.ir_index());


		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_ir_future");
		return null<instr_def>;
	}
}
 

