/*	
	instr_def wrapper functions for overnight futures
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	

//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/
/*-----------------------------------------------------------------------
  func: instr_def_on_future
  ----------------------------------------------------------------------*/
instr_def instr_def_on_future(	string 						name ,
								error_info option(nullable) error = null<error_info>)
option(com_name: 'instr_def_on_future_db')	
option (category: 'Instrument/Overnight Future')
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_on_future(), "instr_def not an overnight future", E_INIT);		
		return c;
						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_on_future");
		return null<..instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_on_future [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_on_future(	string 						instr_def_name,
								date option(nullable)		accr_start_date,
								string option(nullable)		accr_start_code,
								string						accr_end_code,
								day_count_method 			day_count_method,								
								calendar					calendar,
								string						currency,
								onfut_calc_method 			style,
								fut_tick_value_style 		tick_val_style,									
								number						contract_val,
								quote_style					quote_style,
								number 	option(nullable)	tick_size,
								string						final_settle_code,//w.r.t. last trading day = last bus day in month
								string 						idx_name,
								string 						idx_type,
	    						integer						idx_value_days,	
								integer						idx_fixing_days,						
							    day_count_method option(nullable) idx_day_count_method 	= null<day_count_method>,							    
						    	calendar option(nullable) 	idx_calendar 				= null<calendar>,
						    	string option(nullable) 	idx_currency 				= null<string>,
						    	calendar option(nullable) 	idx_suppl_calendar 			= null<calendar>,
								error_info option(nullable) error 						= null<error_info>)
option(com_name: 'instr_def_on_future')
option (category: 'Instrument/Overnight Future')
{	
	try{

		if(!equal(idx_type, "IBOR") && !equal (idx_type, "LIBOR") && !equal (idx_type, "RFR"))
			QL_FAIL("index type not applicable", E_INIT);

		integer idx_spot_days = idx_value_days;
		if(null(idx_day_count_method))  idx_day_count_method = day_count_method;				
		if(null(idx_calendar))  		idx_calendar = calendar;
		if(null(idx_currency))  		idx_currency = currency;
		if(null(idx_suppl_calendar))  	idx_suppl_calendar = calendar;

		number idx_spread = 0;
		
		ir_index idx = create_ir_index(	idx_name,
										idx_type,
										"1D",
										idx_value_days,
										null<number>,
										idx_day_count_method,
										BD_FOLLOWING,
										false,
										idx_calendar,//if libor: this is uk
										null<string>,
										idx_currency,
										idx_suppl_calendar,	//if libor: this is primary(ex.target), if ibor: this is null
										null<string>,
										idx_spot_days,idx_spread);
		
		instr_def c = __instr_def_onfut_nodb(instr_def_name,accr_start_date,accr_start_code,accr_end_code,day_count_method,  calendar, 
											currency,style,tick_val_style,contract_val,quote_style,tick_size,
											final_settle_code,idx );

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_on_future");
		return null<..instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_on_future [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_on_future(	INSTR_TMPL.onfut_def_tmpl	tmpl,
								error_info option(nullable) error = null<error_info>)
option(com_name: 'instr_def_on_future_tmpl')
option (category: 'Instrument/Overnight Future')
{	
	try{
				
		instr_def c = __instr_def_onfut_nodb(	tmpl.name(),tmpl.accr_start_date(),tmpl.accr_start_code(),tmpl.accr_end_code(), tmpl.day_count_method(), 
												tmpl.calendar(), tmpl.currency(),tmpl.style(),
												tmpl.tick_value_style(),
												tmpl.contract_val(),tmpl.quote_style(), 
												tmpl.tick_size(), tmpl.final_settle_code(), tmpl.ir_index());

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_on_future");
		return null<..instr_def>;
	}
}
 
