/*	
	Option vanilla eq def
	Developer: Algorithmica Research, Magnus Nyström			
*/
option(null: hard);


/*-----------------------------------------------------------------------
  vanilla_option_eq_def  	
  ----------------------------------------------------------------------*/

class vanilla_option_eq_def option (category: 'Instrument/Equity Option')
{
	public:
		vanilla_option_eq_def(	..exercise_type 				exercise_type,
								..opt_type 						opt_type,
								number							contract_size,								
								..bd_convention 				bd,
								string 							prem_settle_code,
								string 							deliv_settle_code,																
								string	option(nullable) 		expiry_code,	//no default i.e. not required
								..calendar						cal,
								string	option(nullable) 		strike_code,	//no default i.e. not required
								string							ccy,	
								logical							prem_at_spot,
								//fx_delta_type option(nullable)	delta_type,		
								//fx_atm_type	option(nullable) 	atm_type,		
								delivery_type 					del_type,
								quote_style_eq_opt 				qs);
	
		
		exercise_type 	exercise_type();
		opt_type 		opt_type();
		number			contract_size();
		..bd_convention bd(); 	 								
		string 			prem_settle_code();
		string 			deliv_settle_code();							
		string			expiry_code();
		logical			expiry_code_my();
		..calendar		cal();
		string			strike_code();
		string			ccy();
		logical			prem_at_spot();		
		//fx_delta_type	delta_type();
		//fx_atm_type	atm_type();
		logical			is_atm_strike();
		delivery_type 	del_type();
		logical			is_delta_strike(out number);
		//void			set_atm_delta_type(fx_atm_type, fx_delta_type);
		quote_style_eq_opt qs();
	protected:
		exercise_type 	exercise_type_;
		opt_type 		opt_type_;
		number			contract_size_;		
		..bd_convention bd_;
		string 			prem_settle_code_;
		string 			deliv_settle_code_;
		string 			ccy_;							
		string			expiry_code_;
		logical			expiry_code_my_;
		..calendar		cal_;
		string			strike_code_;
		
		logical			prem_at_spot_;	
		//fx_delta_type	delta_type_;
		//fx_atm_type		atm_type_;
		delivery_type 	del_type_;
		logical 		is_atm_strike_;			
		number 			delta_;
		quote_style_eq_opt qs_;
};

vanilla_option_eq_def.vanilla_option_eq_def(..exercise_type 	exercise_type,
											..opt_type 			opt_type,
											number 				contract_size,
											..bd_convention 	bd, 	 								
											string 				prem_settle_code,
											string 				deliv_settle_code,																			
											string	option(nullable) expiry_code,
											..calendar			cal,
											string	option(nullable) strike_code,
											string				ccy,	
											logical				prem_at_spot,
											//fx_delta_type option(nullable)	delta_type,
											//fx_atm_type	option(nullable) atm_type,
											delivery_type 	del_type,
											quote_style_eq_opt qs)
											:   exercise_type_(exercise_type),
												opt_type_(opt_type),
												contract_size_(contract_size),
												bd_(bd), 	 								
												prem_settle_code_(prem_settle_code),
												deliv_settle_code_(deliv_settle_code),
												ccy_(ccy),
												expiry_code_(expiry_code),
												expiry_code_my_(null<logical>),
												cal_(cal),
												strike_code_(strike_code),												
												prem_at_spot_(prem_at_spot),
												//delta_type_(delta_type),
												//atm_type_(atm_type),
												del_type_(del_type),
												is_atm_strike_(false),
												delta_(null<number>), qs_(qs)
{
	ccy_ = str_to_upper(ccy_);
	
	/*if(null(delta_type))
		delta_type_ = CORE_INT_FX.fx_delta_default(fc, dc, prem_ccy_, use_longterm_dflts);		

	if(null(atm_type_))
		atm_type_ = CORE_INT_FX.fx_atm_default(fc, dc, prem_ccy_, use_longterm_dflts,delta_type_);
	*/
	

	if(!null(expiry_code_)) {			
		//expiry_code_= date_code_tenor_filter(expiry_code_, eom_,bd_,expiry_code_my_);
	}
	
	if(!null(strike_code)){
		integer l = strlen(strike_code);
		is_atm_strike_ = (l == 3) && strcmp_casei(strike_code, "atm") == 0;
		
		if(!is_atm_strike_){
			string e = sub_string(strike_code, l-1, 1);
			QL_FAIL_COND(strcmp_casei(e, "d") != 0,"invalid strike code (a delta code must end with 'd')");
			QL_FAIL_COND(l <2 || l>4,"invalid strike code (invalid length)");
			string n = sub_string(strike_code, 0, l-1);
			n = strcat(n,".0");
			try{
				delta_ = str_to_number(n);
			}
			catch {
				QL_FAIL("invalid strike code (unable to convert to number)");
			}
		}
	}
}

exercise_type 	vanilla_option_eq_def.exercise_type()	{ return exercise_type_;}
opt_type 		vanilla_option_eq_def.opt_type()		{ return opt_type_;}
number			vanilla_option_eq_def.contract_size()	{ return contract_size_;}
string 			vanilla_option_eq_def.ccy()				{ return ccy_;}
..bd_convention vanilla_option_eq_def.bd()				{ return bd_;} 	 								
string			vanilla_option_eq_def.prem_settle_code() { return prem_settle_code_;}
string			vanilla_option_eq_def.deliv_settle_code() { return deliv_settle_code_;}
string			vanilla_option_eq_def.expiry_code()		{ return expiry_code_;}
logical			vanilla_option_eq_def.expiry_code_my()	{ return expiry_code_my_;}
..calendar		vanilla_option_eq_def.cal()				{ return cal_;}
string			vanilla_option_eq_def.strike_code()		{ return strike_code_;}
logical			vanilla_option_eq_def.prem_at_spot()	{ return prem_at_spot_;}			
//eq_delta_type	vanilla_option_eq_def.delta_type()		{ return delta_type_;}
//eq_atm_type		vanilla_option_eq_def.atm_type()		{ return atm_type_;}
delivery_type 	vanilla_option_eq_def.del_type()		{ return del_type_;}
logical			vanilla_option_eq_def.is_atm_strike()	{ return is_atm_strike_;}
logical			vanilla_option_eq_def.is_delta_strike(out number d)	{ d = delta_; return !null(delta_);}
quote_style_eq_opt vanilla_option_eq_def.qs()			{ return qs_;}

vanilla_option_eq_def vanilla_option_eq_def(INSTR_TMPL.vanilla_option_eq_def_tmpl	tmpl,
											error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Equity Option')
{	
	try{		
		return new vanilla_option_eq_def(tmpl.exercise_type(), tmpl.opt_type(), tmpl.contract_size(),  tmpl.bd(),  tmpl.prem_settle_code(),	tmpl.deliv_settle_code(),								
									tmpl.expiry_code(), tmpl.cal(), tmpl.strike_code(), tmpl.ccy(), tmpl.prem_at_spot(),
									/*tmpl.delta_type(),tmpl.atm_type(),*/ tmpl.del_type(), tmpl.qs());						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "vanilla_option_eq_def.vanilla_option_eq_def");
		return null<vanilla_option_eq_def>;
	}
}

vanilla_option_eq_def vanilla_option_eq_def(..exercise_type 	exercise_type,
											..opt_type 			opt_type,
											number 				contract_size,
											..bd_convention 	bd, 	 								
											string 				prem_settle_code,
											string 				deliv_settle_code,																			
											string	option(nullable) expiry_code,
											..calendar			cal,
											string	option(nullable) strike_code,
											string				ccy,	
											logical				prem_at_spot,
											//fx_delta_type option(nullable)	delta_type,
											//fx_atm_type	option(nullable) atm_type,
											delivery_type 	del_type,
											quote_style_eq_opt qs,
											error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Equity Option')
{	
	try{		
		return new vanilla_option_eq_def(exercise_type, opt_type, contract_size,  bd,  prem_settle_code,	deliv_settle_code,								
									expiry_code, cal, strike_code, ccy, prem_at_spot,
									/*tmpl.delta_type(),tmpl.atm_type(),*/ del_type,qs);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "vanilla_option_eq_def.vanilla_option_eq_def");
		return null<vanilla_option_eq_def>;
	}
}
