/*	
	Option vanilla fx def
	Developer: Algorithmica Research, Magnus Nyström			
*/
option(null: hard);


/*-----------------------------------------------------------------------
  vanilla_option_fx_def  	
  ----------------------------------------------------------------------*/

class vanilla_option_fx_def //option (category: 'Financial/Options/Vanilla/FX')
{
	public:
		vanilla_option_fx_def(	string							currency_pair,
								..exercise_type 				exercise_type,
								..opt_type 						opt_type,
								string 							cut_off,
								..bd_convention 				bd, 	 								
								logical							eom,									
								string	option(nullable) 		expiry_code,	//no default i.e. not required
								..calendar						expiry_cal,
								string	option(nullable) 		strike_code,	//no default i.e. not required
								string	option(nullable) 		face_ccy,		//defaults to foreign ccy (base ccy)
								string	option(nullable) 		prem_ccy,		//has a default based on currency_pair, regular is domestic ccy (price ccy) 
								logical							prem_at_spot,
								fx_delta_type option(nullable)	delta_type,		//has a default based on currency_pair and if it is short term or not
								fx_atm_type	option(nullable) 	atm_type,		//has a default based on currency_pair and if it is short term or not
								delivery_type 					del_type,
								logical							use_longterm_dflts = false);
	
		string			currency_pair();
		exercise_type 	exercise_type();
		opt_type 		opt_type();
		string 			cut_off();
		..bd_convention bd(); 	 								
		logical			eom();									
		string			expiry_code();
		logical			expiry_code_my();
		..calendar		expiry_cal();
		string			strike_code();
		string			face_ccy();
		string			prem_ccy();
		logical			prem_at_spot();
		string			for_ccy();
		string			dom_ccy();
		logical			face_ccy_is_for();
		logical			prem_ccy_is_dom();
		fx_delta_type	delta_type();
		fx_atm_type		atm_type();
		logical			is_atm_strike();
		delivery_type 	del_type();
		logical			is_delta_strike(out number);
		void			set_atm_delta_type(fx_atm_type, fx_delta_type);
		
	protected:
		string			currency_pair_;//format: FFFDDD, FFF=foreign ccy (=base ccy), DDD=domestic ccy (=price ccy)
		exercise_type 	exercise_type_;
		opt_type 		opt_type_;
		string 			cut_off_;
		..bd_convention bd_; 	 								
		logical			eom_;									
		string			expiry_code_;
		logical			expiry_code_my_;
		..calendar		expiry_cal_;
		string			strike_code_;
		string			face_ccy_;
		string			prem_ccy_;
		logical			prem_at_spot_;
		logical			face_ccy_is_for_;
		logical			prem_ccy_is_for_;
		fx_delta_type	delta_type_;
		fx_atm_type		atm_type_;
		delivery_type 	del_type_;
		logical 		is_atm_strike_;			
		number 			delta_;
};

vanilla_option_fx_def.vanilla_option_fx_def(string			currency_pair,//format: FFFDDD, FFF=foreign ccy (=base ccy), DDD=domestic ccy (=price ccy)
											..exercise_type exercise_type,
											..opt_type 		opt_type,
											string 			cut_off,
											..bd_convention bd, 	 								
											logical			eom,									
											string	option(nullable) expiry_code,
											..calendar		expiry_cal,
											string	option(nullable) strike_code,
											string	option(nullable) face_ccy,
											string	option(nullable) prem_ccy,
											logical			prem_at_spot,
											fx_delta_type option(nullable)	delta_type,
											fx_atm_type	option(nullable) atm_type,
											delivery_type 	del_type,
											logical	use_longterm_dflts )
											:   currency_pair_(currency_pair),
												exercise_type_(exercise_type),
												opt_type_(opt_type),
												cut_off_(cut_off),
												bd_(bd), 	 								
												eom_(eom),									
												expiry_code_(expiry_code),
												expiry_code_my_(null<logical>),
												expiry_cal_(expiry_cal),
												strike_code_(strike_code),
												face_ccy_(face_ccy),
												prem_ccy_(prem_ccy),
												prem_at_spot_(prem_at_spot),
												delta_type_(delta_type),
												atm_type_(atm_type),
												del_type_(del_type),
												is_atm_strike_(false),
												delta_(null<number>)
{
	if(!null(face_ccy_))
		face_ccy_ = str_to_upper(face_ccy_);
	if(!null(prem_ccy_))
		prem_ccy_ = str_to_upper(prem_ccy_);
	
	string fc, dc;
	CORE_INT_FX.fx_currency_pair_check(currency_pair_, fc, dc);					

	if(null(prem_ccy_)) {
		logical reg;
		prem_ccy_ = CORE_INT_FX.fx_prem_ccy_default(fc, dc, reg);
	}
	if(null(face_ccy_)){
		face_ccy_ = fc;
		face_ccy_is_for_ = true;
	}
	else
		face_ccy_is_for_ = strcmp(fc, face_ccy_) == 0;

	if(null(delta_type))
		delta_type_ = CORE_INT_FX.fx_delta_default(fc, dc, prem_ccy_, use_longterm_dflts);		

	if(null(atm_type_))
		atm_type_ = CORE_INT_FX.fx_atm_default(fc, dc, prem_ccy_, use_longterm_dflts,delta_type_);
	
	QL_FAIL_COND(!face_ccy_is_for_ && strcmp(dc, face_ccy_) != 0,"invalid face currency");
	prem_ccy_is_for_ = strcmp(fc, prem_ccy_) == 0;
	QL_FAIL_COND(!prem_ccy_is_for_ && strcmp(dc, prem_ccy_) != 0,"invalid premium currency");

	if(!null(expiry_code_)) {			
		expiry_code_= date_code_tenor_filter(expiry_code_, eom_,bd_,expiry_code_my_);
	}
	
	if(!null(strike_code)){
		integer l = strlen(strike_code);
		is_atm_strike_ = (l == 3) && strcmp_casei(strike_code, "atm") == 0;
		
		if(!is_atm_strike_){
			string e = sub_string(strike_code, l-1, 1);
			QL_FAIL_COND(strcmp_casei(e, "d") != 0,"invalid strike code (a delta code must end with 'd')");
			QL_FAIL_COND(l <2 || l>4,"invalid strike code (invalid length)");
			string n = sub_string(strike_code, 0, l-1);
			n = strcat(n,".0");
			try{
				delta_ = str_to_number(n);
			}
			catch {
				QL_FAIL("invalid strike code (unable to convert to number)");
			}
		}
	}
}

string			vanilla_option_fx_def.currency_pair()	{ return currency_pair_;}
exercise_type 	vanilla_option_fx_def.exercise_type()	{ return exercise_type_;}
opt_type 		vanilla_option_fx_def.opt_type()		{ return opt_type_;}
string 			vanilla_option_fx_def.cut_off()			{ return cut_off_;}
..bd_convention vanilla_option_fx_def.bd()				{ return bd_;} 	 								
logical			vanilla_option_fx_def.eom()				{ return eom_;}									
string			vanilla_option_fx_def.expiry_code()		{ return expiry_code_;}
logical			vanilla_option_fx_def.expiry_code_my()	{ return expiry_code_my_;}
..calendar		vanilla_option_fx_def.expiry_cal()		{ return expiry_cal_;}
string			vanilla_option_fx_def.strike_code()		{ return strike_code_;}
string			vanilla_option_fx_def.face_ccy()		{ return face_ccy_;}
string			vanilla_option_fx_def.prem_ccy()		{ return prem_ccy_;}
logical			vanilla_option_fx_def.prem_at_spot()	{ return prem_at_spot_;}			

string			vanilla_option_fx_def.for_ccy()			{ return sub_string(currency_pair_, 0, 3) ;}	
string			vanilla_option_fx_def.dom_ccy()			{ return sub_string(currency_pair_, 3, 3);}
logical			vanilla_option_fx_def.face_ccy_is_for()	{ return face_ccy_is_for_;}
logical			vanilla_option_fx_def.prem_ccy_is_dom()	{ return !prem_ccy_is_for_;}
fx_delta_type	vanilla_option_fx_def.delta_type()		{ return delta_type_;}
fx_atm_type		vanilla_option_fx_def.atm_type()		{ return atm_type_;}
delivery_type 	vanilla_option_fx_def.del_type()		{ return del_type_;}
logical			vanilla_option_fx_def.is_atm_strike()	{ return is_atm_strike_;}
logical			vanilla_option_fx_def.is_delta_strike(out number d)	{ d = delta_; return !null(delta_);}

//----------------------------------------------
// set_atm_delta_type
//----------------------------------------------
void vanilla_option_fx_def.set_atm_delta_type(	fx_atm_type 	atm_t,
												fx_delta_type 	delta_t)
{
	delta_type_ = delta_t;
	if(atm_t == fx_atm_type.DELTA_NEUTRAL_STRADDLE) {
		switch(delta_type_){
		case fx_delta_type.UNADJ_SPOT:			
			atm_type_ = fx_atm_type.DELTA_NEUTRAL_UNADJ_SPOT;	
			break;
		case fx_delta_type.UNADJ_FWD:			
			atm_type_ = fx_atm_type.DELTA_NEUTRAL_UNADJ_FWD;
			break;
		case fx_delta_type.PREMADJ_SPOT:
			atm_type_ = fx_atm_type.DELTA_NEUTRAL_PREMADJ_SPOT;
			break;
		case fx_delta_type.PREMADJ_FWD:	
			atm_type_ = fx_atm_type.DELTA_NEUTRAL_PREMADJ_FWD;
			break;
		default:	
			QL_FAIL("invalid delta type (no corresponding fx_atm_type)");
		}
	}
	atm_type_ = atm_t;
}
		
//----------------------------------------------
// vanilla_option_fx_def  create function
//----------------------------------------------	
vanilla_option_fx_def vanilla_option_fx_def(string			currency_pair,
											..exercise_type exercise_type,
											..opt_type 		opt_type,
											string 			cut_off,
											..bd_convention bd, 	 								
											logical			eom,									
											string	option(nullable) expiry_code,
											..calendar		expiry_cal,
											string	option(nullable) strike_code,
											string	option(nullable) face_ccy,
											string	option(nullable) prem_ccy,
											logical			prem_at_spot,
											fx_delta_type option(nullable) delta_type,
											fx_atm_type	option(nullable) 	atm_type,
											delivery_type	del_type,
											error_info option(nullable) error = null<error_info>)
{
	try{
		CORE_INT.reset_single(error);		
		return new vanilla_option_fx_def(currency_pair, exercise_type, opt_type, cut_off,  bd,  eom,									
										expiry_code, expiry_cal, strike_code, face_ccy, prem_ccy, prem_at_spot,
										delta_type,atm_type,del_type);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "vanilla_option_fx_def.instr_def_fx_option");
		return null<vanilla_option_fx_def>;
	}
}

/*-----------------------------------------------------------------------
  fx_option_expiry
  ----------------------------------------------------------------------*/
void fx_option_expiry(	date 		trade,						
						string 		expiry_code,
						logical 	expiry_code_my,
						calendar 	expiry_cal,
						instr_def	fxspot_def,
						out date 	spot_settle,
						out date 	expiry,
						out date 	delivery)

{
	QL_REQUIRE(fxspot_def.is_fx_spot(),"invalid instr_def (not fx_spot)");
	
	if(expiry_code_my){
		if(null(spot_settle)){
			logical adj_td 	= false;		
			spot_settle		= fx_spot_date(	trade, fxspot_def.fx_base_ccy_calendar(), fxspot_def.fx_base_ccy(),
											fxspot_def.fx_price_ccy_calendar(),fxspot_def.fx_price_ccy(),
											fxspot_def.fx_rule(), fxspot_def.fx_spot_days(),fxspot_def.fx_usd_calendar(),adj_td);
		}
		delivery	= fx_maturity(spot_settle,fxspot_def.fx_base_ccy_calendar(), fxspot_def.fx_base_ccy(),fxspot_def.fx_price_ccy_calendar(),
								  fxspot_def.fx_price_ccy(),fxspot_def.fx_spot_rule(),expiry_code,fxspot_def.fx_usd_calendar());
		expiry 		= fx_spot_fix_date(delivery,fxspot_def.fx_base_ccy_calendar(), fxspot_def.fx_base_ccy(),
										fxspot_def.fx_price_ccy_calendar(),fxspot_def.fx_price_ccy(),
										fxspot_def.fx_spot_rule(), fxspot_def.fx_spot_days(),fxspot_def.fx_usd_calendar());
	}
	else {
		date_code dc 	= date_code(expiry_code);
		expiry			= dc.apply_fwd(trade,expiry_cal,expiry_cal);
		logical adj_td 	= false;		
		delivery		= fx_spot_date(	expiry, fxspot_def.fx_base_ccy_calendar(), fxspot_def.fx_base_ccy(),
										fxspot_def.fx_price_ccy_calendar(),fxspot_def.fx_price_ccy(),
										fxspot_def.fx_spot_rule(), fxspot_def.fx_spot_days(),fxspot_def.fx_usd_calendar(),adj_td);
	}
	
	//return null<date>;
}