/*	
	instr_def wrapper functions for riba
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	


//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have 
*/
/*-----------------------------------------------------------------------
  func: instr_def_frn
  ----------------------------------------------------------------------*/
instr_def instr_def_riba(	string 						name ,
							error_info option(nullable) error = null<error_info>)
option(com_name: 'instr_def_riba_db')	
option (category: 'Instrument/Riba')
{	
	try{
		logical is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_riba(), "instr_def not a riba future", E_INIT);		
		return c;
					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_riba");
		return null<..instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_riba[NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_riba(	string 						instr_def_name,
							date option(nullable) 		accr_start_date,  
						    string option(nullable) 	accr_start_code, 
						    date option(nullable) 		accr_end_date, 
						    string option(nullable) 	accr_end_code,
						    logical option(nullable) 	accr_end_code_off_trade,
							day_count_method 			day_count_method, 							
							calendar					calendar,
							string						currency = "SEK",							
							error_info option(nullable) error = null<error_info>)
option(com_name: 'instr_def_riba')	
option (category: 'Instrument/Riba')
{	
	try{	
		
		instr_def c = __instr_def_riba_nodb(instr_def_name,accr_start_date,accr_start_code,accr_end_date,
											accr_end_code,accr_end_code_off_trade,day_count_method, calendar, currency );

		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_riba");
		return null<..instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_riba   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_riba(INSTR_TMPL.riba_def_tmpl				tmpl,
						error_info option(nullable) error = null<error_info>)
option(com_name: 'instr_def_riba_tmpl')		
option (category: 'Instrument/Riba')
{	
	try{
		
		instr_def c = __instr_def_riba_nodb(tmpl.name(),tmpl.accr_start_date(),tmpl.accr_start_code(),tmpl.accr_end_date(),
											tmpl.accr_end_code(),tmpl.accr_end_code_off_trade(), tmpl.day_count_method(), tmpl.calendar(), 
											tmpl.currency());


		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_riba");
		return null<..instr_def>;
	}
}
 

