/*	
	instr_def wrapper functions for y-y inflation swaps
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	

//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/

/*-----------------------------------------------------------------------
  func: instr_def_swap_fixyy
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_fixyy(string 	name ,
							error_info option(nullable) error = null<error_info>) 
option (category: 'Instrument/Inflation Linked/Fixed vs Y-Y')
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_il_swap_fix_yy(), "instr_def not a inflation y-y vs fix swap", E_INIT);		
		return c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fixyy");
		return null<..instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_il_zero_swap [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_fixyy(	string					instr_def_name,
								integer 				cpn_freq,
								..day_count_method 		day_count_method, 
								string					currency,
								..calendar 	 			calendar,
								..bd_convention 		bd_convention,
								logical 				eom	,												    				   						 															
								string 	 				settle_code,
								string option(nullable) maturity_code,
								infl_index_method		index_method,																							
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Fixed vs Y-Y')
{	
	try{	
		instr_def c = __instr_def_fixyy_nodb(instr_def_name,cpn_freq,day_count_method, currency,calendar,
											bd_convention,eom,settle_code,maturity_code,index_method );

		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fixyy");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_swap_fixyy   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:  	
  ----------------------------------------------------------------------*/

instr_def instr_def_swap_fixyy(INSTR_TMPL.swap_il_fixyy_def_tmpl		tmpl,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Fixed vs Y-Y')
{	
	try{
		instr_def c = __instr_def_fixyy_nodb(	tmpl.name(),tmpl.fix_cpn_freq(),tmpl.fix_day_count_method(),
												tmpl.fix_currency(),tmpl.fix_calendar(),
							    				tmpl.fix_bd_convention(), tmpl.fix_eom() ,tmpl.settle_code(),
												tmpl.maturity_code(),tmpl.index_method());

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fixyy");
		return null<instr_def>;
	}
}
/*-----------------------------------------------------------------------
  func: instr_def_swap_fixyy   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:  	
  ----------------------------------------------------------------------*/

instr_def instr_def_swap_fixyy(INSTR_TMPL.swap_il_fixyy_def_tmpl		tmpl,
							   string option(nullable)			maturity_code,//override of template value
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Fixed vs Y-Y')
{	
	try{
		if(null(maturity_code))
			maturity_code = tmpl.maturity_code();
		instr_def c = __instr_def_fixyy_nodb(	tmpl.name(),tmpl.fix_cpn_freq(),tmpl.fix_day_count_method(),
												tmpl.fix_currency(),tmpl.fix_calendar(),
							    				tmpl.fix_bd_convention(), tmpl.fix_eom() ,tmpl.settle_code(),
												maturity_code,tmpl.index_method());

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_fixyy");
		return null<instr_def>;
	}
}
 