/*	
	instr_def wrapper functions for y-y inflation swaps
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	

//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/

/*-----------------------------------------------------------------------
  func: instr_def_swap_oisyy
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_oisyy(string 	name ,
							error_info option(nullable) error = null<error_info>) 
option (category: 'Instrument/Inflation Linked/ONIndex vs Y-Y')
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_il_swap_ois_yy(), "instr_def not a inflation y-y vs ois swap", E_INIT);		
		return c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_oisyy");
		return null<..instr_def>;
	}
}