/*	
	instr_def wrapper functions for zeros
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	

//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/
/*-----------------------------------------------------------------------
  func: instr_def_zero_bond
  ----------------------------------------------------------------------*/
instr_def instr_def_zero_bond(	string 	name ,
								error_info option(nullable) error = null<error_info>) 
option (category: 'Instrument/Zero Bond')
{	
	try{
		logical	is_class_name ;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_zero_bond(), "instr_def not a zero coupon bond", E_INIT);		
		return c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_zero_bond");
		return null<..instr_def>;
	}
}


//----------------
// [NO DATABASE] create
//----------------

/*-----------------------------------------------------------------------
  func: instr_def_zero_bond [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/

instr_def instr_def_zero_bond(	string					instr_def_name,									
								zero_yld_method			yld_method,						
								integer					quasi_cpn_freq,
								..day_count_method 		day_count_method, 													    				   						 															
								string 	 				settle_code,						
								..calendar 	 			calendar,
								string					currency,									
								..quote_style			quote_style,							
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Zero Bond')
{	
	try{	
		instr_def c = __instr_def_zero_nodb(instr_def_name,yld_method,day_count_method, 
											quasi_cpn_freq,settle_code,calendar,currency,quote_style );

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_zero_bond");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_il_zero   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_zero_bond(INSTR_TMPL.zero_def_tmpl			tmpl,
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Zero Bond')
{	
	try{
		instr_def c = __instr_def_zero_nodb(tmpl.name(),tmpl.yld_method(), tmpl.day_count_method(),  
									tmpl.quasi_cpn_freq(),tmpl.settle_code(), tmpl.calendar(),
									tmpl.currency(),tmpl.quote_style());


		return create_instr_def(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_zero_bond");
		return null<instr_def>;
	}
}
 