/*	
	instr_def wrapper functions for zeroois
	Developer: Algorithmica Research, Magnus Nyström

*/

option(null: hard);	


//----------------
// [DATABASE] create
//----------------

/*
instr_def from class: is incomplete
instr_def from instrument: have settle_date/code and maturity_date/code
*/
/*-----------------------------------------------------------------------
  func: instr_def_swap_zeroois
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_zeroois(string 	name ,
								error_info option(nullable) error = null<error_info>) 
option (category: 'Instrument/Interest Rate Swap/Zero vs ONIndex')
{	
	try{
		logical	is_class_name;
		..instr_def c = instr_def(name ,is_class_name ,error); 
		c 				= create_instr_def(c, is_class_name, error);		
		QL_FAIL_COND(!null(c) && !c.is_swap_zeroois(), "instr_def not a zero-ois", E_INIT);		
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_zeroois");
		return null<..instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_zeroois [NO DATABASE]  [LEGACY]
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_zeroois(string				instr_def_name,	
							    string 				settle_code,
							    string 	option(nullable) maturity_code,								
								notional_exchg_style option(nullable) not_exchange,
								integer				payment_lag,
							 	day_count_method 	zero_day_count_method,
							    string 				zero_currency,
							    calendar 			zero_calendar,
							    bd_convention 		zero_bd_convention,
							    logical 			zero_eom,
								integer 			zero_comp_freq,

								integer 			ois_cpn_freq,	  
								..day_count_method 	ois_day_count_method,
								string 				ois_currency,
								..calendar			ois_calendar,	
								..bd_convention 	ois_bd_convention,												
								logical 			ois_eom,																
								rfr_arrears_type option(nullable) 		ois_arr_type,
								number option(nullable)					ois_arr_days,
								logical option(nullable) 				ois_endog_df,
								flt_comp_avg_type option(nullable)		ois_comp_avg,
    							flt_sprd_comp_method option(nullable) 	ois_spread_comp_method,
    							flt_avg_method option(nullable) 		ois_avg_method,	
							    								
								string 				idx_name,
								string 				idx_type,
								integer 			idx_value_days,
								integer 			idx_fixing_days,
								integer 			idx_spot_days,
							    day_count_method option(nullable) 	idx_day_count_method,							   
							    calendar option(nullable) 	idx_calendar,
							    string option(nullable) 	idx_currency,
							    calendar option(nullable) 	idx_suppl_calendar,
								number option(nullable) 	idx_spread,	
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Zero vs ONIndex')
{	
	try{

		if(!equal(idx_type, "IBOR") && !equal (idx_type, "LIBOR") && !equal (idx_type, "RFR"))
			QL_FAIL("index type not applicable", E_INIT);

		ir_index idx = create_ir_index(	idx_name,idx_type,"1D", idx_value_days,idx_fixing_days, idx_day_count_method,
										BD_FOLLOWING, false,
										idx_calendar,//if libor: this is uk
										null<string>,
										idx_currency,
										idx_suppl_calendar,	//if libor: this is primary(ex.target), if ibor: this is null
										null<string>,
										idx_spot_days,idx_spread);
		
		instr_def c = __instr_def_zeroois_nodb(instr_def_name,zero_day_count_method,zero_currency,zero_calendar,zero_bd_convention,
							    				zero_eom,zero_comp_freq,
											    ois_cpn_freq,ois_day_count_method,ois_currency,ois_calendar,ois_bd_convention,ois_eom,
											    
												ois_comp_avg, ois_spread_comp_method,ois_avg_method,ois_arr_type,ois_arr_days,
											    ois_endog_df, idx,settle_code,
												maturity_code,payment_lag,not_exchange );

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_zeroois");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_zeroois [NO DATABASE]  
  this instr_def will be complete but not date_complete
	arguments:
	instr_def_name: user defined name
  ----------------------------------------------------------------------*/
instr_def instr_def_swap_zeroois(string				instr_def_name,	
							    string 				settle_code,
							    string 	option(nullable) maturity_code,								
								notional_exchg_style option(nullable) not_exchange,
								integer				payment_lag,
							 	day_count_method 	zero_day_count_method,
							    string 				zero_currency,
							    calendar 			zero_calendar,
							    bd_convention 		zero_bd_convention,
							    logical 			zero_eom,
								integer 			zero_comp_freq,

								integer 			ois_cpn_freq,	  
								..day_count_method 	ois_day_count_method,
								string 				ois_currency,
								..calendar			ois_calendar,	
								..bd_convention 	ois_bd_convention,												
								logical 			ois_eom,																
								rfr_arrears_type option(nullable) 		ois_arr_type,
								number option(nullable)					ois_arr_days,
								logical option(nullable) 				ois_endog_df,
								flt_comp_avg_type option(nullable)		ois_comp_avg,
    							flt_sprd_comp_method option(nullable) 	ois_spread_comp_method,
    							flt_avg_method option(nullable) 		ois_avg_method,								    							
								ir_index 			on_idx,						
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Zero vs ONIndex')
{	
	try{
		
		instr_def c = __instr_def_zeroois_nodb(instr_def_name,zero_day_count_method,zero_currency,zero_calendar,zero_bd_convention,
							    				zero_eom,zero_comp_freq,
											    ois_cpn_freq,ois_day_count_method,ois_currency,ois_calendar,ois_bd_convention,ois_eom,
											    
												ois_comp_avg, ois_spread_comp_method,ois_avg_method,ois_arr_type,ois_arr_days,
											    ois_endog_df,on_idx,settle_code,
												maturity_code,payment_lag,not_exchange );

		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_zeroois");
		return null<instr_def>;
	}
}


/*-----------------------------------------------------------------------
  func: instr_def_swap_zeroois   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_swap_zeroois(INSTR_TMPL.swap_zeroois_def_tmpl		tmpl,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Zero vs ONIndex')
{	
	try{
		instr_def c = __instr_def_zeroois_nodb(	tmpl.name(),tmpl.zero_day_count_method(),tmpl.zero_currency(),tmpl.zero_calendar(),tmpl.zero_bd_convention(),
							    				tmpl.zero_eom(),tmpl.zero_comp_freq(),
											    tmpl.ois_cpn_freq(),tmpl.ois_day_count_method(),tmpl.ois_currency(),tmpl.ois_calendar(),tmpl.ois_bd_convention(),
												tmpl.ois_eom(),											    
												tmpl.ois_comp_avg(), tmpl.ois_spread_comp_method(),tmpl.ois_avg_method(),tmpl.ois_arr_type(),
												tmpl.ois_arr_days(),tmpl.ois_endog_df(), 
												tmpl.ois_ir_index(),
												tmpl.spot_settle_code(),
												tmpl.maturity_code(),tmpl.payment_lag(),tmpl.not_exchange() );


		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_zeroois");
		return null<instr_def>;
	}
}

/*-----------------------------------------------------------------------
  func: instr_def_swap_zeroois   [NO DATABASE]
  this instr_def will be complete but not date_complete
	arguments:
  	
  ----------------------------------------------------------------------*/

instr_def instr_def_swap_zeroois(INSTR_TMPL.swap_zeroois_def_tmpl		tmpl,
								 string option(nullable) 			maturity_code,//override of template value
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Zero vs ONIndex')
{	
	try{
		if(null(maturity_code))
			maturity_code = tmpl.maturity_code();
		instr_def c = __instr_def_zeroois_nodb(	tmpl.name(),tmpl.zero_day_count_method(),tmpl.zero_currency(),tmpl.zero_calendar(),tmpl.zero_bd_convention(),
							    				tmpl.zero_eom(),tmpl.zero_comp_freq(),
											    tmpl.ois_cpn_freq(),tmpl.ois_day_count_method(),tmpl.ois_currency(),tmpl.ois_calendar(),tmpl.ois_bd_convention(),
												tmpl.ois_eom(),											    
												tmpl.ois_comp_avg(), tmpl.ois_spread_comp_method(),tmpl.ois_avg_method(),tmpl.ois_arr_type(),tmpl.ois_arr_days(),
												tmpl.ois_endog_df(), tmpl.ois_ir_index(),
												tmpl.spot_settle_code(),
												maturity_code,tmpl.payment_lag(),tmpl.not_exchange() );


		return create_instr_def(c, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instr_def.instr_def_swap_zeroois");
		return null<instr_def>;
	}
}
 

