option(null: hard);	

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	TODO:
	1) 6 quote funcs for fx (handling of inverse)


exog_settle_ok(Mw::inst_type_t t) 	
    

case Mw::inst_type_t::IT_FRN:x
case Mw::inst_type_t::IT_CALL_FRN:x 	
case Mw::inst_type_t::IT_DEPO:x
case Mw::inst_type_t::IT_FIX_CPN_BOND:x			
case Mw::inst_type_t::IT_FIX_CPN_CALL_BOND:x
case Mw::inst_type_t::IT_ZERO_BOND:x
???//case Mw::inst_type_t::IT_RIBA:x
case Mw::inst_type_t::IT_REAL_BILL:x
case Mw::inst_type_t::IT_REAL_FIX_CPN_BOND:x	
case Mw::inst_type_t::IT_REAL_ZERO_BOND:x	
case Mw::inst_type_t::IT_BILL:x	    		    			
case Mw::inst_type_t::IT_GENERIC:x 
case Mw::inst_type_t::IT_EQUITY:x 


*/

module CORE_INT
{
	void instr_fail_check(logical fail, string alt_msg, string option(nullable) name, error_info option(nullable) error)
	{
				
		if(fail){
			if(null(name))
				name = "";
			if(null(error))
			   QL_FAIL(alt_msg, name, true) ;
			else if(error.is_error())
				QL_FAIL(error.message(), "", false,error.ql_error_type()) ;
			else
				QL_FAIL(alt_msg, name, true) ;		
		}
	}

	void instr_fail_check(logical fail, string alt_msg, string option(nullable) name, instr_error option(nullable)  error)
	{
		if(fail){
			if(null(name))
				name = "";
			if(null(error))
				QL_FAIL(alt_msg, name, true) ;
			else if(error.is_error())
				QL_FAIL(error.message(), "", false) ;
			else
				QL_FAIL(alt_msg, name, true) ;		
		}
	}

	
}

/*-----------------------------------------------------------------------
  __instrument member: is_valid 
  ----------------------------------------------------------------------*/
logical __instrument.is_valid(out instr_error option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = this.__is_valid(t, s);
		set_instr_error(error,t,s);
		return error.is_error() ? false : c;						
	}
	catch {
		set_instr_error(error,ERR_T_CALC,err.message());
		return false;
	}
}

/*-----------------------------------------------------------------------
  __instrument: instr_type
  ----------------------------------------------------------------------*/
instr_type __instrument.instr_type(out instr_error option(nullable) error) option(hidden)
{	
	try{	
		..__instr_type c = this.__instr_type();
		return CORE_INT.conv_instr_type(c);						
	}
	catch {
		set_instr_error(error,ERR_T_CALC,err.message());
		return null<..instr_type>;
	}
}

//-----------------------------------------------------------------------
//  class fin_instr  <abstract>
//----------------------------------------------------------------------
class fin_instr
option(category: "Instrument") 
option(allow_undeclared_mfuncs)
{
public:
	
	virtual string 		name(error_info option(nullable) error = null<error_info>) = 0;
	virtual date 		trade_date(error_info option(nullable) error = null<error_info> ) = 0;	
	virtual ..instr_type instr_type(error_info option(nullable) error = null<error_info>) = 0;
	virtual logical 	is_instr_type(..instr_type , error_info option(nullable) error = null<error_info>);	
	virtual fin_instr 	clone() 		= 0;
	virtual integer 	id(error_info option(nullable) error = null<error_info> ) = 0;
	virtual logical 	is_valid(error_info option(nullable) error = null<error_info> )= 0;							
	virtual logical 	is_expired(error_info option(nullable) error = null<error_info>)= 0;		
	virtual void        __dbg_print(__dbg_label);
    virtual void        __dbg_browse(__dbg_split);
protected:
	fin_instr();
	fin_instr(fin_instr);
	virtual logical 	mw_lib_type();
	
	//---------------------------------------------------
	//---PROTECTED err funcs---
	//---------------------------------------------------		
	string				na_func_msg(string option(nullable));
	number 				err_type(number option(nullable), error_info option(nullable),string option(nullable) f = null<string>);
	integer 			err_type(integer, error_info option(nullable),string option(nullable) f = null<string>);
	integer 			err_type_freq(integer, error_info option(nullable),string option(nullable) f = null<string>);
	string  			err_type(string  option(nullable), error_info option(nullable),string option(nullable) f = null<string>);
	logical 			err_type(logical option(nullable), error_info option(nullable),string option(nullable) f = null<string>);
	date 				err_type(date option(nullable), error_info option(nullable),string option(nullable) f = null<string>);
	fin_instr 			err_type(fin_instr option(nullable), error_info option(nullable),string option(nullable) f = null<string>);
	bond_fut_style	err_type(bond_fut_style option(nullable), error_info option(nullable),string option(nullable) f = null<string>);
	..frn_neg_rate_rule err_type(..frn_neg_rate_rule option(nullable), error_info option(nullable),string option(nullable) f = null<string>); 
	vector(string) 		err_type(vector(string) option(nullable), error_info option(nullable),string option(nullable) f = null<string>);
	vector(number) 		err_type(vector(number) option(nullable), error_info option(nullable),string option(nullable) f = null<string>);
	vector(date) 		err_type(vector(date) option(nullable), error_info option(nullable),string option(nullable) f = null<string>);
	void  				err_type(error_info option(nullable),string option(nullable) f = null<string>);
	..ir_index			err_type(..ir_index option(nullable), error_info option(nullable),string option(nullable) f = null<string>);
	tenor_code			err_type(tenor_code option(nullable), error_info option(nullable),string option(nullable) f = null<string>);
};

//-----

fin_instr.fin_instr() 			{}
fin_instr.fin_instr(fin_instr) 	{}
logical fin_instr.mw_lib_type() { return false;}

/*-----------------------------------------------------------------------
__dbg_print
----------------------------------------------------------------------*/
void fin_instr.__dbg_print(__dbg_label l)
{
	error_info e = error_info(true,false);
	
    l.set_text(strcat([ "name: ",
						name(e)]));
}
/*-----------------------------------------------------------------------
__dbg_browse
----------------------------------------------------------------------*/
void fin_instr.__dbg_browse(__dbg_split s)
{
    s.resize(1);

	error_info e = error_info(true,false);
	
    s.set_text(0, "name");
    s.set_value(0, name(e));
}
/*-----------------------------------------------------------------------
  is_instr_type
  ----------------------------------------------------------------------*/
logical fin_instr.is_instr_type(	..instr_type 			it, 
									error_info option(nullable) error)
{	
	try{	
		return it == this.instr_type(error);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fin_instr.is_instr_type");
		return false;
	}
}
/*-----------------------------------------------------------------------
  err_type
  ----------------------------------------------------------------------*/
string _na_func_msg option(constant) = "mwlib(ql) error: inapplicable function call for current instrument type";

string fin_instr.na_func_msg(string option(nullable) func)
{
	string f = null(func) ? "" : strcat([" (function: ",func,")"]);
	try {
		error_info  error = new error_info();
		string n = name(error);
		string nn = null(n) ? strcat(_na_func_msg,f) : strcat([_na_func_msg," ['",n,"']",f]);
		return strcat(["<",nn,">"]);
	}
	catch {
		return strcat(["<",_na_func_msg,f,">"]);
	}
}

number fin_instr.err_type(number option(nullable) nul, error_info option(nullable) error,string option(nullable) f )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,na_func_msg(null<string>), f);	
	return null<number>;	
}
integer fin_instr.err_type(integer a, error_info option(nullable) error,string option(nullable) f )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,na_func_msg(null<string>), f);
	return err_int();	
}
integer fin_instr.err_type_freq(integer a, error_info option(nullable) error,string option(nullable) f )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,na_func_msg(null<string>), f);
	return err_freq();	
}
string fin_instr.err_type(string  option(nullable) nul, error_info option(nullable) error,string option(nullable) f )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,na_func_msg(null<string>), f);
	return null<string>;
}
logical fin_instr.err_type(logical  option(nullable) nul, error_info option(nullable) error,string option(nullable) f )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,na_func_msg(null<string>), f);
	return null<logical>;
}
date fin_instr.err_type(date option(nullable) nul, error_info option(nullable) error,string option(nullable) f )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,na_func_msg(null<string>), f);
	return null<date>;
}
fin_instr fin_instr.err_type(fin_instr option(nullable) nul, error_info option(nullable) error,string option(nullable) f )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,na_func_msg(null<string>), f);
	return null<fin_instr>;
}
void fin_instr.err_type(error_info option(nullable) error,string option(nullable) f )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,na_func_msg(null<string>), f);
	return ;
}
bond_fut_style	fin_instr.err_type(bond_fut_style option(nullable), error_info option(nullable) error,string option(nullable) f )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,na_func_msg(null<string>), f);
	return null<bond_fut_style>;
}
..frn_neg_rate_rule	fin_instr.err_type(..frn_neg_rate_rule option(nullable), error_info option(nullable) error,string option(nullable) f )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,na_func_msg(null<string>), f);
	return null<..frn_neg_rate_rule>;
}
vector(string) 	fin_instr.err_type(vector(string) option(nullable), error_info option(nullable) error,string option(nullable) f )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,na_func_msg(null<string>), f);
	return null<vector(string)>;
}
vector(number) 	fin_instr.err_type(vector(number) option(nullable), error_info option(nullable) error,string option(nullable) f )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,na_func_msg(null<string>), f);
	return null<vector(number)>;
}
vector(date) fin_instr.err_type(vector(date) option(nullable), error_info option(nullable) error,string option(nullable) f )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,na_func_msg(null<string>), f);
	return null<vector(date)>;
}
..ir_index	fin_instr.err_type(..ir_index option(nullable), error_info option(nullable) error,string option(nullable) f )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,na_func_msg(null<string>), f);
	return null<..ir_index>;
}
tenor_code	fin_instr.err_type(tenor_code option(nullable), error_info option(nullable) error,string option(nullable) f )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,na_func_msg(null<string>), f);
	return null<tenor_code>;
}

/*-----------------------------------------------------------------------
QL_FAIL_COND
----------------------------------------------------------------------*/
void QL_FAIL_COND(	logical check,
					string option(nullable) e,
					fin_instr option(nullable) i,
					logical option(nullable) inst_err = null<logical>,
					error_type option(nullable) type = E_INVALID_ARG)
option(com_name: 'QL_FAIL_COND_EXT2')
option (category: 'Core Programming/Error Handling')
{
	if(check) {
		if(null(type))
			type = E_INVALID_ARG;
		if(!null(e))
			e = strcat("mwlib(ql) error: ",e);
		if(!null(i)){
			error_info ee = new error_info(true,false);
			throw(type,throw_err(e,i.name(ee),inst_err));
		}
		else {
			throw(type,throw_err(e));
		}
	}
}
/*-----------------------------------------------------------------------
QL_FAIL
----------------------------------------------------------------------*/
void QL_FAIL(	string e,
				fin_instr option(nullable) i,
				logical option(nullable) inst_err = null<logical>,
				error_type option(nullable) type = E_INVALID_ARG)
option(com_name: 'QL_FAIL_EXT2')
option (category: 'Core Programming/Error Handling')
{
	QL_FAIL_COND(true, e, i, inst_err, type );
}
/*-----------------------------------------------------------------------
QL_REQUIRE
----------------------------------------------------------------------*/
void QL_REQUIRE(logical check,
				string option(nullable) e,
				fin_instr option(nullable) i,
				logical option(nullable) inst_err = null<logical>,
				error_type option(nullable) type = E_INVALID_ARG)
option(com_name: 'QL_REQUIRE_EXT2')
option (category: 'Core Programming/Error Handling')
{	
	if(!check) {
		if(null(type))
			type = E_INVALID_ARG;
		if(!null(e))
			e = strcat("mwlib(ql) error: ",e);
		if(!null(i)){
			error_info ee = new error_info(true,false);
			throw(type,throw_err(e,i.name(ee),inst_err));
		}
		else {
			throw(type,throw_err(e));
		}
	}
}
module CORE_INT
{
	/*-----------------------------------------------------------------------
	instr_fail_check
	----------------------------------------------------------------------*/
	void instr_fail_check(logical fail,
						  string alt_msg,
						  fin_instr option(nullable) i,
						  error_info option(nullable) error)
	{			
		if(fail){
			if(null(error)){				
				string name = null(i) ? "" : i.name();
				QL_FAIL(alt_msg, name, true) ;
			}
			else if(error.is_error()){
				QL_FAIL(error.message(), "", false,error.ql_error_type()) ;
			}
			else{
				string name = null(i) ? "" : i.name();
				QL_FAIL(alt_msg, name, true) ;
			}
		}
	}
	/*-----------------------------------------------------------------------
	instr_fail_check
	----------------------------------------------------------------------*/
	void instr_fail_check(logical fail,
						  string alt_msg,
						  fin_instr option(nullable) i,
						  instr_error option(nullable)  error)
	{
		if(fail){
			if(null(error)){
				string name = null(i) ? "" : i.name();
				QL_FAIL(alt_msg, name, true) ;
			}
			else if(error.is_error()){
				QL_FAIL(error.message(), "", false) ;
			}
			else {
				string name = null(i) ? "" : i.name();
				QL_FAIL(alt_msg, name, true) ;
			}
		}
	}	
}
//-----------------------------------------------------------------------
//  class instrument  <abstract>
//----------------------------------------------------------------------
class instrument : public fin_instr
option(category: "Instrument") 
option(allow_undeclared_mfuncs)
{

private:
	__instrument clone_int(error_info option(nullable) error);
	__instrument i_;
public:
	virtual __instrument 		i();						/*hidden, must be public*/
	override instrument 		clone() 		= 0;		//should be removed
	virtual instrument 			inst()			= 0;
	override void            	__dbg_print(__dbg_label);
    override void            	__dbg_browse(__dbg_split);
protected:
	
	instrument(__instrument);
	instrument(instrument);
	instrument();
	virtual instrument  create(	__instrument option(nullable),out instr_error option(nullable) ,error_type t = E_INVALID_ARG) = 0;
	instrument 			err_type(instrument option(nullable), error_info option(nullable),string option(nullable) f = null<string>);

public: 	
	
	//--------------------------------
	//---COMMON--PUBLIC--VISIBLE---	
	//--------------------------------
	//	- public and VISIBLE functions should be relevant for all instr types --> normally no override in child (swaps an exception)
	//    (ext swaps does not support all these functions)
	//	- if hidden it should (unless only for backward compat) be implemented in instr type where it is relevant

	//--general-funcs--
	override string 		name(error_info option(nullable) error = null<error_info>);								/*DLL_SWAP_HANDLER*/
	override logical 		is_valid(error_info option(nullable) error = null<error_info> );						/*DLL_SWAP_HANDLER*/	
	override logical 		is_expired(error_info option(nullable) error = null<error_info>);						/*DLL_SWAP_HANDLER*/
	override date 			trade_date(error_info option(nullable) error = null<error_info> );						/*DLL_SWAP_HANDLER*/
	virtual date 			settle_date(error_info option(nullable) error = null<error_info> );						/*redef: BILL_FUTURE, BOND_FUTURE*/	/*DLL_SWAP_HANDLER*/
	virtual instr_def 		instr_def(error_info option(nullable) error = null<error_info>);						/*DLL_SWAP_HANDLER*/
	override instr_type 	instr_type(error_info option(nullable) error = null<error_info>);						/*DLL_SWAP_HANDLER*/
	override integer 		id(error_info option(nullable) error = null<error_info> );								/*DLL_SWAP_HANDLER*/
	virtual string 			class_name(error_info option(nullable) error = null<error_info> );						/*DLL_SWAP_HANDLER*/
	virtual string 			issuer(error_info option(nullable) error = null<error_info>  );							/*DLL_SWAP_HANDLER*/
	virtual string 			err_msg(error_info option(nullable) error = null<error_info>  );	
	virtual string 			quote_side(error_info option(nullable) error = null<error_info>  );
	virtual logical 		quote_side_is_comp(out string ,out string ,error_info option(nullable) error = null<error_info>  );
 	virtual calendar 		calendar(integer ,error_info option(nullable) error = null<error_info>  );				/*redef: FIXFLT,FIXOIS,OISOIS*/		/*DLL_SWAP_HANDLER(leg1)*/	
	virtual calendar 		calendar(error_info option(nullable) error = null<error_info>  );						/*redef: FIXFLT,FIXOIS,OISOIS*/		/*DLL_SWAP_HANDLER(leg1)*/	
	virtual string 			calendar_name(integer, error_info option(nullable) error = null<error_info> );			/*redef: FIXFLT,FIXOIS,OISOIS*/		/*DLL_SWAP_HANDLER(leg1)*/	
	virtual string 			calendar_name(error_info option(nullable) error = null<error_info> );					/*redef: FIXFLT,FIXOIS,OISOIS*/		/*DLL_SWAP_HANDLER(leg1)*/	
	virtual string 			settle_code(error_info option(nullable) error = null<error_info> );						/*redef: FIXFLT,FIXOIS,OISOIS*/		/*DLL_SWAP_HANDLER(leg1)*/
	virtual string 			currency(error_info option(nullable) error = null<error_info> );						/*redef: FIXFLT,FIXOIS,OISOIS*/		/*DLL_SWAP_HANDLER(leg1)*/
	string 					value_code();																			/*legacy, hidden*/
	virtual string 			quote_style(error_info option(nullable) error = null<error_info>  );					/*DLL_SWAP_HANDLER(leg1)*/			
	virtual quote_style		quote_style_e(error_info option(nullable) error = null<error_info>  );					/*DLL_SWAP_HANDLER(leg1)*/
	virtual string 			realtime_feed(error_info option(nullable) error = null<error_info>  );					/*DLL_SWAP_HANDLER*/
	virtual string 			realtime_ric(error_info option(nullable) error = null<error_info>  );					/*DLL_SWAP_HANDLER*/
	virtual string 			realtime_fid(error_info option(nullable) error = null<error_info>  );					/*DLL_SWAP_HANDLER*/
	virtual void 			realtime_feed(out vector(string),error_info option(nullable) error = null<error_info>  );/*DLL_SWAP_HANDLER*/
	virtual void 			realtime_ric(out vector(string), error_info option(nullable) error = null<error_info>  );/*DLL_SWAP_HANDLER*/
	virtual void 			realtime_fid(out vector(string), error_info option(nullable) error = null<error_info>  );/*DLL SWAP_HANDLER*/
	virtual string 			quote_key(error_info option(nullable) error = null<error_info> );						/*DLL SWAP_HANDLER*/
	virtual string 			quote_table(error_info option(nullable) error = null<error_info>  );					/*DLL_SWAP_HANDLER*/			
	virtual number			quote_unit_dec(error_info option(nullable) error = null<error_info>   );
	//--quote-funcs--
	virtual number 			quote(error_info option(nullable) error = null<error_info>   );							/*DLL_SWAP_HANDLER, for ext_swap always just one quotestyle*/
	number  				quote_orig(error_info option(nullable) error = null<error_info>  ) ; 					/*internal, hidden, calls quote()*/

	logical 				valid_in_bootstrap(error_info option(nullable) error = null<error_info> );
	logical 				valid_in_bootstrap_fwd(error_info option(nullable) error = null<error_info> );
		//FIX_ME: next 6 quote functions not applicable for fx, only the basic quote function supports inverse quote 
	virtual number 			quote(date option(nullable),string option(nullable) qs = null<string>,
								  error_info option(nullable) error = null<error_info>);							/*err: ext_swap*/
	virtual number 			quote(integer,string option(nullable) qs = null<string>,
								  error_info option(nullable) error = null<error_info>);							/*err: ext_swap*/
	virtual vector(number) 	quote(vector(date),string option(nullable) qs = null<string>,
								  error_info option(nullable) error = null<error_info>);							/*err: ext_swap*/
	virtual number 			quote(..quote_style option(nullable) , error_info option(nullable) error = null<error_info> );			/*err: ext_swap */  	/*DLL_SWAP_HANDLER*/
	virtual number 			quote(disc_func,..quote_style option(nullable), error_info option(nullable) error = null<error_info> );	/*err: swaps except fixflt,fixois,rr_fixflt, eq, fx, bondfut*/
	
	number 					get_quote(string option(nullable) ) ;													/*legacy, hidden, calls quote(date,string)*/
	number 					get_quote_num(string option(nullable) ) ;												/*legacy, hidden, calls quote(date,string)*/

	virtual logical			required_fixings_valid(error_info option(nullable) error = null<error_info>);
	
	//--pv--	
	virtual number 			present_value(	number option(nullable) nom = null<number>, logical trade_date_pv = false,
											disc_func option(nullable) disc_func_disc = null<disc_func>, 
											error_info option(nullable) error = null<error_info>);					/*redef: FIXFLT,FIXOIS, OISOIS*/
	
	virtual number 			present_value(	disc_func, number option(nullable) nom=null<number>, logical trade_date_pv = false,
											disc_func option(nullable) disc_func_disc = null<disc_func>, 
											error_info option(nullable) error = null<error_info>);					/*redef: FIXFLT,FIXOIS, OISOIS*/	
	//--------------------------------
	//-----PUBLIC--VISIBLE---BUT NOT COMMON FOR ALL TYPES!
	//--------------------------------
	//	--> moved to public even though they are not relevant for all types of instruments (-->backward compat)
	//	--> these are sometimes implemented also in child(not necessary) (--> ok for now but remove in child)
	//	--> if not relevant they should be overridden and throw an error
	
	//--general--
	virtual number 			nominal(error_info option(nullable) error = null<error_info> );					/*redef: FIXFLT,FIXOIS,OISOIS*/			/*DLL_SWAP_HANDLER(leg1)*/	
	virtual date 			maturity(error_info option(nullable) error = null<error_info> );														/*DLL_SWAP_HANDLER(leg1)*/
	virtual date 			maturity_adj(error_info option(nullable) error = null<error_info> );													/*DLL_SWAP_HANDLER(leg1)*/
	virtual string 			maturity_code(error_info option(nullable) error = null<error_info> );			/*done:DEPO,BILL,BILL_FUT,BOND,ZERO, BOND_FUT*/		
	virtual number 			coupon_rate(error_info option(nullable) error = null<error_info> );				/*redef: FIXFLT,FIXOIS, OISOIS*/		/*DLL_SWAP_HANDLER(leg1)*/	
	virtual number 			face_amount(error_info option(nullable) error = null<error_info>);				/*redef: BILL_FUT,BOND_FUT*/	/*err: DEPO, FIXFLT,FIXOIS,OISOIS*/ /*DLL_SWAP_HANDLER(err)*/ 
	virtual integer 		coupon_freq(error_info option(nullable) error = null<error_info> );				/*redef: FIXFLT,FIXOIS,OISOIS*/	/*err: DEPO,BILL,BILL_FUT*/  		/*DLL_SWAP_HANDLER(leg1)*/ 	
	virtual date 			issue_date(error_info option(nullable) error = null<error_info> );				/*redef: FIXFLT,FIXOIS,OISOIS*/ 		/*DLL_SWAP_HANDLER*/	

	virtual string 			__curve_sort_maturity(); 
	//--cashflow-funcs--
	virtual vector(date)	cash_flow_dates(logical post_settle = true, logical adj_dates = true,
											logical keep_size = false,
											error_info option(nullable) error = null<error_info>);			/*redef:BILL_FUT,BOND_FUT,FIXFLT,FIXOIS,OISOIS*/
	virtual vector(number)	cash_flows(	number option(nullable) nom = null<number>,
										logical post_settle = true, logical keep_size = false,
										error_info option(nullable) error = null<error_info> );				/*redef:BILL_FUT,BOND_FUT,FIXFLT,FIXOIS,OISOIS*/
	virtual vector(number)	cash_flows_cpn(	number option(nullable) nom = null<number>,
											logical post_settle = true, logical keep_size = false,
											error_info option(nullable) error = null<error_info> );			/*redef:BILL_FUT,BOND_FUT,FIXFLT,FIXOIS,OISOIS*/
	virtual void 			cash_flow_data(	number option(nullable), logical, ir_cf_code,logical,
											logical ,out vector(date),out vector(number)  ,
											error_info option(nullable) error = null<error_info>);			/*redef:BILL_FUT,BOND_FUT,FIXFLT,FIXOIS,OISOIS*/

	//--cashflow-funcs legacy--
	virtual void 			cash_flows(	out vector(date),out vector(number),
										number option(nullable) nominal = null<number>,
										logical post_settle = true ,											
										error_info option(nullable) error = null<error_info> );				/*legacy, hidden*/ 		/*redef:FIXFLT,FIXOIS,OISOIS*/
	
	virtual vector(date)	cash_flow_dates_noadj(logical post_settle = true ,
												error_info option(nullable) error = null<error_info>);		/*legacy, hidden*/		/*redef:FIXFLT,FIXOIS,OISOIS*/				
	
	virtual vector(number)	cash_flow_amounts(	number option(nullable) nom = null<number>,
												logical post_settle = true, logical keep_size = false,
												error_info option(nullable) error = null<error_info> );		/*legacy, hidden*/		/*redef:FIXFLT,FIXOIS,OISOIS*/		
	
	virtual vector(number)	cash_flow_nom_amounts(	number option(nullable) nominal = null<number>,
													logical post_settle = true, logical keep_size = false,
													error_info option(nullable) error = null<error_info> );	/*legacy, hidden*/	/*redef:FIXFLT,FIXOIS,OISOIS*/
	
	vector(number)			cash_flow_cpn();																/*legacy, hidden*/

	//--fixed income: risk--
	virtual number 		pvbp(number option(nullable),number option(nullable),logical option(nullable),
							logical option(nullable),error_info option(nullable) error = null<error_info>) ;
	virtual number 		pvbp(number option(nullable) = null<number>,number  option(nullable) = null<number>,error_info option(nullable) error = null<error_info>);


	//number 				pvbp(number option(nullable) delta = 0.0001,error_info option(nullable) error = null<error_info>);				/*legacy, hidden*/
	virtual number 		mac_dur(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) error = null<error_info>);	
	virtual number 		mod_dur(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) error = null<error_info>);	
	virtual number 		dol_dur(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) error = null<error_info>);			
	virtual number 		convexity(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) error = null<error_info>);	
	virtual number 		dol_convexity(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) error = null<error_info>);	
	virtual number 		sensitivity(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) error = null<error_info>);		
	
	//--fixed income: price--
	//yield
	virtual number 		yield(logical dr = false,error_info option(nullable) error = null<error_info> );						/*DLL_SWAP_HANDLER, err for ext swap*/
	number 				yield_py(logical dr = false,error_info option(nullable) error = null<error_info> );							/*hidden, for python*/
	virtual number 		yield(disc_func,logical disable_rounding = false ,error_info option(nullable) error = null<error_info>);
	number 				yield_py(disc_func,logical disable_rounding = false ,error_info option(nullable) error = null<error_info>);	/*hidden, for python*/
	virtual number 		price_to_yield(number ,..quote_style,error_info option(nullable) error = null<error_info>);
	number 				price_to_yield(number ); 																				/*legacy, hidden*/
	
	virtual number 		dirty_price_to_yield(number ,logical,error_info option(nullable) error = null<error_info>);				/*legacy, unhidden because of vba*/
	virtual number 		clean_price_to_yield(number ,logical,error_info option(nullable) error = null<error_info>);				/*legacy, unhidden because of vba*/

	//price
	virtual number  	dirty_price(number option(nullable) ,logical disable_rounding = false,
									logical in_pcnt = true,error_info option(nullable) error = null<error_info>);
	virtual number 		dirty_price(logical disable_rounding = false,logical in_pcnt = true,
									error_info option(nullable) error = null<error_info>);	
	virtual number 		dirty_price(disc_func,logical disable_rounding = false,
									logical in_pcnt = true,error_info option(nullable) error = null<error_info>);
	
	virtual number 		clean_price(number option(nullable),logical disable_rounding = false,
									logical in_pcnt = true,error_info option(nullable) error = null<error_info>);
	virtual number 		clean_price(logical disable_rounding = false,logical in_pcnt = true,
									error_info option(nullable) error = null<error_info>);														
	virtual number 		clean_price(disc_func,logical disable_rounding = false,
									logical in_pcnt = true,error_info option(nullable) error = null<error_info>);
		
	virtual number 		yield_to_price(number ,..quote_style,error_info option(nullable) error = null<error_info>);
	virtual number 		yield_to_clean(number,logical disable_rounding = false);										/*legacy, hidden*/	
	virtual number 		yield_to_dirty(number,logical disable_rounding = false);										/*legacy, hidden*/		

	//accr
	virtual number 		accrued(logical disable_rounding = false,logical in_pcnt = true,
								error_info option(nullable) error = null<error_info>);
	
/*	--------------------------------
	---PUBLIC--HIDDEN--- 
	--------------------------------
		- can be called from any instrument type and does not return an error in ql 
		  but should return error from dll if not applicable to the type of instrument
		- in the root because of backward compat and in some cases because it is convenient
		- these funcs should be implemented in child if relevant
*/
	virtual logical 			is_ext_swap(error_info option(nullable) error = null<error_info>  );
	virtual logical 			is_ccy_swap(error_info option(nullable) error = null<error_info>  );
	
	//--add-funcs--			
	virtual void 				add_nominal(number );																		/*done:DEPO,BILL,BOND,BILL_FUT,ZERO,BOND_FUT*/							
	virtual void 				add_quote(number, logical option(nullable) set_coupon_to_quote = null<logical>  );			/*done:DEPO,BILL,BOND,BILL_FUT,ZERO,BOND_FUT,*/
	virtual void 				add_quote_from_yield(number,logical option(nullable) set_coupon_to_yield = null<logical>);	/*done:DEPO,BILL,BOND,BILL_FUT,ZERO,*/

	//--general--
	void						update_quote(logical ignore_null_quote= true);
	integer 					cpn_freq();																	/*legacy, hidden*/		
	virtual number 				coupon(error_info option(nullable) error = null<error_info> );				/*redef: FIXFLT,FIXOIS, OISOIS*/							/*DLL_SWAP_HANDLER(leg1)*/ 	
	virtual logical 			eom(error_info option(nullable) error = null<error_info>  );				/*done:DEPO,BILL,BOND,ZERO, FLTFLT,FIXOIS,OISOIS*/			/*DLL_SWAP_HANDLER(leg1)*/
	virtual day_count_method 	dc_method(error_info option(nullable) error = null<error_info> );			/*done:DEPO,BILL,BILL_FUT,ZERO, FLTFLT,FIXOIS,OISOIS*/		/*DLL_SWAP_HANDLER(leg1)*/		
	virtual bd_convention 		pmt_bus_day(error_info option(nullable) error = null<error_info> );			/*done:DEPO,BILL,BOND,ZERO, FIXFLT,FIXOIS, OISOIS*/			/*DLL_SWAP_HANDLER(leg1)*/
	virtual date 				next_cpn_date(error_info option(nullable) error = null<error_info> );		/*done:DEPO,BILL,BOND*/
	virtual date 				next_excpn_date(error_info option(nullable) error = null<error_info> );		/*done:BILL,BOND */											/*DLL_SWAP_HANDLER(err)*/
	virtual date 				next_cpn_date_adj(error_info option(nullable) error = null<error_info>);	/*done:BOND */		
	virtual date 				previous_cpn_date(error_info option(nullable) error = null<error_info>);	/*done:BOND */
	date 						last_cpn_date();															/*legacy*/	
	virtual date 				first_cpn_date(error_info option(nullable) error = null<error_info>  );		/*done:DEPO,BILL,BOND, FLTFLT,FIXOIS,OISOIS*/
	virtual date 				first_settle_date(error_info option(nullable) error = null<error_info> );	/*done:DEPO,BILL,BOND,ZERO*/								/*DLL_SWAP_HANDLER*/	
	virtual integer 			comp_freq(error_info option(nullable) error = null<error_info> );			/*done:BOND,ZERO*/
	virtual date 				cpn_start_date(error_info option(nullable) error = null<error_info>);		/*done:DEPO,BILL,BOND*/ /*redef: FIXFLT, FIXOIS, OISOIS*/ 	/*DLL_SWAP_HANDLER(leg1)*/					
	virtual date 				last_reg_cpn_date(error_info option(nullable) error = null<error_info>);	/*done:BOND, FLTFLT,FIXOIS,OISOIS */
	virtual date 				last_reg_cpn_date_adj(error_info option(nullable) error = null<error_info>);/*done:BOND */	
	
	virtual day_count_method 	accr_dc_method(error_info option(nullable) error = null<error_info>);		/*done:BILL,BOND,*/											/*DLL_SWAP_HANDLER(leg1)*/
	virtual number 				first_coupon(error_info option(nullable) error = null<error_info>);			/*legacy*/
	virtual number 				first_coupon_rate(error_info option(nullable) error = null<error_info> );	/*done:BOND, FRN, ILBOND */
	virtual number 				first_cpn_amount(error_info option(nullable) error = null<error_info> );	/*done:DEPO,BILL,BOND*/
	virtual number 				last_cpn_amount(error_info option(nullable) error = null<error_info> );		/*done:BOND */
	number 						last_coupon();																/*legacy*/				
	virtual number 				next_cpn_amount(error_info option(nullable) error = null<error_info> );		/*done:DEPO,BILL,BOND*/
	number 						next_coupon();																/*legacy*/				
	virtual logical 			is_regular_first(error_info option(nullable) error = null<error_info>);		/*done:BOND, FLTFLT,FIXOIS,OISOIS */						/*DLL_SWAP_HANDLER(leg1)*/		
	virtual logical 			is_regular_last(error_info option(nullable) error = null<error_info> );		/*done:BOND, FLTFLT,FIXOIS,OISOIS */						/*DLL_SWAP_HANDLER(leg1)*/	
	virtual number 				redemp_price(error_info option(nullable) error = null<error_info>);			/*done:BILL,BOND,BILL_FUT,ZERO, */							/*DLL_SWAP_HANDLER(err)*/				
	virtual day_count_method 	next_dc_method(error_info option(nullable) error = null<error_info> );		/*done:BOND,ZERO, */										/*DLL_SWAP_HANDLER(leg1)*/					
	virtual day_count_method 	accr_last_dc_method(error_info option(nullable) error = null<error_info> );	/*done:BOND */												/*DLL_SWAP_HANDLER(leg1)*/
	virtual day_count_method 	next_last_dc_method(error_info option(nullable) error = null<error_info> );	/*done:BOND,ZERO  */										/*DLL_SWAP_HANDLER(leg1)*/
	virtual integer 			roll_day(error_info option(nullable) error = null<error_info> );			/*done:BOND, FIXFLT,FIXOIS,OISOIS  */						/*DLL_SWAP_HANDLER(leg1)*/		
	virtual string 				excpn_code(error_info option(nullable) error = null<error_info> );			/*done:BILL,BOND */											/*DLL_SWAP_HANDLER(err)*/
	virtual number 				issued_amount(error_info option(nullable) error = null<error_info>);		/*done:BILL,BOND,ZERO*/										/*DLL_SWAP_HANDLER(err)*/

	virtual date 				maturity_blend(error_info option(nullable) error = null<error_info>);		/*used for blending, fra/mmfut must have override*/
	//---analytic versions of risk funcs are all legacy and should not be implemented in child (except frn)
	virtual number 		mac_dur_analytic(error_info option(nullable) = null<error_info>);									/*legacy*/
	virtual number 		mod_dur_analytic(error_info option(nullable) = null<error_info>);									/*legacy*/
	virtual number 		dol_dur_analytic(error_info option(nullable) = null<error_info>);									/*legacy*/
	virtual number 		pvbp_analytic(number option(nullable) = null<number>,error_info option(nullable) = null<error_info>);/*legacy*/
	virtual number 		convexity_analytic(error_info option(nullable) = null<error_info>);									/*legacy*/
	virtual number 		dol_convexity_analytic(error_info option(nullable) = null<error_info>);								/*legacy*/
	virtual number 		sensitivity_analytic(error_info option(nullable) = null<error_info>);								/*legacy*/

	//--fixed income: price--					
	virtual number 		accrued_period(error_info option(nullable) error = null<error_info>);									/*done:DEPO,BILL,BOND*/
	virtual number 		accrued_period(out integer,error_info option(nullable) error = null<error_info>);						/*backward compat*/
	virtual integer 	accrued_days(error_info option(nullable) error = null<error_info>);										/*done: DEPO, BILL, BOND*/	
	virtual number 		accrued_chg(integer,out number,out date, 
									out date,logical in_pcnt = true,
									error_info option(nullable) error = null<error_info>) ; 									/*done:DEPO,BILL,BOND*/									
										
	virtual number 		clean_price_to_coupon(number,disc_func,error_info option(nullable) error = null<error_info>) ; 			/*done:DEPO,BOND*/									
	
	virtual number 		dirty_price_diff(number,number option(nullable),date option(nullable) ,
										logical,error_info option(nullable) error = null<error_info>) ;							/*internal for now*/
	
	number 				diff_dirty(number,number option(nullable),date option(nullable),logical);  								/*legacy*/
	
	virtual number 		convexity_cf(	number option(nullable) ,number,number,logical option(nullable),logical option(nullable),
										out number ,out number,
										error_info option(nullable) error = null<error_info>) ;										/*done: */
																
	virtual number 		pvbp_diff(number,number,logical option(nullable),logical option(nullable),
									error_info option(nullable) error = null<error_info>) ;											/*internal for now*/
	
	virtual number 		pl_intraday(number,date option(nullable),number,number ,disc_func option(nullable) ,
									out number, out number,
									error_info option(nullable) error = null<error_info>) ; 										/*internal for now, work in progress*/ 
	virtual number 		pl_intraday(number ,date option(nullable),disc_func ,disc_func ,
									out number, out number,
									error_info option(nullable) error = null<error_info>) ; 										/*internal for now, work in progress*/ 
		
	virtual number 		price_to_coupon(number,disc_func )  ;																		/*legacy*/

	virtual void  		funding(	date,number,number option(nullable) ,day_count_method ,rate_type option(nullable) ,
									disc_func option(nullable),cpn_reinv_type,number option(nullable), out number,
									out number,out number	,out number,out number,out number,out number,
									error_info option(nullable) error = null<error_info>) ; 											/*done:,BILL,BOND,ZERO */

	virtual number  	clean_price_fwd(date ,number ,number option(nullable) ,day_count_method,rate_type option(nullable) ,
										disc_func option(nullable) ,cpn_reinv_type,error_info option(nullable) error = null<error_info>) ; 	/*done:BILL,BOND,ZERO */

	virtual number  	dirty_price_fwd(date ,number ,number option(nullable) ,day_count_method,rate_type option(nullable) ,
										disc_func option(nullable) ,cpn_reinv_type,error_info option(nullable) error = null<error_info>) ; 	/*done:BILL,BOND,ZERO */

	virtual number  	yield_fwd(date ,number ,number option(nullable) ,day_count_method,rate_type option(nullable) ,
										disc_func option(nullable) ,cpn_reinv_type,error_info option(nullable) error = null<error_info>) ; 	/*done:BILL,BOND,ZERO */

	virtual number  	horizon_return(date ,number ,..quote_style	option(nullable),number option(nullable) ,
										day_count_method,rate_type option(nullable),disc_func option(nullable) ,
										cpn_reinv_type,error_info option(nullable) error = null<error_info>) ; 								/*done:BILL,BOND,ZERO */

	virtual void  		roll_down(	date,disc_func option(nullable) ,day_count_method,rate_type option(nullable),
									logical option(nullable),out number,out number ,out number ,
									out number ,out date,error_info option(nullable) error = null<error_info>) ; 					/*done:BILL,BOND,ZERO */

	//INTERNAL: fixed_income: internal cashflow funcs for bootstrap, should not be implemented in child
	logical 			cash_flows_bootstrap(out vector(date)  ,out vector(number), error_info option(nullable) error = null<error_info>) ;			/*internal*/
	logical 			cash_flows_fwd_bootstrap(out vector(date) ,out vector(number) , number option(nullable),out vector(date) ,out vector(date) , 
												out vector(number), error_info option(nullable) error = null<error_info>) ;							/*internal*/
/*  --------------------------------------------
	---FUTURES--PUBLIC--HIDDEN--IMPL._IN_ROOT--- 
	--------------------------------------------
		
		- public hidden functions in root that corresponds to function in futures (billfut, bondfut, irfut, onfut, ...)
		- the functions with prefix 'fut_' must be here for backward compat
		- not virtual because they have different name (no prefix) in child		
		- relies on c++ to return an error if called from wrong instr type since there is no throw in the root
		- impl. in root because they are relevant for several instr types
*/
	logical 	fut_daily_mtm(error_info option(nullable) error = null<error_info>);								/*DLL_SWAP_HANDLER(err)*/												
	number 		fut_tick_value(number option(nullable),error_info option(nullable) error = null<error_info> );		
	number 		fut_contract_size(error_info option(nullable) error = null<error_info>);							/*DLL_SWAP_HANDLER(err)*/					
	number 		fut_tick_size(error_info option(nullable) error = null<error_info> );
	
/*  ---------------------------------------------------
	---IBOR INDEX DEP--PUBLIC--HIDDEN--IMPL._IN_ROOT--- 
	---------------------------------------------------
		- virtual because they have same name in child
		- relies on c++ to return an error if called from wrong instr type since there is no throw in the root
		- impl. in root because they are relevant for several instr types
*/

	virtual calendar 	fixing_calendar(error_info option(nullable) error = null<error_info> );					
	virtual string 		fixing_calendar_name(error_info option(nullable) error = null<error_info>);				
	virtual string 		fixing_code(error_info option(nullable) error = null<error_info> );						
	virtual date 		index_maturity(error_info option(nullable) error = null<error_info> );				
	virtual ir_index 	ir_index(error_info option(nullable) error = null<error_info> ); 				/*done:DEPO, FIXFLT,FIXOIS,OISOIS */	 /*DLL_SWAP_HANDLER(not for ext swap)*/						
	virtual date		fixing_date(error_info option(nullable) error = null<error_info>);														/*not for swaps*/
	virtual string 		index_tenor(error_info option(nullable) error = null<error_info>) ;				/*done:DEPO */			
	virtual tenor_code 	index_tenor_code(error_info option(nullable) error = null<error_info>);			/*done:DEPO */
	virtual string 		fixing_curve(error_info option(nullable) error = null<error_info>) ;	
	virtual string 		fixing_instr(error_info option(nullable) error = null<error_info>) ;	
	virtual string 		fixing_instr_qs(error_info option(nullable) error = null<error_info>) ;			
		
/*  ---------------------------------------------------
	---FX--PUBLIC--HIDDEN--IMPL._IN_ROOT--- 
	---------------------------------------------------

		- public hidden functions in root that corresponds to function in fx instruments (spot.fwd, swap)
		- the functions with prefix 'fx_' must be here for backward compat
		- not virtual because they have different name (no prefix) in child		
		- relies on c++ to return an error if called from wrong instr type since there is no throw in the root
		- impl. in root because they are relevant for several instr types
*/

	void  			fx_add_quote(	number, logical option(nullable) );  
	date 			fx_spot_date(error_info option(nullable) error = null<error_info>) ;
	integer 		fx_pip_decimals(error_info option(nullable) error = null<error_info> );
	integer 		fx_quote_dec(error_info option(nullable) error = null<error_info>); 
	integer 		fx_scale(error_info option(nullable) error = null<error_info>);
	integer 		fx_spot_days(error_info option(nullable) error = null<error_info>); 
	logical 		fx_reverse_ric(error_info option(nullable) error = null<error_info>); 
	logical 		fx_is_post_spot(instrument,error_info option(nullable) error = null<error_info> ) ;
	logical 		fx_is_on(error_info option(nullable) error = null<error_info> ) ;
	string 			fx_base_ccy(error_info option(nullable) error = null<error_info>) ;
	string 			fx_price_ccy(error_info option(nullable) error = null<error_info>) ;
	string 			fx_spot_name(error_info option(nullable) error = null<error_info>) ;
	string 			fx_spot_code(error_info option(nullable) error = null<error_info>) ;
	calendar 		fx_base_ccy_calendar(error_info option(nullable) error = null<error_info>) ;
	calendar 		fx_price_ccy_calendar(error_info option(nullable) error = null<error_info>) ;
	calendar 		fx_usd_calendar(error_info option(nullable) error = null<error_info>) ;
	string 			fx_base_ccy_calendar_name(error_info option(nullable) error = null<error_info>) ;
	string 			fx_price_ccy_calendar_name(error_info option(nullable) error = null<error_info>) ;
	string 			fx_usd_calendar_name(error_info option(nullable) error = null<error_info>) ;
	..fx_spot_rule 	fx_rule(error_info option(nullable) error = null<error_info> );
	number 			fx_quote(logical unit_quote=false,logical no_rnd = false,error_info option(nullable) error = null<error_info>) ; 
	number 			fx_quote_inv(number option(nullable) scale = 1,logical no_rnd = false ,error_info option(nullable) error = null<error_info>); 

	calendar 		base_ccy_calendar( );		/*legacy*/
	calendar 		price_ccy_calendar( );		/*legacy*/
	calendar 		usd_calendar( ) ;			/*legacy*/
	integer 		fx_pip_value();				/*legacy*/

	//fx_synt_depo have the implementation in fxfwd and fxswap because they return a deposit (since we cannot forward declare a class!!)
	//--> throws error in root
	virtual instrument  fx_synt_depo(instrument,day_count_method,number,day_count_method,logical ,instrument option(nullable),
									error_info option(nullable) error = null<error_info> ) ;
	
/*  ---------------------------------------------------
	---INDEXLINKED--PUBLIC--HIDDEN--IMPL._IN_ROOT--- 
	---------------------------------------------------

		- public hidden functions in root that corresponds to function in indexlinked instrument
		- the functions with prefix _il must be here for backward compat
		- not virtual because they have different name in child (update: some made virtual)
		- a version without the prefix il_ is used for the specific instr type		
		- relies on c++ to return an error if called from wrong instr type since there is no throw in the root
*/
	
	number 			il_dirty_price(	cpi_link option(nullable) ,disc_func ,
									error_info option(nullable) error = null<error_info> );		
 	number 			dirty_price(cpi_link option(nullable), disc_func ) ;													/*legacy*/
	number 			il_clean_price(	logical ex = false, error_info option(nullable) error = null<error_info> );
	integer 		il_index_freq(	error_info option(nullable) error = null<error_info> );
	integer 		index_freq();																							/*legacy*/
	number 			il_index_factor(error_info option(nullable) error = null<error_info>);
	number 			index_factor();																							/*legacy*/
	number 			il_index_factor(date option(nullable),date,	
									error_info option(nullable) error = null<error_info>);
	number 			index_factor(date);																						/*legacy*/
	virtual number 	il_base_cpi(error_info option(nullable) error = null<error_info>);
	virtual number 	base_cpi();																								/*legacy*/
	//number 			il_imp_index(error_info option(nullable) error = null<error_info>);
	vector(number) 	il_cash_flow_nom_amounts(cpi_link option(nullable), number option(nullable) nominal = null<number>,
											logical post_settle = true,logical=false,
											 error_info option(nullable) error = null<error_info>);
	vector(number) 	cash_flow_nom_amounts(cpi_link); 																		/*legacy*/
	
	vector(number) 	il_cash_flow_nom_cpn(cpi_link option(nullable),number option(nullable) 
									nominal = null<number>,logical post_settle = true,
									logical k=false,error_info option(nullable) error = null<error_info>);

	vector(number) 	il_cash_flow_amounts(cpi_link option(nullable),number option(nullable),logical,
									logical,ir_cf_code,il_cf_code ,
									error_info option(nullable) error = null<error_info>);

	cpi_link 		il_cpi_link(error_info option(nullable) error = null<error_info>);
	cpi_link 		il_cpi_link_idx2(error_info option(nullable) error = null<error_info>);

	void  			il_cpi_knots(date,out date,out date,out logical ,
								out logical  ,error_info option(nullable) error = null<error_info>);
	void  			cpi_knots(date ,out date,out date,out logical ,
								out logical );																/*legacy*/
	void  			il_cpi_values(out number,out number,
								  error_info option(nullable) error = null<error_info>); 
	void			get_cpi_values(out number ,out number);								/*legacy*/
	
	void  			il_bond_funding(date ,number,number option(nullable) ,
									day_count_method ,rate_type option(nullable) ,
									disc_func option(nullable) ,cpn_reinv_type 	,cpi_link option(nullable) 	,						
									number option(nullable), out number	,out number,
									out number ,out number,
									out number,out number,
									out number ,out number,
									out number ,out number,
									out number ,error_info option(nullable) error = null<error_info>) ;
	
	number  		il_clean_price_fwd(date ,number,number option(nullable) ,day_count_method,
									rate_type option(nullable) ,disc_func option(nullable) ,	
									cpn_reinv_type ,cpi_link option(nullable) ,
									logical,error_info option(nullable) error = null<error_info>);

	number  		il_dirty_price_fwd(date ,number,number option(nullable),day_count_method,
										rate_type option(nullable) ,disc_func option(nullable),	
										cpn_reinv_type ,cpi_link option(nullable) ,
										error_info option(nullable) error = null<error_info>);

	number  		il_yield_fwd(	date ,number,number option(nullable),day_count_method,rate_type option(nullable),
									disc_func option(nullable) ,cpn_reinv_type ,cpi_link option(nullable),	
									error_info option(nullable) error = null<error_info>);

	void  			il_roll_down(	date,disc_func,logical,day_count_method,rate_type option(nullable) ,cpi_link option(nullable),						
									out number	,out number,out number,
									out number, error_info option(nullable) error = null<error_info>);

	number  		il_horizon_return(	date ,number,..quote_style option(nullable),number option(nullable),
										day_count_method ,rate_type option(nullable),disc_func option(nullable),
										cpn_reinv_type ,cpi_link option(nullable) ,
										error_info option(nullable) error = null<error_info>);
	
/*  ---------------------------------------------------
	---SWAPS--PUBLIC--HIDDEN--IMPL._IN_ROOT--- 
	---------------------------------------------------

		- public hidden functions in root that corresponds to function in swap instrument
		- the functions with prefix must be here for backward compat		
		- a version without the prefix is used for the specific instr type		
		- relies on c++ to return an error if called from wrong instr type since there is no throw in the root
*/

	// - virtual because they have same name in child---
	//virtual number 		fix_leg_y_to_pv(number option(nullable) y = null<number>,logical l= true ,
		//								error_info option(nullable) error = null<error_info> );	
	
	// - not virtual because they have different name in child	
	//instrument_type 	swap_type(error_info option(nullable) error = null<error_info>);
	//logical				swap_payleg1(error_info option(nullable) error = null<error_info>);
	//ir_index 			swap_ir_index_leg1(error_info option(nullable) error = null<error_info> );
	//ir_index 			swap_ir_index_leg2(error_info option(nullable) error = null<error_info> );
	//string				swap_index_tenor_leg1(error_info option(nullable) error = null<error_info> );
	//string				swap_index_tenor_leg2(error_info option(nullable) error = null<error_info> );
	//tenor_code			swap_index_tenor_code_leg1(error_info option(nullable) error = null<error_info> );
	//tenor_code			swap_index_tenor_code_leg2(error_info option(nullable) error = null<error_info> );
	//string				swap_currency_leg1(error_info option(nullable) error = null<error_info> );
	//string				swap_currency_leg2(error_info option(nullable) error = null<error_info> );
	//day_count_method	swap_dc_method_leg1(error_info option(nullable) error = null<error_info> );  	/*DLL_SWAP_HANDLER: ok*/
	//day_count_method	swap_dc_method_leg2(error_info option(nullable) error = null<error_info> );		/*DLL_SWAP_HANDLER: ok*/
	//integer				swap_coupon_freq_leg1(error_info option(nullable) error = null<error_info> );
	//integer				swap_coupon_freq_leg2(error_info option(nullable) error = null<error_info> );
	//integer				swap_reset_freq_leg1(error_info option(nullable) error = null<error_info> );
	//integer				swap_reset_freq_leg2(error_info option(nullable) error = null<error_info> );
	/*integer				swap_pmt_lag_leg1(error_info option(nullable) error = null<error_info> );
	integer				swap_pmt_lag_prin_leg1(error_info option(nullable) error = null<error_info> );
	integer				swap_pmt_lag_leg2(error_info option(nullable) error = null<error_info> );
	integer				swap_pmt_lag_prin_leg2(error_info option(nullable) error = null<error_info> );	*/
	
	/*flt_avg_method 		swap_avg_method_leg1(error_info option(nullable) error = null<error_info>);
	flt_avg_method 		swap_avg_method_leg2(error_info option(nullable) error = null<error_info>);
	flt_sprd_comp_method swap_sprd_comp_method_leg1(error_info option(nullable) error = null<error_info>);
	flt_sprd_comp_method swap_sprd_comp_method_leg2(error_info option(nullable) error = null<error_info>);
	flt_comp_avg_type 	swap_comp_avg_type_leg1(error_info option(nullable) error = null<error_info>);
	flt_comp_avg_type 	swap_comp_avg_type_leg2(error_info option(nullable) error = null<error_info>) ;

	rfr_arrears_type 	swap_rfr_arr_type_leg1(error_info option(nullable) error = null<error_info>);
	integer 			swap_rfr_arr_days_leg1(error_info option(nullable) error = null<error_info>);
	rfr_arrears_type 	swap_rfr_arr_type_leg2(error_info option(nullable) error = null<error_info>);
	integer 			swap_rfr_arr_days_leg2(error_info option(nullable) error = null<error_info>);*/
	
	
/*number  			swap_present_value(	disc_func option(nullable),disc_func option(nullable),out number ,
											out number ,number option(nullable),
											logical option(nullable) tpv = false ,		
											error_info option(nullable) error = null<error_info> );
	
	number  			swap_present_value(disc_func option(nullable),disc_func option(nullable),
											out number ,out number ,
												date option(nullable) ,date option(nullable) ,
												logical,logical  ,error_info option(nullable) error = null<error_info>);
	
	number  			swap_present_value(out number ,out number pv_leg2,
												logical option(nullable) ,error_info option(nullable) error = null<error_info>);*/

/*void 				swap_add_notional(number );
	void 				swap_add_notional_leg1(number );
	void 				swap_add_notional_leg2(number );
	void 				swap_add_fx_rate_leg1(number );
	void 				swap_add_fx_rate_leg2(number );
	void 				swap_add_disc_func(disc_func option(nullable)); 
	void 				swap_add_disc_func_leg1(disc_func option(nullable));
	void 				swap_add_disc_func_leg2(disc_func option(nullable));*/
	//disc_func 			swap_disc_func_leg1(error_info option(nullable) error = null<error_info> ) ;
	//disc_func 			swap_disc_func_leg2(error_info option(nullable) error = null<error_info>) ;
	//tenor_surface 		swap_tenor_surface_leg1(error_info option(nullable) error = null<error_info>) ;
	//tenor_surface 		swap_tenor_surface_leg2(error_info option(nullable) error = null<error_info>) ;

	/*void 				swap_add_surface_leg1(tenor_surface option(nullable));
	void 				swap_add_surface_leg2(tenor_surface option(nullable));
	void 				swap_add_fwd_func_leg1(fwd_func option(nullable));
	void 				swap_add_fwd_func_leg2(fwd_func option(nullable));
	void				swap_add_curr_fixing_leg1(number option(nullable));
	void				swap_add_curr_fixing_leg2(number option(nullable));
	void				swap_add_fixing_leg1(vector(date) ,vector(number) ,logical option(nullable) fixing_as_fwd = false);
	void				swap_add_fixing_leg2(vector(date) ,vector(number) ,logical option(nullable) fixing_as_fwd = false);
	void				swap_add_fixing_leg1(number ,logical option(nullable) fixing_as_fwd = false);
	void				swap_add_fixing_leg2(number ,logical option(nullable) fixing_as_fwd = false);*/
	//number				swap_solver(number,swap_solver_code ,logical option(nullable) tpv=false,
	//								error_info option(nullable) error = null<error_info>);

	
	//ql_fixed_income_swap 	swap_instrument(error_info option(nullable) error = null<error_info>) ;
	
	/*vector(ql_swap_leg) 	swap_leg(logical, error_info option(nullable) error = null<error_info>);
	vector(ql_float_leg) 	swap_float_leg(logical, error_info option(nullable) error = null<error_info>);
	vector(ql_fix_leg) 		swap_fix_leg(logical, error_info option(nullable) error = null<error_info>);
	vector(ql_fix_infl_ci_leg) swap_fix_infl_ci_leg(logical, error_info option(nullable) error = null<error_info>);
	
	
	vector(ql_ois_leg) 		swap_ois_leg(logical, error_info option(nullable) error = null<error_info>);
	vector(ql_fix_zero_leg) swap_fix_zero_leg(logical, error_info option(nullable) error = null<error_info>);
	vector(ql_zero_infl_leg) swap_zero_infl_leg(logical, error_info option(nullable) error = null<error_info>);
	vector(ql_yy_infl_leg) swap_yy_infl_leg(logical, error_info option(nullable) error = null<error_info>);*/
	
	/*void 				swap_add_fltflt_data(number,disc_func,tenor_surface,vector(date),vector(number),tenor_surface ,
											vector(date),vector(number),logical option(nullable) fixing_as_fwd = false);
	
	void				swap_add_fltflt_ext_data(number,disc_func,number,tenor_surface,vector(date) ,vector(number) ,number ,
												disc_func ,number,tenor_surface,vector(date),vector(number) ,
												logical option(nullable) fixing_as_fwd = false) ;*/
	
/*	---------------------------------------------------
	---------------------------------------------------
	---BOND_FUTURE--PUBLIC--HIDDEN--(MOST THROWS_ERROR)--- 
	---------------------------------------------------
	---------------------------------------------------

		- public hidden functions in root that corresponds to function in bond future 
		- the functions with prefix bondfut_ must be in root for backward compat
		- virtual because they throw error in root and must have override functions in bond_future class (protected)
		- no impl. in root because they are relevant only for one instr type
*/	

	virtual bond_fut_style 		bondfut_style(error_info option(nullable) error = null<error_info>);
	virtual vector(string) 		bondfut_deliverables(error_info option(nullable) error = null<error_info>);
	virtual vector(string) 		deliverables();																		/*legacy*/
	virtual vector(number) 		bondfut_price_factors(error_info option(nullable) error = null<error_info> );
	virtual vector(number) 		price_factors();																	/*legacy*/
	virtual date 				bondfut_synt_maturity(error_info option(nullable) error = null<error_info>);
	virtual date 				bondfut_expiry_settle_date(error_info option(nullable) error = null<error_info>);

	/*  ---------------------------------------------------
	---------------------------------------------------
	---ON_FUTURE--PUBLIC--HIDDEN--(MOST THROWS_ERROR)--- 
	---------------------------------------------------
	---------------------------------------------------

		- public hidden functions in root that corresponds to function in on_future 
		- the functions with prefix on_future_ must be in root for backward compat
		- virtual because they throw error in root and must have override functions in on_future class (protected)
		- no impl. in root because they are relevant only for one instr type
*/
	virtual logical 	on_future_in_fixing_period(error_info option(nullable) error = null<error_info>);
	
/*  ---------------------------------------------------
	---------------------------------------------------
	---RIBA_FUTURE--PUBLIC--HIDDEN--(MOST THROWS_ERROR)--- 
	---------------------------------------------------
	---------------------------------------------------

		- public hidden functions in root that corresponds to function in riba 
		- the functions with prefix riba_ must be in root for backward compat
		- virtual because they throw error in root and must have override functions in riba class (protected)
		- no impl. in root because they are relevant only for one instr type
*/
	
	virtual logical 	riba_is_fixed(error_info option(nullable) error = null<error_info>);
	virtual logical 	riba_in_fixing_period(error_info option(nullable) error = null<error_info>);
	
	virtual number 		riba_final_fix_rate(error_info option(nullable) error = null<error_info>);
	virtual date 		riba_fix_period_end_date(error_info option(nullable) error = null<error_info>);
	virtual date 		riba_final_settlement_date(error_info option(nullable) error = null<error_info>);
	virtual date 		riba_expiry_date(error_info option(nullable) error = null<error_info>);
	virtual number 		riba_price(error_info option(nullable) error = null<error_info>);
	virtual number 		riba_settle_amount(	number ,number option(nullable) contract_rate = null<number>,
											number option(nullable) nominal = 100 ,
											error_info option(nullable) error = null<error_info>);
	number 				riba_pv(number,number option(nullable) contract_rate = null<number>,
								number option(nullable) nominal = 100);														/*legacy*/
	virtual number 		riba_settle_amount_df(	disc_func ,number option(nullable) contract_rate = null<number>,
												number option(nullable) nominal = 100 ,
												error_info option(nullable) error = null<error_info>);
	
	virtual number 		riba_pv_curve(number,number ,disc_func ,error_info option(nullable) error = null<error_info>);
	virtual number 		riba_pvbp(number option(nullable),number option(nullable),
								  error_info option(nullable) error = null<error_info>);
	virtual number 		riba_pvbp_df(number,disc_func,number ,error_info option(nullable) error = null<error_info>);
	number 				riba_pvbp_curve(number,disc_func,number );															/*legacy*/
	virtual number 		riba_pvbp_implied(number ,number ,error_info option(nullable) error = null<error_info>);
	virtual number 		riba_implied_curve_rate(number,error_info option(nullable) error = null<error_info>);
	virtual number 		riba_implied_rate(disc_func,error_info option(nullable) error = null<error_info>);
	virtual number 		riba_implied_rate_risk(disc_func,number ,error_info option(nullable) error = null<error_info>);
	virtual void 		riba_repo_data(	disc_func,out vector(number) ,out vector(date),
										out vector(date), error_info option(nullable) error = null<error_info>);
	void 				riba_repodata(	disc_func,out vector(number),out vector(date),out vector(date));					/*legacy*/

	//riba_*_legacy are hidden and have implementation in root
	virtual vector(number) riba_cash_flow_amounts_legacy(error_info option(nullable) error = null<error_info>) ;			/*legacy*/
	virtual vector(date) riba_cash_flow_dates_legacy(error_info option(nullable) error = null<error_info>) ;				/*legacy*/
	virtual number 		riba_accrued_legacy(error_info option(nullable) error = null<error_info>) ;							/*legacy*/
	virtual number 		riba_dirty_price_legacy(number option(nullable) y=null<number>,
													error_info option(nullable) error = null<error_info>) ;					/*legacy*/
	virtual number 		riba_clean_price_legacy(number option(nullable) y=null<number>,
													error_info option(nullable) error = null<error_info>) ;					/*legacy*/

/*  ---------------------------------------------------
	---------------------------------------------------	
	---FRN--PUBLIC--HIDDEN--(MOST THROWS_ERROR)--- 
	---------------------------------------------------
	---------------------------------------------------
	
		- public hidden functions in root that corresponds to function in frn
		- the functions with prefix frn_ must be in root for backward compat
		- has override functions in frn (protected)
		- no impl. in root because they are relevant only for one instr type
*/

	void 				frn_add_quote(number,number  option(nullable) ,number ); //no need for backward compat
	virtual number 		frn_fix_margin(error_info option(nullable) error = null<error_info>);
	number 				fix_margin() ;																							/*legacy*/									
	virtual number 		frn_assumed_index_rate(error_info option(nullable) error = null<error_info>);
	virtual number 		frn_disc_rate_next(error_info option(nullable) error = null<error_info>);
	virtual number 		frn_disc_margin(error_info option(nullable) error = null<error_info> );
	virtual number 		frn_disc_margin(	number ,number option(nullable) ,number option(nullable) ,
											number option(nullable) index_rate_next = null<number>,
											error_info option(nullable) error = null<error_info> );
	
	number 				disc_margin(number,number ,number ,number option(nullable)=null )  ;									/*legacy*/
	virtual number 		frn_accrued(number option(nullable),error_info option(nullable) error = null<error_info>);
	number 				accrued_frn(number option(nullable) );																	/*legacy*/
	virtual number 		frn_disc_margin_risk_bp(number ,number ,number option(nullable) ,number option(nullable) ,
												number option(nullable) index_rate_next = null<number>,
												error_info option(nullable) error = null<error_info>);

	number 				disc_margin_risk_bp(number ,number,number option(nullable) ,number option(nullable) ,number option(nullable) ); /*legacy*/
	virtual number 		frn_rate_risk_bp(	number ,number ,number option(nullable) ,number option(nullable) ,
											number option(nullable) index_rate_next = null<number>,
											error_info option(nullable) error = null<error_info>);

	number 				rate_risk_bp(	number ,number,number option(nullable) ,number option(nullable) ,number option(nullable) ); /*legacy*/
	virtual number 		frn_dirty_from_disc_margin(	number ,number option(nullable),number option(nullable) ,
												number option(nullable) index_rate_next = null<number>,
												logical disable_rounding = false,error_info option(nullable) error = null<error_info>);
	number 				dirty_from_disc_margin(	number,number option(nullable) ,number option(nullable) ,
												number option(nullable) ,logical disable_rounding = false) ;						/*legacy*/
	virtual number 		frn_clean_from_disc_margin(	number ,number option(nullable),number option(nullable) ,
													number option(nullable) index_rate_next = null<number>,
													logical disable_rounding = false,
													error_info option(nullable) error = null<error_info>);
	number 				clean_from_disc_margin(	number ,number option(nullable) ,number option(nullable) ,number option(nullable) ,
												logical disable_rounding = false) ;													/*legacy*/
	virtual string 		frn_roll_method(error_info option(nullable) error = null<error_info> ) ;

	string 				roll_method();																								/*legacy*/
	string				frn_fixing_code() ;	
	virtual vector(number) 	frn_cash_flows(	disc_func option(nullable), number option(nullable) fwd_spread = 0,
											number option(nullable) nominal = 100, logical from_settle = true,
											logical incl_floor_fixed = true, logical incl_floor_fwd = true,
											logical keep_size = false, error_info option(nullable) error = null<error_info>);	
	
	vector(number) 			cash_flow_amounts_frn(disc_func	,logical incl_floor = true) ; 											/*legacy*/

	virtual vector(number) 	frn_cash_flows(	fwd_func option(nullable), number option(nullable) fwd_spread = 0,
											number option(nullable) nominal = 100, logical from_settle = true,
											logical incl_floor_fixed = true, logical incl_floor_fwd = true,
											logical keep_size = false, error_info option(nullable) error = null<error_info>);	

	virtual vector(number) 	frn_cash_flows_cpn(	disc_func option(nullable), number option(nullable) fwd_spread = 0,
												number option(nullable) nominal = 100, logical from_settle = true,
												logical incl_floor_fixed = true, logical incl_floor_fwd = true,
												logical keep_size = false, error_info option(nullable) error = null<error_info>);
	
	virtual vector(number) 	frn_cash_flows_cpn(	fwd_func option(nullable), number option(nullable) fwd_spread = 0,
												number option(nullable) nominal = 100, logical from_settle = true,
												logical incl_floor_fixed = true, logical incl_floor_fwd = true,
												logical keep_size = false, error_info option(nullable) error = null<error_info>);	
	
	virtual frn_neg_rate_rule  frn_neg_rate_rule(error_info option(nullable) error = null<error_info>);
	frn_neg_rate_rule 		frn_neg_rate_style(error_info option(nullable) error = null<error_info>);								/*legacy*/
	virtual void 			frn_curve_to_price(	disc_func,disc_func,number,out number, out number	,out number,
												out number,out number, logical disable_rounding = false,
												error_info option(nullable) error = null<error_info>);	
	
	virtual void 			frn_curve_to_price(	fwd_func,disc_func,number,out number, out number,out number,
												out number,out number, logical disable_rounding = false,
												error_info option(nullable) error = null<error_info>);
	
	virtual void 			frn_coupon_data(out vector(date) ,out vector(date) , out vector(number) ,out vector(number),
											logical from_settle = false, logical keep_size = false ,
											error_info option(nullable) error = null<error_info>);	

	virtual vector(date) 	frn_fixing_dates(error_info option(nullable) error = null<error_info>);
	virtual logical 		frn_is_odd_first(error_info option(nullable) error = null<error_info>);
	virtual logical 		frn_is_odd_last(error_info option(nullable) error = null<error_info>);
	
/*  ---------------------------------------------------
	---PUBLIC--COMMON CREATOR FUNCS---  --VISIBLE--NO THROWS---
	---------------------------------------------------	
		- override always 	1) when NOT applicable throw and
							2) when applicable to get return type to specific instr type
*/	
	virtual instrument 		set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);				/*done:DEPO,BILL,BILL_FUT,BOND,ZERO*/	
	virtual instrument 		set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);				/*done:DEPO,BILL,BILL_FUT,BOND,ZERO,*/	
	virtual instrument		set_quote_from_yield(number option(nullable) ,error_info option(nullable) error = null<error_info>); 	/*done:DEPO,BILL,BILL_FUT,BOND,ZERO,*/
																																	/*hidden,legacy*/
/*  ---------------------------------------------------
	---TEMP PUBLIC--COMMON CREATOR FUNCS --VISIBLE--THROWS_ERROR--- 
	---------------------------------------------------

		- override when applicable for a specific instr type
*/
	virtual instrument 		set_yield(number option(nullable) ,error_info option(nullable) error = null<error_info>);				/*done:DEPO,BILL,BILL_FUT,BOND,ZERO,*/	

/*  ---------------------------------------------------
	---PUBLIC--COMMON CREATOR FUNCS --HIDDEN--THROWS_ERROR--- 
	---------------------------------------------------

		- override when applicable for a specific instr type
*/

	virtual instrument 		set_date(	date, date option(nullable) settle_date = null<date>,
										logical re_init_static =true, logical init_quote = true ,
										error_info option(nullable) error = null<error_info>);					/*done:DEPO,BILL,BILL_FUT(prot),BOND,ZERO,*/

	virtual instrument 		set_date(	date, logical , error_info option(nullable) error = null<error_info>);	/*done:DEPO(prot),BILL(prot),BILL_FUT(prot),BOND(prot),ZERO(prot),*/
																												/*legacy*/	//old q is NOT kept
	virtual instrument 		move_date(	date, date option(nullable) settle_date = null<date>,
										error_info option(nullable) error = null<error_info>);					/*done:DEPO(prot),BILL(prot),BILL_FUT(prot),BOND(prot),ZERO(prot),*/
																												/*legacy*/ 	//old q is kept
	virtual instrument 		set_settle_date(date , logical re_initialize /*= true*/ = false,
											error_info option(nullable) error = null<error_info> );				/*done:DEPO,BILL,BOND,ZERO,*/
	
	virtual instrument 		set_clean_price(number option(nullable), date option(nullable) trade_date  = null<date>,
											date option(nullable) settle_date = null<date> ,
											error_info option(nullable) error = null<error_info> );				/*done:DEPO,BILL,BOND,ZERO,*/
	virtual instrument 		set_dirty_price(number option(nullable), date option(nullable) trade_date  = null<date>,
											date option(nullable) settle_date = null<date> ,
											error_info option(nullable) error = null<error_info>);				/*done:DEPO,BILL,BOND,ZERO,*/
	
/*  ---------------------------------------------------
	---PUBLIC--old stuff--- 
	---------------------------------------------------*/
	//number 			yield_cf(rate_type, day_count_method );									/*legacy, hidden*/
	//number 			z_spread(disc_func,rate_type,day_count_method ); 						/*legacy, hidden*/

	label_date 		label_date();
	label_number 	label_number();
	number 			tag_num(string 	tag, error_info option(nullable) error = null<error_info>);
	string 			tag_str(string 	tag,error_info option(nullable) error = null<error_info>);
	date 			tag_date(string tag, error_info option(nullable) error = null<error_info>);
	number 			get_tag_num(string 	tag, error_info option(nullable) error = null<error_info>);						/*legacy, hidden*/
	string 			get_tag_str(string 	tag, error_info option(nullable) error = null<error_info>);						/*legacy, hidden*/
	date 			get_tag_date(string tag, error_info option(nullable) error = null<error_info>);						/*legacy, hidden*/
	
	bd_convention 	pmt_bus_day_d(bd_convention option(nullable),error_info option(nullable) error = null<error_info>);	/*legacy, hidden*/
	logical 		eom_d(logical option(nullable),error_info option(nullable) error = null<error_info>);				/*legacy, hidden*/
	
	number			flt_coupon_freq (error_info option(nullable) error = null<error_info>);								/*legacy, hidden*/
	number			flt_coupon_freq_flat(error_info option(nullable) error = null<error_info>);							/*legacy, hidden*/
	string 			flt_currency_flat(error_info option(nullable) error = null<error_info>);							/*legacy, hidden*/
	string 			flt_currency(error_info option(nullable) error = null<error_info>);									/*legacy, hidden*/
	day_count_method flt_daycount_method_flat(error_info option(nullable) error = null<error_info>);					/*legacy, hidden*/
	day_count_method flt_daycount_method(error_info option(nullable) error = null<error_info>);  						/*legacy, hidden*/
	number			flt_reset_days_d(number option(nullable),error_info option(nullable) error = null<error_info>);		/*legacy, hidden*/
	number			flt_reset_days(error_info option(nullable) error = null<error_info>);								/*legacy, hidden*/
	number			flt_value_days(error_info option(nullable) error = null<error_info>);								/*legacy, hidden, added for sw*/
	logical 		ccbs_is_mtm(error_info option(nullable) error = null<error_info>);									/*legacy, hidden*/	/*DLL_SWAP_HANDLER(leg1/leg2)*/
	logical 		ccbs_is_mtm_leg1(error_info option(nullable) error = null<error_info>);								/*legacy, hidden*/	/*DLL_SWAP_HANDLER(leg1/leg2)*/
	logical 		ccbs_is_mtm_leg2(error_info option(nullable) error = null<error_info>);								/*legacy, hidden*/	/*DLL_SWAP_HANDLER(leg1/leg2)*/
	string 			irs_class_name_flat(error_info option(nullable) error = null<error_info>);							/*legacy, hidden*/
	string 			irs_class_name_base(error_info option(nullable) error = null<error_info>);							/*legacy, hidden*/	
	string 			irs_class_name_sprd(error_info option(nullable) error = null<error_info>);							/*legacy, hidden*/

/*  ---------------------------------------------------
	---PUBLIC--tag readers--- 
	---------------------------------------------------*/			
	//number 			fix_reset_days_d(number option(nullable) ,error_info option(nullable) error = null<error_info>);	/*legacy, hidden*/
	//number			fix_spot_days_d (number option(nullable) ,error_info option(nullable) error = null<error_info>);	/*legacy, hidden*/
	//logical			fix_is_libor_d (logical option(nullable),error_info option(nullable) error = null<error_info>);		/*legacy, hidden*/
	//string			fix_uk_cal_d(string option(nullable),error_info option(nullable) error = null<error_info>);			/*legacy, hidden*/	
	
protected:

	//virtual logical 	verify_full_swap(error_info option(nullable) error = null<error_info>);	
	//logical 			check_full_swap(logical, error_info option(nullable) error = null<error_info>);
	override logical 	mw_lib_type();
/*  ---------------------------------------------------
	---PROTECTED COMMON CREATOR FUNCS---
	---------------------------------------------------

		- to be called from specific instr type
*/
	instrument 			_set_date(date, date option(nullable),  logical, logical , error_info option(nullable) error = null<error_info>);							
	instrument 			_set_date(	date, logical re_initialize = true, error_info option(nullable) error = null<error_info>);
	instrument 			_move_date(	date, date option(nullable) settle_date = null<date>, error_info option(nullable) error = null<error_info>);
	instrument 			_set_settle_date(date , logical re_initialize = true, error_info option(nullable) error = null<error_info> );
	instrument 			_set_clean_price(number option(nullable), date option(nullable) trade_date  = null<date>,
										 date option(nullable) settle_date = null<date> , error_info option(nullable) error = null<error_info> );		
	instrument 			_set_dirty_price(number option(nullable), date option(nullable) trade_date  = null<date>,
										 date option(nullable) settle_date = null<date> , error_info option(nullable) error = null<error_info> );	
	instrument 			_set_yield(	number option(nullable) , date option(nullable) trade_date = null<date>,
									date option(nullable) settle_date = null<date>, logical option(nullable) set_coupon_to_yield = true, 
									error_info option(nullable) error = null<error_info>);
	instrument 			_set_quote_from_yield(number option(nullable), logical option(nullable) set_coupon_to_yield = true,
											  error_info option(nullable) error = null<error_info>);
	instrument 			_set_quote(	number option(nullable), date option(nullable) trade_date  = null<date>,
									date option(nullable) settle_date = null<date>, logical option(nullable) set_coupon_to_quote= true,
									error_info option(nullable) error = null<error_info>);	
	instrument 			_set_quote(	string option(nullable), date option(nullable) trade_date  = null<date>,
									date option(nullable) settle_date = null<date>, logical option(nullable) set_coupon_to_quote= true,
									error_info option(nullable) error = null<error_info>);	  
};

//---

/*-----------------------------------------------------------------------
__dbg_print
----------------------------------------------------------------------*/
void instrument.__dbg_print(__dbg_label l)
{
	error_info e = error_info(true,false);
	
    l.set_text(strcat([ "name: ",
						name(e),
						",  id: ",
						string(id(e)),
						", valid: ",
						string(this.is_valid(e))]));
}
/*-----------------------------------------------------------------------
__dbg_browse
----------------------------------------------------------------------*/
void instrument.__dbg_browse(__dbg_split s)
{
    s.resize(3);

	error_info e = error_info(true,false);
	
    s.set_text(0, "name");
    s.set_value(0, name(e));

    s.set_text(1, "id");
    s.set_value(1, id(e));

	s.set_text(1, "valid");
    s.set_value(1, is_valid(e));

}

/*-----------------------------------------------------------------------
  clone_int  <private>
  ----------------------------------------------------------------------*/
__instrument instrument.clone_int(error_info option(nullable) error)
{
	try {		
		__instrument ii = i().__clone();
		QL_FAIL_COND(null(ii), "__clone() returned null", E_INIT);
		return ii;		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.clone_int");
		return null<__instrument>;
	}
}
/*-----------------------------------------------------------------------
  constructor  <protected>
  ----------------------------------------------------------------------*/
instrument.instrument() : fin_instr(), i_(null<__instrument>)
{}
/*-----------------------------------------------------------------------
  constructor  <protected>
  ----------------------------------------------------------------------*/
instrument.instrument(__instrument i) : fin_instr(), i_(i)
{}
/*-----------------------------------------------------------------------
  copy constructor  <protected>
  ----------------------------------------------------------------------*/
instrument.instrument(instrument i): fin_instr(i) 
{
	if(null(i.i_))
		return;
	error_info  error = new error_info(true,true);
	i_ = i.clone_int(error);
}

/*-----------------------------------------------------------------------
  i  <public>
  ----------------------------------------------------------------------*/
__instrument instrument.i()  option(hidden)	option(com_name: 'INTERNAL_i')
{ 
	QL_FAIL_COND(null(i_), "internal instrument not defined", E_INIT);	

	//instr_error_type t;
	//string 			s;	
	//logical l=i_.__is_valid(t,s);
	
	return i_;	
}
/*-----------------------------------------------------------------------
  mw_lib_type <protected>, <override from root>
  ----------------------------------------------------------------------*/
logical instrument.mw_lib_type() { return !null(i_); }

/*-----------------------------------------------------------------------
  err_type  <protected>
  ----------------------------------------------------------------------*/

instrument instrument.err_type(instrument option(nullable) nul, error_info option(nullable) error,string option(nullable) f )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,na_func_msg(null<string>), f);
	return null<instrument>;
}

/*-----------------------------------------------------------------------
  name  <public>, <override from root>
  ----------------------------------------------------------------------*/
string instrument.name(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__name(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.name");	
		return e ? "": c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.name");
		return "";
	}
}
/*-----------------------------------------------------------------------
  trade_date  <public>, <override from root>
  ----------------------------------------------------------------------*/
date instrument.trade_date(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__trade_date(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.trade_date");	
		return e ? null<date>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.trade_date");
		return null<date>;
	}
}
/*-----------------------------------------------------------------------
  required_fixings_valid  must be overridden for instruments that have fixings that may be required at init
  - currently implemented for instruments that are used in curvebuilding where fixings could be required
	--> implemented for riba and overnight futures
	--> and currently not implemented for frn (usually not used in curvebuilding) and swaps with oislegs (usually no fixings
		required when these are used for curvebuilding)
  ToDo: frn and swaps with oislegs
  ----------------------------------------------------------------------*/
logical	instrument.required_fixings_valid(error_info option(nullable) error ) option(hidden)
{
	return true;
}

/*-----------------------------------------------------------------------
  instr_type  <public>, <override from root>
  ----------------------------------------------------------------------*/
instr_type instrument.instr_type(error_info option(nullable) error)
option(com_name: 'instr_type_f')
{	
	try{			
		..__instr_type __c = i().__instr_type();
		return CORE_INT.conv_instr_type(__c);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.instr_type");
		return null<..instr_type>;
	}
}

/*-----------------------------------------------------------------------
  id   <public>, <override from root>
  ----------------------------------------------------------------------*/
integer  instrument.id(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = i().__id(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.id");	
		return e ? err_int(): c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.id");
		return err_int();
	}
}
/*-----------------------------------------------------------------------
  is_valid  <public>, <override from root>
  ----------------------------------------------------------------------*/
logical instrument.is_valid(error_info option(nullable) error)
{	
	try{
		if(!mw_lib_type())
			return false;
		instr_error_type t;
   		string 			s;	
		logical c = i().__is_valid(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.is_valid");	
		return e ? false: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.is_valid");
		return false;
	}
}

/*-----------------------------------------------------------------------
  is_expired <public>, <override from root>
  ----------------------------------------------------------------------*/
logical instrument.is_expired(error_info option(nullable) error)
{	
	try{
		if(!mw_lib_type())
			return false;
		instr_error_type t;
   		string 			s;	
		logical c = i().__is_expired(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.is_expired");	
		return e ? null<logical>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.is_expired");
		return null<logical>;
	}
}

/*-----------------------------------------------------------------------
  settle_date <public>
  ----------------------------------------------------------------------*/
date instrument.settle_date(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__settle_date(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.settle_date");	
		return e ? null<date>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.settle_date");
		return null<date>;
	}
}
/*-----------------------------------------------------------------------
  instr_def  <public>
  ----------------------------------------------------------------------*/
instr_def instrument.instr_def(	error_info option(nullable) error )
option(com_name: 'instr_def_f')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..instr_def c = i().__instr_def(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.instr_def");
		if(e)
			return INSTR_CREATE_NULL_ERR ? null<..instr_def> : c; 
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.instr_def");
		return null<..instr_def>;
	}
}

/*-----------------------------------------------------------------------
  class_name  <public>
  ----------------------------------------------------------------------*/
string instrument.class_name(error_info option(nullable) error)
{	
	try{		
		string c = i().__class_name();
		return c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.class_name");
		return null<string>;
	}
}


/*-----------------------------------------------------------------------
  issuer  <public>
  ----------------------------------------------------------------------*/
string instrument.issuer(error_info option(nullable) error)
{	
	try{	
		string c = i().__issuer();	
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.issuer");
		return null<string>;
	}
}
/*-----------------------------------------------------------------------
  err_msg  <public>
  ----------------------------------------------------------------------*/
string instrument.err_msg(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__err_msg(t, s);
		CORE_INT.add_error_info(error,t,s, "instrument.err_msg");	
		return null(c) ? "" : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.err_msg");
		return null<string>;
	}
}


/*-----------------------------------------------------------------------
  quote_side  <public>
  ----------------------------------------------------------------------*/
string instrument.quote_side(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__quote_side(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.quote_side");	
		return e ? null<string>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.quote_side");
		return null<string>;
	}
}
/*-----------------------------------------------------------------------
  quote_side_is_comp  <public>
  ----------------------------------------------------------------------*/
logical instrument.quote_side_is_comp(out string quote_side1,
									  out string quote_side2,									  
									  error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = i().__quote_side_is_comp(quote_side1,quote_side2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.quote_side_is_comp");	
		return e ? null<logical>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.quote_side_is_comp");
		return null<logical>;
	}
}


/*-----------------------------------------------------------------------
  calendar  <public>
  ----------------------------------------------------------------------*/
calendar instrument.calendar(integer index, error_info option(nullable) error)
	option(com_name: 'calendar_i')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..calendar c = i().__calendar(index, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.calendar");	
		return e ? null<..calendar>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.calendar");
		return null<..calendar>;
	}
}

/*-----------------------------------------------------------------------
  calendar  <public>
  ----------------------------------------------------------------------*/
calendar instrument.calendar(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..calendar c = i().__calendar(0, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.calendar");	
		return e ? null<..calendar>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.calendar");
		return null<..calendar>;
	}
}
/*-----------------------------------------------------------------------
  calendar_name  <public>
  ----------------------------------------------------------------------*/
string instrument.calendar_name(integer index, error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__calendar_name(index, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.calendar_name");	
		return e ? null<string>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.calendar_name");
		return null<string>;
	}
}
/*-----------------------------------------------------------------------
  calendar_name  <public>
  ----------------------------------------------------------------------*/
string instrument.calendar_name(error_info option(nullable) error)
option(com_name: 'calendar_name_0')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__calendar_name(0, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.calendar_name");	
		return e ? null<string>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.calendar_name");
		return null<string>;
	}
}
/*-----------------------------------------------------------------------
  settle_code  <public>
  ----------------------------------------------------------------------*/
string instrument.settle_code(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__settle_code(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.settle_code");	
		return e ? null<string>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.settle_code");
		return null<string>;
	}
}
/*-----------------------------------------------------------------------
  value_code legacy <public>, <hidden>
  ----------------------------------------------------------------------*/
string instrument.value_code() option(hidden)
option(com_name: 'LEGACY_value_code')
{
	return this.settle_code();	
}
/*-----------------------------------------------------------------------
  currency   <public>
  ----------------------------------------------------------------------*/
string instrument.currency(error_info option(nullable) error)
{	
	try{	
		string c = i().__currency();
		return  c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.currency");
		return null<string>;
	}
}


/*-----------------------------------------------------------------------
  quote_style   <public>  quote_style in instr_def EXT SWAP: ok
  ----------------------------------------------------------------------*/
string instrument.quote_style(error_info option(nullable) error)
option(com_name: 'quote_style_f')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__quote_style(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.quote_style");	
		return e ? null<string>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.quote_style");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  quote_style_e   <public>  quote_style in instr_def EXT SWAP: ok
  ----------------------------------------------------------------------*/
quote_style instrument.quote_style_e(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..quote_style c = i().__quote_style_e(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.quote_style_e");	
		return e ? null<..quote_style>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.quote_style_e");
		return null<..quote_style >;
	}
}

/*-----------------------------------------------------------------------
  realtime_feed   <public>
  ----------------------------------------------------------------------*/
string instrument.realtime_feed(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__realtime_feed(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.realtime_feed");	
		return e ? null<string>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.realtime_feed");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  realtime_ric   <public>
  ----------------------------------------------------------------------*/
string instrument.realtime_ric(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__realtime_ric(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.realtime_ric");	
		return e ? null<string>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.realtime_ric");
		return null<string>;
	}
}
/*-----------------------------------------------------------------------
  realtime_fid   <public>
  ----------------------------------------------------------------------*/
string instrument.realtime_fid(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__realtime_fid(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.realtime_fid");	
		return e ? null<string>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.realtime_fid");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  realtime_feed   <public>
  ----------------------------------------------------------------------*/
void instrument.realtime_feed(out vector(string) result,error_info option(nullable) error)
	option(com_name: 'realtime_feed_v')	
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__realtime_feed_v(result,t, s);
		CORE_INT.add_error_info(error,t,s, "instrument.realtime_feed");	
		return ;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.realtime_feed");
		result = null<vector(string)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  realtime_ric   <public>
  ----------------------------------------------------------------------*/
void instrument.realtime_ric(out vector(string) result,error_info option(nullable) error)
	option(com_name: 'realtime_ric_v')	
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__realtime_ric_v(result,t, s);
		CORE_INT.add_error_info(error,t,s, "instrument.realtime_ric");	
		return ;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.realtime_ric");
		result = null<vector(string)>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  realtime_fid   <public>
  ----------------------------------------------------------------------*/
void instrument.realtime_fid(out vector(string) result,error_info option(nullable) error)
	option(com_name: 'realtime_fid_v')	
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__realtime_fid_v(result,t, s);
		CORE_INT.add_error_info(error,t,s, "instrument.realtime_fid");	
		return ;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.realtime_fid");
		result = null<vector(string)>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  quote_key   <public>
  ----------------------------------------------------------------------*/
string instrument.quote_key(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__quote_key(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.quote_key");	
		return e ? null<string>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.quote_key");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  quote_table   <public>
  ----------------------------------------------------------------------*/
string instrument.quote_table(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__quote_table(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.quote_table");	
		return e ? null<string>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.quote_table");
		return null<string>;
	}
}


/*-----------------------------------------------------------------------
  is_ext_swap   <public>, <hidden>
  ----------------------------------------------------------------------*/
logical instrument.is_ext_swap(error_info option(nullable) error) option(hidden)
{	
	try{
		if(!mw_lib_type())
			return false;	
		logical c = i().__is_ext_swap();
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.is_ext_swap");
		return false;
	}
}

/*-----------------------------------------------------------------------
  is_ccy_swap   <public>, <hidden>
  ----------------------------------------------------------------------*/
logical instrument.is_ccy_swap(error_info option(nullable) error) option(hidden)
{	
	try{
		if(!mw_lib_type())
			return false;	
		logical c = i().__is_ccy_swap();	
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.is_ccy_swap");
		return false;
	}
}

/*-----------------------------------------------------------------------
  quote_unit_dec   <public> 
  ----------------------------------------------------------------------*/
number instrument.quote_unit_dec(error_info option(nullable) error   )
{	
	try{
		error_info ee = new error_info(true,true);
		..quote_style qs = this.quote_style_e(ee);
		switch (qs){
		case ..quote_style.CLEAN_PCT:
		case ..quote_style.DIRTY_PCT:
		case ..quote_style.CLEAN_PCT_EXINFL:
		case ..quote_style.YIELD_PCT:
		case ..quote_style.YIELD_AFTER_TAX_PCT:
		case ..quote_style.YIELD_TO_WORST_PCT:
		case ..quote_style.EDFUT:
		case ..quote_style.PRICE_MU_2:
			return this.quote(ee)/100.0;
		case ..quote_style.DISC_MARGIN_BP:
		case ..quote_style.SPREAD_BP:
			return this.quote(ee)/10000.0;
		case ..quote_style.CLEAN:
		case ..quote_style.CLEAN_PCT_16:
		case ..quote_style.CLEAN_PCT_32:
		case ..quote_style.CLEAN_PCT_64:
		case ..quote_style.CLEAN_PCT_128:
		case ..quote_style.CLEAN_PCT_256:
		{
			number q = this.quote(..quote_style.CLEAN_PCT,ee);
			return q/100.0;
		}
		case ..quote_style.DIRTY:
		{
			number q = this.quote(..quote_style.DIRTY_PCT,ee);
			return q/100.0;
		}
		case ..quote_style.FX_PIPS:
		case ..quote_style.FX_RATE:
			return this.fx_quote(true,false,ee);
		default:
			return this.quote(ee);
		}
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.quote_unit_dec");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  quote      <public>
  ----------------------------------------------------------------------*/
number  instrument.quote(error_info option(nullable) error)
option(com_name: 'quote')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__quote(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.quote");	
		return e ? null<number>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.quote");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  quote_orig      <public>, <hidden>
  ----------------------------------------------------------------------*/
number  instrument.quote_orig(error_info option(nullable) error) option(hidden)
option(com_name: 'INTERNAL_quote_orig')
{	
	return this.quote(error);
}

/*-----------------------------------------------------------------------
  quote   <public>
  ----------------------------------------------------------------------*/
number instrument.quote(date option(nullable) 	quote_date, 
						string option(nullable) quote_side, 
						error_info option(nullable) error)
option(com_name: 'quote_dt_qs')
{	
	try{
		quote_date = conv_null_date_com(quote_date) ;
		quote_side = conv_null_string_com(quote_side) ;					
		if(null(quote_date)) {
			error_info ee = new error_info(true,true);
			quote_date = this.trade_date(ee);
			CORE_INT.instr_fail_check(null(quote_date), "invalid quote date", this, ee);
		}
		
		instr_error_type t;
   		string 			s;
		number c = i().__quote(quote_date, quote_side,t,s );//if ext_swap we get a null
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.quote");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.quote");
		return null<number >;
	}
}

number instrument.get_quote(string option(nullable) quote_side) option(hidden)
option(com_name: 'LEGACY_get_quote')
{
	return this.quote(this.trade_date(), quote_side);
}
number instrument.get_quote_num(string option(nullable) quote_side) option(hidden)
option(com_name: 'LEGACY_get_quote_num')
{
	return this.quote(this.trade_date(), quote_side);
}
/*-----------------------------------------------------------------------
  quote   <public>
  ----------------------------------------------------------------------*/
number instrument.quote(integer  				bus_days_back, 
						string option(nullable) quote_side, 
						error_info option(nullable) error)
option(com_name: 'quote_h_qs')
{	
	try{
		quote_side = conv_null_string_com(quote_side) ;
		instr_error_type t;
   		string 			s;			
		number c = i().__quote(bus_days_back, quote_side,t,s );//if ext_swap we get a null
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.quote");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.quote");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  quote   <public>
  ----------------------------------------------------------------------*/
vector(number) instrument.quote(vector(date)  			quote_dates, 
								string option(nullable) quote_side, 
								error_info option(nullable) error)
option(com_name: 'quote_vdt_qs')
{	
	try{
		quote_side = conv_null_string_com(quote_side) ;
		instr_error_type t;
   		string 			s;			
		vector(number) c = i().__quote(quote_dates, quote_side,t,s );//if ext_swap we get a null
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.quote");	
		return e ? null<vector(number)>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.quote");
		return null<vector(number) >;
	}
}

/*-----------------------------------------------------------------------
  quote     <public> 	not for ext swap
  ----------------------------------------------------------------------*/
number  instrument.quote(	..quote_style option(nullable) quote_style,
							error_info option(nullable) error)
option(com_name: 'quote_qstyle')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__quote(quote_style,t, s);//if ext_swap we get a null
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.quote");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.quote");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  quote   <public>  (implied quote from a disc_func)
  ----------------------------------------------------------------------*/
number  instrument.quote(	disc_func		disc_func,
							..quote_style option(nullable) quote_style,									
							error_info option(nullable) error)
option(com_name: 'quote_df')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__quote(disc_func, quote_style, t, s);//if most swaps,fx,equity, bondfut we get a null (swap-exceptions are fixflt,fixois,realfixflt)
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.quote");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.quote");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  present_value   <public>  , not all instr types ok (ex fx swap,mmfut_ff,...
  ----------------------------------------------------------------------*/
number  instrument.present_value(	number option(nullable) 	nominal,
									logical 					trade_date_pv,
									disc_func option(nullable) 	disc_func_disc,//used for discounting from settle to tradedate
									error_info option(nullable) error)
option(com_name: 'present_value')
{	
	try{	
		nominal = conv_null_number_com(nominal) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__present_value(nominal,trade_date_pv,disc_func_disc,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.present_value");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.present_value");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  present_value   <public>  
  ----------------------------------------------------------------------*/
number  instrument.present_value(	disc_func					disc_func,//used for instrument cashflows
									number option(nullable) 	nominal,
									logical 					trade_date_pv,
									disc_func option(nullable) 	disc_func_disc,//used for discounting from settle to tradedate
									error_info option(nullable) error) 
option(com_name: 'present_value_df')
{	
	try{	
		nominal= conv_null_number_com(nominal) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__present_value(disc_func,nominal,trade_date_pv,disc_func_disc,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.present_value");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.present_value");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  nominal    <public>  DLL_SWAP_HANDLER(leg1)
  ----------------------------------------------------------------------*/
number  instrument.nominal(error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__nominal(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.nominal");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.nominal");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  __curve_sort_maturity
  ----------------------------------------------------------------------*/
string instrument.__curve_sort_maturity() option(hidden)
{
	try {
		error_info ee = new error_info(true,false);
		return strcat(string(maturity_adj(ee)), name(ee));
	}
	catch {
		return "";
	}
}
/*-----------------------------------------------------------------------
  maturity   <public>   DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
date instrument.maturity(error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__maturity(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.maturity");	
		return e ? null<date>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.maturity");
		return null<date>;
	}
}
/*-----------------------------------------------------------------------
  maturity_adj   <public>   DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
date instrument.maturity_adj(error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__maturity_adj(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.maturity_adj");	
		return e ? null<date>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.maturity_adj");
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  maturity_blend   <hidden>   DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
date instrument.maturity_blend(error_info option(nullable) error)  option(hidden)
{	
	return maturity_adj(error) ;
}

/*-----------------------------------------------------------------------
  coupon  <public>, <hidden>, legacy --> should have _rate suffix for clarity, DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
number  instrument.coupon(error_info option(nullable) error) option(hidden)
{
	return coupon_rate(error);
}
/*-----------------------------------------------------------------------
  coupon  <public>  DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
number  instrument.coupon_rate(error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__coupon_rate(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.coupon_rate");	
		return e ? null<number>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.coupon_rate");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  face_amount   <public>   DLL_SWAP_HANDLER: ok (--> err for all swaps)
  ----------------------------------------------------------------------*/
number  instrument.face_amount(error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__face_amount(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.face_amount");	
		return e ? null<number>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.face_amount");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  issued_amount   <public>  <hidden>
  ----------------------------------------------------------------------*/
number  instrument.issued_amount(error_info option(nullable) error)  option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__issued_amount(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.issued_amount");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.issued_amount");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  update_quote    <public>
  updates the instrument with a new quote.
  - if the instrument is created with a manual quote nothing will happen)
  - if ignore_null_quote = true --> instrument will not be updated if the updated quote is null (i.e. previous quote is kept)
  - useful for example when we want the instrument to be updated with a new realtime quote without recreating a new instrument
  ----------------------------------------------------------------------*/
void instrument.update_quote(logical ignore_null_quote) option(hidden)
{
	try {
		i().__update_quote(ignore_null_quote);
	}
	catch {
	}
	
	return;
}
/*-----------------------------------------------------------------------
  issue_date    <public>    DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
date instrument.issue_date(error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__issue_date(t, s);//first from swap then from def
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.issue_date");	
		return e ? null<date>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.issue_date");
		return null<date>;
	}
}
/*-----------------------------------------------------------------------
  coupon_freq    <public>    DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
integer  instrument.coupon_freq(error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = i().__coupon_freq(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.coupon_freq");	
		return e ? err_freq(): c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.coupon_freq");
		return err_freq();
	}
}

integer instrument.cpn_freq() option(hidden) /*legacy*/
option(com_name: 'LEGACY_cpn_freq')
{
	return this.coupon_freq();
}

/*-----------------------------------------------------------------------
  cash_flow_dates    <public>    
  ----------------------------------------------------------------------*/
vector(date) instrument.cash_flow_dates(logical post_settle,
										logical adj_dates,
										logical keep_size, 
										error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(date) c = i().__cash_flow_dates(post_settle, adj_dates,keep_size,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.cash_flow_dates");	
		return e ? null<vector(date)>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.cash_flow_dates");
		return null<vector(date)>;
	}
}

/*-----------------------------------------------------------------------
  cash_flow_data    <public>    
  ----------------------------------------------------------------------*/
void instrument.cash_flow_data(	number option(nullable) nominal,
								logical 				post_settle,
								ir_cf_code 				cf_code,
								logical 				adj_dates,
								logical 				keep_size,
								out vector(date)   		dates,
								out vector(number) 		amounts,																
								error_info option(nullable) error) 
{	
	try{
		nominal= conv_null_number_com(nominal) ;
		instr_error_type t;
   		string 			s;	
		i().__cash_flow_data(nominal,post_settle, cf_code,adj_dates,dates,amounts,keep_size,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.cash_flow_data");
		if(e) {
			dates = null<vector(date)>;
			amounts = null<vector(number)>;
		}
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.cash_flow_data");
		dates = null<vector(date)>;
		amounts = null<vector(number)>;
		return ;
	}
}


/*-----------------------------------------------------------------------
  cash_flows_cpn    <public>    
  ----------------------------------------------------------------------*/
vector(number) instrument.cash_flows_cpn(number option(nullable) nominal ,
										logical 	post_settle,
										logical 	keep_size,
										error_info option(nullable) error) 
{	
	try{
		nominal= conv_null_number_com(nominal) ;
		instr_error_type t;
   		string 			s;	
		vector(number) c = i().__cash_flows_cpn(nominal, post_settle, keep_size,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.cash_flows_cpn");	
		return e ? null<vector(number)>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.cash_flows_cpn");
		return null<vector(number)>;
	}
}

/*-----------------------------------------------------------------------
  cash_flow_cpn      <public>, <hidden>   LEGACY
  ----------------------------------------------------------------------*/
vector(number) instrument.cash_flow_cpn() option(hidden)
option(com_name: 'LEGACY_cash_flow_cpn')
{
	return cash_flows_cpn(null<number>, true ,	false);
}

/*-----------------------------------------------------------------------
  cash_flows    <public>    
  ----------------------------------------------------------------------*/
vector(number) instrument.cash_flows(	number option(nullable) nominal ,
										logical 	post_settle,
										logical 	keep_size,
										error_info option(nullable) error) 
{	
	try{
		nominal= conv_null_number_com(nominal) ;
		instr_error_type t;
   		string 			s;	
		vector(number) c = i().__cash_flows(nominal, post_settle, keep_size,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.cash_flows");	
		return e ? null<vector(number)>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.cash_flows");
		return null<vector(number)>;
	}
}

/*-----------------------------------------------------------------------
  cash_flow_dates_noadj     <public>, <hidden>     LEGACY
  ----------------------------------------------------------------------*/
vector(date) instrument.cash_flow_dates_noadj(	logical 	post_settle,
												error_info option(nullable) error) option(hidden)
option(com_name: 'LEGACY_cash_flow_dates_noadj')												
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(date) c = i().__cash_flow_dates(post_settle, false,false,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.cash_flow_dates_noadj");	
		return e ? null<vector(date)>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.cash_flow_dates_noadj");
		return null<vector(date)>;
	}
}

/*-----------------------------------------------------------------------
  cash_flow_amounts     <public>, <hidden>     LEGACY
  ----------------------------------------------------------------------*/
vector(number) instrument.cash_flow_amounts(number option(nullable) nominal,
											logical post_settle,
											logical keep_size,											
											error_info option(nullable) error) option(hidden)
option(com_name: 'LEGACY_cash_flow_amounts')
{	
	try{
		nominal= conv_null_number_com(nominal) ;
		instr_error_type t;
   		string 			s;	
		vector(number) c = i().__cash_flows(nominal,post_settle, keep_size,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.cash_flow_amounts");	
		return e ? null<vector(number)>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.cash_flow_amounts");
		return null<vector(number)>;
	}
}

/*-----------------------------------------------------------------------
  cash_flow_nom_amounts     <public>, <hidden>     LEGACY
  ----------------------------------------------------------------------*/
vector(number) instrument.cash_flow_nom_amounts(number option(nullable) nominal,
												logical post_settle,
												logical keep_size,
												error_info option(nullable) error) option(hidden)
option(com_name: 'LEGACY_cash_flow_nom_amounts')
{	
	try{
		nominal= conv_null_number_com(nominal) ;
		instr_error_type t;
   		string 			s;	
		vector(number) c = i().__cash_flows_nom(nominal, post_settle,keep_size, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.cash_flow_nom_amounts");	
		return e ? null<vector(number)>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.cash_flow_nom_amounts");
		return null<vector(number)>;
	}
}

/*-----------------------------------------------------------------------
  cash_flows      <public>, <hidden>     LEGACY
  ----------------------------------------------------------------------*/
void instrument.cash_flows(	out vector(date)   dates,
    						out vector(number)   amounts,
							number option(nullable) nominal ,
							logical post_settle,							
							error_info option(nullable) error)  option(hidden)
option(com_name: 'LEGACY_cash_flows')
{	
	try{
		nominal= conv_null_number_com(nominal) ;
		instr_error_type t;
   		string 			s;

		dates = i().__cash_flow_dates(post_settle, true, false,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.cash_flows");
		if(e) {
			dates = null<vector(date)>;
			amounts = null<vector(number)>;
			return;
		}
		
		amounts = i().__cash_flows(nominal ,post_settle, false, t, s);
		//i().__cash_flows(cash_flow_dates, cash_flow_amounts,t, s);
		e = CORE_INT.add_error_info(error,t,s, "instrument.cash_flows");
		if(e) {
			dates = null<vector(date)>;
			amounts = null<vector(number)>;
		}
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.cash_flows");
		dates = null<vector(date)>;
		amounts = null<vector(number)>;
		return ;
	}
}

	
/*-----------------------------------------------------------------------
  mac_dur      <public>
  ----------------------------------------------------------------------*/
number  instrument.mac_dur(	error_info option(nullable) error) 
{	
	try{
		number delta = 0.0001;
		//delta	= conv_null_number_com(delta) ;
		//if(null(delta)) delta = 0.0001;
		instr_error_type t;
   		string 			s;			
		number c = i().__mac_dur(delta, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.mac_dur");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.mac_dur");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  mod_dur      <public>
  ----------------------------------------------------------------------*/
number  instrument.mod_dur(	error_info option(nullable) error) 
{	
	try{	
		number delta = 0.0001;
		//delta	= conv_null_number_com(delta) ;
		//if(null(delta)) delta = 0.0001;
		instr_error_type t;
   		string 			s;		
		number c = i().__mod_dur(delta, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.mod_dur");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.mod_dur");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  dol_dur      <public>
  ----------------------------------------------------------------------*/
number  instrument.dol_dur(	error_info option(nullable) error) 
{	
	try{	
		number delta = 0.0001;
		//delta	= conv_null_number_com(delta) ;
		//if(null(delta)) delta = 0.0001;
		instr_error_type t;
   		string 			s;	
		number c = i().__dol_dur(delta, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.dol_dur");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.dol_dur");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  pvbp      <public>
  ----------------------------------------------------------------------*/
number  instrument.pvbp(	number 	option(nullable) nominal,
							number  option(nullable) delta,																																		
							error_info option(nullable) error) 
{	
	try{	
		nominal	= conv_null_number_com(nominal) ;
		delta	= conv_null_number_com(delta) ;
		instr_error_type t;
   		string 			s;	
		if(null(delta)) delta = 0.0001;
		number c = i().__pvbp(nominal,delta,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.pvbp");	
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.pvbp");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  pvbp      <public>, <hidden>
  ----------------------------------------------------------------------*/
/*number  instrument.pvbp(number  option(nullable) delta,
						error_info option(nullable) error) option(hidden)
option(com_name: 'LEGACY_pvbp')
{
	return pvbp(null<number>,delta,error);
}*/

/*-----------------------------------------------------------------------
  pvbp      <public>  (for riba it is FULL PERIOD)
  ----------------------------------------------------------------------*/
number  instrument.pvbp(	number option(nullable) nominal,
							number option(nullable) delta,
							logical option(nullable) centered,
							logical option(nullable) disable_rounding,	
							error_info option(nullable) error) 
option(com_name: 'pvbp_ext')
{	
	try{	
		
		instr_error_type t;
   		string 			s;	
		number c = i().__pvbp(nominal, delta,centered, disable_rounding, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.pvbp");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.pvbp");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  convexity      <public>
  ----------------------------------------------------------------------*/
number  instrument.convexity(error_info option(nullable) error) 
{	
	try{	
		number delta = 0.0001;
		//delta	= conv_null_number_com(delta) ;
		//if(null(delta)) delta = 0.0001;
		instr_error_type t;
   		string 			s;
		number c = i().__convexity(delta, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.convexity");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.convexity");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  dol_convexity      <public>
  ----------------------------------------------------------------------*/
number  instrument.dol_convexity(	error_info option(nullable) error) 
{	
	try{	
		number delta = 0.0001;
		//delta	= conv_null_number_com(delta) ;
		//if(null(delta)) delta = 0.0001;
		instr_error_type t;
   		string 			s;	
		number c = i().__dol_convexity(delta, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.dol_convexity");	
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.dol_convexity");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  sensitivity      <public>
  ----------------------------------------------------------------------*/
number  instrument.sensitivity(	error_info option(nullable) error) 
{	
	try{	
		number delta = 0.0001;
		//delta	= conv_null_number_com(delta) ;
		//if(null(delta)) delta = 0.0001;
		instr_error_type t;
   		string 			s;		
		number c = i().__sensitivity(delta, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.sensitivity");	
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.sensitivity");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  yield       <public> 	not for ext swap
  ----------------------------------------------------------------------*/
number  instrument.yield(	logical 	disable_rounding,
							error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__yield(disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.yield");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.yield");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  yield       <hidden> 	not for ext swap  -for python
  ----------------------------------------------------------------------*/
number  instrument.yield_py(	logical 	disable_rounding,
							error_info option(nullable) error) option(hidden)
{	
	return yield(disable_rounding,error) ;
}

/*-----------------------------------------------------------------------
  yield	     <public>	not for ext swap
  ----------------------------------------------------------------------*/
number  instrument.yield(	disc_func		disc_func,
							logical 		disable_rounding ,								
							error_info option(nullable) error)
option(com_name: 'yield_fit')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__yield(disc_func, disable_rounding , t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.yield");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.yield");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  yield	     <hidden>	not for ext swap  -for python
  ----------------------------------------------------------------------*/
number  instrument.yield_py(disc_func		disc_func,
							logical 		disable_rounding ,								
							error_info option(nullable) error) option(hidden)

{	
	return yield(disc_func,disable_rounding,error) ;
}
/*-----------------------------------------------------------------------
  price_to_yield     <public>
  ----------------------------------------------------------------------*/
number  instrument.price_to_yield(	number price,
									..quote_style qs_price,									
									error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c= i().__price_to_yield(price,qs_price, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.price_to_yield");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.price_to_yield");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  price_to_yield     <public>, <hidden>, legacy
  ----------------------------------------------------------------------*/
number instrument.price_to_yield(number dirty_price_pcnt) option(hidden)
option(com_name: 'LEGACY_price_to_yield')
{
	return price_to_yield(dirty_price_pcnt, ..quote_style.DIRTY_PCT);
}
/*-----------------------------------------------------------------------
  dirty_price_to_yield     <public> (cannot be hidden because of vba)
  ----------------------------------------------------------------------*/
number  instrument.dirty_price_to_yield(number dirty_price_pcnt,
										logical disable_rounding ,									
										error_info option(nullable) error)
option(com_name: 'LEGACY_dirty_price_to_yield')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__dirty_price_to_yield(dirty_price_pcnt, disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.dirty_price_to_yield");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.dirty_price_to_yield");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  clean_price_to_yield     <public>  (cannot be hidden because of vba)
  ----------------------------------------------------------------------*/
number  instrument.clean_price_to_yield(number clean_price_pcnt,
										logical disable_rounding ,									
										error_info option(nullable) error)
option(com_name: 'LEGACY_clean_price_to_yield')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__clean_price_to_yield(clean_price_pcnt, disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.clean_price_to_yield");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.clean_price_to_yield");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  dirty_price    <public>
  ----------------------------------------------------------------------*/
number  instrument.dirty_price(	number option(nullable)		yield,
								logical 					disable_rounding,
								logical 					in_pcnt,									
								error_info option(nullable) error)
	option(com_name: 'dirty_price_alt')
{	
	try{	
		yield = conv_null_number_com(yield) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__dirty_price(yield, disable_rounding, in_pcnt, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.dirty_price");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.dirty_price");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  yield_to_dirty     <public>  (backward compat)
  ----------------------------------------------------------------------*/

number instrument.yield_to_dirty(number	yield,
								logical disable_rounding) option (hidden)
option(com_name: 'LEGACY_yield_to_dirty')								
{
	return dirty_price(	yield,disable_rounding,true  ) ;
} 
/*-----------------------------------------------------------------------
  dirty_price    <public>
  ----------------------------------------------------------------------*/
number  instrument.dirty_price(	logical 	disable_rounding,
								logical 	in_pcnt,									
								error_info option(nullable) error) 

{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__dirty_price(null<number>,disable_rounding,in_pcnt, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.dirty_price");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.dirty_price");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  dirty_price    <public>
  ----------------------------------------------------------------------*/
number  instrument.dirty_price(	disc_func		disc_func,
								logical 		disable_rounding,								
								logical 		in_pcnt,									
								error_info option(nullable) error) 
option(com_name: 'dirty_price_fit')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__dirty_price(disc_func, disable_rounding,in_pcnt, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.dirty_price");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.dirty_price");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  clean_price   <public>
  ----------------------------------------------------------------------*/
number  instrument.clean_price(	number	option(nullable)	yield,
								logical 					disable_rounding,
								logical 					in_pcnt,									
								error_info option(nullable) error)
	option(com_name: 'clean_price_alt')
{	
	try{	
		yield = conv_null_number_com(yield) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__clean_price(yield, disable_rounding, in_pcnt, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.clean_price");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.clean_price");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  yield_to_clean     <public>, <hidden> (backward compat)
  ----------------------------------------------------------------------*/
number instrument.yield_to_clean(number	yield,
								logical disable_rounding) option(hidden)
option(com_name: 'LEGACY_yield_to_clean')
{
	return clean_price(	yield,disable_rounding,true  ) ;
} 
/*-----------------------------------------------------------------------
  clean_price   <public>
  ----------------------------------------------------------------------*/
number  instrument.clean_price(	logical 	disable_rounding,
								logical 	in_pcnt,									
								error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__clean_price(null<number>,disable_rounding,in_pcnt, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.clean_price");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.clean_price");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  clean_price   <public>
  ----------------------------------------------------------------------*/
number  instrument.clean_price(	disc_func		disc_func,
								logical 		disable_rounding,								
								logical 		in_pcnt,									
								error_info option(nullable) error) 
option(com_name: 'clean_price_fit')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__clean_price(disc_func, disable_rounding, in_pcnt, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.clean_price");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.clean_price");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  yield_to_price  <public>
  ----------------------------------------------------------------------*/
number  instrument.yield_to_price(	number 			yield,//decimal
									..quote_style 	qs_price,									
									error_info option(nullable) error) 
{	
	try{		
		instr_error_type t;
   		string 			s;	
		number c= i().__yield_to_price(yield,qs_price, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.yield_to_price");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.yield_to_price");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  accrued  <public>
  ----------------------------------------------------------------------*/
number  instrument.accrued(	logical 	disable_rounding,
							logical 	in_pcnt,									
							error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__accrued(disable_rounding,in_pcnt, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.accrued");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.accrued");
		return null<number>;
	}
}

/*-----------
	HIDDEN
-------------*/

/*-----------------------------------------------------------------------
  add_nominal (n/ a for equity, handled in dll)
  ----------------------------------------------------------------------*/
void instrument.add_nominal(number nominal) option(hidden)
option(com_name: 'INTERNAL_add_nominal')
{			
	i().__add_nominal(nominal );
	return ;						
}

/*-----------------------------------------------------------------------
  add_quote
  ----------------------------------------------------------------------*/
void instrument.add_quote(	number  quote,
							logical option(nullable) set_coupon_to_quote ) option(hidden)
option(com_name: 'INTERNAL_add_quote')
{	
	if(is_ext_swap())
		i().__swap_add_quote(quote);	
	else
		i().__add_quote(quote, set_coupon_to_quote);
	return ;					
	
}
/*-----------------------------------------------------------------------
  add_quote_from_yield
  ----------------------------------------------------------------------*/
void instrument.add_quote_from_yield(number  yield ,
							logical option(nullable) set_coupon_to_yield ) option(hidden)
option(com_name: 'INTERNAL_add_quote_from_yield')
{
	QL_FAIL_COND(is_ext_swap(),"inapplicable function call for non-db swaps", this,true);
	i().__add_quote_from_yield(yield , set_coupon_to_yield );
	return ;					
	
}
/*-----------------------------------------------------------------------
  maturity_code
  ----------------------------------------------------------------------*/
string instrument.maturity_code(error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__maturity_code(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.maturity_code");	
		return e ? null<string>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.maturity_code");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  dc_method wrapper   DLL_SWAP_HANDLER OK (leg1)
  ----------------------------------------------------------------------*/
day_count_method instrument.dc_method(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		day_count_method c = i().__dc_method(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.dc_method");	
		return e ? null<day_count_method>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.dc_method");
		return null<day_count_method>;
	}
}
/*-----------------------------------------------------------------------
  pmt_bus_day 	DLL_SWAP_HANDLER OK (leg1)
  ----------------------------------------------------------------------*/
bd_convention instrument.pmt_bus_day(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		bd_convention c = i().__pmt_bus_day(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.pmt_bus_day");	
		return e ? null<bd_convention>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.pmt_bus_day");
		return null<bd_convention>;
	}
}

/*-----------------------------------------------------------------------
  eom  DLL_SWAP_HANDLER(leg1)
  ----------------------------------------------------------------------*/
logical instrument.eom(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = i().__eom(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.eom");	
		return e ? null<logical>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.eom");
		return null<logical>;
	}
}

/*-----------------------------------------------------------------------
  previous_cpn_date
  ----------------------------------------------------------------------*/
date instrument.previous_cpn_date(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__previous_cpn_date(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.previous_cpn_date");	
		return e ? null<date>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.previous_cpn_date");
		return null<date>;
	}
}

date instrument.last_cpn_date() option(hidden)
option(com_name: 'LEGACY_last_cpn_date')
{
	return this.previous_cpn_date();
}
/*-----------------------------------------------------------------------
  next_cpn_date
  ----------------------------------------------------------------------*/
date instrument.next_cpn_date(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__next_cpn_date(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.next_cpn_date");	
		return e ? null<date>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.next_cpn_date");
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  next_excpn_date
  ----------------------------------------------------------------------*/
date instrument.next_excpn_date(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__next_excpn_date(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.next_excpn_date");	
		return e ? null<date>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.next_excpn_date");
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  first_cpn_date
  ----------------------------------------------------------------------*/
date instrument.first_cpn_date(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__first_cpn_date(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.first_cpn_date");	
		return e ? null<date>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.first_cpn_date");
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  last_reg_cpn_date
  ----------------------------------------------------------------------*/
date instrument.last_reg_cpn_date(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__last_reg_cpn_date(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.last_reg_cpn_date");	
		return e ? null<date>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.last_reg_cpn_date");
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  next_cpn_date_adj
  ----------------------------------------------------------------------*/
date instrument.next_cpn_date_adj(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__next_cpn_date_adj(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.next_cpn_date_adj");	
		return e ? null<date>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.next_cpn_date_adj");
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  last_reg_cpn_date_adj
  ----------------------------------------------------------------------*/
date instrument.last_reg_cpn_date_adj(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__last_reg_cpn_date_adj(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.last_reg_cpn_date_adj");	
		return e ? null<date>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.last_reg_cpn_date_adj");
		return null<date>;
	}
}


/*-----------------------------------------------------------------------
  is_regular_first
  ----------------------------------------------------------------------*/
logical instrument.is_regular_first(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = i().__is_regular_first(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.is_regular_first");	
		return e ? null<logical>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.is_regular_first");
		return null<logical>;
	}
}
/*-----------------------------------------------------------------------
  is_regular_last
  ----------------------------------------------------------------------*/
logical instrument.is_regular_last(error_info  option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = i().__is_regular_last(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.is_regular_last");	
		return e ? null<logical>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.is_regular_last");
		return null<logical>;
	}
}

/*-----------------------------------------------------------------------
  redemp_price
  ----------------------------------------------------------------------*/
number  instrument.redemp_price(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__redemp_price(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.redemp_price");	
		return e ? null<number>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.redemp_price");
		return null<number>;
	}
}



/*-----------------------------------------------------------------------
  excpn_code
  ----------------------------------------------------------------------*/
string instrument.excpn_code(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__excpn_code(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.excpn_code");	
		return e ? null<string>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.excpn_code");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  fixing_code  
  ----------------------------------------------------------------------*/
string instrument.fixing_code(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__fixing_code(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fixing_code");	
		return e ? null<string>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fixing_code");
		return null<string>;
	}
}

string instrument.frn_fixing_code()  option(hidden)
{
	return fixing_code();
}

/*-----------------------------------------------------------------------
  first_settle_date
  ----------------------------------------------------------------------*/
date instrument.first_settle_date(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__first_settle_date(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.first_settle_date");	
		return e ? null<date>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.first_settle_date");
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  cpn_start_date  DLL_SWAP_HANDLER OK (leg1)
  ----------------------------------------------------------------------*/
date instrument.cpn_start_date(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__cpn_start_date(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.cpn_start_date");	
		return e ? null<date>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.cpn_start_date");
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  comp_freq   
  ----------------------------------------------------------------------*/
integer  instrument.comp_freq(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = i().__comp_freq(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.comp_freq");	
		return e ? err_int(): c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.comp_freq");
		return err_int();
	}
}

/*-----------------------------------------------------------------------
  accr_dc_method wrapper   DLL_SWAP_HANDLER OK (leg1)
  ----------------------------------------------------------------------*/
day_count_method instrument.accr_dc_method(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		day_count_method c = i().__accr_dc_method(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.accr_dc_method");	
		return e ? null<day_count_method>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.accr_dc_method");
		return null<day_count_method>;
	}
}
/*-----------------------------------------------------------------------
  accr_last_dc_method wrapper   DLL_SWAP_HANDLER OK (leg1, returns accr_dc)
  ----------------------------------------------------------------------*/
day_count_method instrument.accr_last_dc_method(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		day_count_method c = i().__accr_last_dc_method(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.accr_last_dc_method");	
		return e ? null<day_count_method>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.accr_last_dc_method");
		return null<day_count_method>;
	}
}
/*-----------------------------------------------------------------------
  next_dc_method   DLL_SWAP_HANDLER OK (leg1, returns accr_dc)
  ----------------------------------------------------------------------*/
day_count_method instrument.next_dc_method(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		day_count_method c = i().__next_dc_method(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.next_dc_method");	
		return e ? null<day_count_method>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.next_dc_method");
		return null<day_count_method>;
	}
}
/*-----------------------------------------------------------------------
  next_last_dc_method wrapper   DLL_SWAP_HANDLER OK (leg1, returns accr_dc)
  ----------------------------------------------------------------------*/
day_count_method instrument.next_last_dc_method(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		day_count_method c = i().__next_last_dc_method(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.next_last_dc_method");	
		return e ? null<day_count_method>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.next_last_dc_method");
		return null<day_count_method>;
	}
}

/*-----------------------------------------------------------------------
  first_coupon_rate
  ----------------------------------------------------------------------*/
number  instrument.first_coupon_rate(error_info option(nullable) error)  option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__first_coupon_rate(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.first_coupon_rate");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.first_coupon_rate");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  first_cpn_amount
  ----------------------------------------------------------------------*/
number  instrument.first_cpn_amount(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__first_cpn_amount(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.first_cpn_amount");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.first_cpn_amount");
		return null<number>;
	}
}

number instrument.first_coupon(error_info option(nullable) error) option(hidden)
option(com_name: 'LEGACY_first_coupon')
{
	return first_cpn_amount(error);
}
/*-----------------------------------------------------------------------
  last_cpn_amount (= final cpn amount)
  ----------------------------------------------------------------------*/
number  instrument.last_cpn_amount(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__last_cpn_amount(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.last_cpn_amount");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.last_cpn_amount");
		return null<number>;
	}
}

number instrument.last_coupon() option(hidden)
option(com_name: 'LEGACY_last_coupon')
{
	return last_cpn_amount();
}


/*-----------------------------------------------------------------------
  next_cpn_amount
  ----------------------------------------------------------------------*/
number  instrument.next_cpn_amount(error_info option(nullable) error) option(hidden)
{	
	try{
		
		instr_error_type t;
   		string 			s;	
		number c = i().__next_cpn_amount(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.next_cpn_amount");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.next_cpn_amount");
		return null<number>;
	}
}

number instrument.next_coupon() option(hidden)
option(com_name: 'LEGACY_next_coupon')
{
	return next_cpn_amount();
}

/*-----------------------------------------------------------------------
  roll_day   
  ----------------------------------------------------------------------*/
integer  instrument.roll_day(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = i().__roll_day(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.roll_day");	
		return e ? err_int(): c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.roll_day");
		return err_int();
	}
}

/*-----------------------------------------------------------------------
  mac_dur_analytic
  ----------------------------------------------------------------------*/
number  instrument.mac_dur_analytic(error_info option(nullable) error) option(hidden)
option(com_name: 'LEGACY_mac_dur_analytic')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__mac_dur_analytic( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.mac_dur_analytic");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.mac_dur_analytic");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  mod_dur_analytic
  ----------------------------------------------------------------------*/
number  instrument.mod_dur_analytic(error_info option(nullable) error)  option(hidden)
option(com_name: 'LEGACY_mod_dur_analytic')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__mod_dur_analytic( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.mod_dur_analytic");	
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.mod_dur_analytic");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  dol_dur_analytic
  ----------------------------------------------------------------------*/
number  instrument.dol_dur_analytic(error_info option(nullable) error)  option(hidden)
option(com_name: 'LEGACY_dol_dur_analytic')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__dol_dur_analytic( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.dol_dur_analytic");	
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.dol_dur_analytic");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  pvbp_analytic
  ----------------------------------------------------------------------*/
number  instrument.pvbp_analytic(number option(nullable) nom,
								error_info option(nullable) error)  option(hidden)
//should be option(com_name: 'LEGACY_pvbp_analytic')
{	
	try{
		nom	= conv_null_number_com(nom) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__pvbp_analytic(nom, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.pvbp_analytic");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.pvbp_analytic");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  convexity_analytic
  ----------------------------------------------------------------------*/
number  instrument.convexity_analytic(error_info option(nullable) error)  option(hidden)
option(com_name: 'LEGACY_convexity_analytic')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__convexity_analytic( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.convexity_analytic");	
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.convexity_analytic");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  dol_convexity_analytic
  ----------------------------------------------------------------------*/
number  instrument.dol_convexity_analytic(error_info option(nullable) error)  option(hidden)
option(com_name: 'LEGACY_dol_convexity_analytic')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__dol_convexity_analytic( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.dol_convexity_analytic");	
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.dol_convexity_analytic");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  sensitivity_analytic
  ----------------------------------------------------------------------*/
number  instrument.sensitivity_analytic(error_info option(nullable) error)  option(hidden)
option(com_name: 'LEGACY_sensitivity_analytic')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__sensitivity_analytic( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.sensitivity_analytic");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.sensitivity_analytic");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  accrued_days
  ----------------------------------------------------------------------*/
integer instrument.accrued_days(error_info option(nullable) error) option(hidden)
{
	try{	
		instr_error_type t;
   		string 			s;
		integer n_days;
		number c;
		c = i().__accrued_period(n_days,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.accrued_days");	
		if( e ) {
			return err_int();
		}
		return n_days;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.accrued_days");
		return err_int();
	}
}
/*-----------------------------------------------------------------------
  accrued_period
  ----------------------------------------------------------------------*/
number instrument.accrued_period(out integer n_days, error_info option(nullable) error) option(hidden)
{
	try{	
		instr_error_type t;
   		string 			s;
		number c = i().__accrued_period(n_days,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.accrued_period");	
		if( e ) {
			n_days = err_int();
			return null<number >;
		}
		return c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.accrued_period");
		n_days = err_int();
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  accrued_period
  ----------------------------------------------------------------------*/
number instrument.accrued_period(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;
		integer n_days;
		number c = i().__accrued_period(n_days,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.accrued_period");	
		if( e ) {
			return null<number >;
		}
		return c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.accrued_period");
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  accrued_chg
  ----------------------------------------------------------------------*/
number  instrument.accrued_chg(	integer bus_days,
								out	number option(nullable)	cpn_cashflow,
								out date settle,
								out date settle_next,	
								logical 	in_pcnt,								
								error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__accrued_chg(bus_days,cpn_cashflow,settle,settle_next,in_pcnt, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.accrued_chg");
		if( e ) {
			cpn_cashflow = null<number>;
			settle = settle_next = null<date>;
			return null<number>;
		}
		return c;						
	}
	catch {
		cpn_cashflow = null<number>;
		settle = settle_next = null<date>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.accrued_chg");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  clean_price_to_coupon
  ----------------------------------------------------------------------*/
number  instrument.clean_price_to_coupon(	number 		clean_price_pcnt,						
											disc_func 	disc_func,
											error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__clean_price_to_coupon(clean_price_pcnt,disc_func,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.clean_price_to_coupon");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.clean_price_to_coupon");
		return null<number>;
	}
}

number instrument.price_to_coupon(	number 		clean_price_pcnt,						
									disc_func 	disc_func)  option(hidden)
option(com_name: 'LEGACY_price_to_coupon')
{
	return this.clean_price_to_coupon(clean_price_pcnt,disc_func);
}

/*-----------------------------------------------------------------------
  dirty_price_diff
  ----------------------------------------------------------------------*/
number  instrument.dirty_price_diff(	number 					yield_diff,
										number option(nullable) nominal,
										date option(nullable) 	horizon,
										logical 				disable_rounding,																				
										error_info option(nullable) error) option(hidden)
{	
	try{
		nominal	= conv_null_number_com(nominal) ;
		horizon	= conv_null_date_com(horizon) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__dirty_price_diff(yield_diff, nominal, horizon,disable_rounding, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.dirty_price_diff");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.dirty_price_diff");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  diff_dirty  //backward compat
  ----------------------------------------------------------------------*/
number instrument.diff_dirty(	number 					yield_diff,
								number option(nullable) nominal,
								date option(nullable) 	horizon,
								logical 				disable_rounding )  option(hidden)
option(com_name: 'LEGACY_diff_dirty')								
{	
	return dirty_price_diff(yield_diff,nominal,horizon,disable_rounding );
}


/*-----------------------------------------------------------------------
  convexity_cf
  ----------------------------------------------------------------------*/
number  instrument.convexity_cf(	number option(nullable) nominal,
									number 					yield_diff,
									number 					pvbp_delta,
									logical option(nullable) pvbp_centered,
									logical option(nullable) disable_rounding,
									out number  exact_diff,
									out number  est_diff,																			
									error_info option(nullable) error) option(hidden)
{	
	try{
		nominal	= conv_null_number_com(nominal) ;		
		instr_error_type t;
   		string 			s;	
		number c = i().__convexity_cf(nominal,yield_diff, pvbp_delta,pvbp_centered, disable_rounding,exact_diff,est_diff, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.convexity_cf");	
		if( e ) {
			exact_diff = est_diff = null<number>;			
			return null<number>;
		}
		return c;						
	}
	catch {
		exact_diff = est_diff = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.convexity_cf");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  pvbp_diff
  ----------------------------------------------------------------------*/
number  instrument.pvbp_diff(	number  				nominal,
								number 					yield_diff,									
								logical option(nullable) centered,		
								logical option(nullable) scale_to_convex,																											
								error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__pvbp_diff(nominal,yield_diff, centered, scale_to_convex,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.pvbp_diff");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.pvbp_diff");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  pl_intraday
	nominal > 0 --> positive cashflows --> long instrument or lending pos
	nominal < 0 --> negative cashflows --> short instrument or borrow pos
  ----------------------------------------------------------------------*/
number  instrument.pl_intraday(	number 					nominal,
								date option(nullable) 	reval_date,
								number 					pos_quote,
								number 					reval_quote,								
								disc_func option(nullable) 		disc_func,
								out number 	option(nullable) 	pos_value,
								out number 	option(nullable) 	re_value,
								error_info option(nullable) 	error) option(hidden)
option(com_name: 'pl_intraday')							
{	
	try{
		reval_date	= conv_null_date_com(reval_date) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__pl_intraday(nominal, reval_date,pos_quote,reval_quote,disc_func,pos_value,re_value,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.pl_intraday");	
		if( e ) {
			pos_value = re_value = null<number>;			
			return null<number>;
		}
		return c;					
	}
	catch {
		pos_value = re_value = null<number>;	
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.pl_intraday");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  pl_intraday  
	nominal > 0 --> positive cashflows --> long instrument or lending pos
	nominal < 0 --> negative cashflows --> short instrument or borrow pos
  ----------------------------------------------------------------------*/
number  instrument.pl_intraday(	number 					nominal,
								date option(nullable) 	reval_date,
								disc_func 				disc_func_pos,
								disc_func 				disc_func_reval,
								out number 	option(nullable) pos_value,
								out number 	option(nullable) re_value,
								error_info option(nullable) error) option(hidden)
option(com_name: 'pl_intraday_df')	
{	
	try{
		reval_date	= conv_null_date_com(reval_date) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__pl_intraday(nominal, reval_date,disc_func_pos, disc_func_reval,pos_value,re_value,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.pl_intraday");	
		if( e ) {
			pos_value = re_value = null<number>;			
			return null<number>;
		}
		return c;						
	}
	catch {
		pos_value = re_value = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.pl_intraday");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  funding

  ----------------------------------------------------------------------*/
void instrument.funding(	date 						fwd_settle_date,
							number  					repo_rate,
							number option(nullable) 	cpn_reinv_rate,
							day_count_method 			day_count_method,
							rate_type option(nullable) 	rate_type,
							disc_func option(nullable) 	disc_func_reinv,//when repo_rate is not nullable the disc_func is only used for reinv of cpns (if cpn_reinv_rate is null)	
							cpn_reinv_type 				cpn_reinv_type,
							number option(nullable)		nominal,
							out number					dirty_price_fwd,
							out number					cf_fund_cost,
							out number 					cf_net_fund_cost,
							out number					cf_accr,
							out number					cf_coc,
							out number					cf_cpn,
							out number 					cf_cpn_reinv,								
							error_info option(nullable) error) option(hidden)
{	
	try{
		cpn_reinv_rate	= conv_null_number_com(cpn_reinv_rate) ;
		instr_error_type t;
   		string 			s;	
		i().__bond_funding(	fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,rate_type, 
							disc_func_reinv, cpn_reinv_type, dirty_price_fwd,cf_fund_cost,cf_net_fund_cost,
							cf_accr,cf_coc,cf_cpn,cf_cpn_reinv,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.funding");	
		if(e){ 
			dirty_price_fwd = cf_fund_cost = null<number>;
			cf_net_fund_cost = cf_accr = cf_coc = cf_cpn = cf_cpn_reinv = null<number>;
		}

		if(null(nominal))
			nominal = 100;
	
		dirty_price_fwd = dirty_price_fwd/100*nominal;
		cf_fund_cost 	= cf_fund_cost/100*nominal;
		cf_net_fund_cost = cf_net_fund_cost/100*nominal;
		cf_accr 		= cf_accr/100*nominal;
		cf_coc 			= cf_coc/100*nominal;
		cf_cpn 			= cf_cpn/100*nominal;
		cf_cpn_reinv 	= cf_cpn_reinv/100*nominal;
	
		return ;						
	}
	catch {
		dirty_price_fwd = cf_fund_cost = null<number>;
		cf_net_fund_cost = cf_accr = cf_coc = cf_cpn = cf_cpn_reinv = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.funding");
		return ;
	}
}


/*-----------------------------------------------------------------------
  clean_price_fwd

  ----------------------------------------------------------------------*/
number instrument.clean_price_fwd(	date 						fwd_settle_date,
									number  					repo_rate,
									number option(nullable) 	cpn_reinv_rate,
									day_count_method 			day_count_method,
									rate_type option(nullable) 	rate_type,
									disc_func option(nullable) 	disc_func,	
									cpn_reinv_type 				cpn_reinv_type,								
									error_info option(nullable) error) option(hidden)
{	
	try{
		cpn_reinv_rate	= conv_null_number_com(cpn_reinv_rate) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__clean_price_fwd(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,rate_type, 
							disc_func, cpn_reinv_type,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.clean_price_fwd");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.clean_price_fwd");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  dirty_price_fwd

  ----------------------------------------------------------------------*/
number instrument.dirty_price_fwd(	date 						fwd_settle_date,
									number  					repo_rate,
									number option(nullable) 	cpn_reinv_rate,
									day_count_method 			day_count_method,
									rate_type option(nullable) 	rate_type,
									disc_func option(nullable) 	disc_func,	
									cpn_reinv_type 				cpn_reinv_type,								
									error_info option(nullable) error) option(hidden)
{	
	try{
		cpn_reinv_rate	= conv_null_number_com(cpn_reinv_rate) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__dirty_price_fwd(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,rate_type, 
							disc_func, cpn_reinv_type,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.dirty_price_fwd");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.dirty_price_fwd");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  yield_fwd

  ----------------------------------------------------------------------*/
number instrument.yield_fwd(date 						fwd_settle_date,
							number  					repo_rate,
							number option(nullable) 	cpn_reinv_rate,
							day_count_method 			day_count_method,
							rate_type option(nullable) 	rate_type,
							disc_func option(nullable) 	disc_func,	
							cpn_reinv_type 				cpn_reinv_type,								
							error_info option(nullable) error) option(hidden)
{	
	try{
		cpn_reinv_rate	= conv_null_number_com(cpn_reinv_rate) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__yield_fwd(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,rate_type, 
							disc_func, cpn_reinv_type,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.yield_fwd");	
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.yield_fwd");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  horizon_return

  ----------------------------------------------------------------------*/
number instrument.horizon_return(	date 						fwd_settle_date,
									number  					quote,
									..quote_style	option(nullable) quote_style,
									number option(nullable) 	cpn_reinv_rate,
									day_count_method 			day_count_method,
									rate_type option(nullable) 	rate_type,
									disc_func option(nullable) 	disc_func,	
									cpn_reinv_type 				cpn_reinv_type,								
									error_info option(nullable) error) option(hidden)
{	
	try{
		cpn_reinv_rate	= conv_null_number_com(cpn_reinv_rate) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__horizon_return(fwd_settle_date,quote,quote_style,cpn_reinv_rate,day_count_method,rate_type, 
							disc_func, cpn_reinv_type,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.horizon_return");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.horizon_return");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  roll_down

  ----------------------------------------------------------------------*/
void instrument.roll_down(	date 						fwd_settle_date,							
							disc_func option(nullable) 	disc_func,
							day_count_method 			day_count_method,
							rate_type option(nullable) 	rate_type,
							logical option(nullable)	realized_fwd,
							out number  fwd_yield,
							out number  sprd_vs_crv,
							out number  roll_sprd,
							out number  roll_return,
							out date 	fwd_trade_date,
							error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;
		if(null(realized_fwd))
			realized_fwd = false;

		logical use_true_trade_date = false;
		i().__roll_down(	fwd_settle_date,disc_func, day_count_method,rate_type,realized_fwd,use_true_trade_date,fwd_yield,
							sprd_vs_crv,roll_sprd,roll_return,fwd_trade_date,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.roll_down");
		if(e){ 
			fwd_yield = sprd_vs_crv = roll_sprd = roll_return = null<number>;			
		}		
		return ;						
	}
	catch {
		fwd_yield = sprd_vs_crv = roll_sprd = roll_return = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.roll_down");
		return ;
	}
}

/*-----------------------------------------------------------------------
  valid_in_bootstrap  <public>
  ----------------------------------------------------------------------*/
logical instrument.valid_in_bootstrap(error_info option(nullable) error  )
{
	try{
		vector(date) dates;
		vector(number) amounts;
		instr_error_type t;
   		string 			s;	
		logical c = i().__cash_flows_bootstrap(dates, amounts,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.valid_in_bootstrap");
		if(e)
			return false;
		
		if(!c)
			CORE_INT.add_error_info(error,instr_error_type.ERR_T_INIT,"instrument not valid in bootstrap", "instrument.valid_in_bootstrap");
		
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.valid_in_bootstrap");
		return false;
	}
}


/*-----------------------------------------------------------------------
  cash_flows_bootstrap
  ----------------------------------------------------------------------*/
logical instrument.cash_flows_bootstrap(out vector(date)   dates,
    									out vector(number)   amounts,
										error_info option(nullable) error) option(hidden)
option(com_name: 'INTERNAL_cash_flows_bootstrap')	
{	
	try{
		//prevent warning for bootstrap
		if(null(error))
			error = new error_info(true,false);
		
		instr_error_type t;
   		string 			s;	
		logical c = i().__cash_flows_bootstrap(dates, amounts,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.cash_flows_bootstrap");
		if(e){
			dates = null<vector(date)>;
			amounts = null<vector(number)>;
			return false;
		}
		else
			return c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.cash_flows_bootstrap");
		dates = null<vector(date)>;
		amounts = null<vector(number)>;
		return false;
	}
}
/*-----------------------------------------------------------------------
  valid_in_bootstrap_fwd  <public>
  ----------------------------------------------------------------------*/
logical instrument.valid_in_bootstrap_fwd(error_info option(nullable) error  )
{
	try{
		vector(date)   fixed_dates,float_dates,float_disc_d;
		vector(number)   fixed_amounts,float_nominals;
		number first_flt_fixing;
		instr_error_type t;
   		string 			s;	
		logical c = i().__cash_flows_fwd_bootstrap(fixed_dates,fixed_amounts,first_flt_fixing,float_dates,float_disc_d,float_nominals,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.valid_in_bootstrap_fwd");
		if(e)
			return false;
		
		if(!c)
			CORE_INT.add_error_info(error,instr_error_type.ERR_T_INIT,"instrument not valid in bootstrap_fwd", "instrument.valid_in_bootstrap_fwd");
		
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.valid_in_bootstrap_fwd");
		return false;
	}
}
/*-----------------------------------------------------------------------
  cash_flows_fwd_bootstrap
  ----------------------------------------------------------------------*/
logical instrument.cash_flows_fwd_bootstrap(out vector(date)   fixed_dates,
											out vector(number)   fixed_amounts,
											number option(nullable) first_flt_fixing,
											out vector(date)   float_dates,
											out vector(date)   float_disc_d,
											out vector(number)   float_nominals,
											error_info option(nullable) error) option(hidden)
option(com_name: 'INTERNAL_cash_flows_fwd_bootstrap')	
{	
	try{
		//prevent warning for bootstrap
		if(null(error))
			error = new error_info(true,false);
		
		instr_error_type t;
   		string 			s;	
		logical c = i().__cash_flows_fwd_bootstrap(fixed_dates,fixed_amounts,first_flt_fixing,float_dates,float_disc_d,float_nominals,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.cash_flows_fwd_bootstrap");	
		if(e){
			fixed_dates = float_dates = float_disc_d = null<vector(date)>;
			fixed_amounts = float_nominals = null<vector(number)>;
			return false;
		}
		else
			return c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.cash_flows_fwd_bootstrap");
		fixed_dates = float_dates = float_disc_d = null<vector(date)>;
		fixed_amounts = float_nominals = null<vector(number)>;
		return false;
	}
}

/*  --------------------------------------------
	---FUTURES--PUBLIC--HIDDEN--IMPL._IN_ROOT--- 
	--------------------------------------------
/*-----------------------------------------------------------------------
  fut_daily_mtm
  ----------------------------------------------------------------------*/
logical instrument.fut_daily_mtm(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = i().__fut_daily_mtm(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fut_daily_mtm");
		return e ? null<logical>: c;	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fut_daily_mtm");
		return null<logical>;
	}
}

/*-----------------------------------------------------------------------
  fut_tick_value
  ----------------------------------------------------------------------*/
number  instrument.fut_tick_value(	number option(nullable) tick_size,									
									error_info option(nullable) error) option(hidden)
{	
	try{
		tick_size	= conv_null_number_com(tick_size) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__fut_tick_value(tick_size, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fut_tick_value");
		return e ? null<number>: c;	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fut_tick_value");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  fut_contract_size
  ----------------------------------------------------------------------*/
number  instrument.fut_contract_size(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__fut_contract_size(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fut_contract_size");
		return e ? null<number>: c;	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fut_contract_size");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  fut_tick_size
  ----------------------------------------------------------------------*/
number  instrument.fut_tick_size(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__fut_tick_size(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fut_tick_size");
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fut_tick_size");
		return null<number>;
	}
}

/*---------------------------------------------------
---IBOR INDEX DEP--PUBLIC--HIDDEN--IMPL._IN_ROOT--- 
---------------------------------------------------*/

/*-----------------------------------------------------------------------
  fixing_calendar_name
  ----------------------------------------------------------------------*/
string instrument.fixing_calendar_name(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__fixing_calendar_name(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fixing_calendar_name");
		return e ? null<string>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fixing_calendar_name");
		return null<string>;
	}
}


/*-----------------------------------------------------------------------
  index_maturity
  ----------------------------------------------------------------------*/
date instrument.index_maturity(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__index_maturity(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.index_maturity");
		return e ? null<date>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.index_maturity");
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  fixing_calendar
  ----------------------------------------------------------------------*/
..calendar instrument.fixing_calendar(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..calendar c = i().__fixing_calendar(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fixing_calendar");
		return e ? null<..calendar>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fixing_calendar");
		return null<..calendar>;
	}
}

/*-----------------------------------------------------------------------
  ir_index		NOT for ext swap
  ----------------------------------------------------------------------*/
ir_index instrument.ir_index(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..ir_index c = i().__ir_index( t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.ir_index");
		return e ? null<..ir_index>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.ir_index");
		return null<..ir_index>;
	}
}


/*-----------------------------------------------------------------------
  fixing_curve
  ----------------------------------------------------------------------*/
string instrument.fixing_curve(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = instr_def(error).__fixing_curve(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fixing_curve");
		return e ? null<string>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fixing_curve");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  fixing_instr
  ----------------------------------------------------------------------*/
string instrument.fixing_instr(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = instr_def(error).__fixing_instr(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fixing_instr");
		return e ? null<string>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fixing_instr");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  fixing_instr_qs
  ----------------------------------------------------------------------*/
string instrument.fixing_instr_qs(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = instr_def(error).__fixing_instr_qs(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fixing_instr_qs");
		return e ? null<string>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fixing_instr_qs");
		return null<string>;
	}
}


/*-----------------------------------------------------------------------
  index_tenor
  ----------------------------------------------------------------------*/
string instrument.index_tenor(error_info option(nullable) error) option(hidden)
{	
	try{
		..ir_index ir = ir_index(error) ;
		if(null(ir)) return null<string>;
		return ir.tenor();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.index_tenor");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  index_tenor
  ----------------------------------------------------------------------*/
tenor_code instrument.index_tenor_code(error_info option(nullable) error) option(hidden)
{	
	try{
		..ir_index ir = ir_index(error) ;
		if(null(ir)) return null<tenor_code>;
		return ir.tenor_code();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.index_tenor_code");
		return null<tenor_code>;
	}
}

/*-----------------------------------------------------------------------
  fixing_date  only for FRN,CALL_FRN,FRA,MMFUT,NOIS  (if FRN: not applicable for frn-rfr)
  ----------------------------------------------------------------------*/
date instrument.fixing_date(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__fixing_date(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fixing_date");	
		return e ? null<date>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fixing_date");
		return null<date>;
	}
}

/*  ---------------------------------------------------
	---FX--PUBLIC--HIDDEN--IMPL._IN_ROOT--- 
	---------------------------------------------------*/
/*-----------------------------------------------------------------------
  fx_add_quote
  ----------------------------------------------------------------------*/
void instrument.fx_add_quote(	number  quote,
								logical option(nullable) quote_is_unit) option(hidden) 
option(com_name: 'LEGACY_fx_add_quote')
{	
	i().__fx_add_quote(quote, quote_is_unit);
	return ;					
	
}

/*-----------------------------------------------------------------------
  fx_spot_date
  ----------------------------------------------------------------------*/
date instrument.fx_spot_date(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__fx_spot_date(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_spot_date");
		return e ? null<date>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_spot_date");
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  fx_pip_decimals
  ----------------------------------------------------------------------*/
integer  instrument.fx_pip_decimals(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = i().__fx_pip_decimals(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_pip_decimals");
		return e ? err_int(): c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_pip_decimals");
		return err_int();
	}
}


integer instrument.fx_pip_value() option(hidden)
option(com_name: 'LEGACY_fx_pip_value')
{
	return fx_pip_decimals();
}
/*-----------------------------------------------------------------------
  fx_quote_dec   
  ----------------------------------------------------------------------*/
integer  instrument.fx_quote_dec(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = i().__fx_quote_dec(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_quote_dec");
		return e ? err_int(): c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_quote_dec");
		return err_int();
	}
}

/*-----------------------------------------------------------------------
  fx_scale  
  ----------------------------------------------------------------------*/
integer  instrument.fx_scale(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = i().__fx_scale(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_scale");
		return e ? err_int(): c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_scale");
		return err_int();
	}
}

/*-----------------------------------------------------------------------
  fx_spot_days  
  ----------------------------------------------------------------------*/
integer  instrument.fx_spot_days(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = i().__fx_spot_days(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_spot_days");
		return e ? err_int(): c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_spot_days");
		return err_int();
	}
}

/*-----------------------------------------------------------------------
  fx_reverse_ric
  ----------------------------------------------------------------------*/
logical instrument.fx_reverse_ric(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = i().__fx_reverse_ric(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_reverse_ric");
		return e ? null<logical>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_reverse_ric");
		return null<logical>;
	}
}

/*-----------------------------------------------------------------------
  fx_is_post_spot
  ----------------------------------------------------------------------*/
logical  instrument.fx_is_post_spot(	instrument fx_spot,
										error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = i().__fx_is_post_spot(fx_spot.i(),t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_is_post_spot");
		return e ? null<logical>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_is_post_spot");
		return null<logical >;
	}
}

/*-----------------------------------------------------------------------
  fx_is_on
  ----------------------------------------------------------------------*/
logical  instrument.fx_is_on(	error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = i().__fx_is_on(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_is_on");
		return e ? null<logical>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_is_on");
		return null<logical >;
	}
}
/*-----------------------------------------------------------------------
  fx_base_ccy
  ----------------------------------------------------------------------*/
string instrument.fx_base_ccy(error_info option(nullable) error)  option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__fx_base_ccy(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_base_ccy");
		return e ? null<string>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_base_ccy");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  fx_price_ccy
  ----------------------------------------------------------------------*/
string instrument.fx_price_ccy(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__fx_price_ccy(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_price_ccy");
		return e ? null<string>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_price_ccy");
		return null<string>;
	}
}


/*-----------------------------------------------------------------------
  fx_spot_name
  ----------------------------------------------------------------------*/
string instrument.fx_spot_name(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__fx_spot_name(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_spot_name");
		return e ? null<string>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_spot_name");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  fx_spot_code
  ----------------------------------------------------------------------*/
string instrument.fx_spot_code(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__fx_spot_code(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_spot_code");
		return e ? null<string>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_spot_code");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  fx_price_ccy_calendar_name
  ----------------------------------------------------------------------*/
string instrument.fx_price_ccy_calendar_name(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__fx_price_ccy_calendar_name(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_price_ccy_calendar_name");
		return e ? null<string>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_price_ccy_calendar_name");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  fx_base_ccy_calendar_name
  ----------------------------------------------------------------------*/
string instrument.fx_base_ccy_calendar_name(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__fx_base_ccy_calendar_name(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_base_ccy_calendar_name");
		return e ? null<string>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_base_ccy_calendar_name");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  fx_usd_calendar_name
  ----------------------------------------------------------------------*/
string instrument.fx_usd_calendar_name(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__fx_usd_calendar_name(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_usd_calendar_name");
		return e ? null<string>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_usd_calendar_name");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  fx_usd_calendar
  ----------------------------------------------------------------------*/
calendar instrument.fx_usd_calendar(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..calendar c = i().__fx_usd_calendar(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_usd_calendar");
		return e ? null<..calendar>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_usd_calendar");
		return null<..calendar>;
	}
}

calendar instrument.usd_calendar() option(hidden)
option(com_name: 'LEGACY_usd_calendar')
{
	return fx_usd_calendar();
}
/*-----------------------------------------------------------------------
  fx_price_ccy_calendar
  ----------------------------------------------------------------------*/
calendar instrument.fx_price_ccy_calendar(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..calendar c = i().__fx_price_ccy_calendar(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_price_ccy_calendar");
		return e ? null<..calendar>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_price_ccy_calendar");
		return null<..calendar>;
	}
}

calendar instrument.price_ccy_calendar( ) option(hidden)
option(com_name: 'LEGACY_price_ccy_calendar')
{
	return fx_price_ccy_calendar();
}
/*-----------------------------------------------------------------------
  fx_base_ccy_calendar
  ----------------------------------------------------------------------*/
calendar instrument.fx_base_ccy_calendar(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..calendar c = i().__fx_base_ccy_calendar(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_base_ccy_calendar");
		return e ? null<..calendar>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_base_ccy_calendar");
		return null<..calendar>;
	}
}

calendar instrument.base_ccy_calendar( ) option(hidden)
option(com_name: 'LEGACY_base_ccy_calendar')
{
	return fx_base_ccy_calendar();
}

/*-----------------------------------------------------------------------
  fx_rule
  ----------------------------------------------------------------------*/
..fx_spot_rule instrument.fx_rule(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..fx_spot_rule  c = i().__fx_rule(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_rule");
		return e ? null<..fx_spot_rule>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_rule");
		return null<..fx_spot_rule >;
	}
}

/*-----------------------------------------------------------------------
  fx_quote
  ----------------------------------------------------------------------*/
number  instrument.fx_quote(	logical		unit_quote,
								logical 	no_rnd,	
								error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__fx_quote(unit_quote,no_rnd,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_quote");
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_quote");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  fx_quote_inv fwd+spot
  ----------------------------------------------------------------------*/
number  instrument.fx_quote_inv(	number option(nullable)		scale,
									logical 					no_rnd,		
									error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__fx_quote_inv(scale,no_rnd,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fx_quote_inv");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fx_quote_inv");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  fx_synt_depo only for fx_swap and fx fwd
  ----------------------------------------------------------------------*/
instrument  instrument.fx_synt_depo(instrument 				fx_spot,
									day_count_method 		dc_synt,
									number 					rate,
									day_count_method 		dc,
									logical 				synt_is_base,	
									instrument option(nullable)	fx_swap_tn,
									error_info option(nullable) e)  option(hidden)
{
	return this.err_type(null<instrument>, e,"fx_synt_depo");	
}

/*  ---------------------------------------------------
	---INDEXLINKED--PUBLIC--HIDDEN--IMPL._IN_ROOT--- 
	---------------------------------------------------

/*-----------------------------------------------------------------------
  il_dirty_price
  ----------------------------------------------------------------------*/
number instrument.il_dirty_price(	cpi_link option(nullable) 	cpi_forecast,
									disc_func 					disc_func_nominal,									
									error_info option(nullable) error)  option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__il_dirty_price(cpi_forecast,disc_func_nominal,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_dirty_price");
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_dirty_price");
		return null<number >;
	}
}

number instrument.dirty_price(	cpi_link option(nullable) cpi_forecast,
								disc_func disc_func_nominal) option(hidden)
option(com_name: 'LEGACY_dirty_price')								
{
	return il_dirty_price(cpi_forecast,disc_func_nominal);
}

/*-----------------------------------------------------------------------
  il_clean_price
  ----------------------------------------------------------------------*/
number instrument.il_clean_price(	logical 					ex_inflation,									
									error_info option(nullable) error) 
option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__il_clean_price(ex_inflation,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_clean_price");
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_clean_price");
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  il_index_freq
  ----------------------------------------------------------------------*/
integer instrument.il_index_freq(	error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c = i().__il_index_freq(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_index_freq");
		return e ? err_freq(): c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_index_freq");
		return err_freq();
	}
}

integer instrument.index_freq() 
option(hidden)
option(com_name: 'LEGACY_index_freq')
{
	return il_index_freq();
}
/*-----------------------------------------------------------------------
  il_index_factor
  ----------------------------------------------------------------------*/
number instrument.il_index_factor(	error_info option(nullable) error) 
option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__il_index_factor(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_index_factor");
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_index_factor");
		return null<number >;
	}
}

number instrument.index_factor() option(hidden)
option(com_name: 'index_factor')
//should be option(com_name: 'LEGACY_index_factor')
{
	return il_index_factor();
}

/*-----------------------------------------------------------------------
  il_index_factor
  ----------------------------------------------------------------------*/
number instrument.il_index_factor(	date option(nullable) 	trade_date,
									date 					settle_date,
									//logical 				check_publ_date,
									error_info option(nullable) error) option(hidden)
option(com_name: 'il_index_factor_ext')									
{	
	try{
		trade_date	= conv_null_date_com(trade_date) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__il_index_factor(trade_date,settle_date,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_index_factor");
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_index_factor");
		return null<number >;
	}
}

number instrument.index_factor(date date) option(hidden)
option(com_name: 'index_factor_dt')
//should be option(com_name: 'LEGACY_index_factor_dt')
{
	return il_index_factor(this.trade_date(),date);
}
/*-----------------------------------------------------------------------
  il_base_cpi
  ----------------------------------------------------------------------*/
number instrument.il_base_cpi(	error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__il_base_cpi(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_base_cpi");
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_base_cpi");
		return null<number >;
	}
}

number instrument.base_cpi() option(hidden)
option(com_name: 'LEGACY_base_cpi')
{
	return il_base_cpi();
}
/*-----------------------------------------------------------------------
  il_imp_index
  ----------------------------------------------------------------------*/
/*number instrument.il_imp_index(	error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__il_imp_index(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_imp_index");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_imp_index");
		return null<number >;
	}
}*/
/*-----------------------------------------------------------------------
  il_cash_flow_amounts
  ----------------------------------------------------------------------*/
vector(number) instrument.il_cash_flow_amounts(	cpi_link option(nullable) 	cpi_forecast,
												number option(nullable) 	nominal,
												logical 					post_settle,
												logical 					keep_size,
												ir_cf_code 					cf_code,
												il_cf_code 					il_cf_code,
												error_info option(nullable) error) option(hidden)
{	
	try{
		nominal	= conv_null_number_com(nominal) ;
		instr_error_type t;
   		string 			s;	
		vector(number) c = i().__il_cash_flow_amounts(cpi_forecast,nominal,post_settle,keep_size,cf_code,il_cf_code,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_cash_flow_amounts");
		return e ? null<vector(number)>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_cash_flow_amounts");
		return null<vector(number) >;
	}
}

/*-----------------------------------------------------------------------
  il_cash_flow_nom_amounts
  ----------------------------------------------------------------------*/
vector(number) instrument.il_cash_flow_nom_amounts(	cpi_link option(nullable) 	cpi_forecast,
													number option(nullable) 	nominal,
													logical 					post_settle,
													logical 					keep_size,
													error_info option(nullable) error) option(hidden)
{	
	try{
		nominal	= conv_null_number_com(nominal) ;
		instr_error_type t;
   		string 			s;	
		vector(number) c = i().__il_cash_flow_nom_amounts(cpi_forecast,nominal,post_settle,keep_size,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_cash_flow_nom_amounts");
		return e ? null<vector(number)>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_cash_flow_nom_amounts");
		return null<vector(number) >;
	}
}

vector(number) instrument.cash_flow_nom_amounts(cpi_link cpi_link) option(hidden)
option(com_name: 'LEGACY_cash_flow_nom_amounts')
{
	return il_cash_flow_nom_amounts(cpi_link);
}

/*-----------------------------------------------------------------------
  il_cash_flow_nom_cpn
  ----------------------------------------------------------------------*/
vector(number) instrument.il_cash_flow_nom_cpn(	cpi_link option(nullable) 	cpi_forecast,
												number option(nullable) 	nominal,
												logical 					post_settle,
												logical 					keep_size,
												error_info option(nullable) error) option(hidden)
{	
	try{
		nominal	= conv_null_number_com(nominal) ;
		instr_error_type t;
   		string 			s;	
		vector(number) c = i().__il_cash_flow_nom_cpn(cpi_forecast,nominal,post_settle,keep_size,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_cash_flow_nom_cpn");
		return e ? null<vector(number)>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_cash_flow_nom_cpn");
		return null<vector(number) >;
	}
}

/*-----------------------------------------------------------------------
  il_cpi_link
  ----------------------------------------------------------------------*/
cpi_link instrument.il_cpi_link(error_info option(nullable) error)
option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		cpi_link c = i().__il_cpi_link(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_cpi_link");
		return e ? null<cpi_link>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_cpi_link");
		return null<cpi_link>;
	}
}

/*-----------------------------------------------------------------------
  il_cpi_link_idx2
  ----------------------------------------------------------------------*/
cpi_link instrument.il_cpi_link_idx2(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		cpi_link c = i().__il_cpi_link_idx2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_cpi_link_idx2");
		return e ? null<cpi_link>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_cpi_link_idx2");
		return null<cpi_link>;
	}
}

/*-----------------------------------------------------------------------
  il_cpi_knots

  ----------------------------------------------------------------------*/
void instrument.il_cpi_knots(	date 							settle_date,
								out date  option(nullable)		mth_lag1,
								out date   option(nullable)		mth_lag2,
								out logical   option(nullable)	active_lag1,
								out logical   option(nullable)	active_lag2,																
								error_info option(nullable) 	error) 		option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__il_cpi_knots(settle_date,mth_lag1,mth_lag2,active_lag1,active_lag2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_cpi_knots");
		if(e){ 
			mth_lag1 = mth_lag1 = null<date>;
			active_lag1 = active_lag1 = null<logical>;	
		}		
		return ;						
	}
	catch {
		mth_lag1 = mth_lag1 = null<date>;
		active_lag1 = active_lag1 = null<logical>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_cpi_knots");
		return ;
	}
}

void  instrument.cpi_knots(		date settle_date,
								out date  option(nullable)	mth_lag1,
								out date   option(nullable)	mth_lag2,
								out logical   option(nullable)	active_lag1,
								out logical   option(nullable)	active_lag2) option(hidden)
option(com_name: 'LEGACY_cpi_knots')
{
	il_cpi_knots(settle_date,mth_lag1,mth_lag2,active_lag1,active_lag2);
}
/*-----------------------------------------------------------------------
  il_cpi_values

  ----------------------------------------------------------------------*/
void instrument.il_cpi_values(	out number  option(nullable)	value1,
								out number   option(nullable)	value2,															
								error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__il_cpi_values(value1,value2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_cpi_values");
		if(e){ 
			value1 = value2 = null<number>;	
		}		
		return ;						
	}
	catch {
		value1 = value2 = null<number>;	
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_cpi_values");
		return ;
	}
}

void  instrument.get_cpi_values(out number  option(nullable)	value1,
								out number   option(nullable)	value2) option(hidden)
option(com_name: 'LEGACY_get_cpi_values')
{
	il_cpi_values(value1,value2);
}

/*-----------------------------------------------------------------------
  il_bond_funding

  ----------------------------------------------------------------------*/
void instrument.il_bond_funding(date 						fwd_settle_date,
								number  					repo_rate,
								number option(nullable) 	cpn_reinv_rate,
								day_count_method 			day_count_method,
								rate_type option(nullable) 	rate_type,
								disc_func option(nullable) 	disc_func_reinv_nom,	//when repo_rate is not nullable the disc_func is only used for reinv of cpns (if cpn_reinv_rate is null)
								cpn_reinv_type 				cpn_reinv_type,	
								cpi_link option(nullable) 	cpi_link_forecast,
								number option(nullable)		nominal,
								out number		dirty_price_fwd,
								out number		cf_fund_cost,
								out number 	cf_net_fund_cost,
								out number		cf_accr,
								out number		cf_coc,
								out number		cf_cpn,
								out number 	cf_cpn_reinv,
								out number 	index_factor,
								out number 	index_factor_fwd,
								out number 	cpi_return,
								out number 	real_return,								
								error_info option(nullable) error) option(hidden)
{	
	try{
		cpn_reinv_rate	= conv_null_number_com(cpn_reinv_rate) ;
		instr_error_type t;
   		string 			s;	
		i().__il_bond_funding(	fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,rate_type, 
							disc_func_reinv_nom, cpn_reinv_type, cpi_link_forecast,dirty_price_fwd,cf_fund_cost,cf_net_fund_cost,
							cf_accr,cf_coc,cf_cpn,cf_cpn_reinv,index_factor,index_factor_fwd,cpi_return,real_return,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_bond_funding");
		if(e){ 
			dirty_price_fwd = cf_fund_cost = index_factor = index_factor_fwd = cpi_return = null<number>;
			cf_net_fund_cost = cf_accr = cf_coc = cf_cpn = cf_cpn_reinv = real_return = null<number>;
		}

		if(null(nominal))
			nominal = 100;
	
		dirty_price_fwd = dirty_price_fwd/100*nominal;
		cf_fund_cost 	= cf_fund_cost/100*nominal;
		cf_net_fund_cost = cf_net_fund_cost/100*nominal;
		cf_accr 		= cf_accr/100*nominal;
		cf_coc 			= cf_coc/100*nominal;
		cf_cpn 			= cf_cpn/100*nominal;
		cf_cpn_reinv 	= cf_cpn_reinv/100*nominal;
	
		return ;						
	}
	catch {
		dirty_price_fwd = cf_fund_cost = index_factor = index_factor_fwd = cpi_return = null<number>;
		cf_net_fund_cost = cf_accr = cf_coc = cf_cpn = cf_cpn_reinv = real_return = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_bond_funding");
		return ;
	}
}

/*-----------------------------------------------------------------------
  il_clean_price_fwd

  ----------------------------------------------------------------------*/
number instrument.il_clean_price_fwd(date 						fwd_settle_date,
									number  					repo_rate,
									number option(nullable) 	cpn_reinv_rate,
									day_count_method 			day_count_method,
									rate_type option(nullable) 	rate_type,
									disc_func option(nullable) 	disc_func_nominal,	
									cpn_reinv_type 				cpn_reinv_type,	
									cpi_link option(nullable) 	cpi_link_forecast,	
									logical						ex_inflation,						
									error_info option(nullable) error) option(hidden)
{	
	try{
		cpn_reinv_rate	= conv_null_number_com(cpn_reinv_rate) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__il_clean_price_fwd(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,rate_type, 
							disc_func_nominal, cpn_reinv_type,cpi_link_forecast,ex_inflation,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_clean_price_fwd");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_clean_price_fwd");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  il_dirty_price_fwd

  ----------------------------------------------------------------------*/
number instrument.il_dirty_price_fwd(date 						fwd_settle_date,
									number  					repo_rate,
									number option(nullable) 	cpn_reinv_rate,
									day_count_method 			day_count_method,
									rate_type option(nullable) 	rate_type,
									disc_func option(nullable) 	disc_func_nominal,	
									cpn_reinv_type 				cpn_reinv_type,	
									cpi_link option(nullable) 	cpi_link_forecast,							
									error_info option(nullable) error) option(hidden)
{	
	try{
		cpn_reinv_rate	= conv_null_number_com(cpn_reinv_rate) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__il_dirty_price_fwd(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,rate_type, 
							disc_func_nominal, cpn_reinv_type,cpi_link_forecast,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_dirty_price_fwd");
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_dirty_price_fwd");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  il_yield_fwd

  ----------------------------------------------------------------------*/
number instrument.il_yield_fwd(	date 						fwd_settle_date,
								number  					repo_rate,
								number option(nullable) 	cpn_reinv_rate,
								day_count_method 			day_count_method,
								rate_type option(nullable) 	rate_type,
								disc_func option(nullable) 	disc_func_nominal,	
								cpn_reinv_type 				cpn_reinv_type,	
								cpi_link option(nullable) 	cpi_link_forecast,							
								error_info option(nullable) error) option(hidden)
{	
	try{
		cpn_reinv_rate	= conv_null_number_com(cpn_reinv_rate) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__il_yield_fwd(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,rate_type, 
							disc_func_nominal, cpn_reinv_type,cpi_link_forecast,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_yield_fwd");
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_yield_fwd");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  il_roll_down

  ----------------------------------------------------------------------*/
void instrument.il_roll_down(	date 						fwd_settle_date,
								disc_func  					disc_func,
								logical  					disc_func_is_real,								
								day_count_method 			day_count_method,
								rate_type option(nullable) 	rate_type,							
								cpi_link option(nullable) 	cpi_link_forecast,						
								out number	fwd_yield,
								out number	sprd_vs_crv,
								out number roll_sprd,
								out number	roll_return,															
								error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__il_roll_down(	fwd_settle_date, disc_func, disc_func_is_real, day_count_method, rate_type,
							cpi_link_forecast,fwd_yield,sprd_vs_crv,roll_sprd,roll_return,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_roll_down");
		if(e){ 
			fwd_yield = sprd_vs_crv = null<number>;
			roll_sprd = roll_return = null<number>;
		}		
		return ;						
	}
	catch {
		fwd_yield = sprd_vs_crv = null<number>;
		roll_sprd = roll_return = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_roll_down");
		return ;
	}
}

/*-----------------------------------------------------------------------
  il_horizon_return

  ----------------------------------------------------------------------*/
number instrument.il_horizon_return(date 						fwd_settle_date,
									number  					quote,
									..quote_style	option(nullable) quote_style,
									number option(nullable)		cpn_reinv_rate,								
									day_count_method 			day_count_method,
									rate_type option(nullable) 	rate_type,
									disc_func option(nullable) 	disc_func,
									cpn_reinv_type 				cpn_reinv_type,							
									cpi_link option(nullable) 	cpi_link_forecast,																								
									error_info option(nullable) error) option(hidden)
{	
	try{
		cpn_reinv_rate	= conv_null_number_com(cpn_reinv_rate) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__il_horizon_return(	fwd_settle_date,quote,quote_style,cpn_reinv_rate,day_count_method,rate_type,
											disc_func,cpn_reinv_type,cpi_link_forecast,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.il_horizon_return");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.il_horizon_return");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  fix_leg_y_to_pv
	bool ok = Mw::is_swap_fixflt(b.instr_def()->type(),false) || Mw::is_fix_ois(b.instr_def()->type(),false) 
		|| Mw::is_real_swap_fixflt(b.instr_def()->type(),false) || Mw::is_zero_swap(b.instr_def()->type(),true,true);
  ----------------------------------------------------------------------*/
/*number  instrument.fix_leg_y_to_pv(	number option(nullable)	yield,
									logical 				in_pcnt,
									error_info option(nullable) error) option(hidden)
{	
	try{
		yield	= conv_null_number_com(yield) ;
		instr_error_type t;
   		string 			s;	
		number c = i().__fix_leg_pv(yield,in_pcnt,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.fix_leg_y_to_pv");
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.fix_leg_y_to_pv");
		return null<number>;
	}
}*/


/*-----------------------------------------------------------------------
  check_full_swap  EXT SWAP: ok   <protected>
  ----------------------------------------------------------------------*/
/*logical instrument.check_full_swap(logical f, error_info option(nullable) error) 
{	
	try{
		error_info ee = new error_info(true,false);
		QL_REQUIRE(this.is_valid(ee),"invalid instrument");
		
		if(null(f) || !f) {			
			f = this.verify_full_swap(ee);
			QL_REQUIRE(f, null(ee.message()) ? "invalid swap" : ee.message());
		}
				
		return f;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.check_full_swap");		
		return false;
	}
}*/

/*-----------------------------------------------------------------------
  verify_full_swap  EXT SWAP: ok <protected>
  if true is returned then we have a complete swap in __instrument
  (fltflt2s in "limbo" will return false)
  ----------------------------------------------------------------------*/
/*logical instrument.verify_full_swap(error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = i().__verify_full_swap(t, s);//if c=null or c=false then t,s = error
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.verify_full_swap");
		return e ? false: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.verify_full_swap");
		return false;
	}
*/


/*-----------------------------------------------------------------------
  swap_type  EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*instrument_type instrument.swap_type(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		instrument_type c = i().__swap_type(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_type");
		return e ? null<instrument_type>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_type");
		return null<instrument_type >;
	}
*/

/*-----------------------------------------------------------------------
  swap_payleg1 
  ----------------------------------------------------------------------*/
/*logical	 instrument.swap_payleg1(error_info option(nullable) error ) option(hidden)
{
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = i().__swap_payleg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_payleg1");
		return e ? null<logical> : c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_payleg1");
		return null<logical>;
	}
}*/

/*-----------------------------------------------------------------------
  swap_ir_index_leg1
  ----------------------------------------------------------------------*/
/*ir_index instrument.swap_ir_index_leg1(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..ir_index c = i().__swap_ir_index_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_ir_index_leg1");
		return e ? null<..ir_index >: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_ir_index_leg1");
		return null<..ir_index >;
	}
}*/
/*-----------------------------------------------------------------------
  swap_ir_index_leg2
  ----------------------------------------------------------------------*/
/*ir_index instrument.swap_ir_index_leg2(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..ir_index c = i().__swap_ir_index_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_ir_index_leg2");
		return e ? null<..ir_index >: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_ir_index_leg2");
		return null<..ir_index >;
	}
}*/
/*-----------------------------------------------------------------------
  swap_coupon_freq_leg1 
  ----------------------------------------------------------------------*/
/*integer instrument.swap_coupon_freq_leg1(error_info option(nullable) error) option(hidden)
{	
	try{
		instr_error_type t;
   		string 			s;
		integer c1,c2;
		i().__swap_cpn_freq(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_coupon_freq_leg1");
		return e ? err_freq() : c1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_coupon_freq_leg1");
		return err_freq();
	}
}*/

/*-----------------------------------------------------------------------
  swap_coupon_freq_leg2 
  ----------------------------------------------------------------------*/
/*integer instrument.swap_coupon_freq_leg2(error_info option(nullable) error) option(hidden)
{	
	try{
		instr_error_type t;
   		string 			s;
		integer c1,c2;
		i().__swap_cpn_freq(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_coupon_freq_leg2");
		return e ? err_freq() : c2;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_coupon_freq_leg2");
		return err_freq();
	}
}*/

/*-----------------------------------------------------------------------
  swap_reset_freq_leg1 
  ----------------------------------------------------------------------*/
/*integer instrument.swap_reset_freq_leg1(error_info option(nullable) error) option(hidden)
{	
	try{
		instr_error_type t;
   		string 			s;
		integer c1,c2;
		i().__swap_reset_freq(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_reset_freq_leg1");
		return e ? err_freq() : c1;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_reset_freq_leg1");
		return err_freq();
	}
*/
/*-----------------------------------------------------------------------
  swap_reset_freq_leg2 
  ----------------------------------------------------------------------*/
/*integer instrument.swap_reset_freq_leg2(error_info option(nullable) error) option(hidden)
{	
	try{
		instr_error_type t;
   		string 			s;
		integer c1,c2;
		i().__swap_reset_freq(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_reset_freq_leg2");
		return e ? err_freq() : c2;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_reset_freq_leg2");
		return err_freq();
	}
}*/

/*-----------------------------------------------------------------------
  swap_pmt_lag_leg1 (not for non-db swaps)
  ----------------------------------------------------------------------*/
/*integer instrument.swap_pmt_lag_leg1(error_info option(nullable) error) option(hidden)
{	
	try{
		integer c = this.instr_def(error).swap_pmt_lag_leg1(error);
		//CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_pmt_lag_leg1");
		return err_int();
	}
}*/

/*-----------------------------------------------------------------------
  swap_pmt_lag_prin_leg1 (not for non-db swaps)
  ----------------------------------------------------------------------*/
/*integer instrument.swap_pmt_lag_prin_leg1(error_info option(nullable) error) option(hidden)
{	
	try{
		integer c = this.instr_def(error).swap_pmt_lag_prin_leg1(error);
		//CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_pmt_lag_prin_leg1");
		return err_int();
	}
}*/

/*-----------------------------------------------------------------------
  swap_pmt_lag_leg2 (not for non-db swaps)
  ----------------------------------------------------------------------*/
/*integer instrument.swap_pmt_lag_leg2(error_info option(nullable) error) option(hidden)
{	
	try{
		integer c = this.instr_def(error).swap_pmt_lag_leg2(error);
		//CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_pmt_lag_leg2");
		return err_int();
	}
}*/

/*-----------------------------------------------------------------------
  swap_pmt_lag_prin_leg2 (not for non-db swaps)
  ----------------------------------------------------------------------*/
/*integer instrument.swap_pmt_lag_prin_leg2(error_info option(nullable) error) option(hidden)
{	
	try{
		integer c = this.instr_def(error).swap_pmt_lag_prin_leg2(error);
		//CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_pmt_lag_prin_leg2");
		return err_int();
	}
}*/


/*-----------------------------------------------------------------------
  swap_rfr_arr_type_leg1
  ----------------------------------------------------------------------*/
/*rfr_arrears_type instrument.swap_rfr_arr_type_leg1(error_info option(nullable) error) option(hidden)
{	
	try{
		rfr_arrears_type c = this.instr_def(error).swap_rfr_arr_type_leg1(error);
		//CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_rfr_arr_type_leg1");
		return null<rfr_arrears_type>;
	}
}*/

/*-----------------------------------------------------------------------
  swap_rfr_arr_days_leg1
  ----------------------------------------------------------------------*/
/*integer instrument.swap_rfr_arr_days_leg1(error_info option(nullable) error) option(hidden)
{	
	try{
		integer c = this.instr_def(error).swap_rfr_arr_days_leg1(error);
		//CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_rfr_arr_days_leg1");
		return err_int();
	}
}*/

/*-----------------------------------------------------------------------
  swap_rfr_arr_type_leg2
  ----------------------------------------------------------------------*/
/*rfr_arrears_type instrument.swap_rfr_arr_type_leg2(error_info option(nullable) error) option(hidden)
{	
	try{
		rfr_arrears_type c = this.instr_def(error).swap_rfr_arr_type_leg2(error);
		//CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_rfr_arr_type_leg2");
		return null<rfr_arrears_type>;
	}
*/


/*-----------------------------------------------------------------------
  swap_rfr_arr_days_leg2
  ----------------------------------------------------------------------*/
/*integer instrument.swap_rfr_arr_days_leg2(error_info option(nullable) error) option(hidden)
{	
	try{
		integer c = this.instr_def(error).swap_rfr_arr_days_leg2(error);
		//CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_rfr_arr_days_leg2");
		return err_int();
	}
}*/
/*-----------------------------------------------------------------------
  swap_comp_avg_type_leg1
  ----------------------------------------------------------------------*/
/*flt_comp_avg_type instrument.swap_comp_avg_type_leg1(error_info option(nullable) error) option(hidden)
{	
	try{
		flt_comp_avg_type c = this.instr_def(error).swap_comp_avg_type_leg1(error);
		//CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_comp_avg_type_leg1");
		return null<flt_comp_avg_type>;
	}
}*/
/*-----------------------------------------------------------------------
  swap_comp_avg_type_leg2
  ----------------------------------------------------------------------*/
/*flt_comp_avg_type instrument.swap_comp_avg_type_leg2(error_info option(nullable) error) option(hidden)
{	
	try{
		flt_comp_avg_type c = this.instr_def(error).swap_comp_avg_type_leg2(error);
		//CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_comp_avg_type_leg2");
		return null<flt_comp_avg_type>;
	}
}*/

/*-----------------------------------------------------------------------
  swap_avg_method_leg1
  ----------------------------------------------------------------------*/
/*flt_sprd_comp_method instrument.swap_sprd_comp_method_leg1(error_info option(nullable) error) option(hidden)
{	
	try{
		flt_sprd_comp_method c = this.instr_def(error).swap_sprd_comp_method_leg1(error);
		//CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_sprd_comp_method_leg1");
		return null<flt_sprd_comp_method>;
	}
}*/
/*-----------------------------------------------------------------------
  swap_sprd_comp_method_leg2
  ----------------------------------------------------------------------*/
/*flt_sprd_comp_method instrument.swap_sprd_comp_method_leg2(error_info option(nullable) error) option(hidden)
{	
	try{
		flt_sprd_comp_method c = this.instr_def(error).swap_sprd_comp_method_leg2(error);
		//CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_sprd_comp_method_leg2");
		return null<flt_sprd_comp_method>;
	}
}*/

/*-----------------------------------------------------------------------
  swap_avg_method_leg1
  ----------------------------------------------------------------------*/
/*flt_avg_method instrument.swap_avg_method_leg1(error_info option(nullable) error) option(hidden)
{	
	try{
		flt_avg_method c = this.instr_def(error).swap_avg_method_leg1(error);
		//CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_avg_method_leg1");
		return null<flt_avg_method>;
	}
}*/
/*-----------------------------------------------------------------------
  swap_avg_method_leg2
  ----------------------------------------------------------------------*/
/* instrument.swap_avg_method_leg2(error_info option(nullable) error) option(hidden)
{	
	try{
		flt_avg_method c = this.instr_def(error).swap_avg_method_leg2(error);
		//CORE_INT.reset_single(error);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_avg_method_leg2");
		return null<flt_avg_method>;
	}
}*/
/*-----------------------------------------------------------------------
  swap_dc_method_leg1   DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
/*day_count_method instrument.swap_dc_method_leg1(error_info option(nullable) error) option(hidden)
{	
	try{
		instr_error_type t;
   		string 			s;
		day_count_method c1,c2;
		i().__swap_dc_method( c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_dc_method_leg1");
		return e ? null<day_count_method>: c1;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_dc_method_leg1");
		return null<day_count_method>;
	}
}
*/
/*-----------------------------------------------------------------------
  swap_dc_method_leg2   DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
/*day_count_method instrument.swap_dc_method_leg2(error_info option(nullable) error) option(hidden)
{	
	try{
		instr_error_type t;
   		string 			s;
		day_count_method c1,c2;
		i().__swap_dc_method( c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_dc_method_leg2");
		return e ? null<day_count_method>: c2;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_dc_method_leg2");
		return null<day_count_method>;
	}
}*/

/*-----------------------------------------------------------------------
  swap_currency_leg1
  ----------------------------------------------------------------------*/
/*instrument.swap_currency_leg1(error_info option(nullable) error) option(hidden)
{	
	try{
		instr_error_type t;
		string s;
		string c1,c2;
		i().__swap_currency( c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_currency_leg1");
		return e ? null<string>: c1;				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_currency_leg1");
		return null<string >;
	}
}*/

/*-----------------------------------------------------------------------
  swap_currency_leg2
  ----------------------------------------------------------------------*/
/*string instrument.swap_currency_leg2(error_info option(nullable) error) option(hidden)
{	
	try{
		instr_error_type t;
		string s;
		string c1,c2;
		i().__swap_currency( c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_currency_leg2");
		return e ? null<string>: c2;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_currency_leg2");
		return null<string >;
	}
}*/

/*-----------------------------------------------------------------------
  swap_index_tenor_leg1
  ----------------------------------------------------------------------*/
/*string instrument.swap_index_tenor_leg1(error_info option(nullable) error) option(hidden)
{	
	try{
		..ir_index ir = this.swap_ir_index_leg1(error) ;
		if(null(ir)) return null<string>;
		return ir.tenor();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_index_tenor_leg1");
		return null<string>;
	}
}*/

/*-----------------------------------------------------------------------
  swap_index_tenor_code_leg1
  ----------------------------------------------------------------------*/
/*tenor_code instrument.swap_index_tenor_code_leg1(error_info option(nullable) error) option(hidden)
{	
	try{
		..ir_index ir = this.swap_ir_index_leg1(error) ;
		if(null(ir)) return null<tenor_code>;
		return ir.tenor_code();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_index_tenor_code_leg1");
		return null<tenor_code>;
	}
}*/
/*-----------------------------------------------------------------------
  swap_index_tenor_code_leg2
  ----------------------------------------------------------------------*/
/*tenor_code instrument.swap_index_tenor_code_leg2(error_info option(nullable) error) option(hidden)
{	
	try{
		..ir_index ir = this.swap_ir_index_leg2(error) ;
		if(null(ir)) return null<tenor_code>;
		return ir.tenor_code();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_index_tenor_code_leg2");
		return null<tenor_code>;
	}
}*/

/*-----------------------------------------------------------------------
  swap_index_tenor_leg2
  ----------------------------------------------------------------------*/
/*string instrument.swap_index_tenor_leg2(error_info option(nullable) error) option(hidden)
{	
	try{
		..ir_index ir = this.swap_ir_index_leg2(error) ;
		if(null(ir)) return null<string>;
		return ir.tenor();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_index_tenor_leg2");
		return null<string>;
	}
}*/

/*n = 0;
	r = QL::arg_spec("number");
	a[n++]	    = QL::arg_nullable("date",	"fwd_trade_date");
	a[n++]	    = QL::arg_nullable("date",	"fwd_settle_date");
	a[n++]	    = QL::arg_out("number",	"carry_per_day");
	a[n++]	    = QL::arg_out("number",	"carry_leg1");
	a[n++]	    = QL::arg_out("number",	"carry_leg2");
	a[n++]  = QL::arg_out(mwlib_err_type_str,   "error_type");
	a[n++]  = QL::arg_out("string",		    "error");
	a[n++]  = QL::ctxt_arg();
	QL::add_mem_func(s, reinterpret_cast<QL::function_t*>(::instr_upfront_carry), mw_api::mw_bond::obj_type, "__swap_upfront_carry", r, n, a,0,true);*/



/*-----------------------------------------------------------------------
  swap_present_value

  ----------------------------------------------------------------------*/
/*number swap_gen.present_value(	disc_func option(nullable)  disc_func_leg1,
										disc_func option(nullable) 	disc_func_leg2,
										out number pv_leg1,
										out number pv_leg2,
										number option(nullable) 	notional,
										logical option(nullable) 	trade_date_pv,																								
										error_info option(nullable) error) option(hidden)
option(com_name: 'swap_present_value_df')
{	
	try{
		notional = conv_null_number_com(notional) ;
		instr_error_type t;
   		string 			s;			
		number c = i().__swap_present_value(disc_func_leg1,disc_func_leg2,pv_leg1,pv_leg2,notional,trade_date_pv,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_present_value");
		if(e){
			pv_leg1 = pv_leg2 = null<number>;
			return null<number>;
		}
		return c;						
	}
	catch {
		pv_leg1 = pv_leg2 = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_present_value");
		return null<number>;
	}
}

*/
/*-----------------------------------------------------------------------
  swap_present_value

  ----------------------------------------------------------------------*/
/*number swap_gen.present_value(	disc_func option(nullable)	disc_func_leg1,
										disc_func option(nullable) 	disc_func_leg2,
										out number pv_leg1,
										out number pv_leg2,
										date option(nullable) pv_date,
										date option(nullable) settle_date,
										logical  	incl_issue_cf,
										logical  	incl_mat_cf,	
										error_info option(nullable) error) option(hidden)
option(com_name: 'swap_present_value_df_alt')
{	
	try{
		pv_date = conv_null_date_com(pv_date) ;
		settle_date = conv_null_date_com(settle_date) ;
		instr_error_type t;
   		string 			s;
		number nom = null<number>;	
		number c = i().__swap_present_value(disc_func_leg1,disc_func_leg2,pv_leg1,pv_leg2,nom,pv_date,settle_date,incl_issue_cf,incl_mat_cf,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_present_value");
		if(e){
			pv_leg1 = pv_leg2 = null<number>;
			return null<number>;
		}
		return c;							
	}
	catch {
		pv_leg1 = pv_leg2 = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_present_value");
		return null<number>;
	}
}*/
/*-----------------------------------------------------------------------
  swap_present_value_fee

  ----------------------------------------------------------------------*/
/*number instrument.swap_present_value_fee(	disc_func option(nullable)	disc_func_leg1,
										disc_func option(nullable) 	disc_func_leg2,
										out number pv_leg1,
										out number pv_leg2,
										date option(nullable) pv_date,
										date option(nullable) settle_date,
										logical  	incl_issue_cf,
										logical  	incl_mat_cf,	
										error_info option(nullable) error) option(hidden)
option(com_name: 'swap_present_value_fee_df_alt')
{	
	try{
		pv_date = conv_null_date_com(pv_date) ;
		settle_date = conv_null_date_com(settle_date) ;
		instr_error_type t;
   		string 			s;
		number nom = null<number>;	
		number c = i().__swap_present_value_fee(disc_func_leg1,disc_func_leg2,pv_leg1,pv_leg2,nom,pv_date,settle_date,incl_issue_cf,incl_mat_cf,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_present_value_fee");
		if(e){
			pv_leg1 = pv_leg2 = null<number>;
			return null<number>;
		}
		return c;							
	}
	catch {
		pv_leg1 = pv_leg2 = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_present_value_fee");
		return null<number>;
	}
}*/
/*-----------------------------------------------------------------------
  swap_present_value

  ----------------------------------------------------------------------*/
/*number swap_gen.present_value(	out number pv_leg1,
										out number pv_leg2,
										logical option(nullable) 	trade_date_pv,
										error_info option(nullable) error) option(hidden)
option(com_name: 'swap_present_value')
{	
	try{	
		instr_error_type t;
   		string 			s;
		number nom = null<number>;
		disc_func df_null = null<disc_func>;	
		number c = i().__swap_present_value(df_null,df_null,pv_leg1,pv_leg2,nom,trade_date_pv,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_present_value");
		if(e){
			pv_leg1 = pv_leg2 = null<number>;
			return null<number>;
		}
		return c;					
	}
	catch {
		pv_leg1 = pv_leg2 = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_present_value");
		return null<number>;
	}
}
*/



/*-----------------------------------------------------------------------
  swap_disc_func_leg1
  ----------------------------------------------------------------------*/
/*disc_func instrument.swap_disc_func_leg1(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		disc_func c = i().__swap_disc_func_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_disc_func_leg1");
		return e ? null<disc_func>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_disc_func_leg1");
		return null<disc_func >;
	}
}*/

/*-----------------------------------------------------------------------
  swap_disc_func_leg2
  ----------------------------------------------------------------------*/
/*disc_func instrument.swap_disc_func_leg2(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		disc_func c = i().__swap_disc_func_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_disc_func_leg2");
		return e ? null<disc_func>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_disc_func_leg2");
		return null<disc_func >;
	}
}*/


/*-----------------------------------------------------------------------
  swap_tenor_surface_leg1
  ----------------------------------------------------------------------*/
/*tenor_surface instrument.swap_tenor_surface_leg1(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		tenor_surface c = i().__swap_surface_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_tenor_surface_leg1");
		return e ? null<tenor_surface>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_tenor_surface_leg1");
		return null<tenor_surface >;
	}
*/
/*-----------------------------------------------------------------------
  swap_tenor_surface_leg2
  ----------------------------------------------------------------------*/
/*tenor_surface instrument.swap_tenor_surface_leg2(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		tenor_surface c = i().__swap_surface_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_tenor_surface_leg2");
		return e ? null<tenor_surface>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_tenor_surface_leg2");
		return null<tenor_surface >;
	}
}*/



/*-----------------------------------------------------------------------
  swap_solver
  ----------------------------------------------------------------------*/
/*number instrument.swap_solver(	number 				pv,
								swap_solver_code 	solver_code,
								logical option(nullable) trade_date_pv,
								error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number  c = i().__swap_solver(pv, solver_code,trade_date_pv ,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_solver");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_solver");
		return null<number  >;
	}
}*/

/*-----------------------------------------------------------------------
  swap_instrument
  ----------------------------------------------------------------------*/
/*l_fixed_income_swap instrument.swap_instrument(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		ql_fixed_income_swap c = i().__swap_instrument(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_instrument");
		return e ? null<ql_fixed_income_swap>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_instrument");
		return null<ql_fixed_income_swap >;
	}
}*/

/*-----------------------------------------------------------------------
  swap_leg
  ----------------------------------------------------------------------*/
/*vector(ql_swap_leg) instrument.swap_leg(logical clone, error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(ql_swap_leg) c = i().__swap_leg(clone,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_leg");
		return e ? null<vector(ql_swap_leg) >: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_leg");
		return null<vector(ql_swap_leg) >;
	}
}
*/
/*-----------------------------------------------------------------------
  swap_float_leg
  ----------------------------------------------------------------------*/
/*vector(ql_float_leg) instrument.swap_float_leg(logical clone, error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(ql_float_leg) c = i().__swap_float_leg(clone,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_float_leg");
		return e ? null<vector(ql_float_leg) >: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_float_leg");
		return null<vector(ql_float_leg) >;
	}
}
*/
/*-----------------------------------------------------------------------
  swap_fix_leg
  ----------------------------------------------------------------------*/
/*vector(ql_fix_leg) instrument.swap_fix_leg(logical clone, error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(ql_fix_leg) c = i().__swap_fix_leg(clone,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_fix_leg");
		return e ? null<vector(ql_fix_leg) >: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_fix_leg");
		return null<vector(ql_fix_leg) >;
	}
}*/

/*-----------------------------------------------------------------------
  ql_fix_infl_ci_leg
  ----------------------------------------------------------------------*/
/*vector(ql_fix_infl_ci_leg) instrument.swap_fix_infl_ci_leg(logical clone, error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;		
		vector(ql_fix_infl_ci_leg) c = i().__swap_fix_infl_ci_leg(clone,t, s);
		
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.ql_fix_infl_ci_leg");
		return e ? null<vector(ql_fix_infl_ci_leg) >: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.ql_fix_infl_ci_leg");
		return null<vector(ql_fix_infl_ci_leg) >;
	}
}*/

/*-----------------------------------------------------------------------
  swap_ois_leg
  ----------------------------------------------------------------------*/
/*vector(ql_ois_leg) instrument.swap_ois_leg(logical clone, error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(ql_ois_leg) c = i().__swap_ois_leg(clone,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_ois_leg");
		return e ? null<vector(ql_ois_leg) >: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_ois_leg");
		return null<vector(ql_ois_leg) >;
	}
}*/

/*-----------------------------------------------------------------------
  swap_fix_zero_leg
  ----------------------------------------------------------------------*/
/*vector(ql_fix_zero_leg) instrument.swap_fix_zero_leg(logical clone, error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(ql_fix_zero_leg) c = i().__swap_fix_zero_leg(clone,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_fix_zero_leg");
		return e ? null<vector(ql_fix_zero_leg) >: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_fix_zero_leg");
		return null<vector(ql_fix_zero_leg) >;
	}
}*/

/*-----------------------------------------------------------------------
  ql_zero_infl_leg
  ----------------------------------------------------------------------*/
/*vector(ql_zero_infl_leg) instrument.swap_zero_infl_leg(logical clone, error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(ql_zero_infl_leg) c = i().__swap_zero_infl_leg(clone,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_zero_infl_leg");
		return e ? null<vector(ql_zero_infl_leg) >: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_zero_infl_leg");
		return null<vector(ql_zero_infl_leg) >;
	}
}*/
/*-----------------------------------------------------------------------
  ql_yy_infl_leg
  ----------------------------------------------------------------------*/
/*vector(ql_yy_infl_leg) instrument.swap_yy_infl_leg(logical clone, error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(ql_yy_infl_leg) c = i().__swap_yy_infl_leg(clone,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.swap_yy_infl_leg");
		return e ? null<vector(ql_yy_infl_leg) >: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.swap_yy_infl_leg");
		return null<vector(ql_yy_infl_leg) >;
	}
}*/


/*-----------------------------------------------------------------------
 -----------------------------------------------------------------------
  -----BONDFUT----------------------------------------------------------
  -----------------------------------------------------------------------
  -----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------
  bondfut error returns
  -------------------------------------------------------------*/
date instrument.bondfut_expiry_settle_date(error_info option(nullable) e) 		option(hidden){ return fin_instr.err_type(null<date>, e,"bondfut_expiry_settle_date");}
date instrument.bondfut_synt_maturity(error_info option(nullable) e)			option(hidden){ return fin_instr.err_type(null<date>, e,"bondfut_synt_maturity");}
bond_fut_style instrument.bondfut_style(error_info option(nullable) e)			option(hidden){ return fin_instr.err_type(null<bond_fut_style>, e,"bondfut_style");}
vector(string) 	instrument.bondfut_deliverables(error_info option(nullable) e)	option(hidden){ return fin_instr.err_type(null<vector(string)>, e,"bondfut_deliverables");}
vector(number) 	instrument.bondfut_price_factors(error_info option(nullable) e) option(hidden){ return fin_instr.err_type(null<vector(number)>, e,"bondfut_price_factors");}
/*-----------------------------------------------------------------------
  bondfut price_factors
  ----------------------------------------------------------------------*/
vector(number) 	instrument.price_factors() option(hidden)
option(com_name: 'LEGACY_price_factors')
{
	return bondfut_price_factors();
}
/*-----------------------------------------------------------------------
  bondfut deliverables
  ----------------------------------------------------------------------*/
vector(string) 	instrument.deliverables() option(hidden)
option(com_name: 'LEGACY_deliverables')
{
	return bondfut_deliverables();
}

/*-----------------------------------------------------------------------
 -----------------------------------------------------------------------
 ---on_future----------- 
  -----------------------------------------------------------------------
  -----------------------------------------------------------------------*/

logical instrument.on_future_in_fixing_period(error_info option(nullable) e) 	option(hidden)	{ return fin_instr.err_type(true, e,"onfuture_in_fixing_period");}

/*-----------------------------------------------------------------------
 -----------------------------------------------------------------------
 ---RIBA----------- 
  -----------------------------------------------------------------------
  -----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------
  riba error returns
  ----------------------------------------------------------------------*/
logical instrument.riba_is_fixed(error_info option(nullable) e) 			option(hidden)	{ return fin_instr.err_type(true, e,"riba_is_fixed");}
logical instrument.riba_in_fixing_period(error_info option(nullable) e) 	option(hidden)	{ return fin_instr.err_type(true, e,"riba_in_fixing_period");}

number instrument.riba_final_fix_rate(error_info option(nullable) e) 		option(hidden)	{ return fin_instr.err_type(1.0, e,"riba_final_fix_rate");}
date instrument.riba_fix_period_end_date(error_info option(nullable) e) 	option(hidden)	{ return fin_instr.err_type(null<date>, e, "riba_fix_period_end_date");}
date instrument.riba_final_settlement_date(error_info option(nullable)  e) 	option(hidden)	{ return fin_instr.err_type(null<date>, e, "riba_final_settlement_date");}
date instrument.riba_expiry_date(error_info option(nullable) e) 			option(hidden)	{ return fin_instr.err_type(null<date>, e, "riba_expiry_date");}
number instrument.riba_price(error_info option(nullable) e) 				option(hidden)	{ return fin_instr.err_type(1.0, e, "riba_price");}
number instrument.riba_implied_curve_rate(	number, error_info option(nullable) e) 				option(hidden) 	{ return fin_instr.err_type(1.0, e, "riba_implied_curve_rate");}
number instrument.riba_implied_rate(disc_func,error_info option(nullable) e)  					option(hidden)	{ return fin_instr.err_type(1.0, e, "riba_implied_rate");}
number instrument.riba_implied_rate_risk(	disc_func ,number ,error_info option(nullable) e) 	option(hidden)	{ return fin_instr.err_type(1.0, e, "riba_implied_rate_risk");}
number instrument.riba_settle_amount_df(disc_func ,number  option(nullable) ,number option(nullable) ,error_info option(nullable) e) option(hidden)	{ return fin_instr.err_type(1.0, e, "riba_settle_amount_df");}
number instrument.riba_pv_curve(number ,number ,disc_func,error_info option(nullable) e) 					option(hidden)	{ return fin_instr.err_type(1.0, e, "riba_pv_curve");}
number instrument.riba_pvbp(number  option(nullable),number option(nullable),error_info option(nullable) e)	option(hidden)	{ return fin_instr.err_type(1.0, e, "riba_pvbp");}
number instrument.riba_pvbp_df(	number,disc_func,number ,error_info option(nullable) e) 					option(hidden)	{ return fin_instr.err_type(1.0, e, "riba_pvbp_df");}
number instrument.riba_settle_amount(	number 	,number option(nullable),number option(nullable) ,error_info option(nullable) e) 	option(hidden)	{ return fin_instr.err_type(1.0, e, "riba_settle_amount");}
number instrument.riba_pvbp_implied(number ,number ,error_info option(nullable) e) 													option(hidden)	{ return fin_instr.err_type(1.0, e, "riba_pvbp_implied");}
void instrument.riba_repo_data(	disc_func,out vector(number),out vector(date),out vector(date) ,error_info option(nullable) e) 		option(hidden)	{ fin_instr.err_type(e, "riba_repo_data");}
/*-----------------------------------------------------------------------
  riba_pv  not virtual
  ----------------------------------------------------------------------*/
number instrument.riba_pv(	number m,
							number option(nullable) c,
							number option(nullable) n) 	option(hidden)
option(com_name: 'LEGACY_riba_pv')
{
	return riba_settle_amount(m,c,n);
}
/*-----------------------------------------------------------------------
  riba_pvbp_curve  virtual
  ----------------------------------------------------------------------*/
number instrument.riba_pvbp_curve(	number n,
									disc_func df,
									number r)	 option(hidden)
option(com_name: 'LEGACY_riba_pvbp_curve')
{
	return riba_pvbp_df(n,df,r);
}
/*-----------------------------------------------------------------------
  riba_repodata  not virtual   //backward compat, name change
  ----------------------------------------------------------------------*/
void  instrument.riba_repodata(disc_func df,
							   out vector(number) r,
							   out vector(date) s,
							   out vector(date) end )	option(hidden)
option(com_name: 'LEGACY_riba_repodata')
{
	riba_repo_data(df,r,s,end);
}
/*-----------------------------------------------------------------------
  riba_cash_flow_amounts_legacy  virtual
  ----------------------------------------------------------------------*/
vector(number) instrument.riba_cash_flow_amounts_legacy( error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_riba_cash_flow_amounts')
{
	try{
		instr_error_type t;
   		string 			s;	
		vector(number) c = i().__riba_cash_flow_amounts_legacy(100 ,t,s);		
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.riba_cash_flow_amounts_legacy");
		return e ? null<vector(number)>: c;				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.riba_cash_flow_amounts_legacy");
		return null<vector(number)>;
	}
}
/*-----------------------------------------------------------------------
  riba_cash_flow_dates_legacy  virtual
  ----------------------------------------------------------------------*/
vector(date) instrument.riba_cash_flow_dates_legacy( error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_riba_cash_flow_dates')
{	
	try{
		instr_error_type t;
   		string 			s;	
		vector(date) c = i().__riba_cash_flow_dates_legacy(t,s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.riba_cash_flow_dates_legacy");
		return e ? null<vector(date)>: c;				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.riba_cash_flow_dates_legacy");
		return null<vector(date)>;
	}
}

/*-----------------------------------------------------------------------
  riba_accrued_legacy  virtual
  ----------------------------------------------------------------------*/
number instrument.riba_accrued_legacy( error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_riba_accrued')
{	
	try{
		instr_error_type t;
   		string 			s;
		number	accr_s,accr_hist_s,accr_net_s,accr_period_s,accr_fix,accr_hist_fix,accr_net_fix,accr_period_fix;	
		i().__riba_accrued_legacy(true ,null<date>,accr_s,accr_hist_s,accr_net_s,accr_period_s,
								  accr_fix,accr_hist_fix,accr_net_fix,accr_period_fix,t,s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.riba_accrued_legacy");
		return e ? null<number>: accr_s;				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.riba_accrued_legacy");
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  riba_dirty_price_legacy  virtual
  ----------------------------------------------------------------------*/
number instrument.riba_dirty_price_legacy(number option(nullable) y,
										  error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_riba_dirty_price')
{	
	try{
		instr_error_type t;
   		string 			s;		
		number c = i().__riba_dirty_price_legacy(y,t,s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.riba_dirty_price_legacy");
		return e ? null<number>: c;			
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.riba_dirty_price_legacy");
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  riba_clean_price_legacy  virtual
  ----------------------------------------------------------------------*/
number instrument.riba_clean_price_legacy(number option(nullable) y ,
										  error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_riba_clean_price')
{	
	try{
		instr_error_type t;
   		string 			s;
		
		number c = i().__riba_clean_price_legacy(y,t,s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.riba_clean_price_legacy");
		return e ? null<number>: c;				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.riba_clean_price_legacy");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
 -----------------------------------------------------------------------
 ---FRN----------- 
  -----------------------------------------------------------------------
  -----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------
  frn error returns
  ----------------------------------------------------------------------*/
void 	instrument.frn_add_quote(number, number option(nullable), number)			option(hidden) option(com_name: 'LEGACY_frn_add_quote') { fin_instr.err_type(null<error_info>,"frn_add_quote");	}
number 	instrument.frn_fix_margin(error_info option(nullable) e)					option(hidden) { return fin_instr.err_type(1.0, e,"frn_fix_margin");}
number 	instrument.frn_assumed_index_rate(error_info option(nullable) e)			option(hidden) { return fin_instr.err_type(1.0, e,"frn_assumed_index_rate");}
number 	instrument.frn_disc_rate_next(error_info option(nullable) e)				option(hidden) { return fin_instr.err_type(1.0, e,"frn_disc_rate_next");}
number 	instrument.frn_disc_margin(error_info option(nullable) e)					option(hidden) { return fin_instr.err_type(1.0, e,"frn_disc_margin");}
number 	instrument.frn_disc_margin(	number,number option(nullable),number option(nullable) ,number option(nullable),error_info option(nullable) e)						option(hidden) { return fin_instr.err_type(1.0, e,"frn_disc_margin");}
number 	instrument.frn_accrued(	number option(nullable) ,error_info option(nullable) e)																					option(hidden) { return fin_instr.err_type(1.0, e,"frn_accrued");}
number 	instrument.frn_disc_margin_risk_bp(	number, number,number option(nullable),number option(nullable),number option(nullable) ,error_info option(nullable) e) 		option(hidden) { return fin_instr.err_type(1.0, e,"frn_disc_margin_risk_bp");}
void 	instrument.frn_curve_to_price(	disc_func ,disc_func ,number,out number,out number,	out number,out number,out number,logical ,	error_info option(nullable) e) 	option(hidden) { fin_instr.err_type(e,"frn_curve_to_price");}
void 	instrument.frn_curve_to_price(	fwd_func,disc_func,	number,	out number,out number,out number,out number,out number,logical,error_info option(nullable) e) 		option(hidden) { fin_instr.err_type(e,"frn_curve_to_price");}
void 	instrument.frn_coupon_data(out vector(date) ,out vector(date),out vector(number),out vector(number),logical,logical,error_info option(nullable) e) 				option(hidden) { fin_instr.err_type(e,"frn_coupon_data");}
vector(date) instrument.frn_fixing_dates(error_info option(nullable) e) 			option(hidden) { return fin_instr.err_type(null<vector(date)>, e,"frn_fixing_dates");}
logical instrument.frn_is_odd_first(error_info option(nullable)  e) 				option(hidden) { return fin_instr.err_type(null<logical>, e,"frn_is_odd_first");}
logical instrument.frn_is_odd_last(error_info option(nullable)  e) 					option(hidden) { return fin_instr.err_type(null<logical>, e,"frn_is_odd_last");}
number 	instrument.frn_rate_risk_bp(	number ,number ,number option(nullable) ,number option(nullable) ,number option(nullable) ,	error_info option(nullable) e) 		option(hidden) { return fin_instr.err_type(1.0, e,"frn_rate_risk_bp");}
number 	instrument.frn_dirty_from_disc_margin(number, number option(nullable),number option(nullable),number option(nullable),logical,error_info option(nullable) e) 	option(hidden) { return fin_instr.err_type(1.0, e,"frn_dirty_from_disc_margin");}
string 	instrument.frn_roll_method(error_info  option(nullable) e) 																										option(hidden) { return fin_instr.err_type(null<string>, e,"frn_roll_method");}
number 	instrument.frn_clean_from_disc_margin(number,number option(nullable),number option(nullable),number option(nullable),logical, error_info option(nullable) e) 	option(hidden) { return fin_instr.err_type(1.0, e,"frn_clean_from_disc_margin");}
vector(number) instrument.frn_cash_flows(	disc_func option(nullable),number option(nullable) ,number option(nullable),logical,logical,logical,logical, error_info  option(nullable) e) 		option(hidden) { return fin_instr.err_type(null<vector(number)>, e,"frn_cash_flows");}
vector(number) instrument.frn_cash_flows(	fwd_func option(nullable),number option(nullable) ,number option(nullable) ,logical ,logical ,logical ,logical ,error_info option(nullable) e) 		option(hidden) { return fin_instr.err_type(null<vector(number)>, e,"frn_cash_flows");}
vector(number) instrument.frn_cash_flows_cpn(disc_func option(nullable)	,number option(nullable) ,number option(nullable) ,logical ,logical ,logical ,logical  ,error_info option(nullable) e) 	option(hidden) { return fin_instr.err_type(null<vector(number)>, e,"frn_cash_flows_cpn");}
vector(number) instrument.frn_cash_flows_cpn(fwd_func option(nullable),number option(nullable) ,number option(nullable) ,logical ,logical ,logical ,logical ,error_info option(nullable) e) 	option(hidden) { return fin_instr.err_type(null<vector(number)>, e,"frn_cash_flows_cpn");}
..frn_neg_rate_rule instrument.frn_neg_rate_rule(error_info option(nullable) e) 																												option(hidden) { return fin_instr.err_type(null<..frn_neg_rate_rule>, e,"frn_neg_rate_rule");}

/*-----------------------------------------------------------------------
  frn 
  ----------------------------------------------------------------------*/
number instrument.disc_margin(number c,
							  number next,
							  number ass,
							  number option(nullable) next_i) option(hidden)
option(com_name: 'LEGACY_disc_margin')
{
	return this.frn_disc_margin(c,next,ass,next_i);
}
/*-----------------------------------------------------------------------
  frn 
  ----------------------------------------------------------------------*/
number instrument.fix_margin()  option(hidden)
option(com_name: 'LEGACY_fix_margin')
{
	return frn_fix_margin();
}
/*-----------------------------------------------------------------------
  frn 
  ----------------------------------------------------------------------*/
number instrument.accrued_frn(	number option(nullable) i) option(hidden)
option(com_name: 'LEGACY_accrued_frn')
{
	return frn_accrued(i);
}
/*-----------------------------------------------------------------------
  frn 
  ----------------------------------------------------------------------*/
number instrument.disc_margin_risk_bp(	number delta_disc_margin,
										number clean_price,
										number option(nullable) next_disc_rate,
										number option(nullable) assumed_index,
										number option(nullable) next_index_rate)
option(hidden)
option(com_name: 'LEGACY_disc_margin_risk_bp')
{
	return frn_disc_margin_risk_bp(delta_disc_margin,clean_price,next_disc_rate,assumed_index,next_index_rate);
}
/*-----------------------------------------------------------------------
  frn 
  ----------------------------------------------------------------------*/
number instrument.rate_risk_bp(	number delta_rate,
								number clean_price,
								number option(nullable) next_disc_rate,
								number option(nullable) assumed_index,
								number option(nullable) next_index_rate)
option(hidden)
option(com_name: 'LEGACY_rate_risk_bp')
{
	return frn_rate_risk_bp(delta_rate,clean_price,next_disc_rate,assumed_index,next_index_rate);
}

/*-----------------------------------------------------------------------
  frn 
  ----------------------------------------------------------------------*/
number instrument.dirty_from_disc_margin(	number disc_margin,
											number option(nullable) next_disc_rate,
											number option(nullable) assumed_index,
											number option(nullable) next_index_rate,
											logical disable_rounding )
option(hidden)
option(com_name: 'LEGACY_dirty_from_disc_margin')
{
	return frn_dirty_from_disc_margin(disc_margin,next_disc_rate,assumed_index,next_index_rate,disable_rounding);
}
/*-----------------------------------------------------------------------
  frn 
  ----------------------------------------------------------------------*/
number instrument.clean_from_disc_margin(	number disc_margin,
											number option(nullable) next_disc_rate,
											number option(nullable) assumed_index,
											number option(nullable) next_index_rate,
											logical disable_rounding )
option(hidden)
option(com_name: 'LEGACY_clean_from_disc_margin')
{
	return frn_clean_from_disc_margin(disc_margin,next_disc_rate,assumed_index,next_index_rate,disable_rounding);
}

/*-----------------------------------------------------------------------
  frn 
  ----------------------------------------------------------------------*/
string instrument.roll_method() option(hidden)
option(com_name: 'LEGACY_roll_method')
{
	return frn_roll_method();
}


/*-----------------------------------------------------------------------
  frn 
  ----------------------------------------------------------------------*/
vector(number) instrument.cash_flow_amounts_frn(disc_func	disc_func,
												logical 	incl_floor  )option(hidden)
option(com_name: 'LEGACY_cash_flow_amounts_frn')
{
	return frn_cash_flows(disc_func,0,100,true,true,incl_floor, false);
}

/*-----------------------------------------------------------------------
  frn  frn_neg_rate_style
  ----------------------------------------------------------------------*/
..frn_neg_rate_rule instrument.frn_neg_rate_style(error_info option(nullable) e) option(hidden)
{
	return frn_neg_rate_rule(e);
}
	


//***----------INSTRUMENT INDIRECT CREATORS-----------***
/*
if there is an error:
all set functions returns a null instrument if it is not a valid instrument
*/

/*-----------------------------------------------------------------------
  set_date LEGACY
	OLD QUOTE IS NOT KEPT even if trade_date is unchanged i.e. the quote is re-initialized
  external swap: set_date is the same as move_date since we cannot re-initialize quotes or dates
  ----------------------------------------------------------------------*/
instrument instrument.set_date(	date  trade_date, 
								logical re_init_static, 
								error_info option(nullable) error) option(hidden) option(com_name: 'LEGACY_set_date') { return this.err_type(null<instrument>, error, "set_date");}

instrument instrument._set_date(date  				trade_date, 
								logical 			re_init_static, 
								error_info option(nullable) error)
{	
	try{
		instr_error e 	= instr_error();
		__instrument ci = i();	
		CORE_INT.instr_fail_check(null(ci), "invalid instrument (null)", this, e);
		logical v = ci.is_valid(e);
		CORE_INT.instr_fail_check(!v, "invalid instrument", this, e);
		
		logical re_init_quote 	= true;
		__instrument c 			= ci.__set_date(trade_date, null<date>,re_init_static,re_init_quote );
		//states of c:  1) valid, not null, 2) not valid, not null, 3) not valid, null			
		instrument cc 			= create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid instrument", this, e);
		
		if(!cc.is_valid(error)) 
			return null<instrument>;		
		
		return cc ; 						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument._set_date");
		return null<instrument>;
	}	
}

/*-----------------------------------------------------------------------
  set_date
  ----------------------------------------------------------------------*/
instrument instrument.set_date(	date  				trade_date, 
								date  option(nullable)	settle_date,
								logical 			re_init_static, 
								logical 			init_quote,
								error_info option(nullable) error) option(hidden) { return this.err_type(null<instrument>, error, "set_date");}

instrument instrument._set_date(date  				trade_date, 
								date  option(nullable)	settle_date,
								logical 			re_init_static, 
								logical 			init_quote,
								error_info option(nullable) error)
{	
	try{
		instr_error e 	= instr_error();
		__instrument ci = i();	
		//CORE_INT.instr_fail_check(null(ci) || !ci.is_valid(e), "invalid instrument", this, e);
		CORE_INT.instr_fail_check(null(ci), "invalid instrument (null)", this, e);
		logical v = ci.is_valid(e);
		CORE_INT.instr_fail_check(!v, "invalid instrument", this, e);
		
		__instrument c 	= ci.__set_date(trade_date, settle_date, re_init_static,init_quote );
		instrument cc 	= create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid instrument", this, e);
		
		if(!cc.is_valid(error))
			return null<instrument>;		
		return cc ; 						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument._set_date");
		return null<instrument>;
	}
}

/*-----------------------------------------------------------------------
  move_date LEGACY
  	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	--> OLD QUOTE IS KEPT
	if trade date is the same --> the settle date will be preserved
	external swap: set_date is the same as move_date
  ----------------------------------------------------------------------*/
instrument instrument.move_date(	date  trade_date, 
									date option(nullable) settle_date,
									error_info option(nullable) error) 
option(hidden)
option(com_name: 'LEGACY_move_date')
{ return this.err_type(null<instrument>, error, "move_date");}

instrument instrument._move_date(	date  				trade_date, 
									date option(nullable) settle_date,
									error_info option(nullable) error)
{	
	try{
		instr_error e 	= instr_error();
		__instrument ci = i();	
		//CORE_INT.instr_fail_check(null(ci) || !ci.is_valid(e), "invalid instrument", this, e);
		CORE_INT.instr_fail_check(null(ci), "invalid instrument (null)", this, e);
		logical v = ci.is_valid(e);
		CORE_INT.instr_fail_check(!v, "invalid instrument", this, e);
		
		__instrument c 	= ci.__move_date(trade_date, settle_date);

		instrument cc 	= create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid instrument", this, e);
		
		if(!cc.is_valid(error))
			return null<instrument>;
		
		return cc ; 					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument._move_date");
		return null<instrument>;
	}
}
	
/*-----------------------------------------------------------------------
  set_clean_price
  ----------------------------------------------------------------------*/
instrument instrument.set_clean_price(	number 	option(nullable) clean_pct,
										date  	option(nullable) trade_date, 
										date  	option(nullable) settle_date, 
										error_info option(nullable) error) option(hidden){ return this.err_type(null<instrument>, error,"set_clean_price");}

instrument instrument._set_clean_price(	number 	option(nullable) clean_pct,
										date  	option(nullable) trade_date, 
										date  	option(nullable) settle_date, 
										error_info option(nullable) error) 
{	
	try{
		instr_error e 	= instr_error();
		__instrument ci = i();	
		//CORE_INT.instr_fail_check(null(ci) || !ci.is_valid(e), "invalid instrument", this, e);

		CORE_INT.instr_fail_check(null(ci), "invalid instrument (null)", this, e);
		logical v = ci.is_valid(e);
		CORE_INT.instr_fail_check(!v, "invalid instrument", this, e);
		
		__instrument  c = ci.__set_clean_price(clean_pct, trade_date, settle_date );
		instrument cc 	= create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid instrument", this, e);
		
		if(!cc.is_valid(error))
			return null<instrument>;
		return cc ;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument._set_clean_price");
		return null<instrument>;
	}
}

/*-----------------------------------------------------------------------
  set_dirty_price
  ----------------------------------------------------------------------*/
instrument instrument.set_dirty_price(	number 	option(nullable) dirty_pct,
										date  	option(nullable) trade_date, 
										date  	option(nullable) settle_date, 
										error_info option(nullable) error) 	option(hidden){ return this.err_type(null<instrument>, error,"set_dirty_price");}

instrument instrument._set_dirty_price(	number 	option(nullable) dirty_pct,
										date  	option(nullable) trade_date, 
										date  	option(nullable) settle_date, 
										error_info option(nullable) error)
{	
	try{
		instr_error e 	= instr_error();
		__instrument ci = i();	
		//CORE_INT.instr_fail_check(null(ci) || !ci.is_valid(e), "invalid instrument", this, e);

		CORE_INT.instr_fail_check(null(ci), "invalid instrument (null)", this, e);
		logical v = ci.is_valid(e);
		CORE_INT.instr_fail_check(!v, "invalid instrument", this, e);
		
		__instrument  c = ci.__set_dirty_price(dirty_pct, trade_date, settle_date );
		instrument cc 	= create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid instrument", this, e);
		
		if(!cc.is_valid(error))
			return null<instrument>;
		return cc ;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument._set_dirty_price");
		return null<instrument>;
	}
}

/*-----------------------------------------------------------------------
  set_yield
  ----------------------------------------------------------------------*/
instrument instrument.set_yield(	number 	option(nullable) yield,									
									error_info option(nullable) error) 	 { return this.err_type(null<instrument>, error,"set_yield");}

instrument instrument._set_yield(	number 	option(nullable) yield,
									date  	option(nullable) trade_date, 
									date  	option(nullable) settle_date, 
									logical option(nullable) set_coupon_to_yield,
									error_info option(nullable) error)
{	
	try{
		instr_error e 	= instr_error();
		__instrument ci = i();	
		//CORE_INT.instr_fail_check(null(ci) || !ci.is_valid(e), "invalid instrument", this, e);

		CORE_INT.instr_fail_check(null(ci), "invalid instrument (null)", this, e);
		logical v = ci.is_valid(e);
		CORE_INT.instr_fail_check(!v, "invalid instrument", this, e);
		
		__instrument  c = ci.__set_yield(yield, trade_date, settle_date, set_coupon_to_yield );
		instrument cc 	= create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid instrument", this, e);
		
		if(!cc.is_valid(error))
			return null<instrument>;
		return cc ;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument._set_yield");
		return null<instrument>;
	}
}
/*-----------------------------------------------------------------------
  set_settle_date
  ----------------------------------------------------------------------*/
instrument instrument.set_settle_date(	date settle_date , 
										logical re_initialize, 
										error_info option(nullable) error) option(hidden){ return this.err_type(null<instrument>, error,"set_settle_date");}

instrument instrument._set_settle_date(	date  				settle_date, 
										logical 			re_initialize, 
										error_info option(nullable) error)
{	

	try{
		instr_error e 	= instr_error();
		__instrument ci = i();	
		//CORE_INT.instr_fail_check(null(ci) || !ci.is_valid(e), "invalid instrument", this, e);

		CORE_INT.instr_fail_check(null(ci), "invalid instrument (null)", this, e);
		logical v = ci.is_valid(e);
		CORE_INT.instr_fail_check(!v, "invalid instrument", this, e);
		
		__instrument  c = ci.__set_settle_date(settle_date, re_initialize );
		instrument cc 	= create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid instrument", this, e);
		
		if(!cc.is_valid(error))
			return null<instrument>;
		return cc ;				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument._set_settle_date");
		return null<instrument>;
	}
}
/*-----------------------------------------------------------------------
  _set_quote_from_yield   EXT SWAP: throws
  ----------------------------------------------------------------------*/
instrument instrument._set_quote_from_yield(	number 	option(nullable) yield,
												logical option(nullable) set_coupon_to_yield,
												error_info option(nullable) error)
{	
	try{
		QL_FAIL_COND(is_ext_swap(),"inapplicable function call for non-db swaps", this,true);
		
		instr_error e 	= instr_error();
		__instrument ci = i();	
		//CORE_INT.instr_fail_check(null(ci) || !ci.is_valid(e), "invalid instrument", this, e);

		CORE_INT.instr_fail_check(null(ci), "invalid instrument (null)", this, e);
		logical v = ci.is_valid(e);
		CORE_INT.instr_fail_check(!v, "invalid instrument", this, e);
		
		__instrument  c = ci.__set_quote_from_yield(yield, set_coupon_to_yield );
		instrument cc 	= create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid instrument", this, e);
		
		if(!cc.is_valid(error))
			return null<instrument>;
		return cc ;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument._set_quote_from_yield");
		return null<instrument>;
	}
}

/*-----------------------------------------------------------------------
  set_quote_from_yield 
  ----------------------------------------------------------------------*/
instrument instrument.set_quote_from_yield(	number 	option(nullable) yield,
											error_info option(nullable) error) option(hidden)
{
	return _set_quote_from_yield(yield,null<logical>, error);
}

/*-----------------------------------------------------------------------
  set_quote 
  ----------------------------------------------------------------------*/
instrument instrument.set_quote(number 	option(nullable) quote,
								error_info option(nullable) error) 
{
	return _set_quote(quote,null<date>, null<date>,null<logical>, error);
}

/*-----------------------------------------------------------------------
  _set_quote 
	set_coupon_to_quote is applicable for 	IT_FIX_FLT_SWAP,		IT_ZERO_FLT_SWAP,	IT_FIX_OIS_SWAP:	
    										IT_FRA 					IT_MMFUT 			IT_MMFUT_FF:
    										IT_RIBA 				IT_DEPO:			IT_NOIS:			
    										IT_REAL_FIX_FLT_SWAP 	IT_INFL_ZERO_SWAP 	IT_INFL_FIX_YY_SWAP:

	and quote_style must be yield, bp or edfut
  ----------------------------------------------------------------------*/
instrument instrument._set_quote(number option(nullable) quote,
								date  	option(nullable) trade_date, 
								date  	option(nullable) settle_date, 
								logical option(nullable) set_coupon_to_quote,
								error_info option(nullable) error)
{	
	try{
		instr_error e 	= instr_error();
		__instrument ci = i();	
		//CORE_INT.instr_fail_check(null(ci) || !ci.is_valid(e), "invalid instrument", this, e);

		CORE_INT.instr_fail_check(null(ci), "invalid instrument (null)", this, e);
		logical v = ci.is_valid(e);
		CORE_INT.instr_fail_check(!v, "invalid instrument", this, e);
		
		__instrument  c;	
		if(this.is_ext_swap())
			c = ci.__swap_ext_set_quote(quote, trade_date, settle_date);					
		else 
			c = ci.__set_quote(quote, trade_date, settle_date, set_coupon_to_quote);
		
		instrument cc = create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid instrument", this, e);
		
		if(!cc.is_valid(error))
			return null<instrument>;
		
		return cc ;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument._set_quote");
		return null<instrument>;
	}
}

/*-----------------------------------------------------------------------
  set_quote 
  ----------------------------------------------------------------------*/
instrument instrument.set_quote(string 	option(nullable) quote_side,
								error_info option(nullable) error)
option(com_name: 'set_quote_qs')
{
	return _set_quote(quote_side,null<date>, null<date>,null<logical>, error);
}

/*-----------------------------------------------------------------------
  _set_quote		EXT SWAP: will throw because of quote_side
  ----------------------------------------------------------------------*/
instrument instrument._set_quote(	string 	option(nullable) quote_side,
									date  	option(nullable) trade_date, 
									date  	option(nullable) settle_date, 
									logical option(nullable) set_coupon_to_quote,
									error_info option(nullable) error)
{	
	try{
		instr_error e 	= instr_error();
		__instrument ci = i();	
		//CORE_INT.instr_fail_check(null(ci) || !ci.is_valid(e), "invalid instrument", this, e);

		CORE_INT.instr_fail_check(null(ci), "invalid instrument (null)", this, e);
		logical v = ci.is_valid(e);
		CORE_INT.instr_fail_check(!v, "invalid instrument", this, e);
		
		__instrument  c = ci.__set_quote(quote_side, trade_date, settle_date, set_coupon_to_quote);
		instrument cc = create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid instrument", this, e);
		
		if(!cc.is_valid(error))
			return null<instrument>;
		return cc ;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument._set_quote");
		return null<instrument>;
	}
}

//***----------INSTRUMENT MEMBERS-----------***


/*-----------------------------------------------------------------------
  Name :  	instrument.label_date, instrument.label_number() 
  Notes :           
  Changes:
  			Date    		Who     Detail
  			3-Oct-2016 		MN		moved from instrument.ql   
			23-Apr-2018		MN		moved to i_instrument_class    
  ----------------------------------------------------------------------*/
label_date instrument.label_date()
{
	//try {
		if(this.instr_type() == ..instr_type.FX_SPOT || this.instr_type() == ..instr_type.EQUITY)
			return label(this.settle_date(), this.name());
		else
    		return label(this.maturity(), this.name());
	//}
	//catch {
	//	return null<label_date> ;
	//}
}

label_number instrument.label_number()
{
	//try {
		if(this.instr_type() == ..instr_type.FX_SPOT || this.instr_type() == ..instr_type.EQUITY)
			return label((this.settle_date() - this.trade_date()) / 365.0, this.name());
		else
    		return label((this.maturity() - this.trade_date()) / 365.0, this.name());
	//}
	//catch {
	//	return null<label_number> ;
	//}
}

/*-----------------------------------------------------------------------
  Name :  	instrument.get_tag_num
  Notes :           
  Changes:
  			Date    		Who     Detail
  			6-Dec-2013 		MN      Original code (moved from fiws)  
			2-Apr-2014 		MN      removed instrument i 
			23-Apr-2018		MN		moved to i_instrument_class
  ----------------------------------------------------------------------*/
number instrument.get_tag_num(	string 	tag,
								error_info option(nullable) error ) option(hidden)
option(com_name: 'get_tag_num')
//should be option(com_name: 'LEGACY_get_tag_num')
{
	try{
		CORE_INT.reset_single(error);

		error_info e = new error_info(true,false);
		
		date d = null;
		try{			
			d = trade_date(e);
		}
		catch {}
		
		if(null(d))
			d = today();
		
		number r = ..get_instr_tag_num(tag, name(e),d);
		if(!null(r))
			return r;

		r = ..get_instr_tag_num(tag, class_name(e),d);
		if(!null(r))
			return r;
		
		
		QL_FAIL(strcat(["undefined tag [",tag,",",name(e),"]"]));			

	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.get_tag_num");
		return null<number>;
	}
}
number instrument.tag_num(	string 	tag,
							error_info option(nullable) error )
{	
	return this.get_tag_num(tag, error);
}
/*-----------------------------------------------------------------------
  Name :  	instrument.get_tag_str
  Notes :           
  Changes:
  			Date    		Who     Detail
  			6-Dec-2013 		MN      Original code (moved from fiws) 
			2-Apr-2014 		MN      removed instrument i  
			23-Apr-2018		MN		moved to i_instrument_class
  ----------------------------------------------------------------------*/
string instrument.get_tag_str(	string 	tag,
								error_info option(nullable) error ) option(hidden)
option(com_name: 'get_tag_str')
//should be option(com_name: 'LEGACY_get_tag_str')
{
	try{
		CORE_INT.reset_single(error);

		error_info e = new error_info(true,false);
		
		date d = null;
		try{
			d = trade_date(e);
		}
		catch {}
		
		if(null(d))
			d = today();
		
		string r = ..get_instr_tag_str(tag, name(e),d);
		if(!null(r)) return r;

		r = ..get_instr_tag_str(tag, class_name(e),d);
		if(!null(r)) return r;
						
		QL_FAIL(strcat(["undefined tag [",tag,",",name(e),"]"]));				
				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.get_tag_str");
		return null<string>;
	}
}
string instrument.tag_str(	string 	tag,
							error_info option(nullable) error )
{	
	return this.get_tag_str(tag, error);
}
/*-----------------------------------------------------------------------
  Name :  	instrument.get_tag_date
  Notes :           
  Changes:
  			Date    		Who     Detail
  			14-Oct-2016		MN
			23-Apr-2018		MN		moved to i_instrument_class
  ----------------------------------------------------------------------*/
date instrument.get_tag_date(	string 	tag,
								error_info option(nullable) error ) option(hidden)
option(com_name: 'get_tag_date')
//should be option(com_name: 'LEGACY_get_tag_date')
{
	try{
		CORE_INT.reset_single(error);

		error_info e = new error_info(true,false);
		
		date d = null;
		try{
			d = trade_date(e);
		}
		catch {}
		
		if(null(d))
			d = today();
		
		date r = ..get_instr_tag_date(tag, name(e),d);
		if(!null(r)) return r;

		r = ..get_instr_tag_date(tag, class_name(e),d);
		if(!null(r)) return r;
						
		QL_FAIL(strcat(["undefined tag [",tag,",",name(e),"]"]));				
				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.get_tag_date");
		return null<date>;
	}
}
date instrument.tag_date(	string 	tag,
							error_info option(nullable) error )
{	
	return this.get_tag_date(tag, error);
}
/*-----------------------------------------------------------------------
  Name :  	instrument.pmt_bus_day
  Notes :           
  Changes:
  			Date    		Who     Detail
  			6-Dec-2013 		MN      Original code (moved from fiws) 
			2-Apr-2014 		MN      removed instrument i  
			23-Apr-2018		MN		moved to i_instrument_class
  ----------------------------------------------------------------------*/
bd_convention instrument.pmt_bus_day_d(	bd_convention option(nullable)	dflt,
										error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_pmt_bus_day_d')
{
	try{
		CORE_INT.reset_single(error);
		
		error_info ee = error_info();
		bd_convention b = pmt_bus_day(ee);
		if(!null(b)) return b;

		if(null(dflt))
			QL_FAIL(strcat(["invalid pmt_bus_day [null and no default provided,",name(),"]"]));		
		
		return dflt;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.pmt_bus_day_d");	
		return null<bd_convention>;
	}
}

/*-----------------------------------------------------------------------
  Name :  	instrument.eom
  Notes :           
  Changes:
  			Date    		Who     Detail
  			6-Dec-2013 		MN      Original code (moved from fiws)  
			2-Apr-2014 		MN      removed instrument i 
			23-Apr-2018		MN		moved to i_instrument_class
  ----------------------------------------------------------------------*/
logical instrument.eom_d(logical	option(nullable) 	dflt,
						error_info option(nullable) error  ) option(hidden)
option(com_name: 'LEGACY_eom_d')
{
	try{
		CORE_INT.reset_single(error);
		
		error_info ee = error_info();
		logical e = eom(ee);
		if(!null(e)) return e;

		if(null(dflt))
			QL_FAIL(strcat(["invalid eom [null and no default provided,",name(),"]"]));		
		
		return dflt;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.eom_d");
		return null<logical>;
	}
}

/*-----------------------------------------------------------------------
  Name :  	instrument.flt_value_days
  Notes :           
  Changes:
  			Date    		Who     Detail
  ----------------------------------------------------------------------*/
number instrument.flt_value_days(	error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_flt_value_days')
{
	try{
		instr_error_type t;
   		string 			s;
		integer c = i().__flt_value_days(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.flt_value_days");
		if(e)
			return null<number>;

		if(c == err_int())
			QL_FAIL(strcat(["invalid flt_value_days [",str(c),"," ,name(),"]"]), E_CALC);		

		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.flt_value_days");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  Name :  	instrument.flt_reset_days
  Notes :           
  Changes:
  			Date    		Who     Detail
  			6-Dec-2013 		MN      Original code (moved from fiws) 
			2-Apr-2014 		MN      removed instrument i  
			1-Aug-2016		MN		changed return type to number (from integer) to allow for null result
  ----------------------------------------------------------------------*/
number instrument.flt_reset_days(	error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_flt_reset_days')
{
	try{
		instr_error_type t;
   		string 			s;
		integer c = i().__flt_reset_days(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.flt_reset_days");
		if(e)
			return null<number>;

		if(c == err_int())
			QL_FAIL(strcat(["invalid flt_reset_days [",str(c),"," ,name(),"]"]), E_CALC);		

		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.flt_reset_days");
		return null<number>;
	}
}

number instrument.flt_reset_days_d(number option(nullable) dflt ,
									error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_flt_reset_days_d')
{
	try{
		instr_error_type t;
   		string 			s;
		integer c = i().__flt_reset_days(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.flt_reset_days_d");
		if(!e && c != err_int())
			return c;
		if(!null(dflt ) && (dflt < -1 || dflt > 2))  
			QL_FAIL(strcat(["invalid default for flt_reset_days [",name(),"]"]));			
		
		return dflt;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.flt_reset_days_d");
		return dflt;
	}
}
/*-----------------------------------------------------------------------
  Name :  	instrument.flt_coupon_freq  <backward compat purpose>
  Notes :
	[IT_MMFUT, IT_FRA,										    	--> underlying index tenor
	IT_FIX_FLT_SWAP, IT_ZERO_FLT_SWAP, IT_REAL_FIX_FLT_SWAP,		--> for 2nd leg pmt freq
	IT_FLT_FLT_2_SWAP]										    	--> for 1st flt leg pmt freq         
  Changes:
  			Date    		Who     Detail
  			6-Dec-2013 		MN      Original code (moved from fiws)  
			2-Apr-2014 		MN      removed instrument i 

  ----------------------------------------------------------------------*/
number instrument.flt_coupon_freq(	error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_flt_coupon_freq')
{
	try{
		instr_error_type t;
   		string 			s;
		integer c = i().__flt_coupon_freq(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.flt_coupon_freq");	
		if(e)
			return null<number>;

		if(c!= 1 && c!= 2 && c!= 4 && c!= 12 && c!= 365)
			QL_FAIL(strcat(["invalid flt_coupon_freq [null","," ,name(),"]"]), E_CALC);
			
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.flt_coupon_freq");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  Name :  	instrument.flt_coupon_freq_flat  <backward compat purpose>
  Notes : 
	[IT_FLT_FLT_SWAP,IT_FLT_FLT_2_SWAP]		--> for 2nd flt leg pmt freq         
  Changes:
  			Date    		Who     Detail
  			6-Dec-2013 		MN      Original code (moved from fiws)  
			2-Apr-2014 		MN      removed instrument i 
  ----------------------------------------------------------------------*/
number instrument.flt_coupon_freq_flat(error_info option(nullable) error) option(hidden)
option(com_name: 'LEGACY_flt_coupon_freq_flat')
{
	try{
		instr_error_type t;
   		string 			s;
		integer c = i().__flt_coupon_freq_flat(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.flt_coupon_freq_flat");	
		if(e)
			return null<number>;

		if(c!= 1 && c!= 2 && c!= 4 && c!= 12 && c!= 365)
			QL_FAIL(strcat(["invalid flt_coupon_freq_flat [null","," ,name(),"]"]), E_CALC);
			
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.flt_coupon_freq_flat");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  Name :  	instrument.flt_daycount_method  <backward compat purpose>
  Notes :
	[IT_MMFUT, IT_FRA,										    	--> underlying dc
	IT_FIX_FLT_SWAP, IT_ZERO_FLT_SWAP, IT_REAL_FIX_FLT_SWAP,		--> for 2nd leg pmt dc
	IT_FLT_FLT_2_SWAP]										    	--> for 1st flt leg pmt dc        
  Changes:
  			Date    		Who     Detail
  			6-Dec-2013 		MN      Original code (moved from fiws)  
			2-Apr-2014 		MN      removed instrument i 

  ----------------------------------------------------------------------*/
day_count_method instrument.flt_daycount_method(error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_flt_daycount_method')
{
	try{
		instr_error_type t;
   		string 			s;
		day_count_method c = i().__flt_daycount_method(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.flt_daycount_method");	
		if(e)
			c = null<day_count_method>;

		if(null(c))
			QL_FAIL(strcat(["invalid flt_daycount_method [null","," ,name(),"]"]), E_CALC);
		
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.flt_daycount_method");
		return null<day_count_method>;
	}
}

/*-----------------------------------------------------------------------
  Name :  	instrument.flt_daycount_method_flat  <backward compat purpose>
  Notes : 
	[IT_FLT_FLT_SWAP,IT_FLT_FLT_2_SWAP]		--> for 2nd flt leg pmt dc         
  Changes:
  			Date    		Who     Detail
  			6-Dec-2013 		MN      Original code (moved from fiws)  
			2-Apr-2014 		MN      removed instrument i 
  ----------------------------------------------------------------------*/
day_count_method instrument.flt_daycount_method_flat(error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_flt_daycount_method_flat')
{
	try{
		instr_error_type t;
   		string 			s;
		day_count_method c = i().__flt_daycount_method_flat(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.flt_daycount_method_flat");	
		if(e)
			c = null<day_count_method>;

		if(null(c))
			QL_FAIL(strcat(["invalid flt_daycount_method_flat [null","," ,name(),"]"]), E_CALC);
		
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.flt_daycount_method_flat");
		return null<day_count_method>;
	}
}

/*-----------------------------------------------------------------------
  Name :  	instrument.flt_currency  <backward compat purpose>
  Notes :
	[IT_MMFUT, IT_FRA,										    	--> underlying curr
	IT_FIX_FLT_SWAP, IT_ZERO_FLT_SWAP, IT_REAL_FIX_FLT_SWAP,		--> for 2nd leg pmt curr
	IT_FLT_FLT_2_SWAP]										    	--> for 1st flt leg pmt curr
  Changes:
  			Date    		Who     Detail
  			6-Dec-2013 		MN      Original code (moved from fiws)  
			2-Apr-2014 		MN      removed instrument i 

  ----------------------------------------------------------------------*/
string instrument.flt_currency(	error_info option(nullable) error) option(hidden)
option(com_name: 'LEGACY_flt_currency')
{
	try{
		instr_error_type t;
   		string 			s;
		string c = i().__flt_currency(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.flt_currency");	
		if(e)
			c = null<string>;

		if(null(c))
			QL_FAIL(strcat(["invalid flt_currency [null","," ,name(),"]"]), E_CALC);
					
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.flt_currency");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  Name :  	instrument.flt_currency_flat  <backward compat purpose>
  Notes : 
	[IT_FLT_FLT_SWAP,IT_FLT_FLT_2_SWAP]		--> for 2nd flt leg pmt curr
  Changes:
  			Date    		Who     Detail
  			6-Dec-2013 		MN      Original code (moved from fiws)  
			2-Apr-2014 		MN      removed instrument i 
  ----------------------------------------------------------------------*/
string instrument.flt_currency_flat(error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_flt_currency_flat')
{
	try{
		instr_error_type t;
   		string 			s;
		string c = i().__flt_currency_flat(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.flt_currency_flat");	
		if(e)
			c = null<string>;

		if(null(c))
			QL_FAIL(strcat(["invalid flt_currency_flat [null","," ,name(),"]"]), E_CALC);
							
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.flt_currency_flat");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  Name :  	instrument.ccbs_is_mtm 
  Notes :           
  Changes:
  			Date    		Who     Detail
  			9-Apr-2015 		MN      
  ----------------------------------------------------------------------*/
logical instrument.ccbs_is_mtm(error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_ccbs_is_mtm')
{
	try{
		instr_error_type t;
   		string 			s;
		logical c = i().__ccbs_is_mtm(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.ccbs_is_mtm");	
		if(e)
			c = null<logical>;

		if(null(c))
			QL_FAIL(strcat(["invalid ccbs_is_mtm [null","," ,name(),"]"]), E_CALC);
				
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.ccbs_is_mtm");
		return null<logical>;
	}
}

/*-----------------------------------------------------------------------
  Name :  	instrument.ccbs_is_mtm_leg1 
  Notes :           
  Changes:
  			Date    		Who     Detail
  			9-Apr-2015 		MN      
  ----------------------------------------------------------------------*/
logical instrument.ccbs_is_mtm_leg1(error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_ccbs_is_mtm')
{
	try{
		instr_error_type t;
   		string 			s;
		logical c = i().__ccbs_is_mtm_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.ccbs_is_mtm_leg1");	
		if(e)
			c = null<logical>;

		if(null(c))
			QL_FAIL(strcat(["invalid ccbs_is_mtm_leg1 [null","," ,name(),"]"]), E_CALC);
				
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.ccbs_is_mtm_leg1");
		return null<logical>;
	}
}
/*-----------------------------------------------------------------------
  Name :  	instrument.ccbs_is_mtm_leg2 
  Notes :           
  Changes:
  			Date    		Who     Detail
  			9-Apr-2015 		MN      
  ----------------------------------------------------------------------*/
logical instrument.ccbs_is_mtm_leg2(error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_ccbs_is_mtm')
{
	try{
		instr_error_type t;
   		string 			s;
		logical c = i().__ccbs_is_mtm_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.ccbs_is_mtm_leg2");	
		if(e)
			c = null<logical>;

		if(null(c))
			QL_FAIL(strcat(["invalid ccbs_is_mtm_leg2 [null","," ,name(),"]"]), E_CALC);
				
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.ccbs_is_mtm_leg2");
		return null<logical>;
	}
}
/*-----------------------------------------------------------------------
  Name :  	instrument.irs_class_name_flat 
  Notes :    flt-flt and flt-flt2       
  Changes:
  			Date    		Who     Detail
  			6-Dec-2013 		MN      Original code (moved from fiws) 
			2-Apr-2014 		MN      removed instrument i 
  ----------------------------------------------------------------------*/
string instrument.irs_class_name_flat(error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_irs_class_name_flat')
{
	try{
		instr_error_type t;
   		string 			s;
		string c = i().__irs_class_name_flat(t, s);	
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.irs_class_name_flat");	
		if(e)
			c = null<string>;

		if(null(c))
			QL_FAIL(strcat(["invalid irs_class_name_flat [null","," ,name(),"]"]), E_CALC);
				
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.irs_class_name_flat");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  Name :  	instrument.irs_class_name_base 
  Notes :   flt-flt and flt-flt2        
  Changes:
  			Date    		Who     Detail
  			6-Dec-2013 		MN      Original code (moved from fiws) 
			2-Apr-2014 		MN      removed instrument i  			
  ----------------------------------------------------------------------*/
string instrument.irs_class_name_base(error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_irs_class_name_base')
{
	try{
		instr_error_type t;
   		string 			s;
		string c = i().__irs_class_name_sprd(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "instrument.irs_class_name_base");	
		if(e)
			c = null<string>;

		if(null(c))
			QL_FAIL(strcat(["invalid irs_class_name_base [null","," ,name(),"]"]), E_CALC);
							
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.irs_class_name_base");
		return null<string>;
	}
}
string instrument.irs_class_name_sprd(error_info option(nullable) error ) option(hidden)
option(com_name: 'LEGACY_irs_class_name_base')
{
	return irs_class_name_base(error);
}



