option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	bill
	--------------------------------------------------------------------
*/


//-----------------------------------------------------------------------
//  class bill
//----------------------------------------------------------------------
class bill: public instrument
option(category: "Instrument/Bill")
//option(allow_undeclared_mfuncs)
{
public:
	bill(__instrument);	
	override bill  			clone();
	override instrument 	inst();
	bill(bill);
	
/*	--------------------------------
	---OVERRIDES (HIDDEN IN ROOT) --- 
	--------------------------------
		- implemented in root for backward compat reasons
*/
	//-----add-funcs-----					
	override void 			add_nominal(number );											
	void 					add_quote(number );				/*set cpn to quote removed --> local*/
	void 					add_quote_from_yield(number );	/*set cpn to quote removed --> local*/
	
	//-----general-----
	override logical 		eom(error_info option(nullable) error = null<error_info>);	
	override string 		maturity_code(error_info option(nullable) error = null<error_info> );
	override bd_convention 	pmt_bus_day(error_info option(nullable) error = null<error_info>);
	override day_count_method dc_method(error_info option(nullable) error = null<error_info>);
	override day_count_method accr_dc_method(error_info option(nullable) error = null<error_info> );
	override date 			next_cpn_date(error_info option(nullable) error = null<error_info>  );
	override date 			first_cpn_date(error_info option(nullable) error = null<error_info> );
	override date 			first_settle_date(error_info option(nullable) error = null<error_info>);
	override number 		first_cpn_amount(error_info option(nullable) error = null<error_info>);
	override number 		next_cpn_amount(error_info option(nullable) error = null<error_info>);	
	override date 			cpn_start_date(error_info option(nullable) error = null<error_info>);		
	override  number 		redemp_price(error_info option(nullable) error = null<error_info>);		
	override  string 		excpn_code(error_info option(nullable) error = null<error_info>);			
	override date 			next_excpn_date(error_info option(nullable) error = null<error_info>);		
	override  number 		issued_amount(error_info option(nullable) error = null<error_info>);	
	//-----risk-----
		//not necessary since they are now publicly available in the root

	//-----price-----
	override number 		accrued_chg(integer,out number,out date ,out date ,		
										logical in_pcnt = true ,error_info option(nullable) error = null<error_info> ) ; 
	override number 		accrued_period(error_info option(nullable) error = null<error_info>);
	override integer		accrued_days(error_info option(nullable) error= null<error_info>);
	//-----fwd price  (/*cpn_reinv removed --> locals*/)-----
	void 					funding(date ,number  ,day_count_method ,rate_type option(nullable) ,disc_func option(nullable) ,	number option(nullable) ,
									out number	,out number	, out number ,out number, out number	,
									error_info option(nullable) error = null<error_info>) ;											/*root impl.*/

	number  				clean_price_fwd(date ,number ,day_count_method,rate_type option(nullable) ,
											disc_func option(nullable) , error_info option(nullable) error = null<error_info>) ;	/*root impl.*/

	number  				dirty_price_fwd(date ,number ,day_count_method,rate_type option(nullable) ,
											disc_func option(nullable) , error_info option(nullable) error = null<error_info>) ;	/*root impl.*/

	number  				yield_fwd(	date ,number ,day_count_method,rate_type option(nullable) ,
										disc_func option(nullable) , error_info option(nullable) error = null<error_info>) ;		/*root impl.*/

	number  				horizon_return(	date ,number ,..quote_style	option(nullable), day_count_method,rate_type option(nullable) ,
											disc_func option(nullable) , error_info option(nullable) error = null<error_info>) ;	/*root impl.*/

	override void  			roll_down(	date,disc_func option(nullable) ,day_count_method,
										rate_type option(nullable), logical option(nullable), out number,out number , out number ,out number ,
										out date,error_info option(nullable) error = null<error_info>) ; 									/*root impl.*/

	void  					imp_fwd(instrument ,number option(nullable),number option(nullable),day_count_method,rate_type  ,disc_func,
									number option(nullable),number option(nullable), out number,out number,out number,out number,
									out number,  error_info option(nullable) error = null<error_info>) ;

	/*
		convexity_cf, pl_intraday
	*/

/*	--------------------------------
	---OVERRIDES (PUBLIC i.e. NOT HIDDEN IN ROOT) --- 
	--------------------------------
		-implemented in root
		-required
*/
	override bill 		set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);
	override bill 		set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);
	override bill 		set_quote_from_yield(number option(nullable) ,
											 error_info option(nullable) error = null<error_info> );					/*legacy, hidden in root*/
/*	--------------------------------
	---OVERRIDES (HIDDEN IN ROOT, THROWS IN ROOT) --- 
	--------------------------------
		-implemented in root with "-" prefix
		-here if applicable
*/

	override bill 		set_date(date,
								 date option(nullable) settle_date = null<date>,
								 logical re_init_static = true,
								 logical init_quote = true ,
								 error_info option(nullable) error = null<error_info>);
	
	override bill 		set_settle_date(date ,
										logical re_initialize = false,
										error_info option(nullable) error = null<error_info>);
	
	override bill 		set_clean_price(number option(nullable),
										date option(nullable) trade_date  = null<date>,
										date option(nullable) settle_date = null<date> ,
										error_info option(nullable) error = null<error_info>);

	override bill 		set_dirty_price(number option(nullable),
										date option(nullable) trade_date  = null<date>,
										date option(nullable) settle_date = null<date> ,
										error_info option(nullable) error = null<error_info> );
	
	override bill 		set_yield(number option(nullable) ,
								  error_info option(nullable) error = null<error_info>);
	
/*	--------------------------------
	---LOCALS (NOT EXPOSED IN ROOT) 
	--------------------------------
		-implemented in root with "-" prefix
		-here if applicable
*/
	bill 	set_quote(number option(nullable),date  option(nullable) ,
						date option(nullable) settle_date = null<date>,
						error_info option(nullable) error = null<error_info>);
	bill 	set_quote(string option(nullable),date  option(nullable) ,
						date option(nullable) settle_date = null<date>,
						error_info option(nullable) error = null<error_info>);
	
	bill 	set_yield(number option(nullable) ,
					  date option(nullable) ,
					  date  option(nullable) settle_date = null<date>,
					  error_info option(nullable) error = null<error_info>);
	
	
protected:

	bill 				err_type(bill option(nullable), error_info option(nullable),string option(nullable) f = null<string>);

	override bill 		create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);  
	override void 		add_quote(number,logical option(nullable) ); 
	override void 		add_quote_from_yield(number, logical option(nullable) );

	override bill 		set_date(	date,logical ,error_info option(nullable) error = null<error_info>);		/*legacy*/
	override bill 		move_date(	date,date option(nullable) settle_date = null<date>,
									error_info option(nullable) error = null<error_info>);						/*legacy*/

	override integer 	coupon_freq(error_info option(nullable) error = null<error_info> );
};

//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
bill.bill(__instrument i) option(hidden): instrument(i){}

//------------------------------------------------
// copy constructor
//------------------------------------------------
bill.bill(bill c) : instrument(c) {}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
bill bill(bill b)		{ return new bill(b);}
//------------------------------------------------
// clone
//------------------------------------------------
bill bill.clone()		{ return new bill(this);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	bill.inst()		{ return this;}
//------------------------------------------------
// create  [PROTECTED]
// create deposit from internal instrument
//------------------------------------------------
bill bill.create(	__instrument option(nullable) c,
					out instr_error option(nullable) error,
					error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<bill>; 

	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.BILL, "invalid instrument type",type );//should not happen
	
	
	return new bill(c);
}
/*-----------------------------------------------------------------------
  create_bill
  ----------------------------------------------------------------------*/
bill create_bill(	__instrument option(nullable) c,
					out instr_error option(nullable) error,
					error_type type = E_INIT)
option(com_name: 'INTERNAL_create_bill')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if(!valid && INSTR_CREATE_NULL_ERR)
		return null<bill>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.BILL, "invalid instrument type",type );//should not happen
	
	
	return new bill(c);
}

bill create_bill(	__instrument option(nullable) 		c,
					error_info option(nullable) 		error,
					error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_bill_ei')
{
	instr_error ee 	= instr_error();
	bill b 	= create_bill(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_bill");
	return b;
}

//-----------------------------------------------
// dynamic cast <FUNCTION>
//-----------------------------------------------
bill bill(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Bill')
option(com_name: 'bill_dyncast')
{ 
	try {
		bill d = dynamic_cast<bill>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a bill)","bill" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bill");
		return null<bill>;
	}
}
/*-----------------------------------------------------------------------
  err_type
  ----------------------------------------------------------------------*/

bill bill.err_type(bill option(nullable) nul, error_info option(nullable) error,string option(nullable) f )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,na_func_msg(null<string>), f);
	return null<bill>;
}
/*-----------------------------------------------------------------------
  bill: add_nominal (n/ a for equity, handled in dll)
  ----------------------------------------------------------------------*/
void bill.add_nominal(number nominal) 
{			
	instrument.add_nominal(nominal );
	return ;						
}

/*-----------------------------------------------------------------------
  bill: add_quote
  ----------------------------------------------------------------------*/
void bill.add_quote(number  quote ) 
{	
	instrument.add_quote(quote, false);
	return ;					
	
}
void bill.add_quote(number  quote, logical option(nullable) set_coupon_to_quote ) 
{	
	if(null(set_coupon_to_quote)) set_coupon_to_quote = false;
	QL_FAIL_COND(set_coupon_to_quote, "invalid argument: set coupon to quote not applicable for bill", name(), true);
	instrument.add_quote(quote, false);
	return ;						
}

/*-----------------------------------------------------------------------
  bill: add_quote_from_yield
  ----------------------------------------------------------------------*/
void bill.add_quote_from_yield(number  yield ) 
{	
	instrument.add_quote_from_yield(yield , false);
	return ;					
	
}

void bill.add_quote_from_yield(number  yield, logical option(nullable) set_coupon_to_yield ) 
{	
	if(null(set_coupon_to_yield))
		set_coupon_to_yield = false;
	QL_FAIL_COND(set_coupon_to_yield, "invalid argument: set coupon to yield not applicable for bill", name(), true);
	instrument.add_quote_from_yield(yield, false);
	return ;						
}

logical bill.eom(error_info option(nullable) error)					{ return instrument.eom(error);}
string 	bill.maturity_code(error_info option(nullable) error)		{ return instrument.maturity_code(error);}
date  	bill.next_cpn_date(error_info option(nullable) error) 		{ return instrument.next_cpn_date(error);}
date  	bill.first_cpn_date(error_info option(nullable) error)		{ return instrument.first_cpn_date(error);}
date  	bill.first_settle_date(error_info option(nullable) error)	{ return instrument.first_settle_date(error);}
bd_convention bill.pmt_bus_day(error_info option(nullable) error) 	{ return instrument.pmt_bus_day(error);}
//number  bill.face_amount(error_info option(nullable) error)			{ return instrument.face_amount(error);}
number  bill.accrued_period(error_info option(nullable) error)	{ return instrument.accrued_period(error);}
integer	bill.accrued_days(error_info option(nullable) error)			{ return instrument.accrued_days(error);}
day_count_method bill.dc_method(error_info option(nullable) error) 		{ return instrument.next_dc_method(error);}
day_count_method bill.accr_dc_method(error_info option(nullable) error) { return instrument.accr_dc_method(error);}
number bill.redemp_price(error_info option(nullable) error)				{ return instrument.redemp_price(error);}
number bill.issued_amount(error_info option(nullable) error)			{ return instrument.issued_amount(error);}
number  bill.first_cpn_amount(error_info option(nullable) error) 		{ return instrument.first_cpn_amount(error);}
number  bill.next_cpn_amount(error_info option(nullable) error) 		{ return instrument.next_cpn_amount(error);}
string bill.excpn_code(error_info option(nullable) error) 				{ return instrument.excpn_code(error);}
date bill.next_excpn_date(error_info option(nullable) error) 			{ return instrument.next_excpn_date(error);}
date bill.cpn_start_date(error_info option(nullable) error)				{ return instrument.cpn_start_date(error);}
integer bill.coupon_freq(error_info option(nullable) error)				{ return instrument.coupon_freq(error);}

/*-----------------------------------------------------------------------
  accrued_chg
  ----------------------------------------------------------------------*/
number  bill.accrued_chg(	integer 					bus_days_fwd,
							out	number option(nullable)	cpn_cashflow,
							out date 	settle,
							out date 	settle_next,	
							logical 					in_pcnt,								
							error_info option(nullable) error) 
{	
	return instrument.accrued_chg(bus_days_fwd,	cpn_cashflow,settle,settle_next,in_pcnt,error);
}

/*-----------------------------------------------------------------------
  bill: funding

  ----------------------------------------------------------------------*/
void bill.funding(	date 						fwd_settle_date,
					number  					repo_rate,								
					day_count_method 			day_count_method,
					rate_type option(nullable) 	rate_type,
					disc_func option(nullable) 	disc_func,
					number option(nullable) 	nominal,
					out number	dirty_price_fwd,
					out number	cf_fund_cost,
					out number cf_net_fund_cost,
					out number	cf_accr,
					out number	cf_coc,																
					error_info option(nullable) error) 
{	
	number cpn_reinv_rate;
	cpn_reinv_type 	crt = cpn_reinv_type.FIXED;
	number cf_cpn, cf_cpn_reinv;
	instrument.funding(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,rate_type,disc_func,crt,nominal,							
				dirty_price_fwd,cf_fund_cost,cf_net_fund_cost,cf_accr,cf_coc,cf_cpn,cf_cpn_reinv,error);
	return;
}

/*-----------------------------------------------------------------------
  clean_price_fwd

  ----------------------------------------------------------------------*/
number bill.clean_price_fwd(	date 						fwd_settle_date,
								number  					repo_rate,								
								day_count_method 			day_count_method,
								rate_type option(nullable) 	rate_type,
								disc_func option(nullable) 	disc_func,																
								error_info option(nullable) error)
{	
	number cpn_reinv_rate;
	cpn_reinv_type 	crt = cpn_reinv_type.FIXED;
	return instrument.clean_price_fwd(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,
							rate_type,disc_func,crt,error);
}

/*-----------------------------------------------------------------------
   dirty_price_fwd

  ----------------------------------------------------------------------*/
number bill.dirty_price_fwd(	date 						fwd_settle_date,
								number  					repo_rate,								
								day_count_method 			day_count_method,
								rate_type option(nullable) 	rate_type,
								disc_func option(nullable) 	disc_func,																
								error_info option(nullable) error)
{	
	number cpn_reinv_rate;
	cpn_reinv_type 	crt= cpn_reinv_type.FIXED;
	return instrument.dirty_price_fwd(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,
							rate_type,disc_func,crt,error);
}

/*-----------------------------------------------------------------------
  yield_fwd

  ----------------------------------------------------------------------*/
number bill.yield_fwd(date 						fwd_settle_date,
						number  					repo_rate,						
						day_count_method 			day_count_method,
						rate_type option(nullable) 	rate_type,
						disc_func option(nullable) 	disc_func,														
						error_info option(nullable) error)
{	
	number cpn_reinv_rate;
	cpn_reinv_type 	crt= cpn_reinv_type.FIXED;
	return instrument.yield_fwd(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,
							rate_type,disc_func,crt,error);
}

/*-----------------------------------------------------------------------
  horizon_return

  ----------------------------------------------------------------------*/
number bill.horizon_return(	date 						fwd_settle_date,
							number  					quote,
							..quote_style	option(nullable) quote_style,								
							day_count_method 			day_count_method,
							rate_type option(nullable) 	rate_type,
							disc_func option(nullable) 	disc_func,																
							error_info option(nullable) error)
{	
	number cpn_reinv_rate;
	cpn_reinv_type 	crt= cpn_reinv_type.FIXED;
	return instrument.horizon_return(fwd_settle_date,quote,quote_style,cpn_reinv_rate,day_count_method,
							rate_type,disc_func,crt,error);
}

/*-----------------------------------------------------------------------
  roll_down

  ----------------------------------------------------------------------*/
void bill.roll_down(	date 						fwd_settle_date,							
						disc_func option(nullable) 	disc_func,
						day_count_method 			day_count_method,
						rate_type option(nullable) 	rate_type,
						logical option(nullable) 	realized_fwd,
						out number fwd_yield,
						out number sprd_vs_crv,
						out number roll_sprd,
						out number roll_return,
						out date fwd_trade_date,
						error_info option(nullable) error)
{	
	instrument.roll_down(fwd_settle_date,disc_func,day_count_method,rate_type,realized_fwd,
					 fwd_yield,sprd_vs_crv,roll_sprd,roll_return,fwd_trade_date,error);
}

/*-----------------------------------------------------------------------
  bill: set_date
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
bill bill.set_date(	date  				trade_date, 
					date  option(nullable)	settle_date,
					logical 			re_init_static, 
					logical 			re_init_quote, 
					error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,settle_date,re_init_static,re_init_quote,error);
	return null(cc) ? null<bill>: dynamic_cast<bill>(cc);
	
}

/*-----------------------------------------------------------------------
  set_date  <protected/legacy>
	quote is NOT kept even if trade_date is unchanged
  ----------------------------------------------------------------------*/
bill bill.set_date(	date  				trade_date, 
					logical 			re_initialize, 
					error_info option(nullable) error) 
{	
	instrument cc = instrument._set_date(trade_date,re_initialize,error);
	return null(cc) ? null<bill>: dynamic_cast<bill>(cc);	
}
/*-----------------------------------------------------------------------
  move_date <protected/legacy>
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	if trade date is the same --> the settle date will be preserved	
  ----------------------------------------------------------------------*/
bill bill.move_date(date  				trade_date, 
					date option(nullable) settle_date,
					error_info option(nullable) error) 
{	
	instrument cc = instrument._move_date(trade_date,settle_date,error);
	return null(cc) ? null<bill>: dynamic_cast<bill>(cc);
}

/*-----------------------------------------------------------------------
  bill: set_quote 
  ----------------------------------------------------------------------*/
bill bill.set_quote(	number 	option(nullable) quote,
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, false,error);
	return null(cc) ? null<bill>: dynamic_cast<bill>(cc);
}
/*-----------------------------------------------------------------------
  bill: set_quote 
  ----------------------------------------------------------------------*/
bill bill.set_quote(	string 	option(nullable) quote_side,
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, false,error);
	return null(cc) ? null<bill>: dynamic_cast<bill>(cc);
}
/*-----------------------------------------------------------------------
  bill: set_quote 
  ----------------------------------------------------------------------*/
bill bill.set_quote(	number 	option(nullable) quote,
						date  	option(nullable) trade_date, 
						date  	option(nullable) settle_date, 
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,trade_date, settle_date, false,error);
	return null(cc) ? null<bill>: dynamic_cast<bill>(cc);
}

/*-----------------------------------------------------------------------
  bill: set_quote
  ----------------------------------------------------------------------*/
bill bill.set_quote(	string 	option(nullable) quote_side,
						date  	option(nullable) trade_date, 
						date  	option(nullable) settle_date, 
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,trade_date, settle_date, false,error);
	return null(cc) ? null<bill>: dynamic_cast<bill>(cc);
}
/*-----------------------------------------------------------------------
  bill: set_clean_price
  ----------------------------------------------------------------------*/
bill bill.set_clean_price(	number 	option(nullable) clean_pct,
							date  	option(nullable) trade_date, 
							date  	option(nullable) settle_date, 
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_clean_price(	clean_pct,trade_date, settle_date,error);
	return null(cc) ? null<bill>: dynamic_cast<bill>(cc);
}

/*-----------------------------------------------------------------------
  bill: set_dirty_price
  ----------------------------------------------------------------------*/
bill bill.set_dirty_price(	number 	option(nullable) dirty_pct,
							date  	option(nullable) trade_date, 
							date  	option(nullable) settle_date, 
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_dirty_price(	dirty_pct,trade_date, settle_date,error);
	return null(cc) ? null<bill>: dynamic_cast<bill>(cc);
}

/*-----------------------------------------------------------------------
  bill: set_yield
  ----------------------------------------------------------------------*/
bill bill.set_yield(	number 	option(nullable) yield,						
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_yield(	yield, null<date>, null<date>,false, error);
	return null(cc) ? null<bill>: dynamic_cast<bill>(cc);
}

/*-----------------------------------------------------------------------
  bill: set_yield
  ----------------------------------------------------------------------*/
bill bill.set_yield(	number 	option(nullable) yield,
						date  	option(nullable) trade_date, 
						date  	option(nullable) settle_date, 					
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_yield(	yield, trade_date, settle_date,false, error);
	return null(cc) ? null<bill>: dynamic_cast<bill>(cc);
}

/*-----------------------------------------------------------------------
  bill: set_settle_date
  ----------------------------------------------------------------------*/
bill bill.set_settle_date(	date  				settle_date, 
							logical 			re_initialize, 
							error_info option(nullable) error)
{	
	
	instrument cc = instrument._set_settle_date(	settle_date, re_initialize, error);
	return null(cc) ? null<bill>: dynamic_cast<bill>(cc);
}

/*-----------------------------------------------------------------------
  bill: set_quote_from_yield
  ----------------------------------------------------------------------*/
bill bill.set_quote_from_yield(	number 	option(nullable) yield,
								error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote_from_yield(yield,  false,error);
	return null(cc) ? null<bill>: dynamic_cast<bill>(cc);
}



/*-----------------------------------------------------------------------
  imp_fwd

  ----------------------------------------------------------------------*/
void bill.imp_fwd(	instrument 				instr_long,
					number	option(nullable)	nominal_short,
					number	option(nullable)	nominal_long,
					day_count_method	day_count_method,
					rate_type 			rate_type,
					disc_func 			reinv_disc_func,
					number option(nullable) reinv_sprd_long,
					number option(nullable) take_out_sprd,					
					out number cf_short,
					out number	cf_cpn_long,
					out number cf_cpn_reinv_long,
					out number cf_long,
					out number imp_rate,
					error_info option(nullable) error)
{	
	
	try{
		if(null(nominal_short) && null(nominal_long)) {			
			nominal_short = 100;
			error_info ee 	= new error_info(true,true);
			number dps = this.dirty_price(null<number>,false,true,ee);
			number dpl = instr_long.dirty_price(null<number>,false,true,ee);
			nominal_long = dps/dpl*nominal_short;
		}
		else if(null(nominal_short)) {
			error_info ee 	= new error_info(true,true);
			number dps = this.dirty_price(null<number>,false,true,ee);
			number dpl = instr_long.dirty_price(null<number>,false,true,ee);
			nominal_short = dpl/dps*nominal_long;
		}
		else if(null(nominal_long)) {
			error_info ee 	= new error_info(true,true);
			number dps = this.dirty_price(null<number>,false,true,ee);
			number dpl = instr_long.dirty_price(null<number>,false,true,ee);
			nominal_long = dps/dpl*nominal_short;
		}
		
		instr_error_type t;
   		string 			s;
		number cf_cpn_short,cf_cpn_reinv_short;
		i().__imp_fwd(	instr_long.i(), nominal_short,nominal_long, day_count_method,rate_type,reinv_disc_func,0,
						reinv_sprd_long,take_out_sprd,cf_cpn_short,cf_cpn_reinv_short,cf_short,cf_cpn_long,cf_cpn_reinv_long,cf_long,imp_rate,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bill.imp_fwd");
		if(e){ 
			cf_short = cf_long = imp_rate = null<number>;		
		}		
		return ;						
	}
	catch {
		cf_short = cf_long = imp_rate = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bill.imp_fwd");
		return ;
	}
}
