option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	bill future
	--------------------------------------------------------------------
*/



//-----------------------------------------------------------------------
//  class bill_future
//----------------------------------------------------------------------
class bill_future: public instrument
option(category: "Instrument/Bill Future")
//option(allow_undeclared_mfuncs)
{
public:

	//override string	instr_type_s();
	override instrument 	inst();
	
/*	--------------------------------
	---OVERRIDES (HIDDEN IN ROOT) + LOCALS--- 
	--------------------------------
		- overrides are implemented in root for backward compat reasons
*/
	//-----add-funcs-----			
	override void 			add_nominal(number );
	void 					add_quote(number );				/*set cpn to quote removed --> local*/
	void 					add_quote_from_yield(number );	/*set cpn to quote removed --> local*/
	
	
	//-----general-----		
	override string 		maturity_code(error_info option(nullable) error = null<error_info> );
	override day_count_method dc_method(error_info option(nullable) error = null<error_info> );
	//override  number 		redemp_price(error_info option(nullable) error = null<error_info> );		
	override calendar 		fixing_calendar(error_info option(nullable) error = null<error_info>);		
	override string 		fixing_calendar_name(error_info option(nullable) error = null<error_info> );
	override string 		fixing_code(error_info option(nullable) error = null<error_info>);	
	
	logical 				is_daily_mtm(error_info option(nullable) error = null<error_info> );		/*impl. in root with "fut_" prefix*/
	number 					tick_value(number,error_info option(nullable) error = null<error_info>);	/*impl. in root with "fut_" prefix*/
	number 					tick_size(error_info option(nullable) error = null<error_info> );			/*impl. in root with "fut_" prefix*/
	number 					contract_size(error_info option(nullable) error = null<error_info> );		/*impl. in root with "fut_" prefix*/
	
	//number 					contract_yield(error_info option(nullable) error = null<error_info>);		/*coupon in root*/	
	date 					last_trade_date(error_info option(nullable) error = null<error_info> );		/*local impl.*/
	date 					expiry_settle_date(error_info option(nullable) error = null<error_info> );	/*first_settle in root*/	
	
	//-----cashflow-funcs (post_settle and keep_size not relevant for futures)-----
	vector(date) 			cash_flow_dates(logical ,
											error_info option(nullable) error = null<error_info> );
	vector(number) 			cash_flows(number option(nullable),
									   error_info option(nullable) error = null<error_info> );
	void  					cash_flow_data(	number option(nullable),
											ir_cf_code,
											logical,
											out vector(date)   option(nullable),
											out vector(number)  	,
											error_info option(nullable) error = null<error_info>);	
	
/*	--------------------------------
	---OVERRIDES (PUBLIC i.e. NOT HIDDEN IN ROOT) --- 
	--------------------------------
		-implemented in root
		-required
*/
	override bill_future 	set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);
	override bill_future 	set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);
	override bill_future 	set_quote_from_yield(number option(nullable) ,
												error_info option(nullable) error = null<error_info>);			/*legacy, hidden, hidden in root*/

/*	--------------------------------
	---OVERRIDES (HIDDEN IN ROOT, THROWS IN ROOT) --- 
	--------------------------------
		-implemented in root with "-" prefix
		-here if applicable
*/

	
/*	--------------------------------
	---LOCALS (NOT EXPOSED IN ROOT) 
	--------------------------------
		-implemented in root with "-" prefix
		-here if applicable
*/
	bill_future 			set_quote(number option(nullable),
									  date  option(nullable) ,
									  error_info option(nullable) error = null<error_info>);
	bill_future 			set_quote(string option(nullable),
									  date  option(nullable) ,
									  error_info option(nullable) error = null<error_info>);
	
	bill_future 			set_yield(number option(nullable) ,date option(nullable) ,
									  error_info option(nullable) error = null<error_info>);
	
	
	
	bill_future 			set_date(date,logical,logical ,error_info option(nullable) error = null<error_info>);									
	
	
	bill_future(__instrument);
	override bill_future clone();
	bill_future(bill_future);
protected:
	override void 				add_quote(number,logical option(nullable) );
	override void 				add_quote_from_yield(number,logical option(nullable) );
	
	override number 			face_amount(error_info option(nullable) error = null<error_info>);
	override integer 			coupon_freq(error_info option(nullable) error = null<error_info> );
	
	override bill_future 		set_yield(number option(nullable) ,error_info option(nullable) error = null<error_info>);
	
	override bill_future 		set_date(date,
										 date option(nullable) settle_date =null<date> ,
										 logical re_init_static = true,
										 logical init_quote = true ,
										 error_info option(nullable) error = null<error_info>);
	
	override bill_future 		set_date(date,logical ,
										 error_info option(nullable) error = null<error_info>);							/*legacy*/

	
	override bill_future 		move_date(	date,
											date option(nullable) settle_date =null<date>,
											error_info option(nullable) error = null<error_info>);						/*legacy*/

	override vector(date)		cash_flow_dates(logical ,logical, logical,
												error_info option(nullable) error = null<error_info>);
	override vector(number)		cash_flows_cpn(number option(nullable),logical ,logical,
											   error_info option(nullable) error = null<error_info>);
	override vector(number)		cash_flows(number option(nullable),logical ,logical,
										   error_info option(nullable) error = null<error_info>);	
	
	override void 				cash_flow_data(	number option(nullable) ,logical ,ir_cf_code ,logical,logical ,
												out vector(date)   ,
												out vector(number)   ,
												error_info option(nullable) error = null<error_info>);

	override date 				settle_date(error_info option(nullable) error = null<error_info> );
	
	
	override bill_future 	create(__instrument option(nullable),out instr_error option(nullable),
								   error_type type = E_INVALID_ARG);    
};

//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
bill_future.bill_future(__instrument i) option(hidden): instrument(i){}
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string bill_future.instr_type_s()  		{ return string(..instr_type.BILL_FUTURE);}

//------------------------------------------------
// inst
//------------------------------------------------
instrument 	bill_future.inst()		{ return this;}
//------------------------------------------------
// copy constructor
//------------------------------------------------
bill_future.bill_future(bill_future c) : instrument(c) {}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
bill_future bill_future(bill_future bf)			{ return new bill_future(bf);}
//------------------------------------------------
// clone
//------------------------------------------------
bill_future bill_future.clone()				{ return new bill_future(this);}
//-----------------------------------------------
// dynamic cast <FUNCTION>
//-----------------------------------------------
bill_future 	bill_future(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Bill Future')
option(com_name: 'bill_future_dyncast')
{ 
	try {
		bill_future d = dynamic_cast<bill_future>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a bill_future)","bill_future" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bill_future");
		return null<bill_future>;
	}
}
//------------------------------------------------
// create  [PROTECTED]
// create bill_future from internal instrument
//------------------------------------------------
bill_future bill_future.create(	__instrument option(nullable) c,
								out instr_error option(nullable) error,
								error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<bill_future>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.BILL_FUTURE, "invalid instrument type",type );//should not happen
	
	
	return new bill_future(c);
}


/*-----------------------------------------------------------------------
  create_bill_future <FUNCTION>
  ----------------------------------------------------------------------*/
bill_future create_bill_future(	__instrument option(nullable) c,
								out instr_error option(nullable) error,
								error_type type = E_INIT)
option(com_name: 'INTERNAL_create_bill_future')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<bill_future>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.BILL_FUTURE, "invalid instrument type",type );//should not happen
	
	return new bill_future(c);
}

bill_future create_bill_future(	__instrument option(nullable) 		c,
								error_info option(nullable) 		error,
								error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_bill_future_ei')
{
	instr_error ee 	= instr_error();
	bill_future b 	= create_bill_future(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_bill_future");
	return b;
}

/*-----------------------------------------------------------------------
  add_nominal 
  ----------------------------------------------------------------------*/
void bill_future.add_nominal(number nominal) 
{			
	instrument.add_nominal(nominal );
	return ;						
}

/*-----------------------------------------------------------------------
  bill_future: add_quote
  ----------------------------------------------------------------------*/
void bill_future.add_quote(number  quote ) 
{	
	instrument.add_quote(quote, false);
	return ;					
	
}
void bill_future.add_quote(	number  quote,
							logical option(nullable) set_to_par ) 
{
	if(null(set_to_par))
		set_to_par = false;
	QL_FAIL_COND(set_to_par, "invalid argument: set_to_par not applicable for bill_future", name(), true);
	
	instrument.add_quote(quote, false);
	return ;					
	
}
/*-----------------------------------------------------------------------
  add_quote
  ----------------------------------------------------------------------*/
/*void bill_future.add_quote(	number  quote,
							..quote_style.quote_style quote_style,
							logical option(nullable) set_to_par ) 
{	
	..quote_style.quote_style qs = instrument.quote_style_e(false);
	if(quote_style == qs)
		instrument.add_quote(quote, set_to_par);
	else{
		if(quote_style == ..quote_style.YIELD) {
			if(qs == ..quote_style.YIELD_PCT)
				instrument.add_quote(quote*100, set_to_par);
			else if(qs == ..quote_style.EDFUT)
				instrument.add_quote(100-quote*100,set_to_par);
			else
				QL_FAIL("invalid quote style");
		}
		else if(quote_style == ..quote_style.YIELD_PCT){
			if(qs == ..quote_style.YIELD)
				instrument.add_quote(quote/100, set_to_par);
			else if(qs == ..quote_style.EDFUT)
				instrument.add_quote(100-quote, set_to_par);
			else
				QL_FAIL("invalid quote style");
		}
		else if(quote_style == ..quote_style.EDFUT){
			if(qs == ..quote_style.YIELD)
				instrument.add_quote((100.0-quote)/100, set_to_par);
			else if(qs == ..quote_style.YIELD_PCT)
				instrument.add_quote(100.0-quote, set_to_par);
			else
				QL_FAIL("invalid quote style");
		}
		else
			QL_FAIL("invalid quote style");
	}					
}*/
/*-----------------------------------------------------------------------
  add_quote_from_yield
  ----------------------------------------------------------------------*/
void bill_future.add_quote_from_yield(number  yield ) 
{	
	instrument.add_quote_from_yield(yield , false);
	return ;					
	
}
void bill_future.add_quote_from_yield(	number  quote,
								logical option(nullable) set_to_par ) 
{
	if(null(set_to_par))
		set_to_par = false;
	QL_FAIL_COND(set_to_par, "invalid argument: set_to_par not applicable for bill_future", name(), true);
	
	instrument.add_quote_from_yield(quote,  false );
	return ;						
}
/*-----------------------------------------------------------------------
  hidden in root members
  ----------------------------------------------------------------------*/
string 	bill_future.maturity_code(error_info option(nullable) error)		{ return instrument.maturity_code(error);}
date  	bill_future.settle_date(error_info option(nullable) error)			{ return this.expiry_settle_date(error);}
date  	bill_future.expiry_settle_date(error_info option(nullable) error)	{ return instrument.first_settle_date(error);}
day_count_method bill_future.dc_method(error_info option(nullable) error) 	{ return instrument.next_dc_method(error);}
//number bill_future.redemp_price(error_info option(nullable) error)			{ return instrument.redemp_price(error);}
string bill_future.fixing_code(error_info option(nullable) error) 			{ return instrument.fixing_code(error) ;}
calendar bill_future.fixing_calendar(error_info option(nullable) error) 	{ return instrument.fixing_calendar(error) ;}
string bill_future.fixing_calendar_name(error_info option(nullable) error) 	{ return instrument.fixing_calendar_name(error) ;}
//number bill_future.contract_yield(error_info option(nullable) error)		{ return instrument.coupon(error);}
number bill_future.tick_size(error_info option(nullable) error)				{ return instrument.fut_tick_size(error);}
logical bill_future.is_daily_mtm(error_info option(nullable) error) 		{ return instrument.fut_daily_mtm(error);}
number  bill_future.tick_value(	number tick_size,									
								error_info option(nullable) error) 			{ return instrument.fut_tick_value(tick_size,error); }
number  bill_future.contract_size(error_info option(nullable) error)		{ return instrument.fut_contract_size(error);}
number 	bill_future.face_amount(error_info option(nullable) error)			{ return this.contract_size(error);}
integer bill_future.coupon_freq(error_info option(nullable) error)			{ return instrument.err_type_freq(err_freq(), error, "bill_future.coupon_freq");}

vector(date) bill_future.cash_flow_dates(logical adj_dates,
										 error_info option(nullable) error){ return instrument.cash_flow_dates(false, adj_dates,true,error);}

vector(date) bill_future.cash_flow_dates(logical post_settle,
										 logical adj_dates,
										 logical keep_size,
										 error_info option(nullable) error){ return this.cash_flow_dates(adj_dates,error);}

vector(number) bill_future.cash_flows_cpn(number option(nullable) 	nominal,
										  logical 					post_settle,
										  logical 					keep_size,
										  error_info option(nullable) error){ return instrument.cash_flows_cpn(nominal, false, true,error);}


vector(number) bill_future.cash_flows(number option(nullable) nominal,
									  error_info option(nullable) error)	{ return instrument.cash_flows(nominal, false, true,error);}

vector(number) bill_future.cash_flows(number option(nullable) 	nominal,
									  logical 					post_settle,
									  logical 					keep_size,
									  error_info option(nullable) error)	{ return this.cash_flows(nominal, error);}

void bill_future.cash_flow_data(number option(nullable) nominal,
								ir_cf_code 				cf_code,
								logical 				adj_dates,
								out vector(date)   dates, 
								out vector(number)   amounts,								
								error_info option(nullable) error)			{ instrument.cash_flow_data(nominal,false, cf_code,adj_dates,true,dates,amounts, error);}

void bill_future.cash_flow_data(number option(nullable) nominal,
								logical 				post_settle,
								ir_cf_code 				cf_code,
								logical 				adj_dates,
								logical 				keep_size,
								out vector(date)   dates, 
								out vector(number)   amounts,								
								error_info option(nullable) error)			{ this.cash_flow_data(nominal,cf_code,adj_dates,dates,amounts, error);}



/*-----------------------------------------------------------------------
  last_trade_date
  ----------------------------------------------------------------------*/
date bill_future.last_trade_date(error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__billfut_last_trade(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bill_future.last_trade_date");	
		return e ? null<date>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bill_future.last_trade_date");		
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  set_quote 
  ----------------------------------------------------------------------*/
bill_future bill_future.set_quote(	number 	option(nullable) quote,
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, false,error);
	return null(cc) ? null<bill_future>: dynamic_cast<bill_future>(cc);
}

/*-----------------------------------------------------------------------
  set_quote 
  ----------------------------------------------------------------------*/
bill_future bill_future.set_quote(	string 	option(nullable) quote_side,
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, false,error);
	return null(cc) ? null<bill_future>: dynamic_cast<bill_future>(cc);
}

/*-----------------------------------------------------------------------
  set_quote 
  ----------------------------------------------------------------------*/
bill_future bill_future.set_quote(	number 	option(nullable) quote,
									date  	option(nullable) trade_date,
									//logical option(nullable) set_to_par, 
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,trade_date, null<date>, false,error);
	return null(cc) ? null<bill_future>: dynamic_cast<bill_future>(cc);
}

/*-----------------------------------------------------------------------
  set_quote
  ----------------------------------------------------------------------*/
bill_future bill_future.set_quote(	string 	option(nullable) quote_side,
									date  	option(nullable) trade_date, 
									//logical 	option(nullable) set_to_par,
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,trade_date, null<date>, false,error);
	return null(cc) ? null<bill_future>: dynamic_cast<bill_future>(cc);
}

/*-----------------------------------------------------------------------
  set_date  (a version without settledate as argument)
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
bill_future bill_future.set_date(	date  				trade_date, 					
									logical 			re_init_static, 
									logical 			re_init_quote, 
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,null<date>,re_init_static,re_init_quote,error);
	return null(cc) ? null<bill_future>: dynamic_cast<bill_future>(cc);
	
}

/*-----------------------------------------------------------------------
  set_date <protected>
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
bill_future bill_future.set_date(	date  				trade_date, 
									date  option(nullable)	settle_date,
									logical 			re_init_static, 
									logical 			re_init_quote, 
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,null<date>,re_init_static,re_init_quote,error);
	return null(cc) ? null<bill_future>: dynamic_cast<bill_future>(cc);
	
}

/*-----------------------------------------------------------------------
  set_date <protected/legacy>
	quote is NOT kept even if trade_date is unchanged
  ----------------------------------------------------------------------*/
bill_future bill_future.set_date(	date  				trade_date, 
									logical 			re_init_static, 
									error_info option(nullable) error) 

{	
	instrument cc = instrument._set_date(trade_date,re_init_static,error);
	return null(cc) ? null<bill_future>: dynamic_cast<bill_future>(cc);	
}

/*-----------------------------------------------------------------------
   move_date  <protected/legacy>
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	if trade date is the same --> the settle date will be preserved	
  ----------------------------------------------------------------------*/
bill_future bill_future.move_date(	date  				trade_date, 
									date option(nullable) settle_date,
									error_info option(nullable) error) 
{	
	instrument cc = instrument._move_date(trade_date,null<date>,error);
	return null(cc) ? null<bill_future>: dynamic_cast<bill_future>(cc);
}

/*-----------------------------------------------------------------------
  set_yield
  ----------------------------------------------------------------------*/
bill_future bill_future.set_yield(	number 	option(nullable) yield,						
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_yield(	yield, null<date>, null<date>,false, error);
	return null(cc) ? null<bill_future>: dynamic_cast<bill_future>(cc);
}

/*-----------------------------------------------------------------------
  set_yield
  ----------------------------------------------------------------------*/
bill_future bill_future.set_yield(	number 	option(nullable) yield,
									date  	option(nullable) trade_date, 
									//logical option(nullable) set_to_par,												
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_yield(	yield, trade_date, null<date>,false, error);
	return null(cc) ? null<bill_future>: dynamic_cast<bill_future>(cc);
}

/*-----------------------------------------------------------------------
  set_quote_from_yield
  ----------------------------------------------------------------------*/
bill_future bill_future.set_quote_from_yield(	number 	option(nullable) yield,
												error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote_from_yield(yield,  false,error);
	return null(cc) ? null<bill_future>: dynamic_cast<bill_future>(cc);
}

/*-----------------------------------------------------------------------
  set_quote_from_yield
  ----------------------------------------------------------------------*/
/*bill_future bill_future.set_quote_from_yield(	number 	option(nullable) yield,
												logical option(nullable) set_to_par, 
												error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote_from_yield(yield,  set_to_par,error);
	return null(cc) ? null<bill_future>: dynamic_cast<bill_future>(cc);
}*/


