option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	bond
	--------------------------------------------------------------------
*/

//-----------------------------------------------------------------------
//  class bond
//----------------------------------------------------------------------
class bond: public instrument
option(category: "Instrument/Bond")
//option(allow_undeclared_mfuncs)
{
public:

	//override string	instr_type_s();
	override instrument 	inst();
	
/*	--------------------------------
	---OVERRIDES (HIDDEN IN ROOT) --- 
	--------------------------------
		- implemented in root for backward compat reasons
*/
	//-----add-funcs-----			
	override void 			add_nominal(number );										
	void 					add_quote(number );				/*set cpn to quote removed --> local*/
	void 					add_quote_from_yield(number );	/*set cpn to quote removed --> local*/
	
	//-----general-----
	override logical 		eom(error_info option(nullable) error = null<error_info> );
	override string 		maturity_code(error_info option(nullable) error = null<error_info> );
	override bd_convention 	pmt_bus_day(error_info option(nullable) error = null<error_info>);	
	override date 			next_cpn_date(error_info option(nullable) error = null<error_info> );
	override date 			next_cpn_date_adj(error_info option(nullable) error = null<error_info> );
	override date 			previous_cpn_date(error_info option(nullable) error = null<error_info> );		
	override date 			first_cpn_date(error_info option(nullable) error = null<error_info> );
	override date 			first_settle_date(error_info option(nullable) error = null<error_info>);
	override integer 		comp_freq(error_info option(nullable) error = null<error_info> );
	override day_count_method accr_dc_method(error_info option(nullable) error = null<error_info> );			
	override  number 		first_coupon_rate(error_info option(nullable) error = null<error_info> );				
	override  number 		first_cpn_amount(error_info option(nullable) error = null<error_info> );			
	override  number 		last_cpn_amount(error_info option(nullable) error = null<error_info>);				
	override  number 		next_cpn_amount(error_info option(nullable) error = null<error_info> );				
	override  date 			cpn_start_date(error_info option(nullable) error = null<error_info> );				
	override  date 			next_excpn_date(error_info option(nullable) error = null<error_info> );			
	override  date 			last_reg_cpn_date(error_info option(nullable) error = null<error_info> );
	override date 			last_reg_cpn_date_adj(error_info option(nullable) error = null<error_info> );
	override  logical 		is_regular_first(error_info option(nullable) error = null<error_info> );			
	override  logical 		is_regular_last(error_info option(nullable) error = null<error_info> );				
	override  number 		redemp_price(error_info option(nullable) error = null<error_info>);				
	override  day_count_method next_dc_method(error_info option(nullable) error = null<error_info> );				
	override  day_count_method accr_last_dc_method(error_info option(nullable) error = null<error_info>);
	override  day_count_method next_last_dc_method(error_info option(nullable) error = null<error_info>);
	override  integer 		roll_day(error_info option(nullable) error = null<error_info> );							
	override  string 		excpn_code(error_info option(nullable) error = null<error_info>);			
	override  number 		issued_amount(error_info option(nullable) error = null<error_info>);
	
	//-----price-----
	override number 		accrued_chg(integer, out number, out date , out date ,		
										logical in_pcnt = true, error_info option(nullable) error = null<error_info> ) ; 			
	override number 		accrued_period(error_info option(nullable) error = null<error_info>);
	override integer		accrued_days(error_info option(nullable) error= null<error_info>);
	override number 		clean_price_to_coupon(number,disc_func, error_info option(nullable) error = null<error_info>) ;

	//-----bond-specific-----
	number					z_spread(disc_func,day_count_method,rate_type,error_info option(nullable) error = null<error_info>);  	/*local impl.*/
	number 					asw_spread(	number option(nullable) ,day_count_method,bd_convention,integer ,
										logical,..calendar,disc_func,fwd_func ,..ir_index,asw_type,
										error_info option(nullable) error = null<error_info> );										/*local impl.*/
	number					i_spread(vector(date),vector(number),error_info option(nullable) error = null<error_info>);				/*local impl.*/
	number					d_spread(vector(number),vector(number),error_info option(nullable) error = null<error_info>);			/*local impl.*/
	number					y_spread(disc_func,error_info option(nullable) error = null<error_info>);
	number					asw_mat_match_spread(	number option(nullable),day_count_method ,bd_convention ,integer ,
													logical,..calendar,disc_func,fwd_func,..ir_index,
													error_info option(nullable) error = null<error_info>);							/*local impl.*/
	
	override void  			funding(date,number,number option(nullable) ,
									day_count_method ,
									rate_type option(nullable) ,
									disc_func option(nullable),
									cpn_reinv_type, number option(nullable),
									out number,out number,
									out number	,out number,
									out number,out number	,
									out number,
									error_info option(nullable) error = null<error_info>) ;						/*root impl.*/
	
	override number  		clean_price_fwd(date ,number ,number option(nullable) ,
											day_count_method,rate_type option(nullable) ,
											disc_func option(nullable) ,cpn_reinv_type,
											error_info option(nullable) error = null<error_info>) ; 			/*root impl.*/			
	override number  		dirty_price_fwd(date ,number ,number option(nullable) ,
											day_count_method,rate_type option(nullable) ,
											disc_func option(nullable) ,cpn_reinv_type,
											error_info option(nullable) error = null<error_info>) ; 			/*root impl.*/	
	override number  		yield_fwd(	date ,number ,number option(nullable) ,
										day_count_method,rate_type option(nullable) ,
										disc_func option(nullable) ,cpn_reinv_type,
										error_info option(nullable) error = null<error_info>) ; 				/*root impl.*/		
	override number  		horizon_return(date ,number ,..quote_style	option(nullable),number option(nullable) ,
											day_count_method,rate_type option(nullable) ,disc_func option(nullable) ,
											cpn_reinv_type,
										   error_info option(nullable) error = null<error_info>) ; 				/*root impl.*/
	override void  			roll_down(	date,disc_func option(nullable) ,day_count_method,
										rate_type option(nullable),logical option(nullable),out number,
										out number ,out number ,
										out number ,out date,
										error_info option(nullable) error = null<error_info>) ; 				/*root impl.*/

	void  					imp_fwd(instrument ,number option(nullable),number option(nullable),day_count_method,rate_type  ,disc_func,
									number option(nullable),number option(nullable),number option(nullable),out number,
									out number,out number,out number,out number,out number,out number,  error_info option(nullable) error = null<error_info>) ; 				
	
	/*
		convexity_cf, pl_intraday
	*/

/*	--------------------------------
	---OVERRIDES (PUBLIC i.e. NOT HIDDEN IN ROOT) --- 
	--------------------------------
		-implemented in root
		-required
*/	
	override bond 		set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);
	override bond 		set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);
	override bond 		set_quote_from_yield(number option(nullable) ,
											 error_info option(nullable) error = null<error_info>);  /*legacy, hidden in root*/

/*	--------------------------------
	---OVERRIDES (HIDDEN IN ROOT, THROWS IN ROOT) --- 
	--------------------------------
		-implemented in root with "-" prefix
		-here if applicable
*/
	override bond 		set_date(date,date option(nullable) settle_date = null<date>,
								 logical re_init_static = true,
								 logical init_quote = true  ,
								 error_info option(nullable) error = null<error_info>);						

	override bond 		set_settle_date(date ,
										logical re_initialize = false ,
										error_info option(nullable) error = null<error_info>);

	override bond 		set_clean_price(number option(nullable),
										date option(nullable) trade_date  = null<date>,
										date option(nullable) settle_date = null<date> ,
										error_info option(nullable) error = null<error_info> );

	override bond 		set_dirty_price(number option(nullable),
										date option(nullable) trade_date  = null<date>,
										date option(nullable) settle_date = null<date> ,
										error_info option(nullable) error = null<error_info>);

	override bond 		set_yield(number option(nullable) ,
								  error_info option(nullable) error = null<error_info>);	
	
/*	--------------------------------
	---LOCALS (NOT EXPOSED IN ROOT) 
	--------------------------------
		-implemented in root with "-" prefix
		-here if applicable
*/
	
	bond 				set_quote(number option(nullable),date  option(nullable) ,
								  date option(nullable) settle_date = null<date>,
								  error_info option(nullable) error = null<error_info>);
	bond 				set_quote(string option(nullable),date  option(nullable) ,
								  date option(nullable) settle_date = null<date>,
								  error_info option(nullable) error = null<error_info>);
	
	bond 				set_yield(number option(nullable) ,date option(nullable) ,
								  date  option(nullable) settle_date = null<date>,
								  error_info option(nullable) error = null<error_info>);

	
	bond(__instrument);
	override bond clone();
	bond(bond);
protected:

	
	override bond 		create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);  
	override void 		add_quote(number,logical option(nullable) ); 
	override void 		add_quote_from_yield(number,logical option(nullable) );
	
	override bond 		set_date(	date,logical ,error_info option(nullable) error = null<error_info>);	/*legacy*/
	override bond 		move_date(	date,date option(nullable) settle_date = null<date>,
									error_info option(nullable) error = null<error_info>);					/*legacy*/
};

//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
bond.bond(__instrument i) option(hidden): instrument(i){}

//------------------------------------------------
// create  [PROTECTED]
// create bond from internal instrument
//------------------------------------------------
bond bond.create(	__instrument option(nullable) c,
					out instr_error option(nullable) error,
					error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<bond>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.FIXED_CPN_BOND, "invalid instrument type",type );//should not happen
	
	return new bond(c);
}

/*-----------------------------------------------------------------------
  create_bond <FUNCTION>
  ----------------------------------------------------------------------*/

bond create_bond(	__instrument option(nullable) c,
						out instr_error option(nullable) error,
						error_type type = E_INIT)
option(com_name: 'INTERNAL_create_bond')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<bond>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.FIXED_CPN_BOND, "invalid instrument type",type );//should not happen
	return new bond(c);
}

bond create_bond(	__instrument option(nullable) 		c,
					error_info option(nullable) 		error,
					error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_bond_ei')
{
	instr_error ee 	= instr_error();
	bond b 	= create_bond(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_bond");
	return b;
}

//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string bond.instr_type_s()  { return string(..instr_type.FIXED_CPN_BOND);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	bond.inst()		{ return this;}
//------------------------------------------------
// copy constructor
//------------------------------------------------
bond.bond(bond c) : instrument(c) {}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
bond bond(bond b)			{ return new bond(b);}
//------------------------------------------------
// clone
//------------------------------------------------
bond bond.clone()			{ return new bond(this);}
//-----------------------------------------------
// dynamic cast <FUNCTION>
//-----------------------------------------------
bond bond(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Bond')
option(com_name: 'bond_dyncast') 
{ 
	try {
		bond d = dynamic_cast<bond>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a bond)","bond" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond");
		return null<bond>;
	}
}

/*-----------------------------------------------------------------------
  bond: add_nominal 
  ----------------------------------------------------------------------*/
void bond.add_nominal(number nominal) 
{			
	instrument.add_nominal(nominal );
	return ;						
}

/*-----------------------------------------------------------------------
  bond: add_quote
  ----------------------------------------------------------------------*/
void bond.add_quote(number  quote ) 
{	
	instrument.add_quote(quote, false);
	return ;					
	
}
void bond.add_quote(number  quote, logical option(nullable) set_coupon_to_quote ) 
{	
	if(null(set_coupon_to_quote)) set_coupon_to_quote = false;
	QL_FAIL_COND(set_coupon_to_quote, "invalid argument: set coupon to quote not applicable for bond", name(), true);
	instrument.add_quote(quote, set_coupon_to_quote);
	return ;						
}

/*-----------------------------------------------------------------------
  bond: add_quote_from_yield
  ----------------------------------------------------------------------*/
void bond.add_quote_from_yield(number  yield ) 
{	
	instrument.add_quote_from_yield(yield, false);
	return ;					
	
}
void bond.add_quote_from_yield(number  yield, logical option(nullable) set_coupon_to_yield ) 
{	
	if(null(set_coupon_to_yield)) set_coupon_to_yield= false;
	QL_FAIL_COND(set_coupon_to_yield, "invalid argument: set coupon to yield not applicable for bond", name(), true);
	instrument.add_quote_from_yield(yield, set_coupon_to_yield);
	return ;						
}
/*-----------------------------------------------------------------------
  hidden in root members
  ----------------------------------------------------------------------*/
logical bond.eom(error_info option(nullable) error) 					{ return instrument.eom(error);}
string 	bond.maturity_code(error_info option(nullable) error)			{ return instrument.maturity_code(error);}
date  	bond.next_cpn_date(error_info option(nullable) error) 			{ return instrument.next_cpn_date(error);}
date  	bond.previous_cpn_date(error_info option(nullable) error) 		{ return instrument.previous_cpn_date(error);}
date  	bond.first_cpn_date(error_info option(nullable) error)			{ return instrument.first_cpn_date(error);}
date  	bond.first_settle_date(error_info option(nullable) error)		{ return instrument.first_settle_date(error);}
bd_convention bond.pmt_bus_day(error_info option(nullable) error) 		{ return instrument.pmt_bus_day(error);}
integer bond.comp_freq(error_info option(nullable) error) 				{ return instrument.comp_freq(error);}
date bond.cpn_start_date(error_info option(nullable) error)				{ return instrument.cpn_start_date(error);}
date bond.last_reg_cpn_date(error_info option(nullable) error)			{ return instrument.last_reg_cpn_date(error);}
date bond.last_reg_cpn_date_adj(error_info option(nullable) error)		{ return instrument.last_reg_cpn_date_adj(error);}
date bond.next_cpn_date_adj(error_info option(nullable) error)			{ return instrument.next_cpn_date_adj(error);}
string bond.excpn_code(error_info option(nullable) error) 				{ return instrument.excpn_code(error);}
logical bond.is_regular_first(error_info option(nullable) error) 		{ return instrument.is_regular_first(error);}
logical bond.is_regular_last(error_info option(nullable) error) 		{ return instrument.is_regular_last(error);}
number  bond.redemp_price(error_info option(nullable) error) 			{ return instrument.redemp_price(error);}
number  bond.first_coupon_rate(error_info option(nullable) error)		{ return instrument.first_coupon_rate(error);}
number  bond.last_cpn_amount(error_info option(nullable) error) 		{ return instrument.last_cpn_amount(error);}
number  bond.first_cpn_amount(error_info option(nullable) error)		{ return instrument.first_cpn_amount(error);}
number  bond.next_cpn_amount(error_info option(nullable) error)			{ return instrument.next_cpn_amount(error);}
day_count_method bond.accr_last_dc_method(error_info option(nullable) error) { return instrument.accr_last_dc_method(error);}
day_count_method bond.next_last_dc_method(error_info option(nullable) error) { return instrument.next_last_dc_method(error);}
day_count_method bond.next_dc_method(error_info option(nullable) error) { return instrument.next_dc_method(error);}
number bond.issued_amount(error_info option(nullable) error)			{ return instrument.issued_amount(error);}
date bond.next_excpn_date(error_info option(nullable) error) 			{ return instrument.next_excpn_date(error);}
integer  bond.roll_day(error_info option(nullable) error) 				{ return instrument.roll_day( error);}
day_count_method bond.accr_dc_method(error_info option(nullable) error) { return instrument.accr_dc_method(error);}
number  bond.accrued_period(error_info option(nullable) error) 			{ return instrument.accrued_period(error);}
integer	bond.accrued_days(error_info option(nullable) error)			{ return instrument.accrued_days(error);}

number bond.clean_price_to_coupon(	number clean_price_pcnt,
									disc_func disc_func,								
									error_info option(nullable) error)	{ return instrument.clean_price_to_coupon(clean_price_pcnt,disc_func,error);}

number  bond.accrued_chg(	integer bus_days_fwd,
							out number cpn_cashflow,
							out date settle,
							out date settle_next,
							logical in_pcnt,
							error_info option(nullable) error) 			{ return instrument.accrued_chg(bus_days_fwd, cpn_cashflow,settle,settle_next,in_pcnt,error);}

/*-----------------------------------------------------------------------
  y_spread
  ----------------------------------------------------------------------*/
number bond.y_spread(disc_func df,
					 error_info option(nullable) error)
{
	try{	
		error_info ee = new error_info(true,true);
		
		number yld_mod 	= this.yield(df,false,ee);
		number yld 		= this.yield(false,ee);
		number ys 		= yld - yld_mod;
		return ys;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond.y_spread");		
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  z_spread
  ----------------------------------------------------------------------*/
number bond.z_spread(disc_func df,
					 day_count_method dc,
					 rate_type rt,
					 error_info option(nullable) error)
{
	try{	
		error_info ee = new error_info(true,true);
		
		vector(date) 	cf_dates;
		vector(number)	cf100 ;
		cash_flow_data(	100 ,true ,ir_cf_code.TOTAL ,true,false ,cf_dates ,cf100,ee);
		
		number dp100 = this.dirty_price(null<number>,false,true,ee);		
		date td 	= this.trade_date();
		date sd 	= this.settle_date();
		number z 	= gen_z_spread(td, df,sd, cf_dates, cf100, dp100, 100,null<number>, rt, dc);		
		return z;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond.z_spread");		
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  i_spread
  ----------------------------------------------------------------------*/
number bond.i_spread(vector(date) mat_v,
					vector(number) y_v,
					 error_info option(nullable) error)
{
	try{
		error_info ee = new error_info(true,true);
		date mat = this.maturity(ee);
		number yld = this.yield(false,ee);
		vector(number) r = gen_i_spread(mat_v,y_v,[mat],[yld])	;		
		return r[0];								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond.i_spread");		
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  d_spread
  ----------------------------------------------------------------------*/
number bond.d_spread(vector(number) dur_v,
					vector(number) y_v,
					 error_info option(nullable) error)
{
	try{
		error_info ee = new error_info(true,true);
		number dur = this.mod_dur(ee);
		number yld = this.yield(false,ee);
		vector(number) r = gen_d_spread(dur_v,y_v,[dur],[yld])	;		
		return r[0];								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond.d_spread");		
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  asw_spread
  ----------------------------------------------------------------------*/
number bond.asw_spread(	number option(nullable) first_fix, 
						day_count_method 		flt_day_count_method,
						bd_convention 			flt_bd_convention,
						integer 				flt_freq,
						logical 				flt_eom,
						..calendar 				flt_calendar,
						disc_func 				disc_func_swap,
						fwd_func 				fwd_func_swap,
						..ir_index 				flt_ir_index,
						asw_type				type,
						error_info option(nullable) error)
{
	try{
		error_info ee 			= new error_info(true,true);
		string curr 			= this.currency(ee);
		number bond_nominal 	= 100;
		date bond_mat_adj 		= this.maturity_adj(ee);
		date bond_last_reg_adj 	= this.last_reg_cpn_date_adj(ee);
		number bond_roll_day 	= this.roll_day(ee);
		
		vector(date) bond_dates;
		vector(number) bond_cpns100;
		this.cash_flow_data(100,true,ir_cf_code.COUPON, true, false,bond_dates,bond_cpns100,ee);
		integer size = v_size(bond_dates);
		QL_FAIL_COND(size < 1, "invalid bond date vector", E_INIT);
			
		number ai100 			= this.accrued(false,true,ee);	
		number cp100 			= this.clean_price(false,true,ee);
		
		number s = CORE_INT.fixflt_asw_helper_spr(	this.trade_date(ee),this.settle_date(ee), bond_nominal,
													bond_mat_adj, bond_last_reg_adj, bond_dates, bond_cpns100,
													bond_roll_day, curr, ai100, cp100,
													flt_day_count_method,flt_bd_convention, flt_freq,flt_eom,flt_calendar,
													curr, flt_ir_index,								
													null<number>, null<disc_func>,disc_func_swap,	
													fwd_func_swap,first_fix, type);
		return s;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond.asw_spread");		
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  asw_spread
  ----------------------------------------------------------------------*/
number bond.asw_mat_match_spread(	number option(nullable) first_fix, 
									day_count_method 		flt_day_count_method,
									bd_convention 			flt_bd_convention,
									integer 				flt_freq,
									logical 				flt_eom,
									..calendar 				flt_calendar,
									disc_func 				disc_func_swap,
									fwd_func 				fwd_func_swap,
									..ir_index 				flt_ir_index,									
									error_info option(nullable) error)
{
	try{
		error_info ee 			= new error_info(true,true);
		string curr 			= this.currency(ee);
		date bond_mat_adj 		= this.maturity_adj(ee);
		//date bond_last_reg_adj 	= this.last_reg_cpn_date_adj(ee);
		number bond_roll_day 	= this.roll_day(ee);
		number yld 				= this.yield(false,ee);
		number s = CORE_INT.fixflt_asw_mat_helper_spr(this.trade_date(ee),this.settle_date(ee), bond_mat_adj,
									this.accr_dc_method(ee),this.pmt_bus_day(ee),this.coupon_freq(ee),
									this.eom(ee),this.calendar(ee), bond_roll_day, curr,yld,
									flt_day_count_method,flt_bd_convention, flt_freq,flt_eom,flt_calendar,curr,
									flt_ir_index,disc_func_swap,fwd_func_swap,first_fix );
		return s;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond.asw_spread");		
		return null<number >;
	}
}
	
/*-----------------------------------------------------------------------
  asw_par_spread
  ----------------------------------------------------------------------*/
/*number bond.asw_par_spread(	number option(nullable) first_fix, 
							day_count_method 		flt_day_count_method,
							bd_convention 			flt_bd_convention,
							integer 				flt_freq,
							logical 				flt_eom,
							..calendar 				flt_calendar,
							disc_func 				disc_func_swap,
							fwd_func 				fwd_func_swap,  
							out number	upfront_pmt, 
							out number pv_flt_leg,  
							out number	pv_fix_leg,
							error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__fcb_asw_par_spread(first_fix, flt_day_count_method,flt_bd_convention,
										flt_freq,flt_eom,flt_calendar,disc_func_swap,fwd_func_swap,
										upfront_pmt, pv_flt_leg, pv_fix_leg, t,s );
		logical e = CORE_INT.add_error_info(error,t,s, "bond.asw_par_spread");
		if(e) {
			upfront_pmt = pv_flt_leg = pv_fix_leg = null<number>;
			return null<number >;
		}
		
		return c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond.asw_par_spread");		
		upfront_pmt = pv_flt_leg = pv_fix_leg = null<number>;
		return null<number >;
	}
}*/

/*-----------------------------------------------------------------------
  bond: funding

  ----------------------------------------------------------------------*/
void bond.funding(	date 						fwd_settle_date,
					number  					repo_rate,
					number option(nullable) 	cpn_reinv_rate,
					day_count_method 			day_count_method,
					rate_type option(nullable) 	rate_type,
					disc_func option(nullable) 	disc_func_reinv,//when repo_rate is not nullable the disc_func is only used for reinv of cpns (if cpn_reinv_rate is null)
					cpn_reinv_type 				cpn_reinv_type,
					number option(nullable) 	nominal,
					out number	dirty_price_fwd,
					out number	cf_fund_cost,
					out number cf_net_fund_cost,
					out number	cf_accr,
					out number	cf_coc,
					out number	cf_cpn,
					out number cf_cpn_reinv,								
					error_info option(nullable) error) 
{	
	instrument.funding(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,rate_type,disc_func_reinv,cpn_reinv_type,							
						nominal,dirty_price_fwd,cf_fund_cost,cf_net_fund_cost,cf_accr,cf_coc,cf_cpn,cf_cpn_reinv,error);

	return;
}


/*-----------------------------------------------------------------------
  clean_price_fwd
  ----------------------------------------------------------------------*/
number bond.clean_price_fwd(	date 						fwd_settle_date,
								number  					repo_rate,
								number option(nullable) 	cpn_reinv_rate,
								day_count_method 			day_count_method,
								rate_type option(nullable) 	rate_type,
								disc_func option(nullable) 	disc_func,	
								cpn_reinv_type  			cpn_reinv_type,								
								error_info option(nullable) error)
{	
	return instrument.clean_price_fwd(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,
							rate_type,disc_func,cpn_reinv_type,error);
}


/*-----------------------------------------------------------------------
  dirty_price_fwd

  ----------------------------------------------------------------------*/
number bond.dirty_price_fwd(	date 						fwd_settle_date,
								number  					repo_rate,
								number option(nullable) 	cpn_reinv_rate,
								day_count_method 			day_count_method,
								rate_type option(nullable) 	rate_type,
								disc_func option(nullable) 	disc_func,	
								cpn_reinv_type 				cpn_reinv_type,								
								error_info option(nullable) error)
{	
	return instrument.dirty_price_fwd(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,
							rate_type,disc_func,cpn_reinv_type,error);
}

/*-----------------------------------------------------------------------
  yield_fwd

  ----------------------------------------------------------------------*/
number bond.yield_fwd(	date 						fwd_settle_date,
						number  					repo_rate,
						number option(nullable) 	cpn_reinv_rate,
						day_count_method 			day_count_method,
						rate_type option(nullable) 	rate_type,
						disc_func option(nullable) 	disc_func,	
						cpn_reinv_type 				cpn_reinv_type,								
						error_info option(nullable) error)
{	
	return instrument.yield_fwd(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,
							rate_type,disc_func,cpn_reinv_type,error);
}


/*-----------------------------------------------------------------------
  horizon_return

  ----------------------------------------------------------------------*/
number bond.horizon_return(	date 						fwd_settle_date,
							number  					quote,
							..quote_style	option(nullable) quote_style,
							number option(nullable) 	cpn_reinv_rate,
							day_count_method 			day_count_method,
							rate_type option(nullable) 	rate_type,
							disc_func option(nullable) 	disc_func,	
							cpn_reinv_type 				cpn_reinv_type,								
							error_info option(nullable) error)
{	
	return instrument.horizon_return(fwd_settle_date,quote,quote_style,cpn_reinv_rate,day_count_method,
							rate_type,disc_func,cpn_reinv_type,error);
}

/*-----------------------------------------------------------------------
  roll_down

  ----------------------------------------------------------------------*/
void bond.roll_down(	date 						fwd_settle_date,							
						disc_func option(nullable) 	disc_func,
						day_count_method 			day_count_method,
						rate_type option(nullable) 	rate_type,
						logical option(nullable) 	realized_fwd,
						out number fwd_yield,
						out number sprd_vs_crv,
						out number roll_sprd,
						out number roll_return,
						out date fwd_trade_date,
						error_info option(nullable) error)
{	
	instrument.roll_down(fwd_settle_date,disc_func,day_count_method,rate_type,realized_fwd,
					 fwd_yield,sprd_vs_crv,roll_sprd,roll_return,fwd_trade_date,error);
}

/*-----------------------------------------------------------------------
  imp_fwd

  ----------------------------------------------------------------------*/
void bond.imp_fwd(	instrument 				bond_long,
					number	option(nullable)	nominal_short,
					number	option(nullable)	nominal_long,
					day_count_method	day_count_method,
					rate_type 			rate_type,
					disc_func 			reinv_disc_func,
					number option(nullable) reinv_sprd_short,
					number option(nullable) reinv_sprd_long,
					number option(nullable) take_out_sprd,
					out number	cf_cpn_short,
					out number cf_cpn_reinv_short,
					out number cf_short,
					out number	cf_cpn_long,
					out number cf_cpn_reinv_long,
					out number cf_long,
					out number imp_rate,
					error_info option(nullable) error)
{	
	
	try{
		if(null(nominal_short) && null(nominal_long)) {			
			nominal_short = 100;
			error_info ee 	= new error_info(true,true);
			number dps = this.dirty_price(null<number>,false,true,ee);
			number dpl = bond_long.dirty_price(null<number>,false,true,ee);
			nominal_long = dps/dpl*nominal_short;
		}
		else if(null(nominal_short)) {
			error_info ee 	= new error_info(true,true);
			number dps = this.dirty_price(null<number>,false,true,ee);
			number dpl = bond_long.dirty_price(null<number>,false,true,ee);
			nominal_short = dpl/dps*nominal_long;
		}
		else if(null(nominal_long)) {
			error_info ee 	= new error_info(true,true);
			number dps = this.dirty_price(null<number>,false,true,ee);
			number dpl = bond_long.dirty_price(null<number>,false,true,ee);
			nominal_long = dps/dpl*nominal_short;
		}
		
		instr_error_type t;
   		string 			s;
	
		i().__imp_fwd(	bond_long.i(), nominal_short,nominal_long, day_count_method,rate_type,reinv_disc_func,reinv_sprd_short,
						reinv_sprd_long,take_out_sprd,cf_cpn_short,cf_cpn_reinv_short,cf_short,cf_cpn_long,cf_cpn_reinv_long,cf_long,imp_rate,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond.imp_fwd");
		if(e){ 
			cf_short = cf_long = imp_rate = null<number>;		
		}		
		return ;						
	}
	catch {
		cf_short = cf_long = imp_rate = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond.imp_fwd");
		return ;
	}
}

/*-----------------------------------------------------------------------
  bond: set_date
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
bond bond.set_date(	date  				trade_date, 
					date  option(nullable)	settle_date,
					logical 			re_init_static, 
					logical 			re_init_quote, 
					error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,settle_date,re_init_static,re_init_quote,error);
	return null(cc) ? null<bond>: dynamic_cast<bond>(cc);
	
}

/*-----------------------------------------------------------------------
  bond: set_date <protected/legacy>
	quote is NOT kept even if trade_date is unchanged i.e. the quote is reinitalized
	(as opposed to move_date)
  ----------------------------------------------------------------------*/
bond bond.set_date(	date  				trade_date, 
					logical 			re_initialize, 
					error_info option(nullable) error) 
{	
	instrument cc = instrument._set_date(	trade_date,re_initialize,error);
	return null(cc) ? null<bond>: dynamic_cast<bond>(cc);
}

/*-----------------------------------------------------------------------
  bond: move_date <protected/legacy>
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	if trade date is the same --> the settle date will be preserved	
  ----------------------------------------------------------------------*/
bond bond.move_date(date  				trade_date, 
					date option(nullable) settle_date,
					error_info option(nullable) error)  
{	
	instrument cc = instrument._move_date(trade_date,settle_date,error);
	return null(cc) ? null<bond>: dynamic_cast<bond>(cc);
}

/*-----------------------------------------------------------------------
  bond: set_quote 
  ----------------------------------------------------------------------*/
bond bond.set_quote(	number 	option(nullable) quote,
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, false,error);
	return null(cc) ? null<bond>: dynamic_cast<bond>(cc);
}

/*-----------------------------------------------------------------------
  bond: set_quote 
  ----------------------------------------------------------------------*/
bond bond.set_quote(	string 	option(nullable) quote_side,
						error_info option(nullable) error)
option(com_name: 'set_quote_qs')
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, false,error);
	return null(cc) ? null<bond>: dynamic_cast<bond>(cc);
}


/*-----------------------------------------------------------------------
  bond: set_quote 
  ----------------------------------------------------------------------*/
bond bond.set_quote(	number 	option(nullable) quote,
						date  	option(nullable) trade_date, 
						date  	option(nullable) settle_date, 
						error_info option(nullable) error)
option(com_name: 'set_quote_ext')
{	
	instrument cc = instrument._set_quote(quote,trade_date, settle_date, false,error);
	return null(cc) ? null<bond>: dynamic_cast<bond>(cc);
}
/*-----------------------------------------------------------------------
  bond: set_quote
  ----------------------------------------------------------------------*/
bond bond.set_quote(	string 	option(nullable) quote_side,
						date  	option(nullable) trade_date, 
						date  	option(nullable) settle_date, 
						error_info option(nullable) error)
option(com_name: 'set_quote_qs_ext')
{	
	instrument cc = instrument._set_quote(quote_side,trade_date, settle_date, false,error);
	return null(cc) ? null<bond>: dynamic_cast<bond>(cc);
}
/*-----------------------------------------------------------------------
  bond: set_clean_price
  ----------------------------------------------------------------------*/
bond bond.set_clean_price(	number 	option(nullable) clean_pct,
							date  	option(nullable) trade_date, 
							date  	option(nullable) settle_date, 
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_clean_price(	clean_pct,trade_date, settle_date,error);
	return null(cc) ? null<bond>: dynamic_cast<bond>(cc);
}

/*-----------------------------------------------------------------------
  bond: set_dirty_price
  ----------------------------------------------------------------------*/
bond bond.set_dirty_price(	number 	option(nullable) dirty_pct,
							date  	option(nullable) trade_date, 
							date  	option(nullable) settle_date, 
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_dirty_price(	dirty_pct,trade_date, settle_date,error);
	return null(cc) ? null<bond>: dynamic_cast<bond>(cc);
}
/*-----------------------------------------------------------------------
  bond: set_yield
  ----------------------------------------------------------------------*/
bond bond.set_yield(	number 	option(nullable) yield,							
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_yield(	yield, null<date>, null<date>,false, error);
	return null(cc) ? null<bond>: dynamic_cast<bond>(cc);
}

/*-----------------------------------------------------------------------
  bond: set_yield
  ----------------------------------------------------------------------*/
bond bond.set_yield(	number 	option(nullable) yield,
						date  	option(nullable) trade_date, 
						date  	option(nullable) settle_date, 								
						error_info option(nullable) error)  option(com_name: 'set_yield_ext')
{	
	instrument cc = instrument._set_yield(	yield, trade_date, settle_date,false, error);
	return null(cc) ? null<bond>: dynamic_cast<bond>(cc);
}

/*-----------------------------------------------------------------------
  bond: set_settle_date
  ----------------------------------------------------------------------*/
bond bond.set_settle_date(	date  				settle_date, 
							logical 			re_initialize, 
							error_info option(nullable) error)
{	
	
	instrument cc = instrument._set_settle_date(	settle_date, re_initialize, error);
	return null(cc) ? null<bond>: dynamic_cast<bond>(cc);
}

/*-----------------------------------------------------------------------
  bond: set_quote_from_yield
  ----------------------------------------------------------------------*/
bond bond.set_quote_from_yield(	number 	option(nullable) yield,
								error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote_from_yield(yield,  false,error);
	return null(cc) ? null<bond>: dynamic_cast<bond>(cc);
}

module CORE_INT
{
	vector(__instrument) get_instruments(vector(bond) iv)
	{
		integer s = v_size(iv);
		if(s == 0) return null<vector(__instrument)>;
		vector(__instrument) iv_;
		resize(iv_,s);
		for(integer j=0;j<s;j++)
			iv_[j] = iv[j].i();
		return ..clone_vector(iv_);
			
	}

	
	vector(bond) clone_vector(vector(bond) option(nullable) v)
	{
		if(null(v))
			return null<vector(bond)>;
		else 
			return ..clone_vector(v);
	}
}

