option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	ToDo: Repo dv01
	
	--------------------------------------------------------------------
	bond_future
	--------------------------------------------------------------------

	Db-column	    calc_method_t [map]		    	Bond_yld_method	    bond_fut_del_method_t [lookup]	
	---------	    -------------------		    	---------------	    ------------------------------
	"BONDFUT"	    CM_BONDFUT_PF_DMTM,		    	BCS_ISMA		    BFDM_PF_P_DEL_MTM				
	
	"SEKOMX2Y"	    CM_TMPL_SEKOMX_BF2Y_SYNT	    BCS_ISMA		    BFDM_SYNT_CP_DEL_MTM 			CM_TMPL_SEKOMX_BF2Y_SYNT-->CM_BONDFUT_CS_FWD_SYNT_DMTM		
	"SEKOMX5Y"	    CM_TMPL_SEKOMX_BF5Y_SYNT	    BCS_ISMA		    BFDM_SYNT_CP_DEL_MTM 			CM_TMPL_SEKOMX_BF5Y_SYNT-->CM_BONDFUT_CS_FWD_SYNT_DMTM		
	"SEKOMX10Y"	    CM_TMPL_SEKOMX_BF10Y_SYNT	    BCS_ISMA		    BFDM_SYNT_CP_DEL_MTM 			CM_TMPL_SEKOMX_BF10Y_SYNT-->CM_BONDFUT_CS_FWD_SYNT_DMTM

	fiws: fwd_y_style_ == not pf_style
*/


//-----------------------------------------------------------------------
//  class bond_future
//----------------------------------------------------------------------
class bond_future: public instrument
option(category: "Instrument/Bond Future")
//option(allow_undeclared_mfuncs)
{
public:

	//override string	instr_type_s();
	override instrument 	inst();

/*	--------------------------------
	---OVERRIDES (HIDDEN IN ROOT) + LOCALS--- 
	--------------------------------
		- overrides are implemented in root for backward compat reasons
*/
	
	//-----add-funcs-----
	override void 			add_nominal(number );
	void 					add_quote(number );				/*set cpn to quote removed --> local*/
		
	void 					add_quote_deliverables(vector(number), error_info option(nullable) error = null<error_info> );
	void 					add_quote_deliverable(integer, number, error_info option(nullable) error = null<error_info> );
	void					add_repo_quote(integer,number option(nullable), day_count_method option(nullable) ,logical,error_info option(nullable) error = null<error_info>);
	void					add_repo_quotes(vector(number) option(nullable), day_count_method option(nullable) ,logical,error_info option(nullable) error = null<error_info>);
	
	//-----general-----
	override string 		maturity_code(error_info option(nullable) error = null<error_info> );
	override date 			settle_date(error_info option(nullable) error = null<error_info> );			/*hidden*/
	logical 				is_daily_mtm(error_info option(nullable) error = null<error_info>  );		/*impl. in root with "fut_" prefix*/		
	number 					tick_value(number,error_info option(nullable) error = null<error_info> );	/*impl. in root with "fut_" prefix*/
	number 					tick_size(error_info option(nullable) error = null<error_info> );			/*impl. in root with "fut_" prefix*/
	number 					contract_size(error_info option(nullable) error = null<error_info>  );		/*impl. in root with "fut_" prefix*/
	date 					synt_maturity(error_info option(nullable) error = null<error_info> );		/*local impl.*/	
	date 					last_trade_date(error_info option(nullable) error = null<error_info> );		/*local impl.*/
	date 					expiry_settle_date(error_info option(nullable) error = null<error_info> );	/*local impl.*/
	date 					settle_date_deliv(error_info option(nullable) error = null<error_info> );	/*local impl.*/
	vector(number) 			price_factor_v(error_info option(nullable) error = null<error_info> );		/*local impl.*/
	vector(string) 			deliverable_v_s(error_info option(nullable) error = null<error_info> );		/*local impl.*/
	vector(bond) 			deliverable_v();															/*local impl.*/
	bond_fut_style 			style(error_info option(nullable) error = null<error_info> );				/*local impl.*/
	logical 				is_price_factor_style(error_info option(nullable) error = null<error_info>);			/*local impl.*/
	
	//-----cashflow-funcs (post_settle and keep_size not relevant for futures)-----
	vector(date) 			cash_flow_dates(logical , error_info option(nullable) error = null<error_info> );
	vector(number) 			cash_flows(number option(nullable), error_info option(nullable) error = null<error_info> );
	void  					cash_flow_data(	number option(nullable), ir_cf_code, logical, out vector(date)   option(nullable),
											out vector(number) , error_info option(nullable) error = null<error_info>);

	//--fixed income: risk--
	/*??? mac_dur, mod_dur etc*/
protected:
	override number 		pvbp(number option(nullable),number option(nullable),logical option(nullable),
								 logical option(nullable),	error_info option(nullable) error = null<error_info> ) ;
	override number 		pvbp(number option(nullable),number option(nullable), error_info option(nullable) error = null<error_info> ) ;
	
public:

	number 					pvbp_fut(	bond_fut_pvbp,number,number option(nullable) delta = 0.0001,logical option(nullable) centered = false,
										logical option(nullable) disable_rounding = null<logical> , error_info option(nullable) error = null<error_info> ) ;
	number 					pvbp_fut(	integer,bond_fut_pvbp,number,number option(nullable) delta = 0.0001,logical option(nullable) centered = false,
										logical option(nullable) disable_rounding = null<logical> , error_info option(nullable) error = null<error_info> ) ;
	number 					pvbp_fut(	bond option(nullable)	,number option(nullable) ,number option(nullable),day_count_method option(nullable) ,
										bond_fut_pvbp,number,number option(nullable) delta = 0.0001,logical option(nullable) centered = false,
										logical option(nullable) disable_rounding = null<logical> , error_info option(nullable) error = null<error_info> ) ;	

	number 					pvbp(	number	option(nullable) ,number option(nullable) ,logical option(nullable) ,error_info option(nullable) error= null<error_info>) ;
	number 					pvbp(	integer,number	option(nullable) ,number option(nullable) ,logical option(nullable) ,error_info option(nullable) error= null<error_info>) ;	
	number 					pvbp(	bond option(nullable)	,number option(nullable),number option(nullable) nominal = 100,
									number option(nullable) delta = 0.0001,	logical option(nullable) centered = false,
									logical option(nullable)  disable_rounding = null<logical>,error_info option(nullable) error = null<error_info> ) ;

	number					pvbp_fwd_del(number	option(nullable) nominal = 100,number option(nullable) delta = 0.0001 ,
										 error_info option(nullable) error = null<error_info>  ) ;
	number					pvbp_fwd_del(integer,number	option(nullable) nominal = 100,number option(nullable) delta = 0.0001 ,
										 error_info option(nullable) error = null<error_info>  ) ;	
	number 					pvbp_fwd_del(bond option(nullable),number option(nullable),number option(nullable) ,
										number option(nullable) ,day_count_method option(nullable),number option(nullable) nominal = 100,
										number option(nullable) 	delta = 0.0001, logical option(nullable) 	centered = false,
										logical option(nullable) 	disable_rounding = null<logical>, error_info option(nullable) error = null<error_info> ) ;

	number					pvbp_inferred(number option(nullable) nominal = 100, number option(nullable) delta = 0.0001 ,
										  logical option(nullable) = null<logical>, error_info option(nullable) error = null<error_info> ) ;
	number					pvbp_inferred(integer, number option(nullable) nominal = 100, number option(nullable) delta = 0.0001 ,
										  logical option(nullable) = null<logical>,  error_info option(nullable) error = null<error_info> ) ;
	number 					pvbp_inferred(	bond option(nullable), number option(nullable),
											number option(nullable)	 	nominal = 100, number option(nullable) 	delta = 0.0001,
											logical option(nullable) 	centered = false, logical option(nullable) 	disable_rounding = null<logical>,
											error_info option(nullable) error = null<error_info> ) ;	

	number 					pvbp_synt(	number option(nullable)	 	nominal = 100, number option(nullable) 	delta = 0.0001,
										logical option(nullable) 	centered = false, logical option(nullable) 	disable_rounding = null<logical>,
										error_info option(nullable) error = null<error_info> ) ;

	number					pvbp_effective(number	option(nullable) nominal = 100,number option(nullable) delta = 0.0001,
										   logical option(nullable) = null<logical>,error_info option(nullable) error = null<error_info>  ) ;
	number					pvbp_effective(integer,number	option(nullable) nominal = 100,number option(nullable) delta = 0.0001,
										   logical option(nullable) = null<logical>,error_info option(nullable) error = null<error_info>  ) ;
	number 					pvbp_effective(	bond option(nullable),number option(nullable),number option(nullable) ,										
											day_count_method option(nullable),number	option(nullable) 	repo_shift = 0.0001,
											number	option(nullable) 	bond_shift = 0.0001, number option(nullable)	 	nominal = 100,										
											logical option(nullable) 	centered = false, logical option(nullable) 	disable_rounding = null<logical>,
											error_info option(nullable) error = null<error_info> );
	
	number 					hdg_ratio_ctd(logical  ,logical option(nullable) = null<logical> ,error_info option(nullable) error = null<error_info>) ;
	number					hdg_ratio_ctd(integer , logical , logical option(nullable) = null<logical>	,error_info option(nullable) error= null<error_info>);
	number 					hdg_ratio_ctd(	bond option(nullable),number option(nullable) ,number option(nullable),day_count_method option(nullable),																												
											logical option(nullable) ,logical option(nullable) ,error_info option(nullable) error = null<error_info>) ;

	number 					hdg_ratio_pvbp(logical option(nullable) = null<logical>,error_info option(nullable) error = null<error_info>) ;
	number 					hdg_ratio_pvbp(integer,logical option(nullable) = null<logical>,error_info option(nullable) error = null<error_info>) ;
	number 					hdg_ratio_pvbp(	bond option(nullable),number option(nullable) ,number option(nullable),day_count_method option(nullable),																												
											logical option(nullable) ,error_info option(nullable) error = null<error_info>) ;

	override number 		mac_dur(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) error = null<error_info>);	
	override number 		mod_dur(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) error = null<error_info>);	
	override number 		dol_dur(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) error = null<error_info>);			
	override number 		convexity(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) error = null<error_info>);	
	override number 		dol_convexity(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) error = null<error_info>);	
	override number 		sensitivity(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) error = null<error_info>);
	
	//--fixed income: price--
	//void 					fwd_p( out number ,out number ,error_info option(nullable) error = null<error_info>);
	override number 		yield(logical dr = false, error_info option(nullable) error = null<error_info> );									
	override number 		yield(disc_func,logical disable_rounding = false , error_info option(nullable) error = null<error_info>);

	override number 		price_to_yield(number ,..quote_style,
									   error_info option(nullable) error = null<error_info>);
		
	override number 		dirty_price_to_yield(number ,logical,
											 error_info option(nullable) error = null<error_info>);						/*legacy, unhidden because of vba*/
	override number 		clean_price_to_yield(number ,logical,
											 error_info option(nullable) error = null<error_info>);						/*legacy, unhidden because of vba*/

	//price
	override number  		dirty_price(number option(nullable) ,logical disable_rounding = false,
										logical in_pcnt = true,
										error_info option(nullable) error = null<error_info>);
	override number 		dirty_price(logical disable_rounding = false,logical in_pcnt = true,
										error_info option(nullable) error = null<error_info>);	
	override number 		dirty_price(disc_func,logical disable_rounding = false,
										logical in_pcnt = true,
										error_info option(nullable) error = null<error_info>);
	
	override number 		clean_price(number option(nullable),logical disable_rounding = false,
										logical in_pcnt = true,
										error_info option(nullable) error = null<error_info>);
	override number 		clean_price(logical disable_rounding = false,logical in_pcnt = true,
										error_info option(nullable) error = null<error_info>);														
	override number 		clean_price(disc_func,logical disable_rounding = false,
										logical in_pcnt = true,
										error_info option(nullable) error = null<error_info>);
		
	override number 		yield_to_price(number ,..quote_style,
									   error_info option(nullable) error = null<error_info>);
	
	
	/*local impl.*/
	integer					del_index(instrument_name,error_info option(nullable) error = null<error_info>);
	day_count_method 		repo_dc_method(error_info option(nullable) error = null<error_info> );

	bond 					deliv(integer,error_info option(nullable) error = null<error_info> );
	bond 					deliv_fwd(integer,error_info option(nullable) error = null<error_info> );
	bond					deliv_fwd(bond option(nullable),number option(nullable),error_info option(nullable) error = null<error_info>);
	bond 					ctd(out number, out integer, error_info option(nullable) error = null<error_info> );
	number 					repo( integer, error_info option(nullable) error = null<error_info> );
	number 					repo_ctd(error_info option(nullable) error = null<error_info> );
	number 					price_factor(integer, error_info option(nullable) error = null<error_info> );
	number 					price_factor_ctd(error_info option(nullable) error = null<error_info> );
	
	number 					imp_repo(error_info option(nullable) error = null<error_info> );
	number 					imp_repo(integer,error_info option(nullable) error = null<error_info> );
	number 					imp_repo(bond option(nullable),number option(nullable), day_count_method option(nullable),
									 error_info option(nullable) error = null<error_info> );
	vector(number) 			imp_repo(vector(bond) option(nullable),vector(number) option(nullable) 	,day_count_method option(nullable),
									error_info option(nullable) error = null<error_info>);

	void  					imp_repo_ext(out number, out number	,out number,out number, out number ,out number,out number,
										out number,out number,out number, out number	,error_info option(nullable) error = null<error_info> );
	void  					imp_repo_ext(integer,out number, out number	,out number,out number, out number ,out number,out number,
										out number,out number,out number, out number	,error_info option(nullable) error = null<error_info> );
	void  					imp_repo_ext(bond option(nullable),number option(nullable),day_count_method option(nullable) ,
										 out number, out number	,out number,out number, out number ,out number,out number,
										out number,out number,out number, out number	,error_info option(nullable) error = null<error_info> );
	

	number 					repo_sens(	integer,
										number option(nullable)	,number option(nullable) ,logical option(nullable) = null<logical> ,
										error_info option(nullable) error = null<error_info>);
	number 					repo_sens(	bond option(nullable),number option(nullable),day_count_method option(nullable)	,
										number option(nullable)	,number option(nullable) ,logical option(nullable) = null<logical>,
										error_info option(nullable) error = null<error_info>);

	number 					ctd_y_sens(	integer	,
										number option(nullable)	,number option(nullable) ,logical option(nullable) = null<logical>,
										error_info option(nullable) error = null<error_info>);
	number 					ctd_y_sens(	bond option(nullable),number option(nullable),number option(nullable),day_count_method option(nullable)	,
										number option(nullable)	,number option(nullable) ,logical option(nullable) = null<logical>,
										error_info option(nullable) error = null<error_info>);

	number 					fut_y_sens(	integer	,
										number option(nullable)	,number option(nullable) ,logical option(nullable) = null<logical>,
										error_info option(nullable) error = null<error_info>);
	number 					fut_y_sens(	bond option(nullable),number option(nullable),number option(nullable),day_count_method option(nullable)	,
										number option(nullable)	,number option(nullable) ,logical option(nullable) = null<logical>,
										error_info option(nullable) error = null<error_info>);

	
	void 					imp_fut(number option(nullable),out number,out number, error_info option(nullable) error = null<error_info>  );
	void 					imp_fut(integer,number option(nullable), out number,out number, error_info option(nullable) error = null<error_info>  );
	void 					imp_fut(bond option(nullable),number option(nullable),number option(nullable) ,
									number option(nullable) , day_count_method option(nullable) ,
									out number,out number, error_info option(nullable) error = null<error_info> );

	void					imp_fut_ext(number option(nullable),out number	,out number,out number, out number ,out number,out number,
										out number,out number,out number, error_info option(nullable) error = null<error_info> );
	void					imp_fut_ext(integer,number option(nullable),out number	,out number,out number, out number ,out number,out number,
										out number,out number,out number, error_info option(nullable) error = null<error_info> );	
	void					imp_fut_ext(bond option(nullable),number option(nullable) ,number option(nullable) ,
										number option(nullable) ,day_count_method option(nullable) ,								
										out number	,out number,out number, out number ,out number,out number,
										out number,out number,out number, error_info option(nullable) error = null<error_info> );

	void 					imp_spot(number option(nullable),out number,out number, error_info option(nullable) error = null<error_info>  );
	void 					imp_spot(integer,number option(nullable),out number,out number, error_info option(nullable) error = null<error_info>  );
	void 					imp_spot(bond option(nullable),number option(nullable),number option(nullable) ,
									number option(nullable) , day_count_method option(nullable) ,
									out number,out number, error_info option(nullable) error = null<error_info> );
		
	void 					funding(number option(nullable)	,number option(nullable) ,
									day_count_method option(nullable) ,out number,out number,out number,out number ,out number,
									out number,out number	,out number	,out number,out number,out number,error_info option(nullable) error = null<error_info> );
	void 					funding(integer,number option(nullable)	,number option(nullable) ,
									day_count_method option(nullable) ,out number,out number,out number,out number ,out number,
									out number,out number	,out number	,out number,out number,out number,error_info option(nullable) error = null<error_info> );
	void 					funding(bond option(nullable),number option(nullable),number option(nullable)	,number option(nullable) ,
									day_count_method option(nullable) ,out number,out number,out number,out number ,out number,
									out number,out number	,out number	,out number,out number,out number,error_info option(nullable) error = null<error_info> );

	void 					funding_1day(number option(nullable)	,number option(nullable) ,
									day_count_method option(nullable) ,out number,out number,out number,out number ,out number,
									out number,out number	,out number	,out number,out number,out number,out integer,error_info option(nullable) error = null<error_info> );
	void 					funding_1day(integer,number option(nullable)	,number option(nullable) ,
									day_count_method option(nullable) ,out number,out number,out number,out number ,out number,
									out number,out number	,out number	,out number,out number,out number,out integer,error_info option(nullable) error = null<error_info> );
	void 					funding_1day(bond option(nullable),number option(nullable),number option(nullable)	,number option(nullable) ,
									day_count_method option(nullable) ,out number,out number,out number,out number ,out number,
									out number,out number	,out number	,out number,out number,out number,out integer, error_info option(nullable) error = null<error_info> );

	number 					settle_amount(	number, number option(nullable)	contract_quote= null<number>, number option(nullable) nominal = 100,											
											logical disc_to_trade = false, disc_func option(nullable) disc_func = null<disc_func>,
											error_info option(nullable) error = null<error_info>  );
	
	number 					disc_fact(number option(nullable) , error_info option(nullable) error = null<error_info>);
	number  				pl_yfut_chg(	number,logical option(nullable), number option(nullable) ,date option(nullable),number ,
											logical ,logical,error_info option(nullable) error = null<error_info>);

/*	--------------------------------
	---OVERRIDES (PUBLIC i.e. NOT HIDDEN IN ROOT) --- 
	--------------------------------
		-implemented in root
		-required
*/

	override bond_future 	set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);
	override bond_future 	set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);
	//override bond_future 		set_quote_from_yield(...) in protected
	override number 		quote(error_info option(nullable) error = null<error_info>   );	

/*	--------------------------------
	---OVERRIDES (HIDDEN IN ROOT, THROWS IN ROOT) --- 
	--------------------------------
		-implemented in root with "-" prefix
		-here if applicable
*/
	
	override bond_future	set_yield(number option(nullable) ,error_info option(nullable) error = null<error_info> );
	bond_future 			set_clean_price(number option(nullable), date option(nullable) = null<date> ,
												error_info option(nullable) error = null<error_info> );				
	
/*	--------------------------------
	---LOCALS (NOT EXPOSED IN ROOT) 
	--------------------------------
		-implemented in root with "-" prefix
		-here if applicable
*/
	bond_future 			set_quote(number option(nullable), date  option(nullable) , logical option(nullable),
									  error_info option(nullable) error = null<error_info>);
	bond_future 			set_quote(string option(nullable),  date  option(nullable) , logical option(nullable),
									  error_info option(nullable) error = null<error_info>);
	
	bond_future 			set_date(date,logical,logical, error_info option(nullable) error = null<error_info>  );
	
	
//constructors are public (but hidden since the creation must be via "constructor functions") 
	bond_future(__instrument,string option(nullable));
	bond_future(__instrument,vector(string),string option(nullable),vector(number) option(nullable),vector(number) option(nullable) ,day_count_method option(nullable) );
	bond_future(__instrument,vector(bond),vector(number) option(nullable),vector(number) option(nullable) ,day_count_method option(nullable));	
	override bond_future clone();
	bond_future(bond_future);
protected:
	
	override instrument  		create(	__instrument option(nullable),out instr_error option(nullable),
											error_type type = E_INVALID_ARG);
	bond_future					create(__instrument option(nullable),vector(bond) ,vector(number) option(nullable) ,
										   vector(number) option(nullable) ,
											day_count_method option(nullable), out instr_error option(nullable),
										   error_type type = E_INVALID_ARG);
	
	void						init_del(__instrument,vector(string) option(nullable), string option(nullable)  );
	void						init_ctd();
	void 						copy_data(bond_future);
	void 						compare_del_list();
	void 						verify_del(logical verify_db);
	logical						del_v_is_valid();
	void 						check_index(integer);
	void						index_to_data(integer , out bond , out number , out number );
	void						func_helper_ctd( out bond ,out number ,out number ,out day_count_method ,out logical );
	
	void						ctd(vector(bond),vector(number) option(nullable) ,vector(number) option(nullable),day_count_method ,
										out integer,out vector(number)  ,logical ,
										error_info option(nullable) error = null<error_info>  );

	override void 				add_quote(number,logical option(nullable) set_to_par  );
	override void 				add_quote_from_yield(number,logical option(nullable) );
	//-----quote funcs-----
	override number 			quote(disc_func,..quote_style option(nullable),
										error_info option(nullable) error = null<error_info> );
	
	override number 			face_amount(error_info option(nullable) error = null<error_info>);
	
	override date 				issue_date(error_info option(nullable) error = null<error_info> );
	
	override vector(date)		cash_flow_dates(logical ,logical, logical,
												error_info option(nullable) error = null<error_info>);

	override vector(number)		cash_flow_amounts(	number option(nullable) ,logical ,logical ,
													error_info option(nullable) error = null<error_info> );
	
	override vector(number)		cash_flows_cpn(number option(nullable),logical ,logical,
											   error_info option(nullable) error = null<error_info>);
	
	override vector(number)		cash_flows(number option(nullable),logical ,logical,
										   error_info option(nullable) error = null<error_info>);	
	
	override void 				cash_flow_data(	number option(nullable) ,logical ,ir_cf_code ,logical,logical ,
												out vector(date)   ,
												out vector(number)   ,
												error_info option(nullable) error = null<error_info>);
	
	
	override bond_fut_style 	bondfut_style(error_info option(nullable) error = null<error_info> );
	override vector(string) 	bondfut_deliverables(error_info option(nullable) error = null<error_info> );
	override vector(string) 	deliverables();																				/*legacy, backward compat to really old version*/
	override vector(number) 	bondfut_price_factors(error_info option(nullable) error = null<error_info>  );
	override vector(number) 	price_factors();																			/*legacy, backward compat to really old version*/
	override date 				bondfut_synt_maturity(error_info option(nullable) error = null<error_info> );
	override date 				bondfut_expiry_settle_date(error_info option(nullable) error = null<error_info> );

	void 						add_r(vector(number), logical);
	bond_future 				err_type(bond_future option(nullable), error_info option(nullable),string option(nullable) f = null<string>);
	
	/*set*/
	override bond_future 		set_clean_price(number option(nullable), date option(nullable), date option(nullable) ,
												error_info option(nullable) error = null<error_info> );				
	
	override bond_future 		set_quote_from_yield(number option(nullable) ,
													error_info option(nullable) error = null<error_info>);			/*legacy, hidden in root*/
	
	override bond_future 		set_date(date, date option(nullable) settle_date=null<date>,
										logical re_init_static = true, logical init_quote = true,
										error_info option(nullable) error = null<error_info> );
	
	override bond_future 		set_date(date,logical , error_info option(nullable) error = null<error_info> );		/*legacy*/
	override bond_future 		move_date(date, date option(nullable) settle_date=null<date>,
											error_info option(nullable) error = null<error_info> );					/*legacy*/

	//void 						set_date_deliverables(	date,logical,logical ,error_info option(nullable) 	error);
	override number 			mac_dur_analytic(error_info option(nullable) error = null<error_info>);									/*legacy*/
	override number 			mod_dur_analytic(error_info option(nullable) error = null<error_info>);									/*legacy*/
	override number 			dol_dur_analytic(error_info option(nullable) error = null<error_info>);									/*legacy*/
	override number 			pvbp_analytic(number option(nullable) nom = null<number>,
										error_info option(nullable) error = null<error_info>);											/*legacy*/
	override number 			convexity_analytic(error_info option(nullable) error = null<error_info>);								/*legacy*/
	override number 			dol_convexity_analytic(error_info option(nullable) error = null<error_info>);							/*legacy*/
	override number 			sensitivity_analytic(error_info option(nullable) error = null<error_info>);								/*legacy*/
	
//private:
	vector(bond) 	deliv_v_;
	vector(number) 	pf_v_;
	vector(number) 	repo_rates_;
	day_count_method repo_dc_;
	logical			null_quote_exist_;
	integer			ctd_idx_;
	    
};

//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
bond_future.bond_future(__instrument i, string option(nullable) del_qs) option(hidden)
						:instrument(i),
						 repo_rates_(null<vector(number)>),
						 repo_dc_(DC_ACT_360),
						 null_quote_exist_(false),
						 ctd_idx_(err_int())
{
	instr_error  error = instr_error();
	if(!i.is_valid(error))
		QL_FAIL(error.message(), E_INIT) ;
	
	error_info  ee = error_info(true,false);
	vector(string) del 	= this.deliverable_v_s(ee);//this.instr_def().assoc_instrs(error);   
	pf_v_ 				= this.price_factor_v(ee);//this.instr_def().assoc_factors(error);	
	init_del(i,del, del_qs);
	verify_del(false);
	init_ctd();	
}
/*-----------------------------------------------------------------------
  constructor [HIDDEN, cannot be protected]
  ----------------------------------------------------------------------*/
bond_future.bond_future(__instrument 						i,
						vector(bond) 						delb,
						vector(number) option(nullable) 	pf,
						vector(number) option(nullable) 	repo_rates,
						day_count_method option(nullable) 	repo_dc ) option(hidden)
						: instrument(i),
						deliv_v_(clone_vector(delb)), 
						pf_v_(CORE_INT.clone_vector(pf)),
						repo_rates_(CORE_INT.clone_vector(repo_rates)),
						repo_dc_(null(repo_dc ) ? DC_ACT_360: repo_dc ),
						null_quote_exist_(false),
						ctd_idx_(err_int())

{
	instr_error  error = instr_error();
	if(!i.is_valid(error))
		QL_FAIL(error.message(), E_INIT) ;

	if(null(deliv_v_) || v_size(deliv_v_) == 0){
		resize(pf_v_,0);
		resize(repo_rates_,0);
		return;
	}
	
	integer n = v_size(deliv_v_);	
	error_info e = error_info(true,true);
	
	for (integer j = 0 ; j < n ; j++) {
		if(null(deliv_v_[j]))
			QL_FAIL( "invalid instrument in deliverable bond vector (null instrument)", this, true, E_INIT) ;
		if(!deliv_v_[j].is_valid(e))
			QL_FAIL(strcat(["invalid instrument in deliverable bond vector (",e.message(),")"]), this, true, E_INIT) ;
			
	}
	
	vector(string) del = deliv_v_.name(e);
	QL_REQUIRE(v_size(v_find_uniquei(del)) == n,"deliverable bond vector contains duplicate names", this, true, E_INIT) ;

/*
	check for duplicate bonds
*/			
	verify_del(false);	
	init_ctd();	
}
/*-----------------------------------------------------------------------
  constructor [HIDDEN, cannot be protected]
  ----------------------------------------------------------------------*/
bond_future.bond_future(__instrument 						i,
						vector(string) 						del,
						string		option(nullable) 		del_qs,
						vector(number) option(nullable) 	pf,
						vector(number) option(nullable) 	repo_rates,
						day_count_method option(nullable) 	repo_dc ) option(hidden)
						: instrument(i),
						  pf_v_(CORE_INT.clone_vector(pf)),
						  repo_rates_(CORE_INT.clone_vector(repo_rates)),
						  repo_dc_(null(repo_dc ) ? DC_ACT_360: repo_dc ),
						  null_quote_exist_(false),
						  ctd_idx_(err_int())
{
	instr_error  error = instr_error();
	if(!i.is_valid(error))
		QL_FAIL(error.message(), E_INIT) ;
	
	init_del(i,del, del_qs);
	verify_del(false);	
	init_ctd();	
}

/*-----------------------------------------------------------------------
  init_del
  ----------------------------------------------------------------------*/
void bond_future.init_del(__instrument i,vector(string) option(nullable) del, string option(nullable) del_qs)  
{
	instr_error error = instr_error();
	if(!i.is_valid(error))
		QL_FAIL(error.message(), E_INIT) ;
	
	if(null(del) || v_size(del) == 0){
		resize(deliv_v_,0);
		resize(pf_v_,0);
		resize(repo_rates_,0);
		return;
	}

	integer n = v_size(del);
	
	for (integer j = 0 ; j < n ; j++) 		
		QL_FAIL_COND(null(del[j]) || strlen(del[j]) == 0, "invalid name in deliverable bond vector",this, true, E_INIT) ;

    QL_REQUIRE(CORE_INT.is_unique(del),"deliverable bond vector contains duplicate names", this, true, E_INIT) ;

	resize(deliv_v_,n);
	instr_error_type t;
   	string s;	

	date td	= i.__trade_date(t,s);
	error = new instr_error(t,s);
	QL_FAIL_COND(error.is_error(), "invalid instrument", this, true) ;
	
	//date sd;
	//sd = i.__settle_date(t,s);
	//error = new instr_error(t,s);
	//QL_FAIL_COND(error.is_error(), "invalid instrument", nm, true) ;

	for (integer j = 0 ; j < n ; j++) {				
		__instrument b = __instrument(del[j], td,del_qs,null<date>);
		QL_FAIL_COND(null(b), "invalid instrument in deliverable bond vector",E_INIT );
		string bnm = b.__name(t,s);
		if(!b.is_valid(error))
			QL_FAIL(strcat(["invalid instrument in deliverable bond vector (",error.message(),")"]),bnm, true,E_INIT );
		QL_FAIL_COND(b.__instr_type() != ..__instr_type.FIXED_CPN_BOND, "invalid instrument type in deliverable bond vector",bnm, true,E_INIT );
		
		deliv_v_[j] = new bond(b);
	}

	return;
}

/*-----------------------------------------------------------------------
  verify_del
  ----------------------------------------------------------------------*/
void bond_future.verify_del(logical verify_db)
{
	if(verify_db)
		compare_del_list();

	error_info error 		= error_info(true,false);
	
	date fwd_settle_date  	= this.expiry_settle_date(error);
	date trade_date	    	= this.trade_date(error);	
    logical is_static 		= null(trade_date); 
    logical upd_td 			= true;

	error_info e = error_info(true,true);
	string nm = this.name(e);
	
	if(!is_static)
		QL_REQUIRE(!null(fwd_settle_date),"invalid expiry settlement date",nm,true, E_INIT);	
		
	integer n = v_size(deliv_v_);
	if(n==0)
		return;

	string curr = this.currency(error);
	CORE_INT.instr_fail_check(null(curr), "invalid currency", nm, error);

	date deliv_settle;
	for (integer i = 0 ; i < n ; i++) {
		
		date td = deliv_v_[i].trade_date(error);
		
		if(!is_static && upd_td && (null(td) || trade_date != td)){
			deliv_v_[i] = deliv_v_[i].set_date(trade_date, null<date>,false,true,error);
			QL_REQUIRE(!null(deliv_v_[i]),"failed to update trade date (deliverable)",nm,true , E_INIT);
			td = deliv_v_[i].trade_date(error);
		}

		string dnm = deliv_v_[i].name(e);
		
		if(!is_static) {			
			QL_REQUIRE(fwd_settle_date < deliv_v_[i].maturity(),"invalid maturity (deliverable)",dnm,true, E_INIT );
			QL_REQUIRE(!null(td),"invalid trade date (null)",deliv_v_[i].name(),true, E_INIT);			
			QL_REQUIRE(trade_date == td,"invalid trade date (not equal to futures trade date)",dnm,true , E_INIT);
	   	}

		number q = deliv_v_[i].quote(error);
		if(null(q)) null_quote_exist_ = true;

	    if(i==0) {
			deliv_settle = deliv_v_[i].settle_date(error);
			if(!is_static) {
				QL_REQUIRE(!null(deliv_settle),"invalid settlement date (null)",dnm,true, E_INIT);
				QL_REQUIRE(fwd_settle_date >= deliv_settle, "invalid settlement date (settle date after futures settle date)",dnm,true, E_INIT);					
		 	}									
			QL_REQUIRE(strcmp_casei(curr , deliv_v_[i].currency()) == 0,"currency mismatch (deliverable)",dnm,true, E_INIT ) ;
	    }
	    else { 
			date ds = deliv_v_[i].settle_date(error);
			if(!is_static) {
				QL_REQUIRE(!null(ds ),"invalid settlement date (null)",dnm,true, E_INIT);
				QL_REQUIRE(deliv_settle == ds ,"invalid settlement date (deliverable-all bonds must have same settlement date)",dnm,true, E_INIT );				
			}			
			QL_REQUIRE(strcmp_casei(curr , deliv_v_[i].currency()) == 0,"currency mismatch (deliverable)",dnm,true , E_INIT) ;
		}					       
	}

	bond_fut_style bfs = this.style(error) ;
	CORE_INT.instr_fail_check(null(bfs), "invalid bond future style", nm, error);

	if(bfs == bond_fut_style.PRICE_FACTOR_MTM) {
		if(n > 0) 		
			QL_REQUIRE(!null(pf_v_) && v_size(pf_v_) == n,"invalid price factor vector",nm,true, E_INIT ) ;
		for (integer i = 0 ; i < n ; i++) {
			string dnm = deliv_v_[i].name(e);
			QL_REQUIRE(!null(pf_v_[i]) && pf_v_[i] > 0 ,"invalid price factor",dnm,true, E_INIT );
		}
	}

	if(n>0){
		if(null(repo_rates_) || v_size(repo_rates_) == 0) 
			repo_rates_ = one_vector(n,0);
		else {
			QL_REQUIRE(v_size(repo_rates_) == n,"invalid repo rate vector (wrong size)",nm,true, E_INIT ) ;
			for (integer i = 0 ; i < n ; i++) 
				QL_REQUIRE(!null(repo_rates_[i]) ,"invalid repo rate",nm,true , E_INIT);
		}
	}
}
/*-----------------------------------------------------------------------
  bond_future: init_ctd
  ----------------------------------------------------------------------*/
void bond_future.init_ctd()
{	
	if(!del_v_is_valid()) {
		ctd_idx_ = err_int();
		return;
	}
		
	try {
		vector(number) imp_repo;
		instr_error_type t;
		string 			s;
		i().__bondfut_ctd(CORE_INT.get_instruments(deliv_v_),pf_v_,repo_rates_,repo_dc_,ctd_idx_,imp_repo,false, t, s);
		instr_error e = new instr_error(t,s);
	
		if(e.is_error()) 		
			ctd_idx_ = err_int();
		
		return ;
	}
	catch {
		ctd_idx_ = err_int();
	}
}
/*-----------------------------------------------------------------------
  constructor
  ----------------------------------------------------------------------*/
bond_future.bond_future(bond_future c) 
					: instrument(c),deliv_v_(CORE_INT.clone_vector(c.deliv_v_)), 
					pf_v_(CORE_INT.clone_vector(c.pf_v_)), 
					repo_rates_(CORE_INT.clone_vector(c.repo_rates_)), 
					repo_dc_(this.repo_dc_),null_quote_exist_(c.null_quote_exist_),
					ctd_idx_(c.ctd_idx_) {}
/*-----------------------------------------------------------------------
  inst()
  ----------------------------------------------------------------------*/
instrument 	bond_future.inst()		{ return this;}
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string bond_future.instr_type_s()  	{ return string(..instr_type.BOND_FUTURE);}
//------------------------------------------------
// del_v_is_valid
//------------------------------------------------
logical	bond_future.del_v_is_valid(){ return !null_quote_exist_ && !null(deliv_v_) && v_size(deliv_v_)>0;}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
bond_future bond_future(bond_future bf)		{ return new bond_future(bf);}
//------------------------------------------------
// clone
//------------------------------------------------
bond_future bond_future.clone()				{ return new bond_future(this);}
//-----------------------------------------------
// dynamic cast <FUNCTION>
//-----------------------------------------------
bond_future	bond_future(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Bond Future')
option(com_name: 'bond_future_dyncast')
{ 
	try {
		bond_future d = dynamic_cast<bond_future>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a bond_future)","bond_future" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future");
		return null<bond_future>;
	}
}

/*-----------------------------------------------------------------------
  create  [PROTECTED]
  create bond_future from internal instrument
  is called from all "set" functions and "set" functions creates a copy
  bond_future have state both in the instr.dll and here
  ----------------------------------------------------------------------*/
instrument bond_future.create(	__instrument option(nullable) 		c,
								out instr_error option(nullable) 	error,
								error_type 							type )
{
	return create(c,this.deliv_v_, this.pf_v_, this.repo_rates_, this.repo_dc_,error,type );
}
/*-----------------------------------------------------------------------
  create  [PROTECTED]
  create bond_future from internal instrument
  ----------------------------------------------------------------------*/
bond_future bond_future.create(	__instrument option(nullable) 		c,
								vector(bond) 						delb,
								vector(number) option(nullable) 	pf,
								vector(number) option(nullable) 	repo_rates,
								day_count_method option(nullable) 	repo_dc,
								out instr_error option(nullable) 	error,
								error_type 							type ) 
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<bond_future>; 
		
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.BOND_FUTURE, "invalid instrument type",type );//should not happen	
	
	return new bond_future(c, delb, pf, repo_rates, repo_dc);

}


/*-----------------------------------------------------------------------
  create_bond_future  
  ----------------------------------------------------------------------*/
bond_future create_bond_future(	__instrument option(nullable)	 	c,
								string option(nullable) 			del_qs,
								out instr_error option(nullable) 	error,
								error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_bond_future')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<bond_future>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.BOND_FUTURE, "invalid instrument type",type );//should not happen
	
	return new bond_future(c,del_qs);
}

bond_future create_bond_future(	__instrument option(nullable) 		c,
								string option(nullable) 			del_qs,
								error_info option(nullable) 		error,
								error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_bond_future_ei')
{
	instr_error ee 	= instr_error();
	bond_future b 	= create_bond_future(c,del_qs,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_bond_future");
	return b;
}

/*-----------------------------------------------------------------------
  create_bond_future  (del = vector(string))
  ----------------------------------------------------------------------*/
bond_future create_bond_future(	__instrument option(nullable) 		c,
								vector(string) 						del,
								string option(nullable)				del_qs,
								vector(number) option(nullable) 	pf,
								vector(number) option(nullable) 	repo_rates,
								day_count_method option(nullable) 	repo_dc,
								out instr_error option(nullable) 	error,
								error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_bond_future2')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<bond_future>; 
	
	QL_FAIL_COND(valid && c.instr_type(error) != ..instr_type.BOND_FUTURE, "invalid instrument type",type );//should not happen
	
	return new bond_future(c,del,del_qs,pf,repo_rates,repo_dc);
}

bond_future create_bond_future(	__instrument option(nullable) 		c,
								vector(string) 						del,
								string option(nullable)				del_qs,
								vector(number) option(nullable) 	pf,
								vector(number) option(nullable) 	repo_rates,
								day_count_method option(nullable) 	repo_dc,
								error_info option(nullable) 		error,
								error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_bond_future2_ei')
{
	instr_error ee 	= instr_error();
	bond_future b 	= create_bond_future(c,del,del_qs,pf,repo_rates,repo_dc,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_bond_future");
	return b;
}
/*-----------------------------------------------------------------------
  create_bond_future (del = vector(bond))
  ----------------------------------------------------------------------*/
bond_future create_bond_future(	__instrument option(nullable) 		c,
								vector(bond) 						del,
								vector(number) option(nullable) 	pf,
								vector(number) option(nullable) 	repo_rates,
								day_count_method option(nullable) 	repo_dc,
								out instr_error option(nullable) 	error,
								error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_bond_future3')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<bond_future>; 
	
	QL_FAIL_COND(valid && c.instr_type(error) != ..instr_type.BOND_FUTURE, "invalid instrument type",type );//should not happen
	
	return new bond_future(c,del,pf,repo_rates,repo_dc);
}


bond_future create_bond_future(	__instrument option(nullable) 		c,
								vector(bond) 						del,
								vector(number) option(nullable) 	pf,
								vector(number) option(nullable) 	repo_rates,
								day_count_method option(nullable) 	repo_dc,
								error_info option(nullable) 		error,
								error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_bond_future3_ei')
{
	instr_error ee 	= instr_error();
	bond_future b 	= create_bond_future(c,del,pf,repo_rates,repo_dc,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_bond_future");
	return b;
}

/*-----------------------------------------------------------------------
  compare_del_list  not used
  ----------------------------------------------------------------------*/
void bond_future.compare_del_list()
{
    integer n = v_size(deliv_v_);

	error_info error = error_info(true,true);
	vector(string) db_name 	= this.instr_def(error).assoc_instrs(error);
	//string nm = this.name(error);
	QL_FAIL_COND(null(db_name), error.message(), this, true, E_INIT) ;
	
    integer sa  			= v_size(db_name);
    QL_REQUIRE(sa == n, "size of deliverable bond vector does not match size of deliverable bond vector in database", this, true, E_INIT) ;	    
	
	vector(number) a_f 	= this.instr_def().assoc_factors(error);
	QL_FAIL_COND(null(a_f), error.message(), this, true, E_INIT) ;
    QL_REQUIRE(v_size(a_f) == n, "size of deliverable bond vector does not match size of deliverable bond vector in database", this, true, E_INIT) ;	    
	
    vector(string) b_name;  
    resize(b_name,sa);

    for (integer i = 0 ; i < sa ; i++) {
		QL_REQUIRE(null(db_name[i]),"deliverable bond vector in database contains instrument with invalid name(s)", this, true, E_INIT); 
		//QL_REQUIRE(!!deliv_v_[i]->instr_def()->name(),"deliverable bond vector contains instrument with invalid name(s)") ;	 		
		b_name[i]   = deliv_v_[i].name();
    }

    //db_name_orig    	= clone_vector(db_name);
    //b_name_orig	    	= clone_vector(b_name);
	vector(number) v_o 	= v_find_uniquei(db_name);

    QL_REQUIRE(v_size(v_o) == 0,"deliverable bond vector in database contains duplicate names", this, true, E_INIT) ;
		
	sort_casei(db_name);
	sort_casei(b_name);

    for (integer i = 0 ; i < sa ; i++) 
		QL_REQUIRE(strcmp_casei(db_name[i] , b_name[i]) == 0,"names(s) of deliverable bond vector does not match name(s) of deliverable bond vector in database" , this, true, E_INIT) ;

	//vector(string) db_name_orig,b_name_orig;
	//bond_fut_style del_s = this.style();
	/*logical BFDM_PF_PDEL = true;
	

	if(BFDM_PF_PDEL) {    
		for (integer i = 0 ; i < sa ; i++) {
	    	integer j;
	    	logical ok = match(db_name_orig, b_name_orig[i], j);
	    	if(!ok) OUCH();	
	    		QL_REQUIRE(a_f[j] == pf[i],"price factor(s) of deliverable bond vector does not match price factor(s) of deliverable bond vector in database" ) ;
		}
    }*/
}
/*-----------------------------------------------------------------------
  bond_future: del_index
  ----------------------------------------------------------------------*/
integer bond_future.del_index(instrument_name name, error_info option(nullable) error)
{
	try{
		QL_FAIL_COND(null(deliv_v_),"deliverable vector is null") ;
		
		for (integer i = 0 ; i < v_size(deliv_v_) ; i++) {
			if(strcmp_casei(name , deliv_v_.name()[i]) == 0)
				return i;
		}
		return err_int();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.del_index");
		return err_int();
	}
}
//------------------------------------------------
// check_index
//------------------------------------------------
void bond_future.check_index(integer i)
{
	QL_FAIL_COND(null(deliv_v_),"deliverable vector is null") ;
	QL_FAIL_COND(i == err_int(),"invalid index") ;
	QL_FAIL_COND(i < 0,"invalid index (i < 0)") ;
	QL_FAIL_COND(i >= v_size(deliv_v_),"invalid index (i >= size)") ;
	
	return ;
}
/*-----------------------------------------------------------------------
  bond_future: index_to_data
  ----------------------------------------------------------------------*/
void bond_future.index_to_data(integer idx,
							   out bond b,
							   out number pf,
							   out number repo)
{
	check_index(idx);
	error_info ee 	= error_info(true,false);	
	b 				= deliv_v_[idx];
	logical is_pf 	= is_price_factor_style(ee);
	if(ee.is_error())
		QL_FAIL(strcat(["invalid price factor style [",ee.message(),"]"]), this,true,ee.ql_error_type()) ;
	
	pf 		= is_pf ? pf_v_[idx] : null<number>;
	repo 	= repo_rates_[idx];

	if(!b.is_valid(ee))
		QL_FAIL(strcat(["invalid deliverable bond [",ee.message(),"]"]), this,true,ee.ql_error_type()) ;
}

/*-----------------------------------------------------------------------
  bond_future: settle_date_deliv
  ----------------------------------------------------------------------*/
date bond_future.settle_date_deliv(error_info option(nullable) error)
{
	try {
		QL_FAIL_COND(null(deliv_v_) || v_size(deliv_v_) == 0,"invalid deliverable vector") ;
		return deliv_v_[0].settle_date(error);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.imp_repo");
		return null<date >;
	}
}

/*-----------------------------------------------------------------------
  bond_future: add_quote_deliverables
  ----------------------------------------------------------------------*/
void bond_future.add_quote_deliverables(vector(number) 					quote,						
										error_info option(nullable) 	error)
{	
	try{
		CORE_INT.reset_single(error);
		
		integer n = v_size(deliv_v_);
		QL_REQUIRE(n == v_size(quote),"invalid size of quote vector");
		if(n==0)
			return;
		
		null_quote_exist_ = false;
		for (integer i = 0 ; i < n ; i++) {		
		    
			//QL_REQUIRE(!null(quote[i]),"invalid quote",deliv_v_[i].name(),true );
			if(!null(quote[i]))
				deliv_v_[i].add_quote(quote[i]);
			else
				null_quote_exist_ = null(deliv_v_[i].quote());
		}
		
		init_ctd();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.add_quote_deliverable");
		return ;
	}
}

/*-----------------------------------------------------------------------
  bond_future: add_quote_deliverables
  ----------------------------------------------------------------------*/
void bond_future.add_quote_deliverable( integer idx,
										number	quote,
										error_info option(nullable) error)
{	
	try{
		CORE_INT.reset_single(error);
		
		if(idx == err_int())
			idx = ctd_idx_;
				
		check_index(idx);				
		deliv_v_[idx].add_quote(quote);	    	   				
				
		integer n = v_size(deliv_v_);
		null_quote_exist_ = false;
		error_info ee = new error_info(true,true);
		
		for (integer i = 0 ; i < n ; i++) {		
		    number q = deliv_v_[i].quote(ee);
			
			if(null(q)) {
				null_quote_exist_ = true;
				break;
			}	    	   				
		}

		init_ctd();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.add_quote_deliverable");
		return ;
	}
}
/*-----------------------------------------------------------------------
  bond_future: add_repo_quotes
  ----------------------------------------------------------------------*/
void bond_future.add_repo_quotes(	vector(number)  option(nullable) repo_rates,
									day_count_method option(nullable) repo_dc,
									logical allow_null_rate,
									error_info option(nullable) error)
{	
	try{
		CORE_INT.reset_single(error);

		if(!null(repo_rates))
			add_r(repo_rates, allow_null_rate);
		if(!null(repo_dc))			
			repo_dc_ = repo_dc ;
		init_ctd();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.add_repo_quotes");
		return ;
	}
}

/*-----------------------------------------------------------------------
  bond_future: add_repo_quote
  ----------------------------------------------------------------------*/
void bond_future.add_repo_quote(	integer idx,
									number  option(nullable) repo_rate,
									day_count_method option(nullable) repo_dc,
									logical allow_null_rate,
									error_info option(nullable) error)
{	
	try{
		CORE_INT.reset_single(error);

		if(idx == err_int())
			idx = ctd_idx_;
		
		check_index(idx);
		integer n = v_size(deliv_v_);

		if(n != v_size(repo_rates_)){
			resize(repo_rates_,n);
			repo_rates_ = null<number>;
		}

		if(!null(repo_rate) || allow_null_rate)
			repo_rates_[idx] = repo_rate;
				
		if(!null(repo_dc))			
			repo_dc_ = repo_dc ;
		
		init_ctd();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.add_repo_quote");
		return ;
	}
}
/*-----------------------------------------------------------------------
  bond_future: add_r
  ----------------------------------------------------------------------*/
void bond_future.add_r(	vector(number)  repo_rates, logical allow_null_rate)
{	
	
	integer n = v_size(deliv_v_);
	integer nr = v_size(repo_rates);
	vector(number) r;
	if(n > nr && nr == 1){
		resize(r,n);
		for (integer i = 0 ; i < n ; i++)
			r[i] = repo_rates[0];
		nr = n;
	}
	else
		r = repo_rates;
	
	QL_REQUIRE(n == nr,"invalid repo rate vector (size must be equal to number of deliverable bonds or have size == 1)",this,true);	
	resize(repo_rates_,n);

	for (integer i = 0 ; i < n ; i++){ 
		QL_FAIL_COND(null(r[i]) && !allow_null_rate ,"invalid repo rate",this,true );
		repo_rates_[i] = r[i];
	}
	
}

/*-----------------------------------------------------------------------
  bond_future: deliv
  ----------------------------------------------------------------------*/
bond bond_future.deliv(	integer	idx, error_info option(nullable) error)
{
	CORE_INT.reset_single(error);
		
	try{
		if(idx == err_int())
			idx = ctd_idx_;
		
		number del_pf ;			
		bond b ;
		number r;
		index_to_data(idx, b, del_pf,r);
				
		return b;
				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.deliv");
		return null<bond>;
	}
}

/*-----------------------------------------------------------------------
  bond_future: deliv_fwd
  ----------------------------------------------------------------------*/
bond bond_future.deliv_fwd(	integer	idx, error_info option(nullable) error)
{
	CORE_INT.reset_single(error);
		
	try{
		if(idx == err_int())
			idx = ctd_idx_;
		
		number del_pf ;			
		bond b ;
		number r;
		index_to_data(idx, b, del_pf,r);
				
		return this.deliv_fwd(b,del_pf, error);
				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.deliv_fwd");
		return null<bond>;
	}
}

/*-----------------------------------------------------------------------
  bond_future: deliv_fwd
  ----------------------------------------------------------------------*/
bond bond_future.deliv_fwd(	bond option(nullable)		ctd,
							number option(nullable) 	ctd_price_factor,
							error_info option(nullable) error)
{	
	try{
		number r;
		logical dr;
		day_count_method dc;
		func_helper_ctd(ctd,ctd_price_factor,r,	dc,dr);
		
		instr_error_type t;
   		string 			s;	
		__instrument c = i().__bondfut_del_fwd(ctd.i(),ctd_price_factor,t,s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.deliv_fwd");
		if(e)
			return null<bond>;

		error_info ee 	= error_info(true,true);
		return create_bond(c,ee);										
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.deliv_fwd");
		return null<bond>;
	}
}

/*-----------------------------------------------------------------------
  bond_future: repo
  ----------------------------------------------------------------------*/
number bond_future.repo( integer						idx, 
							error_info option(nullable) error)
{
	try{
		if(idx == err_int())
			idx = ctd_idx_;
		
		check_index(idx);
		return repo_rates_[idx];
	}
	catch {
	
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.repo");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  bond_future: repo_ctd
  ----------------------------------------------------------------------*/
number bond_future.repo_ctd(error_info option(nullable) error)
{
	try{
		QL_REQUIRE(ctd_idx_ != err_int(),"ctd not initialized");
		return repo_rates_[ctd_idx_];
	}
	catch {
	
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.repo_ctd");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  bond_future: price_factor_ctd
  ----------------------------------------------------------------------*/
number bond_future.price_factor_ctd(error_info option(nullable) error)
{
	try{
		QL_REQUIRE(ctd_idx_ != err_int(),"ctd not initialized");
		error_info ee 	= error_info(true,false);	
		logical is_pf 	= is_price_factor_style(ee);
		if(ee.is_error())
			QL_FAIL(strcat(["invalid price factor style [",ee.message(),"]"]), this,true,ee.ql_error_type()) ;
		
		return is_pf ? pf_v_[ctd_idx_] : null<number>;
		
	}
	catch {
	
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.price_factor_ctd");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  bond_future: price_factor
  ----------------------------------------------------------------------*/
number bond_future.price_factor(integer						idx, 
								error_info option(nullable) error)
{
	try{
		if(idx == err_int())
			idx = ctd_idx_;
		
		check_index(idx);
		error_info ee 	= error_info(true,false);	
		logical is_pf 	= is_price_factor_style(ee);
		if(ee.is_error())
			QL_FAIL(strcat(["invalid price factor style [",ee.message(),"]"]), this,true,ee.ql_error_type()) ;
		
		return is_pf ? pf_v_[idx] : null<number>;
		
	}
	catch {
	
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.price_factor");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  bond_future: ctd
  ----------------------------------------------------------------------*/
bond bond_future.ctd(	out number 						ctd_pf,
						out integer						ctd_idx, 
						error_info option(nullable) 	error)
{
		
	CORE_INT.reset_single(error);
	ctd_pf = null<number>;	
	try{
		ctd_idx = ctd_idx_;
		error_info ee = error_info(true,false);
		if(ctd_idx_ == err_int() || ctd_idx_ < 0 ) {
			
			QL_FAIL_COND(null(deliv_v_),"deliverable vector is null", this, true, E_INIT) ;
			QL_FAIL_COND(null_quote_exist_,"deliverable bond(s) has quote = null", this, true, E_INIT) ;
			QL_FAIL("error calculating ctd", this, true, E_INIT) ;			
		}
		else {
			ctd_pf = pf_v_[ctd_idx_];			
			bond b = deliv_v_[ctd_idx_];
			if(!b.is_valid(ee))
				QL_FAIL(strcat(["invalid ctd bond [",ee.message(),"]"]), this,true,ee.ql_error_type()) ;
					
			return b;							
		}
		
	}
	catch {
		ctd_idx = err_int();
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.ctd");
		return null<bond>;
	}
}

/*-----------------------------------------------------------------------
  bond_future ctd  (calc from scratch)
  ----------------------------------------------------------------------*/
void bond_future.ctd(	vector(bond) 					deliverables,
						vector(number) option(nullable) price_factors,
						vector(number) option(nullable) repo_rates,
						day_count_method 				day_count_method,
						out integer 					ctd_index,
						out vector(number)  			imp_repo,
						logical 						verify_db,
						error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__bondfut_ctd(CORE_INT.get_instruments(deliverables),price_factors,repo_rates,day_count_method,ctd_index,imp_repo,verify_db, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.ctd");
		if(e) {
			ctd_index = err_int();			
			imp_repo = null<vector(number)>;
		}		
		return ;						
	}
	catch {
		ctd_index = err_int();			
		imp_repo = null<vector(number)>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.ctd");
		return ;
	}
}
/*-----------------------------------------------------------------------
  err_type
  ----------------------------------------------------------------------*/
bond_future bond_future.err_type(bond_future option(nullable) nul, error_info option(nullable) error,string option(nullable) f )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,instrument.na_func_msg(null<string>), f);
	return null<bond_future>;
}

/*-----------------------------------------------------------------------
  add_nominal 
  ----------------------------------------------------------------------*/
void bond_future.add_nominal(number nominal) 
{			
	instrument.add_nominal(nominal );
	return ;						
}
/*-----------------------------------------------------------------------
  add_quote_from_yield
  ----------------------------------------------------------------------*/
void bond_future.add_quote_from_yield(number  yield, logical option(nullable) set_coupon_to_yield ) 
{
	QL_FAIL(_na_func_msg, this, true);						
}

/*-----------------------------------------------------------------------
  add_quote
  ----------------------------------------------------------------------*/
void bond_future.add_quote(number  quote ) 
{	
	instrument.add_quote(quote, false);
	init_ctd();
	return ;					
	
}
void bond_future.add_quote(number  quote, logical option(nullable) set_coupon_to_quote ) 
{	
	if(null(set_coupon_to_quote)) set_coupon_to_quote = false;
	QL_FAIL_COND(set_coupon_to_quote, "invalid argument: set coupon to quote not applicable for bond future", name(), true);
	instrument.add_quote(quote, set_coupon_to_quote);
	init_ctd();
	return ;						
}
/*-----------------------------------------------------------------------
  copy_data 
  ----------------------------------------------------------------------*/
void bond_future.copy_data(bond_future f_new)
{
	f_new.deliv_v_ 	= CORE_INT.clone_vector(this.deliv_v_);
	f_new.pf_v_ 	= CORE_INT.clone_vector(this.pf_v_);
	f_new.repo_dc_ 	= this.repo_dc_;
	f_new.null_quote_exist_ = this.null_quote_exist_;
	f_new. ctd_idx_ 	= err_int();
}
/*-----------------------------------------------------------------------
  set_quote 
  ----------------------------------------------------------------------*/
bond_future bond_future.set_quote(	number 	option(nullable) quote,
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, false,error);
	if(null(cc))
		return null<bond_future>;

	bond_future f = dynamic_cast<bond_future>(cc);

	copy_data(f);
	f.init_ctd();
	
	return f;
}

/*-----------------------------------------------------------------------
  set_quote 
  ----------------------------------------------------------------------*/
bond_future bond_future.set_quote(	string 	option(nullable) quote_side,
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, false,error);
	if(null(cc))
		return null<bond_future>;

	bond_future f = dynamic_cast<bond_future>(cc);

	copy_data(f);
	f.init_ctd();
	return f;
}

/*-----------------------------------------------------------------------
  set_quote 
  ----------------------------------------------------------------------*/
bond_future bond_future.set_quote(	number 	option(nullable) quote,
									date  	option(nullable) trade_date,
									logical option(nullable) set_to_par, 
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,trade_date, null<date>, set_to_par,error);
	if(null(cc))
		return null<bond_future>;

	bond_future f = dynamic_cast<bond_future>(cc);

	copy_data(f);

	error_info ee 	= new error_info(true,true);
	date _td 		= this.trade_date(ee);
	if(!null(_td) && !null(trade_date) && trade_date != _td){	
		verify_del(false);
	}
	
	f.init_ctd();
	return f;
}

/*-----------------------------------------------------------------------
  set_quote
  ----------------------------------------------------------------------*/
bond_future bond_future.set_quote(	string 	option(nullable) quote_side,
									date  	option(nullable) trade_date, 
									logical 	option(nullable) set_to_par,
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,trade_date, null<date>, set_to_par,error);
	if(null(cc))
		return null<bond_future>;

	bond_future f = dynamic_cast<bond_future>(cc);
		
	copy_data(f);
	
	error_info ee 	= new error_info(true,true);
	date _td 		= this.trade_date(ee);
	if(!null(_td) && !null(trade_date) && trade_date != _td){	
		verify_del(false);
	}
	
	f.init_ctd();
	
	return f;
}

/*-----------------------------------------------------------------------
  set_quote_from_yield
  ----------------------------------------------------------------------*/
bond_future bond_future.set_quote_from_yield(	number 	option(nullable) yield,
												error_info option(nullable) error)
{
	try {
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		..quote_style qs = quote_style_e(ee);
		CORE_INT.instr_fail_check(null(qs), "invalid quote style", this.name(ee), ee);
		
		if(is_pf) {
			number cp = this.clean_price(yield,false,true, error) ;
			if(qs == ..quote_style.CLEAN_PCT)
				return this.set_quote(cp,ee);			
			else 
				QL_FAIL("function requires clean% as quotestyle for this type of future",this,true);
		}
		
		
				
		if(qs == ..quote_style.YIELD || qs == ..quote_style.YIELD_PCT) {
			instrument cc = instrument._set_quote_from_yield(yield,  false,error);
			if(null(cc))
				return null<bond_future>;

			bond_future f = dynamic_cast<bond_future>(cc);

			copy_data(f);
			f.init_ctd();
			return f;
		}
		else {
			QL_FAIL("invalid quote style (style not supported for this function)", this, true);
		}
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.set_quote_from_yield");	
		return null<bond_future>;
	}
}

/*-----------------------------------------------------------------------
  bond_future: set_date 	
	
  ----------------------------------------------------------------------*/
bond_future bond_future.set_date(	date  				td, 
									logical 			re_init_static, 
									logical 			re_init_quote, 
									error_info option(nullable) error)
{
	try {
		
		error_info ee = new error_info(true,true);
		date _td = this.trade_date(ee);
		if(!null(_td) && td == _td){
			return this;
		}
	
		instrument cc = instrument._set_date(td,null<date>,re_init_static,re_init_quote,error);//clone + adjust of deliv dates done here
		if(null(cc))
			return null<bond_future>;
		
		//bond_future bf = dynamic_cast<bond_future>(cc);
		//bf = new bond_future(bf.i(),deliv_v_,pf_v_,repo_rates_,repo_dc_ );
		//bf.set_date_deliverables(td, re_init_static, re_init_quote,error);
		bond_future f = dynamic_cast<bond_future>(cc);

		copy_data(f);
		f.verify_del(false);
		f.init_ctd();
		return f;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.set_date");	
		return null<bond_future>;
	}
}

/*-----------------------------------------------------------------------
  bond_future: set_date (overrides instrument function) <protected>
  ----------------------------------------------------------------------*/
bond_future bond_future.set_date(	date  				trade_date, 
									date  option(nullable)	settle_date,
									logical 			re_init_static, 
									logical 			re_init_quote, 
									error_info option(nullable) error)
{	
	//if(!null(settle_date) && settle_date != this.settle_date(false))
		//QL_FAIL("invalid settlement date",this,true);
	return this.set_date(trade_date, re_init_static,re_init_quote,error);	
}

/*-----------------------------------------------------------------------
  set_date <protected/legacy>
	quote is NOT kept even if trade_date is unchanged
  ----------------------------------------------------------------------*/
bond_future bond_future.set_date(	date  				trade_date, 
									logical 			re_init_static, 
									error_info option(nullable) error) 

{	
	return this.set_date(trade_date, re_init_static,true,error);
}

/*-----------------------------------------------------------------------
  bond_future: set_date_deliverables
  ----------------------------------------------------------------------*/
/*void bond_future.set_date_deliverables(	date  				trade_date, 
										logical 			re_init_static, 
										logical 			re_init_quote, 						
										error_info option(nullable) 	error)
{	
	try{
		CORE_INT.reset_single(error);
		
		integer n = v_size(deliv_v_);
		if(n==0) return;				
		for (integer i = 0 ; i < n ; i++) {		
		    			
			deliv_v_[i] = deliv_v_[i].set_date(trade_date,null<date>,re_init_static,re_init_quote);	    	   				
		}
		
		init_ctd();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.set_date_deliverables");
		return ;
	}
}*/
/*-----------------------------------------------------------------------
   move_date  <protected/legacy>
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	if trade date is the same --> the settle date will be preserved	
  ----------------------------------------------------------------------*/
bond_future bond_future.move_date(	date  				trade_date, 
									date option(nullable) settle_date,
									error_info option(nullable) error) 
{	
	//instrument cc = instrument._move_date(trade_date,null<date>,error);
	//return null(cc) ? null<bond_future>: dynamic_cast<bond_future>(cc);
	return this.set_date(trade_date, false,false,error);
}



/*-----------------------------------------------------------------------
  set_yield  FIX_ME
  ----------------------------------------------------------------------*/
bond_future bond_future.set_yield(	number 	option(nullable) yield,
									error_info option(nullable) error)
{		
	try {
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(is_pf)
			QL_FAIL("function not supported for pricefactor-style futures",this,true);
		
		
		..quote_style qs = quote_style_e(ee);
		CORE_INT.instr_fail_check(null(qs), "invalid quote style", this, ee);
				
		if(qs == ..quote_style.YIELD || qs == ..quote_style.YIELD_PCT) {
			instrument cc = instrument._set_yield(	yield, null<date>, null<date>,false, error);
			if(null(cc))
				return null<bond_future>;

			bond_future f = dynamic_cast<bond_future>(cc);

			copy_data(f);
			f.init_ctd();
			return f;
		}
		QL_FAIL("invalid quote style (style not supported for this function)", this, true);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.set_yield");	
		return null<bond_future>;
	}
}

/*-----------------------------------------------------------------------
  set_clean_price
  ----------------------------------------------------------------------*/
bond_future bond_future.set_clean_price(number 	option(nullable) clean_pct,
										date  	option(nullable) trade_date, 
										error_info option(nullable) error)
{	
	instrument cc = instrument._set_clean_price(clean_pct,trade_date, null<date>,error);
	if(null(cc))
		return null<bond_future>;

	bond_future f = dynamic_cast<bond_future>(cc);

	copy_data(f);
	f.init_ctd();
	return f;
}

/*-----------------------------------------------------------------------
  set_clean_price <protected>
  ----------------------------------------------------------------------*/
bond_future bond_future.set_clean_price(number 	option(nullable) clean_pct,
										date  	option(nullable) trade_date, 
										date  	option(nullable) settle_date, 
										error_info option(nullable) error)
{	
	return this.set_clean_price(clean_pct,trade_date, error);
}

/*-----------------------------------------------------------------------
  other members
  ----------------------------------------------------------------------*/

number  bond_future.quote(	error_info option(nullable) error) 						{ return instrument.quote(error); }

bond_fut_style bond_future.bondfut_style(error_info option(nullable) error) 		{ return this.style(error);}
vector(string) bond_future.bondfut_deliverables(error_info option(nullable) error)	{ return this.deliverable_v_s(error);}
vector(number) bond_future.bondfut_price_factors(error_info option(nullable) error)	{ return this.price_factor_v(error);}
date bond_future.bondfut_expiry_settle_date(error_info option(nullable) error)		{ return this.expiry_settle_date(error);}

string 	bond_future.maturity_code(error_info option(nullable) error)				{ return instrument.maturity_code(error);}
number  bond_future.tick_value(	number tick_size,error_info option(nullable) error) { return instrument.fut_tick_value(tick_size,error); }
number  bond_future.tick_size(error_info option(nullable) error)					{ return instrument.fut_tick_size(error);}
date  	bond_future.settle_date(error_info option(nullable) error)	option(hidden)	{ return this.expiry_settle_date(error);}
logical bond_future.is_daily_mtm(error_info option(nullable) error) 				{ return instrument.fut_daily_mtm(error);}
number  bond_future.contract_size(error_info option(nullable) error)				{ return instrument.fut_contract_size(error);}
number 	bond_future.face_amount(error_info option(nullable) error)					{ return this.contract_size(error);}
date 	bond_future.issue_date(error_info option(nullable) error)					{ return this.expiry_settle_date(error);}
number  bond_future.quote(	disc_func,..quote_style	option(nullable),									
						error_info option(nullable) error) 							{ return fin_instr.err_type(1.0, error);}
logical bond_future.is_price_factor_style(error_info option(nullable) error)		{ return this.style(error) == bond_fut_style.PRICE_FACTOR_MTM;
}

vector(date) bond_future.cash_flow_dates(logical adj_dates,
										 error_info option(nullable) error){ return instrument.cash_flow_dates(false, adj_dates,true,error);}

vector(date) bond_future.cash_flow_dates(logical post_settle,
										 logical adj_dates,
										 logical keep_size,
										 error_info option(nullable) error){ return instrument.cash_flow_dates(post_settle, adj_dates,keep_size,error);}//return this.cash_flow_dates(adj_dates,error);}

vector(number) bond_future.cash_flows_cpn(number option(nullable) 	nominal,
										  logical 					post_settle,
										  logical 					keep_size,
										  error_info option(nullable) error){ return instrument.cash_flows_cpn(nominal, post_settle, keep_size,error);}

vector(number) bond_future.cash_flow_amounts(number option(nullable) 	nominal,
										  logical 					post_settle,
										  logical 					keep_size,
										  error_info option(nullable) error){ return instrument.cash_flow_amounts(nominal, post_settle, keep_size,error);}

vector(number) bond_future.cash_flows(number option(nullable) nominal,
									  error_info option(nullable) error)	{ return instrument.cash_flows(nominal, false, true,error);}

vector(number) bond_future.cash_flows(number option(nullable) 	nominal,
									  logical 					post_settle,
									  logical 					keep_size,
									  error_info option(nullable) error)	{ return instrument.cash_flows(nominal, post_settle, keep_size,error);} //this.cash_flows(nominal, error);}

void bond_future.cash_flow_data(number option(nullable) nominal,
								ir_cf_code 				cf_code,
								logical 				adj_dates,
								out vector(date)   dates, 
								out vector(number)   amounts,								
								error_info option(nullable) error)			{ instrument.cash_flow_data(nominal,false, cf_code,adj_dates,true,dates,amounts, error);}

void bond_future.cash_flow_data(number option(nullable) nominal,
								logical 				post_settle,
								ir_cf_code 				cf_code,
								logical 				adj_dates,
								logical 				keep_size,
								out vector(date)   dates, 
								out vector(number)   amounts,								
								error_info option(nullable) error)			{ instrument.cash_flow_data(nominal,post_settle, cf_code,adj_dates,keep_size,dates,amounts, error);}//this.cash_flow_data(nominal,cf_code,adj_dates,dates,amounts, error);}


day_count_method bond_future.repo_dc_method(error_info option(nullable) error) 	{ return this.repo_dc_;}

/*-----------------------------------------------------------------------
  bond_future: style
  ----------------------------------------------------------------------*/
bond_fut_style bond_future.style(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		bond_fut_style c = i().__bondfut_delivery_style(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.style");	
		return e ? null<bond_fut_style>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.style");
		return null<bond_fut_style >;
	}
}

/*-----------------------------------------------------------------------
  bond_future: deliverable_v_s
  ----------------------------------------------------------------------*/
vector(string) bond_future.deliverable_v_s(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(string) c = i().__bondfut_deliverables(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.deliverable_v_s");	
		return e ? null<vector(string)>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.deliverable_v_s");
		return null<vector(string)>;
	}
}

vector(string) bond_future.deliverables() option(hidden)
{
	return this.deliverable_v_s();
}

vector(bond) bond_future.deliverable_v()
{
	return deliv_v_;
}

/*-----------------------------------------------------------------------
  bond_future: price_factor_v
  ----------------------------------------------------------------------*/
vector(number) bond_future.price_factor_v(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(number) c = i().__bondfut_price_factors(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.price_factor_v");	
		return e ? null<vector(number)>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.price_factor_v");
		return null<vector(number)>;
	}
}

vector(number) bond_future.price_factors() option(hidden)
{
	return this.price_factor_v();
}

/*-----------------------------------------------------------------------
  bond_future: imp_repo
  ----------------------------------------------------------------------*/
number bond_future.imp_repo(error_info option(nullable) error)
{
	return this.imp_repo(null<bond >, null<number>,null<day_count_method>, error);
}
/*-----------------------------------------------------------------------
  bond_future: imp_repo
  ----------------------------------------------------------------------*/
number bond_future.imp_repo(integer idx,
							error_info option(nullable) error)
{
	try {
		if(idx == err_int())
			idx = ctd_idx_;
		bond b;
		number pf, repo;
		index_to_data(idx,b,pf,repo);
		return this.imp_repo(b, pf,repo_dc_, error);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.imp_repo");
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  bond_future: imp_repo
  ----------------------------------------------------------------------*/
number bond_future.imp_repo(	bond option(nullable)				ctd,
								number option(nullable) 			ctd_price_factor,
								day_count_method option(nullable)	day_count_method,
								error_info option(nullable) 		error)
{	
	try{
		number r;
		logical dr;
		func_helper_ctd(ctd,ctd_price_factor,r,	day_count_method,dr);
		
		instr_error_type t;
   		string 	s;	
		number  c = i().__bondfut_imp_repo(ctd.i(), ctd_price_factor, day_count_method, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.imp_repo");	
		return e ? null<number>: c;											
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.imp_repo");
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  bond_future: imp_repo
  ----------------------------------------------------------------------*/
vector(number) bond_future.imp_repo(vector(bond) option(nullable)		del_bonds,
									vector(number) option(nullable) 	price_factors,
									day_count_method option(nullable)	day_count_method,
									error_info option(nullable) 		error)
{	
	try{
		if(null(del_bonds)){
			number r = this.imp_repo(null<bond>, null<number>, day_count_method, error);
			return [r];
		}
		else if(v_size(del_bonds)==1){
			if(null(price_factors)){
				resize(price_factors,1);
				price_factors[0] = null<number>;
			}
			number r = this.imp_repo(del_bonds[0], price_factors[0], day_count_method, error);
			return [r];
		}
			
		if(null(day_count_method))
			day_count_method = repo_dc_;
		QL_FAIL_COND(null(day_count_method), "invalid daycount method",this,true);
				
		integer size = v_size(del_bonds);
		if(null(price_factors)){
			resize(price_factors,size);
			price_factors = null<number>;
		}
		QL_FAIL_COND(size != v_size(price_factors), "invalid price factor vector",this,true);
		
		vector(number) res[size];
		
		for(integer j=0;j<size;j++){
			QL_FAIL_COND(null(del_bonds[j]), "invalid deliverable bond",this,true);
			instr_error_type t;
			string 	s;	
			number  c = i().__bondfut_imp_repo(del_bonds[j].i(), price_factors[j], day_count_method, t, s);
			logical e = CORE_INT.add_error_info(error,t,s, "bond_future.imp_repo");	
			res[j] = e ? null<number>: c;
		}
		return res;
		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.imp_repo");
		return null<vector(number) >;
	}
}

/*-----------------------------------------------------------------------
  bond_future: imp_repo_ext
  ----------------------------------------------------------------------*/
void bond_future.imp_repo_ext(	out number		imp_repo,
								out number		gross_basis_fut,
								out number		gross_basis,
								out number		net_basis,
								out number 		dirty_price_ctd_fwd,
								out number		cf_fund_cost,
								out number		cf_net_fund_cost,
								out number		cf_accr,
								out number		cf_coc,
								out number		cf_cpn,
								out number		cf_cpn_reinv,								
								error_info option(nullable) 	error)
{
	this.imp_repo_ext(null<bond >, null<number>,null<day_count_method>, imp_repo, gross_basis_fut, gross_basis,net_basis,dirty_price_ctd_fwd,
						  cf_fund_cost,cf_net_fund_cost,cf_accr,cf_coc,cf_cpn,cf_cpn_reinv,error);
	return;
}
/*-----------------------------------------------------------------------
  bond_future: imp_repo_ext
  ----------------------------------------------------------------------*/
void bond_future.imp_repo_ext(	integer 		idx,
								out number		imp_repo,
								out number		gross_basis_fut,
								out number		gross_basis,
								out number		net_basis,
								out number 		dirty_price_ctd_fwd,
								out number		cf_fund_cost,
								out number		cf_net_fund_cost,
								out number		cf_accr,
								out number		cf_coc,
								out number		cf_cpn,
								out number		cf_cpn_reinv,								
								error_info option(nullable) 	error)
{
	try {
		if(idx == err_int())
			idx = ctd_idx_;
		bond b;
		number pf, repo;
		index_to_data(idx,b,pf,repo);
		this.imp_repo_ext(b, pf,repo_dc_, imp_repo, gross_basis_fut, gross_basis,net_basis,dirty_price_ctd_fwd,
						  cf_fund_cost,cf_net_fund_cost,cf_accr,cf_coc,cf_cpn,cf_cpn_reinv,error);
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.imp_repo_ext");
		return ;
	}
}
/*-----------------------------------------------------------------------
  bondfut_imp_repo_ext

  ----------------------------------------------------------------------*/
void bond_future.imp_repo_ext(	bond	option(nullable)		ctd,
								number option(nullable) 		ctd_price_factor,
								day_count_method option(nullable) day_count_method,								
								out number		imp_repo,
								out number		gross_basis_fut,
								out number		gross_basis,
								out number		net_basis,
								out number 		dirty_price_ctd_fwd,
								out number		cf_fund_cost,
								out number		cf_net_fund_cost,
								out number		cf_accr,
								out number		cf_coc,
								out number		cf_cpn,
								out number		cf_cpn_reinv,								
								error_info option(nullable) 	error)
{	
	try{	
		number r;
		logical dr;
		func_helper_ctd(ctd,ctd_price_factor,r,	day_count_method,dr);

		instr_error_type t;
   		string 			s;	
		i().__bondfut_imp_repo_ext(	ctd.i(),ctd_price_factor,day_count_method,imp_repo, gross_basis_fut,
									gross_basis,net_basis,dirty_price_ctd_fwd,cf_fund_cost,cf_net_fund_cost,
									cf_accr,cf_coc,cf_cpn,cf_cpn_reinv,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.imp_repo_ext");	
		if(e){ 
			imp_repo = gross_basis_fut = gross_basis = net_basis = dirty_price_ctd_fwd = cf_fund_cost = null<number>;
			cf_net_fund_cost = cf_accr = cf_coc = cf_cpn = cf_cpn_reinv = null<number>;
		}		
		return ;						
	}
	catch {
		imp_repo = gross_basis_fut = gross_basis = net_basis = dirty_price_ctd_fwd = cf_fund_cost = null<number>;
		cf_net_fund_cost = cf_accr = cf_coc = cf_cpn = cf_cpn_reinv = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.imp_repo_ext");
		return ;
	}
}

/*-----------------------------------------------------------------------
  bond_future: repo_sens
  ----------------------------------------------------------------------*/
number bond_future.repo_sens(	integer 							idx,
								number option(nullable)				y_fut_shift,
								number option(nullable) 			y_bond_shift,			
								logical option(nullable) 			disable_rounding,
								error_info option(nullable) 		error)
{	
	try{
		if(idx == err_int())
			idx = ctd_idx_;
		bond b;
		number pf, repo;
		index_to_data(idx,b,pf,repo);
		return this.repo_sens(b,pf,repo_dc_, y_fut_shift, y_bond_shift, disable_rounding, error);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.repo_sens");
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  bond_future: repo_sens
  ----------------------------------------------------------------------*/
number bond_future.repo_sens(	bond option(nullable)				ctd,
								number option(nullable) 			ctd_price_factor,
								day_count_method option(nullable)	day_count_method,
								number option(nullable)				y_fut_shift,
								number option(nullable) 			y_bond_shift,			
								logical option(nullable) 			disable_rounding,
								error_info option(nullable) 		error)
{	
	try{
		number r;
		func_helper_ctd(ctd,ctd_price_factor,r,	day_count_method,disable_rounding);

		instr_error_type t;
   		string 	s;	
		number  c = i().__bondfut_repo_sens(ctd.i(), ctd_price_factor, day_count_method,y_fut_shift,y_bond_shift, disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.repo_sens");	
		return e ? null<number>: c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.repo_sens");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  bond_future: ctd_y_sens
  ----------------------------------------------------------------------*/
number bond_future.ctd_y_sens(	integer 							idx,
								number option(nullable)				repo_shift,
								number option(nullable) 			y_fut_shift,			
								logical option(nullable) 			disable_rounding,
								error_info option(nullable) 		error)
{	
	try{
		if(idx == err_int())
			idx = ctd_idx_;
		bond b;
		number pf, repo;
		index_to_data(idx,b,pf,repo);
		return this.ctd_y_sens(b,pf,repo,repo_dc_, repo_shift, y_fut_shift, disable_rounding, error);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.ctd_y_sens");
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  bond_future: ctd_y_sens
  ----------------------------------------------------------------------*/
number bond_future.ctd_y_sens(	bond option(nullable)				ctd,
								number option(nullable) 			ctd_price_factor,
								number option(nullable) 			repo_rate,
								day_count_method option(nullable)	day_count_method,
								number option(nullable)				repo_shift,
								number option(nullable) 			y_fut_shift,			
								logical option(nullable) 			disable_rounding,
								error_info option(nullable) 		error)
{	
	try{		
		func_helper_ctd(ctd,ctd_price_factor,repo_rate,	day_count_method,disable_rounding);

		instr_error_type t;
   		string 	s;	
		number  c = i().__bondfut_ctd_y_sens(ctd.i(), ctd_price_factor, repo_rate, day_count_method,repo_shift,y_fut_shift, disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.ctd_y_sens");	
		return e ? null<number>: c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.ctd_y_sens");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  bond_future: fut_y_sens
  ----------------------------------------------------------------------*/
number bond_future.fut_y_sens(	integer 							idx,
								number option(nullable)				repo_shift,
								number option(nullable) 			y_bond_shift,			
								logical option(nullable) 			disable_rounding,
								error_info option(nullable) 		error)
{	
	try{
		if(idx == err_int())
			idx = ctd_idx_;
		bond b;
		number pf, repo;
		index_to_data(idx,b,pf,repo);
		return this.fut_y_sens(b,pf,repo,repo_dc_, repo_shift, y_bond_shift, disable_rounding, error);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.fut_y_sens");
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  bond_future: fut_y_sens
  ----------------------------------------------------------------------*/
number bond_future.fut_y_sens(	bond option(nullable)				ctd,
								number option(nullable) 			ctd_price_factor,
								number option(nullable) 			repo_rate,
								day_count_method option(nullable)	day_count_method,
								number option(nullable)				repo_shift,
								number option(nullable) 			y_bond_shift,			
								logical option(nullable) 			disable_rounding,
								error_info option(nullable) 		error)
{	
	try{
		func_helper_ctd(ctd,ctd_price_factor,repo_rate,	day_count_method,disable_rounding);

		instr_error_type t;
   		string 	s;	
		number  c = i().__bondfut_fut_y_sens(ctd.i(), ctd_price_factor, repo_rate, day_count_method,repo_shift,y_bond_shift, disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.fut_y_sens");	
		return e ? null<number>: c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.fut_y_sens");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  bond_future: imp_fut

  ----------------------------------------------------------------------*/
void bond_future.imp_fut(	number  option(nullable) 	repo_rate,
							out number	imp_clean_price_fut,
							out number	imp_yield_fut,
							error_info option(nullable) error)
{
	this.imp_fut(	null<bond >, null<number>,repo_rate,null<number>,null<day_count_method>,							
					imp_clean_price_fut,imp_yield_fut, error);
}
/*-----------------------------------------------------------------------
  bond_future: imp_fut

  ----------------------------------------------------------------------*/
void bond_future.imp_fut(	integer idx,
							number  option(nullable) 	repo_rate,
							out number	imp_clean_price_fut,
							out number	imp_yield_fut,
							error_info option(nullable) error)
{
	try{
		if(idx == err_int())
			idx = ctd_idx_;
		bond b;
		number pf, r;
		index_to_data(idx,b,pf,r);
		this.imp_fut(b, pf,repo_rate,null<number>,repo_dc_,	imp_clean_price_fut,imp_yield_fut, error);
	}
	catch {
		imp_clean_price_fut  = imp_yield_fut = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.imp_fut");
		return ;
	}
}
/*-----------------------------------------------------------------------
  bond_future: imp_fut

  ----------------------------------------------------------------------*/
void bond_future.imp_fut(	bond	option(nullable)	ctd,
							number option(nullable) 	ctd_price_factor,
							number  option(nullable) 	repo_rate,
							number option(nullable) 	cpn_reinv_rate,
							day_count_method option(nullable)	day_count_method,								
							out number					imp_clean_price_fut,
							out number					imp_yield_fut,
							error_info option(nullable) error)
{	
	try{
		logical dr;
		func_helper_ctd(ctd,ctd_price_factor,repo_rate,	day_count_method,dr);
		
		QL_FAIL_COND(null(repo_rate), "invalid repo rate",this,true);
		if(null(cpn_reinv_rate))
			cpn_reinv_rate = repo_rate;
		
		instr_error_type t;
   		string 			s;		
		i().__bondfut_imp_fut(ctd.i(),ctd_price_factor,repo_rate,cpn_reinv_rate,day_count_method,
							  imp_clean_price_fut, imp_yield_fut,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.imp_fut");	
		if(e){ 
			imp_clean_price_fut  = imp_yield_fut = null<number>;
		}		
		return ;						
	}
	catch {
		imp_clean_price_fut  = imp_yield_fut = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.imp_fut");
		return ;
	}
}

/*-----------------------------------------------------------------------
  bond_future: imp_fut_ext

  ----------------------------------------------------------------------*/
void bond_future.imp_fut_ext(	number  option(nullable) 	repo_rate,
								out number	imp_clean_price_fut,
								out number	imp_yield_fut,
								out number	imp_dirty_price_ctd_fwd,
								out number	cf_fund_cost,
								out number	cf_net_fund_cost,
								out number 	cf_accr,
								out number	cf_coc,
								out number	cf_cpn,
								out number	cf_cpn_reinv,								
								error_info option(nullable) error)
{
	this.imp_fut_ext(null<bond>, null<number>,repo_rate,null<number>,null<day_count_method>,
							imp_clean_price_fut, imp_yield_fut, imp_dirty_price_ctd_fwd,cf_fund_cost,cf_net_fund_cost,
									cf_accr,cf_coc,cf_cpn,cf_cpn_reinv,error);
	return;
}
/*-----------------------------------------------------------------------
  bond_future: imp_fut_ext

  ----------------------------------------------------------------------*/
void bond_future.imp_fut_ext(	integer idx,
								number  option(nullable) 	repo_rate,
								out number	imp_clean_price_fut,
								out number	imp_yield_fut,
								out number	imp_dirty_price_ctd_fwd,
								out number	cf_fund_cost,
								out number	cf_net_fund_cost,
								out number 	cf_accr,
								out number	cf_coc,
								out number	cf_cpn,
								out number	cf_cpn_reinv,								
								error_info option(nullable) error)
{
	try {
		if(idx == err_int())
			idx = ctd_idx_;
		bond b;
		number pf, r;
		index_to_data(idx,b,pf,r);
		this.imp_fut_ext(b, pf,repo_rate,null<number>,repo_dc_,
						imp_clean_price_fut, imp_yield_fut, imp_dirty_price_ctd_fwd,cf_fund_cost,cf_net_fund_cost,
						cf_accr,cf_coc,cf_cpn,cf_cpn_reinv,error);
		return;
	}
	catch {
		imp_clean_price_fut  = imp_yield_fut = imp_dirty_price_ctd_fwd = cf_fund_cost = null<number>;
		cf_net_fund_cost = cf_accr = cf_coc = cf_cpn = cf_cpn_reinv = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.imp_fut_ext");
		return ;
	}
}
/*-----------------------------------------------------------------------
  bond_future: imp_fut_ext

  ----------------------------------------------------------------------*/
void bond_future.imp_fut_ext(	bond option(nullable)		ctd,
								number option(nullable) 	ctd_price_factor,
								number option(nullable)		repo_rate,
								number option(nullable) 	cpn_reinv_rate,
								day_count_method option(nullable) day_count_method,								
								out number	imp_clean_price_fut,
								out number	imp_yield_fut,
								out number	imp_dirty_price_ctd_fwd,
								out number	cf_fund_cost,
								out number	cf_net_fund_cost,
								out number 	cf_accr,
								out number	cf_coc,
								out number	cf_cpn,
								out number	cf_cpn_reinv,								
								error_info option(nullable) error)
{	
	try{	
		logical dr;
		func_helper_ctd(ctd,ctd_price_factor,repo_rate,	day_count_method,dr);
		
		QL_FAIL_COND(null(repo_rate), "invalid repo rate",this,true);	
		if(null(cpn_reinv_rate))
			cpn_reinv_rate = repo_rate;
		
		instr_error_type t;
   		string 			s;	
		i().__bondfut_imp_fut_ext(	ctd.i(),ctd_price_factor,repo_rate,cpn_reinv_rate,day_count_method,imp_clean_price_fut, 
									imp_yield_fut, imp_dirty_price_ctd_fwd,cf_fund_cost,cf_net_fund_cost,
									cf_accr,cf_coc,cf_cpn,cf_cpn_reinv,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.imp_fut_ext");
		if(e){ 
			imp_clean_price_fut  = imp_yield_fut = imp_dirty_price_ctd_fwd = cf_fund_cost = null<number>;
			cf_net_fund_cost = cf_accr = cf_coc = cf_cpn = cf_cpn_reinv = null<number>;
		}		
		return ;						
	}
	catch {
		imp_clean_price_fut  = imp_yield_fut = imp_dirty_price_ctd_fwd = cf_fund_cost = null<number>;
		cf_net_fund_cost = cf_accr = cf_coc = cf_cpn = cf_cpn_reinv = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.imp_fut_ext");
		return ;
	}
}

/*-----------------------------------------------------------------------
  bond_future: imp_spot

  ----------------------------------------------------------------------*/
void bond_future.imp_spot(	number option(nullable) repo_rate,
							out number	imp_clean_price_ctd,
							out number	imp_yield_ctd,
							error_info option(nullable) error)
{
	this.imp_spot(	null<bond >, null<number>,repo_rate,null<number>,null<day_count_method>,							
					imp_clean_price_ctd,imp_yield_ctd, error);
	return;
}
/*-----------------------------------------------------------------------
  bond_future: imp_spot

  ----------------------------------------------------------------------*/
void bond_future.imp_spot(	integer idx,
							number option(nullable) repo_rate,
							out number	imp_clean_price_ctd,
							out number	imp_yield_ctd,
							error_info option(nullable) error)
{
	try {
		if(idx == err_int())
			idx = ctd_idx_;
		bond b;
		number pf, r;
		index_to_data(idx,b,pf,r);
		this.imp_spot(	b, pf, repo_rate,null<number>,null<day_count_method>,							
						imp_clean_price_ctd,imp_yield_ctd, error);
		return;
	}
	catch {
		imp_clean_price_ctd  = imp_yield_ctd = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.imp_spot");
		return ;
	}
}
/*-----------------------------------------------------------------------
  bond_future: imp_spot

  ----------------------------------------------------------------------*/
void bond_future.imp_spot(	bond	option(nullable)	ctd,
							number option(nullable) 	ctd_price_factor,
							number  option(nullable) 	repo_rate,
							number option(nullable) 	cpn_reinv_rate,
							day_count_method option(nullable)	day_count_method,								
							out number					imp_clean_price_ctd,
							out number					imp_yield_ctd,
							error_info option(nullable) error)
{	
	try{	
		logical dr;
		func_helper_ctd(ctd,ctd_price_factor,repo_rate,	day_count_method,dr);
		
		QL_FAIL_COND(null(repo_rate), "invalid repo rate",this,true);			
		if(null(cpn_reinv_rate))
			cpn_reinv_rate = repo_rate;
		
		instr_error_type t;
   		string 			s;		
		i().__bondfut_imp_spot(ctd.i(),ctd_price_factor,repo_rate,cpn_reinv_rate,day_count_method,
							  imp_clean_price_ctd, imp_yield_ctd,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.imp_spot");	
		if(e){ 
			imp_clean_price_ctd  = imp_yield_ctd = null<number>;
		}		
		return ;						
	}
	catch {
		imp_clean_price_ctd  = imp_yield_ctd = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.imp_spot");
		return ;
	}
}
/*-----------------------------------------------------------------------
  bond_future: funding

  ----------------------------------------------------------------------*/
void bond_future.funding(	number option(nullable)		repo_rate,
							number option(nullable) 	cpn_reinv_rate,
							day_count_method option(nullable) day_count_method,								
							out number	dirty_price_fwd,
							out number	cf_fund_cost,
							out number	cf_net_fund_cost,
							out number 	cf_accr,
							out number	cf_coc,
							out number	cf_cpn,
							out number	cf_cpn_reinv,
							out number 	disc_fact,
							out number	net_basis,
							out number	gross_basis_fut,
							out number	gross_basis,						
							error_info option(nullable) error)
{
	this.funding(	null<bond> ,null<number>, repo_rate, cpn_reinv_rate, day_count_method,								
				dirty_price_fwd,cf_fund_cost,cf_net_fund_cost,cf_accr,cf_coc,cf_cpn,
				cf_cpn_reinv,disc_fact,net_basis,gross_basis_fut,gross_basis,error);
}
/*-----------------------------------------------------------------------
  bond_future: funding

  ----------------------------------------------------------------------*/
void bond_future.funding(	integer idx,
							number option(nullable)		repo_rate,
							number option(nullable) 	cpn_reinv_rate,
							day_count_method option(nullable) day_count_method,								
							out number	dirty_price_fwd,
							out number	cf_fund_cost,
							out number	cf_net_fund_cost,
							out number 	cf_accr,
							out number	cf_coc,
							out number	cf_cpn,
							out number	cf_cpn_reinv,
							out number 	disc_fact,
							out number	net_basis,
							out number	gross_basis_fut,
							out number	gross_basis,						
							error_info option(nullable) error)
{
	try {
		if(idx == err_int())
			idx = ctd_idx_;
		bond b;
		number pf, r;
		index_to_data(idx,b,pf,r);
		this.funding(	b ,pf, repo_rate, cpn_reinv_rate, day_count_method,								
					dirty_price_fwd,cf_fund_cost,cf_net_fund_cost,cf_accr,cf_coc,cf_cpn,
					cf_cpn_reinv,disc_fact,net_basis,gross_basis_fut,gross_basis,error);
		return;
	}
	catch {
		dirty_price_fwd = cf_fund_cost = net_basis = gross_basis_fut = gross_basis = null<number>;
		cf_net_fund_cost = cf_accr = cf_coc = cf_cpn = cf_cpn_reinv = disc_fact = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.funding");
		return ;
	}
		
}

/*-----------------------------------------------------------------------
  bond_future: funding

  ----------------------------------------------------------------------*/
void bond_future.funding(	bond option(nullable)		ctd,
							number option(nullable) 	ctd_price_factor,
							number option(nullable)		repo_rate,
							number option(nullable) 	cpn_reinv_rate,
							day_count_method option(nullable) day_count_method,								
							//out number	imp_clean_price_fut,
							//out number	imp_yield_fut,
							out number	dirty_price_fwd,
							out number	cf_fund_cost,
							out number	cf_net_fund_cost,
							out number 	cf_accr,
							out number	cf_coc,
							out number	cf_cpn,
							out number	cf_cpn_reinv,
							out number 	disc_fact,
							out number	net_basis,
							out number	gross_basis_fut,
							out number	gross_basis,							
							error_info option(nullable) error)
{	
	try{	
		logical dr;
		func_helper_ctd(ctd,ctd_price_factor,repo_rate,	day_count_method,dr);
		
		QL_FAIL_COND(null(repo_rate), "invalid repo rate",this,true);

		if(null(cpn_reinv_rate))
			cpn_reinv_rate = repo_rate;
				
		number ai,ai_fwd;
		instr_error_type t;
   		string 			s;	
		i().__bondfut_funding(	ctd.i(),ctd_price_factor,repo_rate,cpn_reinv_rate,day_count_method,dirty_price_fwd,ai,ai_fwd, 
								cf_fund_cost,cf_net_fund_cost, cf_accr,cf_coc,cf_cpn,cf_cpn_reinv,disc_fact,net_basis,
								gross_basis_fut, gross_basis,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.funding");
		if(e){ 
			dirty_price_fwd = cf_fund_cost = net_basis = gross_basis_fut = gross_basis = null<number>;
			cf_net_fund_cost = cf_accr = cf_coc = cf_cpn = cf_cpn_reinv = disc_fact = null<number>;
		}		
		return ;

		
	}
	catch {
		dirty_price_fwd = cf_fund_cost = net_basis = gross_basis_fut = gross_basis = null<number>;
		cf_net_fund_cost = cf_accr = cf_coc = cf_cpn = cf_cpn_reinv = disc_fact = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.funding");
		return ;
	}
}
/*-----------------------------------------------------------------------
  bond_future: funding_1day

  ----------------------------------------------------------------------*/
void bond_future.funding_1day(	number option(nullable)		repo_rate,
							number option(nullable) 	cpn_reinv_rate,
							day_count_method option(nullable) day_count_method,								
							out number	dirty_price_fwd,
							out number	cf_fund_cost,
							out number	cf_net_fund_cost,
							out number 	cf_accr,
							out number	cf_coc,
							out number	cf_cpn,
							out number	cf_cpn_reinv,
							out number 	disc_fact,
							out number	net_basis,
							out number	gross_basis_fut,
							out number	gross_basis,
							out integer days,
							error_info option(nullable) error)
{
	this.funding_1day(	null<bond> ,null<number>, repo_rate, cpn_reinv_rate, day_count_method,								
					dirty_price_fwd,cf_fund_cost,cf_net_fund_cost,cf_accr,cf_coc,cf_cpn,
					cf_cpn_reinv,disc_fact,net_basis,gross_basis_fut,gross_basis,days, error);
	return;
}
/*-----------------------------------------------------------------------
  bond_future: funding_1day

  ----------------------------------------------------------------------*/
void bond_future.funding_1day(	integer idx,
								number option(nullable)		repo_rate,
								number option(nullable) 	cpn_reinv_rate,
								day_count_method option(nullable) day_count_method,								
								out number	dirty_price_fwd,
								out number	cf_fund_cost,
								out number	cf_net_fund_cost,
								out number 	cf_accr,
								out number	cf_coc,
								out number	cf_cpn,
								out number	cf_cpn_reinv,
								out number 	disc_fact,
								out number	net_basis,
								out number	gross_basis_fut,
								out number	gross_basis,
								out integer days,
								error_info option(nullable) error)
{
	try {
		if(idx == err_int())
			idx = ctd_idx_;
		bond b;
		number pf, r;
		index_to_data(idx,b,pf,r);
		this.funding_1day(	b,pf, repo_rate, cpn_reinv_rate, day_count_method,								
					dirty_price_fwd,cf_fund_cost,cf_net_fund_cost,cf_accr,cf_coc,cf_cpn,
					cf_cpn_reinv,disc_fact,net_basis,gross_basis_fut,gross_basis,days, error);
		return ;

		
	}
	catch {
		dirty_price_fwd = cf_fund_cost = net_basis = gross_basis_fut = gross_basis = null<number>;
		cf_net_fund_cost = cf_accr = cf_coc = cf_cpn = cf_cpn_reinv = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.funding");
		return ;
	}
}
/*-----------------------------------------------------------------------
  bond_future: funding

  ----------------------------------------------------------------------*/
void bond_future.funding_1day(	bond option(nullable)		ctd,
							number option(nullable) 	ctd_price_factor,
							number option(nullable)		repo_rate,
							number option(nullable) 	cpn_reinv_rate,
							day_count_method option(nullable) day_count_method,								
							//out number	imp_clean_price_fut,
							//out number	imp_yield_fut,
							out number	dirty_price_fwd,
							out number	cf_fund_cost,
							out number	cf_net_fund_cost,
							out number 	cf_accr,
							out number	cf_coc,
							out number	cf_cpn,
							out number	cf_cpn_reinv,
							out number 	disc_fact,
							out number	net_basis,
							out number	gross_basis_fut,
							out number	gross_basis,
							out integer days,
							error_info option(nullable) error)
{	
	try{
		logical dr;
		func_helper_ctd(ctd,ctd_price_factor,repo_rate,	day_count_method,dr);
		
		QL_FAIL_COND(null(repo_rate), "invalid repo rate",this,true);

		if(null(cpn_reinv_rate))
			cpn_reinv_rate = repo_rate;
				
		error_info ee = new error_info(true,false);
		
		funding(ctd,ctd_price_factor,repo_rate,cpn_reinv_rate,day_count_method,								
				dirty_price_fwd,cf_fund_cost,cf_net_fund_cost,cf_accr,
				cf_coc,cf_cpn,cf_cpn_reinv,disc_fact,net_basis,gross_basis_fut,
				gross_basis, ee);

		QL_FAIL_COND(ee.is_error(),ee.message());
		
		..calendar cal = ctd.calendar();
		date next_td = cal.move_bus_days(ctd.trade_date(),1);
		
		bond b1 = ctd.set_date(next_td,null<date>,false,false,ee);
		QL_FAIL_COND(ee.is_error(),ee.message());
		days = b1.settle_date(ee) - ctd.settle_date(ee);
		
		//number q1 = ctd.quote();
		//number q2 = b1.quote();

		number	dirty_price_fwd_2, cf_fund_cost_2, cf_net_fund_cost_2, cf_accr_2, cf_coc_2, cf_cpn_2;
		number	cf_cpn_reinv_2, disc_fact_2, net_basis_2, gross_basis_fut_2, gross_basis_2;

		bond_future bf = new bond_future(this);
		bf = bf.set_date(next_td,false,false,ee);
		QL_FAIL_COND(ee.is_error(),ee.message());
		
		bf.funding(b1,ctd_price_factor,repo_rate,cpn_reinv_rate,day_count_method,								
				dirty_price_fwd_2,cf_fund_cost_2,cf_net_fund_cost_2,cf_accr_2,
				cf_coc_2,cf_cpn_2,cf_cpn_reinv_2,disc_fact_2,net_basis_2,gross_basis_fut_2,
				gross_basis_2, ee);
		QL_FAIL_COND(ee.is_error(),ee.message());
		
		dirty_price_fwd	= dirty_price_fwd_2	- dirty_price_fwd;
		cf_fund_cost	= cf_fund_cost_2	- cf_fund_cost;
		cf_net_fund_cost= cf_net_fund_cost_2- cf_net_fund_cost;
		cf_accr			= cf_accr_2			- cf_accr;
		cf_coc			= cf_coc_2			- cf_coc;
		cf_cpn			= cf_cpn_2			- cf_cpn;
		cf_cpn_reinv	= cf_cpn_reinv_2	- cf_cpn_reinv;
		disc_fact		= disc_fact_2		- disc_fact;
		net_basis		= net_basis_2		- net_basis;
		gross_basis_fut	= gross_basis_fut_2	- gross_basis_fut;
		gross_basis 	= gross_basis_2		- gross_basis;

		
		return ;

		
	}
	catch {
		dirty_price_fwd = cf_fund_cost = net_basis = gross_basis_fut = gross_basis = null<number>;
		cf_net_fund_cost = cf_accr = cf_coc = cf_cpn = cf_cpn_reinv = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.funding");
		return ;
	}
}

//-------------------------------------------------------
// pvbp_fut	
/*
												spot	repo	fwd		comment
PFT_FUT_1BP_DISC		(PFT_FUT1BP_D_1BP)		n/a		1bp		1bp		fut_pvbp discounted with repo+1bp
PFT_FUT_1BP_FLAT_DISC	(PFT_FUT1BP_D_FLAT)		n/a		0bp		1bp		fut_pvbp discounted with repo flat
PFT_FUT_1BP_NO_DISC		(PFT_FUT1BP_D_NO)		n/a		n/a		1bp		fut_pvbp undiscounted	
PFT_FUT_1BP_BE_DISC		(PFT_FUT1BP_D_BE) 		1bp		be		1bp		fut_pvbp discounted with be-repo

PFT_BE_FUT_DISC			(PFT_FUTBEPL_D_1BP)		1bp		1bp		be		fut_pvbp adjusted for y sensitivity discounted with be repo+1bp
PFT_BE_FUT_NO_DISC		(PFT_FUTBEPL_D_NO)		1bp		1bp		be		fut_pvbp adjusted for y sensitivity undiscounted

PFT_INF_DISC			(PFT_FUTBE0R_D_FLAT)	1bp		0bp		be		inferred fut_pvbp discounted with repo flat
PFT_INF_NO_DISC			(PFT_FUTBE0R_D_NO)		1bp		0bp		be		inferred fut_pvbp undiscounted

PFT_REPO_INF_DISC								0bp		1bp		be		inferred (from repo) fut_pvbp discounted with repo flat
PFT_REPO_INF_NO_DISC							0bp		1bp		be		inferred (from repo) fut_pvbp undiscounted
PFT_PVBP_SYNT									0bp		0bp		1bp		risk of underlying synt bond
*/
//-------------------------------------------------------

/*-----------------------------------------------------------------------
  bond_future: pvbp_fut
  ----------------------------------------------------------------------*/
number bond_future.pvbp_fut(bond_fut_pvbp						pvbp_type,
							number								nominal,
							number option(nullable) 			delta,
							logical option(nullable) 			centered,
							logical option(nullable) 			disable_rounding,
							error_info option(nullable) 		error) option(hidden)

{	
	return this.pvbp_fut(null<bond>,null<number>,null<number>,null<day_count_method>,pvbp_type,nominal,
						 delta,centered,disable_rounding,error);
}
/*-----------------------------------------------------------------------
  bond_future: pvbp_fut
  ----------------------------------------------------------------------*/
number bond_future.pvbp_fut(integer 							idx,
							bond_fut_pvbp						pvbp_type,
							number								nominal,
							number option(nullable) 			delta,
							logical option(nullable) 			centered,
							logical option(nullable) 			disable_rounding,
							error_info option(nullable) 		error) option(hidden)

{
	try {
		if(idx == err_int())
			idx = ctd_idx_;
		bond b;
		number pf, repo;
		index_to_data(idx,b,pf,repo);
		return this.pvbp_fut(b,pf,repo,repo_dc_,pvbp_type,nominal,delta,centered,disable_rounding,error);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.pvbp_fut");
		return null<number >;
	}
		
}
/*-----------------------------------------------------------------------
  bond_future: pvbp_fut
  ----------------------------------------------------------------------*/
number bond_future.pvbp_fut(bond option(nullable)				ctd,
							number option(nullable) 			ctd_price_factor,
							number option(nullable)  			repo_rate,									
							day_count_method option(nullable) 	day_count_method,
							bond_fut_pvbp						pvbp_type,
							number								nominal,
							number option(nullable) 			delta,
							logical option(nullable) 			centered,
							logical option(nullable) 			disable_rounding,
							error_info option(nullable) 		error) option(hidden)

{	
	try{	
		func_helper_ctd(ctd,ctd_price_factor,repo_rate,	day_count_method,disable_rounding);

		instr_error_type t;
   		string 			s;	
		number  c = i().__bondfut_pvbp_all(ctd.i(), ctd_price_factor, repo_rate, day_count_method, 
											pvbp_type,nominal, delta, centered,disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.pvbp_fut");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.pvbp_fut");
		return null<number >;
	}
}


/*-----------------------------------------------------------------------
  bond_future: pvbp  <override, protected>  -->BACKWARD COMPAT
  ----------------------------------------------------------------------*/
number bond_future.pvbp(number	option(nullable) 	nominal,
						number option(nullable) 	delta,
						error_info option(nullable) error)

{
	return this.pvbp_synt(nominal,delta,false,true, error) ;
	
/*	switch(fs){
	case bond_fut_style.FWD_CASH_SETTLE:
	case bond_fut_style.SYNT_CASH_SETTLE:
	case bond_fut_style.SYNT_CASH_SETTLE_MTM:
		return this.pvbp_synt(nominal,delta,false,true, error) ;
	case bond_fut_style.PRICE_FACTOR_MTM:
	default:
		return this.pvbp(null<bond>, null<number>,  nominal, delta, false,true,error);
	}*/
	
}
/*-----------------------------------------------------------------------
  bond_future: pvbp  <override, protected>  -->BACKWARD COMPAT
  ----------------------------------------------------------------------*/
number bond_future.pvbp(number	option(nullable) 	nominal,
						number option(nullable) 	delta,
						logical option(nullable) 	centered,
						logical option(nullable) 	disable_rounding,
						error_info option(nullable) error)

{
	return this.pvbp_synt(nominal,delta,centered,disable_rounding, error) ;
	
/*	switch(fs){
	case bond_fut_style.FWD_CASH_SETTLE:
	case bond_fut_style.SYNT_CASH_SETTLE:
	case bond_fut_style.SYNT_CASH_SETTLE_MTM:
		return this.pvbp_synt(nominal,delta,centered,disable_rounding, error) ;
	case bond_fut_style.PRICE_FACTOR_MTM:
	default:
		return this.pvbp(null<bond>, null<number>,  nominal, delta, centered,disable_rounding,error);
	}

*/
}

/*-----------------------------------------------------------------------
  bond_future: pvbp
  ----------------------------------------------------------------------*/
number bond_future.pvbp(	number	option(nullable) 	nominal,
							number option(nullable) 	delta,
							logical option(nullable) 	disable_rounding,
							error_info option(nullable) error) 

{
	return this.pvbp(null<bond>,null<number>,nominal,delta,false,disable_rounding,error) ;
}
/*-----------------------------------------------------------------------
  bond_future: pvbp
  ----------------------------------------------------------------------*/
number bond_future.pvbp(	integer idx,
							number	option(nullable) 	nominal,
							number option(nullable) 	delta,
							logical option(nullable) 	disable_rounding,
							error_info option(nullable) error) 

{
	try {
		if(idx == err_int())
			idx = ctd_idx_;
		bond b;
		number pf, repo;
		index_to_data(idx,b,pf,repo);
		return this.pvbp(b,pf,nominal,delta,false,disable_rounding,error) ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.pvbp");
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  bond_future: pvbp
  //PFT_FUT1BP_D_NO
  ----------------------------------------------------------------------*/
number bond_future.pvbp(bond option(nullable)		ctd,
						number option(nullable) 	ctd_price_factor,									
						number	option(nullable) 	nominal,
						number option(nullable) 	delta,
						logical option(nullable) 	centered,
						logical option(nullable) 	disable_rounding,
						error_info option(nullable) error)

{	
	try{			
		number r;
		day_count_method d;
		func_helper_ctd(ctd,ctd_price_factor,r,	d,disable_rounding);
		
		instr_error_type t;
   		string 			s;	
		number  c = i().__bondfut_pvbp(ctd.i(), ctd_price_factor,  nominal, delta, centered,disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.pvbp");	
		return e ? null<number>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.pvbp");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  bond_future: pvbp_fwd_del
  ----------------------------------------------------------------------*/
number bond_future.pvbp_fwd_del(number	option(nullable) 	nominal,
								number option(nullable) 	delta,							
								error_info option(nullable) error) 

{
	logical centered = false;
	logical disable_rounding = true;
	return this.pvbp_fwd_del(null<bond>,null<number>,null<number>,null<number>,
						null<day_count_method>,nominal,delta,centered,disable_rounding,error) ;
}
/*-----------------------------------------------------------------------
  bond_future: pvbp_fwd_del
  ----------------------------------------------------------------------*/
number bond_future.pvbp_fwd_del(integer 					idx,
								number	option(nullable) 	nominal,
								number option(nullable) 	delta,							
								error_info option(nullable) error) 

{
	try {
		if(idx == err_int())
			idx = ctd_idx_;
		bond b;
		number pf, repo;
		index_to_data(idx,b,pf,repo);
		
		logical centered = false;
		logical disable_rounding = true;
		return this.pvbp_fwd_del(b,pf,repo,null<number>,repo_dc_,nominal,delta,centered,disable_rounding,error) ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.pvbp_fwd_del");
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  bond_future: pvbp_fwd_del
  ----------------------------------------------------------------------*/
number bond_future.pvbp_fwd_del(bond option(nullable)		ctd,
								number option(nullable) 	ctd_price_factor,
								number option(nullable) 	repo_rate,
								number option(nullable) 	cpn_reinv_rate,
								day_count_method option(nullable) day_count_method,										
								number	option(nullable) 	nominal,
								number option(nullable) 	delta,
								logical option(nullable) 	centered,
								logical option(nullable) 	disable_rounding,
								error_info option(nullable) error) 

{	
	try{
		func_helper_ctd(ctd,ctd_price_factor,repo_rate,	day_count_method,disable_rounding);
			
		instr_error_type t;
   		string 			s;	
		number  c = i().__bondfut_pvbp_fwd_del(ctd.i(), ctd_price_factor,  repo_rate, cpn_reinv_rate, day_count_method,
												nominal, delta, centered,disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.pvbp_fwd_del");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.pvbp_fwd_del");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  bond_future: pvbp_inferred
  ----------------------------------------------------------------------*/
number bond_future.pvbp_inferred(	number	option(nullable) 	nominal,
									number option(nullable) 	delta,
									logical option(nullable) 	disable_rounding,
									error_info option(nullable) error) 

{
	return this.pvbp_inferred(null<bond>,null<number>,nominal,delta,false,disable_rounding,error) ;
}
/*-----------------------------------------------------------------------
  bond_future: pvbp_inferred
  ----------------------------------------------------------------------*/
number bond_future.pvbp_inferred(	integer 					idx,
									number	option(nullable) 	nominal,
									number option(nullable) 	delta,
									logical option(nullable) 	disable_rounding,
									error_info option(nullable) error) 

{
	try {
		if(idx == err_int())
			idx = ctd_idx_;
		bond b;
		number pf, repo;
		index_to_data(idx,b,pf,repo);
		return this.pvbp_inferred(b,pf,nominal,delta,false,disable_rounding,error) ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.pvbp_inferred");
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  bond_future: pvbp_inferred
  ----------------------------------------------------------------------*/
number bond_future.pvbp_inferred(	bond option(nullable)		ctd,
									number option(nullable) 	ctd_price_factor,									
									number	option(nullable) 	nominal,
									number option(nullable) 	delta,
									logical option(nullable) 	centered,
									logical option(nullable) 	disable_rounding,
									error_info option(nullable) error) 
{	
	try{
		number r;
		day_count_method d;
		func_helper_ctd(ctd,ctd_price_factor,r,	d,disable_rounding);
		
		instr_error_type t;
   		string 			s;	
		number  c = i().__bondfut_pvbp_inferred(ctd.i(), ctd_price_factor,  nominal, delta, centered,disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.pvbp_inferred");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.pvbp_inferred");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  bond_future: pvbp_synt
  ----------------------------------------------------------------------*/
number bond_future.pvbp_synt(	number option(nullable) 	nominal,
								number option(nullable) 	delta,
								logical option(nullable) 	centered,
								logical option(nullable) 	disable_rounding,
								error_info option(nullable) error) 

{	
	try{
		if(null(disable_rounding))
			disable_rounding = true;
		
		instr_error_type t;
   		string 			s;	
		number  c = i().__bondfut_pvbp_synt( nominal, delta, centered,disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.pvbp_synt");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.pvbp_synt");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  bond_future: func_helper_ctd
  ----------------------------------------------------------------------*/
void bond_future.func_helper_ctd(	out bond ctd,
									out number ctd_price_factor,
									out number repo_rate,										
									out day_count_method day_count_method,
									out logical disable_rounding)
{
	integer ctd_idx;
	if(null(ctd)) {			
		ctd = this.ctd(ctd_price_factor, ctd_idx);	
	}

	QL_FAIL_COND(null(ctd), "invalid deliverable bond");
	
	QL_FAIL_COND(this.is_price_factor_style() && null(ctd_price_factor), "invalid price factor");
	
	if(ctd_idx != err_int() && null(repo_rate)) {
		repo_rate = repo_rates_[ctd_idx];
	}
	
	if(null(day_count_method))
		day_count_method = repo_dc_;

	QL_FAIL_COND(null(day_count_method), "invalid repo daycount method",this,true);
	
	if(null(disable_rounding))
		disable_rounding = true;
}

/*-----------------------------------------------------------------------
  bond_future: pvbp_effective
  ----------------------------------------------------------------------*/
number bond_future.pvbp_effective(	number	option(nullable) 	nominal,
									number option(nullable) 	delta,
									logical option(nullable) disable_rounding,
									error_info option(nullable) error)
{
	return this.pvbp_effective(	null<bond>,null<number>,null<number>,null<day_count_method>,
							delta,delta,nominal,false,disable_rounding,error) ;
}
/*-----------------------------------------------------------------------
  bond_future: pvbp_effective
  ----------------------------------------------------------------------*/
number bond_future.pvbp_effective(	integer 					idx,
									number	option(nullable) 	nominal,
									number option(nullable) 	delta,
									logical option(nullable) 	disable_rounding,
									error_info option(nullable) error)
{
	try {
		if(idx == err_int())
			idx = ctd_idx_;
		bond b;
		number pf, repo;
		index_to_data(idx,b,pf,repo);
		return this.pvbp_effective(b,pf,repo,repo_dc_,delta,delta,nominal,false,disable_rounding,error) ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.pvbp_effective");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  bond_future: pvbp_effective
  ----------------------------------------------------------------------*/
number bond_future.pvbp_effective(	bond option(nullable)	ctd,
									number option(nullable) ctd_price_factor,
									number option(nullable)  repo_rate,										
									day_count_method option(nullable) day_count_method,
									number	option(nullable) repo_shift,
									number	option(nullable) bond_shift,										
									number	option(nullable) nominal,										
									logical option(nullable) centered,
									logical option(nullable) disable_rounding,
									error_info option(nullable) error) 

{	
	try{	
		func_helper_ctd(ctd,ctd_price_factor,repo_rate,	day_count_method,disable_rounding);
		
		instr_error_type t;
   		string 			s;	
		number  c = i().__bondfut_pvbp_effective(ctd.i(), ctd_price_factor,  repo_rate,  day_count_method,repo_shift,
												bond_shift,nominal,  centered,disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.pvbp_effective");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.pvbp_effective");
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  bond_future: hdg_ratio_ctd
  ----------------------------------------------------------------------*/
number bond_future.hdg_ratio_ctd( logical 					incl_tail,
								  logical option(nullable) 	disable_rounding,
								  error_info option(nullable) error)
{
	return this.hdg_ratio_ctd(null<bond>,null<number>,null<number>,null<day_count_method>, incl_tail,disable_rounding,error) ;
}
/*-----------------------------------------------------------------------
  bond_future: hdg_ratio_ctd
  ----------------------------------------------------------------------*/
number bond_future.hdg_ratio_ctd(integer 					idx,
								 logical 					incl_tail,
								 logical option(nullable) 	disable_rounding,
								 error_info option(nullable) error)
{
	try {
		if(idx == err_int())
			idx = ctd_idx_;
		bond b;
		number pf, repo;
		index_to_data(idx,b,pf,repo);		
		return this.hdg_ratio_ctd(b,pf,repo,repo_dc_, incl_tail,disable_rounding,error) ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.hdg_ratio_ctd");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  bond_future: hdg_ratio_ctd
  ----------------------------------------------------------------------*/
number bond_future.hdg_ratio_ctd(	bond option(nullable)		ctd,
									number option(nullable) 	ctd_price_factor,
									number option(nullable) 	repo_rate,										
									day_count_method option(nullable) day_count_method,
									logical option(nullable) 	incl_tail,
									logical option(nullable) 	disable_rounding,
									error_info option(nullable) error) 

{	
	try{	
		func_helper_ctd(ctd,ctd_price_factor,repo_rate,	day_count_method,disable_rounding);
		
		instr_error_type t;
   		string 			s;	
		number  c = i().__bondfut_hdg_ratio_ctd(ctd.i(), ctd_price_factor,  repo_rate,  day_count_method, incl_tail, disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.hdg_ratio_ctd");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.hdg_ratio_ctd");
		return null<number >;
	}
}
//-------------------------------------------------------
// hdg_ratio_ctd
//-------------------------------------------------------
/*number bond_future.hdg_ratio_ctd(	bond option(nullable)		ctd,
									number option(nullable) 	ctd_price_factor,
									logical option(nullable)	incl_tail,	//required when not fwd_y_style_
									number  option(nullable)	delta,
									logical option(nullable)	centered,
									logical option(nullable)	disable_rnd,
									error_info option(nullable) error ) 	
{		
	try {
		if(fwd_y_style_) {
			
			number pvbpf = pvbp_fwd_del(null<bond>,null<number>,null<number>,null<number>,
										null<day_count_method>,null<number>,delta,centered,disable_rounding,error) ;
				
			number pvbpfs = pvbp_synt(null<number>, delta, centered, disable_rounding, error) ;
			return pvbpf/pvbps;
			f
			//return deliv_fwd_[idx_ctd_].pvbp(100, delta, centered, disable_rnd)/fut_.pvbp(100, delta, centered, disable_rnd);
		}
		else {
			if(null(incl_tail))
				return null<number>;
			if(incl_tail)
				return pf_[idx_ctd_] * disc_fact_ctd() ;
			else
				return pf_[idx_ctd_];
		}
	}
	catch {
		return null<number>;
	}		
}*/

/*-----------------------------------------------------------------------
  bond_future: hdg_ratio_pvbp
  ----------------------------------------------------------------------*/
number bond_future.hdg_ratio_pvbp(  logical option(nullable) disable_rounding,
									error_info option(nullable) error)
{
	return this.hdg_ratio_pvbp(null<bond>,null<number>,null<number>,null<day_count_method>, disable_rounding,error) ;
}

/*-----------------------------------------------------------------------
  bond_future: hdg_ratio_pvbp
  ----------------------------------------------------------------------*/
number bond_future.hdg_ratio_pvbp(  integer 					idx,
									logical option(nullable) 	disable_rounding,
									error_info option(nullable) error)
{
	try {
		if(idx == err_int())
			idx = ctd_idx_;
		bond b;
		number pf, repo;
		index_to_data(idx,b,pf,repo);
		return this.hdg_ratio_pvbp(b,pf,repo,repo_dc_, disable_rounding,error) ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.hdg_ratio_pvbp");
		return null<number >;
	}
}


/*-----------------------------------------------------------------------
  bond_future: hdg_ratio_pvbp
  ----------------------------------------------------------------------*/
number bond_future.hdg_ratio_pvbp(	bond option(nullable)		ctd,
									number option(nullable) 	ctd_price_factor,
									number option(nullable) 	repo_rate,										
									day_count_method option(nullable) day_count_method,									
									logical option(nullable) 	disable_rounding,
									error_info option(nullable) error) 

{	
	try{	
		func_helper_ctd(ctd,ctd_price_factor,repo_rate,	day_count_method,disable_rounding);
		
		instr_error_type t;
   		string 			s;	
		number  c = i().__bondfut_hdg_ratio_pvbp(ctd.i(), ctd_price_factor,  repo_rate,  day_count_method, disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.hdg_ratio_pvbp");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.hdg_ratio_pvbp");
		return null<number >;
	}
}
//-------------------------------------------------------
// hdg_ratio_pvbp
//-------------------------------------------------------
/*number bond_future.hdg_ratio_pvbp(	bond option(nullable)	ctd,
									number option(nullable) ctd_price_factor,
									number  option(nullable)	delta,
									logical option(nullable)	centered,
									logical option(nullable)	disable_rnd ) 	
{		
	try {
		if(!init_calc_ok_)
			return null<number>;

		number pvbp_ctd_spot = deliv_[idx_ctd_].pvbp(100, delta, centered, disable_rnd);
		if(fwd_y_style_)
			return pvbp_ctd_spot/(fut_.pvbp(100, delta, centered, disable_rnd)* disc_fact_ctd());			
		else {
			number pvbp_fut = deliv_fwd_[idx_ctd_].pvbp(100, delta, centered, disable_rnd)/pf_[idx_ctd_];
			return pvbp_ctd_spot/pvbp_fut;
		}
	}
	catch {
		return null<number>;
	}		
}*/

/*-----------------------------------------------------------------------
  mac_dur      <public>
  ----------------------------------------------------------------------*/
number  bond_future.mac_dur(error_info option(nullable) error) 
{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.mac_dur(error);

		
		QL_FAIL("work in progress for pf-style futures",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.mac_dur");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  mod_dur      <public>
  ----------------------------------------------------------------------*/
number  bond_future.mod_dur(error_info option(nullable) error) 
{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.mod_dur(error);

		
		QL_FAIL("work in progress for pf-style futures",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.mod_dur");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  dol_dur      <public>
  ----------------------------------------------------------------------*/
number  bond_future.dol_dur(error_info option(nullable) error) 
{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.dol_dur(error);

		
		QL_FAIL("work in progress for pf-style futures",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.dol_dur");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  convexity      <public>
  ----------------------------------------------------------------------*/
number  bond_future.convexity(error_info option(nullable) error) 
{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.convexity(error);

		
		QL_FAIL("work in progress for pf-style futures",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.convexity");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  dol_convexity      <public>
  ----------------------------------------------------------------------*/
number  bond_future.dol_convexity(	error_info option(nullable) error) 
{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.dol_convexity(error);

		
		QL_FAIL("work in progress for pf-style futures",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.dol_convexity");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  sensitivity      <public>
  ----------------------------------------------------------------------*/
number  bond_future.sensitivity(error_info option(nullable) error) 
{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.sensitivity(error);

		
		QL_FAIL("work in progress for pf-style futures",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.sensitivity");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  mac_dur_analytic
  ----------------------------------------------------------------------*/
number  bond_future.mac_dur_analytic(error_info option(nullable) error) 
{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.mac_dur_analytic(error);

		
		QL_FAIL("work in progress for pf-style futures",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.mac_dur_analytic");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  mod_dur_analytic
  ----------------------------------------------------------------------*/
number  bond_future.mod_dur_analytic(error_info option(nullable) error)  

{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.mod_dur_analytic(error);

		
		QL_FAIL("work in progress for pf-style futures",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.mod_dur_analytic");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  dol_dur_analytic
  ----------------------------------------------------------------------*/
number  bond_future.dol_dur_analytic(error_info option(nullable) error)  

{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.dol_dur_analytic(error);

		
		QL_FAIL("work in progress for pf-style futures",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.dol_dur_analytic");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  pvbp_analytic
  ----------------------------------------------------------------------*/
number  bond_future.pvbp_analytic(number option(nullable) nom,
								error_info option(nullable) error)  

{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.pvbp_analytic(nom,error);

		
		QL_FAIL("work in progress for pf-style futures",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.pvbp_analytic");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  convexity_analytic
  ----------------------------------------------------------------------*/
number  bond_future.convexity_analytic(error_info option(nullable) error)  

{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.convexity_analytic(error);

		
		QL_FAIL("work in progress for pf-style futures",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.convexity_analytic");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  dol_convexity_analytic
  ----------------------------------------------------------------------*/
number  bond_future.dol_convexity_analytic(error_info option(nullable) error)  

{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.dol_convexity_analytic(error);

		
		QL_FAIL("work in progress for pf-style futures",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.dol_convexity_analytic");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  sensitivity_analytic
  ----------------------------------------------------------------------*/
number  bond_future.sensitivity_analytic(error_info option(nullable) error)  

{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.sensitivity_analytic(error);

		
		QL_FAIL("work in progress for pf-style futures",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.sensitivity_analytic");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  last_trade_date
  ----------------------------------------------------------------------*/
date bond_future.last_trade_date(error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__bondfut_last_trade(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.last_trade_date");	
		return e ? null<date>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.last_trade_date");		
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  bond_future: settle_amount
  ----------------------------------------------------------------------*/
number  bond_future.settle_amount(	number  				market_quote,
									number option(nullable)	contract_quote,
									number option(nullable)	nominal,											
									logical					disc_to_trade,
									disc_func option(nullable)	disc_func,
									error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__bondfut_settle_amount(market_quote,contract_quote,nominal,disc_to_trade,disc_func,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.settle_amount");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.settle_amount");
		return null<number>;
	}
}



/*-----------------------------------------------------------------------
  bond_future: expiry_settle_date
  ----------------------------------------------------------------------*/
date bond_future.expiry_settle_date(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__bondfut_expiry_settle_date(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.expiry_settle_date");	
		return e ? null<date>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.expiry_settle_date");
		return null<date>;
	}
}

date bond_future.bondfut_synt_maturity(error_info option(nullable) error){	return this.synt_maturity(error);}
/*-----------------------------------------------------------------------
  bond_future: synt_maturity
  ----------------------------------------------------------------------*/
date bond_future.synt_maturity(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__bondfut_synt_maturity(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "bond_future.synt_maturity");	
		return e ? null<date>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.synt_maturity");
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  yield       <public> 	not for ext swap
  ----------------------------------------------------------------------*/
number  bond_future.yield(	logical 	disable_rounding,
							error_info option(nullable) error) 
{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.yield(disable_rounding,ee);
				
		number ctd_price_factor;
		integer ctd_idx;
		bond ctd_bond = this.ctd(ctd_price_factor,ctd_idx, ee);				
		QL_FAIL_COND(null(ctd_bond), "invalid cheapest-to-deliver bond",this,true, E_INIT);

		number cp_fut 	= this.clean_price(null<number>,false,true,ee);
		bond deliv_fwd 	= this.deliv_fwd(ctd_idx, ee);
		
		number dp_fwd 	= cp_fut * ctd_price_factor + deliv_fwd.accrued(false,true,ee);			
		number y 		= deliv_fwd.price_to_yield(dp_fwd, ..quote_style.DIRTY_PCT, ee);
		return y;
		
						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.yield");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  yield	     <public>	not for ext swap
  ----------------------------------------------------------------------*/
number  bond_future.yield(	disc_func		disc_func,
							logical 		disable_rounding ,								
							error_info option(nullable) error)
{	
	try{
		
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.yield(disc_func,disable_rounding,ee);
			

		number ctd_price_factor;
		integer ctd_idx;
		bond ctd_bond = this.ctd(ctd_price_factor,ctd_idx, ee);				
		QL_FAIL_COND(null(ctd_bond), "invalid cheapest-to-deliver bond",this,true, E_INIT);

		number cp_fut 	= this.clean_price(null<number>,false,true,ee);
		bond deliv_fwd 	= this.deliv_fwd(ctd_idx, ee);
		
		number dp_fwd 	= cp_fut * ctd_price_factor + deliv_fwd.accrued(false,true,ee);
		deliv_fwd		= deliv_fwd.set_dirty_price(dp_fwd,null<date>, null<date>,ee);
		number y 		= deliv_fwd.yield(disc_func,disable_rounding, ee);
		
		return y;
		
							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.yield");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  price_to_yield     <public>
  ----------------------------------------------------------------------*/
number  bond_future.price_to_yield(	number price,
									..quote_style qs_price,									
									error_info option(nullable) error) 
{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.price_to_yield(price,qs_price,error);
		
		QL_REQUIRE(qs_price == ..quote_style.CLEAN_PCT || qs_price == ..quote_style.DIRTY_PCT, "quote_style not applicable for this type of future");
		
		number ctd_price_factor;
		integer ctd_idx;
		bond ctd_bond = this.ctd(ctd_price_factor,ctd_idx, ee);				
		QL_FAIL_COND(null(ctd_bond), "invalid cheapest-to-deliver bond",this,true, E_INIT);
		
		bond deliv_fwd 	= this.deliv_fwd(ctd_idx, ee);
		
		number dp_fwd 	= price * ctd_price_factor + deliv_fwd.accrued(false,true,ee);
		deliv_fwd		= deliv_fwd.set_dirty_price(dp_fwd,null<date>, null<date>,ee);
		number y 		= deliv_fwd.price_to_yield(dp_fwd, ..quote_style.DIRTY_PCT, ee);
	
		return y;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.price_to_yield");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  dirty_price_to_yield     <public> (cannot be hidden because of vba)
  ----------------------------------------------------------------------*/
number  bond_future.dirty_price_to_yield(number dirty_price_pcnt,
										logical disable_rounding ,									
										error_info option(nullable) error)
{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.dirty_price_to_yield(dirty_price_pcnt,disable_rounding,error);
		else
			return this.price_to_yield(	dirty_price_pcnt, ..quote_style.DIRTY_PCT, error) ;			
						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.dirty_price_to_yield");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  clean_price_to_yield     <public>  (cannot be hidden because of vba)
  ----------------------------------------------------------------------*/
number  bond_future.clean_price_to_yield(number clean_price_pcnt,
										logical disable_rounding ,									
										error_info option(nullable) error)
{	
	return this.price_to_yield(clean_price_pcnt, ..quote_style.CLEAN_PCT, error) ;
}
/*-----------------------------------------------------------------------
  dirty_price    <public>
  ----------------------------------------------------------------------*/
number  bond_future.dirty_price(number option(nullable)		yield,
								logical 					disable_rounding,
								logical 					in_pcnt,									
								error_info option(nullable) error) 
{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.dirty_price(yield,disable_rounding,in_pcnt,error);
		else  			
			return this.clean_price(yield,disable_rounding,in_pcnt,error);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.dirty_price");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  dirty_price    <public>
  ----------------------------------------------------------------------*/
number  bond_future.dirty_price(logical 	disable_rounding,
								logical 	in_pcnt,									
								error_info option(nullable) error) 
{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.dirty_price(disable_rounding,in_pcnt,error);
		else			
			return this.clean_price(disable_rounding,in_pcnt,error);				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.dirty_price");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  dirty_price    <public>
  ----------------------------------------------------------------------*/
number  bond_future.dirty_price(disc_func		disc_func,
								logical 		disable_rounding,								
								logical 		in_pcnt,									
								error_info option(nullable) error) 
{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.dirty_price(disc_func, disable_rounding,in_pcnt,error);
		else
			return this.clean_price(disc_func, disable_rounding,in_pcnt,error);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.dirty_price");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  clean_price   <public>
  ----------------------------------------------------------------------*/
number  bond_future.clean_price(number	option(nullable)	yield,
								logical 					disable_rounding,
								logical 					in_pcnt,									
								error_info option(nullable) error) 
{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf || null(yield))
			return instrument.clean_price(yield, disable_rounding,in_pcnt,error);

		QL_REQUIRE(in_pcnt, "in_pcnt must be true for this type of future",this,true);
			
		number ctd_price_factor;
		integer ctd_idx;
		bond ctd_bond = this.ctd(ctd_price_factor,ctd_idx, ee);				
		QL_FAIL_COND(null(ctd_bond), "invalid cheapest-to-deliver bond",this,true, E_INIT);
		
		bond deliv_fwd 	= this.deliv_fwd(ctd_idx, ee);

		number cp_fwd 	= deliv_fwd.clean_price(yield, disable_rounding,true,ee);
		number cp 		= cp_fwd/ctd_price_factor;
		return cp;
						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.clean_price");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  clean_price   <public>
  ----------------------------------------------------------------------*/
number  bond_future.clean_price(logical 	disable_rounding,
								logical 	in_pcnt,									
								error_info option(nullable) error) 
{	
	try{
		return this.clean_price(null<number>, disable_rounding, in_pcnt,error) ;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.clean_price");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  clean_price   <public>
  ----------------------------------------------------------------------*/
number  bond_future.clean_price(disc_func		disc_func,
								logical 		disable_rounding,								
								logical 		in_pcnt,									
								error_info option(nullable) error) 
{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.clean_price(disc_func, disable_rounding,in_pcnt,error);
		
		QL_REQUIRE(in_pcnt, "in_pcnt must be true for this type of future",this,true);
			
		number ctd_price_factor;
		integer ctd_idx;
		bond ctd_bond = this.ctd(ctd_price_factor,ctd_idx, ee);				
		QL_FAIL_COND(null(ctd_bond), "invalid cheapest-to-deliver bond",this,true, E_INIT);
		
		bond deliv_fwd 	= this.deliv_fwd(ctd_idx, ee);

		number cp_fwd 	= deliv_fwd.clean_price(disc_func, disable_rounding,true,ee);
		number cp 		= cp_fwd/ctd_price_factor;
		return cp;
		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.clean_price");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  yield_to_price  <public>
  ----------------------------------------------------------------------*/
number  bond_future.yield_to_price(	number 			yield,//decimal
									..quote_style 	qs_price,									
									error_info option(nullable) error) 
{	
	try{
		error_info  ee = error_info(true,true);
		logical is_pf 	= is_price_factor_style(ee);

		if(!is_pf)
			return instrument.yield_to_price(yield, qs_price,error);
		
		if(qs_price == ..quote_style.CLEAN_PCT || qs_price == ..quote_style.DIRTY_PCT)
			return this.clean_price(yield,false,true, error) ;
		else
			QL_FAIL("quote_style is not applicable for this type of future",this,true);
		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.yield_to_price");
		return null<number>;
	}
}

//-------------------------------------------------------
// disc_fact
//-------------------------------------------------------
number bond_future.disc_fact(	number option(nullable) r,									
								error_info option(nullable) error)
{
	try{
		if(null(r)) {
			integer ctd_idx;
			number ctd_price_factor;		
			bond ctd;
			ctd = this.ctd(ctd_price_factor, ctd_idx);
			if(ctd_idx != err_int()) 
				r = repo_rates_[ctd_idx];
		}
			
		QL_REQUIRE(!null(r), "invalid repo rate",this,true);
		
		error_info  ee = error_info(true,true);
		return ..present_value(1, r,  this.settle_date_deliv(ee), this.expiry_settle_date(ee), repo_dc_, rate_type.RT_SIMPLE);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future.disc_fact");		
		return null<number>;
	}
}

//-------------------------------------------------------
// pl_yfut_chg	
//-------------------------------------------------------	
number bond_future.pl_yfut_chg(	number 		y_shift,
								logical option(nullable) incl_disc,	//to the horizon date 
								number option(nullable) disc_rate,
								date option(nullable) horizon,
								number 		nominal,
								logical 	buy_fut,
								logical		disable_rnd,									
								error_info option(nullable) error)
{							
	try {
		
		if(y_shift == 0)
			return 0;

		error_info  ee = error_info(true,true);
	
		date settle = settle_date_deliv(ee);
		date expiry = expiry_settle_date(ee);

		if(null(incl_disc))
			incl_disc = false;
		
		if(null(horizon) || horizon < settle)
			horizon = settle;
		
		number y_fwd 	= yield(false,ee);
		number y_new 	= y_fwd + y_shift;
		
		number cp_fut		= this.clean_price(null<number>,false,true,ee);
		number cp_fut_diff	= this.clean_price(y_new,false,true,ee);			
		number pl = (buy_fut ? cp_fut_diff - cp_fut : cp_fut - cp_fut_diff)/100*nominal;							
				
		if(!incl_disc || this.is_daily_mtm(ee))
			return pl;
		
		
		if(horizon <= settle)
			return  pl * disc_fact(disc_rate);
		else {					
			if(horizon >= expiry){
				return pl;
			}
			else {
				return  pl * ..present_value(1, disc_rate,  horizon , expiry, repo_dc_, rate_type.RT_SIMPLE);
			}
		}			
	}
	catch {
		return null<number>;
	}
}

