option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	deposit
	--------------------------------------------------------------------
*/

//-----------------------------------------------------------------------
//  class deposit (only singleflow instrument for now)
// change function names yield -> rate
//----------------------------------------------------------------------
class deposit : public instrument
option(category: "Instrument/Deposit")
//option(allow_undeclared_mfuncs)
{
public:
    //override string			instr_type_s();
	override instrument 	inst();

/*	--------------------------------
	---OVERRIDES (HIDDEN IN ROOT) --- 
	--------------------------------
		- implemented in root for backward compat reasons
*/
	//--add-funcs--			
	override void 			add_nominal(number );										
	override void 			add_quote(number,logical option(nullable) set_coupon_to_quote = null<logical> );
	override void 			add_quote_from_yield(number,logical option(nullable) set_coupon_to_yield = null<logical>);

	//--general--	
	override logical 		eom(error_info option(nullable) error = null<error_info>  );	
	override string 		maturity_code(error_info option(nullable) error = null<error_info>  );
	override bd_convention 	pmt_bus_day(error_info option(nullable) error = null<error_info>  );
	override day_count_method dc_method(error_info option(nullable) error = null<error_info>  );
	override date 			next_cpn_date(error_info option(nullable) error = null<error_info>  );
	override date 			first_cpn_date(error_info option(nullable) error = null<error_info> );
	override date 			first_settle_date(error_info option(nullable) error = null<error_info> );
	override number 		first_cpn_amount(error_info option(nullable) error = null<error_info>  );	
	override number 		next_cpn_amount(error_info option(nullable) error = null<error_info>  );	
	override date 			cpn_start_date(error_info option(nullable) error = null<error_info>  );			
	override ir_index 		ir_index(error_info option(nullable) error = null<error_info>  );
	override string 		index_tenor(error_info option(nullable) error = null<error_info>) ;				
	override tenor_code 	index_tenor_code(error_info option(nullable) error = null<error_info>);
	logical 				is_index();
	override date			index_maturity(error_info option(nullable) error = null<error_info>  );
	
	//--fixed income: price--
	override number 		accrued_chg(integer,out number,out date ,
										out date,logical in_pcnt = true,
										error_info option(nullable) error = null<error_info> ) ; 												
	override number 		accrued_period(error_info option(nullable) error = null<error_info> );
	override integer		accrued_days(error_info option(nullable) error= null<error_info>);
	override number 		clean_price_to_coupon(number,disc_func,
												  error_info option(nullable) error = null<error_info> ) ;

	override number			yield(	disc_func,logical ,error_info option(nullable) error = null<error_info>);
	override number 		yield(logical disable_rounding = false,
							  error_info option(nullable) error = null<error_info> );

	number					par_rate(	disc_func	,
										error_info option(nullable) error = null<error_info> );
	//-----fwd price-----


	/*
		convexity_cf, pl_intraday
	*/

/*	--------------------------------
	---OVERRIDES (PUBLIC i.e. NOT HIDDEN IN ROOT) --- 
	--------------------------------
		-implemented in root
		-required
*/
	override deposit 		set_quote(number option(nullable),
									  error_info option(nullable) error = null<error_info>);
	override deposit 		set_quote(string option(nullable),
									  error_info option(nullable) error = null<error_info>);
	override deposit		set_quote_from_yield(number option(nullable) ,
												 error_info option(nullable) error = null<error_info>); /*legacy, hidden, hidden in root*/
	
/*	--------------------------------
	---OVERRIDES (HIDDEN IN ROOT, THROWS IN ROOT) --- 
	--------------------------------
		-implemented in root with "-" prefix
		-here if applicable
*/
	override deposit  		set_date(date,
									 date option(nullable) settle_date = null<date>,
									 logical re_init_static = true,
									 logical init_quote = true  ,
									 error_info option(nullable) error = null<error_info>);
	
	override deposit		set_settle_date(date,
											logical re_initialize /*= true*/,
											error_info option(nullable) error = null<error_info> );
	
	override deposit 		set_clean_price(number option(nullable),
											date option(nullable) trade_date  = null<date>,
											date option(nullable) settle_date = null<date>,
											error_info option(nullable) error = null<error_info> );	
	override deposit 		set_dirty_price(number option(nullable),
											date option(nullable) trade_date  = null<date>,
											date option(nullable) settle_date = null<date>, 
											error_info option(nullable) error = null<error_info> );	
	override deposit		set_yield(number option(nullable) ,
									  error_info option(nullable) error = null<error_info>);
		
/*	--------------------------------
	---LOCALS (NOT EXPOSED IN ROOT) 
	--------------------------------
		-implemented in root with "-" prefix
		-here if applicable
*/
	deposit 				set_quote(number option(nullable),
									  date  option(nullable) ,
									  date option(nullable) settle_date = null<date>,
									  logical option(nullable) set_to_par= true,
									  error_info option(nullable) error = null<error_info>);
	
	deposit 				set_quote(string option(nullable),
									  date  option(nullable) ,
									  date option(nullable) settle_date = null<date>,
									  logical option(nullable) set_to_par= true,
									  error_info option(nullable) error = null<error_info>);
	
	deposit					set_yield(number option(nullable) ,
									  date option(nullable),
									  date option(nullable) settle_date = null<date>,
									  logical option(nullable) set_to_par = true,
									  error_info option(nullable) error = null<error_info>);
	
	deposit					set_quote_from_yield(number option(nullable),
												 logical option(nullable)  ,
												 error_info option(nullable) error = null<error_info>);	
		
	deposit(__instrument);	
	override deposit clone();
	deposit(deposit);
protected:
	
	override deposit  		create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);
	override deposit 		set_date(date,
									 logical ,
									 error_info option(nullable) error = null<error_info> );						/*legacy*/
	override deposit 		move_date(date,
									  date option(nullable) settle_date = null<date>,
									  error_info option(nullable) error = null<error_info> );						/*legacy*/
	/*errs*/
	override number 		face_amount(error_info option(nullable) error = null<error_info>);
	override integer 		coupon_freq(error_info option(nullable) error = null<error_info> );
};

//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
deposit.deposit(__instrument i) option(hidden): instrument(i)	{}

//------------------------------------------------
// create  [PROTECTED]
// create deposit from internal instrument
//------------------------------------------------
deposit deposit.create(	__instrument option(nullable) 		c,
						out instr_error option(nullable) 	error,
						error_type 							type ) 
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<deposit>; 

	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.DEPOSIT && it != ..instr_type.DEPOSIT_INDEX, "invalid instrument type",type );//should not happen
		
	return new deposit(c);
}

/*-----------------------------------------------------------------------
  create_deposit <FUNCTION>
  ----------------------------------------------------------------------*/

deposit create_deposit(	__instrument option(nullable) 		c,
						out instr_error option(nullable) 	error,
						error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_deposit')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<deposit>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.DEPOSIT && it != ..instr_type.DEPOSIT_INDEX, "invalid instrument type",type );//should not happen
	
	return new deposit(c);
}

deposit create_deposit(	__instrument option(nullable) 		c,
						error_info option(nullable) 		error,
						error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_deposit_ei')
{
	instr_error ee 	= instr_error();
	deposit dep 	= create_deposit(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_deposit");
	return dep;
}
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string	deposit.instr_type_s() 	{ return is_index() ? string(..instr_type.DEPOSIT_INDEX) : string(..instr_type.DEPOSIT);}

//------------------------------------------------
// inst
//------------------------------------------------
instrument 	deposit.inst()		{ return this;}

//------------------------------------------------
// copy constructor
//------------------------------------------------
deposit.deposit(deposit c) : instrument(c) {}

//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
deposit deposit(deposit d)			{ return new deposit(d);}
//------------------------------------------------
// clone
//------------------------------------------------
deposit deposit.clone()				{ return new deposit(this);}
//-----------------------------------------------
// dynamic cast <FUNCTION>
//-----------------------------------------------
deposit deposit(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Deposit') 
option(com_name: 'deposit_dyncast')
{
	try {
		deposit d = dynamic_cast<deposit>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a deposit)","deposit" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "deposit");
		return null<deposit>;
	}
}

/*-----------------------------------------------------------------------
  add_nominal 
  ----------------------------------------------------------------------*/
void deposit.add_nominal(number nominal) 
{			
	instrument.add_nominal(nominal );
	return ;						
}

/*-----------------------------------------------------------------------
  add_quote
  ----------------------------------------------------------------------*/
void deposit.add_quote(	number  quote,
						logical option(nullable) set_to_par ) 
{	
	instrument.add_quote(quote, set_to_par);
	return ;						
}
/*-----------------------------------------------------------------------
  add_quote_from_yield
  ----------------------------------------------------------------------*/

void deposit.add_quote_from_yield(	number  quote,
									logical option(nullable) set_to_par )
{
	instrument.add_quote_from_yield(quote, set_to_par );
}
/*-----------------------------------------------------------------------
  hidden in root members
  ----------------------------------------------------------------------*/
logical  deposit.is_index()		{ return this.instr_type() == ..instr_type.DEPOSIT_INDEX;}

..ir_index deposit.ir_index(error_info option(nullable) error)
{
	if(!this.is_index())
		return fin_instr.err_type(null<..ir_index>, error, "deposit.ir_index");
	return instrument.ir_index(error);
}
string deposit.index_tenor(error_info option(nullable) error)
{
	if(!this.is_index())
		return fin_instr.err_type(null<string>, error, "deposit.index_tenor");
	return instrument.index_tenor(error);
}

tenor_code deposit.index_tenor_code(error_info option(nullable) error)
{
	if(!this.is_index())
		return fin_instr.err_type(null<tenor_code>, error, "deposit.index_tenor_code");
	return instrument.index_tenor_code(error) ;
}

logical deposit.eom(error_info option(nullable) error)				{ return instrument.eom(error);}
string 	deposit.maturity_code(error_info option(nullable) error) 	{ return instrument.maturity_code(error);}
date  	deposit.next_cpn_date(error_info option(nullable) error) 	{ return instrument.next_cpn_date(error);}
date  	deposit.first_cpn_date(error_info option(nullable) error)	{ return instrument.first_cpn_date(error);}
date  	deposit.first_settle_date(error_info option(nullable) error){ return instrument.first_settle_date(error);}
bd_convention deposit.pmt_bus_day(error_info option(nullable) error)  { return instrument.pmt_bus_day(error);}
day_count_method deposit.dc_method(error_info option(nullable) error) { return instrument.dc_method(error);}

number  deposit.accrued_period(error_info option(nullable) error)		{ return instrument.accrued_period(error);}
integer	deposit.accrued_days(error_info option(nullable) error)			{ return instrument.accrued_days(error);}	
number  deposit.first_cpn_amount(error_info option(nullable) error) 	{ return instrument.first_cpn_amount(error);}
number  deposit.next_cpn_amount(error_info option(nullable) error) 		{ return instrument.next_cpn_amount(error);}
date 	deposit.cpn_start_date(error_info option(nullable) error) 		{ return instrument.cpn_start_date(error);}
number  deposit.accrued_chg(integer bus_days_fwd, 
							out number	cpn_cashflow,
							out date settle,
							out date settle_next,
							logical 	in_pcnt,
							error_info option(nullable) error) 				{ return instrument.accrued_chg(bus_days_fwd, cpn_cashflow,settle,settle_next,in_pcnt,error);}

number deposit.clean_price_to_coupon(	number clean_price_pcnt,
										disc_func disc_func,								
										error_info option(nullable) error) 	{ return instrument.clean_price_to_coupon(clean_price_pcnt,disc_func,error);}


number deposit.face_amount(error_info option(nullable) error){ return fin_instr.err_type(null<number>, error, "deposit.face_amount");}
integer deposit.coupon_freq(error_info option(nullable) error){ return instrument.err_type_freq(err_freq(), error, "deposit.coupon_freq");}

/*-----------------------------------------------------------------------
   index_maturity
  ----------------------------------------------------------------------*/
date 	deposit.index_maturity(error_info option(nullable) error)
{
	if(this.is_index())
		return instrument.maturity(error);
	else
		return instrument.index_maturity(error);
}


/*-----------------------------------------------------------------------
   par_rate
  ----------------------------------------------------------------------*/
number  deposit.par_rate(	disc_func		disc_func,
							error_info option(nullable) error)
{
	try{
		error_info ee = new error_info(true,true);
		date issue = this.issue_date(ee);
		date settle = this.settle_date(ee);

		if(!null(issue) && !null(settle) && issue == settle)
			return clean_price_to_coupon(100, disc_func, error) ;
		else
			QL_FAIL("function only applicable when start date equals settlement date", this, true);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "deposit.par_rate");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  yield
  ----------------------------------------------------------------------*/
number  deposit.yield(	disc_func		disc_func,
						logical 		disable_rounding ,								
						error_info option(nullable) error)
option(com_name: 'yield_fit')
{	
	try{
		error_info ee = new error_info(true,true);
		number coupon = this.coupon(ee);		
		if(null(coupon))
			return clean_price_to_coupon(100, disc_func, error) ;
		
		instr_error_type t;
   		string 			s;	
		number c = i().__yield(disc_func, disable_rounding , t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "deposit.yield");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "deposit.yield");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  yield   
  ----------------------------------------------------------------------*/
number  deposit.yield(	logical 	disable_rounding,
						error_info option(nullable) error) 
{	
	return instrument.yield(disable_rounding,error);
}
/*-----------------------------------------------------------------------
  deposit: set_quote 
  ----------------------------------------------------------------------*/
deposit deposit.set_quote(	number 	option(nullable) quote,
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, true,error);
	return null(cc) ? null<deposit>: dynamic_cast<deposit>(cc);
}

/*-----------------------------------------------------------------------
  deposit: set_quote 
  ----------------------------------------------------------------------*/
deposit deposit.set_quote(	string 	option(nullable) quote_side,
							error_info option(nullable) error)
option(com_name: 'set_quote_qs')
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, true,error);
	return null(cc) ? null<deposit>: dynamic_cast<deposit>(cc);
}
/*-----------------------------------------------------------------------
  deposit: set_quote 
  ----------------------------------------------------------------------*/
deposit deposit.set_quote(	number 	option(nullable) quote,
							date  	option(nullable) trade_date, 
							date  	option(nullable) settle_date, 
							logical option(nullable) set_to_par,
							error_info option(nullable) error)
option(com_name: 'set_quote_ext')
{	
	instrument cc = instrument._set_quote(quote,trade_date, settle_date, set_to_par,error);
	return null(cc) ? null<deposit>: dynamic_cast<deposit>(cc);
}

/*-----------------------------------------------------------------------
  deposit: set_quote
  ----------------------------------------------------------------------*/
deposit deposit.set_quote(	string 	option(nullable) quote_side,
							date  	option(nullable) trade_date, 
							date  	option(nullable) settle_date, 
							logical option(nullable) set_to_par,
							error_info option(nullable) error)
option(com_name: 'set_quote_qs_ext')
{	
	instrument cc = instrument._set_quote(quote_side,trade_date, settle_date, set_to_par,error);
	return null(cc) ? null<deposit>: dynamic_cast<deposit>(cc);
}
/*-----------------------------------------------------------------------
  deposit: set_date
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
deposit deposit.set_date(	date  				trade_date, 
							date  option(nullable)	settle_date,
							logical 			re_init_static, 
							logical 			re_init_quote, 
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,settle_date,re_init_static,re_init_quote,error);
	return null(cc) ? null<deposit>: dynamic_cast<deposit>(cc);
	
}

/*-----------------------------------------------------------------------
  set_date  <protected/legacy>
	quote is NOT kept even if trade_date is unchanged
  ----------------------------------------------------------------------*/
deposit deposit.set_date(	date  				trade_date, 
							logical 			re_init_static, 
							error_info  option(nullable) error) 
{	
	instrument cc = instrument._set_date(trade_date,re_init_static,error);
	return null(cc) ? null<deposit>: dynamic_cast<deposit>(cc);	
}

/*-----------------------------------------------------------------------
  deposit: move_date  <protected/legacy>
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	if trade date is the same --> the settle date will be preserved
	NOTE: 	if coupon is defined in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
deposit deposit.move_date(	date  				trade_date, 
							date option(nullable) settle_date,
							error_info option(nullable) error)
{	
	instrument cc = instrument._move_date(trade_date,settle_date,error);
	return null(cc) ? null<deposit>: dynamic_cast<deposit>(cc);
}

/*-----------------------------------------------------------------------
  deposit: set_clean_price
  ----------------------------------------------------------------------*/
deposit deposit.set_clean_price(	number 	option(nullable) clean_pct,
									date  	option(nullable) trade_date, 
									date  	option(nullable) settle_date, 
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_clean_price(clean_pct,trade_date, settle_date,error);
	return null(cc) ? null<deposit>: dynamic_cast<deposit>(cc);
}

/*-----------------------------------------------------------------------
  deposit: set_dirty_price
  ----------------------------------------------------------------------*/
deposit deposit.set_dirty_price(	number 	option(nullable) dirty_pct,
									date  	option(nullable) trade_date, 
									date  	option(nullable) settle_date, 
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_dirty_price(dirty_pct,trade_date, settle_date,error);
	return null(cc) ? null<deposit>: dynamic_cast<deposit>(cc);
}

/*-----------------------------------------------------------------------
  deposit: set_yield
  ----------------------------------------------------------------------*/
deposit deposit.set_yield(	number 	option(nullable) yield,
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_yield(	yield, null<date>, null<date>,true, error);
	return null(cc) ? null<deposit>: dynamic_cast<deposit>(cc);
}

/*-----------------------------------------------------------------------
  deposit: set_yield
  ----------------------------------------------------------------------*/
deposit deposit.set_yield(	number 	option(nullable) yield,
							date  	option(nullable) trade_date, 
							date  	option(nullable) settle_date, 
							logical option(nullable) set_to_par,
							error_info option(nullable) error)
option(com_name: 'set_yield_ext')
{	
	instrument cc = instrument._set_yield(	yield, trade_date, settle_date,set_to_par, error);
	return null(cc) ? null<deposit>: dynamic_cast<deposit>(cc);
}

/*-----------------------------------------------------------------------
  deposit: set_settle_date
  ----------------------------------------------------------------------*/
deposit deposit.set_settle_date(	date  				settle_date, 
									logical 			re_init_static, 
									error_info option(nullable) error)
{		
	instrument cc = instrument._set_settle_date(settle_date, re_init_static, error);
	return null(cc) ? null<deposit>: dynamic_cast<deposit>(cc);
}
/*-----------------------------------------------------------------------
  deposit: set_quote_from_yield
  ----------------------------------------------------------------------*/
deposit deposit.set_quote_from_yield(	number 	option(nullable) yield,
										logical option(nullable) set_to_par,
										error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote_from_yield(yield,  set_to_par,error);
	return null(cc) ? null<deposit>: dynamic_cast<deposit>(cc);
}
/*-----------------------------------------------------------------------
  deposit: set_quote_from_yield
  ----------------------------------------------------------------------*/
deposit deposit.set_quote_from_yield(	number 	option(nullable) yield,
										error_info option(nullable) error)
option(hidden)
{	
	instrument cc = instrument._set_quote_from_yield(yield,  true,error);
	return null(cc) ? null<deposit>: dynamic_cast<deposit>(cc);
}

module CORE_INT_DEPO
{
	
	/*-----------------------------------------------------------------------
	  risk_ladder
	  ----------------------------------------------------------------------*/
	void  risk_ladder_fwd(	deposit 			depo,
							logical 			borrow,//=payfix
							number 				nominal,
							disc_func			df,
							vector(fwd_func) 	f_v_pert,
							fwd_func 			f_base,
							fwd_func option(nullable) f_all,
							out vector(number) 	pv_diff_pert,
							out number 			pv_diff_all,
							number 				y_shift,
							error_info option(nullable) error ) 
	{
		error_info ee 		= new error_info(true,true);
		number sign 		= borrow ? 1.0: -1.0; 
		/*
		 fwd_shift == cpn_r up --> pv up: no sign --> positive
		 borrow = short bond --> positive
		
		 */
		integer size 		= v_size(f_v_pert);
		resize(pv_diff_pert,size);
		pv_diff_pert 		= 0;

		date d 				= depo.trade_date();
		date stl			= depo.settle_date();
		number per 			= (stl-d)/365.0;
		number  r 			= f_base.fwd(per) ;
		deposit depo_		= depo.set_yield(r,null<date>, null<date>,true,ee);
		number pv_base 		= abs(depo_.present_value(df,nominal,false, null<disc_func> , ee));
		//number nom 			= depo.nominal(ee);
		number shift_mult 	= 0.0001 / y_shift;
		number mult 		= sign*shift_mult;
		
		for(integer i=0;i<size;i++){
			QL_FAIL_COND(null(f_v_pert[i]), "fwd_func in vector not valid", depo.name(), true);
			r 				= f_v_pert[i].fwd(per) ;
			depo_			= depo_.set_yield(r,null<date>, null<date>,true,ee);
			number pvi 		= abs(depo_.present_value(df,nominal,false, null<disc_func> , ee));
			//r up --> pvi < pv_base
			pv_diff_pert[i] = (pvi - pv_base)*mult;			
		}
		if(!null(f_all)){

			r 				= f_all.fwd(per) ;
			depo_			= depo_.set_yield(r,null<date>, null<date>,true,ee);
			number pv_all 	= abs(depo_.present_value(df,nominal,false, null<disc_func> , ee));
			pv_diff_all 	= (pv_all - pv_base)*mult;
		}
		else {
			pv_diff_all 	= null<number>;
		}
			
	}
	/*-----------------------------------------------------------------------
	  risk_ladder
	  ----------------------------------------------------------------------*/
	void  risk_ladder_disc(	deposit 			depo,
							logical 			pay,
							number 				nominal,						
							vector(disc_func) 	df_v_pert,
							disc_func			df_base,
							disc_func option(nullable) df_all,
							out vector(number) 	pv_diff_pert,
							out number 			pv_diff_all,
							number 				y_shift,
							error_info option(nullable) error ) 
	{
		error_info ee 		= new error_info(true,true);
		number sign 		= pay ? -1.0: 1.0; 
		/*
		 disc_shift == disc_r up --> pv down: no sign --> negative result
		 pay = short bond --> positive (we reverse the sign)
		 
		 */
		integer size 		= v_size(df_v_pert);
		resize(pv_diff_pert,size);
		pv_diff_pert 		= 0;
			
		number  r 			= depo.yield(df_base,false,ee) ;
		deposit depo_		= depo.set_yield(r,null<date>, null<date>,true,ee);
		number pv_base 		= abs(depo_.present_value(df_base,nominal,false, null<disc_func> , ee));
		//number nom 			= depo.nominal(ee);
		number shift_mult 	= 0.0001 / y_shift;
		number mult 		= sign*shift_mult;
		
		for(integer i=0;i<size;i++){
			QL_FAIL_COND(null(df_v_pert[i]), "disc_func in vector not valid", depo.name(), true);
			number pvi 		= abs(depo_.present_value(df_v_pert[i],nominal,false, null<disc_func> , ee));		
			pv_diff_pert[i] = (pvi - pv_base)*mult;			
		
		}
		if(!null(df_all)){
			number pv_all 	= abs(depo_.present_value(df_all,nominal,false, null<disc_func> , ee));			
			pv_diff_all 	= (pv_all - pv_base)*mult;
		}
		else {
			pv_diff_all 	= null<number>;
		}
			
	}
}