option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	equity
	--------------------------------------------------------------------
*/


//----------------------------------------------------------------------
//  class equity
//----------------------------------------------------------------------
class equity: public instrument
option(category: "Instrument/Equity")
//option(allow_undeclared_mfuncs)
{
public:
    //override string	instr_type_s();
	override instrument 	inst();
	
	equity(__instrument);	
	override equity clone();

	override void       __dbg_print(__dbg_label);
    override void       __dbg_browse(__dbg_split);

	override number 	quote(error_info option(nullable) error = null<error_info>   );
	override number 	quote(date option(nullable),string option(nullable) qs = null<string>,
								  error_info option(nullable) error = null<error_info>);			
	override number 	quote(integer,string option(nullable) qs = null<string>,
								  error_info option(nullable) error = null<error_info>);		
	override vector(number) quote(vector(date),string option(nullable) qs = null<string>,
								  error_info option(nullable) error = null<error_info>);	

	override string 	__curve_sort_maturity();
	/*---exposed in root here returns error--*/
protected:
	override number 	nominal(error_info option(nullable) error = null<error_info> );
	override date 		maturity(error_info option(nullable) error = null<error_info>);
	override number 	coupon(error_info option(nullable) error = null<error_info> );
	override number 	face_amount(error_info option(nullable) error = null<error_info> );
	override integer 	coupon_freq(error_info option(nullable) error = null<error_info> );
	override date 		issue_date(error_info option(nullable) error = null<error_info> );
	override number 	issued_amount(error_info option(nullable) error = null<error_info> );
	override number 	pvbp(number option(nullable),number option(nullable),logical option(nullable),logical option(nullable),
							 error_info option(nullable) error = null<error_info>) ;

	override number 	mac_dur(error_info option(nullable) error = null<error_info>);
	override number 	mod_dur(error_info option(nullable) error = null<error_info>);
	override number 	dol_dur(error_info option(nullable) error = null<error_info>);
	override number 	pvbp(number option(nullable) nom = null<number>,number  option(nullable) delta = 0.0001,
							 error_info option(nullable) error = null<error_info>);
	override number 	convexity(error_info option(nullable) error = null<error_info>);
	override number 	dol_convexity(error_info option(nullable) error = null<error_info>);
	override number 	sensitivity(error_info option(nullable) error = null<error_info>);
	
	override vector(date)	cash_flow_dates(logical post_settle = true, logical a = true, logical k = false,
											error_info option(nullable) error = null<error_info>);
	override vector(number)	cash_flows(number option(nullable) nom = null<number>,logical posts = true,logical k = false,
									   error_info option(nullable) error = null<error_info>);	

	override vector(number)	cash_flows_cpn(number option(nullable) nom = null<number>,logical posts = true,logical k = false,
										   error_info option(nullable) error = null<error_info>);		

	override void 			cash_flow_data(	number option(nullable) ,logical ,ir_cf_code ,logical,logical ,out vector(date)   ,
											out vector(number)   ,error_info option(nullable) error = null<error_info>);
					
	override number 	yield(logical dr = false,error_info option(nullable) error = null<error_info>);				
	override number 	yield(disc_func ,logical disable_rounding = false,error_info option(nullable) error = null<error_info>);
	
	override number 	dirty_price(number option(nullable),logical disable_rounding = false,logical in_pcnt = true,error_info option(nullable) error = null<error_info>);
	
	override number  	dirty_price(disc_func,logical disable_rounding = false,logical in_pcnt = true,error_info option(nullable) error = null<error_info>);
	
	override number 	clean_price(number option(nullable),logical disable_rounding = false,logical in_pcnt = true,error_info option(nullable) error = null<error_info>);
	
	override number 	clean_price(disc_func,logical disable_rounding = false,logical in_pcnt = true,error_info option(nullable) error = null<error_info>);
	
	override number 	accrued(logical disable_rounding = false,logical in_pcnt = true,error_info option(nullable) error = null<error_info>);

public:
	/*---set functions-required--*/	
	override equity		set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);
	override equity		set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);

	//local set
	equity				set_quote(	number option(nullable),date option(nullable) trade_date , date option(nullable) settle_date = null<date>,
									error_info option(nullable) error = null<error_info>);
	equity				set_quote(	string option(nullable),date option(nullable) trade_date  , date option(nullable) settle_date = null<date>,
									error_info option(nullable) error = null<error_info>);

	/*---set functions-if applicable--*/
	override equity		set_date(date,date option(nullable) s = null<date>,logical r = true,logical rq = true ,error_info option(nullable) error = null<error_info>);

	override equity		set_settle_date(date ,logical re_initialize = false, error_info option(nullable) error = null<error_info> );


	equity(equity);
protected:
	override equity 		create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);  
	override number 		quote(disc_func,..quote_style option(nullable),error_info option(nullable) error = null<error_info>);
	
	override equity 		set_date(date,logical ,error_info option(nullable) error = null<error_info>);
	override equity 		move_date(date,date option(nullable) s = null<date>, error_info option(nullable) error = null<error_info>);

};
//------------------------------------------------
// __dbg_print
//------------------------------------------------
void equity.__dbg_print(__dbg_label l)
{
	error_info ee 	= new error_info(true,false);
    l.set_text(strcat([
						"name: ",
						name(ee) ]));
}
//------------------------------------------------
// __dbg_browse
//------------------------------------------------
void equity.__dbg_browse(__dbg_split s)
{
    s.resize(1);
	error_info ee 	= new error_info(true,false);
    s.set_text(0, "name");
    s.set_value(0, this.name(ee));

}
//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
equity.equity(__instrument i) option(hidden) : instrument(i){}
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string equity.instr_type_s() 	{ return string(..instr_type.EQUITY);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	equity.inst()		{ return this;}
//------------------------------------------------
// copy constructor
//------------------------------------------------
equity.equity(equity c) : instrument(c) {}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
equity equity(equity b)			{ return new equity(b);}
//------------------------------------------------
// clone
//------------------------------------------------
equity equity.clone() 			{ return new equity(this);}
//-----------------------------------------------
// dynamic cast <FUNCTION>
//-----------------------------------------------
equity equity(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Equity')
option(com_name: 'equity_dyncast') 
{ 
	try {
		equity d = dynamic_cast<equity>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not an equity)","equity" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "equity");
		return null<equity>;
	}
}

//------------------------------------------------
// create  [PROTECTED]
//------------------------------------------------
equity equity.create(	__instrument option(nullable) c,
						out instr_error option(nullable) error,
						error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<equity>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.EQUITY, "invalid instrument type",type );//should not happen
	
	return new equity(c);
}

/*-----------------------------------------------------------------------
  create_equity  <FUNCTION>
  ----------------------------------------------------------------------*/

equity create_equity(	__instrument option(nullable) c,
						out instr_error option(nullable) error,
						error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_equity')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if(!valid && INSTR_CREATE_NULL_ERR)
		return null<equity>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.EQUITY, "invalid instrument type",type );
	
	return new equity(c);
}

equity create_equity(	__instrument option(nullable) 		c,
						error_info option(nullable) 		error,
						error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_equity_ei')
{
	instr_error ee 	= instr_error();
	equity b 	= create_equity(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_equity");
	return b;
}
/*-----------------------------------------------------------------------
  equity: quote
  ----------------------------------------------------------------------*/
number equity.quote(disc_func	disc_func,..quote_style	option(nullable) quote_style,									
					error_info option(nullable) error) 			{ return fin_instr.err_type(1.0, error);}
/*-----------------------------------------------------------------------
  equity: set_date
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
equity equity.set_date(	date  				trade_date, 
					date  option(nullable)	settle_date,
					logical 			re_init_static, 
					logical 			re_init_quote, 
					error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,settle_date,re_init_static,re_init_quote,error);
	return null(cc) ? null<equity>: dynamic_cast<equity>(cc);
	
}

/*-----------------------------------------------------------------------
  equity: set_date
	quote is NOT kept even if trade_date is unchanged
  ----------------------------------------------------------------------*/
equity equity.set_date(		date  				trade_date, 
							logical 			re_initialize, 
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(	trade_date,re_initialize,error);
	return null(cc) ? null<equity>: dynamic_cast<equity>(cc);	
}
/*-----------------------------------------------------------------------
  equity: move_date
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	if trade date is the same --> the settle date will be preserved	
  ----------------------------------------------------------------------*/
equity equity.move_date(date  				trade_date, 
						date option(nullable) settle_date,
						error_info option(nullable) error)
{	
	instrument cc = instrument._move_date(trade_date,settle_date,error);
	return null(cc) ? null<equity>: dynamic_cast<equity>(cc);
}

/*-----------------------------------------------------------------------
  equity: set_quote 
  ----------------------------------------------------------------------*/
equity equity.set_quote(number 	option(nullable) quote,
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, false,error);
	return null(cc) ? null<equity>: dynamic_cast<equity>(cc);
}

/*-----------------------------------------------------------------------
  equity: set_quote 
  ----------------------------------------------------------------------*/
equity equity.set_quote(string 	option(nullable) quote_side,
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, false,error);
	return null(cc) ? null<equity>: dynamic_cast<equity>(cc);
}

/*-----------------------------------------------------------------------
  equity: set_quote 
  ----------------------------------------------------------------------*/
equity equity.set_quote(number 	option(nullable) quote,
						date  	option(nullable) trade_date, 
						date  	option(nullable) settle_date, 
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,trade_date, settle_date, false,error);
	return null(cc) ? null<equity>: dynamic_cast<equity>(cc);
}

/*-----------------------------------------------------------------------
  equity: set_quote
  ----------------------------------------------------------------------*/
equity equity.set_quote(	string 	option(nullable) quote_side,
						date  	option(nullable) trade_date, 
						date  	option(nullable) settle_date, 
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,trade_date, settle_date, false,error);
	return null(cc) ? null<equity>: dynamic_cast<equity>(cc);
}


/*-----------------------------------------------------------------------
  equity: set_settle_date
  ----------------------------------------------------------------------*/
equity equity.set_settle_date(	date  				settle_date, 
								logical 			re_initialize, 
								error_info option(nullable) error)
{	
	
	instrument cc = instrument._set_settle_date(	settle_date, re_initialize, error);
	return null(cc) ? null<equity>: dynamic_cast<equity>(cc);
}


number  equity.quote(error_info option(nullable) error) { return instrument.quote(error);}

number 	equity.quote(	date option(nullable) quote_date,string option(nullable) quote_side ,
						error_info option(nullable) error ) { return instrument.quote(quote_date,quote_side,error);}

number 	equity.quote(	integer bus_days_back,string option(nullable) quote_side ,
						error_info option(nullable) error ) { return instrument.quote(bus_days_back,quote_side,error);}

vector(number) equity.quote(vector(date) quote_dates,string option(nullable) quote_side ,
							error_info option(nullable) error ) { return instrument.quote(quote_dates,quote_side,error);}
	
/*-----------------------------------------------------------------------
  error funcs
  ----------------------------------------------------------------------*/
date equity.maturity(error_info option(nullable) error) 		{ return fin_instr.err_type(null<date>,error,"equity.maturity");}
number equity.nominal(error_info option(nullable) error) 		{ return fin_instr.err_type(null<number>,error,"equity.nominal");}
number equity.coupon(error_info option(nullable) error) 		{ return fin_instr.err_type(null<number>,error,"equity.coupon");}
number equity.face_amount(error_info option(nullable) error) 	{ return fin_instr.err_type(null<number>,error,"equity.face_amount");}
integer equity.coupon_freq(error_info option(nullable) error) 	{ return fin_instr.err_type(integer(1),error,"equity.coupon_freq");}
date equity.issue_date(error_info option(nullable) error) 		{ return fin_instr.err_type(null<date>,error,"equity.issue_date");}
number equity.issued_amount(error_info option(nullable) error) { return fin_instr.err_type(null<number>,error,"equity.issued_amount");}

number equity.pvbp(number option(nullable),number option(nullable),logical option(nullable),
				   logical option(nullable),error_info option(nullable) error) 			{ return fin_instr.err_type(null<number>,error,"equity.pvbp");}
number equity.mac_dur(error_info option(nullable) error)		{ return fin_instr.err_type(null<number>,error,"equity.mac_dur");}
number equity.mod_dur(error_info option(nullable) error)		{ return fin_instr.err_type(null<number>,error,"equity.mod_dur");}
number equity.dol_dur(error_info option(nullable) error)		{ return fin_instr.err_type(null<number>,error,"equity.dol_dur");}
number equity.pvbp(number option(nullable),number  option(nullable),
				   error_info option(nullable) error)									{ return fin_instr.err_type(null<number>,error,"equity.pvbp");}
number equity.convexity(error_info option(nullable) error)		{ return fin_instr.err_type(null<number>,error,"equity.convexity");}
number equity.dol_convexity(error_info option(nullable) error)	{ return fin_instr.err_type(null<number>,error,"equity.dol_convexity");}
number equity.sensitivity(error_info option(nullable) error)	{ return fin_instr.err_type(null<number>,error,"equity.sensitivity");}

vector(date)	equity.cash_flow_dates(logical ,logical, logical,
									   error_info option(nullable) error) 				{ return fin_instr.err_type(null<vector(date)>,error,"equity.cash_flow_dates");}
vector(number)	equity.cash_flows(number option(nullable),logical ,logical,
								  error_info option(nullable) error ) 					{ return fin_instr.err_type(null<vector(number)>,error,"equity.cash_flows");}
vector(number)	equity.cash_flows_cpn(number option(nullable),logical ,logical,
									  error_info option(nullable) error) 				{ return fin_instr.err_type(null<vector(number)>,error,"equity.cash_flows_cpn");}
void 			equity.cash_flow_data(	number option(nullable) ,logical ,
										ir_cf_code ,logical,logical ,
										out vector(date)   ,
										out vector(number)   ,
										error_info option(nullable) error) 				{ fin_instr.err_type(error,"equity.cash_flow_data");}

number equity.yield(logical,error_info option(nullable) error )							{ return fin_instr.err_type(null<number>,error,"equity.yield");}					
number equity.yield(disc_func,logical ,error_info option(nullable) error)				{ return fin_instr.err_type(null<number>,error,"equity.yield");}
number equity.dirty_price(number option(nullable),logical,logical,
						  error_info option(nullable) error)							{ return fin_instr.err_type(null<number>,error,"equity.dirty_price");}
number equity.dirty_price(disc_func,logical,logical,
						  error_info option(nullable) error)							{ return fin_instr.err_type(null<number>,error,"equity.dirty_price");}
number equity.clean_price(number option(nullable),logical,logical,
						  error_info option(nullable) error)							{ return fin_instr.err_type(null<number>,error,"equity.clean_price");}
number equity.clean_price(disc_func,logical,logical,
						  error_info option(nullable) error)							{ return fin_instr.err_type(null<number>,error,"equity.clean_price");}
number equity.accrued(logical,logical,error_info option(nullable) error)				{ return fin_instr.err_type(null<number>,error,"equity.accrued");}



/*-----------------------------------------------------------------------
  __curve_sort_maturity
  ----------------------------------------------------------------------*/
string equity.__curve_sort_maturity() option(hidden)
{
	try {
		return name();
	}
	catch {
		return "";
	}
}