option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	swap_fixfix, 
	--------------------------------------------------------------------
*/


//----------------------------------------------------------------------
//  class swap_fixfix
//----------------------------------------------------------------------
class swap_fixfix: public swap_gen
option(category: "Instrument/Interest Rate Swap/Fixed vs Fixed")
//option(allow_undeclared_mfuncs)
{
public:
    //override string	instr_type_s();
	override instrument 	inst();
	override swap_fixfix  clone();

	override void         __dbg_print(__dbg_label);
    override void         __dbg_browse(__dbg_split);

	/*----------ADD FUNCS [PUBLIC]---------------*/
	void 		add_notional(number );
	void 		add_notional(number , number);
	void		add_fx_rate(number,logical,string,string );
	void 		add_fx_mult_leg1(number );
	void 		add_fx_mult_leg2(number );
	void 		add_disc_func(disc_func ); 
	void 		add_disc_func_leg1(disc_func );
	void 		add_disc_func_leg2(disc_func );
	
	/*----------MISC FUNCS [PUBLIC]---------------*/

	/*----------CASHFLOW FUNCS [PUBLIC]---------------*/

	/*----------PV FUNCS [PUBLIC]---------------*/

	override number  	present_value(	disc_func option(nullable),disc_func option(nullable),out number ,
											out number ,number option(nullable) = null<number>,logical option(nullable) trade_date_pv = false,		
											error_info option(nullable) error = null<error_info>);
	
	override number  	present_value(	disc_func option(nullable),disc_func option(nullable),out number ,out number ,
											date option(nullable) ,date option(nullable) ,
											logical,logical  ,error_info option(nullable) error = null<error_info>);
	
	override number  	present_value(	out number ,out number pv_leg2,
											logical option(nullable) ,error_info option(nullable) error = null<error_info> );

	
	disc_func 			disc_func_leg1(error_info option(nullable) error = null<error_info> ) ;
	disc_func 			disc_func_leg2(error_info option(nullable) error = null<error_info> ) ;

	override number		solver(number,swap_solver_code ,logical option(nullable) trade_date_pv = false,
						error_info option(nullable) error = null<error_info>);

	//-----external swap specific-----
	override ql_fixed_income_swap 	swap_instrument(error_info option(nullable) error = null<error_info>) ;
	override instrument_type 	swap_type(error_info option(nullable) error = null<error_info>);
	vector(ql_fix_leg) 			fix_legs(logical clone,error_info option(nullable) error = null<error_info>);

	/*----------HIDDEN FUNCS [PUBLIC]---------------*/
	//general-one per swap
	//price, compat funcs


	
	swap_fixfix(__instrument);	
	swap_fixfix(swap_fixfix);

protected:
	
	override swap_fixfix	create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);
	swap_fixfix 			err_type(swap_fixfix option(nullable), error_info option(nullable) error = null<error_info>);
	
	
	//logical ext_swap_;
	//logical ccy_swap_;
	//logical full_swap_;
};

//------------------------------------------------
// __dbg_print
//------------------------------------------------
void swap_fixfix.__dbg_print(__dbg_label l)
{
    error_info ee 	= new error_info(true,false);
    l.set_text(strcat([
						"name: ",
						name(ee),
						",  ext_swap: ",
						null(ext_swap_) ? "" : string(ext_swap_),
                        ", ccy_swap: ",
						null(ccy_swap_) ? "" : string(ccy_swap_),
						", valid: ",
						null(this.is_valid(ee)) ? "" : string(this.is_valid(ee))
					]));
}
//------------------------------------------------
// __dbg_browse
//------------------------------------------------
void swap_fixfix.__dbg_browse(__dbg_split s)
{
    s.resize(4);
	error_info ee 	= new error_info(true,false);
    s.set_text(0, "name");
    s.set_value(0, this.name(ee));

    s.set_text(1, "ext_swap");
    s.set_value(1, ext_swap_);

    s.set_text(2, "ccy_swap");
    s.set_value(2, ccy_swap_);

	s.set_text(3, "valid");
    s.set_value(3, is_valid(ee));
}
//------------------------------------------------
// copy constructor
//------------------------------------------------
swap_fixfix.swap_fixfix(swap_fixfix c) : swap_gen(c){}
//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
swap_fixfix.swap_fixfix(__instrument i) option(hidden): swap_gen(i)
{
	
	error_info ee 	= new error_info(true,false);
	if(!this.is_valid(ee)) {
		ext_swap_ = ccy_swap_ = full_swap_ = false;
		return;
	}
	ext_swap_ 		= this.is_ext_swap(ee);
	ccy_swap_ 		= this.is_ccy_swap(ee);
	full_swap_ 		= this.verify_full_swap(true,ee);
	return;										
}
/*-----------------------------------------------------------------------
  swap_type
  ----------------------------------------------------------------------*/
instrument_type swap_fixfix.swap_type(error_info option(nullable) error) 
{	
	return swap_gen.swap_type(error);
}

//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string swap_fixfix.instr_type_s() { return string(..instr_type.SWAP_FIXFIX);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	swap_fixfix.inst()		{ return this;}

//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
swap_fixfix swap_fixfix(swap_fixfix b)	{ return new swap_fixfix(b);}
//------------------------------------------------
// clone
//------------------------------------------------
swap_fixfix swap_fixfix.clone() 		{ return new swap_fixfix(this);}

//------------------------------------------------
// create  [PROTECTED]
// create swap_fixfix from internal instrument
//------------------------------------------------
swap_fixfix swap_fixfix.create(	__instrument option(nullable) c,
								out instr_error option(nullable) error,
								error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_fixfix>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.SWAP_FIXFIX, "invalid instrument type",type );//should not happen
	
	return new swap_fixfix(c);
}
/*-----------------------------------------------------------------------
  create_swap_fixfix
  ----------------------------------------------------------------------*/

swap_fixfix create_swap_fixfix(	__instrument option(nullable) c,
									out instr_error option(nullable) error,
									error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_swap_fixfix')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_fixfix>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.SWAP_FIXFIX, "invalid instrument type",type );//should not happen
	
	return new swap_fixfix(c);
}

swap_fixfix create_swap_fixfix(	__instrument option(nullable) 		c,
								error_info option(nullable) 		error,
								error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_swap_fixfix_ei')
{
	instr_error ee 	= instr_error();
	swap_fixfix b 	= create_swap_fixfix(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_swap_fixfix");
	return b;
}
//-----------------------------------------------
// dynamic cast <FUNCTION>   
//-----------------------------------------------
swap_fixfix swap_fixfix(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Interest Rate Swap/Fixed vs Fixed')
option(com_name: 'swap_fixfix_dyncast')
{ 
	try {
		swap_fixfix d = dynamic_cast<swap_fixfix>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a swap_fixfix)","swap_fixfix" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixfix");
		return null<swap_fixfix>;
	}
}
/*instrument swap_fixfix.create_instr_copy(	__instrument option(nullable) c,
										out instr_error option(nullable) error,
										error_type type )
{
	return create(c,error,type );
}*/

/*-----------------------------------------------------------------------
  err_type	EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_fixfix swap_fixfix.err_type(swap_fixfix option(nullable) nul, error_info option(nullable) error )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,"mwlib(ql) error: inapplicable function call for current instrument type");
	return null<swap_fixfix>;
}


/*-----------------------------------------------------------------------
  swap_fixfix: add_funcs
  ----------------------------------------------------------------------*/
void swap_fixfix.add_notional(number notional)			{ swap_gen.swap_add_notional(notional);}
void swap_fixfix.add_notional(number notional1, number notional2)	{ swap_gen.swap_add_notional(notional1, notional2);}
void swap_fixfix.add_fx_mult_leg1(number fx_mult)		{ swap_gen.swap_add_fx_mult_leg1(fx_mult);}
void swap_fixfix.add_fx_mult_leg2(number fx_mult)		{ swap_gen.swap_add_fx_mult_leg2(fx_mult);}
/*-----------------------------------------------------------------------
  add_fx_rate EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixfix.add_fx_rate(number fx_quote_dec,//must be a quote per unit of base ccy 
							logical pv_in_base_ccy,
							string 	base_ccy,
							string 	price_ccy)
{
	
	swap_gen.swap_add_fx_rate(fx_quote_dec,pv_in_base_ccy,base_ccy,price_ccy);
}
void swap_fixfix.add_disc_func(disc_func disc_func)		{ swap_gen.swap_add_disc_func(disc_func); }
void swap_fixfix.add_disc_func_leg1(disc_func disc_func){ swap_gen.swap_add_disc_func_leg1(disc_func); }
void swap_fixfix.add_disc_func_leg2(disc_func  disc_func) { swap_gen.swap_add_disc_func_leg2(disc_func); }

/*-----------------------------------------------------------------------
  swap_fixfix: disc_func_leg1
  ----------------------------------------------------------------------*/
disc_func swap_fixfix.disc_func_leg1(error_info option(nullable) error) 	{ return swap_gen.swap_disc_func_leg1(error);}
disc_func swap_fixfix.disc_func_leg2(error_info option(nullable) error) 	{ return swap_gen.swap_disc_func_leg2(error);}

/*-----------------------------------------------------------------------
  solver
  ----------------------------------------------------------------------*/
number swap_fixfix.solver(	number 				pv,
							swap_solver_code 	solver_code,
							logical option(nullable) trade_date_pv,
							error_info option(nullable) error)
{	
	return swap_gen.solver(pv,solver_code,trade_date_pv,error);
}

/*-----------------------------------------------------------------------
  swap_instrument
  ----------------------------------------------------------------------*/
ql_fixed_income_swap swap_fixfix.swap_instrument(error_info option(nullable) error)
{
	return swap_gen.swap_instrument(error);

}
/*-----------------------------------------------------------------------
  legs
  ----------------------------------------------------------------------*/
/*vector(ql_swap_leg) swap_fixfix.legs(error_info option(nullable) error)
{	
	return swap_leg(error);
}

*/
/*-----------------------------------------------------------------------
  fix_legs
  ----------------------------------------------------------------------*/
vector(ql_fix_leg) swap_fixfix.fix_legs(logical clone,error_info option(nullable) error)
{	
	return swap_gen.swap_fix_leg(clone,error);
}


/*-----------------------------------------------------------------------
  present_value
  ----------------------------------------------------------------------*/
number swap_fixfix.present_value(	disc_func option(nullable)	disc_func_leg1,
									disc_func option(nullable) 	disc_func_leg2,
									out number pv_leg1,
									out number pv_leg2,
									number option(nullable) 	notional,
									logical option(nullable) 	trade_date_pv,																								
									error_info option(nullable) error)
{
	return swap_gen.present_value(disc_func_leg1,disc_func_leg2,pv_leg1,pv_leg2,notional,trade_date_pv,error);
}


number swap_fixfix.present_value(	disc_func option(nullable)	disc_func_leg1,
									disc_func option(nullable) 	disc_func_leg2,
									out number pv_leg1,
									out number pv_leg2,
									date option(nullable) pv_date,
									date option(nullable) settle_date,
									logical  	incl_issue_cf,
									logical  	incl_mat_cf,	
									error_info option(nullable) error)
{	
	return swap_gen.present_value(disc_func_leg1,disc_func_leg2,pv_leg1,pv_leg2,pv_date, settle_date ,incl_issue_cf,incl_mat_cf,error );
}


number swap_fixfix.present_value(out number pv_leg1,
									out number pv_leg2,
									logical option(nullable) 	trade_date_pv,
									error_info option(nullable) error)
{	
	return swap_gen.present_value(pv_leg1,pv_leg2,trade_date_pv ,error );
}



