option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	swap_fixflt
	--------------------------------------------------------------------
	is_ext_swap is a swap created from a fixed_income_swap
*/

//----------------------------------------------------------------------
//  class swap_fixflt
//----------------------------------------------------------------------
class swap_fixflt: public swap_gen
option(category: "Instrument/Interest Rate Swap/Fixed vs Float")
//option(allow_undeclared_mfuncs)
{
public:
	override swap_fixflt 	clone() ;
	override instrument 	inst();
	override void 	__dbg_print(__dbg_label);
    override void  	__dbg_browse(__dbg_split);
	
	/*----------ADD FUNCS [PUBLIC]---------------*/	
	void 		add_quote(number,..quote_style );
	override void add_quote(number);	
	void 		add_notional(number );
	void 		add_notional(number, number );
	//void 		add_notional_fix_leg(number );
	//void 		add_notional_flt_leg(number );
	void		add_fx_rate(number,logical,string,string );
	void 		add_fx_mult_fix_leg(number );
	void 		add_fx_mult_flt_leg(number );
	void 		add_disc_func(disc_func option(nullable)); 
	void 		add_disc_func_fix_leg(disc_func option(nullable));
	void 		add_disc_func_flt_leg(disc_func option(nullable));	
	void 		add_surface(tenor_surface option(nullable));
	void		add_surface(disc_func,fwd_func);
	void		add_fwd_func(fwd_func);
	void		add_fixing(vector(date) ,vector(number) ,logical option(nullable) fixing_as_fwd = false);	
	void		add_fixing(number ,logical option(nullable) fixing_as_fwd = false);
	void		add_fixing_start_stub(number option(nullable));
	void		add_fixing_end_stub(number option(nullable));
	void		add_current_fixing(number option(nullable));
	void 		add_data( 	number option(nullable), disc_func option(nullable),tenor_surface option(nullable),
							vector(date) option(nullable),vector(number) option(nullable),
							logical option(nullable) fixing_as_fwd_flt_leg = false,
							logical upd_null_crv = false,logical upd_null_fix = false);
	/*void 		add_data( 	number option(nullable), disc_func option(nullable),fwd_func option(nullable),
							vector(date) option(nullable),vector(number) option(nullable),
							logical option(nullable) fixing_as_fwd_flt_leg = false,
							logical option(nullable) upd_nulls = false);*/
	void 		add_ccy_data(	number,disc_func,number,number,disc_func,number,
								tenor_surface,vector(date),vector(number),
								logical option(nullable) fixing_as_fwd_flt_leg = false,
								logical upd_null_crv = false,logical upd_null_fix = false);
	/*void 		add_ccy_data(	number,disc_func,number,number,disc_func,number,
								fwd_func,vector(date),vector(number),
								logical option(nullable) fixing_as_fwd_flt_leg = false,
								logical option(nullable) upd_nulls = false);*/
	void 		add_curve_data(disc_func option(nullable) ,disc_func option(nullable),tenor_surface option(nullable));
	/*----------MISC FUNCS [PUBLIC]---------------*/
	//DLL_SWAP_HANDLER OK
	date 		start_date(error_info option(nullable) error = null<error_info> );				/*name change of issuedate*/
	//DLL_SWAP_HANDLER --> IN PROGRESS
	override void is_amortizing(out logical,out logical ,error_info option(nullable) error = null<error_info>);
	override logical is_amortizing(error_info option(nullable) error = null<error_info>);

	logical		is_cross_currency(error_info option(nullable) error = null<error_info>);
	logical		is_par_flat(error_info option(nullable) error = null<error_info>);
	logical		pay_fix(error_info option(nullable) error = null<error_info>);
	override void notional(out number , out number , error_info option(nullable) error = null<error_info>);
	number 		notional(error_info option(nullable) error = null<error_info>);	
	void 		is_regular_first(out logical option(nullable), out logical option(nullable),error_info option(nullable) error = null<error_info>);				
	void 		is_regular_last(out logical option(nullable), out logical option(nullable),error_info option(nullable) error = null<error_info>);		
	override void 	fx_mult_factor(out number , out number ,error_info option(nullable) error = null<error_info>);
	override void 	currency(out string, out string,error_info option(nullable) error = null<error_info>);
	override void 	coupon(out number  option(nullable),out number  option(nullable),error_info option(nullable) error = null<error_info>);
	override void 	coupon_freq(out integer,out integer,error_info option(nullable) error = null<error_info> );
	override void 	dc_method(	out day_count_method , out day_count_method ,error_info option(nullable) error = null<error_info>);									
	override void  	pmt_bus_day(out bd_convention option(nullable), out bd_convention option(nullable),error_info option(nullable) error = null<error_info>);				
	override void 	roll_day(out integer,out integer,error_info option(nullable) error = null<error_info>);
	override void 	eom(out logical option(nullable),out logical option(nullable),error_info option(nullable) error = null<error_info> );
	override void 	calendar(out ..calendar option(nullable),out ..calendar option(nullable),error_info option(nullable) error = null<error_info>);
	override void 	first_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	override void  	last_reg_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	override void	effective_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	override void  	next_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	override void  	previous_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	override void	calendar_name(out string ,out string  , error_info option(nullable) error = null<error_info> ) ;
	override string settle_code(error_info option(nullable) error = null<error_info>);

	void 			pmt_lag(out	integer 	pmt_lag_leg1,
							out	integer 	mat_pmt_lag_leg1,
							out	integer 	pmt_lag_prin_leg1,
							out	integer 	mat_pmt_lag_prin_leg1,
							out	integer 	pmt_lag_leg2,
							out	integer 	mat_pmt_lag_leg2,
							out	integer 	pmt_lag_prin_leg2,
							out	integer 	mat_pmt_lag_prin_leg2,	
							error_info option(nullable) error) ;
	
	//quote funcs
	override void quote(out number  ,out number  ,error_info option(nullable) error = null<error_info> );	
	override number quote(error_info option(nullable) error = null<error_info> );

	
	/*----------CASHFLOW FUNCS [PUBLIC]---------------*/	
	override void 	cash_flow_dates(logical,out vector(date) ,out vector(date) ,error_info option(nullable) error = null<error_info> ) ;
	override void	cash_flows_cpn(logical,out vector(number) ,out vector(number),error_info option(nullable) error = null<error_info> );
	override void	cash_flows(logical,out vector(number) ,out vector(number),error_info option(nullable) error = null<error_info> );
	override void	cash_flow_data(	logical,ir_cf_code cf_code,out vector(date)   ,out vector(number)  ,out vector(date)   ,out vector(number)  ,
								error_info option(nullable) error = null<error_info> );
	override void 	cash_flow_data(logical,logical option(nullable),out vector(date)  ,out vector(number) ,
								out vector(number)  ,out vector(number)  , out vector(number)  ,out vector(number)  ,
								out vector(number) ,out vector(date)  	, out vector(number)  ,out vector(number)  ,
								out vector(number)  ,out vector(number)  , out vector(number)  ,out vector(number)  ,
								error_info option(nullable) error = null<error_info> );
	
	void 			data(out swap_fix_leg_data,out swap_flt_leg_data,error_info option(nullable) error = null<error_info>);
	void 			data(out swap_fix_leg_data,error_info option(nullable) error = null<error_info>);
	void 			data(out swap_flt_leg_data,error_info option(nullable) error = null<error_info>);

	
	
	/*----------PV FUNCS [PUBLIC]---------------*/
	override number  	present_value(	disc_func option(nullable),disc_func option(nullable),out number  ,
								out number  ,number option(nullable) , logical option(nullable) trade_date_pv = false,		
								error_info option(nullable) error = null<error_info>);
	
	override number  	present_value(	disc_func option(nullable),disc_func option(nullable),out number  ,
								out number ,date option(nullable) ,date option(nullable) ,
								logical,logical  ,error_info option(nullable) error = null<error_info>);
	
	override number  	present_value_fee(	disc_func option(nullable),disc_func option(nullable),out number  ,
								out number ,date option(nullable) ,date option(nullable) ,
								logical,logical  ,error_info option(nullable) error = null<error_info>);
	
	override number  	present_value(	out number  ,out number  , logical option(nullable) ,error_info option(nullable) error = null<error_info> );
	
	override number 	accrued(logical,out number ,out number ,error_info option(nullable) error = null<error_info>);
	override void 		accrued_period(out number ,out number ,out integer,out integer,error_info option(nullable) error = null<error_info>);		

	override number 	accrued_chg(integer bus_days, out	number ,out number,out	number 	,out number  ,
									out date ,out date ,error_info option(nullable) error = null<error_info> ); 

	void				implied_par_funcs(	out disc_func ,out fwd_func  ,number option(nullable),
											error_info option(nullable) error = null<error_info>);
	
	override number		solver(	number,swap_solver_code ,logical option(nullable) trade_date_pv = false,
									error_info option(nullable) error = null<error_info>);

	number  	dv01_fwd(fwd_func,fwd_func,number,error_info option(nullable) error = null<error_info> ) ;

	number 		dv01_disc(disc_func ,disc_func, number ,error_info option(nullable) error = null<error_info>) ;

	number 		dv01_disc(disc_func option(nullable) , disc_func option(nullable) ,disc_func  ,disc_func  ,								
										number ,error_info option(nullable) error = null<error_info>) ;

	number 		dv01(fwd_func option(nullable) ,fwd_func option(nullable) ,disc_func option(nullable) ,
						disc_func option(nullable) ,disc_func option(nullable) ,disc_func option(nullable) ,								
						number ,error_info option(nullable) error = null<error_info>) ;

	number  	pvdiff(	fwd_func option(nullable),fwd_func option(nullable),disc_func option(nullable),disc_func option(nullable),
						disc_func option(nullable),disc_func option(nullable),logical option(nullable),
						out number ,out number ,out number ,error_info option(nullable) error = null<error_info> ) ;
	
	number 		dv01(number option(nullable) delta = null<number>,logical option(nullable) trade_date_pv = false,
						error_info option(nullable) error  = null<error_info>) ;
	
	number 		dv01_disc(number option(nullable) delta = null<number>,  logical option(nullable) trade_date_pv = false,
							error_info option(nullable) error  = null<error_info>) ;

	number 		dv01_fwd(number option(nullable) delta = null<number>,  logical option(nullable) trade_date_pv = false,
						error_info option(nullable) error  = null<error_info>) ;
	
	//number  	pvdiff_curve_shift(	number option(nullable) delta_disc = null<number>, number option(nullable) delta_fwd = null<number>,
									//logical option(nullable) trade_date_pv = false, error_info option(nullable) error  = null<error_info>) ;
	
	number 		pvdiff_curve_shift(	number option(nullable) ,number option(nullable),number option(nullable),
									logical option(nullable) ,logical option(nullable),out number, out number  ,out number ,
									error_info option(nullable) error = null<error_info> );
	
	number  	gamma_risk(	number option(nullable) delta = null<number>, logical option(nullable) trade_date_pv = false,
							error_info option(nullable) error  = null<error_info>) ;

	number 		gamma_risk_fwd(number option(nullable) delta = null<number>, logical option(nullable) trade_date_pv = false,
								error_info option(nullable) error  = null<error_info>) ;
	
	number 		gamma_risk_disc(number option(nullable) delta = null<number>, logical option(nullable) trade_date_pv = false,
								error_info option(nullable) error  = null<error_info>) ;
	
	void 		risk_ladder_fwd(vector(fwd_func),fwd_func,fwd_func option(nullable),number,out vector(number) ,
										out number, error_info option(nullable) error = null<error_info> ) ;
	
	void		risk_ladder_disc(fwd_func option(nullable),vector(disc_func),disc_func,disc_func option(nullable) ,
								number, out vector(number) ,out number ,error_info option(nullable) error = null<error_info> ) ;
	
	void 		upfront_carry(	out date,out date,out number,out number ,out number ,out number ,
								error_info option(nullable) error  = null<error_info> );
	void 		upfront_carry(out date ,out date ,out carry_result ,logical roll_compat = false,
							  error_info option(nullable) error = null<error_info>);

	void 		upfront_rolldown(out date,out date ,out rolldown_result ,logical incl_reinv_in_roll = false,
								 error_info option(nullable) error = null<error_info> );
	void 		upfront_rolldown(out date,out date   ,out number ,out number ,out number ,out number ,
									error_info option(nullable) error = null<error_info> ) ;
	
	void		upfront_carryroll(out date,out date ,out number,out number,out number ,out logical,
								  error_info option(nullable) error = null<error_info>);

	number  	spreadbp_to_fixbp(	error_info option(nullable) error = null<error_info> );
	/*----------FIXLEG FUNCS [PUBLIC]---------------*/
	interest_rule  			ir_rule_fix_leg(error_info option(nullable) error = null<error_info>);
	bd_convention 			pmt_bus_day_fix_leg( error_info option(nullable) error = null<error_info>);
	logical 				eom_fix_leg( error_info option(nullable) error = null<error_info>); 
	calendar  				calendar_fix_leg( error_info option(nullable) error = null<error_info>); 
	string 					currency_fix_leg(error_info option(nullable) error = null<error_info>);
	number					coupon_fix_leg(error_info option(nullable) error = null<error_info> );
	integer					coupon_freq_fix_leg(error_info option(nullable) error = null<error_info>);
	day_count_method  		dc_method_fix_leg( error_info option(nullable) error = null<error_info>);
	number					pv01(	number option(nullable)= null<number>,number option(nullable)= null<number>,
									disc_func option(nullable) df = null<disc_func>,
									error_info option(nullable) error = null<error_info>);
	number					pv01_ext(	number option(nullable) ,number option(nullable) ,disc_func option(nullable) ,
										out number ,out number ,error_info option(nullable) error = null<error_info> ) ;
	
	override number			pvdiff_fix_rate(number , disc_func option(nullable) df = null<disc_func>,
											error_info option(nullable) error = null<error_info>);
	
	disc_func 				disc_func_fix_leg(error_info option(nullable) error = null<error_info> ) ;			
	//override number 		fix_leg_y_to_pv(number option(nullable) y = null<number>,logical l= true ,error_info option(nullable) error = null<error_info>);
	override number			imp_rate_fix_leg(number,logical option(nullable) trade_date_pv = false,
											 error_info option(nullable) error = null<error_info>);	
	override number			par_rate_fix_leg(	disc_func, error_info option(nullable) error = null<error_info>);
	void					accr_dates_fix_leg(	logical,out vector(date),out vector(date),out vector(number) ,
												error_info option(nullable) error= null<error_info> );
	notional_exchg_style 	notional_exchg_style_fix_leg(error_info option(nullable)  error = null<error_info>);

	void 					payment_data_fix_leg(	logical,logical option(nullable), out vector(date),out vector(number) ,
													out vector(number) ,out vector(number) ,
													out vector(number) ,out vector(number),out vector(number) ,
													error_info option(nullable)  error = null<error_info>) ;
	
	void 					principal_data_fix_leg(	logical,logical option(nullable) ,logical ,
													out vector(date),out vector(number),out vector(number) ,
													error_info option(nullable)  error  = null<error_info>);
	
	/*----------FLTLEG FUNCS [PUBLIC]---------------*/
	void  					start_stub_info_flt_leg(out logical, out logical, out date ,out date ,out flt_stub_fwd_style,
													out number ,out number ,out number ,error_info option(nullable) error = null<error_info>);
	void  					end_stub_info_flt_leg(out logical, out logical, out date ,out date ,out flt_stub_fwd_style,
												  out number ,out number ,out number ,error_info option(nullable) error = null<error_info>);
	flt_stub_fwd_style  	stub_fwd_style_flt_leg(error_info option(nullable) error = null<error_info>);
	flt_avg_method  		avg_method_flt_leg(error_info option(nullable) error = null<error_info>);
	flt_sprd_comp_method  	sprd_comp_method_flt_leg(error_info option(nullable) error = null<error_info>);
	flt_comp_avg_type  		comp_avg_type_flt_leg(error_info option(nullable) error = null<error_info>);
	interest_rule  			ir_rule_flt_leg(error_info option(nullable) error = null<error_info>);
	bd_convention 			pmt_bus_day_flt_leg( error_info option(nullable) error = null<error_info>);
	logical 				eom_flt_leg( error_info option(nullable) error = null<error_info>); 
	calendar  				calendar_flt_leg( error_info option(nullable) error = null<error_info>);
	string 					currency_flt_leg(error_info option(nullable) error = null<error_info>);
	number					spread_flt_leg(error_info option(nullable) error = null<error_info> );
	number					current_coupon_flt_leg(error_info option(nullable) error = null<error_info> );
	number					current_fixing_flt_leg(out date,out logical,error_info option(nullable) error = null<error_info>);
	day_count_method  		dc_method_flt_leg( error_info option(nullable) error = null<error_info>);
	number					pv01_spread(number option(nullable)= null<number>,number option(nullable)= null<number>,
										disc_func option(nullable) df = null<disc_func>,
										error_info option(nullable) error = null<error_info>);
	
	integer					reset_freq_flt_leg(error_info option(nullable) error = null<error_info>);
	integer					coupon_freq_flt_leg(error_info option(nullable) error = null<error_info>);
	
	void					index_dates_flt_leg(logical,out vector(date) ,out vector(date) ,
												out vector(logical) ,error_info option(nullable) error = null<error_info> ) ;

	void					accr_dates_flt_leg(	logical,out vector(date),out vector(date),out vector(number) ,
												error_info option(nullable) error= null<error_info> );
		
	void					fixing_data_flt_leg(logical ,logical option(nullable),out vector(date)  ,									
												out vector(number)  ,out vector(logical),
												error_info option(nullable) error = null<error_info> ) ;
	number					imp_spread_flt_leg(number,logical option(nullable) trade_date_pv = false,
											   error_info option(nullable) error = null<error_info>);
	
	disc_func 				disc_func_flt_leg(error_info option(nullable) error = null<error_info> ) ;
	tenor_surface 			tenor_surface_flt_leg(error_info option(nullable) error = null<error_info>);
	ir_index 				ir_index_flt_leg(error_info option(nullable) error = null<error_info> ); 
	string 					index_tenor_flt_leg(error_info option(nullable) error = null<error_info> ) ;
	tenor_code 				index_tenor_code_flt_leg(error_info option(nullable) error = null<error_info> ) ;

	tenor_surface 			create_tenor_surface(disc_func ,fwd_func,error_info option(nullable) error = null<error_info> );
	tenor_surface 			create_tenor_surface(disc_func ,disc_func,error_info option(nullable) error = null<error_info> );

	void					reset_ladder_flt_leg(	out vector(date),out vector(number),
													error_info option(nullable) error = null<error_info>);

	notional_exchg_style 	notional_exchg_style_flt_leg(error_info option(nullable)  error = null<error_info>);

	void 					payment_data_flt_leg(	logical,logical option(nullable),out vector(date) ,out vector(number) ,
													out vector(logical) ,out vector(date),out vector(number) ,out vector(number) ,out vector(number) ,
													out vector(number) ,out vector(number),out vector(number) ,
													error_info option(nullable)  error = null<error_info>) ;

	void 					principal_data_flt_leg(	logical,logical option(nullable) ,logical ,
													out vector(date),out vector(number),out vector(number) ,
													error_info option(nullable)  error  = null<error_info>);
	
	//-----external swap specific-----
	override instrument_type 		swap_type(error_info option(nullable) error = null<error_info> );
	vector(ql_swap_leg) 			legs(logical,error_info option(nullable) error = null<error_info>);
	ql_float_leg 					float_leg(logical,error_info option(nullable) error = null<error_info>);
	ql_fix_leg 						fix_leg(logical,error_info option(nullable) error = null<error_info>);
	override ql_fixed_income_swap 	swap_instrument(error_info option(nullable) error = null<error_info>) ;

	/*---set functions-required--*/	
	override swap_fixflt	set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);
	override swap_fixflt	set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);
	//virtual instrument 	set_settle_date(date ,logical ,error_info option(nullable) error = null<error_info> );

	/*-----set functions-if applicable-----*/
	swap_fixflt				set_rate_fix_leg(number option(nullable) ,error_info option(nullable) error = null<error_info>);	
	swap_fixflt				set_spread_flt_leg(number option(nullable) ,error_info option(nullable) error = null<error_info>);

	//local set funcs
	swap_fixflt 			set_settle_date(date, error_info option(nullable) error = null<error_info> ) ;
	swap_fixflt 			set_date(date,date option(nullable) settle_date=null<date>, error_info option(nullable) error = null<error_info>);
	override swap_fixflt 	set_date(date,date option(nullable),logical,logical , error_info option(nullable) error = null<error_info> );
	void					update_to_par(error_info option(nullable) error = null<error_info> );
	swap_fixflt				set_pay_leg(logical ,error_info option(nullable) error = null<error_info>);
	

	/*----------HIDDEN FUNCS [PUBLIC]---------------*/
	swap_fixflt(__instrument);

	//general-one per swap
	override ir_index 		ir_index(error_info option(nullable) error = null<error_info> ); 				/*hidden, not visible in root*/
	
	//price, compat funcs
	override number 		yield(logical disable_rounding = false,error_info option(nullable) error = null<error_info>);				/*hidden, visible in root*/
	override number			yield(	disc_func,logical= false,error_info option(nullable) error= null<error_info>);						/*hidden, visible in root*/
	override number  		quote(	disc_func , ..quote_style option(nullable) ,error_info option(nullable) error = null<error_info>);  /*hidden, visible in root*/
	override number 		mac_dur(error_info option(nullable) error = null<error_info>);
	override number 		mod_dur(error_info option(nullable) error = null<error_info>);
	override number 		dol_dur(error_info option(nullable) error = null<error_info>);
	
	swap_fixflt(swap_fixflt);
	
protected:
	
	override swap_fixflt	create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);	
	swap_fixflt 			err_type(swap_fixflt option(nullable), error_info option(nullable) error = null<error_info>);
	
	disc_func 				df_shifted_flt_leg(number,disc_func);	
	tenor_surface 			fwd_shifted_flt_leg(number ,disc_func,tenor_surface);
	
	//general	
	override number 		pvbp(number option(nullable),number option(nullable),logical option(nullable),
								logical option(nullable),	error_info option(nullable) error = null<error_info>) ;
	
	override number 		pvbp(number option(nullable),number  option(nullable), error_info option(nullable) error = null<error_info>);
	
	//set funcs
	
	//override swap_fixflt 	set_date(date,date option(nullable),logical,logical ,
									 //error_info option(nullable) error = null<error_info> );
	
	override swap_fixflt 	set_date(date,logical ,error_info option(nullable) error = null<error_info>);								/*legacy*/
	
	override swap_fixflt 	move_date(	date,date option(nullable) settle_date=null<date> ,
										error_info option(nullable) error = null<error_info>);											/*legacy*/

	override swap_fixflt	set_yield(number option(nullable) ,error_info option(nullable) error = null<error_info>);
	override swap_fixflt	set_quote_from_yield(number option(nullable),error_info option(nullable) error = null<error_info> );		/*legacy*/

	void  					get_legs(	out ql_fix_leg,out ql_float_leg );

	void					dur_con_helper(out number ,out number, out number) ;
	logical 				update_to_par_int(	logical ,logical,out disc_func ,out disc_func ,out tenor_surface ,out disc_func ,
												out disc_func, out fwd_func,out tenor_surface);

};
//------------------------------------------------
// __dbg_print
//------------------------------------------------
void swap_fixflt.__dbg_print(__dbg_label l)
{
    error_info ee 	= new error_info(true,false);
    l.set_text(strcat([
						"name: ",
						name(ee),
						",  ext_swap: ",
						null(ext_swap_) ? "" : string(ext_swap_),
                        ", ccy_swap: ",
						null(ccy_swap_) ? "" : string(ccy_swap_),
						", valid: ",
						null(this.is_valid(ee)) ? "" : string(this.is_valid(ee))
					]));
}

//------------------------------------------------
// __dbg_browse
//------------------------------------------------
void swap_fixflt.__dbg_browse(__dbg_split s)
{
    s.resize(4);

	error_info e = error_info(true,false);
    s.set_text(0, "name");
    s.set_value(0, this.name(e));

    s.set_text(1, "ext_swap");
    s.set_value(1, ext_swap_);

    s.set_text(2, "ccy_swap");
    s.set_value(2, ccy_swap_);

	s.set_text(3, "valid");
    s.set_value(3, is_valid(e));
}

//------------------------------------------------
// copy constructor
//------------------------------------------------
swap_fixflt.swap_fixflt(swap_fixflt c) : swap_gen(c)
{}
//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
swap_fixflt.swap_fixflt(__instrument i) option(hidden) : swap_gen(i)	
{	
	error_info ee = new error_info(true,false);
	if(!this.is_valid(ee)) {
		ext_swap_ = ccy_swap_ = full_swap_ = false;
		return;
	}
	
	ext_swap_ = this.is_ext_swap(ee);
	ccy_swap_ = this.is_ccy_swap(ee);
	full_swap_ 	= this.verify_full_swap(true,ee);	//should be false when init does not create a full swap	
}

/*-----------------------------------------------------------------------
  swap_type   EXT SWAP: ok
  ----------------------------------------------------------------------*/
instrument_type swap_fixflt.swap_type(error_info option(nullable) error ) 
{	
	return swap_gen.swap_type(error);
}

//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string 		swap_fixflt.instr_type_s() 		{ return string(..instr_type.SWAP_FIXFLT);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	swap_fixflt.inst()				{ return this;}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
swap_fixflt swap_fixflt(swap_fixflt b)		{ return new swap_fixflt(b);}
//------------------------------------------------
// clone
//------------------------------------------------
swap_fixflt swap_fixflt.clone() 			{ return new swap_fixflt(this);}
//------------------------------------------------
// create  [PROTECTED]
// create swap_fixflt from internal instrument
//------------------------------------------------
swap_fixflt swap_fixflt.create(	__instrument option(nullable) c,
								out instr_error option(nullable) error,
								error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_fixflt>; 

	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.SWAP_FIXFLT, "invalid instrument type",type );//should not happen
	
	return new swap_fixflt(c);
}

/*-----------------------------------------------------------------------
  create_swap_fixflt  <FUNCTION> 
  ----------------------------------------------------------------------*/
swap_fixflt create_swap_fixflt(	__instrument option(nullable) c,
								out instr_error option(nullable) error,
								error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_swap_fixflt')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_fixflt>; 

	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.SWAP_FIXFLT, "invalid instrument type",type );//should not happen
	
	return new swap_fixflt(c);
}

swap_fixflt create_swap_fixflt(	__instrument option(nullable) 		c,
								error_info option(nullable) 		error,
								error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_swap_fixflt_ei')
{
	instr_error ee 	= instr_error();
	swap_fixflt b 	= create_swap_fixflt(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_swap_fixflt");
	return b;
}
/*-----------------------------------------------------------------------
  create_null_swap_fixflt <FUNCTION>   (because it was not possble to return null
									from swap_fltflt2s.swap_fltflt())
  ----------------------------------------------------------------------*/
swap_fixflt create_null_swap_fixflt()
{
	return null<swap_fixflt>;
}
//-----------------------------------------------
// constructor <FUNCTION> dynamic cast  EXT SWAP: ok
//-----------------------------------------------
swap_fixflt swap_fixflt(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Interest Rate Swap/Fixed vs Float')
option(com_name: 'swap_fixflt_dyncast')
{ 
	try {
		swap_fixflt d = dynamic_cast<swap_fixflt>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a swap_fixflt)","swap_fixflt" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt");
		return null<swap_fixflt>;
	}
}
/*-----------------------------------------------------------------------
  err_type	EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_fixflt swap_fixflt.err_type(swap_fixflt option(nullable) nul, error_info option(nullable) error )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,"mwlib(ql) error: inapplicable function call for current instrument type");
	return null<swap_fixflt>;
}

/*-----------------------------------------------------------------------
  update_to_par	EXT SWAP: ok,  not for currency swaps  <protected>
  ----------------------------------------------------------------------*/
logical swap_fixflt.update_to_par_int(	logical break_if_set,
										logical allow_upd_ext_swap,
										out disc_func df_flt_orig,
										out disc_func df_fix_orig,
										out tenor_surface ts_orig,
										out disc_func df_flt,
										out disc_func df_fix,
										out fwd_func flt_fwd_func ,
										out tenor_surface ts )
{
	//do a "par" update only for 
	//1. non-currency-swaps and 
	//2. non-external-swaps (depends on allow_ext_swap)
	//3. swaps which does not already have df/ts (depends on break_if_set)		
	
	if(!full_swap_){
		QL_FAIL("incomplete swap");
	}
	
	QL_FAIL_COND(fix_leg_y_ne_cpn_err(),"yield vs coupon error (internal error for db swap)", this,true);	
	
	error_info ee 	= new error_info(true,true);
	df_flt_orig 	= this.disc_func_flt_leg(ee);
	df_flt  		= df_flt_orig;
	if(ee.is_error()){
		QL_FAIL("error retrieving disc_func (float)");
	}
	df_fix_orig 	= this.disc_func_fix_leg(ee);
	df_fix  		= df_fix_orig;
	if(ee.is_error() ){
		QL_FAIL("error retrieving disc_func (fix)");
	}
	ts_orig 		= this.tenor_surface_flt_leg(ee);
	ts 				= ts_orig;
	if(ee.is_error()){
		QL_FAIL("error retrieving tenor surface");
	}

	if(break_if_set){
		if(!null(df_flt_orig) && !null(df_fix_orig) && !null(ts_orig)){
			return  false;
		}
		
		if(!null(df_flt_orig) || !null(df_fix_orig) || !null(ts_orig)){
			QL_FAIL("one or more disc_func/fwd_func already defined (but not complete)");
		}
	}

	if(!allow_upd_ext_swap && ext_swap_) {
		return false;
	}
	
	if(ccy_swap_ ){
		return false;
	}
	
	number first_fix = null<number>;
	this.implied_par_funcs(df_flt,flt_fwd_func,first_fix,ee);
	
	df_fix = df_flt;
	
	ts = create_tenor_surface( df_flt,flt_fwd_func);
	QL_FAIL_COND(null(ts), "error creating tenor surface", this, true);
	
	add_curve_data(df_flt,null<disc_func>,ts );
	return true;
	
}
/*-----------------------------------------------------------------------
  update_to_par	EXT SWAP: ok,  not for currency swaps
  update to par will overwrite existing disc_func/fwd_func
  ----------------------------------------------------------------------*/
void swap_fixflt.update_to_par(error_info option(nullable) error )
{
	try {
		QL_FAIL_COND(ccy_swap_,"inapplicable function call for cross currency swaps", this,true);
		
		disc_func df, df_tmp, df_flt_orig,df_fix_orig;
		tenor_surface ts_orig;
		fwd_func flt_fwd_func;
		tenor_surface ts;
		logical is_updated = update_to_par_int(false, true,df_flt_orig, df_fix_orig, ts_orig, df, df_tmp,flt_fwd_func,ts );
		QL_REQUIRE(is_updated,"failed par update swap_fixflt",this,true);
			
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.set_to_par");
		return;
	}
}

/*-----------------------------------------------------------------------
  pay_fix  EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical	 swap_fixflt.pay_fix(error_info option(nullable) error )
{
	
	return swap_gen.swap_payleg1(error);
}

/*-----------------------------------------------------------------------
  is_amortizing  EXT SWAP: ok  
  ----------------------------------------------------------------------*/
void swap_fixflt.is_amortizing(out logical is_amort_fix,
							   out logical is_amort_flt,
							   error_info option(nullable) error )
{
	swap_gen.is_amortizing(is_amort_fix,is_amort_flt,error);
	return;
	
}
/*-----------------------------------------------------------------------
  is_amortizing  EXT SWAP: ok  
  ----------------------------------------------------------------------*/
logical swap_fixflt.is_amortizing(error_info option(nullable) error )
{
	return swap_gen.is_amortizing(error);
}

/*-----------------------------------------------------------------------
  swap_fixflt: add_quote		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixflt.add_quote(	number  quote ) 
{
	swap_gen.add_quote(quote);
	return ;						
}
/*-----------------------------------------------------------------------
  swap_fixflt: add_quote		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixflt.add_quote(	number  quote,
							..quote_style quote_style) 
{
	error_info ee = new error_info(true,true);
	..quote_style qs = quote_style_e(ee);
	
	if(quote_style == qs)
		this.add_quote(quote);
	else{
		if(quote_style == ..quote_style.YIELD)
			this.add_quote(quote*100);//instr quotestyle must be pct
		else if(quote_style == ..quote_style.YIELD_PCT)
			this.add_quote(quote/100);//instr quotestyle is not pct
		else
			QL_FAIL("invalid quote style",this,true);
	}					
}

/*-----------------------------------------------------------------------
  swap_fixflt: add_funcs   EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixflt.add_notional(number notional)							{ swap_gen.swap_add_notional(notional);}		//if ccy swap: err
void swap_fixflt.add_notional(number notional1, number notional2)		{ swap_gen.swap_add_notional(notional1,notional2);}		//if single ccy swap: err	
//void swap_fixflt.add_notional_fix_leg(number notional) 					{ swap_gen.swap_add_notional_leg1(notional);}	//if non ccy swap: both legs will be updated
//void swap_fixflt.add_notional_flt_leg(number notional)					{ swap_gen.swap_add_notional_leg2(notional);}	//if non ccy swap: both legs will be updated
void swap_fixflt.add_fx_mult_fix_leg(number fx_mult)					{ swap_gen.swap_add_fx_mult_leg1(fx_mult);}	//if non ccy swap: err
void swap_fixflt.add_fx_mult_flt_leg(number fx_mult)					{ swap_gen.swap_add_fx_mult_leg2(fx_mult);}	//if non ccy swap: err
void swap_fixflt.add_disc_func(disc_func option(nullable) df)			{ swap_gen.swap_add_disc_func(df); }	//if ccy swap: err
void swap_fixflt.add_disc_func_fix_leg(disc_func option(nullable) df)	{ swap_gen.swap_add_disc_func_leg1(df); } 
void swap_fixflt.add_disc_func_flt_leg(disc_func  option(nullable) df) 	{ swap_gen.swap_add_disc_func_leg2(df); }	
/*-----------------------------------------------------------------------
  add_fx_rate EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixflt.add_fx_rate(number fx_quote_dec,//must be a quote per unit of base ccy 
							logical pv_in_base_ccy,
							string 	base_ccy,
							string 	price_ccy)
{
	swap_gen.swap_add_fx_rate(fx_quote_dec,pv_in_base_ccy,base_ccy,price_ccy);
}
/*-----------------------------------------------------------------------
  add_surface EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixflt.add_surface(tenor_surface option(nullable) tenor_surface)
{
	swap_gen.swap_add_surface_leg2(tenor_surface);
}
/*-----------------------------------------------------------------------
  add_surface EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixflt.add_surface(disc_func df,fwd_func fwd)
{
	error_info ee = error_info(true,true);
	tenor_surface ts = this.create_tenor_surface( df, fwd,ee);
	QL_FAIL_COND(null(ts),"tenor surface could not be created");
	this.add_surface(ts);
}
/*-----------------------------------------------------------------------
  add_fwd_func EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixflt.add_fwd_func(fwd_func fwd)
{
	error_info ee = error_info(true,true);
	tenor_surface ts = this.create_tenor_surface( this.disc_func_flt_leg(ee), fwd,ee);
	QL_FAIL_COND(null(ts),"tenor surface could not be created");
	this.add_surface(ts);
}

void swap_fixflt.add_fixing(vector(date) fixing_dates,
							vector(number) fixings,
							logical option(nullable) fixing_as_fwd )	{ swap_gen.swap_add_fixing_leg2(fixing_dates,fixings,fixing_as_fwd);}
void swap_fixflt.add_fixing(number fixing_proxy,
							logical option(nullable) fixing_as_fwd ) 	{ swap_gen.swap_add_fixing_leg2(fixing_proxy, fixing_as_fwd);	}
void swap_fixflt.add_current_fixing(number option(nullable) fixing) 	{ swap_gen.swap_add_curr_fixing_leg2(fixing);	}
void swap_fixflt.add_fixing_start_stub(number option(nullable) fixing) 	{ swap_gen.swap_add_fixing_start_stub_leg2(fixing);	}
void swap_fixflt.add_fixing_end_stub(number option(nullable) fixing) 	{ swap_gen.swap_add_fixing_end_stub_leg2(fixing);	}


void swap_fixflt.add_data(	number 			option(nullable) notional,
							disc_func 		option(nullable) disc_func,										
							tenor_surface 	option(nullable) tenor_surface_flt_leg,
							vector(date) 	option(nullable) fixing_dates_flt_leg,
							vector(number) 	option(nullable) fixings_flt_leg,
							logical option(nullable) fixing_as_fwd_flt_leg,
							logical 		upd_null_crv ,
							logical 		upd_null_fix  )//upd_nulls does not apply to notional
{
	notional = conv_null_number_com(notional) ;
	i().__swap_add_fixflt_data(notional,disc_func, tenor_surface_flt_leg,fixing_dates_flt_leg,
							   fixings_flt_leg, fixing_as_fwd_flt_leg, upd_null_crv,upd_null_fix);
	return ;
}

void swap_fixflt.add_ccy_data(	number 			notional_fix_leg,
								disc_func 		disc_func_fix_leg,
								number			fx_mult_fix_leg,
								number 			notional_flt_leg,
								disc_func 		disc_func_flt_leg,
								number			fx_mult_flt_leg,
								tenor_surface 	tenor_surface_flt_leg,
								vector(date) 	fixing_dates_flt_leg,
								vector(number) 	fixings_flt_leg,
								logical option(nullable) fixing_as_fwd_flt_leg,
								logical 		upd_null_crv ,
								logical 		upd_null_fix )//upd_nulls does not apply to notional 
{
	i().__swap_add_fixflt_ext_data(	notional_fix_leg,disc_func_fix_leg, fx_mult_fix_leg,notional_flt_leg,disc_func_flt_leg,
									fx_mult_flt_leg,tenor_surface_flt_leg,fixing_dates_flt_leg,fixings_flt_leg, fixing_as_fwd_flt_leg,
									upd_null_crv,upd_null_fix);
}

/*-----------------------------------------------------------------------
  add_curve_data	EXT SWAP: ok,  not for currency swaps  <protected>
  ----------------------------------------------------------------------*/
void swap_fixflt.add_curve_data( 	disc_func option(nullable) df_fix,
									disc_func option(nullable) df_flt,
									tenor_surface option(nullable) ts )
{
	logical fix_as_fwd = false;
	
	if(ccy_swap_) {
		QL_FAIL_COND(null(df_flt),"df_flt is required for cross currency swap", this,true);		
		this.add_ccy_data(this.fix_leg(false).notional(),df_fix,this.fix_leg(false).fx_mult(),this.float_leg(false).notional(),
						  df_flt,this.float_leg(false).fx_mult(),ts, null,null, fix_as_fwd,true,false);
	}
	else {
		this.add_data(this.nominal(),df_fix,ts,null,null,fix_as_fwd,true,false);
	}
	return;
}


/*-----------------------------------------------------------------------
  set_date 		EXT SWAP: ok
  ext_swap: if trade date is the same --> the settle date will be preserved (if not input)
  ----------------------------------------------------------------------*/
swap_fixflt swap_fixflt.set_date(	date  					trade_date, 
									date  option(nullable)	settle_date,
									error_info option(nullable) error )
{
	instrument cc;
	if(ext_swap_) {
		logical re_init = false; 
		logical init_quote = false;
		cc = instrument._set_date(trade_date,settle_date,re_init,init_quote,error);
	}
	else {
		QL_FAIL_COND(!null(settle_date),"input of settlement date only supported for non-db swaps" ,this,true);
		logical re_init = true; 
		logical init_quote = true;
		cc = instrument._set_date(trade_date,settle_date,re_init,init_quote,error);
	}
	return null(cc) ? null<swap_fixflt>: dynamic_cast<swap_fixflt>(cc);
	
}

/*-----------------------------------------------------------------------
  set_date <protected>		EXT SWAP: ok	
	re_init for swaps means that updated disc_funcs, fixing data etc is not preserved
	ext_swap: if trade date is the same --> the settle date will be preserved (if not input)	
  ----------------------------------------------------------------------*/
swap_fixflt swap_fixflt.set_date(	date  				trade_date, 
									date  option(nullable)	settle_date,
									logical 			re_init, 		//true->fail for ext_swap
									logical 			re_init_quote, 	//true->fail for ext_swap
									error_info option(nullable) error )
{
	QL_FAIL_COND(ext_swap_ && (re_init || re_init_quote),"re_init/re_init_quote flags = true not supported for non-db swaps" ,this,true );
	QL_FAIL_COND(!ext_swap_ && !null(settle_date),"input of settlement date only supported for non-db swaps" ,this,true );
	instrument cc = instrument._set_date(trade_date,settle_date,re_init,re_init_quote,error);
	return null(cc) ? null<swap_fixflt>: dynamic_cast<swap_fixflt>(cc);
	
}

/*-----------------------------------------------------------------------
  set_date <protected/legacy>		EXT SWAP: ok
  re_init for swaps means that updated disc_funcs, fixing data etc is not preserved
  ----------------------------------------------------------------------*/
swap_fixflt swap_fixflt.set_date(	date  				trade_date, 
									logical 			re_init, 
									error_info option(nullable) error ) 

{	
	instrument cc;
	if(ext_swap_){
		QL_FAIL_COND(re_init,"re_init = true not supported for non-db swaps" ,this,true );
		logical init_quote = false;
		cc = instrument._set_date(trade_date,null<date>,re_init,init_quote,error);
	}
	else{		
		logical init_quote = true;
		cc = instrument._set_date(trade_date,null<date>,re_init,init_quote,error);
	}
	return null(cc) ? null<swap_fixflt>: dynamic_cast<swap_fixflt>(cc);	
}

/*-----------------------------------------------------------------------
  set_settle_date		EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_fixflt swap_fixflt.set_settle_date(date  				settle_date, 
										error_info option(nullable) error ) 

{			
	instrument cc = instrument._set_settle_date(settle_date,false,error);	
	return null(cc) ? null<swap_fixflt>: dynamic_cast<swap_fixflt>(cc);	
}

/*-----------------------------------------------------------------------
   move_date  <protected/legacy>		EXT SWAP: ok
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	ext_swap: if trade date is the same --> the settle date will be preserved (if not input)	
  ----------------------------------------------------------------------*/
swap_fixflt swap_fixflt.move_date(	date  				trade_date, 
									date option(nullable) settle_date,
									error_info option(nullable) error ) 
{
	QL_FAIL_COND(!ext_swap_ && !null(settle_date),"input of settlement date only supported for non-db swaps" ,this,true );
	instrument cc = instrument._move_date(trade_date,settle_date,error);
	return null(cc) ? null<swap_fixflt>: dynamic_cast<swap_fixflt>(cc);
}
/*-----------------------------------------------------------------------
  swap_fixflt: set_quote		EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_fixflt swap_fixflt.set_quote(	number 	option(nullable) quote,									
									error_info option(nullable) error )
{
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, true,error);
	return null(cc) ? null<swap_fixflt>: dynamic_cast<swap_fixflt>(cc);
}

/*-----------------------------------------------------------------------
  swap_fixflt: set_quote 		EXT SWAP: will throw because of quote_side
  ----------------------------------------------------------------------*/
swap_fixflt swap_fixflt.set_quote(	string 	option(nullable) quote_side,
									error_info option(nullable) error )
{
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, true,error);
	return null(cc) ? null<swap_fixflt>: dynamic_cast<swap_fixflt>(cc);
}

/*-----------------------------------------------------------------------
  set_yield   FIX-FLT SWAP: yield == fix_cpn_rate  backward compat
  ----------------------------------------------------------------------*/
swap_fixflt swap_fixflt.set_yield(	number 	option(nullable) yield,							
									error_info option(nullable) error )
{
	QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);

	error_info ee 	= new error_info(true,false);	
	number y 		= this.yield(false,ee);
	number cpnr 	= this.coupon_rate(ee);
	if(null(y) || null(cpnr) || CORE_INT.is_equal(y,cpnr))
		return this.set_rate_fix_leg(yield,error);
	
	QL_FAIL_COND(ext_swap_,"inapplicable function call for non-par swaps", this,true);
}
/*-----------------------------------------------------------------------
  set_quote_from_yield  EXT SWAP: throws
  ----------------------------------------------------------------------*/
swap_fixflt swap_fixflt.set_quote_from_yield(number 	option(nullable) yield,
											error_info option(nullable) error )
{
	QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);

	error_info ee 	= new error_info(true,false);
	number y 		= this.yield(false,ee);
	number cpnr 	= this.coupon_rate(ee);
	if(null(y) || null(cpnr) || CORE_INT.is_equal(y,cpnr)) {
		instrument cc = instrument._set_quote_from_yield(yield,  true,error);
		return null(cc) ? null<swap_fixflt>: dynamic_cast<swap_fixflt>(cc);
	}
	QL_FAIL_COND(ext_swap_,"inapplicable function call for non-par swaps", this,true);
}
/*-----------------------------------------------------------------------
  set_rate_fix_leg  EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_fixflt swap_fixflt.set_rate_fix_leg(	number 	option(nullable) cpn_rate,							
											error_info option(nullable) error )
{
	try{
		
		if(!ext_swap_) {
			instrument cc = instrument._set_yield(	cpn_rate, null<date>, null<date>,true, error);
			return null(cc) ? null<swap_fixflt>: dynamic_cast<swap_fixflt>(cc);
		}

		error_info ee = new error_info(true,true);
		..quote_style qs = this.quote_style_e(ee);
		
		number q;
		if(qs == ..quote_style.YIELD_PCT)
			q = cpn_rate * 100;		
		__instrument  c = i().__swap_ext_set_quote(q, null<date>, null<date> );

		instr_error e = new instr_error();
		instrument cc 	= this.create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid swap_fixflt", this, e);
		
		if(!cc.is_valid(error)) 
			return null<swap_fixflt>;	
				
		return dynamic_cast<swap_fixflt>(cc);					
	}	
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.set_rate_fix_leg");
		return null<swap_fixflt>;
	}
}
/*-----------------------------------------------------------------------
  set_spread_ois_leg
  ----------------------------------------------------------------------*/
swap_fixflt swap_fixflt.set_spread_flt_leg(number option(nullable) spread ,
										   error_info option(nullable) error)
{
	try{
		
		QL_REQUIRE(ext_swap_ ,"function only available for non-db swaps" ,this,true );
		
		__instrument  c = i().__swap_ext_set_spread_leg2(spread);

		instr_error e = new instr_error();
		instrument cc 	= this.create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid swap_fixflt", this, e);
		
		if(!cc.is_valid(error)) 
			return null<swap_fixflt>;	
				
		return dynamic_cast<swap_fixflt>(cc);					
	}	
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.set_spread_flt_leg");
		return null<swap_fixflt>;

	}
}



/*-----------------------------------------------------------------------
  set_pay_leg   --> returns an external swap, a db swap cannot be changed in regards to pay vs receive 
  ----------------------------------------------------------------------*/
swap_fixflt swap_fixflt.set_pay_leg(logical pay_fix,							
									error_info option(nullable) error )
{
	try{
		
		__instrument  c = i().__swap_set_pay_leg1(pay_fix );
		
		instr_error e = new instr_error();
		instrument cc 	= this.create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid swap_fixflt", this, e);
		
		if(!cc.is_valid(error)) 
			return null<swap_fixflt>;	
				
		return dynamic_cast<swap_fixflt>(cc);					
	}	
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.set_pay_leg");
		return null<swap_fixflt>;
	}
}
/*-----------------------------------------------------------------------
  create_tenor_surface	(fwd is a fwd_func)  EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_fixflt.create_tenor_surface(disc_func df,
											   fwd_func fwdf,
											   error_info option(nullable) error)
{
	return swap_gen.create_tenor_surface_flt_leg(false, df, fwdf, error);
}
/*-----------------------------------------------------------------------
  create_tenor_surface	(fwd is a disc_func) EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_fixflt.create_tenor_surface(disc_func df,
											   disc_func fwddf,
											   error_info option(nullable) error)
{
	return swap_gen.create_tenor_surface_flt_leg(false, df, fwddf, error);
}

/*-----------------------------------------------------------------------
  start_date	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
date  swap_fixflt.start_date(error_info option(nullable) error ) 
{
	return this.issue_date(error);
}
/*-----------------------------------------------------------------------
  fx_mult	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.fx_mult_factor(	out number  fx_mult_fix_leg, 
									out number  fx_mult_flt_leg, 
									error_info option(nullable) error ) 
{
	swap_gen.fx_mult_factor(fx_mult_fix_leg, fx_mult_flt_leg, error ) ;
	return;
	
}
/*-----------------------------------------------------------------------
  settle_code  EXT SWAP: ok
  ----------------------------------------------------------------------*/
string swap_fixflt.settle_code(error_info option(nullable) error )  
{
	return swap_gen.settle_code(error);
}
/*-----------------------------------------------------------------------
  is_regular_first	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.is_regular_first(	out logical option(nullable) is_reg_fix_leg, 
									out logical option(nullable) is_reg_flt_leg, 
									error_info option(nullable) error ) 
{	
	try{
		
		error_info ee = error_info(true,true);
		
		ql_float_leg flt = this.float_leg(false,ee);
		is_reg_flt_leg = flt.is_reg_first_period();
		
		ql_fix_leg fix = this.fix_leg(false,ee);
		is_reg_fix_leg = fix.is_reg_first_period();
		
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.is_regular_first");
		is_reg_fix_leg = is_reg_flt_leg = null<logical >;
		return ;
	}
}

/*-----------------------------------------------------------------------
  is_regular_last	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.is_regular_last(	out logical option(nullable) is_reg_fix_leg, 
									out logical option(nullable) is_reg_flt_leg, 
									error_info option(nullable) error ) 
{	
	try{
		
		error_info ee = error_info(true,true);
		ql_float_leg flt = this.float_leg(false,ee);
		is_reg_flt_leg = flt.is_reg_last_period();
		
		ql_fix_leg fix = this.fix_leg(false,ee);
		is_reg_fix_leg = fix.is_reg_last_period();
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.is_regular_last");
		is_reg_fix_leg = is_reg_flt_leg = null<logical >;
		return ;
	}
}
/*-----------------------------------------------------------------------
  current_fixing_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number	swap_fixflt.current_fixing_flt_leg(out date reset_date,
										   out logical is_fixed,
										   error_info option(nullable) error)
{
	try{
		error_info ee = error_info(true,true);
		ql_float_leg flt = this.float_leg(false,ee);

		return flt.current_fixing_rate(reset_date,is_fixed);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.current_fixing_flt_leg");		
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  notional	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.notional(	out number  notional_fix_leg, 
							out number  notional_flt_leg, 
							error_info option(nullable) error ) 
{
	swap_gen.notional( notional_fix_leg,notional_flt_leg, error ) ;
	return;
}

/*-----------------------------------------------------------------------
  notional	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fixflt.notional(	error_info option(nullable) error ) 
{
	return swap_gen.nominal(error);
	
}

/*-----------------------------------------------------------------------
  currency	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.currency(	out string curr_fix_leg, 
							out string curr_flt_leg, 
							error_info option(nullable) error ) 
{
	swap_gen.currency(curr_fix_leg,  curr_flt_leg,  error);
	return;

}
/*-----------------------------------------------------------------------
  currency_fix_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
string swap_fixflt.currency_fix_leg( error_info option(nullable) error ) 
{
	string curr_fix_leg,  curr_flt_leg;
	swap_gen.currency(curr_fix_leg,  curr_flt_leg,  error);
	return curr_fix_leg;

}
/*-----------------------------------------------------------------------
  currency_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
string swap_fixflt.currency_flt_leg( error_info option(nullable) error ) 
{
	string curr_fix_leg,  curr_flt_leg;
	swap_gen.currency(curr_fix_leg,  curr_flt_leg,  error);
	return curr_flt_leg;

}

/*-----------------------------------------------------------------------
  quote 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.quote(	out number  quote_fix_leg, 
							out number  spread_flt_leg, 
							error_info option(nullable) error ) 
{
	swap_gen.quote(quote_fix_leg,  spread_flt_leg, error);
}
/*-----------------------------------------------------------------------
  quote   
  ----------------------------------------------------------------------*/
number  swap_fixflt.quote(error_info option(nullable) error)

{
	return swap_gen.quote(error);
}
/*-----------------------------------------------------------------------
  spread_flt_leg 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*number  swap_fixflt.spread_flt_leg(error_info option(nullable) error ) 
{
	number q1,quote_flt_leg;
	swap_gen.quote(	q1, quote_flt_leg,  error );

	return quote_flt_leg;
}*/
/*-----------------------------------------------------------------------
  spread_flt_leg 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fixflt.spread_flt_leg(error_info option(nullable) error ) 
{
	try{
		
		instr_error_type t;
   		string 			s;
		number q,quote_flt_leg;
		i().__swap_def_quote(q,quote_flt_leg,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fixflt.spread_flt_leg");
		if( e) {
			return null<number> ;
		}
		
		..quote_style qs = i().__swap_quote_style_e_leg2(t,s);
		e = CORE_INT.add_error_info(error,t,s, "swap_fixflt.spread_flt_leg");
		if(e)
			return null<number>;

		if(null(quote_flt_leg))
			return 0;
		
		switch(qs) {
			case ..quote_style.SPREAD:
				return quote_flt_leg;
			case ..quote_style.SPREAD_BP:					
			default:
				return quote_flt_leg/10000;
		}
							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.spread_flt_leg");
		return null<number> ;
	}
}
/*-----------------------------------------------------------------------
  coupon   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.coupon(	out number  cpn_fix_leg, 
							out number  cpn_flt_leg, 
							error_info option(nullable) error ) 
{
	swap_gen.coupon(cpn_fix_leg,cpn_flt_leg,error);
	return;
}

/*-----------------------------------------------------------------------
  coupon_fix_leg	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
number  swap_fixflt.coupon_fix_leg(error_info option(nullable) error ) 
{
	return swap_gen.coupon(error);
}

/*-----------------------------------------------------------------------
  current_coupon_flt_leg	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
number  swap_fixflt.current_coupon_flt_leg(error_info option(nullable) error ) 
{
	number  cpn_leg1 ,cpn_leg2;
	swap_gen.coupon(cpn_leg1 ,cpn_leg2,  error );
	return cpn_leg2;
}
/*-----------------------------------------------------------------------
  reset_freq_flt_leg	
  ----------------------------------------------------------------------*/
integer  swap_fixflt.reset_freq_flt_leg(error_info option(nullable) error ) 
{
	integer c1,c2;
	swap_gen.reset_freq(c1,c2  ,error ) ;
	return c2;
}
/*-----------------------------------------------------------------------
  coupon_freq_flt_leg	
  ----------------------------------------------------------------------*/
integer  swap_fixflt.coupon_freq_flt_leg(error_info option(nullable) error ) 
{
	integer c1,c2;
	swap_gen.coupon_freq(c1,c2  ,error ) ;
	return c2;
}
/*-----------------------------------------------------------------------
  coupon_freq_fix_leg	
  ----------------------------------------------------------------------*/
integer  swap_fixflt.coupon_freq_fix_leg(error_info option(nullable) error ) 
{
	integer c1,c2;
	swap_gen.coupon_freq(c1,c2  ,error ) ;
	return c1;
}
/*-----------------------------------------------------------------------
  dc_method   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.dc_method(	out day_count_method  dc_method_fix_leg, 
								out day_count_method  dc_method_flt_leg, 
								error_info option(nullable) error ) 
{
	swap_gen.dc_method(dc_method_fix_leg,dc_method_flt_leg,error);
	return;
}

/*-----------------------------------------------------------------------
  dc_method   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
day_count_method  swap_fixflt.dc_method_flt_leg( error_info option(nullable) error ) 
{
	day_count_method dc_method_fix_leg,dc_method_flt_leg;
	swap_gen.dc_method(dc_method_fix_leg,dc_method_flt_leg,error);
	return dc_method_flt_leg;
}
/*-----------------------------------------------------------------------
  dc_method   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
day_count_method  swap_fixflt.dc_method_fix_leg( error_info option(nullable) error ) 
{
	day_count_method dc_method_fix_leg,dc_method_flt_leg;
	swap_gen.dc_method(dc_method_fix_leg,dc_method_flt_leg,error);
	return dc_method_fix_leg;
}

/*-----------------------------------------------------------------------
  ir_rule_fix_leg
  ----------------------------------------------------------------------*/
interest_rule  swap_fixflt.ir_rule_fix_leg(error_info option(nullable) error)
	{	
	interest_rule ifix, iflt;
	swap_gen.ir_rule(ifix, iflt,  error ) ;
	return ifix;
}
/*-----------------------------------------------------------------------
  ir_rule_flt_leg
  ----------------------------------------------------------------------*/
interest_rule  swap_fixflt.ir_rule_flt_leg(error_info option(nullable) error)
	{	
	interest_rule ifix, iflt;
	swap_gen.ir_rule(ifix, iflt,  error ) ;
	return iflt;
}
/*-----------------------------------------------------------------------
  start_stub_info_flt_leg
  ----------------------------------------------------------------------*/
void swap_fixflt.start_stub_info_flt_leg(	out logical is_stub,
											out logical is_reg,
											out date idx_start,
											out date idx_end,	
											out flt_stub_fwd_style stub_style,
											out number stub_rate_base,
											out number stub_rate_imp,
											out number stub_rate,
											error_info option(nullable) error )
{
	try{
		error_info ee = new error_info(true,true);
		ql_float_leg l = float_leg(false,ee);
		l.stub_start_info(is_stub, is_reg,idx_start,idx_end, stub_style,stub_rate_base,stub_rate_imp,stub_rate);
		return ;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.start_stub_info_flt_leg");
		return ;
	}
}
/*-----------------------------------------------------------------------
  end_stub_info_flt_leg
  ----------------------------------------------------------------------*/
void swap_fixflt.end_stub_info_flt_leg(	out logical is_stub,
										out logical is_reg,
										out date idx_start,
										out date idx_end,
										out flt_stub_fwd_style stub_style,
										out number stub_rate_base,
										out number stub_rate_imp,
										out number stub_rate,
										error_info option(nullable) error )
{
	try{
		error_info ee = new error_info(true,true);
		ql_float_leg l = float_leg(false,ee);
		l.stub_end_info(is_stub, is_reg,idx_start,idx_end, stub_style,stub_rate_base,stub_rate_imp,stub_rate);
		return ;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.end_stub_info_flt_leg");
		return ;
	}
}
/*-----------------------------------------------------------------------
  stub_fwd_style_flt_leg
  ----------------------------------------------------------------------*/
flt_stub_fwd_style  swap_fixflt.stub_fwd_style_flt_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_stub_fwd_style_leg2(error) ;
}

/*-----------------------------------------------------------------------
  avg_method_flt_leg
  ----------------------------------------------------------------------*/
flt_avg_method  swap_fixflt.avg_method_flt_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_avg_method_leg2(error) ;
}
/*-----------------------------------------------------------------------
  sprd_comp_method_flt_leg
  ----------------------------------------------------------------------*/
flt_sprd_comp_method  swap_fixflt.sprd_comp_method_flt_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_sprd_comp_method_leg2(error) ;
}
/*-----------------------------------------------------------------------
  comp_avg_type_flt_leg
  ----------------------------------------------------------------------*/
flt_comp_avg_type  swap_fixflt.comp_avg_type_flt_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_comp_avg_type_leg2(error) ;
}
/*-----------------------------------------------------------------------
  effective_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.effective_date(	out date  effective_date_fix_leg, 
									out date  effective_date_flt_leg, 
									error_info option(nullable) error) 
{
	swap_gen.effective_date(effective_date_fix_leg,effective_date_flt_leg,error);
	return;

}
/*-----------------------------------------------------------------------
  next_cpn_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.next_cpn_date(	out date  next_cpn_date_fix_leg, 
									out date  next_cpn_date_flt_leg, 
									error_info option(nullable) error) 
{
	swap_gen.next_cpn_date(next_cpn_date_fix_leg,next_cpn_date_flt_leg,error) ;
	return;
}
/*-----------------------------------------------------------------------
  previous_cpn_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.previous_cpn_date(out date  prev_cpn_date_fix_leg, 
									out date  prev_cpn_date_flt_leg, 
									error_info option(nullable) error) 
{
	swap_gen.previous_cpn_date(prev_cpn_date_fix_leg,prev_cpn_date_flt_leg,error) ;
	return;
}
/*-----------------------------------------------------------------------
  coupon_freq   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.coupon_freq(	out integer  cpn_freq_fix_leg, 
								out integer  cpn_freq_flt_leg, 
								error_info option(nullable) error ) 
{
	swap_gen.coupon_freq(cpn_freq_fix_leg,cpn_freq_flt_leg,error);
	return;
}

/*-----------------------------------------------------------------------
  first_cpn_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.first_cpn_date(	out date  first_cpn_date_fix_leg, 
									out date  first_cpn_date_flt_leg, 
									error_info option(nullable) error) 
{
	swap_gen.first_cpn_date(first_cpn_date_fix_leg,first_cpn_date_flt_leg,error);
	return;
}
/*-----------------------------------------------------------------------
  last_reg_cpn_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.last_reg_cpn_date(out date  last_reg_cpn_date_fix_leg, 
									out date  last_reg_cpn_date_flt_leg, 
									error_info option(nullable) error) 
{
	swap_gen.last_reg_cpn_date(last_reg_cpn_date_fix_leg,last_reg_cpn_date_flt_leg,error);
	return;
}

/*-----------------------------------------------------------------------
  roll_day   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.roll_day(	out integer  roll_day_fix_leg, 
							out integer  roll_day_flt_leg, 
							error_info option(nullable) error ) 
{
	swap_gen.roll_day(roll_day_fix_leg,roll_day_flt_leg,error);
	return;
}
/*-----------------------------------------------------------------------
  eom   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.eom(	out logical option(nullable)  	eom_fix_leg, 
						out logical option(nullable) 	eom_flt_leg, 
						error_info option(nullable) 	error ) 
{
	swap_gen.eom(eom_fix_leg, eom_flt_leg,  error ) ;
	return;
}

/*-----------------------------------------------------------------------
  eom_fix_leg   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical  swap_fixflt.eom_fix_leg( error_info option(nullable) 	error ) 
{
	logical efix,eflt;
	swap_gen.eom(efix,eflt,  error ) ;
	return efix;
}
/*-----------------------------------------------------------------------
  eom_flt_leg   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical  swap_fixflt.eom_flt_leg( error_info option(nullable) 	error ) 
{
	logical efix,eflt;
	swap_gen.eom(efix,eflt,  error ) ;
	return eflt;
}
/*-----------------------------------------------------------------------
  calendar   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.calendar(	out ..calendar option(nullable)  cal_fix_leg, 
							out ..calendar option(nullable) cal_flt_leg, 
							error_info option(nullable) error ) 
{
	swap_gen.calendar(cal_fix_leg, cal_flt_leg,  error ) ;
	return;
}
/*-----------------------------------------------------------------------
  calendar_fix_leg   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
calendar  swap_fixflt.calendar_fix_leg( error_info option(nullable) error ) 
{
	..calendar cal_fix_leg, cal_flt_leg;
	swap_gen.calendar(cal_fix_leg, cal_flt_leg,  error ) ;
	return cal_fix_leg;
}
/*-----------------------------------------------------------------------
  calendar_fix_leg   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
calendar  swap_fixflt.calendar_flt_leg( error_info option(nullable) error ) 
{
	..calendar cal_fix_leg, cal_flt_leg;
	swap_gen.calendar(cal_fix_leg, cal_flt_leg,  error ) ;
	return cal_flt_leg;
}
/*-----------------------------------------------------------------------
  calendar_name   	
  ----------------------------------------------------------------------*/
void  swap_fixflt.calendar_name(out string  cal_name_fix_leg, 
								out string  cal_name_flt_leg, 
								error_info option(nullable) error ) 
{
	swap_gen.calendar_name(cal_name_fix_leg, cal_name_flt_leg,  error );
	return;
	
}

/*-----------------------------------------------------------------------
  pmt_bus_day 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.pmt_bus_day(	out bd_convention option(nullable) pmt_bus_day_fix_leg, 
								out bd_convention option(nullable) pmt_bus_day_flt_leg, 
								error_info option(nullable) error ) 
{
	swap_gen.pmt_bus_day(pmt_bus_day_fix_leg, pmt_bus_day_flt_leg,  error ) ;
	return;
}
/*-----------------------------------------------------------------------
  pmt_bus_day_fix_leg 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
bd_convention  swap_fixflt.pmt_bus_day_fix_leg( error_info option(nullable) error ) 
{
	bd_convention bdfix, bdflt;
	swap_gen.pmt_bus_day(bdfix, bdflt,  error ) ;
	return bdfix;
}
/*-----------------------------------------------------------------------
  pmt_bus_day_flt_leg 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
bd_convention  swap_fixflt.pmt_bus_day_flt_leg( error_info option(nullable) error ) 
{
	bd_convention bdfix, bdflt;
	swap_gen.pmt_bus_day(bdfix, bdflt,  error ) ;
	return bdflt;
}
/*-----------------------------------------------------------------------
  notional_exchg_style_fix_leg 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
notional_exchg_style swap_fixflt.notional_exchg_style_fix_leg(error_info option(nullable)  error )
{
	try{
		
		error_info ee = error_info(true,true);

		ql_fix_leg fix = this.fix_leg(false,ee);
		return fix.fix_def().notional_exchange();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.notional_exchg_style_fix_leg");
		return null;
	}
}
/*-----------------------------------------------------------------------
  notional_exchg_style_flt_leg 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
notional_exchg_style swap_fixflt.notional_exchg_style_flt_leg(error_info option(nullable)  error )
{
	try{
		
		error_info ee = error_info(true,true);
		ql_float_leg flt = this.float_leg(false,ee);
		return flt.float_def().notional_exchange();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.notional_exchg_style_flt_leg");
		return null;
	}
}
/*-----------------------------------------------------------------------
  accr_dates_fix_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.accr_dates_fix_leg(	logical 			post_settle, 
										out vector(date) 	accr_start_date,									
										out vector(date) 	accr_end_date,
										out vector(number)  accr_period,
										error_info option(nullable) 		error ) 
{
	vector(date) accr_start_date_leg2;
	vector(date) accr_end_date_leg2;
	vector(number) accr_period_leg2;
	swap_gen.accr_dates(post_settle,
						accr_start_date,accr_end_date,accr_period,
						accr_start_date_leg2,accr_end_date_leg2,accr_period_leg2,
						error ) ;
	return;
}
/*-----------------------------------------------------------------------
  accr_dates_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.accr_dates_flt_leg(	logical 		post_settle, 
									out vector(date) 	accr_start_date,									
									out vector(date) 	accr_end_date,
									out vector(number)  accr_period,
									error_info option(nullable) 		error ) 
{	
	vector(date) accr_start_date_leg1;
	vector(date) accr_end_date_leg1;
	vector(number) accr_period_leg1;
	swap_gen.accr_dates(post_settle,
						accr_start_date_leg1,accr_end_date_leg1,accr_period_leg1,
						accr_start_date,accr_end_date,accr_period,
						error ) ;
	return;
}
/*-----------------------------------------------------------------------
  index_dates_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.index_dates_flt_leg(	logical 			post_settle, 
										out vector(date) 	index_start_dates,									
										out vector(date) 	index_end_dates,
										out vector(logical)  index_regular,
										error_info option(nullable) 		error ) 
{
	swap_gen.index_dates_flt_leg(false,post_settle, index_start_dates,index_end_dates,index_regular,error ) ;
}

/*-----------------------------------------------------------------------
  fixing_data_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.fixing_data_flt_leg(	logical 					post_trade_date,
										logical option(nullable)	only_fixed, 
										out vector(date) 			reset_date,									
										out vector(number)  		reset_rate,
										out vector(logical)  		is_fixed,
										error_info option(nullable) error ) 
{	
	try{
		error_info ee = error_info(true,true);
		ql_float_leg flt = this.float_leg(false,ee);
		
		date cut_off = post_trade_date ? this.trade_date(): null<date>;
		flt.fixing_data(only_fixed,reset_date,reset_rate,is_fixed,cut_off);

		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.fixing_data_flt_leg");
		reset_date = null<vector(date)>; 
		reset_rate = null<vector(number)>; 
		is_fixed = null<vector(logical)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  cash_flow_dates	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.cash_flow_dates(	logical 			post_settle, 
									out vector(date) 	pmt_dates_fix_leg,									
									out vector(date) 	pmt_dates_flt_leg,
									error_info option(nullable) error ) 
{
	swap_gen.cash_flow_dates(post_settle, pmt_dates_fix_leg,pmt_dates_flt_leg,error ) ;
	return;
}
/*-----------------------------------------------------------------------
  cash_flows_cpn	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.cash_flows_cpn(	logical 			post_settle, 
									out vector(number) 	cpn_cf_fix_leg,									
									out vector(number) 	cpn_cf_flt_leg,
									error_info option(nullable) error ) 
{
	swap_gen.cash_flows_cpn(	post_settle, cpn_cf_fix_leg,cpn_cf_flt_leg,error );
	return;
}


/*-----------------------------------------------------------------------
  cash_flows	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.cash_flows(	logical 			post_settle, 
								out vector(number) 	cf_fix_leg,									
								out vector(number) 	cf_flt_leg,
								error_info option(nullable) error ) 
{
	swap_gen.cash_flows(post_settle, cf_fix_leg,cf_flt_leg,error ) ;
	return;
}



/*-----------------------------------------------------------------------
  cash_flow_data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.cash_flow_data(	logical 			post_settle,
									ir_cf_code 			cf_code, 
									out vector(date) 	pmt_dates_fix_leg,									
									out vector(number)  cf_fix_leg,
									out vector(date) 	pmt_dates_flt_leg,									
									out vector(number) 	cf_flt_leg,
									error_info option(nullable) error ) 
{
	swap_gen.cash_flow_data(	post_settle,cf_code, pmt_dates_fix_leg,cf_fix_leg,pmt_dates_flt_leg,cf_flt_leg, error );
	return;
}



/*-----------------------------------------------------------------------
  cash_flow_data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.cash_flow_data(logical 				post_settle,
								logical option(nullable) trade_date_pv,
								out vector(date)  	pmt_date_fix_leg,
								out vector(number)  cpn_rate_fix_leg,
								out vector(number)  cpn_cashflow_fix_leg,
								out vector(number)  pv_cpn_cashflow_fix_leg,
								out vector(number)  fee_fix_leg,
								out vector(number)  pv_fee_fix_leg,
								out vector(number)  notional_fix_leg,
								out vector(date)  	pmt_date_flt_leg,
								out vector(number)  cpn_rate_flt_leg,
								out vector(number)  cpn_cashflow_flt_leg,
								out vector(number)  pv_cpn_cashflow_flt_leg,
								out vector(number)  fee_flt_leg,
								out vector(number)  pv_fee_flt_leg,
								out vector(number)  notional_flt_leg,
								error_info option(nullable) error ) 
{
	swap_gen.cash_flow_data(	post_settle,trade_date_pv,pmt_date_fix_leg,cpn_rate_fix_leg,cpn_cashflow_fix_leg,pv_cpn_cashflow_fix_leg,
					fee_fix_leg,pv_fee_fix_leg,notional_fix_leg,pmt_date_flt_leg,cpn_rate_flt_leg,cpn_cashflow_flt_leg,
					pv_cpn_cashflow_flt_leg,fee_flt_leg,pv_fee_flt_leg,notional_flt_leg, error );
	return;
}
/*-----------------------------------------------------------------------
  data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.data(	out swap_fix_leg_data fix_leg_data,
						out swap_flt_leg_data	float_leg_data,
						error_info option(nullable) error )
{
	try{
		error_info ee = new error_info(true,true);
		vector(ql_swap_leg) l = legs(false,ee);
		fix_leg_data = new swap_fix_leg_data(l[0]);
		float_leg_data = new swap_flt_leg_data(l[1],true);
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.data");
		fix_leg_data = null<swap_fix_leg_data>;
		float_leg_data = null<swap_flt_leg_data>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.data(out swap_fix_leg_data fix_leg_data,
						error_info option(nullable) error )
{
	try{
		error_info ee = new error_info(true,true);
		vector(ql_swap_leg) l = legs(false,ee);
		fix_leg_data = new swap_fix_leg_data(l[0]);
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.data");
		fix_leg_data = null<swap_fix_leg_data>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.data(out swap_flt_leg_data	float_leg_data,
						error_info option(nullable) error )
{
	try{
		error_info ee = new error_info(true,true);
		vector(ql_swap_leg) l = legs(false,ee);
		float_leg_data = new swap_flt_leg_data(l[1],true);
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.data");
		float_leg_data = null<swap_flt_leg_data>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  accrued	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fixflt.accrued(logical 	in_pcnt,
							out number  accr_fix_leg,									
							out number  accr_flt_leg,
							error_info option(nullable) error ) 
option(com_name: 'accrued_ext')
{
	return swap_gen.accrued(in_pcnt, accr_fix_leg, accr_flt_leg, error ) ;
}


/*-----------------------------------------------------------------------
  accrued_period  EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixflt.accrued_period(	out number  period_fix_leg,
									out number  period_flt_leg,
									out integer 				n_days_fix_leg,
									out integer 				n_days_flt_leg,
									error_info option(nullable) error ) 
{
	swap_gen.accrued_period(period_fix_leg,period_flt_leg,n_days_fix_leg,n_days_flt_leg, error ) ;
	return;
}

/*-----------------------------------------------------------------------
  accrued_chg  EXT SWAP: ok
  ----------------------------------------------------------------------*/
number swap_fixflt.accrued_chg  (	integer 	bus_days,
									out	number ai_chg_fix_leg,
									out	number ai_chg_flt_leg,
									out	number cpn_cashflow_fix_leg,
									out	number cpn_cashflow_flt_leg,
									out date settle,
									out date settle_next,	
									error_info option(nullable) error ) 
{
	return swap_gen.accrued_chg(bus_days,ai_chg_fix_leg,ai_chg_flt_leg,cpn_cashflow_fix_leg,cpn_cashflow_flt_leg,
								settle,settle_next,	error);
}

/*-----------------------------------------------------------------------
  df_shifted_flt_leg  prot
  ----------------------------------------------------------------------*/
disc_func swap_fixflt.df_shifted_flt_leg(	number 		delta_disc,
											disc_func 	df)
{		
	return swap_gen.df_shifted_disc_rates_flt_leg(false, delta_disc, df);
}

/*-----------------------------------------------------------------------
  fwd_shifted_flt_leg		DUPLICATED FROM fltflt
  ----------------------------------------------------------------------*/
tenor_surface swap_fixflt.fwd_shifted_flt_leg(number 			delta_fwd,
												disc_func 		df,							
												tenor_surface 	ts)
{
	return swap_gen.fwd_shifted_flt_leg(false, delta_fwd, df, ts);
}

module CORE_INT_FIXFLT
{
	
	/*-----------------------------------------------------------------------
	  risk_ladder_fwd_fixflt
	  ----------------------------------------------------------------------*/
	void  risk_ladder_fwd_fixflt(	swap_fixflt 		sw,
									logical 			payfix,
									number 				nominal,
									vector(fwd_func) 	f_v_pert,
									fwd_func 			f_base,
									fwd_func option(nullable) f_all,
									out vector(number) 	pv_diff_pert,
									out number 			pv_diff_all,
									number 				y_shift,
									error_info option(nullable) error ) 
	{
		error_info ee 			= new error_info(true,true);
		logical instr_payfix 	= sw.pay_fix(ee);
		number sign 			= payfix == instr_payfix ? 1.0: -1.0; 
		disc_func dfflt_orig 	= sw.disc_func_flt_leg(ee);
		disc_func dffix_orig 	= sw.disc_func_fix_leg(ee);
		tenor_surface ts_orig 	= sw.tenor_surface_flt_leg(ee);
		QL_FAIL_COND(null(dffix_orig), "discount function for fixed leg not set", sw.name(), true);
		//dff = dff_orig;
		QL_FAIL_COND(null(dfflt_orig), "discount function for float leg not set", sw.name(), true);
		//df = df_orig;
		//QL_FAIL_COND(null(ts_orig), "tenor surface not set", this, true);
		//tenor_surface ts = ts_orig;
		number nom 				= sw.nominal(ee);
		number scale_nom 		= nominal/nom;
		number shift_mult 		= 0.0001 / y_shift;	
		logical trade_date_pv 	= false;
		number mult 			= sign*scale_nom*shift_mult;
			
		integer size 			= v_size(f_v_pert);
		resize(pv_diff_pert,size);
		pv_diff_pert 			= 0;

		date d 					= sw.trade_date();
		ir_index ir				= sw.ir_index(ee);
		QL_FAIL_COND(ee.is_error(), ee.message(), sw.name(), true);
		logical allow_extrap 	= true;		
		tenor_surface ts 		= tenor_surface(d, dfflt_orig,[f_base],[ir],allow_extrap);		
		QL_FAIL_COND(null(ts), "error creating tenor surface", sw.name(), true);		
		sw.add_surface(ts);
			
		number pv_fix,pv_flt;
		number pv_base 			= sw.present_value(pv_fix,pv_flt,trade_date_pv,ee);	
		QL_FAIL_COND(ee.is_error(), ee.message(), sw.name(), true);

		vector(date) 	reset_date;
		vector(number)  rate;
		vector(logical)  is_fixed;
		sw.fixing_data_flt_leg(	false,false,  reset_date, rate, is_fixed, ee );
		
		for(integer i=0;i<size;i++){
			QL_FAIL_COND(null(f_v_pert[i]), "fwd_func in vector not valid", sw.name(), true);
			ts 		= tenor_surface(d, dfflt_orig,[f_v_pert[i]],[ir],allow_extrap);
			
			QL_FAIL_COND(null(ts), "error creating tenor surface", sw.name(), true);		
			sw.add_surface(ts);

			sw.fixing_data_flt_leg(	false,false,  reset_date, rate, is_fixed, ee );
			
			number pvi = sw.present_value(pv_fix,pv_flt,trade_date_pv,ee);
			QL_FAIL_COND(ee.is_error(), ee.message(), sw.name(), true);
			
			pv_diff_pert[i] = (pvi - pv_base)*mult;			
		
		}
		if(!null(f_all)){
			ts 		= tenor_surface(d, dfflt_orig,[f_all],[ir],allow_extrap);
			
			QL_FAIL_COND(null(ts), "error creating tenor surface", sw.name(), true);		
			sw.add_surface(ts);
			number pv_all = sw.present_value(pv_fix,pv_flt,trade_date_pv,ee);
			QL_FAIL_COND(ee.is_error(), ee.message(), sw.name(), true);
			
			pv_diff_all = (pv_all - pv_base)*mult;
		}
		else {
			pv_diff_all = null<number>;
		}
		sw.add_surface(ts_orig);	
	}

	/*-----------------------------------------------------------------------
	  risk_ladder_disc
	  ----------------------------------------------------------------------*/
	void  risk_ladder_disc_fixflt(	swap_fixflt 		sw,
									logical 			payfix,
									number 				nominal,
									fwd_func option(nullable) f,
									vector(disc_func) 	df_v_pert,
									disc_func 			df_base,
									disc_func option(nullable) df_all,
									out vector(number) 	pv_diff_pert,
									out number 			pv_diff_all,
									number 				y_shift,
									error_info option(nullable) error ) 
	{
		error_info ee 			= new error_info(true,true);
		logical instr_payfix 	= sw.pay_fix(ee);
		number sign 			= payfix == instr_payfix ? 1.0: -1.0; 
		disc_func dfflt_orig 	= sw.disc_func_flt_leg(ee);
		disc_func dffix_orig 	= sw.disc_func_fix_leg(ee);
		tenor_surface ts_orig 	= sw.tenor_surface_flt_leg(ee);
		//QL_FAIL_COND(null(dff_orig), "discount function for fixed leg not set", sw.name(), true);
		//dff = dff_orig;
		//QL_FAIL_COND(null(df_orig), "discount function for float leg not set", sw.name(), true);
		//df = df_orig;
		//QL_FAIL_COND(null(ts_orig), "tenor surface not set", this, true);
		//tenor_surface ts = ts_orig;
		if(null(f)) {
			tenor_code tc 			= sw.ir_index_flt_leg().tenor_code();
			QL_FAIL_COND(null(ts_orig), "tenor surface not set", sw.name(), true);
			f 				= ts_orig.fwd_curve_f(tc);
			QL_FAIL_COND(null(f), "invalid tenor surface", sw.name(), true);
		}
		
		number nom 				= sw.nominal(ee);
		number scale_nom 		= nominal/nom;
		number shift_mult 		= 0.0001 / y_shift;	
		logical trade_date_pv 	= false;
		number mult 			= sign*scale_nom*shift_mult;
		
		integer size 			= v_size(df_v_pert);
		resize(pv_diff_pert,size);
		pv_diff_pert 			= 0;

		date d 					= sw.trade_date();
		ir_index ir				= sw.ir_index(ee);
		QL_FAIL_COND(ee.is_error(), ee.message(), sw.name(), true);
		logical allow_extrap 	= true;

		//---set base---
		sw.add_disc_func(df_base);
		tenor_surface ts 		= tenor_surface(d, df_base,[f],[ir],allow_extrap);		
		QL_FAIL_COND(null(ts), "error creating tenor surface", sw.name(), true);		
		sw.add_surface(ts);		
		//---
		
		number pv_fix,pv_flt;
		number pv_base 			= sw.present_value(pv_fix,pv_flt,trade_date_pv,ee);	
		QL_FAIL_COND(ee.is_error(), ee.message(), sw.name(), true);
		
		for(integer i=0;i<size;i++){
			
			QL_FAIL_COND(null(df_v_pert[i]), "disc_func in vector not valid", sw.name(), true);
			sw.add_disc_func(df_v_pert[i]);
			//ts 		= tenor_surface(d, df_v_pert[i],[f],[ir],allow_extrap);
			
			//QL_FAIL_COND(null(ts), "error creating tenor surface", sw.name(), true);		
			//sw.add_surface(ts);

			number pvi = sw.present_value(pv_fix,pv_flt,trade_date_pv,ee);
			QL_FAIL_COND(ee.is_error(), ee.message(), sw.name(), true);
			
			pv_diff_pert[i] = (pvi - pv_base)*mult;			
		
		}
		if(!null(df_all)){
			sw.add_disc_func(df_all);
			//ts 		= tenor_surface(d, df_all,[f],[ir],allow_extrap);			
			//QL_FAIL_COND(null(ts), "error creating tenor surface", sw.name(), true);			
			//sw.add_surface(ts);
			number pv_all = sw.present_value(pv_fix,pv_flt,trade_date_pv,ee);
			QL_FAIL_COND(ee.is_error(), ee.message(), sw.name(), true);
			
			pv_diff_all = (pv_all - pv_base)*mult;
		}
		else {
			pv_diff_all = null<number>;
		}
		
		sw.add_disc_func_flt_leg(dfflt_orig);
		sw.add_disc_func_fix_leg(dffix_orig);
		sw.add_surface(ts_orig);	
	}
	/*-----------------------------------------------------------------------
	fwd_date_adjust  Note! not a member func
	----------------------------------------------------------------------*/
	void fwd_date_adjust(	out date  	fwd_trade_date,//can be both input and output
							out date 	fwd_settle_date,
							..calendar 	cal,
							date_code 	option(nullable) spot_code)
	{
		if(null(fwd_settle_date)) {
			QL_REQUIRE(!null(fwd_trade_date),"Invalid forward settlement date (must be defined when forward trade date is not input)");
			QL_REQUIRE(!null(spot_code),"Invalid settle code");
			fwd_trade_date = cal.adjust_date(fwd_trade_date, BD_FOLLOWING);
			fwd_settle_date  = spot_code.apply_fwd(fwd_trade_date,cal);
		}
		else if(null(fwd_trade_date)) {
			QL_REQUIRE(!null(fwd_settle_date),"Invalid forward trade date (must be defined when forward settlement date is not input)");
			QL_REQUIRE(!null(spot_code),"Invalid settle code");
			fwd_settle_date = cal.adjust_date(fwd_settle_date, BD_FOLLOWING);
			fwd_trade_date  = spot_code.apply_back(fwd_settle_date,cal);
		}
		else{			
			fwd_trade_date = cal.adjust_date(fwd_trade_date, BD_FOLLOWING);
			fwd_settle_date = cal.adjust_date(fwd_settle_date, BD_FOLLOWING);
		}
	}
}

						
/*-----------------------------------------------------------------------
  risk_ladder_disc
  ----------------------------------------------------------------------*/
void  swap_fixflt.risk_ladder_disc(	fwd_func option(nullable) 	f,
									vector(disc_func) 			df_v_pert,
									disc_func 					df_base,
									disc_func option(nullable) 	df_all,
									number 						y_shift,
									out vector(number) 			pv_diff_pert,
									out number 					pv_diff_all,								
									error_info option(nullable) error ) 
{
	
	error_info ee = new error_info(true,true);
	number nom = nominal(ee);
	CORE_INT_FIXFLT.risk_ladder_disc_fixflt(this,this.pay_fix(), nom,f,df_v_pert, df_base, df_all, pv_diff_pert, pv_diff_all, y_shift,error );
}

/*-----------------------------------------------------------------------
  risk_ladder_fwd
  ----------------------------------------------------------------------*/
void  swap_fixflt.risk_ladder_fwd(	vector(fwd_func) 			f_v_pert,
									fwd_func 					f_base,
									fwd_func option(nullable) 	f_all,
									number 						y_shift,
									out vector(number) 			pv_diff_pert,
									out number 					pv_diff_all,								
									error_info option(nullable) error ) 
{
	
	error_info ee = new error_info(true,true);
	number nom = nominal(ee);
	CORE_INT_FIXFLT.risk_ladder_fwd_fixflt(this,this.pay_fix(), nom,f_v_pert, f_base, f_all, pv_diff_pert, pv_diff_all, y_shift, error );	
}

/*-----------------------------------------------------------------------
  pvdiff_curve_shift  
  f.d. pvbp_curve
  ----------------------------------------------------------------------*/
number  swap_fixflt.pvdiff_curve_shift(	number option(nullable) delta_disc_fix_leg, 
										number option(nullable) delta_disc_flt_leg,//not used for single ccy swaps	
										number option(nullable) delta_fwd,
										logical option(nullable) trade_date_pv,
										logical option(nullable) leg_indep_shift,
										out number pv,
										out number pvdiff_fix_leg,
										out number pvdiff_flt_leg,
										error_info option(nullable) error ) 
{	
	try{
		SWAP_ENTRY_FUNC();
			
		if(null(trade_date_pv))
			trade_date_pv = false;
		
		if(null(leg_indep_shift))
			leg_indep_shift = false;
		
		if(null(delta_disc_fix_leg))
			delta_disc_fix_leg = 0.0001;
		
		if(!ccy_swap_) {
			delta_disc_flt_leg = delta_disc_fix_leg;	
		}
		else if(null(delta_disc_flt_leg)) {
			delta_disc_flt_leg = 0.0001;
		}
		
		if(null(delta_fwd))
			delta_fwd = 0.0001;

		if(delta_disc_flt_leg>0 &&  delta_fwd > 0)
			QL_REQUIRE(CORE_INT.is_equal(delta_disc_flt_leg, delta_fwd),"the float leg disc and fwd rate shifts must be equal when different from zero");
		
		if(CORE_INT.is_equal_zero(delta_disc_fix_leg ) && CORE_INT.is_equal_zero(delta_disc_flt_leg ) && CORE_INT.is_equal_zero(delta_fwd ) ) {
			pvdiff_fix_leg = 0;
			pvdiff_flt_leg = 0;
			return 0;
		}

		logical break_if_set 		= true;
		logical allow_upd_ext_swap 	= true;
		
		disc_func df, dff, df_orig,dff_orig;
		tenor_surface ts, ts_orig;
		fwd_func fwdf;
		logical is_par_updated 		= update_to_par_int(break_if_set,allow_upd_ext_swap, df_orig, dff_orig, ts_orig, df, dff,fwdf, ts );
		//Note on is_par_updated: 	(1) if ccy_swap will return false but not throw --> all *_orig parameters will be updated	
		//							(2) will return false if all funcs are set (since break_if_set = true)
		//							(3) otherwise true or throw ex1. if one *_orig is null --> throw (since break_if_set = true)
												
		error_info ee = new error_info(true,true);

		number pv_fix,pv_flt;
		pv = present_value(pv_fix,pv_flt,trade_date_pv,ee);
		
		/* create new df and ts */
		//discflt
		disc_func df_delta = this.df_shifted_flt_leg(delta_disc_flt_leg,df);
		QL_FAIL_COND(null(df_delta), "error creating disc_func for float leg", this, true);

		//fwdflt
		tenor_surface ts_delta 	= this.fwd_shifted_flt_leg(delta_fwd,df_delta,ts);
		QL_FAIL_COND(null(ts_delta), "error creating tenor surface", this, true);
		
		//discfix
		disc_func df_delta_fix;
		if(ccy_swap_) {
			df_delta_fix = this.df_shifted_fix_leg(delta_disc_fix_leg,dff) ;
		}
		else if(leg_indep_shift) {
			if(!CORE_INT.is_equal(delta_disc_fix_leg,delta_disc_flt_leg))
				df_delta_fix = this.df_shifted_fix_leg(delta_disc_fix_leg,dff) ;
			else
				df_delta_fix = df_delta;
		}
		else {
			df_delta_fix = df_delta;
		}
		QL_FAIL_COND(null(df_delta_fix), "error creating disc_func for fix leg", this, true);
		

		//add
		if(!CORE_INT.is_equal_zero(delta_disc_fix_leg ) ) 
			this.add_disc_func_fix_leg(df_delta_fix);

		if(!CORE_INT.is_equal_zero(delta_disc_flt_leg ) ) 
			this.add_disc_func_flt_leg(df_delta);		
		
		if(!CORE_INT.is_equal_zero(delta_fwd )) 
			this.add_surface(ts_delta);	

		//calc new pv
		number pv_fix_delta,pv_flt_delta;
		number pv_delta = present_value(pv_fix_delta,pv_flt_delta,trade_date_pv,ee);
		pvdiff_fix_leg 	= pv_fix_delta - pv_fix; 
		pvdiff_flt_leg 	= pv_flt_delta - pv_flt;
		number pvdiff 	= pv_delta-pv;

		//clean up
		if(is_par_updated || !CORE_INT.is_equal_zero(delta_disc_fix_leg) ) 
			this.add_disc_func_fix_leg(dff_orig);

		if(is_par_updated || !CORE_INT.is_equal_zero(delta_disc_flt_leg ) ) 
			this.add_disc_func_flt_leg(df_orig);
				
		if(is_par_updated || !CORE_INT.is_equal_zero(delta_fwd )) 
			this.add_surface(ts_orig);	

		return pvdiff;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.pvdiff_curve_shift");
		pv = pvdiff_fix_leg =  pvdiff_flt_leg = null<number>;
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  pvdiff
  ----------------------------------------------------------------------*/
number  swap_fixflt.pvdiff(	fwd_func option(nullable) fwd_base, 
							fwd_func option(nullable) fwd_shift,
							disc_func option(nullable)	df_base_flt, 
							disc_func option(nullable)	df_shift_flt,
							disc_func option(nullable)	df_base_fix, //only for cross curr
							disc_func option(nullable)	df_shift_fix,//only for cross curr
							logical option(nullable) trade_date_pv,
							out number pv,
							out number pvdiff_fix_leg,
							out number pvdiff_flt_leg,
							error_info option(nullable) error ) 
{	
	try{	
		error_info ee = new error_info(true,true);

		QL_FAIL_COND(!null(fwd_shift) && null(fwd_base), "fwd_base required if fwd_shift is input", this, true);
		QL_FAIL_COND(!null(df_shift_flt) && null(df_base_flt), "df_base_flt required if df_shift_flt is input", this, true);
				
		if(!ccy_swap_) {
			QL_FAIL_COND(null(fwd_shift) && null(df_shift_flt), "fwd_shift and df_shift_flt cannot both be null", this, true);
			df_base_fix = df_shift_fix = null<disc_func>;
		}
		else {
			QL_FAIL_COND(!null(df_shift_fix) && null(df_base_fix), "df_base_fix required if df_shift_fix is input", this, true);
			QL_FAIL_COND(null(fwd_shift) && null(df_shift_flt) && null(df_shift_fix), "fwd_shift, df_shift_flt and df_shift_fix cannot all be null", this, true);
		}
		
		disc_func df_orig 		= this.disc_func_flt_leg(ee);
		disc_func dff_orig 		= this.disc_func_fix_leg(ee);
		tenor_surface ts_orig 	= this.tenor_surface_flt_leg(ee);

		//logical upd = false;

		if(!ccy_swap_ && null(dff_orig) && null(df_orig) && null(ts_orig)){//only update if all is null and not ccy swap
			disc_func df;
			fwd_func fwdf;
			this.implied_par_funcs(df,fwdf,null<number>,ee);//currently not for ccy swaps 
			tenor_surface ts 	= this.create_tenor_surface( df,fwdf);			
			QL_FAIL_COND(null(ts), "error creating tenor surface", this, true);

			this.add_data(this.nominal(),df,ts,null<vector(date)>,null<vector(number)>,null<logical>, false,false);
			//upd = true;
		}
		else {
			QL_FAIL_COND(null(dff_orig), "discount function for fixed leg not set", this, true);
			QL_FAIL_COND(null(df_orig), "discount function for float leg not set", this, true);
			QL_FAIL_COND(null(ts_orig), "tenor surface not set", this, true);
		}		
		
		if(null(df_base_flt)) {
			df_base_flt = this.disc_func_flt_leg(ee);
		}
		else {
			if(ccy_swap_)
				this.add_disc_func_flt_leg(df_base_flt);
			else
				this.add_disc_func(df_base_flt);
		}
		
		if(ccy_swap_ && !null(df_base_fix)) {
			this.add_disc_func_fix_leg(df_base_fix);
		}

		if(!null(fwd_base)) {
			tenor_surface ts_base 	= this.create_tenor_surface( df_base_flt,fwd_base);
			this.add_surface(ts_base);
		}

		//base
		number pv_fix,pv_flt;
		pv = present_value(pv_fix,pv_flt,trade_date_pv,ee);

		//shifted
		if(null(df_shift_flt)) {
			df_shift_flt = df_base_flt;
		}
		else {
			if(ccy_swap_)
				this.add_disc_func_flt_leg(df_shift_flt);
			else
				this.add_disc_func(df_shift_flt);
		}

		if(ccy_swap_ && !null(df_shift_fix)) {
			this.add_disc_func_fix_leg(df_shift_fix);
		}

		if(!null(fwd_shift)) {
			tenor_surface ts_base 	= this.create_tenor_surface( df_shift_flt,fwd_shift);
			this.add_surface(ts_base);
		}
						
		number pv_fix_delta,pv_flt_delta;
		number pv_delta = present_value(pv_fix_delta,pv_flt_delta,trade_date_pv,ee);
		pvdiff_fix_leg 	= pv_fix_delta - pv_fix; 
		pvdiff_flt_leg 	= pv_flt_delta - pv_flt;
		number pvdiff 	= pv_delta-pv;

		//clean up
		//if(upd) { 
			this.add_disc_func_fix_leg(dff_orig);
			this.add_disc_func_flt_leg(df_orig);			
			this.add_surface(ts_orig);
		//}

		return pvdiff;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.pvdiff");
		pv = pvdiff_fix_leg =  pvdiff_flt_leg = null<number>;
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  pvdiff_fix_rate	EXT SWAP: ok
  compared to pv01 this is a plain diff without scaling and handling of the sign of the result
  ----------------------------------------------------------------------*/
number  swap_fixflt.pvdiff_fix_rate(	number 	delta_fix_cpn_rate,									
										disc_func option(nullable) df,
										error_info option(nullable) error ) 
{
	return swap_gen.pvdiff_fix_rate(delta_fix_cpn_rate,	df, error ) ;
}

/*-----------------------------------------------------------------------
  dv01
  DV01 refers to dollar value of 1 basis point and it's the change in value of the npv
  of the instrument with a change of 1 basis point in the curve(s).
  This version has no knowledge of the underlying instruments and therefore the shifts
  are calculated directly from the fwd_func and disc_func
  (fwd_func --> shift of fwd rates)
  (disc_func --> shift of fwd rates calculated from the disc_func)
  ----------------------------------------------------------------------*/
number  swap_fixflt.dv01(	number option(nullable) delta, 
							logical option(nullable) trade_date_pv,
							error_info option(nullable) error ) 
{
	if(null(delta))
		delta = 0.0001;

	logical leg_indep_shift = false;
		
	number pv,pvdiff_fix, pvdiff_flt;

	number pvdiff = pvdiff_curve_shift(	delta, delta, delta,
										trade_date_pv, leg_indep_shift,pv, pvdiff_fix,
										pvdiff_flt, error );

	
	//number pvdiff = pvdiff_curve_shift(delta, delta, trade_date_pv,error ) ;	
	return pvdiff / delta / 10000.0;
}
/*-----------------------------------------------------------------------
  dv01_disc
  This version has no knowledge of the underlying instruments (see above)
  ----------------------------------------------------------------------*/
number  swap_fixflt.dv01_disc(	number option(nullable) delta, 
								logical option(nullable) trade_date_pv,
								error_info option(nullable) error ) 
{
	if(null(delta))
		delta = 0.0001;
	//number pvdiff = pvdiff_curve_shift(delta,0, trade_date_pv,error ) ;

	logical leg_indep_shift = false;
		
	number pv,pvdiff_fix, pvdiff_flt;

	number pvdiff = pvdiff_curve_shift(	delta, delta, 0,
										trade_date_pv, leg_indep_shift,pv, pvdiff_fix,
										pvdiff_flt, error );
	
	return pvdiff / delta / 10000.0;
	
}

/*-----------------------------------------------------------------------
  dv01_fwd
   This version has no knowledge of the underlying instruments (see above)
  ----------------------------------------------------------------------*/
number  swap_fixflt.dv01_fwd(	number option(nullable) delta, 
								logical option(nullable) trade_date_pv,
								error_info option(nullable) error ) 
{
	if(null(delta))
		delta = 0.0001;

	logical leg_indep_shift = false;
		
	number pv,pvdiff_fix, pvdiff_flt;
	
	//number pvdiff = pvdiff_curve_shift(0, delta,trade_date_pv,error ) ;

	number pvdiff = pvdiff_curve_shift(	0, 0, delta,
										trade_date_pv, leg_indep_shift,pv, pvdiff_fix,
										pvdiff_flt, error );
	
	return pvdiff / delta / 10000.0;
	
}


/*-----------------------------------------------------------------------
  dv01
  This version has the fwd_funcs and disc_funcs as input. These can be calculated from shifting
  the underlying instruments in the curve
  ----------------------------------------------------------------------*/
number  swap_fixflt.dv01(	fwd_func option(nullable) fwd_base, 
							fwd_func option(nullable) fwd_shift,
							disc_func option(nullable) df_base_flt,
							disc_func option(nullable) df_shift_flt,
							disc_func option(nullable) df_base_fix, 
							disc_func option(nullable) df_shift_fix,								
							number 		r_shift,
							error_info option(nullable) error ) 
{
	number pv,pvdiff_fix_leg,pvdiff_flt_leg;
	number pvd = pvdiff(fwd_base,fwd_shift,df_base_flt,df_shift_flt,df_base_fix,df_shift_fix,
						false,pv,pvdiff_fix_leg,pvdiff_flt_leg,error ) ;
	return pvd / r_shift / 10000.0;
	
}

/*-----------------------------------------------------------------------
  dv01_fwd
  ----------------------------------------------------------------------*/
number  swap_fixflt.dv01_fwd(	fwd_func	fwd_base, 
								fwd_func	fwd_shift,
								number 		r_shift,
								error_info option(nullable) error ) 
{
	number pv,pvdiff_fix_leg,pvdiff_flt_leg;
	number pvd = pvdiff(fwd_base,fwd_shift,null<disc_func>,null<disc_func>,null<disc_func>,null<disc_func>,
						false,pv,pvdiff_fix_leg,pvdiff_flt_leg,error ) ;
	return pvd / r_shift / 10000.0;	
}

/*-----------------------------------------------------------------------
  dv01_disc
  ----------------------------------------------------------------------*/
number  swap_fixflt.dv01_disc(	disc_func	df_base_flt, 
								disc_func	df_shift_flt,
								number 		r_shift,
								error_info option(nullable) error ) 
{
	number pv,pvdiff_fix_leg,pvdiff_flt_leg;
	number pvd = pvdiff(null<fwd_func>,null<fwd_func>,df_base_flt,df_shift_flt,null<disc_func>,null<disc_func>,
						false,pv,pvdiff_fix_leg,pvdiff_flt_leg,error ) ;
	return pvd / r_shift / 10000.0;
	
}
/*-----------------------------------------------------------------------
  dv01_disc
  ----------------------------------------------------------------------*/
number  swap_fixflt.dv01_disc(	disc_func option(nullable) df_base_flt, 
								disc_func option(nullable) df_shift_flt,
								disc_func df_base_fix, 
								disc_func df_shift_fix,								
								number 		r_shift,
								error_info option(nullable) error ) 
{
	number pv,pvdiff_fix_leg,pvdiff_flt_leg;
	number pvd = pvdiff(null<fwd_func>,null<fwd_func>,df_base_flt,df_shift_flt,df_base_fix,df_shift_fix,
						false,pv,pvdiff_fix_leg,pvdiff_flt_leg,error ) ;
	return pvd / r_shift / 10000.0;
	
}

/*-----------------------------------------------------------------------
  delta_risk
  ----------------------------------------------------------------------*/
/*number  swap_fixflt.delta_risk(	logical 					incl_disc,
								number option(nullable) 	delta,								
								logical option(nullable) 	trade_date_pv,
								error_info option(nullable) error ) 
{
	number delta_disc = incl_disc ? delta: 0;	
	number pvdiff = delta_pvdiff(delta_disc, delta, trade_date_pv,error ) ;
	
	return pvdiff / delta / 10000.0;
	
}*/


/*-----------------------------------------------------------------------
  gamma_risk
  ----------------------------------------------------------------------*/
number  swap_fixflt.gamma_risk(	number option(nullable) 	delta, 
								logical option(nullable) 	trade_date_pv,
								error_info option(nullable) error ) 
{		
	if(null(delta) )
		delta = 0.0001;
	
	number delta_disc = delta;
	
	if(null(trade_date_pv))
		trade_date_pv = false;

	logical leg_indep_shift = false;
	
	number pv_x,pvdiff_fix, pvdiff_flt;

	number pvdiffup 	= pvdiff_curve_shift(delta_disc, delta_disc, delta,
										trade_date_pv, leg_indep_shift,pv_x, pvdiff_fix,
										pvdiff_flt, error );
	number pv_x_up 		= pvdiffup + pv_x;
	
	number pvdiffdown 	= pvdiff_curve_shift(-delta_disc, -delta_disc, -delta,
										trade_date_pv, leg_indep_shift,pv_x, pvdiff_fix,
										pvdiff_flt, error );

	number pv_x_down 	= pvdiffdown + pv_x;
	//number dup 		= delta_risk(	delta, trade_date_pv,error );
	//number ddown 	= delta_risk(	-delta, trade_date_pv,error );
	
	//return -(ddown-dup);

	number g = CORE_INT.num2der(pv_x,pv_x_up,pv_x_down,delta*10000.0) ;
	return g;
}
/*-----------------------------------------------------------------------
  gamma_risk
  ----------------------------------------------------------------------*/
number  swap_fixflt.gamma_risk_disc(number option(nullable) 	delta, 
									logical option(nullable) 	trade_date_pv,
									error_info option(nullable) error ) 
{		
	if(null(delta) )
		delta = 0.0001;
	
	if(null(trade_date_pv))
		trade_date_pv = false;

	logical leg_indep_shift = false;
	
	number pv_x,pvdiff_fix, pvdiff_flt;

	number pvdiffup 	= pvdiff_curve_shift(delta, delta, 0,
										trade_date_pv, leg_indep_shift,pv_x, pvdiff_fix,
										pvdiff_flt, error );
	number pv_x_up 		= pvdiffup + pv_x;
	
	number pvdiffdown 	= pvdiff_curve_shift(-delta, -delta, 0,
										trade_date_pv, leg_indep_shift,pv_x, pvdiff_fix,
										pvdiff_flt, error );

	number pv_x_down 	= pvdiffdown + pv_x;
	//number dup 		= delta_risk(	delta, trade_date_pv,error );
	//number ddown 	= delta_risk(	-delta, trade_date_pv,error );
	
	//return -(ddown-dup);

	number g = CORE_INT.num2der(pv_x,pv_x_up,pv_x_down,delta*10000.0) ;
	return g;
}

/*-----------------------------------------------------------------------
  gamma_risk_fwd
  ----------------------------------------------------------------------*/
number  swap_fixflt.gamma_risk_fwd(	number option(nullable) 	delta, 
									logical option(nullable) 	trade_date_pv,
									error_info option(nullable) error ) 
{		
	if(null(delta) )
		delta = 0.0001;
	
	if(null(trade_date_pv))
		trade_date_pv = false;

	logical leg_indep_shift = false;
	
	number pv_x,pvdiff_fix, pvdiff_flt;

	number pvdiffup 	= pvdiff_curve_shift(0, 0, delta, trade_date_pv, leg_indep_shift,pv_x, pvdiff_fix,
										pvdiff_flt, error );
	number pv_x_up 		= pvdiffup + pv_x;
	
	number pvdiffdown 	= pvdiff_curve_shift(0, 0, -delta, trade_date_pv, leg_indep_shift,pv_x, pvdiff_fix,
										pvdiff_flt, error );

	number pv_x_down 	= pvdiffdown + pv_x;
	//number dup 		= delta_risk(	delta, trade_date_pv,error );
	//number ddown 	= delta_risk(	-delta, trade_date_pv,error );
	
	//return -(ddown-dup);

	number g = CORE_INT.num2der(pv_x,pv_x_up,pv_x_down,delta*10000.0) ;
	return g;
}



/*-----------------------------------------------------------------------
  pv01	EXT SWAP: ok  - always returns a positive number regardless of pay/receive and sign of notional
  Note: not a "true" measure of risk, this version also takes into account if the swap has a pv <> 0
  
if sign is needed:
 receive fix --> negative sign
  ----------------------------------------------------------------------*/
number  swap_fixflt.pv01_ext(number option(nullable) notional,
							number option(nullable) delta,
							//logical option(nullable) trade_date_pv,
							disc_func option(nullable) df,
							out number pv01_mkt,
							out number pv01_pv,
							error_info option(nullable) error ) 
{	
	try{
		error_info ee 		= new error_info(true,true);
		
		instr_error_type t;
   		string 			s;	

		logical is_par_updated = false;

		disc_func df_flt_orig,df_fix_orig;
		tenor_surface ts_orig;
		
		if(!ccy_swap_) {					
			disc_func df_tmp;				
			fwd_func flt_fwd_func;
			tenor_surface ts;			
			is_par_updated = update_to_par_int(true, true,df_flt_orig, df_fix_orig, ts_orig, df, df_tmp, flt_fwd_func, ts );			
		}
						
		disc_func df_orig 	= this.disc_func_fix_leg(ee);
		logical upd 		= false;
		
		if(!null(df)){
			this.add_disc_func_fix_leg(df);
			upd = true;
		}
		else if(null(df_orig)) {	
			disc_func _df = this.implied_par_disc_func_fix_leg(ee);
			this.add_disc_func_fix_leg(_df);
			upd = true;
		}
		
		pv01_mkt = i().__swap_pvbp_fix_leg(notional,delta, true,t, s);
		if(!null(pv01_mkt))
			pv01_mkt = abs(pv01_mkt);
		

		pv01_pv = 0;
		number pvfix,pvflt;
		number pv 			= this.present_value(pvfix,pvflt,false,ee);
					
		if(!CORE_INT.is_equal_zero(pv)) {

			if(this.pay_fix(ee))
				pv *= -1;
			
			if(!null(notional)){
				number n_fix,n_flt;
				this.notional(n_fix,n_flt,ee);
				if(!CORE_INT.is_equal(notional, n_fix)){
					pv = pv * notional/n_fix;
				}
			}
			disc_func df_curr 	= this.disc_func_fix_leg(ee);
			vector(date) pmt_dates = this.fix_leg(false,ee).ir_payment_dates();
			
			day_count_method fixdc,fltdc;
			this.dc_method(fixdc,fltdc,ee);
			number ad;
			number a = swap_annuity(this.trade_date(ee),this.settle_date(ee),df_curr,pmt_dates,fixdc,delta,ad);				
			number cf = pv/abs(a);
			number pv_shift = cf*abs(ad);
			pv01_pv = pv - pv_shift;//pv > 0 --> pv_diff > 0
		}
		
		if(is_par_updated) {
			add_curve_data(df_fix_orig,df_flt_orig,ts_orig );
		}
		else if(upd && !null(df_orig)){			
			this.add_disc_func_fix_leg(df_orig);
		}
		
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fixflt.pv01_ext");	
		if(e) { 
			pv01_mkt = pv01_pv = null<number>;
			return null<number>;
		}
		return pv01_mkt+pv01_pv;
	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.pv01_ext");
		pv01_mkt = pv01_pv = null<number>;
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  pv01	EXT SWAP: ok  - always returns a positive number regardless of pay/receive and sign of notional
  Note: not a "true" measure of risk, does not take into account if the swap has a pv <> 0
   PV01 refers to present value of 1 basis point and it's the discounted value of the cashflows
  for a rate of 0.01% for all periods of a particular instrument, ie, the npv of the fixed leg with a rate of 0.01%

if sign is needed:
 receive fix --> negative sign
  ----------------------------------------------------------------------*/
number  swap_fixflt.pv01(	number option(nullable) notional,
							number option(nullable) delta,
							//logical option(nullable) trade_date_pv,
							disc_func option(nullable) df,
							error_info option(nullable) error ) 
{
	return swap_gen.pv01_fix_leg(notional,delta,df,error);
}

/*-----------------------------------------------------------------------
  pv01_spread	EXT SWAP: ok  - always returns a positive number regardless of pay/receive and sign of notional
  Note: not a "true" measure of risk, does not take into account if the swap has a pv <> 0
   PV01 refers to present value of 1 basis point spread and it's the discounted value of the cashflows
  for a float rate of 0.01% 
  ----------------------------------------------------------------------*/
number  swap_fixflt.pv01_spread(number option(nullable) notional,
								number option(nullable) delta,
								//logical option(nullable) trade_date_pv,
								disc_func option(nullable) df,
								error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	

		error_info ee 		= new error_info(true,true);
		disc_func df_orig 	= this.disc_func_flt_leg(ee);
		logical upd 		= false;
		
		if(!null(df)){
			this.add_disc_func_flt_leg(df);
			upd = true;
		}
		else if(null(df_orig)) {	
			QL_FAIL("discount function not set",this,true);
		}
		
		number c = i().__swap_pvbp_float_leg(notional,delta, false,t, s);
		if(!null(c))
			c = abs(c);
		
		if(upd && !null(df_orig))
			this.add_disc_func_flt_leg(df_orig);		

		logical e = CORE_INT.add_error_info(error,t,s, "swap_fixflt.pv01_spread");	
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.pv01_spread");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  spreadbp_to_fixbp	EXT SWAP: ok 
  ----------------------------------------------------------------------*/
number  swap_fixflt.spreadbp_to_fixbp(	error_info option(nullable) error ) 
{
	try {
		error_info ee = new error_info(true,true);
		number  pv01s = this.pv01_spread(100,0.0001,null,ee) ;
		number  pv01f = this.pv01(100,0.0001,null,ee) ;
		return pv01s / pv01f;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.spreadbp_to_fixbp");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  pvbp	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fixflt.pvbp(	number option(nullable) notional,
							number option(nullable) delta,
							logical option(nullable) centered,
							logical option(nullable) disable_rounding,	
							error_info option(nullable) error ) 
{
	try {
		error_info ee = new error_info(true,true);
		number pv01_ = this.pv01(notional,delta,null<disc_func>,ee); //always positive
		if(!null(notional) && notional < 0)
			return -pv01_;
		else
			return pv01_;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.pvbp");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  pvbp	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fixflt.pvbp(	number 	option(nullable) notional,
							number  option(nullable) delta,																																		
							error_info option(nullable) error ) 
{	
	try{
		error_info ee = new error_info(true,true);
		number pv01_ = this.pv01(notional,delta, null<disc_func>,ee);//always positive
		if(!null(notional) && notional < 0)
			return -pv01_;
		else
			return pv01_;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.pvbp");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  implied_par_funcs		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixflt.implied_par_funcs(	out disc_func  	df,
									out fwd_func 	fwdf,
									number option(nullable) 		first_flt_fixing,
									error_info option(nullable) 	error )
{
	try{		
		QL_FAIL_COND(ccy_swap_,"inapplicable function call for cross currency swaps", this,true);
		
		error_info ee = new error_info(true,true);

		number s = this.spread_flt_leg(ee) ;
		QL_FAIL_COND(!CORE_INT.is_equal_zero(s),"error creating implied par disc_func (non zero spread)", this,true);
		
		df = implied_par_disc_func_fix_leg(ee );

		vector(date) dates;
		vector(number) amounts;
		vector(date)	float_idx0, float_pmt;
		vector(number)	float_dt;			
		logical ok = this.cash_flows_fwd_bootstrap(dates,amounts, first_flt_fixing,float_idx0,float_pmt,float_dt,ee) ;
		QL_FAIL_COND(!ok,"error creating bootstrap cashflows (fwd)", this,true);

		cashflows_fwd cf = cashflows_fwd(this.trade_date(), dates, amounts, float_idx0, float_pmt, float_dt);
		QL_FAIL_COND(null(cf),"error creating cash flows", this,true);	
		
		fwdf = bootstrap_fwd(cf, df, ip_linear());
		QL_FAIL_COND(null(fwdf ),"error creating fwd_func", this,true);	
		
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.implied_par_funcs");
		df 		= null<disc_func>;
		fwdf 	= null<fwd_func>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  swap_fixflt: ir_index_flt_leg		EXT SWAP: ok
  ----------------------------------------------------------------------*/
ir_index swap_fixflt.ir_index_flt_leg(error_info option(nullable) error )
{
	return swap_gen.swap_ir_index_leg2(error);
}
/*-----------------------------------------------------------------------
  swap_fixflt: ir_index		EXT SWAP: ok
  ----------------------------------------------------------------------*/
ir_index swap_fixflt.ir_index(error_info option(nullable) error ) option(hidden)
{

	return swap_gen.swap_ir_index_leg2(error);
}
/*-----------------------------------------------------------------------
  index_tenor_flt_leg		EXT SWAP: ok
  ----------------------------------------------------------------------*/
string swap_fixflt.index_tenor_flt_leg(error_info option(nullable) error ) 
{

	return swap_gen.swap_index_tenor_leg2(error);
}

/*-----------------------------------------------------------------------
  index_tenor_code_flt_leg		EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_code swap_fixflt.index_tenor_code_flt_leg(error_info option(nullable) error ) 
{

	return swap_gen.swap_index_tenor_code_leg2(error);
}

/*-----------------------------------------------------------------------
  swap_fixflt: disc_func_fix_leg / disc_func_flt_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
disc_func swap_fixflt.disc_func_fix_leg(error_info option(nullable) error ) 	{ return swap_gen.disc_func_leg1(error);}
disc_func swap_fixflt.disc_func_flt_leg(error_info option(nullable) error ) 	{ return swap_gen.disc_func_leg2(error);}
/*-----------------------------------------------------------------------
  tenor_surface_flt_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_fixflt.tenor_surface_flt_leg(error_info option(nullable) error ) 	{ return swap_gen.swap_tenor_surface_leg2(error);}


logical DEBUG_FIXFLT option(constant) = false;

/*-----------------------------------------------------------------------
  swap_fixflt: upfront_carry		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixflt.upfront_carry(	out date 	fwd_trade_date,
								out date 	fwd_settle_date,
								out number 	carry_pv,
								out number 	carry,
								out number 	carry_pv_ai_adj,
								out number 	carry_ai_adj,
								error_info option(nullable) error )

{	
	
	try {
		error_info ee = new error_info(true,true);
		logical roll_compat = false;
		CORE_INT_FIXFLT.fwd_date_adjust(fwd_trade_date,fwd_settle_date,this.swap_gen.calendar(ee), date_code(this.settle_code(ee)));					
		carry_result res = new carry_result;
		swap_gen.swap_upfront_carry(fwd_trade_date,fwd_settle_date,roll_compat,res,ee);

		carry_pv 				= res.carry_pv;//carry_spot_fix_leg + carry_spot_flt_leg;
		carry 					= res.carry;//carry_fwd_fix_leg + carry_fwd_flt_leg - npv_spot_ir_cost;
		carry_pv_ai_adj 		= res.carry_pv_ai_adj;//carry_spot_ai_fix_leg + carry_spot_ai_flt_leg;	
		carry_ai_adj 			= res.carry_ai_adj;//carry_fwd_ai_fix_leg + carry_fwd_ai_flt_leg - npv_spot_ir_cost;
		
		return ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.carry");
		carry_pv  =  carry  =  null<number>;
		carry_pv_ai_adj = carry_ai_adj =  null<number>;

		return ;
	}
}
/*-----------------------------------------------------------------------
  swap_fixflt: upfront_carry		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixflt.upfront_carry(	out date 			fwd_trade_date,
								out date 			fwd_settle_date,							
								out carry_result	res,
								logical 			roll_compat ,
								error_info option(nullable) error)
{
	try {
		error_info ee = new error_info(true,true);
		CORE_INT_FIXFLT.fwd_date_adjust(fwd_trade_date,fwd_settle_date,this.swap_gen.calendar(ee), date_code(this.settle_code(ee)));					
		
		swap_gen.swap_upfront_carry(fwd_trade_date,fwd_settle_date,roll_compat,res,ee);

		//checking only from here
		if(!DEBUG_FIXFLT)
			return;
		
		number c 			= res.reinv_irim_cf + res.pvadj_ai_fwd;
		number check 		= res.carry_ai_adj - c ;
		if(!CORE_INT.is_equal_zero(check/10000))
			QL_WARNING("carrycheck failed (fwd)");

		disc_func df 		= this.disc_func_fix_leg(ee);
		number df_f 		= df.disc((fwd_settle_date-this.trade_date(ee))/365.0);
		number df_s 		= df.disc((this.settle_date(ee)-this.trade_date(ee))/365.0);

		number pv_reinv_irim_cf = res.reinv_irim_cf * df_f/df_s;
		number pv_ai_spot	= res.pvadj_ai_fwd * df_f/df_s;
		c 					= pv_reinv_irim_cf + pv_ai_spot;
		check 				= res.carry_pv_ai_adj - c;
		if(!CORE_INT.is_equal_zero(check/10000))
			QL_WARNING("carrycheck failed (spot)");
		
		return ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.upfront_carry");
		fwd_trade_date = fwd_settle_date = null;
		res =  null;
		return ;
	}
}


/*-----------------------------------------------------------------------
  swap_fixflt: upfront_rolldown		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixflt.upfront_rolldown(	out date 	fwd_trade_date,
									out date 	fwd_settle_date,							
									out rolldown_result res,
									logical incl_reinv_in_roll,
									error_info option(nullable) error)
{
	try {
		error_info ee = new error_info(true,true);
		CORE_INT_FIXFLT.fwd_date_adjust(fwd_trade_date,fwd_settle_date,this.swap_gen.calendar(ee), date_code(this.settle_code(ee)));
		swap_gen.swap_upfront_rolldown(fwd_trade_date,fwd_settle_date,incl_reinv_in_roll,res,ee);
		
		return ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.upfront_rolldown");
		fwd_trade_date = fwd_settle_date = null;
		res =  null;
		return ;
	}
}

/*-----------------------------------------------------------------------
  swap_fixflt: upfront_rolldown		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixflt.upfront_rolldown(	out date 	fwd_trade_date,
									out date 	fwd_settle_date,
									out number 	roll_pv,
									out number 	roll,
									out number 	roll_pv_ai_adj,
									out number 	roll_ai_adj,	
									error_info option(nullable) error )
{	

	
	try {
		logical incl_reinv_in_roll = false;
		rolldown_result res = new rolldown_result;
		error_info ee = new error_info(true,true);
		swap_gen.swap_upfront_rolldown(fwd_trade_date, fwd_settle_date, incl_reinv_in_roll,res,  ee);	
		roll_pv 				= res.roll_pv;
		roll 					= res.roll;		
		roll_pv_ai_adj 			= res.roll_pv_ai_adj;
		roll_ai_adj 			= res.roll_ai_adj;

		
		return ;

	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.upfront_rolldown");
		roll_pv  =  roll  = null<number>;
		roll_pv_ai_adj = roll_ai_adj =  null<number>;
		return ;
	}
}


/*-----------------------------------------------------------------------
  swap_fixflt: upfront_carryroll		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixflt.upfront_carryroll(	out date 	fwd_trade_date,
									out date 	fwd_settle_date,
									out number 	carry_roll,
									out number 	roll,//==roll_fwd_ai_adj
									out number  carry_implied,
									out logical ai_adjusted,
									error_info option(nullable) error )
{
	try {
		logical incl_reinv_in_roll = false;
		rolldown_result res = new rolldown_result;
		error_info ee 		= new error_info(true,true);
		swap_gen.swap_upfront_rolldown(fwd_trade_date, fwd_settle_date, incl_reinv_in_roll,res,  ee);

		number _roll 			= res.roll;//roll_fwd_fix_leg+roll_fwd_flt_leg+npv_spot_ir_cost;
		roll 					= res.roll_ai_adj;//roll_fwd_ai_fix_leg+roll_fwd_ai_flt_leg+npv_spot_ir_cost;
		ai_adjusted				= !CORE_INT.is_equal(roll , _roll);
				
		//number npv_spot 		= npv_spot_fix_leg+npv_spot_flt_leg;
		//number npv_fwd 			= npv_fwd_fix_leg+npv_fwd_flt_leg;
		//number reinv_irim_cf 	= reinv_irim_cf_fix_leg + reinv_irim_cf_flt_leg;
		//number carry_roll_test;
		//carry_roll_test 		= (npv_fwd-npv_spot)+reinv_irim_cf;
		//number pv_ai_fwd		= pvadj_ai_fwd_fix_leg + pvadj_ai_fwd_flt_leg;
		//number carry_roll_adj_test;
		//carry_roll_adj_test 	= reinv_irim_cf + pv_ai_fwd;//carry_roll-roll

		carry_roll 				= res.carry_roll;//carry_roll_fwd_fix_leg + carry_roll_fwd_flt_leg + npv_spot_ir_cost;
		carry_implied 			= res.carry_implied;//imp_carry_fwd_fix_leg + imp_carry_fwd_flt_leg;
		//carry_roll_adj: because carry and roll are not additive in the case when we have passed the fixing of the float leg
		//i.e. the assumptions behind future fixings are different (unchanged curve vs realized fwds)
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.upfront_carryroll");
		
		carry_roll = roll = carry_implied =  null<number>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  solver   EXT SWAP: ok
  ----------------------------------------------------------------------*/
number swap_fixflt.solver(	number 				swap_pv,
							swap_solver_code 	solver_code,
							logical option(nullable) trade_date_pv,
							error_info option(nullable) error )
{

	return swap_gen.solver(swap_pv,solver_code,trade_date_pv,error);
}

/*-----------------------------------------------------------------------
  imp_rate_fix_leg    EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fixflt.imp_rate_fix_leg(	number 							swap_pv,							
										logical option(nullable) 		trade_date_pv,
										error_info option(nullable) 	error ) 
{
	return swap_gen.imp_rate_fix_leg(swap_pv,trade_date_pv,error);
	
	/*try{
		
		instr_error_type t;
   		string 			s;	
		number c = i().__swap_imp_fix_rate(swap_pv,trade_date_pv,true,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fixflt.imp_rate_fix_leg");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.imp_rate_fix_leg");
		return null<number>;
	}*/
}

/*-----------------------------------------------------------------------
  imp_spread_flt_leg    EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fixflt.imp_spread_flt_leg(	number 						swap_pv,							
										logical option(nullable) 	trade_date_pv,
										error_info option(nullable) error ) 
{	
	try{
		
		instr_error_type t;
   		string 			s;	
		number c = i().__swap_imp_flt_sprd(swap_pv,trade_date_pv,false,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fixflt.imp_spread_flt_leg");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.imp_spread_flt_leg");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  reset_ladder_flt_leg    EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.reset_ladder_flt_leg(	out vector(date) reset_date,
										out vector(number) pv_diff,
										error_info option(nullable) error ) 
{	
	try{
		error_info ee = new error_info(true,true);
		ql_float_leg flt = float_leg(false,ee );
		number pv_no_fx;
		vector(number) pv_pert;
		number r_shift = 0.0001;
		flt.reset_ladder(r_shift, pv_no_fx,reset_date, pv_pert);
		pv_diff = pv_pert;
		pv_diff -= -pv_no_fx;
		return ;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.reset_ladder_flt_leg");
		return ;
	}
}
/*-----------------------------------------------------------------------
  swap_instrument   EXT SWAP: ok
  ----------------------------------------------------------------------*/
ql_fixed_income_swap swap_fixflt.swap_instrument(error_info option(nullable) error )
{
	
	return swap_gen.swap_instrument(error);
}

/*-----------------------------------------------------------------------
  swap_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
vector(ql_swap_leg) swap_fixflt.legs(logical clone,error_info option(nullable) error )
{

	return swap_gen.swap_leg(clone,error);
}

/*-----------------------------------------------------------------------
  float_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
ql_float_leg swap_fixflt.float_leg(logical clone,error_info option(nullable) error )
{
	
	vector(ql_float_leg) l = swap_gen.swap_float_leg(clone,error);
	return !null(l) ? l[0] : null<ql_float_leg>;
}

/*-----------------------------------------------------------------------
  fix_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
ql_fix_leg swap_fixflt.fix_leg(logical clone,error_info option(nullable) error )
{
	return swap_gen.fix_leg1(clone,error);	
}

/*-----------------------------------------------------------------------
  get_legs	EXT SWAP: ok  prot
  ----------------------------------------------------------------------*/
void  swap_fixflt.get_legs(	out ql_fix_leg  leg1, 
							out ql_float_leg  leg2) 
{	
	leg1 = fix_leg(false);
	leg2 = float_leg(false);
}


/*-----------------------------------------------------------------------
  is_cross_currency
  ----------------------------------------------------------------------*/
logical	 swap_fixflt.is_cross_currency(error_info option(nullable) error )
{
	try{
		QL_FAIL_COND(null(ccy_swap_),"init error");
		return ccy_swap_;	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.is_cross_currency");
		return null<logical>;
	}
}
/*-----------------------------------------------------------------------
  is_par_flat (must be par, have flat floatleg, non-aged, ...)  EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical	 swap_fixflt.is_par_flat(error_info option(nullable) error )
{
	try{
				
		if(!ext_swap_)
			return true;

		error_info ee = new error_info(true,true);
		
		QL_FAIL_COND(is_amortizing(ee),"function not applicable for amortizing swaps",this,true );
				
		if(this.settle_date(ee) != this.issue_date(ee))
			return false;

		number quote_flt_leg = this.spread_flt_leg(ee);
	
		if(null(quote_flt_leg))
			return false;
		
		if(!CORE_INT.is_equal_zero(quote_flt_leg ))
			return false;
				
		number pv1,pv2;
		number pv = this.present_value(pv1,pv2,false,ee);
		
		if(null(pv))
			return false;

		number fixn,fltn;
		notional(fixn,fltn,ee);
		if(!CORE_INT.is_equal_zero(pv, CORE_INT.EPSILON*abs(fixn) ))
			return false;				

		return true;
	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.is_par_flat");
		return null<logical>;
	}
}

/*-----------------------------------------------------------------------
  present_value
  ----------------------------------------------------------------------*/
number swap_fixflt.present_value(	disc_func option(nullable)	disc_func_fix_leg,
									disc_func option(nullable) 	disc_func_flt_leg,
									out number  pv_fix_leg,
									out number  pv_flt_leg,
									number option(nullable) 	notional,
									logical option(nullable) 	trade_date_pv,																								
									error_info option(nullable) error )
{

	return swap_gen.present_value(disc_func_fix_leg,disc_func_flt_leg,pv_fix_leg,pv_flt_leg,notional,trade_date_pv,error);
}

/*-----------------------------------------------------------------------
  present_value
  ----------------------------------------------------------------------*/
number swap_fixflt.present_value(	disc_func option(nullable)	disc_func_fix_leg,
									disc_func option(nullable) 	disc_func_flt_leg,
									out number  				pv_fix_leg,
									out number  				pv_flt_leg,
									date option(nullable) 		pv_date,
									date option(nullable) 		settle_date,
									logical  					incl_issue_cf,
									logical  					incl_mat_cf,	
									error_info option(nullable) error )
{

	return swap_gen.present_value(disc_func_fix_leg,disc_func_flt_leg,pv_fix_leg,pv_flt_leg,pv_date, settle_date ,incl_issue_cf,incl_mat_cf,error );
}


number swap_fixflt.present_value(	out number  pv_fix_leg,
									out number  pv_flt_leg,
									logical option(nullable) 	trade_date_pv,	
									error_info option(nullable) error )
{

	return swap_gen.present_value(pv_fix_leg,pv_flt_leg,trade_date_pv ,error );
}

/*-----------------------------------------------------------------------
  present_value_fee
  ----------------------------------------------------------------------*/
number swap_fixflt.present_value_fee(disc_func option(nullable)	disc_func_fix_leg,
									disc_func option(nullable) 	disc_func_flt_leg,
									out number  pv_fee_fix_leg,
									out number  pv_fee_flt_leg,
									date option(nullable) 		pv_date,
									date option(nullable) 		settle_date,
									logical  					incl_issue_cf,
									logical  					incl_mat_cf,	
									error_info option(nullable) error )
{
	return swap_gen.present_value_fee(disc_func_fix_leg,disc_func_flt_leg,pv_fee_fix_leg,pv_fee_flt_leg,pv_date, settle_date ,incl_issue_cf,incl_mat_cf,error );
}



/*-----------------------------------------------------------------------
  fix_leg_y_to_pv
  ----------------------------------------------------------------------*/
/*number  swap_fixflt.fix_leg_y_to_pv(number option(nullable)	yield,
									logical 				in_pcnt,
									error_info option(nullable) error ) 
{	
	return instrument.fix_leg_y_to_pv(yield, in_pcnt, error);
}

/*-----------------------------------------------------------------------
  swap_fixflt: yield,  for backward compat reasons
  ----------------------------------------------------------------------*/
number  swap_fixflt.yield(	logical 	disable_rounding,
							error_info option(nullable) error )  option(hidden)
{ 
	try {
		//QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);
		error_info ee 	= new error_info(true,true);
		
		number cpnr 	= this.coupon_fix_leg(ee);
		
		if(!ext_swap_) {
			number y = instrument.yield(false,ee);
			if(CORE_INT.is_equal(cpnr,y))
				return y;
			else
				QL_FAIL("yield for non-par swaps not supported");
		}
			
		disc_func df 	= this.disc_func_fix_leg(ee);
		if(null(df)) {
			return this.coupon_rate(ee);
		}
		else {
			number y = swap_gen.yield(df, false , ee );
			if(CORE_INT.is_equal(cpnr,y))
				return y;
			else
				QL_FAIL("yield for non-par swaps not supported");
		}
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.yield");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  swap_fixflt: yield,  for backward compat reasons
  ----------------------------------------------------------------------*/
number  swap_fixflt.yield(	disc_func		disc_func,
							logical 		disable_rounding ,								
							error_info option(nullable) error ) option(hidden)
{
	return swap_gen.yield(	disc_func, disable_rounding , error );
}
/*-----------------------------------------------------------------------
   par_rate_fix_leg
  ----------------------------------------------------------------------*/
number  swap_fixflt.par_rate_fix_leg(	disc_func		disc_func,
										error_info option(nullable) error)
{
	return swap_gen.par_rate_fix_leg(disc_func,error);
}

/*-----------------------------------------------------------------------
  swap_fixflt: yield,  for backward compat reasons 
  ----------------------------------------------------------------------*/
number  swap_fixflt.quote(	disc_func		df_fix_leg,
							..quote_style option(nullable) qs,	 							
							error_info option(nullable) error ) option(hidden)
{ 
	try {
		QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);
		
		error_info ee 	= new error_info(true,false);
		tenor_surface ts = this.tenor_surface_flt_leg(ee);
		if(ee.is_error() || null(ts))
			return instrument.quote(df_fix_leg,qs,error);

		if(null(qs)) {
			qs = quote_style_e(ee);			
		}

		logical ok_qs = qs == ..quote_style.YIELD || qs == ..quote_style.YIELD_PCT;
		QL_FAIL_COND(null(qs) || !ok_qs ,"invalid quote style", this,true);
		
		if(ccy_swap_) {

			disc_func df 	= this.disc_func_flt_leg(ee);
			QL_FAIL_COND(ee.is_error() || null(df),"discount function for float leg not set (required for cross currency swaps)", this,true);
		}

		disc_func dffix_orig 	= this.disc_func_fix_leg(ee);

		if(!ccy_swap_) {
			this.add_disc_func(df_fix_leg);
		}
		else {
			this.add_disc_func_fix_leg(df_fix_leg);
		}
		number q = this.imp_rate_fix_leg(0,false,ee);

		if(qs == ..quote_style.YIELD_PCT){
			q *= 100;
		}		

		if(!ccy_swap_) {
			this.add_disc_func(dffix_orig);
		}
		else {
			this.add_disc_func_fix_leg(dffix_orig);
		}

		return q;
							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.quote");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  dur_con_helper
  ----------------------------------------------------------------------*/
void  swap_fixflt.dur_con_helper(out number mc,
								 out number md,
								 out number dd) 
{
	error_info ee 	= new error_info(true,true);

	disc_func df_flt, df_fix, df_flt_orig,df_fix_orig;
	tenor_surface ts_orig;
	fwd_func fwd_flt;
	tenor_surface ts;

	logical break_if_set 		= true;
	logical allow_upd_ext_swap 	= true;
	logical is_par_updated 		= update_to_par_int(break_if_set,allow_upd_ext_swap, df_flt_orig, df_fix_orig, ts_orig, df_flt, df_fix,fwd_flt, ts );
	//Note on is_par_updated: 	(1) if ccy_swap will return false but not throw --> all *_orig parameters will be updated	
	//							(2) will return false if all funcs are set (since break_if_set = true)
	//							(3) otherwise true or throw ex1. if one *_orig is null --> throw (since break_if_set = true)

	date trade 		= this.trade_date(ee);
	date settle 	= this.settle_date(ee);
	logical payfix 	= this.pay_fix(ee);
	//number _dv01 	= this.dv01(null<number>, false,ee) *100;
	number delta 	= 0.0001;
	logical leg_indep_shift = true;
	number pv,pvdiff_fix, pvdiff_flt;	
	number _dv01 	= pvdiff_curve_shift(	delta, delta, delta, false, leg_indep_shift, pv, pvdiff_fix, pvdiff_flt, ee );

	//number tmp 	= pvdiff_curve_shift(	delta, delta, delta, false, false, pv, pvdiff_fix, pvdiff_flt, ee );
	
	//number _dv01 	= pvdiff_curve_shift(delta, delta, false,ee ) ;
	
	_dv01 			= payfix ? _dv01 / delta / 100.0 : -_dv01 / delta / 100.0 ;

	number pv_fix,pv_flt;
	number pv_base;
	pv_base = this.present_value(pv_fix,pv_flt,false,ee);

	if(payfix){
		pv_fix *= -1;
	}
	else{
		pv_flt *= -1;
	}
	
	number notional_fix,  notional_flt;
	this.notional(notional_fix, notional_flt, ee ) ;

	date mat = this.maturity(ee);
	number per_mat = (mat-trade)/365.0;
	number per_s = (settle-trade)/365.0;
		
	ql_fix_leg fixleg 	= this.fix_leg(false,ee);
	notional_exchg_style ne = fixleg.fix_def().notional_exchange();
	if(ne == notional_exchg_style.NE_NONE || ne == notional_exchg_style.NE_START){
				
		number pv_not_fix = notional_fix * df_fix.disc(per_mat)/df_fix.disc(per_s);			
		pv_fix += pv_not_fix;			
	}

	ql_float_leg fltleg 	= this.float_leg(false,ee);
	ne = fltleg.float_def().notional_exchange();
	if(ne == notional_exchg_style.NE_NONE || ne == notional_exchg_style.NE_START){
					
		number pv_not_flt = notional_flt * df_flt.disc(per_mat)/df_flt.disc(per_s);			
		pv_flt += pv_not_flt;
	}
	
	number pfix = pv_fix/notional_fix;
	number pflt = pv_flt/notional_flt;

	
	integer freq_fix, freq_flt;
	this.coupon_freq(freq_fix, freq_flt, ee);

	day_count_method dc_fix,dc_flt;
	this.dc_method(dc_fix,dc_flt,ee);
	
	number cper		= (1.0/freq_fix)*365.0;
	date to			= settle + integer(trunc(cper));
	number rfix 	= df_fix.simple_rate(trade, settle, to ,dc_fix);
	
	cper			= (1.0/freq_flt)*365.0;
	to				= settle + integer(trunc(cper));
	number rflt 	= df_flt.simple_rate(trade, settle, to ,dc_flt);
	
	number mcmdadjfix = (1.0+rfix/freq_fix);
	number mcmdadjflt = (1.0+rflt/freq_flt);
	
	number y;
	rate_type ytm_type;
	vector(number) 	cf_tot;
	vector(date) pmt_date;
	fix_yield_ext_swap(	df_fix,y,pv,ytm_type, pmt_date, cf_tot );//y is calculated from df, df for fixleg required here


	//clean up
	if(is_par_updated ) {
		if(ccy_swap_){
			this.add_disc_func_fix_leg(df_fix_orig);
			this.add_disc_func_flt_leg(df_flt_orig);
		}
		else {
			this.add_disc_func(df_fix_orig);				
		}
		this.add_surface(ts_orig);
	}

	
	number mcfix = CORE_INT.cf_mac_dur(dc_fix, trade,settle, pmt_date, cf_tot,df_fix) ;//use disc_func version
	number mdfix = mcfix/mcmdadjfix;
	number mdflt = (_dv01- pfix * mdfix)/-pflt;
	number mcflt = mdflt * mcmdadjflt;
	
	/*1) calc dv01 for whole swap [dv01]
	 2) calc classical macdur for fixleg [mcfix]
	 2) calc pv for each leg assuming notional exchange in the end of the swap [pfix, pflt]
	 3) calc adjustmentfactor between macdur and moddur for fixleg (1+r/freq_fix) and flt leg (1+r/freq_flt) [mcmdadjfix, mcmdadjflt]
	 4) calc moddur for fixleg [mdfix]
	 5) calc moddur for fltleg [mdflt] using identity  dv01 = pfix * mdfix - pflt * mdflt
	 6) calc macdur for fltleg [mcflt]
	 7) calc macdur for swap using   macdur = mcfix - mcflt
	 */

	mc = mcfix - mcflt;
	md = mdfix - mdflt;
	dd = _dv01;
	return;
}
/*-----------------------------------------------------------------------
  mac_dur      <public>
  dur for swaps returns effective duration. The base for the calculation is dv01.
  ----------------------------------------------------------------------*/
number  swap_fixflt.mac_dur(error_info option(nullable) error) 
{	
	try{
		number md,mc,dd;
		dur_con_helper( mc,md,dd) ;
		
		return mc ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.mac_dur");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  mod_dur      <public>
  dur for swaps returns effective duration. The base for the calculation is dv01.
  ----------------------------------------------------------------------*/
number  swap_fixflt.mod_dur(error_info option(nullable) error) 
{	
	try{
		number md,mc,dd;
		dur_con_helper( mc,md,dd) ;
		
		return md ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.mod_dur");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  dol_dur      <public>
  dur for swaps returns effective duration. The base for the calculation is dv01.
  ----------------------------------------------------------------------*/
number  swap_fixflt.dol_dur(error_info option(nullable) error) 
{	
	try{
		number md,mc,dd;
		dur_con_helper( mc,md,dd) ;
		
		return dd ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt.dol_dur");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  payment_data_fix_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.payment_data_fix_leg(	logical 				post_settle,
										logical option(nullable) trade_date_pv,									
										out vector(date)  		pmt_date,
										out vector(number) 		cpn_rate,
										out vector(number)  	cpn_cashflow,
										out vector(number)  	pv_cpn_cashflow,
										out vector(number)  	fee,
										out vector(number)  	pv_fee,
										out vector(number)  	notional ,
										error_info option(nullable)  error ) 
{	
	swap_gen.payment_data_fix_leg(false, post_settle, trade_date_pv, pmt_date,cpn_rate,cpn_cashflow,pv_cpn_cashflow,
								fee,pv_fee, notional, error);
						
							
	
}
/*-----------------------------------------------------------------------
  payment_data_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.payment_data_flt_leg( logical 				post_settle,
									logical option(nullable) trade_date_pv,
									out vector(date)  		fixing_date,
									out vector(number)  	fixing_rate,
									out vector(logical)  	is_fixed,									
									out vector(date)  		pmt_date,
									out vector(number) 		cpn_rate,
									out vector(number)  	cpn_cashflow,
									out vector(number)  	pv_cpn_cashflow,
									out vector(number)  	fee,
									out vector(number)  	pv_fee,
									out vector(number)  	notional ,
									error_info option(nullable)  error ) 
{	
	swap_gen.payment_data_flt_leg(true, post_settle, trade_date_pv, fixing_date, fixing_rate,
						  is_fixed,pmt_date,cpn_rate,cpn_cashflow,pv_cpn_cashflow,
						  fee,pv_fee, notional, error);
						
							
	
}

/*-----------------------------------------------------------------------
  principal_data_fix_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.principal_data_fix_leg( 	logical 				post_settle,
											logical option(nullable) trade_date_pv,
											logical 				only_real_cf,
											out vector(date) 		prin_date,
											out vector(number) 		prin_cf,	
											out vector(number) 		pv_prin_cf,
											error_info option(nullable)  error )
{
	swap_gen.principal_data_fix_leg(false, post_settle, trade_date_pv, only_real_cf,
									prin_date,prin_cf,pv_prin_cf,error);
}
/*-----------------------------------------------------------------------
  principal_data_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.principal_data_flt_leg( 	logical 				post_settle,
											logical option(nullable) trade_date_pv,
											logical 				only_real_cf,
											out vector(date) 		prin_date,
											out vector(number) 		prin_cf,	
											out vector(number) 		pv_prin_cf,
											error_info option(nullable)  error )
{
	swap_gen.principal_data_flt_leg(true, post_settle, trade_date_pv, only_real_cf,
									prin_date,prin_cf,pv_prin_cf,error);
}
/*-----------------------------------------------------------------------
  pmt_lag   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixflt.pmt_lag(	out	integer 	pmt_lag_fix_leg,
							out	integer 	mat_pmt_lag_fix_leg,
							out	integer 	pmt_lag_prin_fix_leg,
							out	integer 	mat_pmt_lag_prin_fix_leg,
							out	integer 	pmt_lag_flt_leg,
							out	integer 	mat_pmt_lag_flt_leg,
							out	integer 	pmt_lag_prin_flt_leg,
							out	integer 	mat_pmt_lag_prin_flt_leg,	
							error_info option(nullable) error) 
{
	swap_gen.swap_pmt_lag(	pmt_lag_fix_leg, mat_pmt_lag_fix_leg, pmt_lag_prin_fix_leg, mat_pmt_lag_prin_fix_leg,
								pmt_lag_flt_leg, mat_pmt_lag_flt_leg, pmt_lag_prin_flt_leg, mat_pmt_lag_prin_flt_leg,error);
	return;
}