option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	fixois
	--------------------------------------------------------------------
	is_ext_swap is a swap created from a fixed_income_swap
*/
/*
* if [approx_calc = true] --> a disc_func is always the source for the fwd rates and when
* 	1) endog_df = true] --> use the same discfunc as for discounting (make sure tenor_surface is updated with the discfunc)
* 	2) endog_df = false] --> use the discfunc from the tenor_surface (since we cannot use the other one in the object )

* if [approx_calc = false] --> a fwd_func is always the source for the fwd rates. The fwd_func is input via the tenor surface.
* 	1) [endog_df = true] --> IMPORTANT: make sure that fwd_func and disc_func are the same curve (update tenor_surface with the discfunc)
* 	2) [endog_df = false] --> fwdfunc and discfunc independent
*
* 
* 
*									fwd-rates		    						discounting
*					-				--------		    						-----------
* use_approx_ && endog_df	    	--> discount. disc_func/surf. disc_func	    disc. disc_func  --> a surface is not required but will be created (fwd_func in surface in sync with disc_func in surface and disc_func for discounting)
* use_approx_ && NOT endog_df	    --> surf. disc_func	    					disc. disc_func  --> a surface required (fwd_func in surface in sync with disc_func in surface)
* NOT use_approx_ && endog_df	    --> surf. fwd_func for fwd-rates	    	disc. disc_func  --> a surface required, fwd and disc are the same curve
* NOT use_approx_ && NOT endog_df   --> surf. fwd_func for fwd-rates	    	disc. disc_func  --> a surface required, fwd and disc are independent

*									surface_disc													surface_fwd
*									--------------------											---------------
* use_approx_ && endog_df	    	--> surf. disc_func = discount. disc_func	    				implied from surf. disc_func [not used for price calc]    
* use_approx_ && NOT endog_df	    --> surf. disc_func [**]	    								implied from surf. disc_func [not used for price calc]
* NOT use_approx_ && endog_df	    --> implied from fwd or invalid [not used for price calc]	    surf. fwd_func [**] (fwd and discounting disc_func are the same curve)
* NOT use_approx_ && NOT endog_df   --> implied from fwd or invalid [not used for price calc] 		surf. fwd_func [**]

with index_spread (eonia+)
-------------------
* use_approx_ && endog_df	    	-->flat input to dll (spread added from ir_index)				[add spread on disc. disc_func]
* use_approx_ && NOT endog_df	    -->flat input to dll (spread added from ir_index)				[no spread on disc. disc_func]
* NOT use_approx_ && endog_df	    -->flat input to dll (spread added from ir_index)				[add spread on disc. disc_func]
* NOT use_approx_ && NOT endog_df 	-->flat input to dll (spread added from ir_index)				[no spread on disc. disc_func]



*/
//----------------------------------------------------------------------
//  class swap_fixois
//----------------------------------------------------------------------
class swap_fixois: public swap_gen
option(category: "Instrument/Interest Rate Swap/Fixed vs ONIndex")
//option(allow_undeclared_mfuncs)
{
public:
	override swap_fixois 	clone() ;
	override instrument 	inst();
	override void  	__dbg_print(__dbg_label);
    override void  	__dbg_browse(__dbg_split);
	
	/*----------ADD FUNCS [PUBLIC]---------------*/	
	void 		add_quote(number,..quote_style );
	override void add_quote(number);
	void 		add_notional(number );
	void 		add_notional(number , number);
	void		add_fx_rate(number,logical,string,string );
	void 		add_fx_mult_fix_leg(number );
	void 		add_fx_mult_ois_leg(number );
	
	void 		add_disc_func(disc_func,logical,out tenor_surface);
	void 		add_disc_func_fix_leg(disc_func );	
	void		add_fwd_func(fwd_func, logical,out disc_func,out tenor_surface  );
	void 		add_fwd_from_disc_func(disc_func,logical,out tenor_surface  );
	void 		add_disc_func_ois_leg(disc_func,logical, out tenor_surface );
	void 		add_surface(tenor_surface option(nullable));
	
	void		add_fixing(vector(date) ,vector(number) ,logical option(nullable) fixing_as_fwd = false);
	void		add_fixing(number ,logical option(nullable) fixing_as_fwd = false);
	void		add_current_fixing(number option(nullable));

	void 		add_curve_data_ois_leg(disc_func , disc_func option(nullable),logical ) ;
	void 		add_curve_data_ois_leg(disc_func , fwd_func option(nullable) ,logical) ;

	void 		add_curve_data(disc_func ,disc_func option(nullable), disc_func option(nullable),logical ) ;
	void 		add_curve_data(disc_func ,disc_func option(nullable), fwd_func option(nullable),logical ) ;
	
	/*void 		add_data( 	number option(nullable), disc_func option(nullable),tenor_surface option(nullable),
							vector(date) option(nullable),vector(number) option(nullable),
							logical option(nullable) fixing_as_fwd_ois_leg = false,
							logical upd_null_crv = false,logical upd_null_fix = false);//legacy and hidden
	void 		add_data( 	number option(nullable), disc_func option(nullable),fwd_func option(nullable),
							vector(date) option(nullable),vector(number) option(nullable),
							logical option(nullable) fixing_as_fwd_ois_leg = false,
							logical upd_null_crv = false,logical upd_null_fix = false);
	void 		add_ccy_data(	number option(nullable),disc_func,number option(nullable),number option(nullable),disc_func,number option(nullable),
								tenor_surface option(nullable),vector(date) option(nullable),vector(number) option(nullable),
								logical option(nullable) fixing_as_fwd_ois_leg = false,
								logical upd_null_crv = false,logical upd_null_fix = false);	//legacy and hidden
	void 		add_ccy_data(	number option(nullable),disc_func,number option(nullable),number option(nullable),disc_func,number option(nullable),
								fwd_func,vector(date) option(nullable),vector(number) option(nullable),
								logical option(nullable) fixing_as_fwd_ois_leg = false,
								logical upd_null_crv = false,logical upd_null_fix = false);*/

	void 		curve_state(out disc_func, out disc_func, out tenor_surface);
	void		add_curve_state( disc_func option(nullable),  disc_func option(nullable),  tenor_surface option(nullable));
	
	/*----------MISC FUNCS [PUBLIC]---------------*/
	//DLL_SWAP_HANDLER OK
	date 				start_date(error_info option(nullable) error = null<error_info> );				/*name change of issuedate*/
	override void  		final_pmt_date(out date,out date ,error_info option(nullable) error = null<error_info> ); 
	//DLL_SWAP_HANDLER --> IN PROGRESS
	override void 		is_amortizing(out logical,out logical ,error_info option(nullable) error = null<error_info>);
	override logical 	is_amortizing(error_info option(nullable) error = null<error_info>);
	logical				is_cross_currency(error_info option(nullable) error = null<error_info>);
	logical				is_par_flat(error_info option(nullable) error = null<error_info>);
	logical 			pay_fix(error_info option(nullable) error = null<error_info> );
	override void 		notional(out number , out number , error_info option(nullable) error = null<error_info>);
	number 				notional(error_info option(nullable) error = null<error_info>);
	void 				is_regular_first(out logical , out logical , error_info option(nullable) error = null<error_info>);				
	void 				is_regular_last(out logical , out logical , error_info option(nullable) error = null<error_info>);		
	override void 		fx_mult_factor(out number , out number , error_info option(nullable) error = null<error_info>);
	override void 		currency(out string , out string , error_info option(nullable) error = null<error_info>);
	override void 		coupon(out number ,out number , error_info option(nullable) error = null<error_info>);
	override void 		coupon_freq(out integer,out integer, error_info option(nullable) error = null<error_info> );
	override void 		dc_method(	out day_count_method , out day_count_method , error_info option(nullable) error = null<error_info>);									
	override void  		pmt_bus_day(out bd_convention, out bd_convention, error_info option(nullable) error = null<error_info>);			
	override void 		roll_day(out integer,out integer,  error_info option(nullable) error = null<error_info>);
	override void 		eom(out logical ,out logical , error_info option(nullable) error = null<error_info> );
	override void 		calendar(out ..calendar option(nullable),out ..calendar option(nullable), error_info option(nullable) error = null<error_info>);	
	override void  		first_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	override void  		last_reg_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	override void  		effective_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	override void  		next_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	override void  		previous_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	override void		calendar_name(out string ,out string  , error_info option(nullable) error = null<error_info> ) ;

	void 			pmt_lag(out	integer 	pmt_lag_leg1,
							out	integer 	mat_pmt_lag_leg1,
							out	integer 	pmt_lag_prin_leg1,
							out	integer 	mat_pmt_lag_prin_leg1,
							out	integer 	pmt_lag_leg2,
							out	integer 	mat_pmt_lag_leg2,
							out	integer 	pmt_lag_prin_leg2,
							out	integer 	mat_pmt_lag_prin_leg2,	
							error_info option(nullable) error) ;
	
	override string 	settle_code(error_info option(nullable) error = null<error_info>);	
	//quote funcs
	override void 		quote(out number  ,out number  ,error_info option(nullable) error = null<error_info> );	
	override number 	quote(error_info option(nullable) error = null<error_info> );
	
	/*----------CASHFLOW FUNCS [PUBLIC]---------------*/
	override void		cash_flow_dates(logical,out vector(date) ,out vector(date) ,error_info option(nullable) error = null<error_info> ) ;
	override void		cash_flows_cpn(logical,out vector(number) ,out vector(number),error_info option(nullable) error = null<error_info> );
	override void		cash_flows(logical,out vector(number) ,out vector(number),error_info option(nullable) error = null<error_info> );
	override void		cash_flow_data(	logical,ir_cf_code cf_code,out vector(date)  ,out vector(number)  , out vector(date)   ,out vector(number)  ,
								error_info option(nullable) error = null<error_info> );
	override void 		cash_flow_data(logical,logical option(nullable),out vector(date)  ,out vector(number) ,
								out vector(number)  ,out vector(number)  , out vector(number)  ,out vector(number)  ,
								out vector(number)  ,out vector(date)  	, out vector(number)  ,out vector(number)  ,
								out vector(number)  ,out vector(number)  , out vector(number)  ,out vector(number)  ,
							   error_info option(nullable) error = null<error_info> );
	void 				data(out swap_fix_leg_data,out swap_ois_leg_data,error_info option(nullable) error = null<error_info>);
	void 				data(out swap_fix_leg_data,error_info option(nullable) error = null<error_info>);
	void 				data(out swap_ois_leg_data,error_info option(nullable) error = null<error_info>);
	/*----------PV FUNCS [PUBLIC]---------------*/
	override number  	present_value(	disc_func option(nullable),disc_func option(nullable),out number  ,
								out number  ,number option(nullable) ,logical option(nullable) trade_date_pv = false,		
								error_info option(nullable) error = null<error_info>);
	
	override number  	present_value(	disc_func option(nullable),disc_func option(nullable),out number  ,
								out number  , date option(nullable) ,date option(nullable) ,
								logical,logical  ,error_info option(nullable) error = null<error_info>);

	override number  	present_value_fee(	disc_func option(nullable),disc_func option(nullable),out number  ,
								out number ,date option(nullable) ,date option(nullable) ,
								logical,logical  ,error_info option(nullable) error = null<error_info>);
	
	override number  	present_value(	out number  ,out number  pv_ois_leg, logical option(nullable) ,error_info option(nullable) error = null<error_info> );

	override number 	accrued(logical,out number ,out number , error_info option(nullable) error = null<error_info>);
	override void 		accrued_period(out number ,out number , out integer,out integer,error_info option(nullable) error = null<error_info>);

	override number 	accrued_chg(integer bus_days, out number 	,out number , out number 	,out number  ,
									out date  ,out date  ,error_info option(nullable) error = null<error_info> );

	void				implied_par_funcs(out disc_func ,out fwd_func ,error_info option(nullable) error = null<error_info>);

	override number		solver(	number,swap_solver_code ,logical option(nullable) trade_date_pv = false,
								error_info option(nullable) error = null<error_info>);

	number  	dv01_fwd(fwd_func,fwd_func,number,error_info option(nullable) error = null<error_info> ) ;

	number 		dv01_disc(disc_func ,disc_func, number ,error_info option(nullable) error = null<error_info>) ;

	number 		dv01_disc(disc_func option(nullable) , disc_func option(nullable) ,disc_func  ,disc_func  ,								
								number ,error_info option(nullable) error = null<error_info>) ;

	number 		dv01(	fwd_func option(nullable) ,fwd_func option(nullable) ,disc_func option(nullable) ,
							disc_func option(nullable) ,disc_func option(nullable) ,disc_func option(nullable) ,								
							number ,error_info option(nullable) error = null<error_info>) ;

	number  	pvdiff(	fwd_func option(nullable),fwd_func option(nullable),disc_func option(nullable),disc_func option(nullable),
							disc_func option(nullable),disc_func option(nullable),logical option(nullable),
							out number ,out number ,out number ,error_info option(nullable) error = null<error_info> ) ;

	number 		dv01(number option(nullable) delta = null<number>, logical option(nullable) trade_date_pv = false,
						error_info option(nullable) error  = null<error_info>) ;

	number 		dv01_disc(number option(nullable) delta = null<number>, logical option(nullable) trade_date_pv = false,
						error_info option(nullable) error  = null<error_info>) ;

	number 		dv01_fwd(number option(nullable) delta = null<number>, logical option(nullable) trade_date_pv = false,
						error_info option(nullable) error  = null<error_info>) ;

	number  	pvdiff_curve_shift(	number option(nullable) delta_disc = null<number>,number option(nullable) delta_fwd = null<number>,
									logical option(nullable) trade_date_pv = false,error_info option(nullable) error  = null<error_info>) ;
			
	number  	gamma_risk(	number option(nullable) delta = null<number>,  logical option(nullable) trade_date_pv = false,
							error_info option(nullable) error  = null<error_info>) ;

	number 		gamma_risk_fwd(number option(nullable) delta = null<number>,  logical option(nullable) trade_date_pv = false,
								error_info option(nullable) error  = null<error_info>) ;
	
	number 		gamma_risk_disc(number option(nullable) delta = null<number>,  logical option(nullable) trade_date_pv = false,
								error_info option(nullable) error  = null<error_info>) ;

	/*void  		risk_ladder(	vector(disc_func) ,disc_func ,disc_func option(nullable) ,number,out vector(number) ,
								out number ,error_info option(nullable)  );
	
	void  		risk_ladder(	vector(fwd_func) ,fwd_func ,fwd_func option(nullable) ,number,out vector(number) ,
								out number ,error_info option(nullable)  );*/
	
	void 		risk_ladder_fwd(vector(fwd_func),fwd_func,fwd_func option(nullable),number,out vector(number) ,
								out number, error_info option(nullable) error = null<error_info> ) ;
	void 		risk_ladder_fwd(vector(disc_func),disc_func,disc_func option(nullable),number,out vector(number) ,
								out number, error_info option(nullable) error = null<error_info> ) ;
	
	void		risk_ladder_disc(/*fwd_func option(nullable),*/vector(disc_func),disc_func,disc_func option(nullable) ,
								 number, out vector(number) ,
								 out number ,error_info option(nullable) error = null<error_info> ) ;
	
	void 		upfront_carry_all(	out date  ,out  date  , out number 	,out number,out number,out number ,																		
									out number  npv_spot_fix_leg,	
									out number 	npv_spot_ois_leg,
									out number  npv_fwd_fix_leg,	
									out number 	npv_fwd_ois_leg,
									out number  reinv_irim_cf_fix_leg,									
									out number 	reinv_irim_cf_ois_leg,									
									out number  irim_cf_fix_leg,									
									out number 	irim_cf_ois_leg,																															
								error_info option(nullable) error = null<error_info> ) ;

	//void 		carry(	out date  ,out date  , logical,out number,out number,out number,out number,error_info option(nullable) error = null<error_info> ) ;
	
	void 		upfront_rolldown_all(out date  ,out date  ,logical  ,out number 	,out number ,out number ,out number ,
									out number ,out number ,out number  ,out number,out number,out number,out number,out number ,
									error_info option(nullable) error = null<error_info> ) ;

	//number 		run_rolldown(	out date,out date ,logical ,out number,error_info option(nullable) = null<error_info> );
	number  	spreadbp_to_fixbp(	error_info option(nullable) error = null<error_info> );
	
	/*----------FIXLEG FUNCS [PUBLIC]---------------*/
	interest_rule  			ir_rule_fix_leg(error_info option(nullable) error = null<error_info>);
	number					coupon_fix_leg(error_info option(nullable) error = null<error_info> );

	number					pv01_ext(	number option(nullable) ,number option(nullable) ,disc_func option(nullable) ,
										out number ,out number ,error_info option(nullable) error = null<error_info> ) ;
	
	number					pv01(	number option(nullable) = null<number>,number option(nullable) = null<number>,
									disc_func option(nullable) df = null<disc_func>,
									error_info option(nullable) error = null<error_info>);
	
	override number			pvdiff_fix_rate(number , disc_func option(nullable) df = null<disc_func>,
												error_info option(nullable) error = null<error_info>);
	
	disc_func 				disc_func_fix_leg(error_info option(nullable) error = null<error_info> ) ;
	//override number 		fix_leg_y_to_pv(number option(nullable) y = null<number>,logical l= true , error_info option(nullable) error = null<error_info>);
	override number			imp_rate_fix_leg(number,logical option(nullable) trade_date_pv = false,error_info option(nullable) error = null<error_info>);
	override number			par_rate_fix_leg(	disc_func, error_info option(nullable) error = null<error_info>);
	void					accr_dates_fix_leg(	logical,out vector(date),out vector(date),out vector(number) ,
												error_info option(nullable) error= null<error_info> );

	void 					payment_data_fix_leg(	logical,logical option(nullable), out vector(date),out vector(number) ,
													out vector(number) ,out vector(number) ,
													out vector(number) ,out vector(number),out vector(number) ,
													error_info option(nullable)  error = null<error_info>) ;
	
	void 					principal_data_fix_leg(	logical,logical option(nullable) ,logical ,
													out vector(date),out vector(number),out vector(number) ,
													error_info option(nullable)  error  = null<error_info>);
	/*----------OISLEG FUNCS [PUBLIC]---------------*/
	integer  			rfr_arrears_days_ois_leg(error_info option(nullable) error = null<error_info>);
	rfr_arrears_type  	rfr_arrears_type_ois_leg(error_info option(nullable) error = null<error_info>);
	flt_avg_method  	avg_method_ois_leg(error_info option(nullable) error = null<error_info>);
	flt_sprd_comp_method  sprd_comp_method_ois_leg(error_info option(nullable) error = null<error_info>);
	flt_comp_avg_type  	comp_avg_type_ois_leg(error_info option(nullable) error = null<error_info>);
	interest_rule  			ir_rule_ois_leg(error_info option(nullable) error = null<error_info>);
	number					spread_ois_leg(error_info option(nullable) error = null<error_info> );
	//number				current_coupon_ois_leg(error_info option(nullable) error = null<error_info> );
	void					current_fixings_ois_leg(logical,out vector(date),out vector(number) ,out vector(logical),
													error_info option(nullable) error = null<error_info>);
	logical  				is_endog_df(error_info option(nullable) error = null<error_info>);
	logical  				is_approx_calc(error_info option(nullable) error = null<error_info>);
	number					pv01_spread(number option(nullable)= null<number>,number option(nullable)= null<number>,
										disc_func option(nullable) df = null<disc_func>,
										error_info option(nullable) error = null<error_info>);
	
	integer					reset_freq_ois_leg(error_info option(nullable) error = null<error_info>);
	
	void					index_dates_ois_leg(logical,logical,out vector(date) ,out vector(date) ,
												out vector(logical)  ,error_info option(nullable) error = null<error_info> ) ;
	void					accr_dates_ois_leg(	logical,out vector(date),out vector(date),out vector(number) ,
												error_info option(nullable) error= null<error_info> );
	
	void					fixing_data_ois_leg(logical ,logical option(nullable),out vector(date)  ,									
												out vector(number)  ,out vector(logical) ,
												error_info option(nullable) error = null<error_info> ) ;
	number					imp_spread_ois_leg(number,logical option(nullable) trade_date_pv = false,
											   error_info option(nullable) error = null<error_info>);
	
	disc_func 				disc_func_ois_leg(error_info option(nullable) error = null<error_info> ) ;
	tenor_surface 			tenor_surface_ois_leg(error_info option(nullable) error = null<error_info>);
	fwd_func 				fwd_func_ois_leg(error_info option(nullable) error = null<error_info>);
	ir_index 				ir_index_ois_leg(error_info option(nullable) error = null<error_info> );
	string 					index_tenor_ois_leg(error_info option(nullable) error = null<error_info> ) ;
	tenor_code 				index_tenor_code_ois_leg(error_info option(nullable) error = null<error_info> ) ;
	string 					currency_ois_leg(error_info option(nullable) error = null<error_info>);
	day_count_method  		dc_method_ois_leg( error_info option(nullable) error = null<error_info>);
	
	//tenor_surface 			create_tenor_surface(disc_func ,disc_func ); //legacy and hidden
	tenor_surface 			create_tenor_surface_ois_leg(disc_func option(nullable),fwd_func option(nullable),logical,error_info option(nullable) error = null<error_info> );

	void 					payment_data_ois_leg(	logical,logical option(nullable),out vector(date) ,out vector(number) ,
													out vector(logical) ,out vector(date),out vector(number) ,out vector(number) ,out vector(number) ,
													out vector(number) ,out vector(number),out vector(number) ,
													error_info option(nullable)  error = null<error_info>) ;

	void 					principal_data_ois_leg(	logical,logical option(nullable) ,logical ,
													out vector(date),out vector(number),out vector(number) ,
													error_info option(nullable)  error  = null<error_info>);
	
	//-----external swap specific-----	
	override instrument_type 		swap_type(error_info option(nullable) error = null<error_info> );
	vector(ql_swap_leg) 			legs(logical,error_info option(nullable) error = null<error_info>);
	ql_ois_leg 						ois_leg(logical,error_info option(nullable) error = null<error_info>);
	ql_fix_leg 						fix_leg(logical,error_info option(nullable) error = null<error_info>);
	override ql_fixed_income_swap 	swap_instrument(error_info option(nullable) error = null<error_info>) ;
	
	/*---set functions-required--*/	
	override swap_fixois	set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);
	override swap_fixois	set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);
	//virtual instrument 	set_settle_date(date ,logical ,error_info option(nullable) error = null<error_info> );
		
	/*-----set functions-if applicable-----*/
	swap_fixois				set_rate_fix_leg(number option(nullable) ,error_info option(nullable) error = null<error_info>);
	swap_fixois				set_spread_ois_leg(number option(nullable) ,error_info option(nullable) error = null<error_info>);
	
	//local set funcs
	swap_fixois 			set_date(date,date option(nullable) settle_date=null<date>, error_info option(nullable) error = null<error_info>);
	override swap_fixois	set_date(date,date option(nullable),logical,logical ,error_info option(nullable) error = null<error_info> );
	void					update_to_par(error_info option(nullable) error = null<error_info> );
	swap_fixois				set_pay_leg(logical ,error_info option(nullable) error = null<error_info>);

	//--------------------------------------------------------------------------
	//----------HIDDEN FUNCS [PUBLIC]--(mostly for backward compat)-------------
	//--------------------------------------------------------------------------	
	swap_fixois(__instrument);	

	//general-one per swap
	override ir_index 		ir_index(error_info option(nullable) error = null<error_info> );				/*hidden, not visible in root*/	
	
	//price, compat funcs
	override number 		yield(logical disable_rounding = false,error_info option(nullable) error = null<error_info>);			/*hidden, visible in root*/
	override number			yield(	disc_func,logical= false,error_info option(nullable) error= null<error_info>);						/*hidden, visible in root*/	
	override number  		quote(	disc_func , ..quote_style option(nullable) ,error_info option(nullable) error = null<error_info>);  /*hidden, visible in root*/
	override number 		mac_dur(error_info option(nullable) error = null<error_info>);
	override number 		mod_dur(error_info option(nullable) error = null<error_info>);
	override number 		dol_dur(error_info option(nullable) error = null<error_info>);
	
	swap_fixois(swap_fixois);
protected:
	
	override swap_fixois	create(__instrument option(nullable),out instr_error ,error_type type = E_INVALID_ARG);  
	swap_fixois 			err_type(swap_fixois option(nullable), error_info option(nullable) error = null<error_info>);	
	//logical 				y_ne_cpn_err();	
	//void					do_par_update();
	
	
	disc_func 				df_shifted_ois_leg(number,disc_func);
	tenor_surface 			fwd_shifted_ois_leg(number ,disc_func,tenor_surface);//legacy
	fwd_func 				fwd_shifted_ois_leg(number ,fwd_func);
	number 					pvdiff_curve_shift(	number option(nullable) ,number option(nullable),number option(nullable),
												logical option(nullable) ,logical option(nullable), out number, out number  ,out number ,
												error_info option(nullable) error = null<error_info> );
	//add
	//override void 			add_nominal(number );
	//override void 			add_quote(number,logical option(nullable ));	
	//override void 			add_quote_from_yield(number,logical option(nullable) set_coupon_to_yield = null<logical>);
	
	//void 					add_disc_func_int(disc_func,logical  ); 
	//void 					add_disc_func_int_ois_leg(disc_func,logical );		
	//void					add_fwd_func_int(fwd_func,logical );
	/*void 					add_data( 	number option(nullable), disc_func option(nullable),fwd_func option(nullable), 
										logical,vector(date) option(nullable), vector(number) option(nullable),
										logical option(nullable) fixing_as_fwd_ois_leg = false,
										logical upd_null_crv = false,logical upd_null_fix = false);*/
		
	override number 		pvbp(number option(nullable),number option(nullable),logical option(nullable),
								logical option(nullable),	error_info option(nullable) error = null<error_info>) ;
	
	override number 		pvbp(number option(nullable),number  option(nullable),
								 error_info option(nullable) error = null<error_info>);
	
	//set funcs
	//override swap_fixois	set_date(date,date option(nullable) ,logical,logical , error_info option(nullable) error = null<error_info>);	
	override swap_fixois	set_date(date,logical ,error_info option(nullable) error = null<error_info>);					/*legacy*/

	override swap_fixois	move_date(	date,date option(nullable) settle_date=null<date> ,
										error_info option(nullable) error = null<error_info>);								/*legacy*/

	override swap_fixois	set_yield(number option(nullable) ,error_info option(nullable) error = null<error_info>);
	override swap_fixois	set_quote_from_yield(number option(nullable), error_info option(nullable) error = null<error_info>);/*legacy*/

	void  					get_legs(	out ql_fix_leg,out ql_ois_leg );
	

	logical 				update_to_par_int(	logical ,logical, out disc_func ,out disc_func ,out tenor_surface ,out disc_func ,
												out disc_func, out tenor_surface);
	
	//logical ext_swap_;
	//logical ccy_swap_;
	//logical full_swap_;
};
//------------------------------------------------
// __dbg_print
//------------------------------------------------
void swap_fixois.__dbg_print(__dbg_label l)
{
	error_info ee 	= new error_info(true,false);
    l.set_text(strcat([
						"name: ",
						name(ee),
						",  ext_swap: ",
						null(ext_swap_) ? "" : string(ext_swap_),
                        ", ccy_swap: ",
						null(ccy_swap_) ? "" : string(ccy_swap_),
						", valid: ",
						null(this.is_valid(ee)) ? "" : string(this.is_valid(ee))
					]));
}
//------------------------------------------------
// __dbg_browse
//------------------------------------------------
void swap_fixois.__dbg_browse(__dbg_split s)
{
    s.resize(4);

	error_info ee 	= new error_info(true,false);
	
    s.set_text(0, "name");
    s.set_value(0, this.name(ee));

    s.set_text(1, "ext_swap");
    s.set_value(1, ext_swap_);

    s.set_text(2, "ccy_swap");
    s.set_value(2, ccy_swap_);
	
	s.set_text(3, "valid");
    s.set_value(3, this.is_valid(ee));

}
//------------------------------------------------
// copy constructor
//------------------------------------------------
swap_fixois.swap_fixois(swap_fixois c) : swap_gen(c){}

//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
swap_fixois.swap_fixois(__instrument i) option(hidden) : swap_gen(i)
{	
	error_info ee = new error_info(true,false);
	if(!this.is_valid(ee)) {
		ext_swap_ = ccy_swap_ = full_swap_ = false;
		return;
	}
		
	ext_swap_ 	= this.is_ext_swap(ee);
	ccy_swap_ 	= this.is_ccy_swap(ee);
	full_swap_ 	= this.verify_full_swap(true,ee);//if false then swap is static											
}

/*-----------------------------------------------------------------------
  swap_type  EXT SWAP: ok
  ----------------------------------------------------------------------*/
instrument_type swap_fixois.swap_type(error_info option(nullable) error) 
{	
	return swap_gen.swap_type(error);
}

//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string swap_fixois.instr_type_s() 	{ return string(..instr_type.SWAP_FIXOIS);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	swap_fixois.inst()		{ return this;}

//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
swap_fixois swap_fixois(swap_fixois b)			{ return new swap_fixois(b);}
//------------------------------------------------
// clone
//------------------------------------------------
swap_fixois swap_fixois.clone() 	{ return new swap_fixois(this);}

//------------------------------------------------
// create  [PROTECTED]
// create swap_fixois from internal instrument
//------------------------------------------------
swap_fixois swap_fixois.create(	__instrument option(nullable) c,
								out instr_error  error,
								error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_fixois>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.SWAP_FIXOIS, "invalid instrument type",type );//should not happen
	
	return new swap_fixois(c);
}

/*-----------------------------------------------------------------------
  create_swap_fixois  <FUNCTION> 
  ----------------------------------------------------------------------*/
swap_fixois create_swap_fixois(	__instrument option(nullable) c,
									out instr_error  error,
									error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_swap_fixois')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_fixois>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.SWAP_FIXOIS, "invalid instrument type",type );//should not happen
	
	return new swap_fixois(c);
}

swap_fixois create_swap_fixois(	__instrument option(nullable) 		c,
								error_info option(nullable) 		error,
								error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_swap_fixois_ei')
{
	instr_error ee 	= instr_error();
	swap_fixois b 	= create_swap_fixois(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_swap_fixois");
	return b;
}
//-----------------------------------------------
// constructor <FUNCTION> dynamic cast   EXT SWAP: ok
//-----------------------------------------------
swap_fixois swap_fixois(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
option(com_name: 'swap_fixois_dyncast')
{ 
	try {
		swap_fixois d = dynamic_cast<swap_fixois>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a swap_fixois)","swap_fixois" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois");
		return null<swap_fixois>;
	}
}
/*-----------------------------------------------------------------------
  err_type	EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois.err_type(swap_fixois option(nullable) nul,
								 error_info option(nullable) error )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,"mwlib(ql) error: inapplicable function call for current instrument type");
	return null<swap_fixois>;
}
/*-----------------------------------------------------------------------
  create_null_swap_fixois <FUNCTION>   (because it was not possble to return null
									from swap_fltflt2s.swap_fltflt())
  ----------------------------------------------------------------------*/
swap_fixois create_null_swap_fixois()
{
	return null<swap_fixois>;
}
/*-----------------------------------------------------------------------
  update_to_par	EXT SWAP: ok,  not for currency swaps  <protected>
  ----------------------------------------------------------------------*/
logical swap_fixois.update_to_par_int(	logical break_if_set,
										logical allow_upd_ext_swap,
										out disc_func df_ois_orig,
										out disc_func df_fix_orig,
										out tenor_surface ois_ts_orig,
										out disc_func df_ois,
										out disc_func df_fix,
										out tenor_surface ois_ts )
{
	//do a "par" update only for 
	//1. non-currency-swaps and 
	//2. non-external-swaps (depends on allow_ext_swap)
	//3. swaps which does not already have df/ts (depends on break_if_set)
	
	if(!full_swap_){
		QL_FAIL("incomplete swap");
	}

	QL_FAIL_COND(fix_leg_y_ne_cpn_err(),"yield vs coupon error (internal error for db swap)", this,true);	

	//disc_func df_ois_orig,df_fix_orig ;
	tenor_surface ts_orig;
	curve_state(df_fix_orig, df_ois_orig, ts_orig);
	
	error_info ee 	= new error_info(true,true);
	df_ois 			= df_ois_orig;
	df_fix 			= df_fix_orig;
	ois_ts			= ois_ts_orig;	

	if(break_if_set){
		if(!null(df_ois_orig) && !null(df_fix_orig) && !null(ois_ts_orig)){
			return false;
		}
		
		if(!null(df_ois_orig) || !null(df_fix_orig) || !null(ois_ts_orig))
			QL_FAIL("one or more disc_func/fwd_func already defined (but not complete)");
	}

	if(!allow_upd_ext_swap && ext_swap_) {
		return false;
	}
	
	if(ccy_swap_)
		return false;

	fwd_func ois_fwd_func;
	this.implied_par_funcs(df_ois,ois_fwd_func,ee);	

	df_fix = df_ois;

	..ir_index ir		= this.ir_index_ois_leg(ee);
	CORE_INT.instr_fail_check(null(ir), "invalid ir_index", this, ee);
	logical allow_extrap = false;
	tenor_surface ts 	= tenor_surface(this.trade_date(), df_ois,[ois_fwd_func],[ir],allow_extrap);
				
	add_curve_state(df_fix, df_ois, ts);

	return true;
	
}
/*-----------------------------------------------------------------------
  update_to_par	EXT SWAP: ok,  not for currency swaps
  update to par will overwrite existing disc_func/fwd_func
  ----------------------------------------------------------------------*/
void swap_fixois.update_to_par(error_info option(nullable) error )
{
	try {
		
		QL_FAIL_COND(ccy_swap_,"inapplicable function call for cross currency swaps", this,true);
		
		disc_func df, df_tmp, df_flt_orig,df_fix_orig;
		tenor_surface ts_tmp, ts_orig;
		
		logical is_updated = update_to_par_int(false, true,df_flt_orig, df_fix_orig, ts_orig, df, df_tmp,ts_tmp);
		QL_REQUIRE(is_updated,"failed par update swap_fixois",this,true);

		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.set_to_par");
		return;
	}
}
/*-----------------------------------------------------------------------
  pay_fix  EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical	 swap_fixois.pay_fix(error_info option(nullable) error )
{
	return swap_gen.swap_payleg1(error);
}
/*-----------------------------------------------------------------------
  is_amortizing EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixois.is_amortizing(out logical is_amort_fix,
							   out logical is_amort_ois,
							   error_info option(nullable) error )
{
	swap_gen.is_amortizing(is_amort_fix,is_amort_ois,error);
	return;
	
}
/*-----------------------------------------------------------------------
  is_amortizing  EXT SWAP: ok  
  ----------------------------------------------------------------------*/
logical swap_fixois.is_amortizing(error_info option(nullable) error )
{
	return swap_gen.is_amortizing(error);
}

/*-----------------------------------------------------------------------
  swap_fixois: add_quote		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixois.add_quote(	number  quote ) 
{
	instrument.add_quote(quote, true);
	return ;						
}
/*-----------------------------------------------------------------------
  swap_fixois: add_quote		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixois.add_quote(	number  quote,
							..quote_style quote_style) 
{
	error_info ee = new error_info(true,true);
	..quote_style qs = instrument.quote_style_e(ee);
	
	if(quote_style == qs)
		this.add_quote(quote);
	else{
		if(quote_style == ..quote_style.YIELD)
			this.add_quote(quote*100);//instr quotestyle must be pct
		else if(quote_style == ..quote_style.YIELD_PCT)
			this.add_quote(quote/100);//instr quotestyle is not pct
		else
			QL_FAIL("invalid quote style",this,true);
	}					
}
/*-----------------------------------------------------------------------
  add_quote_from_yield
  ----------------------------------------------------------------------*/

/*void swap_fixois.add_quote_from_yield(	number  yield,
										logical option(nullable) set_to_par )
{
	
	QL_FAIL_COND(!null(set_to_par) && !set_to_par,"set_to_par = false is not supported for swaps",this,true);
	instrument.add_quote_from_yield(yield, set_to_par );
}*/

/*-----------------------------------------------------------------------
  swap_fixois: add_funcs
  ----------------------------------------------------------------------*/
void swap_fixois.add_notional(number notional)				{ swap_gen.swap_add_notional(notional);}
void swap_fixois.add_notional(number notional1, number notional2)	{ swap_gen.swap_add_notional(notional1, notional2);}	
void swap_fixois.add_fx_mult_fix_leg(number fx_mult)		{ swap_gen.swap_add_fx_mult_leg1(fx_mult);}
void swap_fixois.add_fx_mult_ois_leg(number fx_mult)		{ swap_gen.swap_add_fx_mult_leg2(fx_mult);}
/*-----------------------------------------------------------------------
  add_fx_rate EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixois.add_fx_rate(number fx_quote_dec,//must be a quote per unit of base ccy 
							logical pv_in_base_ccy,
							string 	base_ccy,
							string 	price_ccy)
{
	swap_gen.swap_add_fx_rate(fx_quote_dec,pv_in_base_ccy,base_ccy,price_ccy);
}
void swap_fixois.add_disc_func_fix_leg(disc_func disc_func) 			{ swap_gen.swap_add_disc_func_leg1(disc_func);}//beware that even for single curr swaps only one leg is updated
void swap_fixois.add_current_fixing(number option(nullable) fixing) 	{ swap_gen.swap_add_curr_fixing_leg2(fixing);	}

/*-----------------------------------------------------------------------
  add_disc_func	 	EXT SWAP: ok
  ----------------------------------------------------------------------*/

void swap_fixois.add_disc_func(disc_func disc_func ,
							   logical add_surf_if_endog,
							   out tenor_surface ts)//ts will be added as is to swap if input (if add_surf_if_endog=true and is_endog )
{
	QL_REQUIRE(!ccy_swap_,"inapplicable function call for cross currency swaps",this,true);
	add_disc_func_ois_leg(disc_func,add_surf_if_endog, ts);
	add_disc_func_fix_leg(disc_func);
}
/*--------------------
 add_disc_func ois leg
 Note: 	-this func refers to the discounting but if [endog_df = true] also the surface will be updated
		-beware that even for single curr swaps only one leg is updated
 ---------------------*/
void swap_fixois.add_disc_func_ois_leg(disc_func  disc_func,
									   logical add_surf_if_endog,
									   out tenor_surface ts)//ts will be added as is to swap if input (if add_surf_if_endog=true and is_endog )
{	
	swap_gen.add_disc_func_ois_leg2( disc_func,add_surf_if_endog, ts );
}
/*--------------------
 add_fwd_func ois leg
 ---------------------*/
void swap_fixois.add_fwd_func(	fwd_func fwd_func ,
								logical add_disc_if_endog,
								out disc_func df,//df will be used if input (if add_disc_if_endog = true and is_endog_df)
								out tenor_surface ts)//ts is output only
{
	swap_gen.add_fwd_func_ois_leg2(fwd_func,add_disc_if_endog,df, ts);			
}
/*--------------------
 add_fwd_from_disc_func
 ---------------------*/
void swap_fixois.add_fwd_from_disc_func(disc_func fwddf,
										logical add_disc_if_endog,
										out tenor_surface ts)//ts is output only
{

	swap_gen.add_fwd_from_disc_func_ois_leg2( fwddf,add_disc_if_endog,ts);
}

/*-----------------------------------------------------------------------
  add_surface
  no sync of disc_func
  ----------------------------------------------------------------------*/
void swap_fixois.add_surface(tenor_surface option(nullable) tenor_surface) 
{	
	swap_gen.swap_add_surface_leg2(tenor_surface);
}

/*-----------------------------------------------------------------------
  add_curve_data_ois_leg
  ----------------------------------------------------------------------*/
void swap_fixois.add_curve_data_ois_leg(disc_func  df_disc,
										disc_func 	option(nullable) df_fwd,//only used if NOT endog_df
										logical sync_endog_ok) 	
{
	swap_gen.add_curve_data_ois_leg2(	df_disc,df_fwd,sync_endog_ok) ;
}

/*-----------------------------------------------------------------------
  add_curve_data_ois_leg
  ----------------------------------------------------------------------*/
void swap_fixois.add_curve_data_ois_leg(disc_func  df_disc,
										fwd_func option(nullable) f_fwd,	//fwd_func_fwd only used if NOT endog_df	
										logical sync_endog_ok) 																											
{

	swap_gen.add_curve_data_ois_leg2( df_disc, f_fwd,sync_endog_ok) ;
}
/*-----------------------------------------------------------------------
  add_curve_data
  ----------------------------------------------------------------------*/
void swap_fixois.add_curve_data(disc_func  df_disc,
								disc_func  option(nullable) df_disc_fix,
								fwd_func option(nullable) fwd_func_fwd, 	//only used if NOT endog_df
								logical sync_endog_ok)
{
	add_curve_data_ois_leg( df_disc, fwd_func_fwd,sync_endog_ok) ;
	
	if(!ccy_swap_){
		swap_gen.swap_add_disc_func_leg1(df_disc);
	}
	else{
		QL_REQUIRE(!null(df_disc_fix), "df_disc_fix required for cross currency swaps");
		swap_gen.swap_add_disc_func_leg1(df_disc_fix);
	}
}
/*-----------------------------------------------------------------------
  add_curve_data
  ----------------------------------------------------------------------*/
void swap_fixois.add_curve_data(disc_func  df_disc,
								disc_func  option(nullable) df_disc_fix,
								disc_func 	option(nullable) disc_func_fwd, 	//disc_func_fwd only used if NOT endog_df
								logical sync_endog_ok)
{
	add_curve_data_ois_leg( df_disc, disc_func_fwd,sync_endog_ok) ;
	
	if(!ccy_swap_) {
		swap_gen.swap_add_disc_func_leg1(df_disc);
	}
	else {
		QL_REQUIRE(!null(df_disc_fix), "df_disc_fix required for cross currency swaps");
		swap_gen.swap_add_disc_func_leg1(df_disc_fix);
	}
}
/*-----------------------------------------------------------------------
  curve_state  <hidden>
  ----------------------------------------------------------------------*/
void swap_fixois.curve_state(out disc_func df_fix, out disc_func df_ois, out tenor_surface ts_ois) option(hidden)
{
	error_info ee = new error_info(true,true);
	df_ois 	= this.disc_func_ois_leg(ee);
	df_fix 	= this.disc_func_fix_leg(ee);
	ts_ois	= this.tenor_surface_ois_leg(ee);//always null if approx AND endog_df
}
/*-----------------------------------------------------------------------
  add_curve_state <hidden>  here there is no checking of endog_df etc
  ----------------------------------------------------------------------*/
void swap_fixois.add_curve_state( disc_func option(nullable) df_fix,
								  disc_func option(nullable) df_ois,
								  tenor_surface option(nullable) ts_ois) option(hidden)
{
	error_info ee = new error_info(true,true);
	logical is_endog = this.is_endog_df(ee);
	logical is_approx = this.is_approx_calc(ee);

	
	if(is_endog && is_approx) {
		i().__swap_add_fixois_ext_data(null,df_fix,null, null, df_ois, null, null<tenor_surface>,null, null, null, true,false);		
	}
	else {//a surface 
		i().__swap_add_fixois_ext_data(null,df_fix,null, null, df_ois, null, ts_ois, null, null, null, true,false);
	}
}

/*-----------------------------------------------------------------------
  add_data  <hidden> CHECK ALL add_data for dependency on endogdf and proxycalc
  ----------------------------------------------------------------------*/
/*void swap_fixois.add_data(	number 			option(nullable) notional,
							disc_func 		option(nullable) disc_func,										
							tenor_surface 	option(nullable) tenor_surface_ois_leg,
							vector(date) 	option(nullable) fixing_dates_ois_leg,
							vector(number) 	option(nullable) fixings_ois_leg,
							logical option(nullable) fixing_as_fwd_ois_leg,
							logical upd_null_crv ,
							logical upd_null_fix ) option(hidden) //upd_nulls does not apply to notional
{
	
	error_info ee = new error_info(true,true);

	if(this.is_approx_calc(ee) && this.is_endog_df(ee))
		QL_FAIL("function not applicable for fixois with self-discounted ois-leg and approx calc",this,true);//surface redundant

	
	notional = conv_null_number_com(notional) ;
	i().__swap_add_fixois_data(notional,disc_func, tenor_surface_ois_leg,fixing_dates_ois_leg,
							   fixings_ois_leg, fixing_as_fwd_ois_leg, upd_null_crv,upd_null_fix);
	
	return ;				
}*/
/*void swap_fixois.add_data(	number 		option(nullable) notional,
							disc_func 	option(nullable) disc_func,										
							fwd_func 	option(nullable) fwd_func_ois_leg,
							vector(date) 	option(nullable) fixing_dates_ois_leg,
							vector(number) 	option(nullable) fixings_ois_leg,
							logical option(nullable) fixing_as_fwd_ois_leg,
							logical upd_null_crv ,
							logical upd_null_fix )//upd_nulls does not apply to notional
{
	error_info ee = new error_info(true,true);
	if(this.is_approx_calc(ee) && !this.is_endog_df(ee))
		QL_FAIL("function not applicable for fixois with non self-discounted ois-leg and approx calc",this,true);//surface needed
	
	logical is_endog = this.is_endog_df(ee);
	this.add_data(notional,disc_func,fwd_func_ois_leg,is_endog,fixing_dates_ois_leg,fixings_ois_leg,
				fixing_as_fwd_ois_leg,upd_null_crv,upd_null_fix );
}*/

/*void swap_fixois.add_data(	number 		option(nullable) notional,
							disc_func 	option(nullable) disc_func,										
							fwd_func 	option(nullable) fwd_func_ois_leg,
							//logical 					 is_endog,
							vector(date) 	option(nullable) fixing_dates_ois_leg,
							vector(number) 	option(nullable) fixings_ois_leg,
							logical option(nullable) fixing_as_fwd_ois_leg,
							logical upd_null_crv ,
							logical upd_null_fix )//upd_nulls does not apply to notional
{
	
	error_info ee = new error_info(true,true);

	logical is_endog = this.is_endog_df(ee);
	if(this.is_approx_calc(ee) && !is_endog)
		QL_FAIL("function not applicable for fixois with non self-discounted ois-leg and approx calc",this,true);
	
	notional = conv_null_number_com(notional) ;

	if(!is_endog) {
		i().__swap_add_fixois_data(notional,disc_func, fwd_func_ois_leg,fixing_dates_ois_leg,
							   fixings_ois_leg, fixing_as_fwd_ois_leg, upd_null_crv,upd_null_fix);
	}
	else if(null(disc_func) && null(fwd_func_ois_leg)){
		i().__swap_add_fixois_data(notional,disc_func, fwd_func_ois_leg,fixing_dates_ois_leg,
							   fixings_ois_leg, fixing_as_fwd_ois_leg, upd_null_crv,upd_null_fix);
	}	
	else if(!null(disc_func) && !null(fwd_func_ois_leg)){
		i().__swap_add_fixois_data(notional,disc_func, fwd_func_ois_leg,fixing_dates_ois_leg,
							   fixings_ois_leg, fixing_as_fwd_ois_leg, upd_null_crv,upd_null_fix);
	}
	else if(!null(fwd_func_ois_leg)) {	//disc_func is null
		error_info ee = new error_info(true,true);
		date m = maturity(ee);
		..ir_index idx = ir_index(ee);
		..disc_func df = CORE_INT.on_fwd_to_df(trade_date(),m,fwd_func_ois_leg,idx.day_count_method(),idx.fixing_calendar(),true);
		i().__swap_add_fixois_data(notional,df, fwd_func_ois_leg,fixing_dates_ois_leg,
								fixings_ois_leg, fixing_as_fwd_ois_leg, upd_null_crv,upd_null_fix);
	}
	else {//fwd_func_ois_leg is null
		error_info ee = new error_info(true,true);
		..ir_index idx = ir_index(ee);
		fwd_func f = fwd_func(disc_func,365,trade_date(),idx.day_count_method(),idx.fixing_calendar(),BD_FOLLOWING,false);
		i().__swap_add_fixois_data(notional,disc_func, f,fixing_dates_ois_leg,
								fixings_ois_leg, fixing_as_fwd_ois_leg, upd_null_crv,upd_null_fix);
	}
	return ;				
}*/
/*-----------------------------------------------------------------------
  add_ccy_data  CHECK ALL add_ccy_data for dependency on endogdf and proxycalc
  ----------------------------------------------------------------------*/
/*void swap_fixois.add_ccy_data(	number 	option(nullable)		notional_fix_leg,
								disc_func 						disc_func_fix_leg,
								number	option(nullable)		fx_mult_fix_leg,
								number option(nullable)			notional_ois_leg,
								disc_func 						disc_func_ois_leg,
								number	option(nullable)		fx_mult_ois_leg,
								tenor_surface  option(nullable)	tenor_surface_ois_leg,
								vector(date) option(nullable)	fixing_dates_ois_leg,
								vector(number) option(nullable)	fixings_ois_leg,
								logical option(nullable) 		fixing_as_fwd_ois_leg,
								logical upd_null_crv ,
							logical upd_null_fix ) option(hidden)//upd_nulls does not apply to notional 
{
	
	error_info ee = new error_info(true,true);
	if(this.is_approx_calc(ee) && this.is_endog_df(ee))
		QL_FAIL("function not applicable for fixois with self-discounted ois-leg and approx calc",this,true);//surface redundant
	
	i().__swap_add_fixois_ext_data(	notional_fix_leg,disc_func_fix_leg, fx_mult_fix_leg,notional_ois_leg,disc_func_ois_leg,
									fx_mult_ois_leg,tenor_surface_ois_leg,fixing_dates_ois_leg,fixings_ois_leg, fixing_as_fwd_ois_leg,
									upd_null_crv,upd_null_fix);
}
*/
/*void swap_fixois.add_ccy_data(	number 	option(nullable)		notional_fix_leg,
								disc_func 						disc_func_fix_leg,
								number	option(nullable)		fx_mult_fix_leg,
								number 	option(nullable)		notional_ois_leg,
								disc_func 						disc_func_ois_leg,
								number	option(nullable)		fx_mult_ois_leg,
								fwd_func 						fwd_func_ois_leg,
								vector(date) option(nullable)	fixing_dates_ois_leg,
								vector(number) option(nullable)	fixings_ois_leg,
								logical option(nullable) 		fixing_as_fwd_ois_leg,
								logical upd_null_crv ,
								logical upd_null_fix )//upd_nulls does not apply to notional 
{
	
	error_info ee = new error_info(true,true);
	if(this.is_approx_calc(ee) && !this.is_endog_df(ee))
		QL_FAIL("function not applicable for fixois with non self-discounted ois-leg and approx calc",this,true);//surface needed
	
	i().__swap_add_fixois_ext_data(	notional_fix_leg,disc_func_fix_leg, fx_mult_fix_leg,notional_ois_leg,disc_func_ois_leg,
									fx_mult_ois_leg,fwd_func_ois_leg,fixing_dates_ois_leg,fixings_ois_leg, fixing_as_fwd_ois_leg,
									upd_null_crv,upd_null_fix);
}
*/
/*-----------------------------------------------------------------------
  add_fixing
  ----------------------------------------------------------------------*/
void swap_fixois.add_fixing(	vector(date) fixing_dates,
								vector(number) fixings,
								logical option(nullable) fixing_as_fwd )
{

	swap_gen.swap_add_fixing_leg2(fixing_dates,fixings,fixing_as_fwd);						
}
void swap_fixois.add_fixing(	number fixing_proxy,
								logical option(nullable) fixing_as_fwd ) 
{

	swap_gen.swap_add_fixing_leg2(fixing_proxy, fixing_as_fwd);						
}

/*-----------------------------------------------------------------------
  create_tenor_surface_ois_leg	(fwd is a fwd_func)  EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_fixois.create_tenor_surface_ois_leg(disc_func option(nullable) fwddf,
													   fwd_func option(nullable) fwdf1d,
													   logical sync_endog_ok,
													   error_info option(nullable) error)
{
	return swap_gen.create_tenor_surface_ois_leg2(fwddf,fwdf1d,sync_endog_ok,error);
}

/*-----------------------------------------------------------------------
  set_date 		EXT SWAP: ok
  ext_swap: if trade date is the same --> the settle date will be preserved (if not input)
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois.set_date(	date  					trade_date, 
									date  option(nullable)	settle_date,
									error_info option(nullable) error )
{
	instrument cc;
	if(ext_swap_){
		logical re_init = false; 
		logical init_quote = false;
		cc = instrument._set_date(trade_date,settle_date,re_init,init_quote,error);
	}
	else{
		QL_FAIL_COND(!null(settle_date),"input of settlement date only supported for non-db swaps" ,this,true );
		logical re_init = true; 
		logical init_quote = true;
		cc = instrument._set_date(trade_date,settle_date,re_init,init_quote,error);
	}
	return null(cc) ? null<swap_fixois>: dynamic_cast<swap_fixois>(cc);
	
}

/*-----------------------------------------------------------------------
  set_date <protected>  EXT SWAP: ok	
	re_init for swaps means that updated disc_funcs, fixing data etc is not preserved
	ext_swap: if trade date is the same --> the settle date will be preserved (if not input)
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois.set_date(	date  				trade_date, 
									date  option(nullable)	settle_date,
									logical 			re_init, 
									logical 			re_init_quote, 
									error_info option(nullable) error)
{
	QL_FAIL_COND(ext_swap_ && (re_init || re_init_quote),"re_init/re_init_quote flags = true not supported for non-db swaps" ,this,true );
	QL_FAIL_COND(!ext_swap_ && !null(settle_date),"input of settlement date only supported for non-db swaps" ,this,true );
	instrument cc = instrument._set_date(trade_date,settle_date,true,re_init_quote,error);
	return null(cc) ? null<swap_fixois>: dynamic_cast<swap_fixois>(cc);
	
}

/*-----------------------------------------------------------------------
  set_date <protected/legacy>  EXT SWAP: ok
	re_init for swaps means that updated disc_funcs, fixing data etc is not preserved	
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois.set_date(	date  				trade_date, 
									logical 			re_init, 
									error_info option(nullable) error) 

{
	instrument cc;
	if(ext_swap_){
		QL_FAIL_COND(re_init,"re_init = true not supported for non-db swaps" ,this,true );
		logical init_quote = false;
		cc = instrument._set_date(trade_date,null<date>,re_init,init_quote,error);
	}
	else{		
		logical init_quote = true;
		cc = instrument._set_date(trade_date,null<date>,re_init,init_quote,error);
	}
	
	//instrument cc = instrument._set_date(trade_date,true,error);
	return null(cc) ? null<swap_fixois>: dynamic_cast<swap_fixois>(cc);	
}

/*-----------------------------------------------------------------------
   move_date  <protected/legacy>  EXT SWAP: ok
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	ext_swap: if trade date is the same --> the settle date will be preserved (if not input)
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois.move_date(	date  				trade_date, 
									date option(nullable) settle_date,
									error_info option(nullable) error) 
{
	QL_FAIL_COND(!ext_swap_ && !null(settle_date),"input of settlement date only supported for non-db swaps" ,this,true );
	instrument cc = instrument._move_date(trade_date,settle_date,error);
	return null(cc) ? null<swap_fixois>: dynamic_cast<swap_fixois>(cc);
}

/*-----------------------------------------------------------------------
  swap_fixois: set_quote   EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois.set_quote(	number 	option(nullable) quote,									
									error_info option(nullable) error)
{

	instrument cc = instrument._set_quote(quote,null<date>, null<date>, true,error);
	return null(cc) ? null<swap_fixois>: dynamic_cast<swap_fixois>(cc);
}

/*-----------------------------------------------------------------------
  swap_fixois: set_quote   EXT SWAP: will throw because of quote_side
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois.set_quote(	string 	option(nullable) quote_side,
									error_info option(nullable) error)
{

	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, true,error);
	return null(cc) ? null<swap_fixois>: dynamic_cast<swap_fixois>(cc);
}
/*-----------------------------------------------------------------------
  set_yield   FIX-OIS SWAP: yield == fix_cpn_rate
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois.set_yield(	number 	option(nullable) yield,							
									error_info option(nullable) error )
{
	QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);

	error_info ee 	= new error_info(true,false);
	number y 		= this.yield(false,ee);
	number cpnr 	= this.coupon_rate(ee);
	if(null(y) || null(cpnr) || CORE_INT.is_equal(y,cpnr))
		return this.set_rate_fix_leg(yield,error);
	
	QL_FAIL_COND(ext_swap_,"inapplicable function call for non-par swaps", this,true);	
}

/*-----------------------------------------------------------------------
  set_quote_from_yield
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois.set_quote_from_yield(number 	option(nullable) yield,
											error_info option(nullable) error)
{
	QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);

	error_info ee 	= new error_info(true,false);
	number y 		= this.yield(false,ee);
	number cpnr 	= this.coupon_rate(ee);
	if(null(y) || null(cpnr) || CORE_INT.is_equal(y,cpnr)) {		
		instrument cc = instrument._set_quote_from_yield(yield,  true,error);
		return null(cc) ? null<swap_fixois>: dynamic_cast<swap_fixois>(cc);
	}
	QL_FAIL_COND(ext_swap_,"inapplicable function call for non-par swaps", this,true);
}
/*-----------------------------------------------------------------------
  set_rate_fix_leg  EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois.set_rate_fix_leg(	number 	option(nullable) cpn_rate,							
											error_info option(nullable) error )
{
	try{

		if(!ext_swap_) {
			instrument cc = instrument._set_yield(	cpn_rate, null<date>, null<date>,true, error);
			return null(cc) ? null<swap_fixois>: dynamic_cast<swap_fixois>(cc);
		}

		error_info ee = new error_info(true,true);
		..quote_style qs = this.quote_style_e(ee);
		
		number q;
		if(qs == ..quote_style.YIELD_PCT)
			q = cpn_rate * 100;		
		__instrument  c = i().__swap_ext_set_quote(q, null<date>, null<date> );

		instr_error e = new instr_error();
		instrument cc 	= this.create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid swap_fixois", this, e);
		
		if(!cc.is_valid(error)) 
			return null<swap_fixois>;	
				
		return dynamic_cast<swap_fixois>(cc);					
	}	
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.set_rate_fix_leg");
		return null<swap_fixois>;
	}
}
/*-----------------------------------------------------------------------
  set_spread_ois_leg
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois.set_spread_ois_leg(number option(nullable) spread ,
										   error_info option(nullable) error)
{
	try{
		
		QL_REQUIRE(ext_swap_ ,"function only available for non-db swaps" ,this,true );
		
		__instrument  c = i().__swap_ext_set_spread_leg2(spread);

		instr_error e = new instr_error();
		instrument cc 	= this.create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid swap_fixois", this, e);
		
		if(!cc.is_valid(error)) 
			return null<swap_fixois>;	
				
		return dynamic_cast<swap_fixois>(cc);					
	}	
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.set_spread_ois_leg");
		return null<swap_fixois>;

	}
}


/*-----------------------------------------------------------------------
  set_pay_leg   --> returns an external swap, a db swap cannot be changed in regards to pay vs receive 
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois.set_pay_leg(logical pay_fix,							
									error_info option(nullable) error )
{
	try{

		__instrument  c = i().__swap_set_pay_leg1(pay_fix );
		
		instr_error e = new instr_error();
		instrument cc 	= this.create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid swap_fixois", this, e);
		
		if(!cc.is_valid(error)) 
			return null<swap_fixois>;	
				
		return dynamic_cast<swap_fixois>(cc);					
	}	
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.set_pay_leg");
		return null<swap_fixois>;
	}
}
/*-----------------------------------------------------------------------
  create_tenor_surface	(fwd is a disc_func) EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*tenor_surface swap_fixois.create_tenor_surface(disc_func df,disc_func fwddf) option(hidden)
{
	try{
		
		error_info ee 			= error_info(true,true);
		..ir_index ir			= this.ir_index(ee);
		CORE_INT.instr_fail_check(null(ir), "invalid ir_index", this, ee);
		
		logical allow_extrap 	= false;		
		tenor_surface ts 		= tenor_surface(this.trade_date(), df,[fwddf],[ir],allow_extrap);
		return ts;
	}
	catch {
		return null<tenor_surface>;
	}
}*/


/*-----------------------------------------------------------------------
  start_date	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
date  swap_fixois.start_date(error_info option(nullable) error ) 
{
	return this.issue_date(error);
}
/*-----------------------------------------------------------------------
  fx_mult	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.fx_mult_factor(	out number  fx_mult_fix_leg, 
							out number  fx_mult_ois_leg, 
							error_info option(nullable) error ) 
{	
	swap_gen.fx_mult_factor(fx_mult_fix_leg, fx_mult_ois_leg, error ) ;
	return;
}
/*-----------------------------------------------------------------------
  settle_code  EXT SWAP: ok
  ----------------------------------------------------------------------*/
string swap_fixois.settle_code(error_info option(nullable) error ) 
{	
	return swap_gen.settle_code(error);
}
/*-----------------------------------------------------------------------
  is_endog_df	EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical  swap_fixois.is_endog_df(error_info option(nullable) error ) 
{	
	try{
		error_info ee = error_info(true,true);		
		ql_ois_leg ois = this.ois_leg(false,ee);
		return ois.is_endog_df();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.is_endog_df");
		return null<logical >;
	}
}
/*-----------------------------------------------------------------------
  is_approx_calc	EXT SWAP: ok (defaults to true for all db swaps)
  ----------------------------------------------------------------------*/
logical  swap_fixois.is_approx_calc(error_info option(nullable) error ) 
{	
	try{
		error_info ee = error_info(true,true);		
		ql_ois_leg ois = this.ois_leg(false,ee);
		return ois.approx_calc();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.is_approx_calc");
		return null<logical >;
	}
}
/*-----------------------------------------------------------------------
  is_regular_first	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.is_regular_first(	out logical  is_reg_fix_leg, 
									out logical  is_reg_ois_leg, 
									error_info option(nullable) error ) 
{	
	try{
		error_info ee = error_info(true,true);
		
		ql_ois_leg ois = this.ois_leg(false,ee);
		is_reg_ois_leg = ois.is_reg_first_period();
		
		ql_fix_leg fix = this.fix_leg(false,ee);
		is_reg_fix_leg = fix.is_reg_first_period();
		
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.is_regular_first");
		is_reg_fix_leg = is_reg_ois_leg = null<logical >;
		return ;
	}
}

/*-----------------------------------------------------------------------
  is_regular_last	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.is_regular_last(	out logical  is_reg_fix_leg, 
									out logical  is_reg_ois_leg, 
									error_info option(nullable) error ) 
{	
	try{
		
		error_info ee = error_info(true,true);
		ql_ois_leg ois = this.ois_leg(false,ee);
		is_reg_ois_leg = ois.is_reg_last_period();
		
		ql_fix_leg fix = this.fix_leg(false,ee);
		is_reg_fix_leg = fix.is_reg_last_period();
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.is_regular_last");
		is_reg_fix_leg = is_reg_ois_leg = null<logical >;
		return ;
	}
}
/*-----------------------------------------------------------------------
  current_fixings_ois_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixois.current_fixings_ois_leg(	logical only_fixed,
											out vector(date) reset_dates,
											out vector(number) rates,
											out vector(logical) is_fixed,
											error_info option(nullable) error)
{
	try{
		error_info ee = error_info(true,true);
		ql_ois_leg ois = this.ois_leg(false,ee);
		ois.current_fixing_rates(only_fixed,reset_dates,rates,is_fixed);
		
		return ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.current_fixings_flt_leg");		
		return ;
	}
}
/*-----------------------------------------------------------------------
  notional	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.notional(	out number  notional_fix_leg, 
							out number  notional_ois_leg, 
							error_info option(nullable) error ) 
{	
	swap_gen.notional( notional_fix_leg,notional_ois_leg, error ) ;
	return;
}
/*-----------------------------------------------------------------------
  notional	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fixois.notional(error_info option(nullable) error ) 
{	
	return swap_gen.nominal(error);
}

/*-----------------------------------------------------------------------
  currency	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.currency(	out string  curr_fix_leg, 
							out string  curr_ois_leg, 
							error_info option(nullable) error ) 
{	
	swap_gen.currency(curr_fix_leg,  curr_ois_leg,  error);
	return;
}

/*-----------------------------------------------------------------------
  quote 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.quote(	out number  quote_fix_leg, 
							out number  spread_ois_leg, 
							error_info option(nullable) error ) 
{	
	swap_gen.quote(quote_fix_leg,  spread_ois_leg, error);
}
/*-----------------------------------------------------------------------
  quote   
  ----------------------------------------------------------------------*/
number  swap_fixois.quote(error_info option(nullable) error)

{	
	return swap_gen.quote(error);
}
/*-----------------------------------------------------------------------
  spread_ois_leg 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fixois.spread_ois_leg(error_info option(nullable) error ) 
{	
	try{
		
		instr_error_type t;
   		string 			s;
		number q,quote_ois_leg;
		i().__swap_def_quote(q,quote_ois_leg,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fixois.spread_ois_leg");
		if( e) {
			return null<number> ;
		}
		
		..quote_style qs = i().__swap_quote_style_e_leg2(t,s);
		e = CORE_INT.add_error_info(error,t,s, "swap_fixois.spread_ois_leg");
		if(e)
			return null<number>;
		
		switch(qs) {
			case ..quote_style.SPREAD:
				return quote_ois_leg;
			case ..quote_style.SPREAD_BP:					
			default:
				return quote_ois_leg/10000;
		}
							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.spread_ois_leg");
		return null<number> ;
	}
}
/*-----------------------------------------------------------------------
  coupon   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.coupon(	out number  cpn_fix_leg, 
							out number  cpn_ois_leg, 
							error_info option(nullable) error ) 
{	
	swap_gen.coupon(cpn_fix_leg,cpn_ois_leg,error);
	return;
}
/*-----------------------------------------------------------------------
  coupon_fix_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fixois.coupon_fix_leg(error_info option(nullable) error ) 
{	
	return swap_gen.coupon(error);
}

/*-----------------------------------------------------------------------
  ir_rule_sprd_leg
  ----------------------------------------------------------------------*/
interest_rule  swap_fixois.ir_rule_fix_leg(error_info option(nullable) error)
	{	
	interest_rule if1, if2;
	swap_gen.ir_rule(if1, if2,  error ) ;
	return if1;
}
/*-----------------------------------------------------------------------
  avg_method_ois_leg
  ----------------------------------------------------------------------*/
flt_avg_method  swap_fixois.avg_method_ois_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_avg_method_leg2(error) ;
}
/*-----------------------------------------------------------------------
  sprd_comp_method_ois_leg
  ----------------------------------------------------------------------*/
flt_sprd_comp_method  swap_fixois.sprd_comp_method_ois_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_sprd_comp_method_leg2(error) ;
}
/*-----------------------------------------------------------------------
  comp_avg_type_ois_leg
  ----------------------------------------------------------------------*/
flt_comp_avg_type  swap_fixois.comp_avg_type_ois_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_comp_avg_type_leg2(error) ;
}

/*-----------------------------------------------------------------------
  rfr_arrears_type_ois_leg
  ----------------------------------------------------------------------*/
rfr_arrears_type  swap_fixois.rfr_arrears_type_ois_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_rfr_arr_type_leg2(error) ;
}
/*-----------------------------------------------------------------------
  rfr_arrears_type_ois_leg
  ----------------------------------------------------------------------*/
integer  swap_fixois.rfr_arrears_days_ois_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_rfr_arr_days_leg2(error) ;
}
/*-----------------------------------------------------------------------
  ir_rule_flat_leg
  ----------------------------------------------------------------------*/
interest_rule  swap_fixois.ir_rule_ois_leg(error_info option(nullable) error)
	{	
	interest_rule if1, if2;
	swap_gen.ir_rule(if1, if2,  error ) ;
	return if2;
}
/*-----------------------------------------------------------------------
  dc_method   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.dc_method(	out day_count_method  dc_method_fix_leg, 
								out day_count_method  dc_method_ois_leg, 
								error_info option(nullable) error ) 
{	
	swap_gen.dc_method(dc_method_fix_leg,dc_method_ois_leg,error);
	return;
}
/*-----------------------------------------------------------------------
  currency_ois_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
string swap_fixois.currency_ois_leg( error_info option(nullable) error ) 
{
	string c,  curr_ois_leg;
	swap_gen.currency(c,  curr_ois_leg,  error);
	return curr_ois_leg;

}
/*-----------------------------------------------------------------------
  effective_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.effective_date(	out date  effective_date_fix_leg, 
									out date  effective_date_ois_leg, 
									error_info option(nullable) error) 
{
	swap_gen.effective_date(effective_date_fix_leg,effective_date_ois_leg,error);
	return;
}

/*-----------------------------------------------------------------------
  next_cpn_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.next_cpn_date(	out date  next_cpn_date_fix_leg, 
									out date  next_cpn_date_ois_leg, 
									error_info option(nullable) error) 
{
	swap_gen.next_cpn_date(next_cpn_date_fix_leg,next_cpn_date_ois_leg,error) ;
	return;
}
/*-----------------------------------------------------------------------
  previous_cpn_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.previous_cpn_date(out date  prev_cpn_date_fix_leg, 
									out date  prev_cpn_date_ois_leg, 
									error_info option(nullable) error) 
{
	swap_gen.previous_cpn_date(prev_cpn_date_fix_leg,prev_cpn_date_ois_leg,error) ;
	return;
}
/*-----------------------------------------------------------------------
  coupon_freq   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.coupon_freq(	out integer  cpn_freq_fix_leg, 
								out integer  cpn_freq_ois_leg, 
								error_info option(nullable) error ) 
{	
	swap_gen.coupon_freq(cpn_freq_fix_leg,cpn_freq_ois_leg,error);
	return;
}
/*-----------------------------------------------------------------------
  first_cpn_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.first_cpn_date(	out date  first_cpn_date_fix_leg, 
									out date  first_cpn_date_ois_leg, 
									error_info option(nullable) error) 
{
	swap_gen.first_cpn_date(first_cpn_date_fix_leg,first_cpn_date_ois_leg,error);
	return;
}

/*-----------------------------------------------------------------------
  last_reg_cpn_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.last_reg_cpn_date(out date  last_reg_cpn_date_fix_leg, 
									out date  last_reg_cpn_date_ois_leg, 
									error_info option(nullable) error) 
{
	swap_gen.last_reg_cpn_date(last_reg_cpn_date_fix_leg,last_reg_cpn_date_ois_leg,error);
	return;
}

/*-----------------------------------------------------------------------
  reset_freq_ois_leg	
  ----------------------------------------------------------------------*/
integer  swap_fixois.reset_freq_ois_leg(error_info option(nullable) error ) 
{
	return 365;
}

/*-----------------------------------------------------------------------
  roll_day   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.roll_day(	out integer  roll_day_fix_leg, 
							out integer  roll_day_ois_leg, 
							error_info option(nullable) error ) 
{	
	swap_gen.roll_day(roll_day_fix_leg,roll_day_ois_leg,error);
	return;
}

/*-----------------------------------------------------------------------
  eom   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.eom(	out logical   	eom_fix_leg, 
						out logical  	eom_ois_leg, 
						error_info option(nullable) 	error ) 
{	
	swap_gen.eom(eom_fix_leg, eom_ois_leg,  error ) ;
	return;
}

/*-----------------------------------------------------------------------
  cal   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.calendar(	out ..calendar option(nullable)  cal_fix_leg, 
							out ..calendar option(nullable) cal_ois_leg, 
							error_info option(nullable) error ) 
{	
	swap_gen.calendar(cal_fix_leg, cal_ois_leg,  error ) ;
	return;
}

/*-----------------------------------------------------------------------
  calendar_name   	
  ----------------------------------------------------------------------*/
void  swap_fixois.calendar_name(out string  cal_name_fix_leg, 
								out string  cal_name_ois_leg, 
								error_info option(nullable) error ) 
{	
	swap_gen.calendar_name(cal_name_fix_leg, cal_name_ois_leg,  error );
	return;
}
/*-----------------------------------------------------------------------
  pmt_lag   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.pmt_lag(	out	integer 	pmt_lag_fix_leg,
							out	integer 	mat_pmt_lag_fix_leg,
							out	integer 	pmt_lag_prin_fix_leg,
							out	integer 	mat_pmt_lag_prin_fix_leg,
							out	integer 	pmt_lag_ois_leg,
							out	integer 	mat_pmt_lag_ois_leg,
							out	integer 	pmt_lag_prin_ois_leg,
							out	integer 	mat_pmt_lag_prin_ois_leg,	
							error_info option(nullable) error) 
{
	swap_gen.swap_pmt_lag(	pmt_lag_fix_leg, mat_pmt_lag_fix_leg, pmt_lag_prin_fix_leg, mat_pmt_lag_prin_fix_leg,
								pmt_lag_ois_leg, mat_pmt_lag_ois_leg, pmt_lag_prin_ois_leg, mat_pmt_lag_prin_ois_leg,error);
	return;
}


/*-----------------------------------------------------------------------
  pmt_bus_day 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.pmt_bus_day(	out bd_convention pmt_bus_day_fix_leg, 
								out bd_convention pmt_bus_day_ois_leg, 
								error_info option(nullable) error ) 
{	
	swap_gen.pmt_bus_day(pmt_bus_day_fix_leg, pmt_bus_day_ois_leg,  error ) ;
	return;
}
/*-----------------------------------------------------------------------
  dc_method   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
day_count_method  swap_fixois.dc_method_ois_leg( error_info option(nullable) error ) 
{
	day_count_method d,dc_method_ois_leg;
	swap_gen.dc_method(d,dc_method_ois_leg,error);
	return dc_method_ois_leg;
}
/*-----------------------------------------------------------------------
  is_cross_currency
  ----------------------------------------------------------------------*/
logical	 swap_fixois.is_cross_currency(error_info option(nullable) error )
{
	try{
		QL_FAIL_COND(null(ccy_swap_),"init error");
		return ccy_swap_;	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.is_cross_currency");
		return null<logical>;
	}
}
/*-----------------------------------------------------------------------
  accr_dates_fix_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.accr_dates_fix_leg(	logical 			post_settle, 
										out vector(date) 	accr_start_date,									
										out vector(date) 	accr_end_date,
										out vector(number)  accr_period,
										error_info option(nullable)  error ) 
{	
	vector(date) accr_start_date_leg2;
	vector(date) accr_end_date_leg2;
	vector(number) accr_period_leg2;
	swap_gen.accr_dates(post_settle, accr_start_date,accr_end_date,accr_period,
						accr_start_date_leg2,accr_end_date_leg2,accr_period_leg2, error ) ;
	return;
}
/*-----------------------------------------------------------------------
  accr_dates_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.accr_dates_ois_leg(	logical 		post_settle, 
									out vector(date) 	accr_start_date,									
									out vector(date) 	accr_end_date,
									out vector(number)  accr_period,
									error_info option(nullable) 		error ) 
{	
	vector(date) accr_start_date_leg1;
	vector(date) accr_end_date_leg1;
	vector(number) accr_period_leg1;
	swap_gen.accr_dates(post_settle, accr_start_date_leg1,accr_end_date_leg1,accr_period_leg1,
						accr_start_date,accr_end_date,accr_period, error ) ;
	return;
}
/*-----------------------------------------------------------------------
  index_dates_ois_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.index_dates_ois_leg(	logical 			post_settle,
										logical 			all_dates,
										out vector(date) 	index_start_dates,									
										out vector(date) 	index_end_dates,
										out vector(logical)  index_regular,
										error_info option(nullable) 		error ) 
{	
	try{
		
		instr_error_type t;
   		string 			s;	
		i().__swap_index_dates(post_settle,index_start_dates,index_end_dates,index_regular, false,all_dates,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fixois.index_dates_flt_leg");
		if(e) {
			index_start_dates = index_end_dates = null<vector(date)>; 
			index_regular = null<vector(logical)>;
		}			
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.index_dates_flt_leg");
		index_start_dates = index_end_dates = null<vector(date)>; 
		index_regular = null<vector(logical)>; 
		return ;
	}
}
/*-----------------------------------------------------------------------
  fixing_data_ois_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.fixing_data_ois_leg(	logical 					post_trade_date,
										logical option(nullable)	only_fixed, 
										out vector(date)  			reset_date,									
										out vector(number)  		rate,
										out vector(logical)  		is_fixed,
										error_info option(nullable) 		error ) 
{	
	try{
		error_info ee = error_info(true,true);
		ql_ois_leg ois = this.ois_leg(false,ee);
		
		date cut_off = post_trade_date ? this.trade_date(): null<date>;
		ois.fixing_data(only_fixed,reset_date,rate,is_fixed,cut_off);

		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.fixing_data_flt_leg");
		reset_date = null<vector(date)>; 
		rate = null<vector(number)>; 
		is_fixed = null<vector(logical)>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  cash_flow_dates	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.cash_flow_dates(	logical 			post_settle, 
									out vector(date) 	pmt_dates_fix_leg,									
									out vector(date) 	pmt_dates_ois_leg,
									error_info option(nullable) error ) 
{	
	swap_gen.cash_flow_dates(post_settle, pmt_dates_fix_leg,pmt_dates_ois_leg,error ) ;
	return;
}

/*-----------------------------------------------------------------------
  cash_flows_cpn	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.cash_flows_cpn(	logical 			post_settle, 
									out vector(number) 	cpn_cf_fix_leg,									
									out vector(number) 	cpn_cf_ois_leg,
									error_info option(nullable) error ) 
{	
	swap_gen.cash_flows_cpn(	post_settle, cpn_cf_fix_leg,cpn_cf_ois_leg,error );
	return;
}

/*-----------------------------------------------------------------------
  cash_flows	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.cash_flows(	logical 			post_settle, 
								out vector(number) 	cf_fix_leg,									
								out vector(number) 	cf_ois_leg,
								error_info option(nullable) error ) 
{	
	swap_gen.cash_flows(post_settle, cf_fix_leg,cf_ois_leg,error ) ;
	return;
}
/*-----------------------------------------------------------------------
  cash_flow_data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.cash_flow_data(	logical 			post_settle,
									ir_cf_code 			cf_code, 
									out vector(date) 	pmt_dates_fix_leg,									
									out vector(number)  cf_fix_leg,
									out vector(date) 	pmt_dates_ois_leg,									
									out vector(number) 	cf_ois_leg,
									error_info option(nullable) 		error ) 
{	
	swap_gen.cash_flow_data(	post_settle,cf_code, pmt_dates_fix_leg,cf_fix_leg,pmt_dates_ois_leg,cf_ois_leg, error );
	return;
}

/*-----------------------------------------------------------------------
  cash_flow_data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.cash_flow_data(logical 			post_settle,
								logical option(nullable) trade_date_pv,
								out vector(date)  	pmt_date_fix_leg,
								out vector(number)  cpn_rate_fix_leg,
								out vector(number)  cpn_cashflow_fix_leg,
								out vector(number)  pv_cpn_cashflow_fix_leg,
								out vector(number)  fee_fix_leg,
								out vector(number)  pv_fee_fix_leg,
								out vector(number)  notional_fix_leg,
								out vector(date)  	pmt_date_ois_leg,
								out vector(number)  cpn_rate_ois_leg,
								out vector(number)  cpn_cashflow_ois_leg,
								out vector(number)  pv_cpn_cashflow_ois_leg,
								out vector(number)  fee_ois_leg,
								out vector(number)  pv_fee_ois_leg,
								out vector(number)  notional_ois_leg,
								error_info option(nullable) 		error ) 
{	
	swap_gen.cash_flow_data(	post_settle,trade_date_pv,pmt_date_fix_leg,cpn_rate_fix_leg,cpn_cashflow_fix_leg,pv_cpn_cashflow_fix_leg,
					fee_fix_leg,pv_fee_fix_leg,notional_fix_leg,pmt_date_ois_leg,cpn_rate_ois_leg,cpn_cashflow_ois_leg,
					pv_cpn_cashflow_ois_leg,fee_ois_leg,pv_fee_ois_leg,notional_ois_leg, error );
}
/*-----------------------------------------------------------------------
  data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.data(	out swap_fix_leg_data fix_leg_data,
						out swap_ois_leg_data	ois_leg_data,
						error_info option(nullable) error )
{
	try{
		error_info ee = new error_info(true,true);
		vector(ql_swap_leg) l = legs(false,ee);
		fix_leg_data = new swap_fix_leg_data(l[0]);
		ois_leg_data = new swap_ois_leg_data(l[1],true);
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.data");
		fix_leg_data = null<swap_fix_leg_data>;
		ois_leg_data = null<swap_ois_leg_data>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.data(	out swap_fix_leg_data fix_leg_data,
						error_info option(nullable) error )
{
	try{
		error_info ee = new error_info(true,true);
		vector(ql_swap_leg) l = legs(false,ee);
		fix_leg_data = new swap_fix_leg_data(l[0]);
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.data");
		fix_leg_data = null<swap_fix_leg_data>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.data(	out swap_ois_leg_data	ois_leg_data,
						error_info option(nullable) error )
{
	try{
		error_info ee = new error_info(true,true);
		vector(ql_swap_leg) l = legs(false,ee);
		ois_leg_data = new swap_ois_leg_data(l[1],true);
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.data");
		ois_leg_data = null<swap_ois_leg_data>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  accrued	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fixois.accrued(logical 					in_pcnt,
							out number  accr_fix_leg,									
							out number  accr_ois_leg,
							error_info option(nullable) error ) 
option(com_name: 'accrued_ext')
{	
	return swap_gen.accrued(in_pcnt, accr_fix_leg, accr_ois_leg, error ) ;
}

/*-----------------------------------------------------------------------
  accrued_period  EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixois.accrued_period(	out number  period_fix_leg,
									out number  period_ois_leg,
									out integer 				n_days_fix_leg,
									out integer 				n_days_ois_leg,
									error_info option(nullable) error ) 
{	
	swap_gen.accrued_period(period_fix_leg,period_ois_leg,n_days_fix_leg,n_days_ois_leg, error ) ;
	return;
}
/*-----------------------------------------------------------------------
  accrued_chg  EXT SWAP: ok
  Note: designed for 1 day (or few days) since only one cpn can "fall off"
  ----------------------------------------------------------------------*/
number swap_fixois.accrued_chg  (	integer 					bus_days,
									out number 	ai_chg_fix_leg,
									out number 	ai_chg_ois_leg,
									out number 	cpn_cashflow_fix_leg,
									out number 	cpn_cashflow_ois_leg,
									out date  settle,
									out date  settle_next,	
									error_info option(nullable) error ) 
{	
	return swap_gen.accrued_chg(bus_days,ai_chg_fix_leg,ai_chg_ois_leg,cpn_cashflow_fix_leg,cpn_cashflow_ois_leg,
								settle,settle_next,	error);
}

/*-----------------------------------------------------------------------
  df_shifted_ois_leg  prot
  ----------------------------------------------------------------------*/
disc_func swap_fixois.df_shifted_ois_leg(number 	delta_disc,
										disc_func 	df)
{
	
	if(delta_disc == 0)
		return df;

	error_info ee = new error_info(true,true);
	
	vector(date) index_start_dates,index_end_dates;
	vector(logical) index_regular;
	this.index_dates_ois_leg(true, true,index_start_dates,index_end_dates,index_regular,ee);		
	day_count_method dc = this.ir_index(ee).day_count_method();
					
	disc_func df_shifted = CORE_INT.fwd_parallell_shift_df(	df, delta_disc, this.trade_date(), index_start_dates, index_end_dates, dc);
	return df_shifted;
	
}
/*-----------------------------------------------------------------------
  fwd_shifted_ois_leg		
  ----------------------------------------------------------------------*/
fwd_func swap_fixois.fwd_shifted_ois_leg(number 	delta_fwd,
										fwd_func 	fwdf)
{	
	if(delta_fwd == 0)
		return fwdf;
	fwd_func fwd_delta = CORE_INT.fwd_parallell_shift_f(fwdf,delta_fwd);
	return fwd_delta;
}
/*-----------------------------------------------------------------------
  fwd_shifted_ois_leg		
  ----------------------------------------------------------------------*/
tenor_surface swap_fixois.fwd_shifted_ois_leg(	number 			delta_fwd,
												disc_func 		df,							
												tenor_surface 	ts)
{	
	if(delta_fwd == 0)
		return ts;

	QL_REQUIRE(!ts.fwd_is_disc_func(),"tenor surface must be created with fwd_func");
	
	error_info ee = new error_info(true,true);
	tenor_code tc 	= this.index_tenor_code(ee);
	tenor_surface ts_delta;
		
	fwd_func  fwdf 			= ts.fwd_curve_f(tc);//note: for all combinations of endog_df and approx_calc we have a 1d-fwdfunc
	fwd_func fwd_delta 		= fwd_shifted_ois_leg(delta_fwd, fwdf);
	if(this.is_endog_df(ee))
		ts_delta 				= create_tenor_surface_ois_leg( null,fwd_delta, true);
	else
		ts_delta 				= create_tenor_surface_ois_leg( df,fwd_delta, true);				
	
	return ts_delta;
}



module CORE_INT_FIXOIS
{
	/*-----------------------------------------------------------------------
	  risk_ladder_fwd_fixois
	  ----------------------------------------------------------------------*/
	void  risk_ladder_fwd_fixois(	swap_fixois 		sw,
									logical 			payfix,
									number 				nominal,
									vector(fwd_func) 	f_v_pert,
									fwd_func 			f_base,
									fwd_func option(nullable) f_all,
									out vector(number) 	pv_diff_pert,
									out number 			pv_diff_all,
									number 				y_shift,									
									error_info option(nullable) error ) 
	{
		logical IS_DEBUG = true;
		
		error_info ee 			= new error_info(true,true);
		logical instr_payfix 	= sw.pay_fix(ee);
		number sign 			= payfix == instr_payfix ? 1.0: -1.0;
		
		disc_func dfois_orig,dffix_orig ;
		tenor_surface ts_orig;
		sw.curve_state(dffix_orig,dfois_orig,ts_orig );		
		//fwd_func ff_orig 		= sw.fwd_func_ois_leg(ee);
	
		QL_FAIL_COND(null(dffix_orig), "disc_func for fixed leg not set", sw.name(), true);
		QL_FAIL_COND(null(dfois_orig), "disc_func for ois leg not set", sw.name(), true);
		QL_FAIL_COND(null(ts_orig), "tenor surface for ois leg not set", sw.name(), true);

		logical is_ccy			= sw.is_ccy_swap(ee);
		logical is_endog_df		= sw.is_endog_df(ee);
		
		number nom 				= sw.nominal(ee);
		number scale_nom 		= nominal/nom;
		number shift_mult 		= 0.0001 / y_shift;	
		logical trade_date_pv 	= false;
		number mult 			= sign*scale_nom*shift_mult;
			
		integer size 			= v_size(f_v_pert);
		resize(pv_diff_pert,size);
		pv_diff_pert 			= 0;

		disc_func __df;
		tenor_surface __ts;
		sw.add_fwd_func(f_base,true,__df, __ts);//if endog_df we will also update disc_func for ois leg here
		__df = null;//must reset __df to null to prevent reuse
		if(!is_ccy && is_endog_df)
			sw.add_disc_func_fix_leg(sw.disc_func_ois_leg(ee));//update fix leg if needed
		
		number pv_fix,pv_ois;
		number pv_base 	= sw.present_value(pv_fix,pv_ois,trade_date_pv,ee);	
		
		vector(date) 	reset_date;
		vector(number)  rate;
		vector(logical)  is_fixed;
			
		if(IS_DEBUG) {			
			sw.fixing_data_ois_leg(	false,false,  reset_date, rate, is_fixed, ee );
		}
		
		for(integer i=0;i<size;i++){
			QL_FAIL_COND(null(f_v_pert[i]), "fwd_func in vector not valid", sw.name(), true);
				
			sw.add_fwd_func(f_v_pert[i],true,__df, __ts);
			__df = null;//must reset __df to null to prevent reuse
			if(!is_ccy && is_endog_df)
				sw.add_disc_func_fix_leg(sw.disc_func_ois_leg(ee));

			if(IS_DEBUG) {
				sw.fixing_data_ois_leg(	false,false,  reset_date, rate, is_fixed, ee );
			}
			
			number pvi 		= sw.present_value(pv_fix,pv_ois,trade_date_pv,ee);
			pv_diff_pert[i] = (pvi - pv_base)*mult;			
		
		}
		if(!null(f_all)){
				
			sw.add_fwd_func(f_all,true,__df, __ts);
			__df = null;//must reset __df to null to prevent reuse
			if(!is_ccy && is_endog_df)
				sw.add_disc_func_fix_leg(sw.disc_func_ois_leg(ee));
			
			number pv_all 	= sw.present_value(pv_fix,pv_ois,trade_date_pv,ee);
			pv_diff_all 	= (pv_all - pv_base)*mult;
		}
		else {
			pv_diff_all = null<number>;
		}

		sw.add_curve_state(dffix_orig,dffix_orig,ts_orig );
	}

	/*-----------------------------------------------------------------------
	  risk_ladder_fwd_fixois
	  ----------------------------------------------------------------------*/
	void  risk_ladder_fwd_fixois(	swap_fixois 		sw,
									logical 			payfix,
									number 				nominal,
									vector(disc_func) 	df_v_pert,
									disc_func 			df_base,
									disc_func option(nullable) df_all,
									out vector(number) 	pv_diff_pert,
									out number 			pv_diff_all,
									number 				y_shift,									
									error_info option(nullable) error ) 
	{
		logical IS_DEBUG = true;
		
		error_info ee 			= new error_info(true,true);
		logical instr_payfix 	= sw.pay_fix(ee);
		number sign 			= payfix == instr_payfix ? 1.0: -1.0;
		
		disc_func dfois_orig,dffix_orig ;
		tenor_surface ts_orig;
		sw.curve_state(dffix_orig,dfois_orig,ts_orig );		
		
		//fwd_func ff_orig 		= sw.fwd_func_ois_leg(ee);		
		QL_FAIL_COND(null(dffix_orig), "disc_func for fixed leg not set", sw.name(), true);
		QL_FAIL_COND(null(dfois_orig), "disc_func for ois leg not set", sw.name(), true);
		QL_FAIL_COND(null(ts_orig), "tenor surface for ois leg not set", sw.name(), true);

		logical is_ccy			= sw.is_ccy_swap(ee);
		logical is_endog_df		= sw.is_endog_df(ee);
		
		number nom 				= sw.nominal(ee);
		number scale_nom 		= nominal/nom;
		number shift_mult 		= 0.0001 / y_shift;	
		logical trade_date_pv 	= false;
		number mult 			= sign*scale_nom*shift_mult;
			
		integer size 			= v_size(df_v_pert);
		resize(pv_diff_pert,size);
		pv_diff_pert 			= 0;

		tenor_surface __ts;
		sw.add_fwd_from_disc_func(df_base,true,__ts);//if endog_df we will also update disc_func for ois leg here
		if(!is_ccy && is_endog_df)
			sw.add_disc_func_fix_leg(sw.disc_func_ois_leg(ee));//update fix leg if needed
		
		number pv_fix,pv_ois;
		number pv_base 	= sw.present_value(pv_fix,pv_ois,trade_date_pv,ee);	
		
		vector(date) 	reset_date;
		vector(number)  rate;
		vector(logical)  is_fixed;
			
		if(IS_DEBUG) {			
			sw.fixing_data_ois_leg(	false,false,  reset_date, rate, is_fixed, ee );
		}
		
		for(integer i=0;i<size;i++){
			QL_FAIL_COND(null(df_v_pert[i]), "fwd_func in vector not valid", sw.name(), true);

			
			sw.add_fwd_from_disc_func(df_v_pert[i],true,__ts);
			if(!is_ccy && is_endog_df)
				sw.add_disc_func_fix_leg(sw.disc_func_ois_leg(ee));

			if(IS_DEBUG) {
				sw.fixing_data_ois_leg(	false,false,  reset_date, rate, is_fixed, ee );
			}
			
			number pvi 		= sw.present_value(pv_fix,pv_ois,trade_date_pv,ee);
			pv_diff_pert[i] = (pvi - pv_base)*mult;			
		
		}
		if(!null(df_all)){
			sw.add_fwd_from_disc_func(df_all,true,__ts);
			if(!is_ccy && is_endog_df)
				sw.add_disc_func_fix_leg(sw.disc_func_ois_leg(ee));
			
			number pv_all 	= sw.present_value(pv_fix,pv_ois,trade_date_pv,ee);
			pv_diff_all 	= (pv_all - pv_base)*mult;
		}
		else {
			pv_diff_all = null<number>;
		}

		sw.add_curve_state(dffix_orig,dffix_orig,ts_orig );
	}
	/*-----------------------------------------------------------------------
	  risk_ladder_disc_fixois
	  Note:   ONLY ois leg disc_func ladder if ccy swap
	  ----------------------------------------------------------------------*/
	void  risk_ladder_disc_fixois(	swap_fixois 		sw,
									logical 			payfix,
									number 				nominal,
									//fwd_func option(nullable) f,//use??
									vector(disc_func) 	df_v_pert,
									disc_func 			df_base,
									disc_func option(nullable) df_all,
									out vector(number) 	pv_diff_pert,
									out number 			pv_diff_all,
									number 				y_shift,
									error_info option(nullable) error ) 
	{
		error_info ee 			= new error_info(true,true);
		logical instr_payfix 	= sw.pay_fix(ee);
		number sign 			= payfix == instr_payfix ? 1.0: -1.0; 

		disc_func dfois_orig,dffix_orig ;
		tenor_surface ts_orig;		
		sw.curve_state(dffix_orig,dfois_orig,ts_orig );
				
		QL_FAIL_COND(null(dffix_orig), "disc_func for fixed leg not set", sw.name(), true);
		QL_FAIL_COND(null(dfois_orig), "disc_func for ois leg not set", sw.name(), true);
		QL_FAIL_COND(null(ts_orig), "tenor surface for ois leg not set", sw.name(), true);

		logical is_ccy			= sw.is_ccy_swap(ee);
		number nom 				= sw.nominal(ee);
		number scale_nom 		= nominal/nom;
		number shift_mult 		= 0.0001 / y_shift;	
		logical trade_date_pv 	= false;
		number mult 			= sign*scale_nom*shift_mult;
		
		integer size 			= v_size(df_v_pert);
		resize(pv_diff_pert,size);
		pv_diff_pert 			= 0;

		//---set base---
		tenor_surface ts;
		sw.add_disc_func_ois_leg(df_base,true, ts);//the surface will be updated if endog_df = true
		if(!is_ccy)
			sw.add_disc_func_fix_leg(df_base);

		number pv_fix,pv_ois;
		number pv_base 			= sw.present_value(pv_fix,pv_ois,trade_date_pv,ee);	
		
		for(integer i=0;i<size;i++){
			
			QL_FAIL_COND(null(df_v_pert[i]), "disc_func in vector not valid", sw.name(), true);
			sw.add_disc_func_ois_leg(df_v_pert[i],true,ts);
			if(!is_ccy)
				sw.add_disc_func_fix_leg(df_v_pert[i]);
			
			number pvi 		= sw.present_value(pv_fix,pv_ois,trade_date_pv,ee);			
			pv_diff_pert[i] = (pvi - pv_base)*mult;			
		
		}
		if(!null(df_all)){

			sw.add_disc_func_ois_leg(df_all,true,ts);
			if(!is_ccy)
				sw.add_disc_func_fix_leg(df_all);
			
			number pv_all 	= sw.present_value(pv_fix,pv_ois,trade_date_pv,ee);			
			pv_diff_all 	= (pv_all - pv_base)*mult;
		}
		else {
			pv_diff_all = null<number>;
		}

		sw.add_curve_state(dffix_orig,dffix_orig,ts_orig );

	}
	/*-----------------------------------------------------------------------
	  risk_ladder_fixois  this is a risk ladder for fwd rates
	  ----------------------------------------------------------------------*/
	/*void  risk_ladder_fixois(	swap_fixois 		sw,
								logical 			payfix,
								number 				nominal,
								vector(fwd_func) 	f_v_pert,
								fwd_func 			f_base,
								fwd_func option(nullable) f_all,						
								out vector(number) 	pv_diff_pert,
								out number 			pv_diff_all,
								number 				y_shift,
								error_info option(nullable) error ) 
	{
		

		risk_ladder_fwd_fixois(sw,payfix,nominal,f_v_pert,f_base,f_all,pv_diff_pert,pv_diff_all,y_shift,error );

		
		error_info ee 			= new error_info(true,true);
		logical is_endog_df		= sw.is_endog_df(ee);
		if(is_endog_df) {
			risk_ladder_fwd_fixois(sw,payfix,nominal,f_v_pert,f_base,f_all,pv_diff_pert,pv_diff_all,y_shift,error );
			return;
		}

		QL_FAIL("work in progress", sw, true);	
	}*/
	
	/*-----------------------------------------------------------------------
	  risk_ladder_fixois  this is a risk ladder for fwd rates (but with disc_func input)
	  ----------------------------------------------------------------------*/
	/*void  risk_ladder_fixois(	swap_fixois 		sw,
								logical 			payfix,
								number 				nominal,
								vector(disc_func) 	df_v_pert,
								disc_func 			df_base,
								disc_func option(nullable) df_all,						
								out vector(number) 	pv_diff_pert,
								out number 			pv_diff_all,
								number 				y_shift,
								error_info option(nullable) error ) 
	{
		
		risk_ladder_fwd_fixois(sw,payfix,nominal,df_v_pert,df_base,df_all,pv_diff_pert,pv_diff_all,y_shift,error );
		
		/*error_info ee 			= new error_info(true,true);
		logical is_endog_df		= sw.is_endog_df(ee);

		if(is_endog_df) {
			risk_ladder_disc_fixois(sw,payfix,nominal,df_v_pert,df_base,df_all,pv_diff_pert,pv_diff_all,y_shift,error );
			return;
		}

		logical instr_payfix 	= sw.pay_fix(ee);
		number sign 			= payfix == instr_payfix ? 1.0: -1.0;

		disc_func dfois_orig,dffix_orig ;
		tenor_surface ts_orig;		
		sw.curve_state(dffix_orig,dfois_orig,ts_orig );
		
		logical is_ccy			= sw.is_ccy_swap(ee);		
		//logical ts_na 			= sw.is_approx_calc(ee) && is_endog_df;
		
		QL_FAIL_COND(null(dffix_orig), "disc_func for fixed leg not set", sw.name(), true);
		QL_FAIL_COND(null(dfois_orig), "disc_func for ois leg not set", sw.name(), true);
		QL_FAIL_COND(null(ts_orig), "tenor surface for ois leg not set", sw.name(), true);
		
		..ir_index idx 			= sw.ir_index(ee);
		
		number nom 				= sw.nominal(ee);
		number scale_nom 		= nominal/nom;
		number shift_mult 		= 0.0001 / y_shift;	
		logical trade_date_pv 	= false;
		number mult 			= sign*scale_nom*shift_mult;
		
		integer size 			= v_size(df_v_pert);
		resize(pv_diff_pert,size);
		pv_diff_pert 			= 0;

		//---set base---
		//sw.add_disc_func(df_base);
		sw.add_disc_func_ois_leg(df_base);		
		fwd_func f = fwd_func(df_base,365,sw.trade_date(ee),idx.day_count_method(),idx.fixing_calendar(),BD_FOLLOWING,false);
		sw.add_fwd_func(f);
		if(!is_ccy)
			sw.add_disc_func_fix_leg(df_base);
	
		number pv_fix,pv_ois;
		number pv_base 			= sw.present_value(pv_fix,pv_ois,trade_date_pv,ee);	
		QL_FAIL_COND(ee.is_error(), ee.message(), sw.name(), true);
		
		for(integer i=0;i<size;i++){
			QL_FAIL_COND(null(df_v_pert[i]), "disc_func in vector not valid", sw.name(), true);
			
			sw.add_disc_func_ois_leg(df_v_pert[i]);		
			f = fwd_func(df_v_pert[i],365,sw.trade_date(ee),idx.day_count_method(),idx.fixing_calendar(),BD_FOLLOWING,false);
			sw.add_fwd_func(f);
			if(!is_ccy)
				sw.add_disc_func_fix_leg(df_v_pert[i]);
					
			number pvi = sw.present_value(pv_fix,pv_ois,trade_date_pv,ee);
			QL_FAIL_COND(ee.is_error(), ee.message(), sw.name(), true);
			
			pv_diff_pert[i] = (pvi - pv_base)*mult;			
		
		}
		if(!null(df_all)){
			
			sw.add_disc_func_ois_leg(df_all);		
			f = fwd_func(df_all,365,sw.trade_date(ee),idx.day_count_method(),idx.fixing_calendar(),BD_FOLLOWING,false);
			sw.add_fwd_func(f);
			if(!is_ccy)
				sw.add_disc_func_fix_leg(df_all);
			number pv_all = sw.present_value(pv_fix,pv_ois,trade_date_pv,ee);
			QL_FAIL_COND(ee.is_error(), ee.message(), sw.name(), true);
			
			pv_diff_all = (pv_all - pv_base)*mult;
		}
		else {
			pv_diff_all = null<number>;
		}

		sw.add_curve_state(dffix_orig,dffix_orig,ts_orig );
	}*/
}

/*-----------------------------------------------------------------------
  risk_ladder
  ----------------------------------------------------------------------*/
/*void  swap_fixois.risk_ladder(	vector(disc_func) 			df_v_pert,
								disc_func 					df_base,
								disc_func option(nullable) 	df_all,
								number 						y_shift,
								out vector(number) 			pv_diff_pert,
								out number 					pv_diff_all,
								error_info option(nullable) error ) 
{
	
	error_info ee = new error_info(true,true);
	number nom = nominal(ee);
	CORE_INT_FIXOIS.risk_ladder_fixois(this,this.pay_fix(), nom,df_v_pert, df_base, df_all, pv_diff_pert, pv_diff_all, y_shift,error );	
}*/
/*-----------------------------------------------------------------------
  risk_ladder
  ----------------------------------------------------------------------*/
/*void  swap_fixois.risk_ladder(	vector(fwd_func) 			f_v_pert,
								fwd_func 					f_base,
								fwd_func option(nullable) 	f_all,
								number 						y_shift,
								out vector(number) 			pv_diff_pert,
								out number 					pv_diff_all,
								error_info option(nullable) error ) 
{
	
	error_info ee = new error_info(true,true);
	number nom = nominal(ee);
	CORE_INT_FIXOIS.risk_ladder_fixois(this,this.pay_fix(), nom,f_v_pert, f_base, f_all, pv_diff_pert, pv_diff_all, y_shift,error );	
}*/
/*-----------------------------------------------------------------------
  risk_ladder_disc
  ----------------------------------------------------------------------*/
void  swap_fixois.risk_ladder_disc(	vector(disc_func) 			df_v_pert,
									disc_func 					df_base,
									disc_func option(nullable) 	df_all,
									number 						y_shift,
									out vector(number) 			pv_diff_pert,
									out number 					pv_diff_all,								
									error_info option(nullable) error ) 
{
	
	error_info ee = new error_info(true,true);
	number nom = nominal(ee);
	CORE_INT_FIXOIS.risk_ladder_disc_fixois(this,this.pay_fix(), nom,/*f,*/df_v_pert, df_base, df_all, pv_diff_pert, pv_diff_all, y_shift,error );
}

/*-----------------------------------------------------------------------
  risk_ladder_fwd
  ----------------------------------------------------------------------*/
void  swap_fixois.risk_ladder_fwd(	vector(fwd_func) 			f_v_pert,
									fwd_func 					f_base,
									fwd_func option(nullable) 	f_all,
									number 						y_shift,
									out vector(number) 			pv_diff_pert,
									out number 					pv_diff_all,								
									error_info option(nullable) error ) 
{
	
	error_info ee = new error_info(true,true);
	number nom = nominal(ee);
	CORE_INT_FIXOIS.risk_ladder_fwd_fixois(this,this.pay_fix(), nom,f_v_pert, f_base, f_all, pv_diff_pert, pv_diff_all, y_shift, error );

}
/*-----------------------------------------------------------------------
  risk_ladder_fwd
  ----------------------------------------------------------------------*/
void  swap_fixois.risk_ladder_fwd(	vector(disc_func) 			df_v_pert,
									disc_func 					df_base,
									disc_func option(nullable) 	df_all,
									number 						y_shift,
									out vector(number) 			pv_diff_pert,
									out number 					pv_diff_all,								
									error_info option(nullable) error ) 
{
	
	error_info ee = new error_info(true,true);
	number nom = nominal(ee);
	CORE_INT_FIXOIS.risk_ladder_fwd_fixois(this,this.pay_fix(), nom,df_v_pert, df_base, df_all, pv_diff_pert, pv_diff_all, y_shift, error );

}
/*-----------------------------------------------------------------------
  pvdiff_curve_shift  
  f.d. pvbp_curve
  ----------------------------------------------------------------------*/
number  swap_fixois.pvdiff_curve_shift(	number option(nullable) delta_disc_fix_leg, 
										number option(nullable) delta_disc_ois_leg,
										number option(nullable) delta_fwd,//if endog: disc and fwd are the same
										logical option(nullable) trade_date_pv,
										logical option(nullable) leg_indep_shift,										
										out number pv_base,
										out number pvdiff_fix_leg,
										out number pvdiff_ois_leg,
										error_info option(nullable) error ) 
{	
	try{	

		//QL_FAIL_COND(this.is_ccy_swap(),"function not supported for currency swaps");
		error_info ee = new error_info(true,true);
		//logical is_endog		= is_endog_df(ee);
		
		/*if(null(delta_disc_fix_leg))
			delta_disc_fix_leg = 0.0001;
		if(!ccy_swap_) {
			//QL_FAIL_COND(!null(delta_disc_ois_leg), "delta for discount function for leg 2 not applicable for single currency swaps", this, true);
			delta_disc_ois_leg = delta_disc_fix_leg;	
		}
		else {
			if(null(delta_disc_ois_leg))
				delta_disc_ois_leg = 0.0001;
		}
		if(null(delta_fwd))
			delta_fwd = 0.0001;
		*/
		if(null(leg_indep_shift))
			leg_indep_shift = false;
		
		logical lfix = null(delta_disc_fix_leg) || CORE_INT.is_equal_zero(delta_disc_fix_leg );
		logical lois = null(delta_disc_ois_leg) || CORE_INT.is_equal_zero(delta_disc_ois_leg );
		logical lf = null(delta_fwd) || CORE_INT.is_equal_zero(delta_fwd );
		if(lfix && lois && lf ) {
			pvdiff_fix_leg = 0;
			pvdiff_ois_leg = 0;
			return 0;
		}

		//---set the curve state---	
		disc_func df_orig,dff_orig ;
		tenor_surface ts_orig;		
		curve_state(dff_orig,df_orig,ts_orig );
		
		disc_func df, dff; 
		fwd_func fwdf ;
		tenor_surface ts;
				
		if(!ccy_swap_ && null(dff_orig) && null(df_orig) && null(ts_orig)){//only update if all is null and not ccy swap			
			this.implied_par_funcs(df,fwdf,ee);//currently not for ccy swaps
						
			dff = df;//currently same disc_func for both legs
			
			..ir_index ir = this.ir_index(ee);
			logical allow_extrap 	= false;
			ts = tenor_surface(this.trade_date(),df,[fwdf],[ir],allow_extrap);
			
			this.add_curve_state(df,dff,ts);
		}
		else {
			QL_FAIL_COND(null(dff_orig), "disc_func for fixed leg not set", this, true);
			QL_FAIL_COND(null(df_orig), "disc_func for ois leg not set", this, true);
			QL_FAIL_COND(null(ts_orig), "tenor surface for ois leg not set", this, true);
			
			dff 	= dff_orig;			
			df 		= df_orig;
			fwdf 	= fwd_func_ois_leg();
			
			QL_FAIL_COND(null(fwdf), "fwd_func for ois leg not set", this, true);
		}
		//--------------------------
		
		/* we now have 1) dff for fix_leg, 2) df for leg 2, 3) fwdf for ois_leg */
		logical endog_df = this.is_endog_df(ee);

		number pv_fix,pv_ois;
		pv_base = present_value(pv_fix,pv_ois,trade_date_pv,ee);
		
		fwd_func f_delta = null<fwd_func>;
		disc_func df_delta= null<disc_func>;
		disc_func __df = null;
		tenor_surface __ts = null;
		
		if(!null(delta_fwd)) {
			f_delta = this.fwd_shifted_ois_leg(delta_fwd,fwdf);
			QL_FAIL_COND(null(f_delta), "error creating fwd_func for ois leg", this, true);
			this.add_fwd_func(f_delta,true,__df, __ts);	//will update disc_func for ois leg if endog_df, __df is reused if not null
			__df = null;//must reset __df to null to prevent reuse
		}
		
		if(!endog_df && !null(delta_disc_ois_leg)) {
			//QL_FAIL_COND(is_endog, "input error", this, true);
			df_delta = this.df_shifted_ois_leg(delta_disc_ois_leg,df);
			QL_FAIL_COND(null(df_delta), "error creating disc_func for ois leg", this, true);
			this.add_disc_func_ois_leg(df_delta,true,ts);
		}

		disc_func df_delta_fix = null<disc_func>;
		if(ccy_swap_) {
			if(!null(delta_disc_fix_leg)) {
				if(leg_indep_shift || !CORE_INT.is_equal(delta_disc_fix_leg,delta_disc_ois_leg))
					df_delta_fix = this.df_shifted_fix_leg(delta_disc_fix_leg,dff) ;
				else
					df_delta_fix = this.df_shifted_ois_leg(delta_disc_fix_leg,dff);
				QL_FAIL_COND(null(df_delta_fix), "error creating disc_func for fix leg", this, true);
				this.add_disc_func_fix_leg(df_delta_fix);
			}
		}
		else {
			if(leg_indep_shift && !null(delta_disc_fix_leg) /*|| !CORE_INT.is_equal(delta_disc_fix_leg,delta_disc_ois_leg)*/)
				df_delta_fix = this.df_shifted_fix_leg(delta_disc_fix_leg,dff) ;
			else
				df_delta_fix = this.disc_func_ois_leg(ee);//possible because the instrument has been updated above (in add_fwd_func or add_disc_func_ois_leg)
			QL_FAIL_COND(null(df_delta_fix), "error creating disc_func for fix leg", this, true);
			this.add_disc_func_fix_leg(df_delta_fix);
		}	
								
		number pv_fix_delta,pv_ois_delta;
		number pv_delta = present_value(pv_fix_delta,pv_ois_delta,trade_date_pv,ee);
		pvdiff_fix_leg 	= pv_fix_delta - pv_fix; 
		pvdiff_ois_leg 	= pv_ois_delta - pv_ois;
		number pvdiff 	= pv_delta-pv_base;

		this.add_curve_state(df_orig,dff_orig,ts_orig);

		return pvdiff;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.pvdiff_curve_shift");
		pv_base = pvdiff_fix_leg =  pvdiff_ois_leg = null<number>;
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  pvdiff_curve_shift
  ----------------------------------------------------------------------*/
number  swap_fixois.pvdiff_curve_shift(	number option(nullable) 	delta_disc,
										number option(nullable) 	delta_fwd, 
										logical option(nullable) 	trade_date_pv,
										error_info option(nullable) error ) 
{
	error_info ee = new error_info(true,true);
	//logical is_endog = is_endog_df(ee);

	if(null(delta_disc))
		delta_disc = 0.0001;
	if(null(delta_fwd))
		delta_fwd = 0.0001;
	//QL_FAIL_COND(is_endog && !null(delta_disc) && !null(delta_fwd), "error creating disc_func for fix leg", this, true);

	number d_disc_fix = ccy_swap_ ? delta_disc : null<number>;
	number d_disc_ois = this.is_endog_df(ee) ? null<number> : delta_disc;
	number d_fwd_ois = delta_fwd;

	if(null(trade_date_pv))
		trade_date_pv = false;

	logical leg_indep_shift = false;
	
	number pv,pvdiff_fix, pvdiff_flt;	
	number pvdiff = pvdiff_curve_shift(	d_disc_fix, d_disc_ois, d_fwd_ois,
										trade_date_pv, leg_indep_shift,pv, pvdiff_fix,
										pvdiff_flt, error );
	return pvdiff ;
	
}


/*-----------------------------------------------------------------------
  pvbp_curve
  ----------------------------------------------------------------------*/
/*number  swap_fixois.pvbp_curve(	number option(nullable) delta_disc_fix_leg, 
								number option(nullable) delta_disc_ois_leg,//not used for single ccy swaps
								number option(nullable) delta_fwd,
								logical option(nullable) trade_date_pv,
								out number  risk_fix_leg,
								out number  risk_ois_leg,
								error_info option(nullable) error ) 
{	
	try{	

		//QL_FAIL_COND(this.is_ccy_swap(),"function not supported for currency swaps");					
		
		if(null(delta_disc_fix_leg))
			delta_disc_fix_leg = 0.0001;
		if(!ccy_swap_) {
			QL_FAIL_COND(!null(delta_disc_ois_leg), "delta for discount function for leg 2 not applicable for single currency swaps", this, true);
			delta_disc_ois_leg = delta_disc_fix_leg;	
		}
		else {
			if(null(delta_disc_ois_leg))
				delta_disc_ois_leg = 0.0001;
		}

		if(null(delta_fwd)) delta_fwd = 0.0001;
		
		if(CORE_INT.is_equal_zero(delta_disc_fix_leg) && CORE_INT.is_equal_zero(delta_disc_ois_leg) && CORE_INT.is_equal_zero(delta_fwd ) ) {
			risk_fix_leg = 0;
			risk_ois_leg = 0;
			return 0;
		}
		
		error_info ee = new error_info(true,true);
		
		disc_func df_orig 		= this.disc_func_ois_leg(ee);
		disc_func dff_orig 		= this.disc_func_fix_leg(ee);
		tenor_surface ts_orig 	= this.tenor_surface_ois_leg(ee);

		disc_func df, dff; 
		disc_func fwddf = null<disc_func>;		
		tenor_surface ts;
		
		logical upd = false;

		if(!ccy_swap_ && null(dff_orig) && null(df_orig) && null(ts_orig)){//only update if all is null and not ccy swap			
			this.par_funcs(df,ee);//currently not for ccy swaps 
			dff 	= fwddf = df;//currently same disc_func for both legs
			ts 		= this.create_tenor_surface( df,fwddf);
			QL_FAIL_COND(null(ts), "error creating tenor surface", this, true);
		
			fwddf 	= null<disc_func>;
			this.add_data(this.nominal(),df,ts,null<vector(date)>,null<vector(number)>,null<logical>, false);
			upd = true;
		}
		else {
			QL_FAIL_COND(null(dff_orig), "discount function for fixed leg not set", this, true);
			dff = dff_orig;
			QL_FAIL_COND(null(df_orig), "discount function for ois leg not set", this, true);
			df = df_orig;
			QL_FAIL_COND(null(ts_orig), "tenor surface not set", this, true);
			ts = ts_orig;	

			logical is_disc = ts_orig.fwd_is_disc_func();
			QL_FAIL_COND(!is_disc, "unsupported tenor surface type", this, true);
			
			tenor_code tc 	= this.index_tenor_code(ee);
			
			fwddf 	= ts_orig.fwd_curve_d(tc);		
			
		}
		// we now have 1) dff for fix_leg, 2) df for leg 2, 3) fwddf for ois_leg 

		number pv_fix,pv_ois;
		number pv = present_value(pv_fix,pv_ois,trade_date_pv,ee);
		// create new df and fwdf/fwddf for ois_leg 
		disc_func df_delta = this.df_pvbp_leg_delta(delta_disc_ois_leg,df);
		QL_FAIL_COND(null(df_delta), "error creating disc_func for float leg", this, true);

		disc_func df_delta_fix = ccy_swap_ ? this.df_pvbp_leg_delta(delta_disc_fix_leg,dff) : df_delta;		
		QL_FAIL_COND(null(df_delta_fix), "error creating disc_func for fix leg", this, true);
		
		tenor_surface ts_delta 	= this.ts_pvbp_leg_delta_fwd(delta_fwd,df_delta,ts);
		QL_FAIL_COND(null(ts_delta), "error creating tenor surface", this, true);
		
		if(!CORE_INT.is_equal_zero(delta_disc_fix_leg ) ) 
			this.add_disc_func_fix_leg(df_delta_fix);

		if(!CORE_INT.is_equal_zero(delta_disc_ois_leg ) ) 
			this.add_disc_func_ois_leg(df_delta);		
		
		if(!CORE_INT.is_equal_zero(delta_fwd)) 
			this.add_surface(ts_delta);	
								
		number pv_fix_delta,pv_ois_delta;
		number pv_delta = present_value(pv_fix_delta,pv_ois_delta,trade_date_pv,ee);
		risk_fix_leg 	= pv_fix_delta - pv_fix;
		risk_ois_leg 	= pv_ois_delta - pv_ois;
		number risk 	= pv_delta-pv;

		//clean up
		if(upd || !CORE_INT.is_equal_zero(delta_disc_fix_leg ) ) 
			this.add_disc_func_fix_leg(dff_orig);

		if(upd || !CORE_INT.is_equal_zero(delta_disc_ois_leg ) ) 
			this.add_disc_func_ois_leg(df_orig);
				
		if(upd || !CORE_INT.is_equal_zero(delta_fwd )) 
			this.add_surface(ts_orig);	

		return risk;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.pvbp_curve");
		risk_fix_leg =  risk_ois_leg = null<number>;
		return null<number>;
	}
}*/


/*-----------------------------------------------------------------------
  pvdiff_fix_rate	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fixois.pvdiff_fix_rate(	number 						delta_fix_cpn_rate,									
											disc_func option(nullable) 	df,
											error_info option(nullable) error ) 
{	
	return swap_gen.pvdiff_fix_rate(delta_fix_cpn_rate,	df, error ) ;
}

/*-----------------------------------------------------------------------
  pv01	EXT SWAP: ok  - always returns a positive number regardless of pay/receive and sign of notional
  Note: not a "true" measure of risk, this version also takes into account if the swap has a pv <> 0
  
if sign is needed:
 receive fix --> negative sign
  ----------------------------------------------------------------------*/
number  swap_fixois.pv01_ext(number option(nullable) notional,
							number option(nullable) delta,
							//logical option(nullable) trade_date_pv,
							disc_func option(nullable) df,
							out number pv01_mkt,
							out number pv01_pv,
							error_info option(nullable) error ) 
{	
	try{
		error_info ee 		= new error_info(true,true);
		
		instr_error_type t;
   		string 			s;	

		logical is_par_updated = false;

		disc_func df_ois_orig,df_fix_orig ;
		tenor_surface ts_orig;		
		curve_state(df_fix_orig,df_ois_orig,ts_orig );
	
		if(!ccy_swap_) {					
			disc_func df_tmp;
			tenor_surface ts_tmp;			
			is_par_updated = update_to_par_int(true, true,df_ois_orig, df_fix_orig, ts_orig, df, df_tmp,ts_tmp );			
		}
						
		disc_func df_orig 	= this.disc_func_fix_leg(ee);
		logical upd 		= false;
		
		if(!null(df)){
			this.add_disc_func_fix_leg(df);
			upd = true;
		}
		else if(null(df_orig)) {	
			disc_func _df = this.implied_par_disc_func_fix_leg(ee);
			this.add_disc_func_fix_leg(_df);
			upd = true;
		}
		
		pv01_mkt = i().__swap_pvbp_fix_leg(notional,delta, true,t, s);
		if(!null(pv01_mkt))
			pv01_mkt = abs(pv01_mkt);
		
		pv01_pv = 0;
		number pvfix,pvflt;
		number pv = this.present_value(pvfix,pvflt,false,ee);
					
		if(!CORE_INT.is_equal_zero(pv)) {

			if(this.pay_fix(ee))
				pv *= -1;
			
			if(!null(notional)){
				number n_fix,n_flt;
				this.notional(n_fix,n_flt,ee);
				if(!CORE_INT.is_equal(notional, n_fix)){
					pv = pv * notional/n_fix;
				}
			}
			disc_func df_curr 	= this.disc_func_fix_leg(ee);
			vector(date) pmt_dates = this.fix_leg(false,ee).ir_payment_dates();
			
			day_count_method fixdc,fltdc;
			this.dc_method(fixdc,fltdc,ee);
			number ad;
			number a = swap_annuity(this.trade_date(ee),this.settle_date(ee),df_curr,pmt_dates,fixdc,delta,ad);				
			number cf = pv/abs(a);
			number pv_shift = cf*abs(ad);
			pv01_pv = pv - pv_shift;//pv > 0 --> pv_diff > 0
		}
		
		if(is_par_updated) {
			add_curve_state(df_fix_orig,df_ois_orig,ts_orig );			
		}
		else if(upd && !null(df_orig)){			
			this.add_disc_func_fix_leg(df_orig);
		}
		
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fixois.pv01_ext");	
		if(e) { 
			pv01_mkt = pv01_pv = null<number>;
			return null<number>;
		}
		return pv01_mkt+pv01_pv;
	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.pv01_ext");
		pv01_mkt = pv01_pv = null<number>;
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
   pv01	EXT SWAP: ok  - always returns a positive number regardless of pay/receive and sign of notional
  Note: not a "true" measure of risk, does not take into account if the swap has a pv <> 0
   PV01 refers to present value of 1 basis point and it's the discounted value of the cashflows
  for a rate of 0.01% for all periods of a particular instrument, ie, the npv of the fixed leg with a rate of 0.01%
  ----------------------------------------------------------------------*/
number  swap_fixois.pv01(	number option(nullable) notional,
							number option(nullable) delta,
							//logical option(nullable) trade_date_pv,
							disc_func option(nullable) df,
							error_info option(nullable) error ) 
{	
	return swap_gen.pv01_fix_leg(notional,delta,df,error);
}

/*-----------------------------------------------------------------------
  pv01_spread	EXT SWAP: ok  - always returns a positive number regardless of pay/receive and sign of notional
  Note: not a "true" measure of risk, does not take into account if the swap has a pv <> 0
   PV01 refers to present value of 1 basis point spread and it's the discounted value of the cashflows
  for a float rate of 0.01% 
  ----------------------------------------------------------------------*/
number  swap_fixois.pv01_spread(number option(nullable) notional,
								number option(nullable) delta,
								//logical option(nullable) trade_date_pv,
								disc_func option(nullable) df,
								error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	

		error_info ee 		= new error_info(true,true);
		disc_func df_orig 	= this.disc_func_ois_leg(ee);
		logical upd 		= false;
		
		if(!null(df)){
			tenor_surface ts;
			this.add_disc_func_ois_leg(df,false, ts);
			upd = true;
		}
		else if(null(df_orig)) {	
			QL_FAIL("discount function not set",this,true);
		}
		
		number c = i().__swap_pvbp_ois_leg(notional,delta, false,t, s);
		if(!null(c))
			c = abs(c);
		
		if(upd && !null(df_orig)){
			tenor_surface ts;
			this.add_disc_func_ois_leg(df_orig,false,ts);	//curve state func instead??
		}

		logical e = CORE_INT.add_error_info(error,t,s, "swap_fixois.pv01_spread");	
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.pv01_spread");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  spreadbp_to_fixbp	EXT SWAP: ok 
  ----------------------------------------------------------------------*/
number  swap_fixois.spreadbp_to_fixbp(	error_info option(nullable) error ) 
{
	try {
		error_info ee = new error_info(true,true);
		number  pv01s = this.pv01_spread(100,0.0001,null,ee) ;
		number  pv01f = this.pv01(100,0.0001,null,ee) ;
		return pv01s / pv01f;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.spreadbp_to_fixbp");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  pvbp	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fixois.pvbp(	number option(nullable) notional,
							number option(nullable) delta,
							logical option(nullable) centered,
							logical option(nullable) disable_rounding,	
							error_info option(nullable) error ) 
{	
	try {
		error_info ee = new error_info(true,true);
		number pv01_ = this.pv01(notional,delta,null<disc_func>,ee); //always positive
		if(!null(notional) && notional < 0)
			return -pv01_;
		else
			return pv01_;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.pvbp");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  pvbp	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fixois.pvbp(	number 	option(nullable) notional,
							number  option(nullable) delta,																																		
							error_info option(nullable) error ) 
{	
	try{	
		error_info ee = new error_info(true,true);
		number pv01_ = this.pv01(notional,delta, null<disc_func>,ee);//always positive
		if(!null(notional) && notional < 0)
			return -pv01_;
		else
			return pv01_;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.pvbp");
		return null<number>;
	}
}


/*
 both
 -----
 
f			non_ccy	ccy
endog		d		d
non_endog	d		d

dfois		non_ccy	ccy
endog		calc	calc
non_endog	d		d

dffix		non_ccy	ccy
endog		dfois	d
non_endog	dfois	d

----------------------------------------------
 disc
 -----
 
f			non_ccy		ccy
endog		d			d
non_endog	not used	not used

dfois		non_ccy	ccy
endog		calc	calc
non_endog	d		d

dffix		non_ccy	ccy
endog		dfois	d
non_endog	dfois	d

----------------------------------------------
 fwd
 ----
 
f			non_ccy	ccy
endog		d		d
non_endog	d		d

dfois		non_ccy		ccy
endog		calc		calc
non_endog	not used	not used

dffix		non_ccy		ccy
endog		not used	not used
non_endog	not used	not used

 */


/*-----------------------------------------------------------------------
  dv01
  DV01 refers to dollar value of 1 basis point and it's the change in value of the npv
  of the instrument with a change of 1 basis point in the curve(s).
  This version has no knowledge of the underlying instruments and therefore the shifts
  are calculated directly from the fwd_func and disc_func
  (fwd_func --> shift of fwd rates)
  (disc_func --> shift of fwd rates calculated from the disc_func)
  ----------------------------------------------------------------------*/
number  swap_fixois.dv01(	number option(nullable) delta, 
							logical option(nullable) trade_date_pv,
							error_info option(nullable) error ) 
{
	error_info ee = new error_info(true,true);
	logical is_endog		= is_endog_df(ee);
	if(null(delta))
		delta = 0.0001;
	
	number d_disc_fix = ccy_swap_ ? delta : null<number>;
	number d_disc_ois = is_endog ? null<number> : delta;
	number d_fwd_ois = delta;

	logical leg_indep_shift = false;
	
	number pv,pvdiff_fix_leg, pvdiff_ois_leg;
	number pvdiff = pvdiff_curve_shift(d_disc_fix,d_disc_ois,d_fwd_ois, trade_date_pv,leg_indep_shift,
										pv, pvdiff_fix_leg, pvdiff_ois_leg, error ) ;

	number div = delta * 10000.0;
	return pvdiff / div;
}


/*-----------------------------------------------------------------------
  dv01_disc
  This version has no knowledge of the underlying instruments (see above)
  ----------------------------------------------------------------------*/
number  swap_fixois.dv01_disc(	number option(nullable) delta, 
								logical option(nullable) trade_date_pv,
								error_info option(nullable) error ) 
{
	error_info ee = new error_info(true,true);
	logical is_endog		= is_endog_df(ee);

	if(null(delta))
		delta = 0.0001;
	
	number d_disc_fix = ccy_swap_ ? delta : null<number>;
	number d_disc_ois = is_endog ? null<number> : delta;
	number d_fwd_ois = is_endog ? delta : null<number>;;

	logical leg_indep_shift = false;
	
	number pv,pvdiff_fix_leg, pvdiff_ois_leg;
	number pvdiff = pvdiff_curve_shift(d_disc_fix,d_disc_ois,d_fwd_ois, trade_date_pv,leg_indep_shift,
										pv, pvdiff_fix_leg, pvdiff_ois_leg, error ) ;

	number div = delta * 10000.0;
	return pvdiff / div;
}

/*-----------------------------------------------------------------------
  dv01_fwd
   This version has no knowledge of the underlying instruments (see above)
  ----------------------------------------------------------------------*/
number  swap_fixois.dv01_fwd(	number option(nullable) delta, 
								logical option(nullable) trade_date_pv,
								error_info option(nullable) error ) 
{
	//error_info ee = new error_info(true,true);
	//logical is_endog		= is_endog_df(ee);
	
	if(null(delta))
		delta = 0.0001;
	
	number d_disc_fix = null<number>;
	number d_disc_ois = null<number> ;
	number d_fwd_ois = delta;

	logical leg_indep_shift = false;
	
	number pv,pvdiff_fix_leg, pvdiff_ois_leg;
	number pvdiff = pvdiff_curve_shift(d_disc_fix,d_disc_ois,d_fwd_ois, trade_date_pv,leg_indep_shift,
										pv, pvdiff_fix_leg, pvdiff_ois_leg, error ) ;

	number div = delta * 10000.0;
	return pvdiff / div;
}


/*-----------------------------------------------------------------------
  pvdiff  (all shifted fwd_func/disc_func is input)
  ----------------------------------------------------------------------*/
number  swap_fixois.pvdiff(	fwd_func option(nullable) fwd_base, 
							fwd_func option(nullable) fwd_shift,
							disc_func option(nullable)	df_base_ois, 
							disc_func option(nullable)	df_shift_ois,
							disc_func option(nullable)	df_base_fix, //only for cross curr
							disc_func option(nullable)	df_shift_fix,//only for cross curr
							logical option(nullable) trade_date_pv,
							out number pv_base,
							out number pvdiff_fix_leg,
							out number pvdiff_ois_leg,
							error_info option(nullable) error ) 
{	
	try{	
		error_info ee 		= new error_info(true,true);

		logical is_endog	= this.is_endog_df(ee);

		QL_FAIL_COND(!null(fwd_shift) && null(fwd_base), "fwd_base required if fwd_shift is input", this, true);
		QL_FAIL_COND(!is_endog && !null(df_shift_ois) && null(df_base_ois), "df_base_ois required if df_shift_ois is input", this, true);
		
		if(!ccy_swap_) {
			df_base_fix = null<disc_func>;
			df_shift_fix = null<disc_func>;
			QL_FAIL_COND(is_endog && null(fwd_shift), "fwd_shift required for single currency swap (self discounted ois leg)", this, true);
			QL_FAIL_COND(!is_endog && null(fwd_shift) && null(df_shift_ois), "fwd_shift and df_shift_ois cannot both be null for single currency swap (non self discounted ois leg)", this, true);
		}
		else {
			QL_FAIL_COND(!null(df_shift_fix) && null(df_base_fix), "df_base_fix required if df_shift_fix is input for cross currency swap", this, true);
			QL_FAIL_COND(is_endog && null(fwd_shift) && null(df_shift_fix), "fwd_shift and df_shift_fix cannot both be null (cross currency swap and self discounted ois leg)", this, true);
			QL_FAIL_COND(!is_endog && null(fwd_shift) && null(df_shift_ois) && null(df_shift_fix), "fwd_shift, df_shift_ois and df_shift_fix cannot all be null (cross currency swap and non self discounted ois leg)", this, true);
		}
				
		//---set the curve state---			
		disc_func df_orig,dff_orig ;
		tenor_surface ts_orig;		
		curve_state(dff_orig,df_orig,ts_orig );
		
		if(!ccy_swap_ && null(dff_orig) && null(df_orig) && null(ts_orig)){//only update if all is null and not ccy swap
			disc_func df;
			fwd_func fwdf;
			this.implied_par_funcs(df,fwdf,ee);//currently not for ccy swaps

			..ir_index ir = this.ir_index(ee);
			logical allow_extrap 	= false;
			tenor_surface ts = tenor_surface(this.trade_date(), df,[fwdf],[ir],allow_extrap);
			
			this.add_curve_state(df,df,ts);
		}
		else {
			QL_FAIL_COND(null(dff_orig), "disc_func for fixed leg not set", this, true);
			QL_FAIL_COND(null(df_orig), "disc_func for float leg not set", this, true);
			QL_FAIL_COND(null(ts_orig), "tenor surface not set", this, true);
		}
		//----------------------------
		
		//----set the base----------------		
		if(is_endog) {

			if(!null(fwd_base)) {
				disc_func __df;
				tenor_surface __ts;
				this.add_fwd_func(fwd_base,true,__df, __ts);//also the disc_func is updated here

				if(!ccy_swap_)
					this.add_disc_func_fix_leg(this.disc_func_ois_leg(ee));
			}
			if(ccy_swap_ && !null(df_base_fix)) {
				this.add_disc_func_fix_leg(df_base_fix);
			}			
		}
		else {

			if(!null(fwd_base)) {
				disc_func __df;
				tenor_surface __ts;
				this.add_fwd_func(fwd_base,true,__df, __ts);
			}
						
			if(!null(df_base_ois)) {
				tenor_surface __ts;
				if(ccy_swap_)
					this.add_disc_func_ois_leg(df_base_ois,true,__ts);
				else
					this.add_disc_func(df_base_ois,true,__ts);
			}
			
			if(ccy_swap_ && !null(df_base_fix)) {
				this.add_disc_func_fix_leg(df_base_fix);
			}					
		}
		
		number pv_fix,pv_ois;
		pv_base = present_value(pv_fix,pv_ois,trade_date_pv,ee);
		//------------------------------
		
		//----set the shifted----------------
		if(is_endog) {
			if(!null(fwd_shift)) {
				disc_func __df;
				tenor_surface __ts;
				this.add_fwd_func(fwd_shift,true, __df, __ts);//also the disc_func is updated here
				if(!ccy_swap_)
					this.add_disc_func_fix_leg(this.disc_func_ois_leg(ee));
			}
			if(ccy_swap_ && !null(df_shift_fix)) {
				this.add_disc_func_fix_leg(df_shift_fix);
			}
		}
		else {

			if(!null(fwd_shift)) {
				disc_func __df;
				tenor_surface __ts;
				this.add_fwd_func(fwd_shift,true,__df, __ts);
			}
			
			if(!null(df_shift_ois)) {
				tenor_surface ts;
				if(ccy_swap_)
					this.add_disc_func_ois_leg(df_shift_ois,true,ts);
				else
					this.add_disc_func(df_shift_ois,true,ts);
			}

			if(ccy_swap_ && !null(df_shift_fix)) {
				this.add_disc_func_fix_leg(df_shift_fix);
			}
		}
		//------------------------------

		//-----results------------------
		number pv_fix_delta,pv_ois_delta;
		number pv_delta = present_value(pv_fix_delta,pv_ois_delta,trade_date_pv,ee);
		pvdiff_fix_leg 	= pv_fix_delta - pv_fix; 
		pvdiff_ois_leg 	= pv_ois_delta - pv_ois;
		number pvdiff 	= pv_delta-pv_base;
		//------------------------------

		
		//---restore curve state-----		
		this.add_curve_state(df_orig,dff_orig,ts_orig);
		
		return pvdiff;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.pvdiff");
		pv_base = pvdiff_fix_leg =  pvdiff_ois_leg = null<number>;
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  dv01
  This version has the fwd_funcs and disc_funcs as input. These can be calculated from shifting
  the underlying instruments in the curve
  ----------------------------------------------------------------------*/
number  swap_fixois.dv01(	fwd_func option(nullable) fwd_base, 
							fwd_func option(nullable) fwd_shift,
							disc_func option(nullable) df_base_flt,
							disc_func option(nullable) df_shift_flt,
							disc_func option(nullable) df_base_fix, 
							disc_func option(nullable) df_shift_fix,								
							number 		r_shift,
							error_info option(nullable) error ) 
{
	number pv,pvdiff_fix_leg,pvdiff_flt_leg;
	number pvd = pvdiff(fwd_base,fwd_shift,df_base_flt,df_shift_flt,df_base_fix,df_shift_fix,
						false,pv,pvdiff_fix_leg,pvdiff_flt_leg,error ) ;

	number div = r_shift * 10000.0;
	return pvd / div;	
}

/*-----------------------------------------------------------------------
  dv01_fwd  (if endog_df: disc_funcs will also be shifted)
  Note: if cross currency --> if we have a self discounted ois leg the discounting on ois leg will be affected but the fix leg not
  ----------------------------------------------------------------------*/
number  swap_fixois.dv01_fwd(	fwd_func	fwd_base, 
								fwd_func	fwd_shift,
								number 		r_shift,
								error_info option(nullable) error ) 
{
	number pv,pvdiff_fix_leg,pvdiff_flt_leg;
	number pvd = pvdiff(fwd_base,fwd_shift,null<disc_func>,null<disc_func>,null<disc_func>,null<disc_func>,
						false,pv,pvdiff_fix_leg,pvdiff_flt_leg,error ) ;

	number div = r_shift * 10000.0;
	return pvd / div;	
}

/*-----------------------------------------------------------------------
  dv01_disc
  Note: if cross currency --> the fix leg is not included 
  ----------------------------------------------------------------------*/
number  swap_fixois.dv01_disc(	disc_func	df_base_flt, 
								disc_func	df_shift_flt,
								number 		r_shift,
								error_info option(nullable) error ) 
{
	
	error_info ee = new error_info(true,true);
	logical is_endog		= is_endog_df(ee);
	number pv,pvdiff_fix_leg,pvdiff_flt_leg;

	number pvd;
	if(is_endog){
		..ir_index idx 		= ir_index(ee);
		fwd_func fwd_base 	= fwd_func(df_base_flt,365,trade_date(ee),idx.day_count_method(),idx.fixing_calendar(),BD_FOLLOWING,false); 
		fwd_func fwd_shift	= fwd_func(df_shift_flt,365,trade_date(ee),idx.day_count_method(),idx.fixing_calendar(),BD_FOLLOWING,false);
	
		pvd 				= pvdiff(fwd_base,fwd_shift,null<disc_func>,null<disc_func>,null<disc_func>,null<disc_func>,
									false,pv,pvdiff_fix_leg,pvdiff_flt_leg,error ) ;
	}
	else {
		pvd 				= pvdiff(null<fwd_func>,null<fwd_func>,df_base_flt,df_shift_flt,null<disc_func>,null<disc_func>,
									false,pv,pvdiff_fix_leg,pvdiff_flt_leg,error ) ;
	}

	number div = r_shift * 10000.0;
	return pvd / div;
	
}
/*-----------------------------------------------------------------------
  dv01_disc
  ----------------------------------------------------------------------*/
number  swap_fixois.dv01_disc(	disc_func option(nullable) df_base_flt, 
								disc_func option(nullable) df_shift_flt,
								disc_func df_base_fix, 
								disc_func df_shift_fix,								
								number 		r_shift,
								error_info option(nullable) error ) 
{
	error_info ee = new error_info(true,true);
	logical is_endog		= is_endog_df(ee);
	number pvd, pv,pvdiff_fix_leg,pvdiff_flt_leg;

	
	if(is_endog){
		QL_FAIL_COND(null(df_base_flt) || null(df_shift_flt), "df_base_flt and df_shift_flt are required input for self discounted ois leg", this, true);
			
		..ir_index idx = ir_index(ee);
		fwd_func fwd_base = fwd_func(df_base_flt,365,trade_date(ee),idx.day_count_method(),idx.fixing_calendar(),BD_FOLLOWING,false); 
		fwd_func fwd_shift= fwd_func(df_shift_flt,365,trade_date(ee),idx.day_count_method(),idx.fixing_calendar(),BD_FOLLOWING,false);
		pvd  = pvdiff(fwd_base,fwd_shift,null<disc_func>,null<disc_func>,df_base_fix,df_shift_fix,
						false,pv,pvdiff_fix_leg,pvdiff_flt_leg,error ) ;
	}
	else {
		
		pvd  = pvdiff(null<fwd_func>,null<fwd_func>,df_base_flt,df_shift_flt,df_base_fix,df_shift_fix,
						false,pv,pvdiff_fix_leg,pvdiff_flt_leg,error ) ;
	}

	number div = r_shift * 10000.0;
	return pvd / div;
	
}

/*-----------------------------------------------------------------------
  gamma_risk
  ----------------------------------------------------------------------*/
number  swap_fixois.gamma_risk(	number option(nullable) 	delta, 
								logical option(nullable) 	trade_date_pv,
								error_info option(nullable) error ) 
{

	if(null(delta) )
		delta = 0.0001;
	
	number delta_disc = delta;
	
	if(null(trade_date_pv))
		trade_date_pv = false;

	logical leg_indep_shift = false;
	
	number pv_x,pvdiff_fix, pvdiff_flt;

	number pvdiffup 	= pvdiff_curve_shift(delta_disc, delta_disc, delta,
										trade_date_pv, leg_indep_shift,pv_x, pvdiff_fix,
										pvdiff_flt, error );
	number pv_x_up 		= pvdiffup + pv_x;
	
	number pvdiffdown 	= pvdiff_curve_shift(-delta_disc, -delta_disc, -delta,
										trade_date_pv, leg_indep_shift,pv_x, pvdiff_fix,
										pvdiff_flt, error );

	number pv_x_down 	= pvdiffdown + pv_x;
	
	number g = CORE_INT.num2der(pv_x,pv_x_up,pv_x_down,delta*10000.0) ;
	return g;
}
/*-----------------------------------------------------------------------
  gamma_risk
  ----------------------------------------------------------------------*/
number  swap_fixois.gamma_risk_disc(number option(nullable) 	delta, 
									logical option(nullable) 	trade_date_pv,
									error_info option(nullable) error ) 
{

	if(null(delta) )
		delta = 0.0001;
	
	if(null(trade_date_pv))
		trade_date_pv = false;

	logical leg_indep_shift = false;
	
	number pv_x,pvdiff_fix, pvdiff_flt;

	number pvdiffup 	= pvdiff_curve_shift(delta, delta, 0,
										trade_date_pv, leg_indep_shift,pv_x, pvdiff_fix,
										pvdiff_flt, error );
	number pv_x_up 		= pvdiffup + pv_x;
	
	number pvdiffdown 	= pvdiff_curve_shift(-delta, -delta, 0,
										trade_date_pv, leg_indep_shift,pv_x, pvdiff_fix,
										pvdiff_flt, error );

	number pv_x_down 	= pvdiffdown + pv_x;
	
	number g = CORE_INT.num2der(pv_x,pv_x_up,pv_x_down,delta*10000.0) ;
	return g;
}

/*-----------------------------------------------------------------------
  gamma_risk_fwd
  ----------------------------------------------------------------------*/
number  swap_fixois.gamma_risk_fwd(	number option(nullable) 	delta, 
									logical option(nullable) 	trade_date_pv,
									error_info option(nullable) error ) 
{

	if(null(delta) )
		delta = 0.0001;
	
	if(null(trade_date_pv))
		trade_date_pv = false;

	logical leg_indep_shift = false;
	
	number pv_x,pvdiff_fix, pvdiff_flt;

	number pvdiffup 	= pvdiff_curve_shift(0, 0, delta, trade_date_pv, leg_indep_shift,pv_x, pvdiff_fix,
										pvdiff_flt, error );
	number pv_x_up 		= pvdiffup + pv_x;
	
	number pvdiffdown 	= pvdiff_curve_shift(0, 0, -delta, trade_date_pv, leg_indep_shift,pv_x, pvdiff_fix,
										pvdiff_flt, error );

	number pv_x_down 	= pvdiffdown + pv_x;

	number g = CORE_INT.num2der(pv_x,pv_x_up,pv_x_down,delta*10000.0) ;
	return g;
}

/*-----------------------------------------------------------------------
  implied_par_funcs		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixois.implied_par_funcs(	out disc_func 	df,
									out fwd_func 	fwdf,
									error_info option(nullable) 	error )
{
	try{		
		QL_FAIL_COND(ccy_swap_,"inapplicable function call for cross currency swaps", this,true);

		error_info ee = new error_info(true,false);
		
		number s = this.spread_ois_leg(ee) ;
		QL_FAIL_COND(!CORE_INT.is_equal_zero(s),"error creating implied par disc_func (non zero spread)", this,true);
		
		df = implied_par_disc_func_fix_leg(ee );
		
		if(ee.is_error()){
			string msg = strcat(["error creating implied par disc_func (",ee.message(),")"]);
			QL_FAIL_COND(null(df),msg, this,true);
		}
		else {
			QL_FAIL_COND(null(df),"error creating implied par disc_func", this,true);
		}
		
		fwdf = fwd_func(df,365,trade_date(ee),swap_gen.dc_method(ee),swap_gen.calendar(ee),BD_FOLLOWING,false);

		
		/*number first_flt_fixing = null<number>;
		vector(date) dates;
		vector(number) amounts;
		vector(date)	float_idx0, float_pmt;
		vector(number)	float_dt;			
		logical ok = this.cash_flows_fwd_bootstrap(dates,amounts, first_flt_fixing,float_idx0,float_pmt,float_dt,ee) ;
		QL_FAIL_COND(!ok,"error creating bootstrap cashflows (fwd)", this,true);

		cashflows_fwd cf = cashflows_fwd(this.trade_date(), dates, amounts, float_idx0, float_pmt, float_dt);
		QL_FAIL_COND(null(cf),"error creating cash flows", this,true);	
		
		fwdf = bootstrap_fwd(cf, df, ip_linear());*/
		QL_FAIL_COND(null(fwdf ),"error creating implied par fwd_func", this,true);
		
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.implied_par_funcs");
		df 		= null<disc_func>;
		return ;
	}
}


/*-----------------------------------------------------------------------
  ir_index_ois_leg		EXT SWAP: ok
  ----------------------------------------------------------------------*/
ir_index swap_fixois.ir_index_ois_leg(error_info option(nullable) error )
{
	
	return swap_gen.swap_ir_index_leg2(error);
}
/*-----------------------------------------------------------------------
  swap_fixois: ir_index
  ----------------------------------------------------------------------*/
ir_index swap_fixois.ir_index(error_info option(nullable) error) option(hidden)
{
	
	return swap_gen.swap_ir_index_leg2(error);
}

/*-----------------------------------------------------------------------
  index_tenor_ois_leg		EXT SWAP: ok
  ----------------------------------------------------------------------*/
string swap_fixois.index_tenor_ois_leg(error_info option(nullable) error ) 
{
	
	return swap_gen.swap_index_tenor_leg2(error);
}

/*-----------------------------------------------------------------------
  index_tenor_code_ois_leg		EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_code swap_fixois.index_tenor_code_ois_leg(error_info option(nullable) error ) 
{
	
	return swap_gen.swap_index_tenor_code_leg2(error);
}

/*-----------------------------------------------------------------------
  swap_fixois: disc_func_fix_leg / disc_func_ois_leg
  ----------------------------------------------------------------------*/
disc_func swap_fixois.disc_func_fix_leg(error_info option(nullable) error) 	{ return swap_gen.swap_disc_func_leg1(error);}
disc_func swap_fixois.disc_func_ois_leg(error_info option(nullable) error) 	{ return swap_gen.swap_disc_func_leg2(error);}

/*-----------------------------------------------------------------------
  tenor_surface_ois_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_fixois.tenor_surface_ois_leg(error_info option(nullable) error )	{ return swap_gen.swap_tenor_surface_leg2(error);}



/*-----------------------------------------------------------------------
  fwd_func_ois_leg   EXT SWAP: ok  null if 
  ----------------------------------------------------------------------*/
fwd_func swap_fixois.fwd_func_ois_leg(error_info option(nullable) error )
{
	try{
		error_info  ee = new error_info(true,true);
		ql_ois_leg l = this.ois_leg(false,ee);
		return l.fwd_func();
		}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.fwd_func_ois_leg");
		return null<fwd_func>;
	}
}

	/* swap display notes, carry_rolldown.pdf.

	Roll-down and carry allow an investor to estimate the PNL of a swap over a given horizon assuming an unchanged rate
	environment.
	Ex. receiving fixed position on an interest rate swap:
	The carry on a swap is the difference between what the investor receives (a fixed coupon) and what the investor
	pays (a	floating financing rate) over the investment horizon.
	Implicitly, the carry can be “locked in” at the inception of the swap by paying on the swap (at the same rate) forward to
	the horizon date, and the forward price of this swap should reflect this carry.  That is, Forward Price = Spot Price - Carry

	Carry can be determined by today’s market prices. The roll-down of a swap makes an assumption about the shape of the curve at horizon.  
	
	1.	Upfront Carry (Basis points upfront or absolute return): 
		- 	For a 10-year receive fixed swap, the 1 year carry is the net present value of a 10-year swap less the net present value 
			of a 9-year swap starting 1 year from now. 
	2.	Upfront Roll-down (Basis points upfront or absolute return): 
		- 	For a 10-year receive fixed swap, the 1 year roll-down is the net present value of a 10-year swap and less net present value 
			of a 9-year swap today. 
		- 	Typical display will have carry and roll-down for various swap lengths: 1M, 2M, 3M etc. So a 1 year carry can 
			be provided as 0.45 $ per 100 $ of notional or some other dollar convention.
	
		Receiving 5s: 6m Carry and Roll Down 
		Carry = F[0, 5](r5) - F[0.5, 4.5](r5) = - F[0.5, 4.5](r5)  
		Rolldown = F[0, 4.5](r5) - F[0, 5](r5) = F[0, 4.5](r5)
		F = pv = basispoints 
		F = 0.0035 --> 350000 for 100MM notional 

	We often prefer to view the value in bps running.  Intuitively, this represents how far the yield curve must move for the
	carry to disappear.  That is, if carry is 10 bps running but rates sell off more than 10 bps, then the position will have
	lost as much as it earned in carry.  
 	
	3.	Running Carry:
		- 	the Upfront Carry divided by the pvbp of the forward starting 9-year swap or just the fwd yield. 
	4.	Running Roll-down:
		- 	the Upfront roll-down divided by the pvbp of the 9-year swap starting today. 

		bps Running
		Receiving 5s: 6m Carry and Roll Down  
		Carry = r[0.5, 4.5] - r[0, 5]  
		Rolldown = r[0, 5] - r[0, 4.5] 

	5.	Actual Vol-adjusted Running Carry & Running Roll-down: 
		- 	1Y Running Carry or Running Roll-down divided by the actual volatility of the 1Y rate over the past 1 year. 
	6.	Notional Neutral Switch:
		- 	Typically quoted as where one receives fixed for the shorter rate and pays fixed for the longer rate. 
		-	If the expected carry and roll-down is 180bps on a 5s/30s --> for an investor, who receives fixed on a 5 year swap 1mn notional 
			and pays fixed on a 30 year swap 1mn notional -- expected profit is 180,000. 
	7.	Duration Neutral Switch:
		-	Typically quoted as where one receives fixed for the shorter rate and pays fixed for the longer rate. 
		-	The notionals can vary here such that the durations cancel out. 
	8.	Butterfly:
		-	Quoted as 2bps on a 3s/4s/15s --> expected roll-down and carry as pay fixed on the 3yr and the 15yr, and receive the 4yr fixed rate.

	
Adjusting for Volatility 
Basis Points Running Carry and Roll-down Divided by Actual Basis Point Volatility
 
In order to adjust the expected roll-down and carry for the risk or volatility of each sector, as well as the duration, we divide
the expected roll-down and carry in basis point running terms by the actual volatility of the rate.  Actual volatility is taken over
the horizon of the roll-down and carry analysis.  For example, we divide the 2M expected roll-down and carry by the actual
volatility of the sector over the past two months. 

Curve Trades: Basis Point Upfront Carry and Roll-down
We assume the investor expresses a notional neutral curve switch.  The expected roll-down and carry is expressed in
basis points upfront on the curve switch, where we assume that the investor receives fixed on the shorter rate versus
paying fixed on the longer rate.  For example, if the expected roll-down and carry for a 2s/10s trade is -110bp, an investor
who receives fixed on $100mm of a 2-year swap versus paying fixed on $100mm of a 10-year swap would incur an
expected loss of $1,100,000 due to roll-down and carry over the horizon of the analysis. 

Curve Trades: Basis Point Running Carry and Roll-down 
We assume the investor expresses a duration neutral curve switch.  The expected roll-down and carry is expressed in
basis points running on the curve switch, where we assume that the investor receives fixed on the shorter rate versus
pays fixed on the longer rate (expresses a steepener). For example, a result of 15bp for a 2s/10s curve switch suggests
that expressing a 2s/10s duration neutral curve steepener results in 15bp running of expected roll-down and carry over
the time horizon.  If the investor expressed the steepener with a risk of $100,000 per basis point, the 15bp running of 
expected roll-down and carry would equate to $1,500,000. 

Butterfly Trades: Basis Point Running Carry and Roll-down
We assume the investor expresses a duration neutral butterfly position where the wings are weighted evenly (50/50
risk weighting).  The expected roll-down and carry is expressed in basis points running on the butterfly trade
where the investor receives fixed on the belly versus pays fixed on the wings. For example, a result of 2bp for a
2s/5s/10s butterfly suggests that expressing a long position in the 5-year rate versus the wings (2s and 10s) would result
in 2bp running of expected roll-down and carry over the horizon period.

*/

/*-----------------------------------------------------------------------
  upfront_carry		EXT SWAP: ok
  the carry on a swap is the difference between what the investor
	receives (a fixed coupon) and what the investor pays (a	floating financing rate) over the investment horizon. 
	Implicitly, the carry can be �locked in� at the inception of the swap by paying on the swap (at the same rate) forward to
	the horizon date, and the forward price of this swap should reflect this carry.  That is, Forward Price = Spot Price - Carry

	Carry can be determined by today�s market prices. The roll-down of a swap makes an assumption about the shape of the curve at horizon.
  ----------------------------------------------------------------------*/
void swap_fixois.upfront_carry_all(	out date  	fwd_trade_date,//can be both input and output
									out date 	fwd_settle_date,//can be both input and output									
									out number 	carry_pv,
									out number 	carry,
									out number 	carry_pv_ai_adj,
									out number 	carry_ai_adj,
									//out number 	carry_spot_fix_leg,
									//out number 	carry_spot_ois_leg,
									out number  npv_spot_fix_leg,	
									out number 	npv_spot_ois_leg,
									out number  npv_fwd_fix_leg,	
									out number 	npv_fwd_ois_leg,
									out number  reinv_irim_cf_fix_leg,									
									out number 	reinv_irim_cf_ois_leg,									
									out number  irim_cf_fix_leg,									
									out number 	irim_cf_ois_leg,
									error_info option(nullable) error )
{
	
	try {

		error_info ee = new error_info(true,true);
		logical roll_compat = false;
		CORE_INT_FIXFLT.fwd_date_adjust(fwd_trade_date,fwd_settle_date,this.swap_gen.calendar(ee), date_code(this.settle_code(ee)));					
		carry_result res = new carry_result;
		swap_gen.swap_upfront_carry(fwd_trade_date,fwd_settle_date,roll_compat,res,ee);

		carry_pv 				= res.carry_pv;//carry_spot_fix_leg + carry_spot_flt_leg;
		carry 					= res.carry;//carry_fwd_fix_leg + carry_fwd_flt_leg - npv_spot_ir_cost;
		carry_pv_ai_adj 		= res.carry_pv_ai_adj;//carry_spot_ai_fix_leg + carry_spot_ai_flt_leg;	
		carry_ai_adj 			= res.carry_ai_adj;//carry_fwd_ai_fix_leg + carry_fwd_ai_flt_leg - npv_spot_ir_cost;
		npv_spot_fix_leg		= res.npv_spot_leg1;	
		npv_spot_ois_leg		= res.npv_spot_leg2;	
		npv_fwd_fix_leg			= res.npv_fwd_leg1;	
		npv_fwd_ois_leg			= res.npv_fwd_leg2;	
		reinv_irim_cf_fix_leg	= res.reinv_irim_cf_leg1;										
		reinv_irim_cf_ois_leg	= res.reinv_irim_cf_leg2;						
		irim_cf_fix_leg			= res.irim_cf_leg1;					
		irim_cf_ois_leg			= res.irim_cf_leg2;
		
		return ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.upfront_carry");
		carry_pv  =  carry  =  npv_spot_fix_leg= null<number>;
		npv_spot_ois_leg =  npv_fwd_fix_leg =  npv_fwd_ois_leg = null<number>;
		reinv_irim_cf_fix_leg =  reinv_irim_cf_ois_leg =  irim_cf_fix_leg =  irim_cf_ois_leg = null<number>;
		carry_pv_ai_adj = carry_ai_adj =  null<number>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  carry		EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*void swap_fixois.carry(	out date  	fwd_trade_date,//can be both input and output
						out date 	fwd_settle_date,//can be both input and output
						logical 	incl_reinv_in_carry,
						out number  upfront_carry,
						out number  fwd_carry,
						out number  run_carry,
						out number  run_fwd_carry,
						error_info option(nullable) error )
{
	
	try {
		error_info ee = new error_info(true,true);
		CORE_INT_FIXFLT.fwd_date_adjust(fwd_trade_date,fwd_settle_date,this.calendar(ee), date_code(this.settle_code(ee)));			

		number carry_upfront_fix_leg, carry_upfront_ois_leg, carry_fwd_fix_leg, carry_fwd_ois_leg, npv_spot_fix_leg;
		number npv_spot_ois_leg, npv_fwd_fix_leg, npv_fwd_ois_leg, npv_fwd_spot_fix_leg, npv_fwd_spot_ois_leg;
		number reinv_irim_cf_fix_leg, reinv_irim_cf_ois_leg, irim_cf_fix_leg, irim_cf_ois_leg, pvadj_ai_spot_fix_leg;
		number pvadj_ai_spot_ois_leg, pvadj_ai_fwd_fix_leg, pvadj_ai_fwd_ois_leg,carry_upfront_ai_fix_leg,carry_upfront_ai_ois_leg;
		number carry_fwd_ai_fix_leg, carry_fwd_ai_ois_leg;
		
		instrument.swap_upfront_carry(fwd_trade_date,fwd_settle_date,incl_reinv_in_carry,
										carry_upfront_fix_leg,
										carry_upfront_ois_leg,
										carry_fwd_fix_leg,
										carry_fwd_ois_leg,
										npv_spot_fix_leg,
										npv_spot_ois_leg,
										npv_fwd_fix_leg,
										npv_fwd_ois_leg,
										npv_fwd_spot_fix_leg,
										npv_fwd_spot_ois_leg,
										reinv_irim_cf_fix_leg,
										reinv_irim_cf_ois_leg,
										irim_cf_fix_leg,
										irim_cf_ois_leg,
										pvadj_ai_spot_fix_leg,
										pvadj_ai_spot_ois_leg,
										pvadj_ai_fwd_fix_leg,
										pvadj_ai_fwd_ois_leg,
										carry_upfront_ai_fix_leg,
										carry_upfront_ai_ois_leg,
										carry_fwd_ai_fix_leg,
										carry_fwd_ai_ois_leg,error);

		upfront_carry 	= carry_upfront_fix_leg+carry_upfront_ois_leg;
		fwd_carry		= carry_fwd_fix_leg+carry_fwd_ois_leg;
		swap_fixois sw_fwd = new swap_fixois(this);
		sw_fwd = sw_fwd.set_date(this.trade_date(ee),fwd_settle_date,ee);

		number _pv01 = sw_fwd.pv01();
		run_carry = upfront_carry / _pv01;
		run_fwd_carry = fwd_carry / _pv01;
		
		
			
		return ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.run_carry");
		upfront_carry = fwd_carry = run_carry = run_fwd_carry = null<number>;
		return ;
	}
}*/
/*-----------------------------------------------------------------------
  upfront_rolldown		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fixois.upfront_rolldown_all(	out date  	fwd_trade_date,//can be both input and output
										out date 	fwd_settle_date,//can be both input and output
										logical		incl_reinv_in_roll,
										out number 	roll_pv,
										out number 	roll,
										out number 	roll_pv_ai_adj,
										out number 	roll_ai_adj,
										
										out number  npv_spot_fix_leg,	
										out number 	npv_spot_ois_leg,
										out number  npv_fwd_fix_leg,	
										out number 	npv_fwd_ois_leg,
										out number  reinv_irim_cf_fix_leg,									
										out number 	reinv_irim_cf_ois_leg,									
										out number  irim_cf_fix_leg,									
										out number 	irim_cf_ois_leg,
										error_info option(nullable) error )
{
	
	try {
		rolldown_result res = new rolldown_result;
		error_info ee 		= new error_info(true,true);
		swap_gen.swap_upfront_rolldown(fwd_trade_date, fwd_settle_date, incl_reinv_in_roll,res,  ee);

		roll_pv 				= res.roll_pv;
		roll 					= res.roll;		
		roll_pv_ai_adj 			= res.roll_pv_ai_adj;
		roll_ai_adj 			= res.roll_ai_adj;

		npv_spot_fix_leg		= res.npv_spot_leg1	;
		npv_spot_ois_leg		= res.npv_spot_leg2	;
		npv_fwd_fix_leg			= res.npv_fwd_leg1	;	
		npv_fwd_ois_leg			= res.npv_fwd_leg2	;
		reinv_irim_cf_fix_leg	= res.reinv_irim_cf_leg1;									
		reinv_irim_cf_ois_leg	= res.reinv_irim_cf_leg2;									
		irim_cf_fix_leg			= res.irim_cf_leg1	;									
		irim_cf_ois_leg			= res.irim_cf_leg2	;
		//npv_spot_ir_fix_leg		= res.npv_spot_ir_leg1	;
		//npv_spot_ir_ois_leg		= res.npv_spot_ir_leg2	;
		
		
		return ;

	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.upfront_rolldown");
		roll_pv  =  roll  =  npv_spot_fix_leg= null<number>;
		npv_spot_ois_leg =  npv_fwd_fix_leg =  npv_fwd_ois_leg = null<number>;
		reinv_irim_cf_fix_leg =  reinv_irim_cf_ois_leg =  irim_cf_fix_leg =  irim_cf_ois_leg =  null<number>;
		roll_pv_ai_adj = roll_ai_adj =  null<number>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  run_rolldown		EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*number swap_fixois.run_rolldown(	out date  	fwd_trade_date,//can be both input and output
									out date 	fwd_settle_date,//can be both input and output
									logical		incl_reinv_in_roll,
									out number  roll_spot,										
									error_info option(nullable) error )
{
	
	try {
		error_info ee = new error_info(true,true);
		number  roll_spot_leg1, roll_spot_leg2, npv_leg1,npv_leg2, reinv_irim_cf_leg1,reinv_irim_cf_leg2;
		number irim_cf_leg1,irim_cf_leg2,npv_fwd_leg1,npv_fwd_leg2;
		
		CORE_INT_FIXFLT.fwd_date_adjust(fwd_trade_date,fwd_settle_date,this.calendar(ee), date_code(this.settle_code(ee)));
		instrument.swap_upfront_rolldown(	fwd_trade_date,fwd_settle_date,incl_reinv_in_roll,
														roll_spot_leg1,
														roll_spot_leg2,
														npv_leg1,
														npv_leg2,
														npv_fwd_leg1,
														npv_fwd_leg2,
														reinv_irim_cf_leg1,
														reinv_irim_cf_leg2,
														irim_cf_leg1,
														irim_cf_leg2,error);

		roll_spot = roll_spot_leg1+roll_spot_leg2;
		swap_fixois sw_fwd = new swap_fixois(this);
		sw_fwd = sw_fwd.set_date(fwd_trade_date,fwd_settle_date,ee);

		number _pv01 	= sw_fwd.pv01();
		number ccy 		= roll_spot / _pv01;
		
		//number cpn = this.coupon();
		//number rf = sw_fwd.imp_rate_fix_leg(npv,false,ee);
		//number ccy = (cpn-rf)*10000;
		return ccy;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.run_rolldown");
		roll_spot = null<number>;
		return null<number>;
	}
}*/
/*-----------------------------------------------------------------------
  solver
  ----------------------------------------------------------------------*/
number swap_fixois.solver(	number 				pv,
							swap_solver_code 	solver_code,
							logical option(nullable) trade_date_pv,
							error_info option(nullable) error)
{
	
	return swap_gen.solver(pv,solver_code,trade_date_pv,error);
}
/*-----------------------------------------------------------------------
  imp_rate_fix_leg    EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fixois.imp_rate_fix_leg(	number 							swap_pv,							
										logical option(nullable) 		trade_date_pv,
										error_info option(nullable) 	error ) 
{	
	return swap_gen.imp_rate_fix_leg(swap_pv,trade_date_pv,error);
}

/*-----------------------------------------------------------------------
  imp_spread_flt_leg    EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fixois.imp_spread_ois_leg(	number 						swap_pv,							
										logical option(nullable) 	trade_date_pv,
										error_info option(nullable) error ) 
{	
	try{
		
		instr_error_type t;
   		string 			s;	
		number c = i().__swap_imp_ois_sprd(swap_pv,trade_date_pv,false,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fixois.imp_spread_ois_leg");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.imp_spread_ois_leg");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  swap_instrument
  ----------------------------------------------------------------------*/
ql_fixed_income_swap swap_fixois.swap_instrument(error_info option(nullable) error)
{
	
	return swap_gen.swap_instrument(error);

}
/*-----------------------------------------------------------------------
  swap_leg
  ----------------------------------------------------------------------*/
vector(ql_swap_leg) swap_fixois.legs(logical clone,error_info option(nullable) error)
{
	
	return swap_gen.swap_leg(clone,error);
}

/*-----------------------------------------------------------------------
  fix_leg
  ----------------------------------------------------------------------*/
ql_fix_leg swap_fixois.fix_leg(logical clone,error_info option(nullable) error)
{
	SWAP_ENTRY_FUNC();
	vector(ql_fix_leg) l = swap_gen.swap_fix_leg(clone,error);
	return !null(l) ? l[0] : null<ql_fix_leg>;
}

/*-----------------------------------------------------------------------
  ois_leg
  ----------------------------------------------------------------------*/
ql_ois_leg swap_fixois.ois_leg(logical clone,error_info option(nullable) error)
{
	SWAP_ENTRY_FUNC();
	vector(ql_ois_leg) l = swap_gen.swap_ois_leg(clone,error);
	return !null(l) ? l[0] : null<ql_ois_leg>;
}

/*-----------------------------------------------------------------------
  get_legs	EXT SWAP: ok  prot
  ----------------------------------------------------------------------*/
void  swap_fixois.get_legs(	out ql_fix_leg  leg1, 
							out ql_ois_leg  leg2) 
{	
	leg1 = fix_leg(false);
	leg2 = ois_leg(false);
}


/*-----------------------------------------------------------------------
  is_par_flat (must be par, have flat floatleg, non-aged, ...)  EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical	 swap_fixois.is_par_flat(error_info option(nullable) error )
{
	try{
		
		if(!ext_swap_)
			return true;

		error_info ee = new error_info(true,true);
		
		if(this.settle_date(ee) != this.issue_date(ee))
			return false;

		//number quote_fix_leg;		
		number quote_ois_leg = this.spread_ois_leg(ee) ;
		
		if(null(quote_ois_leg))
			return false;
		
		if(!CORE_INT.is_equal_zero(quote_ois_leg ))
			return false;
				
		number pv1,pv2;
		number pv = this.present_value(pv1,pv2,false,ee);
		
		if(null(pv))
			return false;

		if(!CORE_INT.is_equal_zero(pv ))
			return false;				

		return true;
	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.is_par_flat");
		return null<logical>;
	}
}


/*-----------------------------------------------------------------------
  present_value
  ----------------------------------------------------------------------*/
number swap_fixois.present_value(	disc_func option(nullable)	disc_func_fix_leg,
									disc_func option(nullable) 	disc_func_ois_leg,
									out number  pv_fix_leg,
									out number  pv_ois_leg,
									number option(nullable) 	notional,
									logical option(nullable) 	trade_date_pv,																								
									error_info option(nullable) error)
{
	
	return swap_gen.present_value(disc_func_fix_leg,disc_func_ois_leg,pv_fix_leg,pv_ois_leg,notional,trade_date_pv,error);
}

number swap_fixois.present_value(	disc_func option(nullable)	disc_func_fix_leg,
									disc_func option(nullable) 	disc_func_ois_leg,
									out number  pv_fix_leg,
									out number  pv_ois_leg,
									date option(nullable) pv_date,
									date option(nullable) settle_date,
									logical  	incl_issue_cf,
									logical  	incl_mat_cf,	
									error_info option(nullable) error)
{
	
	return swap_gen.present_value(disc_func_fix_leg,disc_func_ois_leg,pv_fix_leg,pv_ois_leg,pv_date, settle_date ,incl_issue_cf,incl_mat_cf,error );
}

number swap_fixois.present_value(	out number  pv_fix_leg,
									out number  pv_ois_leg,
									logical option(nullable) 	trade_date_pv,	
									error_info option(nullable) error)
{
	
	return swap_gen.present_value(pv_fix_leg,pv_ois_leg,trade_date_pv ,error );
}

/*-----------------------------------------------------------------------
  present_value_fee
  ----------------------------------------------------------------------*/
number swap_fixois.present_value_fee(disc_func option(nullable)	disc_func_fix_leg,
									disc_func option(nullable) 	disc_func_ois_leg,
									out number  				pv_fee_fix_leg,
									out number  				pv_fee_ois_leg,
									date option(nullable) 		pv_date,
									date option(nullable) 		settle_date,
									logical  					incl_issue_cf,
									logical  					incl_mat_cf,	
									error_info option(nullable) error )
{
	
	return swap_gen.present_value_fee(disc_func_fix_leg,disc_func_ois_leg,pv_fee_fix_leg,pv_fee_ois_leg,pv_date, settle_date ,incl_issue_cf,incl_mat_cf,error );
}

/*-----------------------------------------------------------------------
  swap_fixois: yield,  for backward compat reasons
  ----------------------------------------------------------------------*/
number  swap_fixois.yield(	logical 	disable_rounding,
							error_info option(nullable) error )  option(hidden)
{ 
	try {
		//QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);
		error_info ee 	= new error_info(true,true);
		
		number cpnr 	= this.coupon_fix_leg(ee);
		
		if(!ext_swap_) {
			number y = instrument.yield(false,ee);
			if(CORE_INT.is_equal(cpnr,y))
				return y;
			else
				QL_FAIL("yield for non-par swaps not supported");
		}
			
		disc_func df 	= this.disc_func_fix_leg(ee);
		if(null(df)) {
			return this.coupon_rate(ee);
		}
		else {
			number y = swap_gen.yield(df, false , ee );
			if(CORE_INT.is_equal(cpnr,y))
				return y;
			else
				QL_FAIL("yield for non-par swaps not supported");
		}

		/*
		if(!ext_swap_)
			return instrument.yield(disable_rounding,error);

		error_info ee 	= new error_info(true,true);
		disc_func df 	= this.disc_func_fix_leg(ee);
		if(null(df))
			return this.coupon_rate(ee);
		else
			return swap_gen.yield(df, disable_rounding , error );*/
	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.yield");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  yield,  for backward compat reasons
  ----------------------------------------------------------------------*/
number  swap_fixois.yield(	disc_func		disc_func,
							logical 		disable_rounding ,								
							error_info option(nullable) error ) option(hidden)
{
	return swap_gen.yield(	disc_func, disable_rounding , error );
}
/*-----------------------------------------------------------------------
   par_rate_fix_leg
  ----------------------------------------------------------------------*/
number  swap_fixois.par_rate_fix_leg(	disc_func		disc_func,
										error_info option(nullable) error)
{
	return swap_gen.par_rate_fix_leg(disc_func,error);
}
/*-----------------------------------------------------------------------
  swap_fixois: yield,  for backward compat reasons 
  ----------------------------------------------------------------------*/
number  swap_fixois.quote(	disc_func		df_fix_leg,
							..quote_style option(nullable) qs,	 							
							error_info option(nullable) error ) option(hidden)
{ 
	try {
		QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);
		
		//return instrument.quote(disc_func,quote_style,error);

		error_info ee 	= new error_info(true,false);
		fwd_func ff = this.fwd_func_ois_leg(ee);
		if(ee.is_error() || null(ff))
			return instrument.quote(df_fix_leg,qs,error);

		if(null(qs)) {
			qs = quote_style_e(ee);			
		}

		logical ok_qs = qs == ..quote_style.YIELD || qs == ..quote_style.YIELD_PCT;
		QL_FAIL_COND(null(qs) || !ok_qs ,"invalid quote style", this,true);
		
		if(ccy_swap_) {

			disc_func df 	= this.disc_func_ois_leg(ee);
			QL_FAIL_COND(ee.is_error() || null(df),"discount function for ois leg not set (required for cross currency swaps)", this,true);
		}

		disc_func dffix_orig 	= this.disc_func_fix_leg(ee);
		
		if(!ccy_swap_) {
			tenor_surface ts;
			this.add_disc_func(df_fix_leg,false,ts);
		}
		else {
			this.add_disc_func_fix_leg(df_fix_leg);
		}
		
		number q = this.imp_rate_fix_leg(0,false,ee);

		if(qs == ..quote_style.YIELD_PCT){
			q *= 100;
		}		

		if(!ccy_swap_) {
			tenor_surface ts;
			this.add_disc_func(dffix_orig,false,ts);
		}
		else {
			this.add_disc_func_fix_leg(dffix_orig);
		}
		
		return q;
							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.quote");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  mac_dur      <public>
  ----------------------------------------------------------------------*/
number  swap_fixois.mac_dur(error_info option(nullable) error) 
{	
	try{
		//if(!ext_swap_)
			//return instrument.mac_dur(error);

		QL_FAIL("work in progress for fixois swaps",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.mac_dur");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  mod_dur      <public>
  ----------------------------------------------------------------------*/
number  swap_fixois.mod_dur(error_info option(nullable) error) 
{	
	try{
		//if(!ext_swap_)
			//return instrument.mac_dur(error);

		QL_FAIL("work in progress for fixois swaps",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.mac_dur");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  dol_dur      <public>
  ----------------------------------------------------------------------*/
number  swap_fixois.dol_dur(error_info option(nullable) error) 
{	
	try{
		//if(!ext_swap_)
			//return instrument.mac_dur(error);

		QL_FAIL("work in progress for fixois swaps",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.dol_dur");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  fix_leg_y_to_pv
  ----------------------------------------------------------------------*/
/*number  swap_fixois.fix_leg_y_to_pv(number option(nullable)	yield,
									logical 				in_pcnt,
									error_info option(nullable) error) 
{	
	return instrument.fix_leg_y_to_pv(yield, in_pcnt, error);
}*/


/*-----------------------------------------------------------------------
  final_pmt_date	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.final_pmt_date(out date 	final_pmt_date_fix_leg,									
								out date 	final_pmt_date_ois_leg,
								error_info option(nullable) error ) 
{	
	swap_gen.final_pmt_date( final_pmt_date_fix_leg, final_pmt_date_ois_leg, error ) ;
}

/*-----------------------------------------------------------------------
  payment_data_fix_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.payment_data_fix_leg( logical 				post_settle,
									logical option(nullable) trade_date_pv,									
									out vector(date)  		pmt_date,
									out vector(number) 		cpn_rate,
									out vector(number)  	cpn_cashflow,
									out vector(number)  	pv_cpn_cashflow,
									out vector(number)  	fee,
									out vector(number)  	pv_fee,
									out vector(number)  	notional ,
									error_info option(nullable)  error ) 
{	
	swap_gen.payment_data_fix_leg(false, post_settle, trade_date_pv, pmt_date,cpn_rate,cpn_cashflow,pv_cpn_cashflow,
								fee,pv_fee, notional, error);
						
							
	
}
/*-----------------------------------------------------------------------
  payment_data_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.payment_data_ois_leg( logical 				post_settle,
									logical option(nullable) trade_date_pv,
									out vector(date)  		fixing_date,
									out vector(number)  	fixing_rate,
									out vector(logical)  	is_fixed,									
									out vector(date)  		pmt_date,
									out vector(number) 		cpn_rate,
									out vector(number)  	cpn_cashflow,
									out vector(number)  	pv_cpn_cashflow,
									out vector(number)  	fee,
									out vector(number)  	pv_fee,
									out vector(number)  	notional ,
									error_info option(nullable)  error ) 
{	
	swap_gen.payment_data_ois_leg(true, post_settle, trade_date_pv, fixing_date, fixing_rate,
						  is_fixed,pmt_date,cpn_rate,cpn_cashflow,pv_cpn_cashflow,
						  fee,pv_fee, notional, error);
						
							
	
}

/*-----------------------------------------------------------------------
  principal_data_fix_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.principal_data_fix_leg(logical 				post_settle,
										logical option(nullable) trade_date_pv,
										logical 				only_real_cf,
										out vector(date) 		prin_date,
										out vector(number) 		prin_cf,	
										out vector(number) 		pv_prin_cf,
										error_info option(nullable)  error )
{
	swap_gen.principal_data_fix_leg(false, post_settle, trade_date_pv, only_real_cf,
									prin_date,prin_cf,pv_prin_cf,error);
}
/*-----------------------------------------------------------------------
  principal_data_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fixois.principal_data_ois_leg( logical 				post_settle,
										logical option(nullable) trade_date_pv,
										logical 				only_real_cf,
										out vector(date) 		prin_date,
										out vector(number) 		prin_cf,	
										out vector(number) 		pv_prin_cf,
										error_info option(nullable)  error )
{
	swap_gen.principal_data_ois_leg(true, post_settle, trade_date_pv, only_real_cf,
									prin_date,prin_cf,pv_prin_cf,error);
}