option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	swap_fltflt
	Note:
	for db-swaps: leg1 is the spread leg i.e. the swap is leg1 + quote = leg2, leg1 is specified in the general tab

	MTM for cross currency basis swaps
	------------------------------------
	- is Standard for Interbank Trades
	- non-MTM swaps exist but are less common in wholesale markets
	- USD as Base Currency Convention; USD legs typically serve as the base (meaning non-USD legs get adjusted)

	In a marked-to-market CCS one trade leg will have a constant notional and the other trade leg
	will have the equivalent FX forward adjusted notional. The trade leg with the variable notional
	is called the reset leg. The change in notional is called the notional reset or notional exchange.
	Investors are required to settle this difference in notional on a cashflow by cashflow basis.
	Notional resets are typically applied on the CCS trade leg denominated in the valuation currency.
 
	--------------------------------------------------------------------
*/

//----------------------------------------------------------------------
//  class swap_fltflt
//----------------------------------------------------------------------
class swap_fltflt: public swap_gen
option(category: "Instrument/Interest Rate Swap/Float vs Float")
//option(allow_undeclared_mfuncs)
{
public:
    //override string			instr_type_s();
	override instrument 	inst();
	override swap_fltflt 	clone();

	override void         __dbg_print(__dbg_label);
    override void         __dbg_browse(__dbg_split);
	
	/*----------ADD FUNCS [PUBLIC]---------------*/
	void 		add_quote(number,..quote_style );//???i.e. means add new cpn --> should be a new instrument
	override void add_quote(number);
	void 		add_notional(number );
	void 		add_notional(number , number);
	//void 		add_notional_leg1(number );
	//void 		add_notional_leg2(number );
	void		add_fx_rate(number,logical,string,string );
	void 		add_fx_mult_leg1(number );
	void 		add_fx_mult_leg2(number );
	void 		add_disc_func(disc_func ); 
	void 		add_disc_func_leg1(disc_func );//note disc_func for mtm-feature not added here
	void 		add_disc_func_leg2(disc_func );	//note disc_func for mtm-feature not added here
	void 		add_surface_leg1(tenor_surface option(nullable));
	void 		add_surface_leg2(tenor_surface option(nullable));
	void		add_fixing_leg1(vector(date) ,vector(number) ,logical option(nullable) fixing_as_fwd = false);
	void		add_fixing_leg2(vector(date) ,vector(number) ,logical option(nullable) fixing_as_fwd = false);
	void		add_fixing_leg1(number ,logical option(nullable) fixing_as_fwd = false);
	void		add_fixing_leg2(number ,logical option(nullable) fixing_as_fwd = false);
	void 		add_data( 	number,disc_func,tenor_surface ,vector(date),vector(number) ,
							tenor_surface ,vector(date),vector(number) ,logical option(nullable) fixing_as_fwd = false,
							logical upd_null_crv = false,logical upd_null_fix = false);
	void		add_ccy_data(number,disc_func,number,tenor_surface,vector(date),vector(number) ,number ,
							disc_func ,number,tenor_surface,vector(date) ,vector(number) ,
							logical option(nullable) fixing_as_fwd = false,
							 logical upd_null_crv = false,logical upd_null_fix = false) ;
	void		add_mtm_data(number option(nullable),number option(nullable)	,string option(nullable)	,string option(nullable)	,
							 disc_func option(nullable) ,disc_func option(nullable) ) ;



	/*----------MISC FUNCS [PUBLIC]---------------*/
	date 		start_date(error_info option(nullable) error = null<error_info> );				/*name change of issuedate*/
	//logical	is_par_flat(error_info option(nullable) error = null<error_info>);
	logical 	pay_leg1(error_info option(nullable) error = null<error_info> );
	logical		is_cross_currency(error_info option(nullable) error = null<error_info>);
	void 		is_regular_first(out logical option(nullable), out logical option(nullable),error_info option(nullable) error = null<error_info> );				
	void 		is_regular_last(out logical option(nullable), out logical option(nullable),error_info option(nullable) error = null<error_info> );			
	override void notional(out number, out number,error_info option(nullable) error = null<error_info> );
	number 		notional(error_info option(nullable) error = null<error_info>);
	override void 	fx_mult_factor(out number, out number,error_info option(nullable) error = null<error_info> );
	override void 	currency(out string, out string,error_info option(nullable) error = null<error_info> );
	override void 	coupon(out number  option(nullable),out number  option(nullable),error_info option(nullable) error = null<error_info> );
	override void 	coupon_freq(out integer,out integer,error_info option(nullable) error = null<error_info> );
	override void 	reset_freq(out integer,out integer,error_info option(nullable) error = null<error_info> );	
	override void 	dc_method(	out day_count_method , out day_count_method ,error_info option(nullable) error = null<error_info> );								
	override void  	pmt_bus_day(out bd_convention option(nullable), out bd_convention option(nullable),error_info option(nullable) error = null<error_info> );		
	override void 	roll_day(out integer,out integer,error_info option(nullable) error = null<error_info> );
	override void 	eom(out logical option(nullable),out logical option(nullable),error_info option(nullable) error = null<error_info> );
	override void 	calendar(out ..calendar option(nullable),out ..calendar option(nullable),error_info option(nullable) error = null<error_info> );
	override void 	quote(out number  option(nullable),out number  option(nullable),error_info option(nullable) error = null<error_info> );
	override void  	first_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	override void  	last_reg_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	override void  	effective_date(	out date , out date , error_info option(nullable) error = null<error_info>);

	override void	calendar_name(out string ,out string  , error_info option(nullable) error = null<error_info> ) ;

	void 			pmt_lag(out	integer 	pmt_lag_leg1,
							out	integer 	mat_pmt_lag_leg1,
							out	integer 	pmt_lag_prin_leg1,
							out	integer 	mat_pmt_lag_prin_leg1,
							out	integer 	pmt_lag_leg2,
							out	integer 	mat_pmt_lag_leg2,
							out	integer 	pmt_lag_prin_leg2,
							out	integer 	mat_pmt_lag_prin_leg2,	
							error_info option(nullable) error) ;
	
	/*----------CASHFLOW FUNCS [PUBLIC]---------------*/
	override void	cash_flow_dates(logical,out vector(date) ,out vector(date) ,error_info option(nullable) error = null<error_info> ) ;
	override void	cash_flows_cpn(logical,out vector(number) ,out vector(number),error_info option(nullable) error = null<error_info> );
	override void	cash_flows(logical,out vector(number) ,out vector(number),error_info option(nullable) error = null<error_info> );
	override void	cash_flow_data(logical,ir_cf_code cf_code,out vector(date)   ,out vector(number)   ,
											out vector(date)    ,out vector(number)   ,error_info option(nullable) error = null<error_info> );
	override void 	cash_flow_data(logical,logical option(nullable),out vector(date)   ,out vector(number)  ,
											out vector(number)   ,out vector(number)   ,
											out vector(number)   ,out vector(number)   ,
											out vector(number)  ,out vector(date)   	,
											out vector(number)   ,out vector(number)   ,
											out vector(number)   ,out vector(number)   ,
											out vector(number)   ,out vector(number)   ,
											error_info option(nullable) error = null<error_info> ); 

	
	/*----------PV FUNCS [PUBLIC]---------------*/
	override number  	present_value(	disc_func option(nullable),disc_func option(nullable),out number ,
											out number ,number option(nullable),logical option(nullable)  trade_date_pv = false,		
											error_info option(nullable) error = null<error_info> );

	override number  	present_value(	disc_func option(nullable),disc_func option(nullable),out number ,out number ,
											date option(nullable) ,date option(nullable) ,
											logical,logical  ,error_info option(nullable) error = null<error_info>);

	override number  	present_value(	out number ,out number ,
											logical option(nullable) ,error_info option(nullable) error = null<error_info> );

	override number 	accrued(logical,out number,out number,error_info option(nullable) error = null<error_info>);

	override void 		accrued_period(out number,out number,
										out integer,out integer,error_info option(nullable) error = null<error_info>);		

	override number 	accrued_chg  (integer bus_days, out	number option(nullable)	,out number,
										out	number option(nullable)	,out number ,
										out date ,out date ,error_info option(nullable) error = null<error_info> ); 


	//void			implied_par_funcs(	...)

	override number		solver(number,swap_solver_code ,logical option(nullable) trade_date_pv = false,
									error_info option(nullable) error = null<error_info>);

	number  			pvdiff_curve_shift(	number option(nullable) ,number option(nullable),number option(nullable) ,number option(nullable) ,
										logical option(nullable) ,logical option(nullable) ,out number ,out number,out number ,
										error_info option(nullable) error = null<error_info> ) ;

	number 		dv01(number option(nullable) delta = null<number>,logical option(nullable) trade_date_pv = false,
						error_info option(nullable) error  = null<error_info>) ;
	
	number 		dv01_disc(number option(nullable) delta = null<number>,  logical option(nullable) trade_date_pv = false,
							error_info option(nullable) error  = null<error_info>) ;

	number 		dv01_fwd(number option(nullable) delta = null<number>,  logical option(nullable) trade_date_pv = false,
						error_info option(nullable) error  = null<error_info>) ;

	/*----------LEG1/LEG2 FUNCS [PUBLIC]---------------*/
	flt_avg_method  	avg_method_leg1(error_info option(nullable) error = null<error_info>);
	flt_sprd_comp_method  sprd_comp_method_leg1(error_info option(nullable) error = null<error_info>);
	flt_comp_avg_type  	comp_avg_type_leg1(error_info option(nullable) error = null<error_info>);

	flt_avg_method  	avg_method_leg2(error_info option(nullable) error = null<error_info>);
	flt_sprd_comp_method  sprd_comp_method_leg2(error_info option(nullable) error = null<error_info>);
	flt_comp_avg_type  	comp_avg_type_leg2(error_info option(nullable) error = null<error_info>);
	
	logical  		is_mtm_leg1(error_info option(nullable) error= null<error_info> );
	logical  		is_mtm_leg2(error_info option(nullable) error= null<error_info> ) ;
	string			currency_leg1(error_info option(nullable) error = null<error_info> );
	string			currency_leg2(error_info option(nullable) error = null<error_info> );
	integer			reset_freq_leg1(error_info option(nullable) error = null<error_info> );
	integer			reset_freq_leg2(error_info option(nullable) error = null<error_info> );
	integer			coupon_freq_leg1(error_info option(nullable) error = null<error_info> );
	integer			coupon_freq_leg2(error_info option(nullable) error = null<error_info> );
	day_count_method dc_method_leg1(error_info option(nullable) error = null<error_info> );
	day_count_method dc_method_leg2(error_info option(nullable) error = null<error_info> );

	interest_rule  ir_rule_leg1(error_info option(nullable) error = null<error_info>);
	interest_rule  ir_rule_leg2(error_info option(nullable) error = null<error_info>);
	
	number			spread_leg1(error_info option(nullable) error = null<error_info> );
	number			spread_leg2(error_info option(nullable) error = null<error_info> );
	void			index_dates_leg1(logical,out vector(date)  ,out vector(date)  ,
												out vector(logical)option(nullable) ,error_info option(nullable) error = null<error_info> ) ;

	void			index_dates_leg2(logical,out vector(date)  ,out vector(date)  ,
												out vector(logical)option(nullable) ,error_info option(nullable) error = null<error_info> ) ;

	void			fixing_data_leg1(logical ,logical option(nullable),out vector(date)   ,									
												out vector(number)   ,out vector(logical) option(nullable),
												error_info option(nullable) error = null<error_info> ) ;
		
	void			fixing_data_leg2(logical ,logical option(nullable),out vector(date)   ,									
												out vector(number)   ,out vector(logical) option(nullable),
												error_info option(nullable) error = null<error_info> ) ;

	number			imp_spread_leg1(number,logical option(nullable) trade_date_pv = false,error_info option(nullable) error = null<error_info>);
	number			imp_spread_leg2(number,logical option(nullable) trade_date_pv = false,error_info option(nullable) error = null<error_info>);

	disc_func 		disc_func_leg1(error_info option(nullable) error = null<error_info> ) ;
	disc_func 		disc_func_leg2(error_info option(nullable) error = null<error_info> ) ;
	tenor_surface 	tenor_surface_leg1(error_info option(nullable) error = null<error_info>);
	tenor_surface 	tenor_surface_leg2(error_info option(nullable) error = null<error_info>);
	ir_index 		ir_index_leg1(error_info option(nullable) error = null<error_info> ); 
	ir_index 		ir_index_leg2(error_info option(nullable) error = null<error_info> ); 	
	string 			index_tenor_leg1(error_info option(nullable) error = null<error_info> ) ;
	string 			index_tenor_leg2(error_info option(nullable) error = null<error_info> ) ;
	tenor_code 		index_tenor_code_leg1(error_info option(nullable) error = null<error_info> ) ;
	tenor_code		index_tenor_code_leg2(error_info option(nullable) error = null<error_info> ) ;

	
	tenor_surface 	create_tenor_surface_leg1(disc_func ,fwd_func );
	tenor_surface 	create_tenor_surface_leg1(disc_func ,disc_func );
	tenor_surface 	create_tenor_surface_leg2(disc_func ,fwd_func );
	tenor_surface 	create_tenor_surface_leg2(disc_func ,disc_func );

	number			pv01_spread_leg1(number option(nullable)= null<number>,number option(nullable)= null<number>,
										disc_func option(nullable) df = null<disc_func>,
										error_info option(nullable) error = null<error_info>);
	
	number			pv01_spread_leg2(number option(nullable)= null<number>,number option(nullable)= null<number>,
										disc_func option(nullable) df = null<disc_func>,
										error_info option(nullable) error = null<error_info>);

	void 			payment_data_leg1(	logical,logical option(nullable),out vector(date) ,out vector(number) ,
										out vector(logical) ,out vector(date),out vector(number) ,out vector(number) ,out vector(number) ,
										out vector(number) ,out vector(number),out vector(number) ,
										error_info option(nullable)  error = null<error_info>) ;

	void 			principal_data_leg1(logical,logical option(nullable) ,logical ,
										out vector(date),out vector(number),out vector(number) ,
										error_info option(nullable)  error  = null<error_info>);

	void 			payment_data_leg2(logical,logical option(nullable),out vector(date) ,out vector(number) ,
										out vector(logical) ,out vector(date),out vector(number) ,out vector(number) ,out vector(number) ,
										out vector(number) ,out vector(number),out vector(number) ,
										error_info option(nullable)  error = null<error_info>) ;

	void 			principal_data_leg2(logical,logical option(nullable) ,logical ,
										out vector(date),out vector(number),out vector(number) ,
										error_info option(nullable)  error  = null<error_info>);
	
	/*-----external swap specific-----*/
	override ql_fixed_income_swap 	swap_instrument(error_info option(nullable) error = null<error_info>) ;
	override instrument_type 		swap_type(error_info option(nullable) error = null<error_info> );
	vector(ql_float_leg) 	float_legs(logical,error_info option(nullable) error = null<error_info>);
	vector(ql_swap_leg) 	legs(logical,error_info option(nullable) error = null<error_info>);

	/*---set functions-required--*/
	override swap_fltflt	set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);
	override swap_fltflt	set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);

	/*-----set functions-if applicable-----*/
	//swap_fltflt			set_spread_leg1(number option(nullable) ,error_info option(nullable) error = null<error_info>);
	//swap_fltflt			set_spread_leg2(number option(nullable) ,error_info option(nullable) error = null<error_info>);
	
	//local set funcs
	swap_fltflt				set_date(date,date option(nullable) s=null<date>,error_info option(nullable) error = null<error_info>);						
	swap_fltflt				set_pay_leg(logical ,error_info option(nullable) error = null<error_info>);
	
	//---------------------------------
	
	//--------------------------------------------------------------------------
	//----------HIDDEN FUNCS [PUBLIC]--(mostly for backward compat)-------------
	//--------------------------------------------------------------------------
	swap_fltflt(__instrument);
	
	//general-one per leg
	/*override calendar 			calendar(integer ,error_info option(nullable) error = null<error_info>  );		
	override calendar 			calendar(error_info option(nullable) error = null<error_info>  );				
	override string 			calendar_name(integer, error_info option(nullable) error = null<error_info> );	
	override string 			calendar_name(error_info option(nullable) error = null<error_info> );			
	override ir_index 			ir_index(error_info option(nullable) error = null<error_info> ); 				
	override string 			currency(error_info option(nullable) error = null<error_info> );				
	override day_count_method 	dc_method(error_info option(nullable) error = null<error_info> );										
	override integer 			coupon_freq(error_info option(nullable) error = null<error_info> );				
	override number 			coupon(error_info option(nullable) error = null<error_info> );					
	override number 			nominal(error_info option(nullable) error = null<error_info> );					
	override logical 			eom(error_info option(nullable) error = null<error_info>);						
	override integer			roll_day(error_info option(nullable) error = null<error_info>);					
	override bd_convention 		pmt_bus_day(error_info option(nullable) error = null<error_info> );				
	override date 				first_cpn_date(error_info option(nullable) error = null<error_info>);			
	override date 				last_reg_cpn_date(error_info option(nullable) error = null<error_info>);		
	override date 				cpn_start_date(error_info option(nullable) error = null<error_info>);*/			
	//general-one per swap
	//override date 				issue_date(error_info option(nullable) error = null<error_info> ); 		/*hidden, visible in root*/
	override string 			settle_code(error_info option(nullable) error = null<error_info> );		/*visible in root*/
	

	swap_fltflt(swap_fltflt);
protected:
	
	override swap_fltflt		create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);    	
	swap_fltflt					err_type(swap_fltflt option(nullable), error_info option(nullable) error = null<error_info>);

	

	//general
	
	
	/*override number 			present_value(	number option(nullable) nom=null<number>, logical dtt = false,
												disc_func option(nullable) dfd = null<disc_func>, 
												error_info option(nullable) error = null<error_info>);
	
	override number 			present_value(	disc_func,number option(nullable) nom=null<number>,logical dtt = false,
												disc_func option(nullable) dfd = null<disc_func>, 
												error_info option(nullable) error = null<error_info>);
	
	override number 			accrued(logical disable_rounding = false,logical in_pcnt = true,error_info option(nullable) error = null<error_info>);

	override number 			accrued_period(out integer,error_info option(nullable) error = null<error_info>);		
	
	override number 			accrued_chg(integer,out number,out date, 
									out date,logical in_pcnt = true,error_info option(nullable) error = null<error_info> ) ;	*/

	disc_func 					df_shifted(number,disc_func,logical);
	tenor_surface 				fwd_shifted(number ,disc_func,tenor_surface,logical);

	
	
	//cashflow
	/*override vector(date)	cash_flow_dates(logical post_settle = true, logical a = true, logical k = false, 
											error_info option(nullable) error = null<error_info>);
	override vector(number)	cash_flows_cpn(number option(nullable) nom = null<number>,logical posts = true,
												logical k = false,error_info option(nullable) error = null<error_info>);

	override void 			cash_flows(	out vector(date)  ,
											out vector(number)   ,
											number option(nullable) notional = null<number>,
											logical post_settle = true ,											
											error_info option(nullable) error = null<error_info> );			

	override vector(date)		cash_flow_dates_noadj(logical post_settle = true ,
													  error_info option(nullable) error = null<error_info>);				
	
	override vector(number)		cash_flow_amounts(	number option(nullable) nom = null<number>,
													logical post_settle = true,
													logical keep_size = false,
													error_info option(nullable) error = null<error_info> );			
	
	override vector(number)		cash_flow_nom_amounts(	number option(nullable) notional = null<number>,
														logical post_settle = true,
														logical keep_size = false,
														error_info option(nullable) error = null<error_info> );	
	
	override vector(number)	cash_flows(number option(nullable) nom = null<number>,logical posts = true,
											logical k = false,error_info option(nullable) error = null<error_info>);
	
	override void 			cash_flow_data(	number option(nullable) ,logical ,ir_cf_code ,logical,
												logical ,out vector(date)   ,
												out vector(number)   ,error_info option(nullable) error = null<error_info>);*/

	override number 		pvbp(number option(nullable),number option(nullable),logical option(nullable),
										logical option(nullable),	error_info option(nullable) error = null<error_info>) ; 
	override number 		pvbp(number option(nullable) ,number  option(nullable) ,error_info option(nullable) error = null<error_info>); 

	//set funcs
	override swap_fltflt	set_date(date,date option(nullable),logical,logical ,error_info option(nullable) error = null<error_info> );							
	override swap_fltflt	set_date(date,logical ,error_info option(nullable) error = null<error_info> );							/*legacy*/
	override swap_fltflt	move_date(	date,date option(nullable) s=null<date> , error_info option(nullable) error = null<error_info>);	/*legacy*/
		
												
	/*override number 		yield(logical dr = false,error_info option(nullable) error = null<error_info>);											
	override number 		yield(disc_func ,logical disable_rounding = false,error_info option(nullable) error = null<error_info>);

	override number 		dirty_price(number option(nullable)  ,logical disable_rounding = false,
									logical in_pcnt = true,error_info option(nullable) error = null<error_info>);
												
	override number  		dirty_price(logical disable_rounding = false,logical in_pcnt = true,
									error_info option(nullable) error = null<error_info>);
	
	override number  		dirty_price(disc_func,logical disable_rounding = false,
									logical in_pcnt = true,error_info option(nullable) error = null<error_info>);

	override number 		clean_price(number option(nullable),logical disable_rounding = false,
									logical in_pcnt = true,error_info option(nullable) error = null<error_info>);
													
	override number 		clean_price(logical disable_rounding = false,logical in_pcnt = true,
									error_info option(nullable) error = null<error_info>);
	
	override number 		clean_price(disc_func,logical disable_rounding = false,
									logical in_pcnt = true,error_info option(nullable) error = null<error_info>);
	
	override number 		dirty_price_to_yield(number ,logical,error_info option(nullable) error = null<error_info>);										
	override number 		clean_price_to_yield(number ,logical,error_info option(nullable) error = null<error_info>);										
	override number 		price_to_yield(number ,..quote_style, error_info option(nullable) error = null<error_info>);*/

	void  					get_legs(	out ql_float_leg,out ql_float_leg);
		
	
	
	//logical ext_swap_;
	//logical ccy_swap_;
	//logical full_swap_;
};

//------------------------------------------------
// __dbg_print
//------------------------------------------------
void swap_fltflt.__dbg_print(__dbg_label l)
{    
	error_info ee 	= new error_info(true,false);
    l.set_text(strcat([
						"name: ",
						name(ee),
						",  ext_swap: ",
						null(ext_swap_) ? "" : string(ext_swap_),
                        ", ccy_swap: ",
						null(ccy_swap_) ? "" : string(ccy_swap_),
						", valid: ",
						null(this.is_valid(ee)) ? "" : string(this.is_valid(ee))
					]));
}
//------------------------------------------------
// __dbg_browse
//------------------------------------------------
void swap_fltflt.__dbg_browse(__dbg_split s)
{
    s.resize(4);

	error_info ee 	= new error_info(true,false);
    s.set_text(0, "name");
    s.set_value(0, this.name(ee));

    s.set_text(1, "ext_swap");
    s.set_value(1, ext_swap_);

    s.set_text(2, "ccy_swap");
    s.set_value(2, ccy_swap_);

	s.set_text(3, "valid");
    s.set_value(3, is_valid(ee));
}

//------------------------------------------------
// copy constructor
//------------------------------------------------
swap_fltflt.swap_fltflt(swap_fltflt c) : swap_gen(c) {}
//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
swap_fltflt.swap_fltflt(__instrument i) option(hidden): swap_gen(i)
{
	//try {
		error_info ee 	= new error_info(true,true);
		if(!this.is_valid(ee)) {
			ext_swap_ = ccy_swap_ = full_swap_ = false;
			return;
		}
		ext_swap_ 		= this.is_ext_swap(ee);
		ccy_swap_ 		= this.is_ccy_swap(ee);
		full_swap_ 		= this.verify_full_swap(true,ee);
		return;									
	//}
	//catch {		
	//	CORE_INT.write_warning_message(err.message());
	//}
}
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string 		swap_fltflt.instr_type_s() 	{ return string(..instr_type.SWAP_FLTFLT);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	swap_fltflt.inst()			{ return this;}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
swap_fltflt swap_fltflt(swap_fltflt b)	{ return new swap_fltflt(b);}
//------------------------------------------------
// clone
//------------------------------------------------
swap_fltflt swap_fltflt.clone() 		{ return new swap_fltflt(this);}

//------------------------------------------------
// create  [PROTECTED]
// create swap_fltflt from internal instrument
//------------------------------------------------
swap_fltflt swap_fltflt.create(	__instrument option(nullable) c,
								out instr_error option(nullable) error,
								error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_fltflt>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.SWAP_FLTFLT, "invalid instrument type",type );//should not happen
	
	return new swap_fltflt(c);
}
/*-----------------------------------------------------------------------
  function: create_swap_fltflt
  ----------------------------------------------------------------------*/

swap_fltflt create_swap_fltflt(	__instrument option(nullable) c,
								out instr_error option(nullable) error,
								error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_swap_fltflt')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_fltflt>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.SWAP_FLTFLT, "invalid instrument type",type );//should not happen
	
	return new swap_fltflt(c);
}
swap_fltflt create_swap_fltflt(	__instrument option(nullable) 		c,
								error_info option(nullable) 		error,
								error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_swap_fltflt_ei')
{
	instr_error ee 	= instr_error();
	swap_fltflt b 	= create_swap_fltflt(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_swap_fltflt");
	return b;
}
/*-----------------------------------------------------------------------
  function: cast instrument to swap swap_fltflt  EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_fltflt swap_fltflt(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Interest Rate Swap/Float vs Float')
option(com_name: 'swap_fltflt_dyncast')
{ 
	try {
		swap_fltflt d = dynamic_cast<swap_fltflt>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a swap_fltflt)","swap_fltflt" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt");
		return null<swap_fltflt>;
	}
}

/*-----------------------------------------------------------------------
  function: create_null_swap_fltflt  (because it was not possble to return null
									from swap_fltflt2s.swap_fltflt())
  ----------------------------------------------------------------------*/

swap_fltflt create_null_swap_fltflt()
{
	return null<swap_fltflt>;
}

/*-----------------------------------------------------------------------
  err_type		EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_fltflt swap_fltflt.err_type(swap_fltflt option(nullable) nul, error_info option(nullable) error)
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,"mwlib(ql) error: inapplicable function call for current instrument type");	
	return null<swap_fltflt>;
}
/*-----------------------------------------------------------------------
  pay_leg1  EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical	 swap_fltflt.pay_leg1(error_info option(nullable) error )
{
	return swap_gen.swap_payleg1(error);
}

/*-----------------------------------------------------------------------
  swap_fltflt: add_quote		EXT SWAP FLTFLT: NOT ok
  ----------------------------------------------------------------------*/
void swap_fltflt.add_quote(	number  quote ) 
{	
	swap_gen.add_quote(quote);
	return ;					
	
}
/*-----------------------------------------------------------------------
  swap_fltflt: add_quote		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fltflt.add_quote(	number  quote,
							..quote_style quote_style) 
{
	error_info ee = new error_info(true,true);
	..quote_style qs = quote_style_e(ee);
	
	if(quote_style == qs)
		this.add_quote(quote);
	else{
		if(quote_style == ..quote_style.SPREAD_BP)
			this.add_quote(quote*10000);//instr quotestyle must be bp
		else if(quote_style == ..quote_style.SPREAD)
			this.add_quote(quote/10000);//instr quotestyle is not bp
		else
			QL_FAIL("invalid quote style",this,true);
	}					
}
/*-----------------------------------------------------------------------
  swap_fltflt: add_funcs
  ----------------------------------------------------------------------*/
void swap_fltflt.add_notional(number notional)						{ swap_gen.swap_add_notional(notional);}//if ccy swap: err
void swap_fltflt.add_notional(number notional1, number notional2)	{ swap_gen.swap_add_notional(notional1, notional2);}
void swap_fltflt.add_fx_mult_leg1(number fx_mult)		{ swap_gen.swap_add_fx_mult_leg1(fx_mult);}
void swap_fltflt.add_fx_mult_leg2(number fx_mult)		{ swap_gen.swap_add_fx_mult_leg2(fx_mult);}
/*-----------------------------------------------------------------------
  add_fx_rate EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fltflt.add_fx_rate(number fx_quote_dec,//must be a quote per unit of base ccy 
							logical pv_in_base_ccy,
							string 	base_ccy,
							string 	price_ccy)
{
	
	swap_gen.swap_add_fx_rate(fx_quote_dec,pv_in_base_ccy,base_ccy,price_ccy);
}

void swap_fltflt.add_disc_func(disc_func disc_func)		{ swap_gen.swap_add_disc_func(disc_func); }
void swap_fltflt.add_disc_func_leg1(disc_func disc_func){ swap_gen.swap_add_disc_func_leg1(disc_func); }//note disc_func for mtm-feature not added here
void swap_fltflt.add_disc_func_leg2(disc_func  disc_func) { swap_gen.swap_add_disc_func_leg2(disc_func); }//note disc_func for mtm-feature not added here
void swap_fltflt.add_surface_leg1(tenor_surface option(nullable) tenor_surface)	{ swap_gen.swap_add_surface_leg1(tenor_surface);}
void swap_fltflt.add_fixing_leg1(	vector(date) fixing_dates,
									vector(number) fixings,
									logical option(nullable) fixing_as_fwd )
{			
	swap_gen.swap_add_fixing_leg1(fixing_dates,fixings,fixing_as_fwd);						
}
void swap_fltflt.add_surface_leg2(tenor_surface option(nullable) tenor_surface)	{ swap_add_surface_leg2(tenor_surface);}
void swap_fltflt.add_fixing_leg2(	vector(date) fixing_dates,
									vector(number) fixings,
									logical option(nullable) fixing_as_fwd )
{			
	swap_gen.swap_add_fixing_leg2(fixing_dates,fixings,fixing_as_fwd);						
}
void swap_fltflt.add_fixing_leg1(	number fixing_proxy,
									logical option(nullable) fixing_as_fwd ) 
{			
	swap_gen.swap_add_fixing_leg1(fixing_proxy, fixing_as_fwd);						
}
void swap_fltflt.add_fixing_leg2(	number fixing_proxy,
									logical option(nullable) fixing_as_fwd ) 
{			
	swap_gen.swap_add_fixing_leg2(fixing_proxy, fixing_as_fwd);						
}

/*void swap_fltflt.add_data(	number 			notional,
							disc_func 		disc_func,
							tenor_surface 	tenor_surface_leg1,	
							vector(date) 	fixing_dates_leg1,
							vector(number) 	fixings_leg1,
							tenor_surface 	tenor_surface_leg2,
							vector(date) 	fixing_dates_leg2,
							vector(number) 	fixings_leg2,
							logical option(nullable) fixing_as_fwd)
{			
	swap_gen.swap_add_fltflt_data(notional,disc_func, tenor_surface_leg1,fixing_dates_leg1,fixings_leg1,
						tenor_surface_leg2,fixing_dates_leg2,fixings_leg2, fixing_as_fwd);						
}*/

/*void swap_fltflt.add_ccy_data(	number 			notional_leg1,
								disc_func 		disc_func_leg1,
								number			fx_mult_leg1,
								tenor_surface 	tenor_surface_leg1,	
								vector(date) 	fixing_dates_leg1,
								vector(number) 	fixings_leg1,
								number 			notional_leg2,
								disc_func 		disc_func_leg2,
								number			fx_mult_leg2,
								tenor_surface 	tenor_surface_leg2,
								vector(date) 	fixing_dates_leg2,
								vector(number) 	fixings_leg2,
								logical option(nullable) fixing_as_fwd )
{			
	swap_gen.swap_add_fltflt_ext_data(	notional_leg1,disc_func_leg1, fx_mult_leg1,tenor_surface_leg1,fixing_dates_leg1,fixings_leg1,
								notional_leg2,disc_func_leg2,fx_mult_leg2,tenor_surface_leg2,fixing_dates_leg2,fixings_leg2, 
								fixing_as_fwd);						
}*/
void swap_fltflt.add_mtm_data(	number 	option(nullable) curr_notional_reset_leg,									
								number 	option(nullable)	fx_spot,  //leg1=price_ccy, leg2=flat=base_ccy
								string 	option(nullable)	fx_base_ccy,
								string 	option(nullable)	fx_price_ccy,
								//date option(nullable) fx_spot_date,
								disc_func	 option(nullable) df_leg1,
								disc_func	 option(nullable) df_leg2)  
{
	number fx_spot_leg1_is_base;
	swap_gen.mtm_helper(fx_spot, fx_base_ccy,fx_price_ccy,fx_spot_leg1_is_base);
	
	i().__swap_add_fltflt_mtm_data(	curr_notional_reset_leg,fx_spot_leg1_is_base,df_leg1,df_leg2);
	return ;						
}

/*-----------------------------------------------------------------------
  swap_add_fltflt_data  
  ----------------------------------------------------------------------*/
void swap_fltflt.add_data( 	number 			notional,
							disc_func 		disc_func,
							tenor_surface 	tenor_surface_leg1,	
							vector(date) 	fixing_dates_leg1,
							vector(number) 	fixings_leg1,
							tenor_surface 	tenor_surface_leg2,
							vector(date) 	fixing_dates_leg2,
							vector(number) 	fixings_leg2,
							logical option(nullable) fixing_as_fwd,
							logical upd_null_crv ,
							logical upd_null_fix )  
{			
	i().__swap_add_fltflt_data(notional,disc_func, tenor_surface_leg1,fixing_dates_leg1,fixings_leg1,
								tenor_surface_leg2,fixing_dates_leg2,fixings_leg2, fixing_as_fwd,upd_null_crv,upd_null_fix);
	return ;						
}

/*-----------------------------------------------------------------------
  swap_add_fltflt_ext_data 
  ----------------------------------------------------------------------*/
void swap_fltflt.add_ccy_data(number 		notional_leg1,
							disc_func 		disc_func_leg1,
							number			fx_mult_leg1,
							tenor_surface 	tenor_surface_leg1,	
							vector(date) 	fixing_dates_leg1,
							vector(number) 	fixings_leg1,
							number 			notional_leg2,
							disc_func 		disc_func_leg2,
							number			fx_mult_leg2,
							tenor_surface 	tenor_surface_leg2,
							vector(date) 	fixing_dates_leg2,
							vector(number) 	fixings_leg2,
							logical option(nullable) fixing_as_fwd,
							logical upd_null_crv ,
							logical upd_null_fix )  
{			
	i().__swap_add_fltflt_ext_data(	notional_leg1,disc_func_leg1, fx_mult_leg1,tenor_surface_leg1,fixing_dates_leg1,fixings_leg1,
									notional_leg2,disc_func_leg2,fx_mult_leg2,tenor_surface_leg2,fixing_dates_leg2,fixings_leg2,
									fixing_as_fwd,upd_null_crv,upd_null_fix);
	return ;						
}
/*-----------------------------------------------------------------------
  set_date 		EXT SWAP: ok
	if trade date is the same --> the settle date will be preserved (if not input)	
  ----------------------------------------------------------------------*/
swap_fltflt swap_fltflt.set_date(	date  				trade_date, 
									date  option(nullable)	settle_date,
									error_info option(nullable) error)
{
	instrument cc;

	if(ext_swap_)
		cc = instrument._set_date(trade_date,settle_date,false,false,error); 
	else
		cc = instrument._set_date(trade_date,settle_date,true,true,error);  //update_trade_date_dep() i dll does not handle mtm --> need to reset mtm

	if(null(cc))
		return null<swap_fltflt>;

	swap_fltflt sw = dynamic_cast<swap_fltflt>(cc);
	sw.reset_mtm();
	return sw;
	
	//return null(cc) ? null<swap_fltflt>: dynamic_cast<swap_fltflt>(cc);
	
}

/*-----------------------------------------------------------------------
  set_date <protected>
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
swap_fltflt swap_fltflt.set_date(	date  				trade_date, 
									date  option(nullable)	settle_date,
									logical 			re_init_static, //true->fail for ext_swap
									logical 			re_init_quote, //true->fail for ext_swap
									error_info option(nullable) error)
{
	instrument cc = instrument._set_date(trade_date,settle_date,re_init_static,re_init_quote,error);
	if(null(cc))
		return null<swap_fltflt>;

	swap_fltflt sw = dynamic_cast<swap_fltflt>(cc);
	sw.reset_mtm();
	return sw;
}

/*-----------------------------------------------------------------------
  set_date <protected/legacy>
	quote is NOT kept even if trade_date is unchanged
  ----------------------------------------------------------------------*/
swap_fltflt swap_fltflt.set_date(	date  				trade_date, 
									logical 			re_init_static, 
									error_info option(nullable) error) 

{
	
	instrument cc;
	if(ext_swap_)
		cc = instrument._set_date(trade_date,null<date>,re_init_static,false,error);
	else
		cc = instrument._set_date(trade_date,null<date>,re_init_static,true,error);
	if(null(cc))
		return null<swap_fltflt>;

	swap_fltflt sw = dynamic_cast<swap_fltflt>(cc);
	sw.reset_mtm();
	return sw;

	
	//instrument cc = instrument._set_date(trade_date,true,error);
	//return null(cc) ? null<swap_fltflt>: dynamic_cast<swap_fltflt>(cc);	
}

/*-----------------------------------------------------------------------
   move_date  <protected/legacy>
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	if trade date is the same --> the settle date will be preserved	
  ----------------------------------------------------------------------*/
swap_fltflt swap_fltflt.move_date(	date  				trade_date, 
									date option(nullable) settle_date,
									error_info option(nullable) error) 
{
	instrument cc = instrument._move_date(trade_date,settle_date,error);
	if(null(cc))
		return null<swap_fltflt>;

	swap_fltflt sw = dynamic_cast<swap_fltflt>(cc);
	sw.reset_mtm();
	return sw;
}

/*-----------------------------------------------------------------------
  set_quote 
  ----------------------------------------------------------------------*/
swap_fltflt swap_fltflt.set_quote(	number 	option(nullable) quote,									
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, false,error);
	return null(cc) ? null<swap_fltflt>: dynamic_cast<swap_fltflt>(cc);
}

/*-----------------------------------------------------------------------
  swap_fltflt: set_quote
  ----------------------------------------------------------------------*/
swap_fltflt swap_fltflt.set_quote(	string 	option(nullable) quote_side,								
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, false,error);
	return null(cc) ? null<swap_fltflt>: dynamic_cast<swap_fltflt>(cc);
}

/*-----------------------------------------------------------------------
  create_tenor_surface_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_fltflt.create_tenor_surface_leg1(disc_func df,fwd_func fwdf)
{
	try{
		error_info ee 			= error_info(true,true);
		..ir_index ir			= this.ir_index_leg1(ee);
		CORE_INT.instr_fail_check(null(ir), "invalid ir_index leg1", this, ee);
		
		//integer tenor_m			= integer(ir.tenor_months());	
		logical allow_extrap 	= false;		
		return tenor_surface(this.trade_date(), df,[fwdf],[ir],allow_extrap);
	}
	catch {
		return null<tenor_surface>;
	}
}
/*-----------------------------------------------------------------------
  create_tenor_surface_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_fltflt.create_tenor_surface_leg1(disc_func df,disc_func fwddf)
{
	try{
		error_info ee 			= error_info(true,true);
		..ir_index ir			= this.ir_index_leg1(ee);
		CORE_INT.instr_fail_check(null(ir), "invalid ir_index leg1", this, ee);
		
		//integer tenor_m			= integer(ir.tenor_months());	
		logical allow_extrap 	= false;		
		return tenor_surface(this.trade_date(), df,[fwddf],[ir],allow_extrap);
	}
	catch {
		return null<tenor_surface>;
	}
}

/*-----------------------------------------------------------------------
  create_tenor_surface_leg2	EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_fltflt.create_tenor_surface_leg2(disc_func df,fwd_func fwdf)
{
	try{
		error_info ee 			= error_info(true,true);
		..ir_index ir			= this.ir_index_leg2(ee);
		CORE_INT.instr_fail_check(null(ir), "invalid ir_index leg2", this, ee);
		
		//integer tenor_m			= integer(ir.tenor_months());	
		logical allow_extrap 	= false;		
		return tenor_surface(this.trade_date(), df,[fwdf],[ir],allow_extrap);
	}
	catch {
		return null<tenor_surface>;
	}
}
/*-----------------------------------------------------------------------
  create_tenor_surface_leg2	EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_fltflt.create_tenor_surface_leg2(disc_func df,disc_func fwddf)
{
	try{
		error_info ee 			= error_info(true,true);
		..ir_index ir			= this.ir_index_leg2(ee);
		CORE_INT.instr_fail_check(null(ir), "invalid ir_index leg2", this, ee);
		
		//integer tenor_m			= integer(ir.tenor_months());	
		logical allow_extrap 	= false;		
		return tenor_surface(this.trade_date(), df,[fwddf],[ir],allow_extrap);
	}
	catch {
		return null<tenor_surface>;
	}
}

/*-----------------------------------------------------------------------
  swap_type
  ----------------------------------------------------------------------*/
instrument_type swap_fltflt.swap_type(error_info option(nullable) error) 
{	
	return swap_gen.swap_type(error);
}

/*-----------------------------------------------------------------------
  set_pay_leg   --> returns an external swap, a db swap cannot be changed in regards to pay vs receive 
  ----------------------------------------------------------------------*/
swap_fltflt swap_fltflt.set_pay_leg(logical pay_leg1,							
									error_info option(nullable) error )
{
	try{

		//swap_gen.reset_mtm();
		
		__instrument  c = i().__swap_set_pay_leg1(pay_leg1 );
		
		instr_error e = new instr_error();
		instrument cc 	= this.create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid swap_fltflt", this, e);
		
		if(!cc.is_valid(error)) 
			return null<swap_fltflt>;	
				
		return dynamic_cast<swap_fltflt>(cc);					
	}	
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.set_pay_leg");
		return null<swap_fltflt>;
	}
}
/*-----------------------------------------------------------------------
  fx_mult	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.fx_mult_factor(	out number fx_mult_flt_leg1, 
							out number fx_mult_flt_leg2, 
							error_info option(nullable) error) 
{	
	swap_gen.fx_mult_factor(fx_mult_flt_leg1, fx_mult_flt_leg2, error ) ;
}


/*-----------------------------------------------------------------------
  is_regular_first	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.is_regular_first(	out logical option(nullable) is_reg_flt_leg1, 
									out logical option(nullable) is_reg_flt_leg2, 
									error_info option(nullable) error) 
{	
	try{
		error_info ee = error_info(true,true);
		vector(ql_float_leg) flt = this.float_legs(false,ee);
		QL_FAIL_COND(v_size(flt) < 2,"invalid swap_fltflt", this, true);
		
		is_reg_flt_leg2 = flt[0].is_reg_first_period();		
		is_reg_flt_leg1 = flt[1].is_reg_first_period();

		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.is_regular_first");		
		is_reg_flt_leg1 = is_reg_flt_leg2 = null<logical >;
		return ;
	}
}

/*-----------------------------------------------------------------------
  is_regular_last	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.is_regular_last(	out logical option(nullable) is_reg_flt_leg1, 
									out logical option(nullable) is_reg_flt_leg2, 
									error_info option(nullable) error) 
{	
	try{
		error_info ee = error_info(true,true);
		vector(ql_float_leg) flt = this.float_legs(false,ee);
		QL_FAIL_COND(v_size(flt) < 2,"invalid swap_fltflt", this, true);
		
		is_reg_flt_leg2 = flt[0].is_reg_last_period();		
		is_reg_flt_leg1 = flt[1].is_reg_last_period();			

		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.is_regular_last");		
		is_reg_flt_leg1 = is_reg_flt_leg2 = null<logical >;
		return ;
	}
}

/*-----------------------------------------------------------------------
  is_mtm_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical  swap_fltflt.is_mtm_leg1(error_info option(nullable) error) 
{	
	return swap_gen.is_mtm_leg1(error);
}
/*-----------------------------------------------------------------------
  is_mtm_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical  swap_fltflt.is_mtm_leg2(error_info option(nullable) error) 
{	
	return swap_gen.is_mtm_leg2(error);
}

/*-----------------------------------------------------------------------
  notional	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.notional(	out number notional_flt_leg1, 
							out number notional_flt_leg2, 
							error_info option(nullable) error) 
{
	swap_gen.notional( notional_flt_leg1,notional_flt_leg2, error ) ;
	return;
}


/*-----------------------------------------------------------------------
  notional	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fltflt.notional(	error_info option(nullable) error ) 
{	
	return swap_gen.nominal(error);
}
/*-----------------------------------------------------------------------
  is_cross_currency
  ----------------------------------------------------------------------*/
logical	 swap_fltflt.is_cross_currency(error_info option(nullable) error )
{
	try{
		QL_FAIL_COND(null(ccy_swap_),"init error");
		return ccy_swap_;	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.is_cross_currency");
		return null<logical>;
	}
}


/*-----------------------------------------------------------------------
  settle_code  EXT SWAP: ok
  ----------------------------------------------------------------------*/
string swap_fltflt.settle_code(error_info option(nullable) error) 
{	
	return swap_gen.settle_code(error);
}


/*-----------------------------------------------------------------------
  start_date	
  ----------------------------------------------------------------------*/
date  swap_fltflt.start_date(error_info option(nullable) error ) 
{
	return instrument.issue_date(error);
}

/*-----------------------------------------------------------------------
  currency	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.currency(	out string curr_flt_leg1, 
							out string curr_flt_leg2, 
							error_info option(nullable) error) 
{
	swap_gen.currency(curr_flt_leg1,  curr_flt_leg2,  error);
	return;
}
/*-----------------------------------------------------------------------
  currency_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
string  swap_fltflt.currency_leg1( error_info option(nullable) error) 
{
	string curr_flt_leg1, curr_flt_leg2;
	currency( curr_flt_leg1, curr_flt_leg2,  error) ;
	return curr_flt_leg1;
}
/*-----------------------------------------------------------------------
  currency_leg2	EXT SWAP: ok
  ----------------------------------------------------------------------*/
string  swap_fltflt.currency_leg2( error_info option(nullable) error) 
{
	string curr_flt_leg1, curr_flt_leg2;
	currency( curr_flt_leg1, curr_flt_leg2,  error) ;
	return curr_flt_leg2;
}

/*-----------------------------------------------------------------------
  avg_method_leg2
  ----------------------------------------------------------------------*/
flt_avg_method  swap_fltflt.avg_method_leg2(error_info option(nullable) error)
{	
	return swap_gen.swap_avg_method_leg2(error) ;
}
/*-----------------------------------------------------------------------
  sprd_comp_method_leg2
  ----------------------------------------------------------------------*/
flt_sprd_comp_method  swap_fltflt.sprd_comp_method_leg2(error_info option(nullable) error)
{	
	return swap_gen.swap_sprd_comp_method_leg2(error) ;
}
/*-----------------------------------------------------------------------
  comp_avg_type_leg2
  ----------------------------------------------------------------------*/
flt_comp_avg_type  swap_fltflt.comp_avg_type_leg2(error_info option(nullable) error)
{	
	return swap_gen.swap_comp_avg_type_leg2(error) ;
}

/*-----------------------------------------------------------------------
  avg_method_leg1
  ----------------------------------------------------------------------*/
flt_avg_method  swap_fltflt.avg_method_leg1(error_info option(nullable) error)
{	
	return swap_gen.swap_avg_method_leg1(error) ;
}
/*-----------------------------------------------------------------------
  sprd_comp_method_leg1
  ----------------------------------------------------------------------*/
flt_sprd_comp_method  swap_fltflt.sprd_comp_method_leg1(error_info option(nullable) error)
{	
	return swap_gen.swap_sprd_comp_method_leg1(error) ;
}
/*-----------------------------------------------------------------------
  comp_avg_type_leg1
  ----------------------------------------------------------------------*/
flt_comp_avg_type  swap_fltflt.comp_avg_type_leg1(error_info option(nullable) error)
{	
	return swap_gen.swap_comp_avg_type_leg1(error) ;
}
/*-----------------------------------------------------------------------
  quote 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.quote(	out number quote_flt_leg1, 
							out number quote_flt_leg2, 
							error_info option(nullable) error) 
{
	swap_gen.quote(quote_flt_leg1,  quote_flt_leg2, error);
}

/*-----------------------------------------------------------------------
  spread_leg1 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fltflt.spread_leg1(error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		number quote_flt_leg1,q;
		i().__swap_def_quote(quote_flt_leg1,q,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltflt.spread_leg1");

		if( e) {
			return null<number> ;
		}
		
		..quote_style qs = i().__swap_quote_style_e_leg1(t,s);
		e = CORE_INT.add_error_info(error,t,s, "swap_fltflt.spread_leg1");
		if(e)
			return null<number>;
		
		switch(qs) {
			case ..quote_style.SPREAD:
				return quote_flt_leg1;
			case ..quote_style.SPREAD_BP:					
			default:
				return quote_flt_leg1/10000;
		}
		
		//return e ? null<number> : quote_flt_leg1/10000;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.spread_leg1");
		return null<number> ;
	}
}
/*-----------------------------------------------------------------------
  spread_leg2 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fltflt.spread_leg2(error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		number q,quote_flt_leg2;
		i().__swap_def_quote(q,quote_flt_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltflt.spread_leg2");

		if( e) {
			return null<number> ;
		}
		else {			
			..quote_style qs = i().__swap_quote_style_e_leg2(t,s);
			e = CORE_INT.add_error_info(error,t,s, "swap_fltflt.spread_leg2");
			if( e) {
				return null<number> ;
			}
			switch(qs) {
				case ..quote_style.SPREAD:
					return quote_flt_leg2;
				case ..quote_style.SPREAD_BP:				
				default:
					return quote_flt_leg2/10000;
			}
		}
		//return e ? null<number> : quote_flt_leg2/10000;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.spread_leg2");
		return null<number> ;
	}
}

/*-----------------------------------------------------------------------
  coupon   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.coupon(	out number cpn_flt_leg1, 
							out number cpn_flt_leg2, 
							error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_coupon(cpn_flt_leg1,cpn_flt_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltflt.coupon");
		if(e)
			cpn_flt_leg1 = cpn_flt_leg2 = null<number>;
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.coupon");		
		cpn_flt_leg1 = cpn_flt_leg2 = null<number>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  dc_method   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.dc_method(	out day_count_method  dc_method_flt_leg1, 
								out day_count_method  dc_method_flt_leg2, 
								error_info option(nullable) error) 
{
	swap_gen.dc_method(dc_method_flt_leg1,dc_method_flt_leg2,error);
	return;
}

/*-----------------------------------------------------------------------
  dc_method_leg1   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
day_count_method swap_fltflt.dc_method_leg1( error_info option(nullable) error) 
{
	day_count_method dc_method_flt_leg1, dc_method_flt_leg2;
	dc_method(dc_method_flt_leg1,dc_method_flt_leg2, error);
	return dc_method_flt_leg1;
}
/*-----------------------------------------------------------------------
  dc_method_leg2   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
day_count_method swap_fltflt.dc_method_leg2( error_info option(nullable) error) 
{
	day_count_method dc_method_flt_leg1, dc_method_flt_leg2;
	dc_method(dc_method_flt_leg1,dc_method_flt_leg2, error);
	return dc_method_flt_leg2;
}

/*-----------------------------------------------------------------------
  ir_rule_leg1
  ----------------------------------------------------------------------*/
interest_rule  swap_fltflt.ir_rule_leg1(error_info option(nullable) error)
	{	
	interest_rule if1, if2;
	swap_gen.ir_rule(if1, if2,  error ) ;
	return if1;
}
/*-----------------------------------------------------------------------
  ir_rule_leg2
  ----------------------------------------------------------------------*/
interest_rule  swap_fltflt.ir_rule_leg2(error_info option(nullable) error)
	{	
	interest_rule if1, if2;
	swap_gen.ir_rule(if1, if2,  error ) ;
	return if2;
}

/*-----------------------------------------------------------------------
  effective_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.effective_date(	out date  effective_date_flt_leg1, 
									out date  effective_date_flt_leg2, 
									error_info option(nullable) error) 
{
	try{
		error_info ee = error_info(true,true);
		vector(ql_swap_leg) flt = this.legs(false,ee);
		
		QL_FAIL_COND(v_size(flt) < 2,"invalid swap_fltflt", this, true);				
		effective_date_flt_leg1 = flt[0].effective_date();
		effective_date_flt_leg2 = flt[1].effective_date();
				
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.effective_date");		
		effective_date_flt_leg1 = effective_date_flt_leg2 = null<date>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  first_cpn_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.first_cpn_date(	out date  first_cpn_date_flt_leg1, 
									out date  first_cpn_date_flt_leg2, 
									error_info option(nullable) error) 
{
	try{
		error_info ee = error_info(true,true);
		vector(ql_swap_leg) flt = this.legs(false,ee);
		
		QL_FAIL_COND(v_size(flt) < 2,"invalid swap_fltflt", this, true);				
		first_cpn_date_flt_leg1 = flt[0].first_cpn_date();
		first_cpn_date_flt_leg2 = flt[1].first_cpn_date();
				
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.first_cpn_date");		
		first_cpn_date_flt_leg1 = first_cpn_date_flt_leg2 = null<date>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  last_reg_cpn_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.last_reg_cpn_date(out date  last_reg_cpn_date_flt_leg1, 
									out date  last_reg_cpn_date_flt_leg2, 
									error_info option(nullable) error) 
{
	try{
		error_info ee = error_info(true,true);
		vector(ql_swap_leg) flt = this.legs(false,ee);
		
		QL_FAIL_COND(v_size(flt) < 2,"invalid swap_fltflt", this, true);				
		last_reg_cpn_date_flt_leg1 = flt[0].last_reg_cpn_date();
		last_reg_cpn_date_flt_leg2 = flt[1].last_reg_cpn_date();
				
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.last_reg_cpn_date");		
		last_reg_cpn_date_flt_leg1 = last_reg_cpn_date_flt_leg2 = null<date>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  pmt_lag   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.pmt_lag(	out	integer 	pmt_lag_leg1,
							out	integer 	mat_pmt_lag_leg1,
							out	integer 	pmt_lag_prin_leg1,
							out	integer 	mat_pmt_lag_prin_leg1,
							out	integer 	pmt_lag_leg2,
							out	integer 	mat_pmt_lag_leg2,
							out	integer 	pmt_lag_prin_leg2,
							out	integer 	mat_pmt_lag_prin_leg2,	
							error_info option(nullable) error) 
{
	swap_gen.swap_pmt_lag(	pmt_lag_leg1, mat_pmt_lag_leg1, pmt_lag_prin_leg1, mat_pmt_lag_prin_leg1,
								pmt_lag_leg2, mat_pmt_lag_leg2, pmt_lag_prin_leg2, mat_pmt_lag_prin_leg2,error);
	return;
}

/*-----------------------------------------------------------------------
  coupon_freq   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.coupon_freq(	out integer  cpn_freq_flt_leg1, 
								out integer  cpn_freq_flt_leg2, 
								error_info option(nullable) error) 
{
	swap_gen.coupon_freq(cpn_freq_flt_leg1,cpn_freq_flt_leg2,error);
	return;
}

/*-----------------------------------------------------------------------
  reset_freq   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.reset_freq(	out integer  reset_freq_flt_leg1, 
								out integer  reset_freq_flt_leg2, 
								error_info option(nullable) error) 
{	
	try{	
		error_info ee = error_info(true,true);
		vector(ql_float_leg) flt = this.float_legs(false,ee);
		QL_FAIL_COND(v_size(flt) < 2,"invalid swap_fltflt", this, true);
				
		reset_freq_flt_leg1 = reset_freq_to_int(flt[0].float_def().reset_freq());
		reset_freq_flt_leg2 = reset_freq_to_int(flt[1].float_def().reset_freq());
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.reset_freq");		
		reset_freq_flt_leg1 = reset_freq_flt_leg2 = err_freq();
		return ;
	}
}

/*-----------------------------------------------------------------------
  reset_freq_leg1   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
integer  swap_fltflt.reset_freq_leg1 (error_info option(nullable) error) 
{
	integer  reset_freq_flt_leg1, reset_freq_flt_leg2;
	reset_freq(reset_freq_flt_leg1, reset_freq_flt_leg2,  error) ;
	return reset_freq_flt_leg1;
}
/*-----------------------------------------------------------------------
  reset_freq_leg2   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
integer  swap_fltflt.reset_freq_leg2 (error_info option(nullable) error) 
{
	integer  reset_freq_flt_leg1, reset_freq_flt_leg2;
	reset_freq(reset_freq_flt_leg1, reset_freq_flt_leg2,  error) ;
	return reset_freq_flt_leg2;
}
/*-----------------------------------------------------------------------
  coupon_freq_leg1   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
integer  swap_fltflt.coupon_freq_leg1 (error_info option(nullable) error) 
{
	integer  coupon_freq_flt_leg1, coupon_freq_flt_leg2;
	coupon_freq(coupon_freq_flt_leg1, coupon_freq_flt_leg2,  error) ;
	return coupon_freq_flt_leg1;
}
/*-----------------------------------------------------------------------
  coupon_freq_leg2   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
integer  swap_fltflt.coupon_freq_leg2 (error_info option(nullable) error) 
{
	integer  coupon_freq_flt_leg1, coupon_freq_flt_leg2;
	coupon_freq(coupon_freq_flt_leg1, coupon_freq_flt_leg2,  error) ;
	return coupon_freq_flt_leg2;
}
/*-----------------------------------------------------------------------
  roll_day   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.roll_day(	out integer  roll_day_flt_leg1, 
								out integer  roll_day_flt_leg2, 
								error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_roll_day(roll_day_flt_leg1,roll_day_flt_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltflt.roll_day");
		if(e)
			roll_day_flt_leg1 = roll_day_flt_leg2 = err_int();
		return ;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.roll_day");		
		roll_day_flt_leg1 = roll_day_flt_leg2 = err_int();
		return ;
	}
}

/*-----------------------------------------------------------------------
  eom   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.eom(	out logical option(nullable)  eom_flt_leg1, 
						out logical option(nullable) eom_flt_leg2, 
						error_info option(nullable) error) 
{
	swap_gen.eom(eom_flt_leg1, eom_flt_leg2,  error ) ;
	return;
}


/*-----------------------------------------------------------------------
  cal   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.calendar(	out ..calendar option(nullable)  cal_flt_leg1, 
							out ..calendar option(nullable) cal_flt_leg2, 
							error_info option(nullable) error) 
{	
	swap_gen.calendar(cal_flt_leg1, cal_flt_leg2,  error ) ;
	return;
}

/*-----------------------------------------------------------------------
  calendar_name   	
  ----------------------------------------------------------------------*/
void  swap_fltflt.calendar_name(out string  cal_name_leg1, 
								out string  cal_name_leg2, 
								error_info option(nullable) error ) 
{	
	try{
		QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);
		
		
		cal_name_leg1 = this.instr_def(error).swap_calendar_name_leg1(error);
		cal_name_leg2 = this.instr_def(error).swap_calendar_name_leg2(error);
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.calendar_name");
		cal_name_leg1 = cal_name_leg2 = null<string>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  calendar_name  	
  ----------------------------------------------------------------------*/
/*string swap_fltflt.calendar_name(error_info option(nullable) error )  option(hidden)
{	
	try{
		QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);
		QL_FAIL_COND(ccy_swap_,"inapplicable function call for currency swaps (use 2-leg version)", this,true);

		return this.instr_def(error).swap_calendar_name_leg1(error);
								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.calendar_name");
		return null<string>;
	}
}*/
/*-----------------------------------------------------------------------
  calendar_name  	
  ----------------------------------------------------------------------*/
/*string swap_fltflt.calendar_name(integer index, error_info option(nullable) error )  option(hidden)
{	
	try{
		QL_FAIL_COND(index != 0,"function call not applicable swaps (only index = 0 is supported)", this,true);		
		return this.calendar_name(error);
								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.calendar_name");
		return null<string>;
	}
}*/
/*-----------------------------------------------------------------------
  pmt_bus_day 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.pmt_bus_day(	out bd_convention option(nullable) pmt_bus_day_flt_leg1, 
								out bd_convention option(nullable) pmt_bus_day_flt_leg2, 
								error_info option(nullable) error) 
{	
	swap_gen.pmt_bus_day(pmt_bus_day_flt_leg1, pmt_bus_day_flt_leg2,  error ) ;
	return;
}

/*-----------------------------------------------------------------------
  pmt_bus_day   (fix leg- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*bd_convention swap_fltflt.pmt_bus_day(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		bd_convention c1,c2;
		i().__swap_bd(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltflt.pmt_bus_day");	
		return e ? null<bd_convention>: c1;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.pmt_bus_day");		
		return null<bd_convention>;
	}
}
*/

/*-----------------------------------------------------------------------
  index_dates_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.index_dates_leg1(	logical 							post_settle, 
									out vector(date)  	index_start_dates,									
									out vector(date)  	index_end_dates,
									out vector(logical) option(nullable) index_regular,
									error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		logical leg1 = true;
		i().__swap_index_dates(post_settle,index_start_dates,index_end_dates,index_regular, leg1,false,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltflt.index_dates_leg1");
		if(e) {
			index_start_dates = index_end_dates = null<vector(date)>; 
			index_regular = null<vector(logical)>; 
		}			
		return ;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.index_dates_leg1");		
		index_start_dates = index_end_dates = null<vector(date)>; 
		index_regular = null<vector(logical)>; 
		return ;
	}
}

/*-----------------------------------------------------------------------
  index_dates_leg2	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.index_dates_leg2(	logical 			post_settle, 
									out vector(date)  	index_start_dates,									
									out vector(date)  	index_end_dates,
									out vector(logical) option(nullable) index_regular,
									error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		logical leg1 = false;
		i().__swap_index_dates(post_settle,index_start_dates,index_end_dates,index_regular, leg1,false,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltflt.index_dates_leg2");
		if(e) {
			index_start_dates = index_end_dates = null<vector(date)>; 
			index_regular = null<vector(logical)>; 
		}			
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.index_dates_leg2");		
		index_start_dates = index_end_dates = null<vector(date)>; 
		index_regular = null<vector(logical)>; 
		return ;
	}
}


/*-----------------------------------------------------------------------
  fixing_data_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.fixing_data_leg1(	logical 							post_trade_date,
									logical option(nullable)			only_fixed, 
									out vector(date)   	reset_date,									
									out vector(number)   rate,
									out vector(logical) option(nullable)is_fixed,
									error_info option(nullable) 	error) 
{	
	try{
		error_info ee = error_info(true,true);
		vector(ql_float_leg) flt = this.float_legs(false,ee);
		QL_FAIL_COND(v_size(flt) < 2,"invalid swap_fltflt", this, true);
		
		date cut_off = post_trade_date ? this.trade_date(): null<date>;
		flt[0].fixing_data(only_fixed,reset_date,rate,is_fixed,cut_off);

		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.fixing_data_leg1");		
		reset_date = null<vector(date)>; 
		rate = null<vector(number)>; 
		is_fixed = null<vector(logical)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  fixing_data_leg2	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.fixing_data_leg2(	logical 							post_trade_date,
									logical option(nullable)			only_fixed, 
									out vector(date)   	reset_date,									
									out vector(number)   rate,
									out vector(logical) option(nullable)is_fixed,
									error_info option(nullable) 	error) 
{	
	try{	
		error_info ee = error_info(true,true);
		vector(ql_float_leg) flt = this.float_legs(false,ee);
		QL_FAIL_COND(v_size(flt) < 2,"invalid swap_fltflt", this, true);
		
		date cut_off = post_trade_date ? this.trade_date(): null<date>;
		flt[1].fixing_data(only_fixed,reset_date,rate,is_fixed,cut_off);

		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.fixing_data_leg2");		
		reset_date = null<vector(date)>; 
		rate = null<vector(number)>; 
		is_fixed = null<vector(logical)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  cash_flow_dates	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.cash_flow_dates(	logical 			post_settle, 
									out vector(date) 	pmt_dates_leg1,									
									out vector(date) 	pmt_dates_leg2,
									error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_ir_pmt_dates(post_settle,pmt_dates_leg1,pmt_dates_leg2, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltflt.cash_flow_dates");
		if(e) {
			pmt_dates_leg1 = pmt_dates_leg2 = null<vector(date)>;  
		}
		return;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.cash_flow_dates");		
		pmt_dates_leg1 = pmt_dates_leg2 = null<vector(date)>; 
		return ;
	}
}
/*-----------------------------------------------------------------------
  cash_flow_dates override (fix leg- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*vector(date) swap_fltflt.cash_flow_dates(	logical post_settle, 
											logical adj_dates,   
											logical keep_size,  
											error_info option(nullable) error)
{	
	try{
		QL_FAIL_COND(keep_size == true,"keep size = true not applicable for swaps", this, true);

		vector(date) pmt_dates_leg1,pmt_dates_leg2;
		this.cash_flow_dates(post_settle,pmt_dates_leg1,pmt_dates_leg2,error);
		return pmt_dates_leg1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.cash_flow_dates");		
		return null<vector(date)>;
	}
}*/

/*-----------------------------------------------------------------------
  cash_flows_cpn	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.cash_flows_cpn(	logical 			post_settle, 
									out vector(number) 	cpn_cf_leg1,									
									out vector(number) 	cpn_cf_leg2,
									error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_cashflows_cpn(post_settle,cpn_cf_leg1,cpn_cf_leg2, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltflt.cash_flows_cpn");
		if(e) {
			cpn_cf_leg1 = cpn_cf_leg2 = null<vector(number)>;
		}
		return;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.cash_flows_cpn");		
		cpn_cf_leg1 = cpn_cf_leg2 = null<vector(number)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  cash_flows_cpn override-protected  (fix leg- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*vector(number) swap_fltflt.cash_flows_cpn(	number option(nullable) notional, 
											logical post_settle, 
											logical keep_size,  
											error_info option(nullable) error)
{	
	try{
		QL_FAIL_COND(keep_size == true,"keep size = true not applicable for swaps", this, true);
		QL_FAIL_COND(!null(notional) && notional != this.nominal(),"input of notional not applicable for swaps", this, true);

		error_info ee = new error_info(true,true);
		vector(number) cf_leg1,cf_leg2;
		this.cash_flows_cpn(post_settle,cf_leg1,cf_leg2, ee);
		
		for(integer i=0;i<v_size(cf_leg1);i++)
			cf_leg1[i] = abs(cf_leg1[i]);
		return cf_leg1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.cash_flows_cpn");		
		return null<vector(number)>;
	}

}*/
/*-----------------------------------------------------------------------
  cash_flows	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.cash_flows(	logical 			post_settle, 
								out vector(number) 	cf_leg1,									
								out vector(number) 	cf_leg2,
								error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical or=true;
		i().__swap_cashflows(post_settle,or,cf_leg1,cf_leg2, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltflt.cash_flows");
		if(e) {
			cf_leg1 = cf_leg2 = null<vector(number)>;
		}
		return;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.cash_flows");		
		cf_leg1 = cf_leg2 = null<vector(number)>;
		return ;
	}
}


/*-----------------------------------------------------------------------
  cash_flows  override, protected	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*vector(number) swap_fltflt.cash_flows(number option(nullable) notional, 
									logical post_settle, 
									logical keep_size,  
									error_info option(nullable) error)
{	
	try{
		QL_FAIL_COND(keep_size == true,"keep size = true not applicable for swaps", this, true);
		QL_FAIL_COND(!null(notional) && notional != this.nominal(),"input of notional not applicable for swaps", this, true);

		error_info ee = new error_info(true,true);
		vector(number) cf_leg1,cf_leg2;
		this.cash_flows(post_settle,cf_leg1,cf_leg2, ee);
	
		for(integer i=0;i<v_size(cf_leg1);i++)
			cf_leg1[i] = abs(cf_leg1[i]);
		return cf_leg1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.cash_flows");		
		return null<vector(number)>;
	}
}*/
/*-----------------------------------------------------------------------
  cash_flows  LEGACY, prot
  ----------------------------------------------------------------------*/
/*void swap_fltflt.cash_flows(out vector(date)   dates,
    						out vector(number)   amounts,
							number option(nullable) notional ,
							logical post_settle,							
							error_info option(nullable) error)  
{
	QL_FAIL_COND(!null(notional) && notional != this.nominal(),"input of notional not applicable for swaps", this, true);
	vector(date) pmt_dates_flt_leg;									
	vector(number) cf_flt_leg;

	this.cash_flow_data(	post_settle, ir_cf_code.COUPON, dates,amounts,
							pmt_dates_flt_leg,	cf_flt_leg,error );

	number notional_fix_leg,  notional_flt_leg;
	this.notional(notional_fix_leg, notional_flt_leg, error ) ;
	integer s = v_size(amounts);
	for(integer i=0; i<s;i++){
		amounts[i] = abs(amounts[i]);
	}
	amounts[s-1] += abs(notional_fix_leg);
	
}*/
/*-----------------------------------------------------------------------
  cash_flow_dates_noadj  LEGACY, prot
  ----------------------------------------------------------------------*/
/*vector(date) swap_fltflt.cash_flow_dates_noadj(	logical 	post_settle,
												error_info option(nullable) error) 
												
{
	vector(date)  dates;
	vector(number)  amounts;
	this.cash_flow_data(null<number>, post_settle, ir_cf_code.TOTAL,false,false,  
						dates,  amounts, error );
	return dates;
}*/

/*-----------------------------------------------------------------------
  cash_flow_amounts  LEGACY, prot
  ----------------------------------------------------------------------*/
/*vector(number) swap_fltflt.cash_flow_amounts(number option(nullable) notional,
											logical post_settle,
											logical keep_size,											
											error_info option(nullable) error) 

{	
	vector(date)  dates;
	vector(number)  amounts;
	this.cash_flow_data(notional, post_settle, ir_cf_code.COUPON,false,keep_size,  
						dates,  amounts, error );

	number notional_fix_leg,  notional_flt_leg;
	this.notional(notional_fix_leg, notional_flt_leg, error ) ;
	integer s = v_size(amounts);
	for(integer i=0; i<s;i++){
		amounts[i] = abs(amounts[i]);
	}
	amounts[s-1] += abs(notional_fix_leg);
	
	return amounts;
}*/
/*-----------------------------------------------------------------------
  cash_flow_nom_amounts  LEGACY, prot
  ----------------------------------------------------------------------*/
/*vector(number) swap_fltflt.cash_flow_nom_amounts(number option(nullable) notional,
												logical post_settle,
												logical keep_size,
												error_info option(nullable) error) option(hidden)
{	
	return cash_flow_amounts(notional,post_settle, keep_size,error) ;
}*/
/*-----------------------------------------------------------------------
  cash_flow_data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.cash_flow_data(logical 			post_settle,
								ir_cf_code 			cf_code, 
								out vector(date)  	pmt_dates_leg1,									
								out vector(number)   cf_leg1,
								out vector(date)  	pmt_dates_leg2,									
								out vector(number)  	cf_leg2,
								error_info option(nullable) error) 
{	
	try{
		error_info ee = new error_info(true,true);
		this.cash_flow_dates(post_settle, pmt_dates_leg1,pmt_dates_leg2,ee) ;
		
		if(cf_code == ir_cf_code.COUPON) {
			this.cash_flows_cpn(post_settle, cf_leg1,cf_leg2,ee) ;
		}
		else if	(cf_code == ir_cf_code.PRINCIPAL) {
			this.cash_flows(post_settle,cf_leg1,cf_leg2,ee) ;
	
			vector(number) cpn1,cpn2;
			this.cash_flows_cpn(post_settle,cpn1,cpn2,ee) ;

			cf_leg1 -= cpn1;
			cf_leg2 -= cpn2;
		}
		else {
			this.cash_flows(post_settle,cf_leg1,cf_leg2,ee) ;
		}
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.cash_flow_data");		
		cf_leg1 = cf_leg2 = null<vector(number)>;
		pmt_dates_leg1 = pmt_dates_leg2 = null<vector(date)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  cash_flow_data protected, override	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*void swap_fltflt.cash_flow_data(number option(nullable) notional, 
								logical post_settle, 
								ir_cf_code cf_code,
								logical adj_dates, 
								logical keep_size,  
								out vector(date)   dates,  
								out vector(number)   amounts,								
								error_info option(nullable) error) 
{	
	try{
		QL_FAIL_COND(keep_size == true,"keep size = true not applicable for swaps", this, true);
		QL_FAIL_COND(!null(notional) && notional != this.nominal(),"input of notional not applicable for swaps", this, true);

		error_info ee = new error_info(true,true);
		vector(number) cf_leg2;
		vector(date) dates_leg2;
		this.cash_flow_data(post_settle,cf_code, dates,amounts,  dates_leg2, cf_leg2, ee);

		for(integer i=0;i<v_size(amounts);i++)
			amounts[i] = abs(amounts[i]);
		return ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.cash_flow_data");
		
		return ;
	}

}*/
/*-----------------------------------------------------------------------
  cash_flow_data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.cash_flow_data(logical 							post_settle,
								logical option(nullable) 			trade_date_pv,
								out vector(date)   	pmt_date_leg1,
								out vector(number)   cpn_rate_leg1,
								out vector(number)   cpn_cashflow_leg1,
								out vector(number)   pv_cpn_cashflow_leg1,
								out vector(number)   fee_leg1,
								out vector(number)   pv_fee_leg1,
								out vector(number)   notional_leg1,
								out vector(date)   	pmt_date_leg2,
								out vector(number)   cpn_rate_leg2,
								out vector(number)   cpn_cashflow_leg2,
								out vector(number)   pv_cpn_cashflow_leg2,
								out vector(number)   fee_leg2,
								out vector(number)   pv_fee_leg2,
								out vector(number)   notional_leg2,
								error_info option(nullable) 	error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_payment_data(trade_date_pv,post_settle, 
								pmt_date_leg1,
								cpn_rate_leg1,
								cpn_cashflow_leg1,
								pv_cpn_cashflow_leg1,
								fee_leg1,
								pv_fee_leg1,
								notional_leg1,
								pmt_date_leg2,
								cpn_rate_leg2,
								cpn_cashflow_leg2,
								pv_cpn_cashflow_leg2,
								fee_leg2,
								pv_fee_leg2,
								notional_leg2, t,s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltflt.cash_flow_data");
		if(e) {
			cpn_rate_leg1 = cpn_cashflow_leg1 = pv_cpn_cashflow_leg1 = fee_leg1 = null<vector(number)>;
			pv_fee_leg1 = notional_leg1 = null<vector(number)>;
			cpn_rate_leg2 = cpn_cashflow_leg2 = pv_cpn_cashflow_leg2 = fee_leg2 = null<vector(number)>;
			pv_fee_leg2 = notional_leg2 = null<vector(number)>;
			pmt_date_leg1= pmt_date_leg2 = null<vector(date)>; 
		}			
		return ;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.cash_flow_data");		
		cpn_rate_leg1 = cpn_cashflow_leg1 = pv_cpn_cashflow_leg1 = fee_leg1 = null<vector(number)>;
		pv_fee_leg1 = notional_leg1 = null<vector(number)>;
		cpn_rate_leg2 = cpn_cashflow_leg2 = pv_cpn_cashflow_leg2 = fee_leg2 = null<vector(number)>;
		pv_fee_leg2 = notional_leg2 = null<vector(number)>;
		pmt_date_leg1= pmt_date_leg2 = null<vector(date)>; 
		return ;
	}
}

/*-----------------------------------------------------------------------
  accrued
  ----------------------------------------------------------------------*/
number  swap_fltflt.accrued(logical 	in_pcnt,
							out number accr_leg1,									
							out number accr_leg2,
							error_info option(nullable) error) 
{	
	return swap_gen.accrued(in_pcnt, accr_leg1, accr_leg2, error ) ;
}

/*-----------------------------------------------------------------------
  accrued_period	backward compat, returns leg1 data  EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*number  swap_fltflt.accrued_period(	out integer n_days_leg1,
									error_info option(nullable) error) 
{
	try {
		error_info ee = new error_info(true,true);
		number period_leg1,period_leg2;
		integer n_days_leg2;
		this.accrued_period(period_leg1,period_leg2,n_days_leg1,n_days_leg2,ee);
		return period_leg1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.accrued_period");
		n_days_leg1 = err_int();
		return null<number>;
	}
}*/
/*-----------------------------------------------------------------------
  accrued_period  EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fltflt.accrued_period(	out number period_leg1,
									out number period_leg2,
									out integer n_days_leg1,
									out integer n_days_leg2,
									error_info option(nullable) error) 
{	
	swap_gen.accrued_period(period_leg1,period_leg2,n_days_leg1,n_days_leg2, error ) ;
	return;
}

/*-----------------------------------------------------------------------
  accrued_chg  protected
  ----------------------------------------------------------------------*/
/*number  swap_fltflt.accrued_chg(integer 					bus_days,
								out	number option(nullable)	cpn_cashflow,
								out date settle,
								out date settle_next,	
								logical 	in_pcnt,								
								error_info option(nullable) error) 
{	
	try {
		QL_FAIL_COND(in_pcnt,"in_pcnt = true not applicable", this, true);
		
		error_info ee = new error_info(true,true);
		number cpn_cashflow_leg2,ai_chg_leg1,ai_chg_leg2;
		number c = this.accrued_chg(	bus_days,ai_chg_leg1,ai_chg_leg2,
									cpn_cashflow,cpn_cashflow_leg2,
									settle,settle_next,ee);		
		return c;		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.accrued_chg");		
		cpn_cashflow = null<number>;
		settle = settle_next = null<date>;
		return null<number>;
	}
}*/

/*-----------------------------------------------------------------------
  accrued_chg  EXT SWAP: ok
  ----------------------------------------------------------------------*/
number swap_fltflt.accrued_chg  (	integer bus_days,
									out	number option(nullable)	ai_chg_leg1,
									out	number option(nullable)	ai_chg_leg2,
									out	number option(nullable)	cpn_cashflow_leg1,
									out	number option(nullable)	cpn_cashflow_leg2,
									out date settle,
									out date settle_next,	
									error_info option(nullable) error) 
{	
	return swap_gen.accrued_chg(bus_days,ai_chg_leg1,ai_chg_leg2,cpn_cashflow_leg1,cpn_cashflow_leg2,
								settle,settle_next,	error);
}


/*-----------------------------------------------------------------------
  pvbp	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fltflt.pvbp(	number option(nullable) notional,
							number option(nullable) delta,
							logical option(nullable) centered,
							logical option(nullable) disable_rounding,	
							error_info option(nullable) error) 
{	
	return null<number>;//this.pvbp_fix_leg(notional,delta,false,error) ;
}


/*-----------------------------------------------------------------------
  pvbp	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fltflt.pvbp(	number 	option(nullable) notional,
							number  option(nullable) delta,																																		
							error_info option(nullable) error) 
{	
	try{	
		return this.pvbp(notional,delta, false,false,error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.pvbp");		
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  df_pvbp_leg_delta  
  ----------------------------------------------------------------------*/
disc_func swap_fltflt.df_shifted(	number 		delta_disc,
									disc_func 	df,							
									logical 	leg1)
{
	return swap_gen.df_shifted_disc_rates_flt_leg(leg1, delta_disc, df);
}

/*-----------------------------------------------------------------------
  fwd_shifted
  ----------------------------------------------------------------------*/
tenor_surface swap_fltflt.fwd_shifted(	number 			delta_fwd,
										disc_func 		df,							
										tenor_surface 	ts,
										logical 		leg1)
{
	return swap_gen.fwd_shifted_flt_leg(leg1, delta_fwd, df, ts);//fwd rates shift = delta
}

/*-----------------------------------------------------------------------
  pvdiff
  ----------------------------------------------------------------------*/
number  swap_fltflt.pvdiff_curve_shift(	number option(nullable) delta_disc_leg1,
										number option(nullable) delta_disc_leg2,	//not used for single ccy swaps							
										number option(nullable) delta_fwd_leg1,
										number option(nullable) delta_fwd_leg2,
										logical option(nullable) trade_date_pv,
										logical option(nullable) leg_indep_shift,//not used yet
										out number pv,
										out number pvdiff_leg1,
										out number pvdiff_leg2,
										error_info option(nullable) error) 
{	
	try{	

		SWAP_ENTRY_FUNC();
			
		if(null(trade_date_pv))
			trade_date_pv = false;
		
		if(null(leg_indep_shift))
			leg_indep_shift = false;
		
				
		if(null(delta_disc_leg1))
			delta_disc_leg1 = 0.0001;
		
		if(!ccy_swap_) {
			delta_disc_leg2 = delta_disc_leg1;	
		}
		else
			if(null(delta_disc_leg2))
				delta_disc_leg2 = 0.0001;

		if(null(delta_fwd_leg1))
			delta_fwd_leg1 = 0.0001;
		
		if(null(delta_fwd_leg2))
			delta_fwd_leg2 = 0.0001;

		if(delta_disc_leg1>0 &&  delta_fwd_leg1 > 0)
			QL_REQUIRE(CORE_INT.is_equal(delta_disc_leg1, delta_fwd_leg1),"the float leg 1 disc and fwd deltas must be equal when different from zero");
		if(delta_disc_leg2>0 &&  delta_fwd_leg2 > 0)
			QL_REQUIRE(CORE_INT.is_equal(delta_disc_leg2, delta_fwd_leg2),"the float leg 2 disc and fwd deltas must be equal when different from zero");
		
		if(CORE_INT.is_equal_zero(delta_disc_leg1 ) && CORE_INT.is_equal_zero(delta_disc_leg2 )
		   && CORE_INT.is_equal_zero(delta_fwd_leg1 ) && CORE_INT.is_equal_zero(delta_fwd_leg2 )) {
			pvdiff_leg1 = 0;
			pvdiff_leg2 = 0;
			return 0;
		}

		error_info ee = new error_info(true,true);
		disc_func df_orig1 		= this.disc_func_leg1(ee);
		disc_func df_orig2 		= this.disc_func_leg2(ee);
		tenor_surface ts_orig1 	= this.tenor_surface_leg1(ee);
		tenor_surface ts_orig2 	= this.tenor_surface_leg2(ee);

		QL_FAIL_COND(null(df_orig1), "discount function for float leg 1 not set", this, true);
		disc_func df1 = df_orig1;
		QL_FAIL_COND(null(df_orig2), "discount function for float leg 2 not set", this, true);
		disc_func df2 = df_orig2;
		QL_FAIL_COND(null(ts_orig1), "tenor surface for float leg 1 not set", this, true);
		tenor_surface ts1 = ts_orig1;	
		QL_FAIL_COND(null(ts_orig2), "tenor surface for float leg 2 not set", this, true);
		tenor_surface ts2 = ts_orig2;										

		number pv_1,pv_2;
		pv = present_value(pv_1,pv_2,trade_date_pv,ee);
		
		/* create new df's and ts's */
		//float leg 1		
		disc_func df_delta1 = this.df_shifted(delta_disc_leg1,df1, true);	
		QL_FAIL_COND(null(df_delta1), "error creating disc_func for leg 1", this, true);

		tenor_surface ts_delta1 = this.fwd_shifted(delta_fwd_leg1,df_delta1,ts1,true);
		QL_FAIL_COND(null(ts_delta1), "error creating tenor surface for float leg 1", this, true);

		//float leg 2
		disc_func df_delta2;
		tenor_surface ts_delta2;
		if(ccy_swap_) {
			df_delta2 = this.df_shifted(delta_disc_leg2,df2, false);
			QL_FAIL_COND(null(df_delta2), "error creating disc_func for float leg 2", this, true);

			ts_delta2 = this.fwd_shifted(delta_fwd_leg2,df_delta2,ts2,false);
			QL_FAIL_COND(null(ts_delta2), "error creating tenor surface for float leg 2", this, true);
		}
		else {		
			
			if(leg_indep_shift) {
				df_delta2 = this.df_shifted(delta_disc_leg2,df2,false) ;							
				QL_FAIL_COND(null(df_delta2), "error creating disc_func for float leg 2", this, true);
				
				ts_delta2 = this.fwd_shifted(delta_fwd_leg2,df_delta2,ts2,false);
				QL_FAIL_COND(null(ts_delta2), "error creating tenor surface for float leg 2", this, true);
			}
			else {
				df_delta2 = df_delta1;					
				QL_FAIL_COND(null(df_delta2), "error creating disc_func for leg 2", this, true);

				//FIX_ME:  fwd_shifted must change here since we are shifting the fwd rates with 1bp using the shifted discfunc of a different freq
				ts_delta2 = this.fwd_shifted(delta_fwd_leg2,df_delta2,ts2,false);
				QL_FAIL_COND(null(ts_delta2), "error creating tenor surface for float leg 2", this, true);
			}
		}
		

		//add
		if(!CORE_INT.is_equal_zero(delta_disc_leg1 )) 
			this.add_disc_func_leg1(df_delta1);

		if(!CORE_INT.is_equal_zero(delta_disc_leg2 )) 
			this.add_disc_func_leg2(df_delta2);		

		if(!CORE_INT.is_equal_zero(delta_fwd_leg1 ))  
			this.add_surface_leg1(ts_delta1);
		
		if(!CORE_INT.is_equal_zero(delta_fwd_leg2 )) 
			this.add_surface_leg1(ts_delta2);		

		//calc new pv
		number pv_1_delta,pv_2_delta;
		number pv_delta = present_value(pv_1_delta,pv_2_delta,trade_date_pv,ee);		
		pvdiff_leg1 	= pv_1_delta - pv_1;
		pvdiff_leg2 	= pv_2_delta - pv_2;
		number pvdiff = pv_delta-pv;

		//clean up
		if(!CORE_INT.is_equal_zero(delta_disc_leg1 )) 
			this.add_disc_func_leg1(df_orig1);

		if(!CORE_INT.is_equal_zero(delta_disc_leg2 )) 
			this.add_disc_func_leg2(df_orig2);
		
		if(!CORE_INT.is_equal_zero(delta_fwd_leg1 )) 
			this.add_surface_leg1(ts_orig1);
		
		if(!CORE_INT.is_equal_zero(delta_fwd_leg2 )) 
			this.add_surface_leg2(ts_orig2);

		return pvdiff;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.pvdiff_curve_shift");		
		pvdiff_leg1 =  pvdiff_leg2 = null<number>;
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  dv01
  DV01 refers to dollar value of 1 basis point and it's the change in value of the npv
  of the instrument with a change of 1 basis point in the curve(s).
  This version has no knowledge of the underlying instruments and therefore the shifts
  are calculated directly from the fwd_func and disc_func
  (fwd_func --> shift of fwd rates)
  (disc_func --> shift of fwd rates calculated from the disc_func)
  ----------------------------------------------------------------------*/
number  swap_fltflt.dv01(	number option(nullable) delta, 
							logical option(nullable) trade_date_pv,
							error_info option(nullable) error ) 
{
	if(null(delta))
		delta = 0.0001;

	logical leg_indep_shift = false;
		
	number pv,pvdiff_fix, pvdiff_flt;

	number pvdiff = pvdiff_curve_shift(	delta, delta, delta,delta,
										trade_date_pv, leg_indep_shift,pv, pvdiff_fix,
										pvdiff_flt, error );
	
	return pvdiff / delta / 10000.0;
}
/*-----------------------------------------------------------------------
  dv01_disc
  This version has no knowledge of the underlying instruments (see above)
  ----------------------------------------------------------------------*/
number  swap_fltflt.dv01_disc(	number option(nullable) delta, 
								logical option(nullable) trade_date_pv,
								error_info option(nullable) error ) 
{
	if(null(delta))
		delta = 0.0001;
	
	logical leg_indep_shift = false;
		
	number pv,pvdiff_fix, pvdiff_flt;

	number pvdiff = pvdiff_curve_shift(	delta, delta, 0,0,
										trade_date_pv, leg_indep_shift,pv, pvdiff_fix,
										pvdiff_flt, error );
	
	return pvdiff / delta / 10000.0;
	
}

/*-----------------------------------------------------------------------
  dv01_fwd
   This version has no knowledge of the underlying instruments (see above)
  ----------------------------------------------------------------------*/
number  swap_fltflt.dv01_fwd(	number option(nullable) delta,								
								logical option(nullable) trade_date_pv,
								error_info option(nullable) error ) 
{
	if(null(delta))
		delta = 0.0001;
	
	logical leg_indep_shift = false;
		
	number pv,pvdiff_fix, pvdiff_flt;
	
	number pvdiff = pvdiff_curve_shift(	0, 0, delta,delta,
										trade_date_pv, leg_indep_shift,pv, pvdiff_fix,
										pvdiff_flt, error );
	
	return pvdiff / delta / 10000.0;
	
}

/*-----------------------------------------------------------------------
  swap_fltflt: ir_index_leg1
  ----------------------------------------------------------------------*/
ir_index swap_fltflt.ir_index_leg1(error_info option(nullable) error)
{	
	return swap_gen.swap_ir_index_leg1(error);
}

/*-----------------------------------------------------------------------
  ir_index	protected	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*ir_index swap_fltflt.ir_index(error_info option(nullable) error) option(hidden)
{	
	return swap_gen.swap_ir_index_leg1(error);
}*/

/*-----------------------------------------------------------------------
  swap_fltflt: ir_index_leg2
  ----------------------------------------------------------------------*/
ir_index swap_fltflt.ir_index_leg2(error_info option(nullable) error)
{	
	return swap_gen.swap_ir_index_leg2(error);
}


/*-----------------------------------------------------------------------
  index_tenor_leg1
  ----------------------------------------------------------------------*/
string swap_fltflt.index_tenor_leg1(error_info option(nullable) error) 
{	
	return swap_gen.swap_index_tenor_leg1(error);
}

/*-----------------------------------------------------------------------
  index_tenor_leg2
  ----------------------------------------------------------------------*/
string swap_fltflt.index_tenor_leg2(error_info option(nullable) error) 
{	
	return swap_gen.swap_index_tenor_leg2(error);
}

/*-----------------------------------------------------------------------
  index_tenor_code_leg1
  ----------------------------------------------------------------------*/
tenor_code swap_fltflt.index_tenor_code_leg1(error_info option(nullable) error) 
{	
	return swap_gen.swap_index_tenor_code_leg1(error);
}

/*-----------------------------------------------------------------------
  index_tenor_code_leg2
  ----------------------------------------------------------------------*/
tenor_code swap_fltflt.index_tenor_code_leg2(error_info option(nullable) error) 
{	
	return swap_gen.swap_index_tenor_code_leg2(error);
}

/*-----------------------------------------------------------------------
  disc_func_leg		EXT SWAP: ok
  ----------------------------------------------------------------------*/
disc_func swap_fltflt.disc_func_leg1(error_info option(nullable) error) 	{ return swap_gen.swap_disc_func_leg1(error);}
disc_func swap_fltflt.disc_func_leg2(error_info option(nullable) error) 	{ return swap_gen.swap_disc_func_leg2(error);}

/*-----------------------------------------------------------------------
  tenor_surface_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_fltflt.tenor_surface_leg1(error_info option(nullable) error) 	{ return swap_gen.swap_tenor_surface_leg1(error);}
tenor_surface swap_fltflt.tenor_surface_leg2(error_info option(nullable) error) 	{ return swap_gen.swap_tenor_surface_leg2(error);}

/*-----------------------------------------------------------------------
  get_legs	EXT SWAP: ok  prot
  ----------------------------------------------------------------------*/
void  swap_fltflt.get_legs(	out ql_float_leg  leg1, 
							out ql_float_leg  leg2) 
{
	error_info ee = new error_info(true,true);
	vector(ql_float_leg) l = swap_gen.swap_float_leg(false,ee);
	leg1 = l[0];
	leg2 = l[1];
}

/*-----------------------------------------------------------------------
  solver
  ----------------------------------------------------------------------*/
number swap_fltflt.solver(	number 				pv,
							swap_solver_code 	solver_code,
							logical option(nullable) trade_date_pv,
							error_info option(nullable) error)
{	
	return swap_gen.solver(pv,solver_code,trade_date_pv,error);
}

/*-----------------------------------------------------------------------
  imp_spread_leg1    EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fltflt.imp_spread_leg1(	number 				pv,							
									logical option(nullable) trade_date_pv,
									error_info option(nullable) error) 
{	
	return imp_spread_flt_leg(true, pv, trade_date_pv, error);
}


/*-----------------------------------------------------------------------
  imp_spread_leg2    EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fltflt.imp_spread_leg2(number 				pv,							
									logical option(nullable) trade_date_pv,
									error_info option(nullable) error) 
{	
	return imp_spread_flt_leg(false, pv, trade_date_pv, error);
}

/*-----------------------------------------------------------------------
  swap_instrument
  ----------------------------------------------------------------------*/
ql_fixed_income_swap swap_fltflt.swap_instrument(error_info option(nullable) error)
{
	return swap_gen.swap_instrument(error);

}
/*-----------------------------------------------------------------------
  float_legs
  ----------------------------------------------------------------------*/
vector(ql_float_leg) swap_fltflt.float_legs(logical clone,error_info option(nullable) error)
{	
	return swap_gen.swap_float_leg(clone,error);
}
/*-----------------------------------------------------------------------
  legs
  ----------------------------------------------------------------------*/
vector(ql_swap_leg) swap_fltflt.legs(logical clone,error_info option(nullable) error)
{	
	return swap_gen.swap_leg(clone,error);
}


/*-----------------------------------------------------------------------
  present_value
  ----------------------------------------------------------------------*/
number swap_fltflt.present_value(	disc_func option(nullable)	disc_func_leg1,
									disc_func option(nullable) 	disc_func_leg2,
									out number pv_leg1,
									out number pv_leg2,
									number option(nullable) 	notional,
									logical option(nullable) 	trade_date_pv,																								
									error_info option(nullable) error)
{	
	return swap_gen.present_value(disc_func_leg1,disc_func_leg2,pv_leg1,pv_leg2,notional,trade_date_pv,error);
}


number swap_fltflt.present_value(	disc_func option(nullable)	disc_func_leg1,
									disc_func option(nullable) 	disc_func_leg2,
									out number pv_leg1,
									out number pv_leg2,
									date option(nullable) pv_date,
									date option(nullable) settle_date,
									logical  	incl_issue_cf,
									logical  	incl_mat_cf,	
									error_info option(nullable) error)
{	
	return swap_gen.present_value(disc_func_leg1,disc_func_leg2,pv_leg1,pv_leg2,pv_date, settle_date ,incl_issue_cf,incl_mat_cf,error );
}


number swap_fltflt.present_value(	out number pv_leg1,
									out number pv_leg2,
									logical option(nullable) 	trade_date_pv,
									error_info option(nullable) error)
{	
	return swap_gen.present_value(pv_leg1,pv_leg2,trade_date_pv ,error );
}

/*-----------------------------------------------------------------------
  present_value override prot
  ----------------------------------------------------------------------*/
/*number  swap_fltflt.present_value(	number option(nullable) 	notional,
									logical 					trade_date_pv,
									disc_func option(nullable) 	disc_func_disc,
									error_info option(nullable) error)
{	
	try{	
		notional= conv_null_number_com(notional) ;		
		QL_FAIL_COND(!null(disc_func_disc),"input of separate disc_func (for trade_date_pv calculation) not supported for swaps", this, true);

		QL_FAIL_COND(!null(notional) && ccy_swap_,"input of notional not applicable for currency swaps", this, true);//use a version with 2 notionals or set notional to null	

		number pv_fix_leg,pv_flt_leg;
		return present_value(	null<disc_func>,null<disc_func>, pv_fix_leg, pv_flt_leg,
								notional,trade_date_pv,error);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.present_value");		
		return null<number>;
	}
}*/

/*-----------------------------------------------------------------------
  present_value  override
  ----------------------------------------------------------------------*/
/*number  swap_fltflt.present_value(	disc_func					disc_func,
									number option(nullable) 	notional,
									logical 					trade_date_pv,
									disc_func option(nullable) 	disc_func_disc,
									error_info option(nullable) error) 
{	
	try{	
		notional= conv_null_number_com(notional) ;
		QL_FAIL_COND(!null(disc_func_disc),"input of separate disc_func (for trade_date_pv calculation) not supported for swaps", this, true);

		QL_FAIL_COND(ccy_swap_,"inapplicable function call for cross currency swaps", this, true);//use a version with 2 disc_funcs	

		number pv_fix_leg,pv_flt_leg;
		return present_value(	disc_func,disc_func, pv_fix_leg, pv_flt_leg,
								notional,trade_date_pv,error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.present_value");		
		return null<number>;
	}
}*/

/*-----------------------------------------------------------------------
  pv01_spread	EXT SWAP: ok  - always returns a positive number regardless of pay/receive and sign of notional
  Note: not a "true" measure of risk, does not take into account if the swap has a pv <> 0
   PV01 refers to present value of 1 basis point spread and it's the discounted value of the cashflows
  for a float rate of 0.01% 
  ----------------------------------------------------------------------*/
number  swap_fltflt.pv01_spread_leg1(number option(nullable) notional,
										number option(nullable) delta,
										//logical option(nullable) trade_date_pv,
										disc_func option(nullable) df,
										error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	

		error_info ee 		= new error_info(true,true);
		disc_func df_orig 	= this.disc_func_leg1(ee);
		logical upd 		= false;
		
		if(!null(df)){
			this.add_disc_func_leg1(df);
			upd = true;
		}
		else if(null(df_orig)) {	
			QL_FAIL("discount function not set",this,true);
		}
		
		number c = i().__swap_pvbp_float_leg(notional,delta, true,t, s);
		if(!null(c))
			c = abs(c);
		
		if(upd && !null(df_orig))
			this.add_disc_func_leg1(df_orig);		

		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltflt.pv01_spread_leg1");	
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.pv01_spread_leg1");
		return null<number>;
	}
}

number  swap_fltflt.pv01_spread_leg2(number option(nullable) notional,
										number option(nullable) delta,
										//logical option(nullable) trade_date_pv,
										disc_func option(nullable) df,
										error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	

		error_info ee 		= new error_info(true,true);
		disc_func df_orig 	= this.disc_func_leg2(ee);
		logical upd 		= false;
		
		if(!null(df)){
			this.add_disc_func_leg2(df);
			upd = true;
		}
		else if(null(df_orig)) {	
			QL_FAIL("discount function not set",this,true);
		}
		
		number c = i().__swap_pvbp_float_leg(notional,delta, false,t, s);
		if(!null(c))
			c = abs(c);
		
		if(upd && !null(df_orig))
			this.add_disc_func_leg2(df_orig);		

		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltflt.pv01_spread_leg2");	
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt.pv01_spread_leg2");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  payment_data_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.payment_data_leg1(logical 				post_settle,
									logical option(nullable) trade_date_pv,
									out vector(date)  		fixing_date,
									out vector(number)  	fixing_rate,
									out vector(logical)  	is_fixed,									
									out vector(date)  		pmt_date,
									out vector(number) 		cpn_rate,
									out vector(number)  	cpn_cashflow,
									out vector(number)  	pv_cpn_cashflow,
									out vector(number)  	fee,
									out vector(number)  	pv_fee,
									out vector(number)  	notional ,
									error_info option(nullable)  error ) 
{	
	swap_gen.payment_data_flt_leg(false, post_settle, trade_date_pv, fixing_date, fixing_rate,
								  is_fixed,pmt_date,cpn_rate,cpn_cashflow,pv_cpn_cashflow,
								  fee,pv_fee, notional, error);

}
/*-----------------------------------------------------------------------
  payment_data_leg2	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.payment_data_leg2(logical 				post_settle,
									logical option(nullable) trade_date_pv,
									out vector(date)  		fixing_date,
									out vector(number)  	fixing_rate,
									out vector(logical)  	is_fixed,									
									out vector(date)  		pmt_date,
									out vector(number) 		cpn_rate,
									out vector(number)  	cpn_cashflow,
									out vector(number)  	pv_cpn_cashflow,
									out vector(number)  	fee,
									out vector(number)  	pv_fee,
									out vector(number)  	notional ,
									error_info option(nullable)  error ) 
{	
	swap_gen.payment_data_flt_leg(true, post_settle, trade_date_pv, fixing_date, fixing_rate,
								  is_fixed,pmt_date,cpn_rate,cpn_cashflow,pv_cpn_cashflow,
								  fee,pv_fee, notional, error);

}

/*-----------------------------------------------------------------------
  principal_data_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.principal_data_leg1( 	logical 				post_settle,
											logical option(nullable) trade_date_pv,
											logical 				only_real_cf,
											out vector(date) 		prin_date,
											out vector(number) 		prin_cf,	
											out vector(number) 		pv_prin_cf,
											error_info option(nullable)  error )
{
	swap_gen.principal_data_flt_leg(false, post_settle, trade_date_pv, only_real_cf,
									prin_date,prin_cf,pv_prin_cf,error);
}

/*-----------------------------------------------------------------------
  principal_data_leg2	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltflt.principal_data_leg2( 	logical 				post_settle,
											logical option(nullable) trade_date_pv,
											logical 				only_real_cf,
											out vector(date) 		prin_date,
											out vector(number) 		prin_cf,	
											out vector(number) 		pv_prin_cf,
											error_info option(nullable)  error )
{
	swap_gen.principal_data_flt_leg(true, post_settle, trade_date_pv, only_real_cf,
									prin_date,prin_cf,pv_prin_cf,error);
}
