option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	Notes on disc_funcs and fwd_funcs --> see class file for swap_fixois
	--------------------------------------------------------------------
	fltois
	Note:
	for db-swaps: leg1 is the float leg, floatleg is specified in the general tab
	--------------------------------------------------------------------
*/

//----------------------------------------------------------------------
//  class swap_fltois
//----------------------------------------------------------------------
class swap_fltois: public swap_gen
option(category: "Instrument/Interest Rate Swap/Float vs ONIndex")
//option(allow_undeclared_mfuncs)
{
public:
    //override string	instr_type_s();
	override instrument 	inst();
	override swap_fltois 	clone() ;	
	override void         __dbg_print(__dbg_label);
    override void         __dbg_browse(__dbg_split);
	
	/*----------ADD FUNCS [PUBLIC]---------------*/
	void 		add_quote(number,..quote_style );
	override void add_quote(number);
	void 		add_notional(number );
	void 		add_notional(number , number);
	void		add_fx_rate(number,logical,string,string );
	void 		add_fx_mult_flt_leg(number );
	void 		add_fx_mult_ois_leg(number );
	
	void 		add_disc_func(disc_func,logical,out tenor_surface );
	void 		add_disc_func_flt_leg(disc_func );	//note disc_func for mtm-feature not added here
	void 		add_disc_func_ois_leg(disc_func,logical ,out tenor_surface );	//note disc_func for mtm-feature not added here
	void		add_fwd_func_ois_leg(fwd_func,logical,out disc_func,out tenor_surface   );
	void 		add_fwd_from_disc_func_ois_leg(disc_func,logical,out tenor_surface  );
	void 		add_surface_flt_leg(tenor_surface option(nullable));
	void 		add_surface_ois_leg(tenor_surface option(nullable));

	void		add_fixing_flt_leg(vector(date) ,vector(number) ,logical option(nullable) fixing_as_fwd = false);
	void		add_fixing_ois_leg(vector(date) ,vector(number) ,logical option(nullable) fixing_as_fwd = false);
	void		add_fixing_flt_leg(number ,logical option(nullable) fixing_as_fwd = false);
	void		add_fixing_ois_leg(number ,logical option(nullable) fixing_as_fwd = false);
	void		add_current_fixing_flt_leg(number option(nullable));

	void 		add_curve_data_ois_leg(disc_func , disc_func option(nullable),logical ) ;
	void 		add_curve_data_ois_leg(disc_func , fwd_func option(nullable),logical ) ;

	void 		add_curve_data_flt_leg(	disc_func ,tenor_surface ) ;
	
	void 		add_curve_data(	disc_func  ,tenor_surface , disc_func option(nullable), disc_func option(nullable),logical ) ;
	void 		add_curve_data(	disc_func  ,tenor_surface , disc_func option(nullable), fwd_func option(nullable),logical ) ;
	/*
	 add_data()
	 add_ccy_data()
	 */
	void 		curve_state(out disc_func, out disc_func, out tenor_surface);
	void		add_curve_state( disc_func option(nullable),  disc_func option(nullable),  tenor_surface option(nullable));
	void		add_mtm_data(number option(nullable),number option(nullable)	,string option(nullable)	,string option(nullable)	,
							 disc_func option(nullable) ,disc_func option(nullable) ) ;
	
	/*----------MISC FUNCS [PUBLIC]---------------*/
	date 				start_date(error_info option(nullable) error = null<error_info> );				/*name change of issuedate*/
	override void		final_pmt_date(out date ,out date ,error_info option(nullable) error = null); 

	logical	 			is_cross_currency(error_info option(nullable) error = null<error_info> );
	//override void 	is_amortizing(out logical,out logical ,error_info option(nullable) error = null<error_info>);
	//override logical 	is_amortizing(error_info option(nullable) error = null<error_info>);
	//logical			is_par_flat(error_info option(nullable) error = null<error_info>);
	logical 			pay_float(error_info option(nullable) error = null<error_info> );
	override void 		notional(out number , out number , error_info option(nullable) error = null<error_info>);
	number 				notional(error_info option(nullable) error = null<error_info>);
	//void 				is_regular_first(out logical , out logical , error_info option(nullable) error = null<error_info>);				
	//void 				is_regular_last(out logical , out logical , error_info option(nullable) error = null<error_info>);		
	//override void 	fx_mult(out number , out number , error_info option(nullable) error = null<error_info>);	
	override void 		currency(out string , out string ,error_info option(nullable) error = null<error_info> );
	//override void 	coupon(out number ,out number , error_info option(nullable) error = null<error_info>);
	override void 		coupon_freq(out integer,out integer, error_info option(nullable) error = null<error_info> );
	override void 		dc_method(	out day_count_method , out day_count_method ,error_info option(nullable) error = null<error_info>);	
	override void  		pmt_bus_day(out bd_convention , out bd_convention ,error_info option(nullable) error = null<error_info> );
	//override void 	roll_day(out integer,out integer,  error_info option(nullable) error = null<error_info>);
	override void 		eom(out logical ,out logical ,error_info option(nullable) error = null<error_info> );
	override void 		calendar(out ..calendar ,out ..calendar ,error_info option(nullable) error = null<error_info> );
	//override void  	first_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	//override void  	last_reg_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	override void  		effective_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	override void  		next_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	override void  		previous_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	override void		calendar_name(out string ,out string  , error_info option(nullable) error = null<error_info> ) ;

	void 			pmt_lag(out	integer 	pmt_lag_leg1,
							out	integer 	mat_pmt_lag_leg1,
							out	integer 	pmt_lag_prin_leg1,
							out	integer 	mat_pmt_lag_prin_leg1,
							out	integer 	pmt_lag_leg2,
							out	integer 	mat_pmt_lag_leg2,
							out	integer 	pmt_lag_prin_leg2,
							out	integer 	mat_pmt_lag_prin_leg2,	
							error_info option(nullable) error) ;
	
	override string 	settle_code(error_info option(nullable) error = null<error_info>);
	
	override void 		reset_freq(	out integer , out integer  , error_info option(nullable) error = null<error_info>) ;
	logical				flat_leg_is_float_leg(error_info option(nullable) error = null<error_info> );
	logical				flat_leg_is_ois_leg(error_info option(nullable) error = null<error_info> );

	logical  			is_mtm_flt_leg(error_info option(nullable) error= null<error_info> );
	logical  			is_mtm_ois_leg(error_info option(nullable) error= null<error_info> ) ;
	
	override void 		quote(out number  ,out number  ,error_info option(nullable) error = null<error_info> );	
	override number 	quote(error_info option(nullable) error = null<error_info> );
	
	/*----------CASHFLOW FUNCS [PUBLIC]---------------*/
	override void		cash_flow_dates(logical,out vector(date) ,out vector(date) ,error_info option(nullable) error = null<error_info> ) ;
	void				prin_cash_flow_dates(logical,out vector(date) ,out vector(date) ,error_info option(nullable) error = null<error_info> ) ;

	override void		cash_flows_cpn(logical,out vector(number) ,out vector(number),error_info option(nullable) error = null<error_info> );
	override void		cash_flows(logical,out vector(number) ,out vector(number),error_info option(nullable) error = null<error_info> );
	override void		cash_flow_data(	logical,ir_cf_code cf_code,out vector(date)  ,out vector(number)  , out vector(date)   ,out vector(number)  ,
										error_info option(nullable) error = null<error_info> );
	override void 		cash_flow_data(	logical,logical option(nullable),out vector(date)  ,out vector(number) ,
										out vector(number)  ,out vector(number)  , out vector(number)  ,out vector(number)  ,
										out vector(number)  ,out vector(date)  	, out vector(number)  ,out vector(number)  ,
										out vector(number)  ,out vector(number)  , out vector(number)  ,out vector(number)  ,
										error_info option(nullable) error = null<error_info> );

	
	void 				data(out swap_flt_leg_data,out swap_ois_leg_data,error_info option(nullable) error = null<error_info>);
	void 				data(out swap_flt_leg_data,error_info option(nullable) error = null<error_info>);
	void 				data(out swap_ois_leg_data,error_info option(nullable) error = null<error_info>);
	
	/*----------PV FUNCS [PUBLIC]---------------*/
	override number  	present_value(	disc_func option(nullable),disc_func option(nullable),out number ,
								out number ,number option(nullable)=null<number>,logical option(nullable) trade_date_pv = false,		
								error_info option(nullable) error = null<error_info>);
	
	override number  	present_value(	disc_func option(nullable),disc_func option(nullable),out number ,out number ,
								date option(nullable) ,date option(nullable) ,
								logical,logical  ,error_info option(nullable) error = null<error_info>);

	override number  	present_value_fee(	disc_func option(nullable),disc_func option(nullable),out number  ,
								out number ,date option(nullable) ,date option(nullable) ,
								logical,logical  ,error_info option(nullable) error = null<error_info>);
	
	override number  	present_value(	out number ,out number pv_ois_leg,
								logical option(nullable) ,error_info option(nullable) error = null<error_info> );

	override number 	accrued(logical,out number ,out number , error_info option(nullable) error = null<error_info>);
	override void 		accrued_period(out number ,out number , out integer,out integer,error_info option(nullable) error = null<error_info>);

	
	override number		solver(	number,swap_solver_code ,logical option(nullable) trade_date_pv = false,
								error_info option(nullable) error = null<error_info>);

	/*----------FLTLEG FUNCS [PUBLIC]---------------*/
	
	flt_stub_fwd_style  stub_fwd_style_flt_leg(error_info option(nullable) error= null<error_info>);
	flt_avg_method  	avg_method_flt_leg(error_info option(nullable) error = null<error_info>);
	flt_sprd_comp_method  sprd_comp_method_flt_leg(error_info option(nullable) error = null<error_info>);
	flt_comp_avg_type  	comp_avg_type_flt_leg(error_info option(nullable) error = null<error_info>);
	interest_rule  		ir_rule_flt_leg(error_info option(nullable) error = null<error_info>);
	disc_func 			disc_func_flt_leg(error_info option(nullable) error = null<error_info> ) ;
	tenor_surface 		tenor_surface_flt_leg(error_info option(nullable) error = null<error_info>);
	
	void				accr_dates_flt_leg(	logical,out vector(date),out vector(date),out vector(number) ,
												error_info option(nullable) error= null<error_info> );
	
	ir_index 			ir_index_flt_leg(error_info option(nullable) error = null<error_info>);
	 
	tenor_code 			index_tenor_code_flt_leg(error_info option(nullable) error = null<error_info> ) ;
	string 				currency_flt_leg(error_info option(nullable) error = null<error_info>);
	string 				index_tenor_flt_leg(error_info option(nullable) error = null<error_info>) ;
	number				spread_flt_leg(error_info option(nullable) error = null<error_info> );
	number				imp_spread_flt_leg(number,logical option(nullable) trade_date_pv = false,
											   error_info option(nullable) error = null<error_info>);
	integer				reset_freq_flt_leg(error_info option(nullable) error = null<error_info>);
	integer				coupon_freq_flt_leg(error_info option(nullable) error = null<error_info>);
	number				current_coupon_flt_leg(error_info option(nullable) error = null<error_info> );
	number				current_fixing_flt_leg(out date,out logical,error_info option(nullable) error = null<error_info>);
	day_count_method  	dc_method_flt_leg( error_info option(nullable) error = null<error_info>);

	void				index_dates_flt_leg(logical,out vector(date) ,out vector(date) ,
											out vector(logical) ,error_info option(nullable) error = null<error_info> ) ;
	void				fixing_data_flt_leg(logical ,logical option(nullable),out vector(date)  ,									
												out vector(number)  ,out vector(logical),
												error_info option(nullable) error = null<error_info> ) ;
	
	number				pv01_spread_flt_leg(number option(nullable)= null<number>,number option(nullable)= null<number>,
										disc_func option(nullable) df = null<disc_func>,
										error_info option(nullable) error = null<error_info>);
	
	tenor_surface 		create_tenor_surface_flt_leg(disc_func ,fwd_func,error_info option(nullable) error = null<error_info> );

	void 				payment_data_flt_leg(	logical,logical option(nullable),out vector(date) ,out vector(number) ,
												out vector(logical) ,out vector(date),out vector(number) ,out vector(number) ,out vector(number) ,
												out vector(number) ,out vector(number),out vector(number) ,
												error_info option(nullable)  error = null<error_info>) ;

	void 				principal_data_flt_leg(	logical,logical option(nullable) ,logical ,
												out vector(date),out vector(number),out vector(number) ,
												error_info option(nullable)  error  = null<error_info>);
	
	/*----------OISLEG FUNCS [PUBLIC]---------------*/
	
	integer  			rfr_arrears_days_ois_leg(error_info option(nullable) error = null<error_info>);
	rfr_arrears_type  	rfr_arrears_type_ois_leg(error_info option(nullable) error = null<error_info>);
	flt_avg_method  	avg_method_ois_leg(error_info option(nullable) error = null<error_info>);
	flt_sprd_comp_method  sprd_comp_method_ois_leg(error_info option(nullable) error = null<error_info>);
	flt_comp_avg_type  	comp_avg_type_ois_leg(error_info option(nullable) error = null<error_info>);
	interest_rule  		ir_rule_ois_leg(error_info option(nullable) error = null<error_info>);
	number				spread_ois_leg(error_info option(nullable) error = null<error_info> );
	void				current_fixings_ois_leg(logical,out vector(date),out vector(number) ,out vector(logical),
													error_info option(nullable) error = null<error_info>);
	logical  			is_endog_df(error_info option(nullable) error = null<error_info>);
	logical  			is_approx_calc(error_info option(nullable) error = null<error_info>);
	/*number			pv01_spread(number option(nullable)= null<number>,number option(nullable)= null<number>,
										disc_func option(nullable) df = null<disc_func>,
										error_info option(nullable) error = null<error_info>);*/
	
	integer				reset_freq_ois_leg(error_info option(nullable) error = null<error_info>);

	void				index_dates_ois_leg(logical,logical,out vector(date) ,out vector(date) ,
											out vector(logical)  ,error_info option(nullable) error = null<error_info> ) ;
	void				accr_dates_ois_leg(	logical,out vector(date),out vector(date),out vector(number) ,
											error_info option(nullable) error= null<error_info>);


	void				fixing_data_ois_leg(logical ,logical option(nullable),out vector(date)  ,									
											out vector(number)  ,out vector(logical) ,
											error_info option(nullable) error = null<error_info> ) ;
	number				imp_spread_ois_leg(number,logical option(nullable) trade_date_pv = false,
										   error_info option(nullable) error = null<error_info>);
	
	disc_func 			disc_func_ois_leg(error_info option(nullable) error = null<error_info> ) ;
	tenor_surface 		tenor_surface_ois_leg(error_info option(nullable) error = null<error_info>);
	fwd_func 			fwd_func_ois_leg(error_info option(nullable) error = null<error_info>);	
	ir_index 			ir_index_ois_leg(error_info option(nullable) error = null<error_info> );
	string 				index_tenor_ois_leg(error_info option(nullable) error = null<error_info> ) ;
	tenor_code 			index_tenor_code_ois_leg(error_info option(nullable) error = null<error_info> ) ;
	string 				currency_ois_leg(error_info option(nullable) error = null<error_info>);
	day_count_method  	dc_method_ois_leg( error_info option(nullable) error = null<error_info>);
	tenor_surface 		create_tenor_surface_ois_leg(disc_func option(nullable),fwd_func option(nullable),logical,
													 error_info option(nullable) error = null<error_info> );
	number				pv01_spread_ois_leg(number option(nullable)= null<number>,number option(nullable)= null<number>,
												disc_func option(nullable) df = null<disc_func>,
												error_info option(nullable) error = null<error_info>);
	void 				payment_data_ois_leg(	logical,logical option(nullable),out vector(date) ,out vector(number) ,
												out vector(logical) ,out vector(date),out vector(number) ,out vector(number) ,out vector(number) ,
												out vector(number) ,out vector(number),out vector(number) ,
												error_info option(nullable)  error = null<error_info>) ;

	void 				principal_data_ois_leg(	logical,logical option(nullable) ,logical ,
												out vector(date),out vector(number),out vector(number) ,
												error_info option(nullable)  error  = null<error_info>);
	/*-----external swap specific-----*/
	override ql_fixed_income_swap 	swap_instrument(error_info option(nullable) error = null<error_info>) ;
	override instrument_type 		swap_type(error_info option(nullable) error = null<error_info>);
	vector(ql_swap_leg) 	legs(logical,error_info option(nullable) error = null<error_info>);
	ql_float_leg 			float_leg(logical,error_info option(nullable) error = null<error_info>);
	ql_ois_leg 				ois_leg(logical,error_info option(nullable) error = null<error_info>);


	/*---set functions-required--*/	
	override swap_fltois	set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);
	override swap_fltois	set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);
	
	
	swap_fltois				set_spread_ois_leg(number option(nullable) ,error_info option(nullable) error = null<error_info>);
	swap_fltois				set_spread_flt_leg(number option(nullable) ,error_info option(nullable) error = null<error_info>);

	//local set funcs
	swap_fltois 			set_date(date,date option(nullable) settle_date=null<date>, error_info option(nullable) error = null<error_info>);
	override swap_fltois	set_date(date,date option(nullable),logical,logical ,error_info option(nullable) error = null<error_info> );
	//void					update_to_par(error_info option(nullable) error = null<error_info> );
	swap_fltois				set_pay_leg(logical ,error_info option(nullable) error = null<error_info>);
	//--------------------------------------------------------------------------
	//----------HIDDEN FUNCS [PUBLIC]--(mostly for backward compat)-------------
	//--------------------------------------------------------------------------
	swap_fltois(__instrument);
	//general-one per leg
	override string 		currency(error_info option(nullable) error = null<error_info> );				/*hidden, visible in root*/
	override logical 		eom(error_info option(nullable) error = null<error_info>);						/*hidden, not visible in root*/
	
	swap_fltois(swap_fltois );

protected:
	
	override swap_fltois	create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);
	swap_fltois 			err_type(swap_fltois option(nullable), error_info option(nullable) error = null<error_info>);
	
	
	//set funcs
	//override swap_fixois	set_date(date,date option(nullable) ,logical,logical , error_info option(nullable) error = null<error_info>);	
	override swap_fltois	set_date(date,logical ,error_info option(nullable) error = null<error_info>);					/*legacy*/

	override swap_fltois	move_date(	date,date option(nullable) settle_date=null<date> ,
										error_info option(nullable) error = null<error_info>);								/*legacy*/

	override swap_fltois	set_quote_from_yield(number option(nullable), error_info option(nullable) error = null<error_info>);/*legacy*/

	void  					get_legs(	out ql_float_leg,out ql_ois_leg );
	
	//logical ext_swap_;
	//logical ccy_swap_;
	//logical full_swap_;
};

//------------------------------------------------
// __dbg_print
//------------------------------------------------
void swap_fltois.__dbg_print(__dbg_label l)
{

	error_info ee 	= new error_info(true,false);
    l.set_text(strcat([
						"name: ",
						name(ee),
						",  ext_swap: ",
						null(ext_swap_) ? "" : string(ext_swap_),
                        ", ccy_swap: ",
						null(ccy_swap_) ? "" : string(ccy_swap_),
						", valid: ",
						null(this.is_valid(ee)) ? "" : string(this.is_valid(ee))
					]));
}
//------------------------------------------------
// __dbg_browse
//------------------------------------------------
void swap_fltois.__dbg_browse(__dbg_split s)
{
    s.resize(4);
	error_info ee 	= new error_info(true,false);
    s.set_text(0, "name");
    s.set_value(0, this.name(ee));

    s.set_text(1, "ext_swap");
    s.set_value(1, ext_swap_);

    s.set_text(2, "ccy_swap");
    s.set_value(2, ccy_swap_);

	s.set_text(3, "valid");
    s.set_value(3, is_valid(ee));
}

//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
swap_fltois.swap_fltois(__instrument i) option(hidden): swap_gen(i)
{
	//try {
		error_info ee 	= new error_info(true,true);
		if(!this.is_valid(ee)) {
			ext_swap_ = ccy_swap_ = full_swap_ = false;
			return;
		}
		ext_swap_ 		= this.is_ext_swap(ee);
		ccy_swap_ 		= this.is_ccy_swap(ee);
		full_swap_ 		= this.verify_full_swap(true,ee);
		return;									
	//}
	//catch {		
	//	CORE_INT.write_warning_message(err.message());
	//}
}
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string swap_fltois.instr_type_s() 	{ return string(..instr_type.SWAP_FLTOIS);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	swap_fltois.inst()		{ return this;}
//------------------------------------------------
// copy constructor
//------------------------------------------------
swap_fltois.swap_fltois(swap_fltois c) : swap_gen(c) {}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
swap_fltois swap_fltois(swap_fltois b)			{ return new swap_fltois(b);}
//------------------------------------------------
// clone
//------------------------------------------------
swap_fltois swap_fltois.clone() 	{ return new swap_fltois(this);}
//-----------------------------------------------
// dynamic cast <FUNCTION>   EXT SWAP: ok
//-----------------------------------------------
swap_fltois swap_fltois(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex')
option(com_name: 'swap_fltois_dyncast')
{ 
	try {
		swap_fltois d = dynamic_cast<swap_fltois>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a swap_fltois)","swap_fltois" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois");
		return null<swap_fltois>;
	}
}
//------------------------------------------------
// create  [PROTECTED]
// create swap_fltois from internal instrument
//------------------------------------------------
swap_fltois swap_fltois.create(	__instrument option(nullable) c,
								out instr_error option(nullable) error,
								error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_fltois>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.SWAP_FLTOIS, "invalid instrument type",type );//should not happen
	
	return new swap_fltois(c);
}

/*-----------------------------------------------------------------------
  function: create_swap_fltois
  ----------------------------------------------------------------------*/
swap_fltois create_swap_fltois(	__instrument option(nullable) c,
									out instr_error option(nullable) error,
									error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_swap_fltois')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_fltois>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.SWAP_FLTOIS, "invalid instrument type",type );//should not happen
	
	return new swap_fltois(c);
}
swap_fltois create_swap_fltois(	__instrument option(nullable) 		c,
								error_info option(nullable) 		error,
								error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_swap_fltois_ei')
{
	instr_error ee 	= instr_error();
	swap_fltois b 	= create_swap_fltois(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_swap_fltois");
	return b;
}

/*-----------------------------------------------------------------------
  err_type	EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois.err_type(swap_fltois option(nullable) nul,
								 error_info option(nullable) error )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,"mwlib(ql) error: inapplicable function call for current instrument type");
	return null<swap_fltois>;
}
/*-----------------------------------------------------------------------
  swap_fltois: add_funcs
  ----------------------------------------------------------------------*/
void swap_fltois.add_notional(number notional)				{ swap_gen.swap_add_notional(notional);}
void swap_fltois.add_notional(number notional1, number notional2)	{ swap_gen.swap_add_notional(notional1, notional2);}
void swap_fltois.add_fx_mult_flt_leg(number fx_mult)		{ swap_gen.swap_add_fx_mult_leg1(fx_mult);}
void swap_fltois.add_fx_mult_ois_leg(number fx_mult)		{ swap_gen.swap_add_fx_mult_leg2(fx_mult);}
/*-----------------------------------------------------------------------
  add_fx_rate EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fltois.add_fx_rate(number fx_quote_dec,//must be a quote per unit of base ccy 
							logical pv_in_base_ccy,
							string 	base_ccy,
							string 	price_ccy)
{

	swap_gen.swap_add_fx_rate(fx_quote_dec,pv_in_base_ccy,base_ccy,price_ccy);
}
void swap_fltois.add_disc_func_flt_leg(disc_func disc_func) 				{ swap_gen.swap_add_disc_func_leg1(disc_func); }//beware that even for single curr swaps only one leg is updated
void swap_fltois.add_current_fixing_flt_leg(number option(nullable) fixing) { swap_gen.swap_add_curr_fixing_leg1(fixing);	}

/*-----------------------------------------------------------------------
  swap_fltois: add_quote		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fltois.add_quote(	number  quote ) 
{
	instrument.add_quote(quote, false);
	return ;						
}
/*-----------------------------------------------------------------------
  swap_fltois: add_quote		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fltois.add_quote(	number  quote,
							..quote_style quote_style) 
{
	error_info ee = new error_info(true,true);
	..quote_style qs = instrument.quote_style_e(ee);
	
	if(quote_style == qs)
		this.add_quote(quote);
	else{
		if(quote_style == ..quote_style.SPREAD)
			this.add_quote(quote*10000);//instr quotestyle must be SPREAD_BP
		else if(quote_style == ..quote_style.SPREAD_BP)
			this.add_quote(quote/10000);//instr quotestyle is SPREAD
		else
			QL_FAIL("invalid quote style",this,true);
	}					
}

/*-----------------------------------------------------------------------
  add_disc_func	 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fltois.add_disc_func(disc_func disc_func,
							   logical add_surf_if_endog,
							   out tenor_surface ts )//ts will be added as is to swap if input (if add_surf_if_endog=true and is_endog )
{
	QL_REQUIRE(!ccy_swap_,"inapplicable function call for cross currency swaps",this,true);
	add_disc_func_ois_leg(disc_func,add_surf_if_endog,ts);
	add_disc_func_flt_leg(disc_func);
}
/*--------------------
 add_disc_func ois leg
  Note: -this func refers to the discounting but if [endog_df = true] also the surface will be updated
		-beware that even for single curr swaps only ois leg is updated
 ---------------------*/
void swap_fltois.add_disc_func_ois_leg(disc_func  disc_func,
									   logical add_surf_if_endog,
									   out tenor_surface ts)//ts will be added as is to swap if input (if add_surf_if_endog=true and is_endog ) 
{
	
	swap_gen.add_disc_func_ois_leg2( disc_func,add_surf_if_endog,ts );
}

/*--------------------
 add_fwd_func ois leg
 ---------------------*/
void swap_fltois.add_fwd_func_ois_leg(fwd_func fwd_func,
									  logical add_disc_if_endog,
									  out disc_func df,//df will be used if input (if add_disc_if_endog = true and is_endog_df)
									  out tenor_surface ts)//ts is output only
{
	
	
	swap_gen.add_fwd_func_ois_leg2(fwd_func,add_disc_if_endog, df, ts);


	/*if(this.is_endog_df(ee)){

		date m = maturity(ee);
		..ir_index idx = ir_index(ee);
		disc_func df = CORE_INT.on_fwd_to_df(trade_date(),m,fwd_func,idx.day_count_method(),idx.fixing_calendar(),true);		
		swap_gen.swap_add_disc_func_leg2(df);
				
	}
	
	tenor_surface ts = create_tenor_surface_ois_leg(null, fwd_func, ee);//a discfunc will be created
	add_surface_ois_leg(ts);*/
	
	/*if(this.is_endog_df(ee)){		
		date m = maturity(ee);
		..ir_index idx = ir_index_ois_leg(ee);
		disc_func df = CORE_INT.on_fwd_to_df(trade_date(),m,fwd_func,idx.day_count_method(),idx.fixing_calendar(),true);		
		swap_gen.swap_add_disc_func_leg2(df);
		
		logical allow_extrap = false;
		tenor_surface ts = tenor_surface(this.trade_date(), df,[fwd_func],[idx],allow_extrap);
		add_surface_ois_leg(ts);
		
	}
	else {
		if(this.is_approx_calc(ee)) {//approx + not endog --> a df in surface is used for fwd rates
			tenor_surface ts = create_tenor_surface_ois_leg(null, fwd_func, ee);//a discfunc will be created
			add_surface_ois_leg(ts);
		}
		else {//NOT approx + NOT endog --> fwd and disc are independent
			//swap_gen.swap_add_fwd_func_leg2(fwd_func);
			..ir_index idx = ir_index(ee);
			logical allow_extrap = false;
			disc_func df_na = disc_func_interp([1],[1],ip_linear());//disc_func not applicable but is not nullable
			tenor_surface ts = tenor_surface(this.trade_date(), df_na,[fwd_func],[idx],allow_extrap);
			add_surface_ois_leg(ts);
		}
	}*/
}
/*--------------------
 add_fwd_from_disc_func
 ---------------------*/
void swap_fltois.add_fwd_from_disc_func_ois_leg(disc_func fwddf,
												logical add_disc_if_endog,
												out tenor_surface ts)//ts is output only
{
	
	swap_gen.add_fwd_from_disc_func_ois_leg2( fwddf,add_disc_if_endog,ts);
		
	/*error_info ee = new error_info(true,true);

	if(this.is_endog_df(ee)){
		swap_gen.swap_add_disc_func_leg2(fwddf);
	}

	tenor_surface ts = create_tenor_surface_ois_leg(fwddf, null, ee);//a fwdfunc will be created
	add_surface_ois_leg(ts);*/
	
	/*if(this.is_endog_df(ee)){

		if(this.is_approx_calc(ee)) {		
			swap_gen.swap_add_disc_func_leg2(disc_func);
		}
		else {			
			..ir_index idx = ir_index(ee);
			fwd_func f = fwd_func(disc_func,365,trade_date(),idx.day_count_method(),idx.fixing_calendar(),BD_FOLLOWING,false);			
			//swap_gen.swap_add_fwd_func_leg2(f);
			logical allow_extrap = false;
			tenor_surface ts = tenor_surface(this.trade_date(), disc_func ,[f],[idx],allow_extrap);//disc_func not applicable but is not nullable
			add_surface_ois_leg(ts);
		}
	}
	else {
		if(this.is_approx_calc(ee)) {//approx + not endog --> a df in surface is used for fwd rates
			tenor_surface ts = create_tenor_surface_ois_leg(disc_func, null, ee);
			add_surface_ois_leg(ts);
		}
		else {//NOT approx + NOT endog --> fwd and disc are independent
			..ir_index idx = ir_index(ee);
			fwd_func f = fwd_func(disc_func,365,trade_date(),idx.day_count_method(),idx.fixing_calendar(),BD_FOLLOWING,false);			
			//swap_gen.swap_add_fwd_func_leg2(f);			
			logical allow_extrap = false;
			tenor_surface ts = tenor_surface(this.trade_date(), disc_func,[f],[idx],allow_extrap);//disc_func not applicable but is not nullable hence we use disc_func as input
			add_surface_ois_leg(ts);
		}		
	}*/
}
/*-----------------------------------------------------------------------
  add_surface_flt_leg
  ----------------------------------------------------------------------*/
void swap_fltois.add_surface_flt_leg(tenor_surface option(nullable) tenor_surface)
{
	swap_gen.swap_add_surface_leg1(tenor_surface);
}

/*-----------------------------------------------------------------------
  add_surface_ois_leg
  no sync of disc_func
  ----------------------------------------------------------------------*/
void swap_fltois.add_surface_ois_leg(tenor_surface option(nullable) tenor_surface)	
{
	swap_gen.swap_add_surface_leg2(tenor_surface);
}

/*-----------------------------------------------------------------------
  add_curve_data_ois_leg
  ----------------------------------------------------------------------*/
void swap_fltois.add_curve_data_ois_leg(disc_func  df_disc,
										disc_func 	option(nullable) df_fwd, 	//only used if NOT endog_df
										logical sync_endog_ok)
{
	
	swap_gen.add_curve_data_ois_leg2(	df_disc,df_fwd,sync_endog_ok) ;
	
	/*error_info ee = new error_info(true,true);

	logical endog_df = this.is_endog_df(ee);	
	QL_FAIL_COND(endog_df && !null(df_fwd), "ambigious input");
	
	add_disc_func_ois_leg(df_disc );//if endog we create a fwd_func and update surface

	if(endog_df)
		return;
	
	QL_REQUIRE(!null(df_fwd), "df_fwd is required for non self discounting ois");
		
	tenor_surface ts = create_tenor_surface_ois_leg(df_fwd, null, ee);//a fwdfunc will be created
	add_surface_ois_leg(ts);*/
	
	/*add_disc_func_ois_leg(df_disc );
		
	if(!this.is_endog_df(ee)){
		
		QL_REQUIRE(!null(df_fwd), "df_fwd is required for non self discounting ois");
		
		if(this.is_approx_calc(ee)) {
			tenor_surface ts = create_tenor_surface_ois_leg(df_fwd, null, ee);
			add_surface_ois_leg(ts);
		}
		else {
			..ir_index idx = ir_index(ee);
			fwd_func f = fwd_func(df_fwd,365,trade_date(),idx.day_count_method(),idx.fixing_calendar(),BD_FOLLOWING,false);			
			//swap_gen.swap_add_fwd_func_leg2(f);
			logical allow_extrap = false;
			tenor_surface ts 	= tenor_surface(this.trade_date(), df_disc,[f],[idx],allow_extrap);
			add_surface_ois_leg(ts);
		}
	}	*/
}
/*-----------------------------------------------------------------------
  add_curve_data_ois_leg
  ----------------------------------------------------------------------*/
void swap_fltois.add_curve_data_ois_leg(disc_func  df_disc,
										fwd_func option(nullable) f_fwd, 	//only used if NOT endog_df
										logical sync_endog_ok)
{
	
	swap_gen.add_curve_data_ois_leg2( df_disc, f_fwd,sync_endog_ok) ;
	
/*	error_info ee = new error_info(true,true);

	logical endog_df = this.is_endog_df(ee);	
	QL_FAIL_COND(endog_df && !null(f_fwd), "ambigious input");
	
	add_disc_func_ois_leg(df_disc );//if endog we create a fwd_func and update surface

	if(endog_df)
		return;

	QL_REQUIRE(!null(f_fwd), "fwd_func_fwd is required for non self discounting ois");
		
	tenor_surface ts = create_tenor_surface_ois_leg(null, f_fwd, ee);
	add_surface_ois_leg(ts);*/
	
	/*add_disc_func_ois_leg(df_disc );
		
	if(!this.is_endog_df(ee)){

		QL_REQUIRE(!null(f_fwd), "f_fwd is required for non self discounting ois");

		if(this.is_approx_calc(ee)) {
			tenor_surface ts = create_tenor_surface_ois_leg(null, f_fwd, ee);//a disc_func will be created
			add_surface_ois_leg(ts);
		}
		else {
			//swap_gen.swap_add_fwd_func_leg2(f_fwd);
			..ir_index idx = ir_index(ee);
			logical allow_extrap = false;
			tenor_surface ts 	= tenor_surface(this.trade_date(), df_disc,[f_fwd],[idx],allow_extrap);
			add_surface_ois_leg(ts);
		}
	}*/
}
void swap_fltois.add_mtm_data(	number 	option(nullable) curr_notional_reset_leg,									
								number 	option(nullable)	fx_spot,  //leg1=price_ccy, leg2=flat=base_ccy
								string 	option(nullable)	fx_base_ccy,
								string 	option(nullable)	fx_price_ccy,
								//date option(nullable) fx_spot_date,
								disc_func	 option(nullable) df_leg1,
								disc_func	 option(nullable) df_leg2)  
{
	/*error_info ee = new error_info(true,true);

	if(!null(fx_spot)) {
		QL_REQUIRE(!null(fx_base_ccy),"fx_base_ccy required when fx_spot is input");
		QL_REQUIRE(!null(fx_price_ccy),"fx_price_ccy required when fx_spot is input");
		
		string ccy_leg1, ccy_leg2;		
		this.currency(ccy_leg1, ccy_leg2 ,ee);

		number fx_spot_leg1_is_base;
		if(equal_casei(fx_base_ccy, ccy_leg1)){
			QL_FAIL_COND(!equal_casei(fx_price_ccy, ccy_leg2),"invalid fx price currency" ,this,true );
			fx_spot_leg1_is_base = fx_spot;
		}
		else if(equal_casei(fx_base_ccy, ccy_leg2)){
			QL_FAIL_COND(!equal_casei(fx_price_ccy, ccy_leg1),"invalid fx price currency" ,this,true );
			fx_spot_leg1_is_base = 1.0/fx_spot;
		}
		else {
			QL_FAIL("invalid currency" ,this,true );		
		}
	}*/

	number fx_spot_leg1_is_base;
	swap_gen.mtm_helper(fx_spot, fx_base_ccy,fx_price_ccy,fx_spot_leg1_is_base);
	
	i().__swap_add_fltois_mtm_data(	curr_notional_reset_leg,fx_spot_leg1_is_base,df_leg1,df_leg2);

	return ;					
}
/*-----------------------------------------------------------------------
  add_curve_data_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fltois.add_curve_data_flt_leg( 	disc_func  		df_disc,
											tenor_surface  	ts )
{
	add_disc_func_flt_leg(df_disc);
	add_surface_flt_leg(ts);
}
/*-----------------------------------------------------------------------
  add_curve_data	EXT SWAP: ok  
  ----------------------------------------------------------------------*/
void swap_fltois.add_curve_data(disc_func  df_disc,
								tenor_surface  ts_flt,
								disc_func  option(nullable) df_disc_ois,
								disc_func 	option(nullable) df_fwd_ois,
								logical sync_endog_ok)
{
	add_curve_data_flt_leg( df_disc, ts_flt );
	
	if(!ccy_swap_) {
		add_curve_data_ois_leg(df_disc,df_fwd_ois,sync_endog_ok);
	}
	else {
		QL_REQUIRE(!null(df_disc_ois), "df_disc_ois required for cross currency swaps");
		add_curve_data_ois_leg(df_disc_ois,df_fwd_ois,sync_endog_ok);
	}
}
/*-----------------------------------------------------------------------
  add_curve_data	EXT SWAP: ok 
  ----------------------------------------------------------------------*/
void swap_fltois.add_curve_data(disc_func  df_disc,
								tenor_surface  ts_flt,
								disc_func  option(nullable)  df_disc_ois,
								fwd_func 	option(nullable) f_fwd_ois,
								logical sync_endog_ok)
{
	add_curve_data_flt_leg( df_disc, ts_flt );
	
	if(!ccy_swap_) {
		add_curve_data_ois_leg(df_disc,f_fwd_ois,sync_endog_ok);
	}
	else {
		QL_REQUIRE(!null(df_disc_ois), "df_disc_ois required for cross currency swaps");
		add_curve_data_ois_leg(df_disc_ois,f_fwd_ois,sync_endog_ok);
	}
}
/*-----------------------------------------------------------------------
  curve_state  <hidden>
  ----------------------------------------------------------------------*/
void swap_fltois.curve_state(out disc_func df_flt, out disc_func df_ois,  out tenor_surface ts_ois) option(hidden)
{
	error_info ee = new error_info(true,true);
	df_ois 	= this.disc_func_ois_leg(ee);
	df_flt 	= this.disc_func_flt_leg(ee);
	ts_ois	= this.tenor_surface_ois_leg(ee);//always null if approx AND endog_df
}
/*-----------------------------------------------------------------------
  add_curve_state <hidden>  here there is no checking of endog_df etc
  ----------------------------------------------------------------------*/
void swap_fltois.add_curve_state( disc_func option(nullable) df_flt,
								  disc_func option(nullable) df_ois,								  
								  tenor_surface option(nullable) ts_ois) option(hidden)
{
	error_info ee = new error_info(true,true);
	logical is_endog = this.is_endog_df(ee);
	logical is_approx = this.is_approx_calc(ee);

	
	if(is_endog && is_approx) {
		//i().__swap_add_fltois_ext_data(null,df_fix,null, null, df_ois, null, null<tenor_surface>,null, null, null, true,false);		
	}
	else  {//a surface 
		//i().__swap_add_fltois_ext_data(null,df_fix,null, null, df_ois, null, ts_ois, null, null, null, true,false);
	}
}

/*-----------------------------------------------------------------------
  add_fixing_flt_leg
  ----------------------------------------------------------------------*/
void swap_fltois.add_fixing_flt_leg(vector(date) fixing_dates,
									vector(number) fixings,
									logical option(nullable) fixing_as_fwd )
{			
	swap_gen.swap_add_fixing_leg1(fixing_dates,fixings,fixing_as_fwd);						
}
void swap_fltois.add_fixing_flt_leg(	number fixing_proxy,
									logical option(nullable) fixing_as_fwd ) 
{			
	swap_gen.swap_add_fixing_leg1(fixing_proxy, fixing_as_fwd);						
}
/*-----------------------------------------------------------------------
  add_fixing_ois_leg
  ----------------------------------------------------------------------*/
void swap_fltois.add_fixing_ois_leg(vector(date) fixing_dates,
									vector(number) fixings,
									logical option(nullable) fixing_as_fwd )
{			
	swap_gen.swap_add_fixing_leg2(fixing_dates,fixings,fixing_as_fwd);						
}

void swap_fltois.add_fixing_ois_leg(	number fixing_proxy,
									logical option(nullable) fixing_as_fwd ) 
{			
	swap_gen.swap_add_fixing_leg2(fixing_proxy, fixing_as_fwd);						
}
/*-----------------------------------------------------------------------
  create_tenor_surface_ois_leg	(fwd is a fwd_func)  EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_fltois.create_tenor_surface_ois_leg(disc_func option(nullable) fwddf,
													   fwd_func option(nullable) fwdf1d,
													   logical sync_endog_ok,
													   error_info option(nullable) error)
{
	return swap_gen.create_tenor_surface_ois_leg2(fwddf,fwdf1d,sync_endog_ok,error);	
}
/*-----------------------------------------------------------------------
  set_date 		EXT SWAP: ok
  ext_swap: if trade date is the same --> the settle date will be preserved (if not input)
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois.set_date(	date  					trade_date, 
									date  option(nullable)	settle_date,
									error_info option(nullable) error )
{
	
	instrument cc;
	if(ext_swap_){
		logical re_init = false; 
		logical init_quote = false;
		cc = instrument._set_date(trade_date,settle_date,re_init,init_quote,error);
	}
	else{
		QL_FAIL_COND(!null(settle_date),"input of settlement date only supported for non-db swaps" ,this,true );
		logical re_init = true; 
		logical init_quote = true;
		cc = instrument._set_date(trade_date,settle_date,re_init,init_quote,error);
	}

	if(null(cc))
		return null<swap_fltois>;

	swap_fltois sw = dynamic_cast<swap_fltois>(cc);
	sw.reset_mtm();
	return sw;
	
}

/*-----------------------------------------------------------------------
  set_date <protected>  EXT SWAP: ok	
	re_init for swaps means that updated disc_funcs, fixing data etc is not preserved
	ext_swap: if trade date is the same --> the settle date will be preserved (if not input)
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois.set_date(	date  				trade_date, 
									date  option(nullable)	settle_date,
									logical 			re_init, 
									logical 			re_init_quote, 
									error_info option(nullable) error)
{	
	QL_FAIL_COND(ext_swap_ && (re_init || re_init_quote),"re_init/re_init_quote flags = true not supported for non-db swaps" ,this,true );
	QL_FAIL_COND(!ext_swap_ && !null(settle_date),"input of settlement date only supported for non-db swaps" ,this,true );
	
	instrument cc = instrument._set_date(trade_date,settle_date,true,re_init_quote,error);
	if(null(cc))
		return null<swap_fltois>;

	swap_fltois sw = dynamic_cast<swap_fltois>(cc);
	sw.reset_mtm();
	return sw;
	
}
/*-----------------------------------------------------------------------
  set_date <protected/legacy>  EXT SWAP: ok
	re_init for swaps means that updated disc_funcs, fixing data etc is not preserved	
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois.set_date(	date  				trade_date, 
									logical 			re_init, 
									error_info option(nullable) error) 

{
	instrument cc;
	if(ext_swap_){
		QL_FAIL_COND(re_init,"re_init = true not supported for non-db swaps" ,this,true );
		logical init_quote = false;
		cc = instrument._set_date(trade_date,null<date>,re_init,init_quote,error);
	}
	else{
		logical init_quote = true;
		cc = instrument._set_date(trade_date,null<date>,re_init,init_quote,error);
	}
	
	if(null(cc))
		return null<swap_fltois>;

	swap_fltois sw = dynamic_cast<swap_fltois>(cc);
	sw.reset_mtm();
	return sw;
}

/*-----------------------------------------------------------------------
   move_date  <protected/legacy>  EXT SWAP: ok
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	ext_swap: if trade date is the same --> the settle date will be preserved (if not input)
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois.move_date(	date  				trade_date, 
									date option(nullable) settle_date,
									error_info option(nullable) error) 
{
	QL_FAIL_COND(!ext_swap_ && !null(settle_date),"input of settlement date only supported for non-db swaps" ,this,true );
	
	instrument cc = instrument._move_date(trade_date,settle_date,error);
	if(null(cc))
		return null<swap_fltois>;

	swap_fltois sw = dynamic_cast<swap_fltois>(cc);
	sw.reset_mtm();
	return sw;
}


/*-----------------------------------------------------------------------
  set_spread_ois_leg
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois.set_spread_ois_leg(number option(nullable) spread ,
										   error_info option(nullable) error)
{
	try{
		
		QL_REQUIRE(ext_swap_ ,"function only available for non-db swaps" ,this,true );
		
		__instrument  c = i().__swap_ext_set_spread_leg2(spread);

		instr_error e = new instr_error();
		instrument cc 	= this.create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid swap_fltois", this, e);
		
		if(!cc.is_valid(error)) 
			return null<swap_fltois>;	
				
		return dynamic_cast<swap_fltois>(cc);					
	}	
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.set_spread_ois_leg");
		return null<swap_fltois>;

	}
}
/*-----------------------------------------------------------------------
  set_spread_ois_leg
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois.set_spread_flt_leg(number option(nullable) spread ,
										   error_info option(nullable) error)
{
	try{
		
		QL_REQUIRE(ext_swap_ ,"function only available for non-db swaps" ,this,true );
		
		__instrument  c = i().__swap_ext_set_spread_leg1(spread);

		instr_error e = new instr_error();
		instrument cc 	= this.create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid swap_fltois", this, e);
		
		if(!cc.is_valid(error)) 
			return null<swap_fltois>;	
				
		return dynamic_cast<swap_fltois>(cc);					
	}	
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.set_spread_flt_leg");
		return null<swap_fltois>;

	}
}
/*-----------------------------------------------------------------------
  swap_fltois: set_quote   EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois.set_quote(	number 	option(nullable) quote,									
									error_info option(nullable) error)
{
	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, false,error);
	return null(cc) ? null<swap_fltois>: dynamic_cast<swap_fltois>(cc);
}

/*-----------------------------------------------------------------------
  swap_fltois: set_quote   EXT SWAP: will throw because of quote_side
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois.set_quote(	string 	option(nullable) quote_side,
									error_info option(nullable) error)
{
	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, false,error);
	return null(cc) ? null<swap_fltois>: dynamic_cast<swap_fltois>(cc);
}
/*-----------------------------------------------------------------------
  set_pay_leg   --> returns an external swap, a db swap cannot be changed in regards to pay vs receive 
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois.set_pay_leg(logical pay_float,							
									error_info option(nullable) error )
{
	try{

		//swap_gen.reset_mtm();
			
		__instrument  c = i().__swap_set_pay_leg1(pay_float );
		
		instr_error e = new instr_error();
		instrument cc 	= this.create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid swap_fltois", this, e);
		
		if(!cc.is_valid(error)) 
			return null<swap_fltois>;	
				
		return dynamic_cast<swap_fltois>(cc);					
	}	
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.set_pay_leg");
		return null<swap_fltois>;
	}
}

/*-----------------------------------------------------------------------
  is_mtm_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical  swap_fltois.is_mtm_flt_leg(error_info option(nullable) error) 
{	
	return swap_gen.is_mtm_leg1(error) ;
}
/*-----------------------------------------------------------------------
  is_mtm_ois_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical  swap_fltois.is_mtm_ois_leg(error_info option(nullable) error) 
{	
	return swap_gen.is_mtm_leg2(error) ;
}
/*-----------------------------------------------------------------------
  tenor_surface_flt_leg / tenor_surface_ois_leg
  ----------------------------------------------------------------------*/
tenor_surface swap_fltois.tenor_surface_flt_leg(error_info option(nullable) error ) 	{ return swap_gen.swap_tenor_surface_leg1(error);}
tenor_surface swap_fltois.tenor_surface_ois_leg(error_info option(nullable) error )  	{ return swap_gen.swap_tenor_surface_leg2(error);}

/*-----------------------------------------------------------------------
  swap_fltois: disc_func_flt_leg / disc_func_ois_leg
  ----------------------------------------------------------------------*/
disc_func swap_fltois.disc_func_flt_leg(error_info option(nullable) error) 	{ return swap_gen.swap_disc_func_leg1(error);}
disc_func swap_fltois.disc_func_ois_leg(error_info option(nullable) error) 	{ return swap_gen.swap_disc_func_leg2(error);}

/*-----------------------------------------------------------------------
  flat_leg_is_float_leg
  ----------------------------------------------------------------------*/
logical	swap_fltois.flat_leg_is_float_leg(error_info option(nullable) error  )
{	
	return !swap_gen.leg1_is_quote(error);
}
/*-----------------------------------------------------------------------
  flat_leg_is_ois_leg
  ----------------------------------------------------------------------*/
logical	swap_fltois.flat_leg_is_ois_leg(error_info option(nullable) error )
{	
	return swap_gen.leg1_is_quote(error);
}	
/*-----------------------------------------------------------------------
  swap_type
  ----------------------------------------------------------------------*/
instrument_type swap_fltois.swap_type(error_info option(nullable) error) 
{	
	return swap_gen.swap_type(error);
}

/*-----------------------------------------------------------------------
  solver
  ----------------------------------------------------------------------*/
number swap_fltois.solver(	number 				pv,
							swap_solver_code 	solver_code,
							logical option(nullable) trade_date_pv,
							error_info option(nullable) error)
{	
	return swap_gen.solver(pv,solver_code,trade_date_pv,error);
}

/*-----------------------------------------------------------------------
  swap_instrument
  ----------------------------------------------------------------------*/
ql_fixed_income_swap swap_fltois.swap_instrument(error_info option(nullable) error)
{
	return swap_gen.swap_instrument(error);

}
/*-----------------------------------------------------------------------
  index_tenor_code_leg1
  ----------------------------------------------------------------------*/
tenor_code swap_fltois.index_tenor_code_flt_leg(error_info option(nullable) error) 
{	
	return swap_gen.swap_index_tenor_code_leg1(error);
}
/*-----------------------------------------------------------------------
  current_fixing_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number	swap_fltois.current_fixing_flt_leg(out date reset_date,
										   out logical is_fixed,
										   error_info option(nullable) error)
{
	try{
		error_info ee = error_info(true,true);
		ql_float_leg flt = this.float_leg(false,ee);

		return flt.current_fixing_rate(reset_date,is_fixed);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.current_fixing_flt_leg");		
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  current_coupon_flt_leg	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
number  swap_fltois.current_coupon_flt_leg(error_info option(nullable) error ) 
{
	number  cpn_leg1 ,cpn_leg2;
	swap_gen.coupon(cpn_leg1 ,cpn_leg2,  error );
	return cpn_leg2;
}
/*-----------------------------------------------------------------------
  reset_freq_flt_leg	
  ----------------------------------------------------------------------*/
integer  swap_fltois.reset_freq_flt_leg(error_info option(nullable) error ) 
{
	integer c1,c2;
	swap_gen.reset_freq(c1,c2  ,error ) ;
	return c1;
}
/*-----------------------------------------------------------------------
  coupon_freq_flt_leg	
  ----------------------------------------------------------------------*/
integer  swap_fltois.coupon_freq_flt_leg(error_info option(nullable) error ) 
{
	integer c1,c2;
	swap_gen.coupon_freq(c1,c2  ,error ) ;
	return c2;
}

/*-----------------------------------------------------------------------
  ir_rule_sprd_leg
  ----------------------------------------------------------------------*/
interest_rule  swap_fltois.ir_rule_flt_leg(error_info option(nullable) error)
	{	
	interest_rule if1, if2;
	swap_gen.ir_rule(if1, if2,  error ) ;
	return if1;
}
/*-----------------------------------------------------------------------
  ir_rule_ois_leg
  ----------------------------------------------------------------------*/
interest_rule  swap_fltois.ir_rule_ois_leg(error_info option(nullable) error)
	{	
	interest_rule if1, if2;
	swap_gen.ir_rule(if1, if2,  error ) ;
	return if2;
}
/*-----------------------------------------------------------------------
  stub_fwd_style_flt_leg
  ----------------------------------------------------------------------*/
flt_stub_fwd_style  swap_fltois.stub_fwd_style_flt_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_stub_fwd_style_leg1(error) ;
}
/*-----------------------------------------------------------------------
  avg_method_ois_leg
  ----------------------------------------------------------------------*/
flt_avg_method  swap_fltois.avg_method_flt_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_avg_method_leg1(error) ;
}
/*-----------------------------------------------------------------------
  sprd_comp_method_ois_leg
  ----------------------------------------------------------------------*/
flt_sprd_comp_method  swap_fltois.sprd_comp_method_flt_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_sprd_comp_method_leg1(error) ;
}
/*-----------------------------------------------------------------------
  comp_avg_type_ois_leg
  ----------------------------------------------------------------------*/
flt_comp_avg_type  swap_fltois.comp_avg_type_flt_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_comp_avg_type_leg1(error) ;
}

/*-----------------------------------------------------------------------
  avg_method_ois_leg
  ----------------------------------------------------------------------*/
flt_avg_method  swap_fltois.avg_method_ois_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_avg_method_leg2(error) ;
}
/*-----------------------------------------------------------------------
  sprd_comp_method_ois_leg
  ----------------------------------------------------------------------*/
flt_sprd_comp_method  swap_fltois.sprd_comp_method_ois_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_sprd_comp_method_leg2(error) ;
}
/*-----------------------------------------------------------------------
  comp_avg_type_ois_leg
  ----------------------------------------------------------------------*/
flt_comp_avg_type  swap_fltois.comp_avg_type_ois_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_comp_avg_type_leg2(error) ;
}

/*-----------------------------------------------------------------------
  rfr_arrears_type_ois_leg
  ----------------------------------------------------------------------*/
rfr_arrears_type  swap_fltois.rfr_arrears_type_ois_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_rfr_arr_type_leg2(error) ;
}
/*-----------------------------------------------------------------------
  rfr_arrears_type_ois_leg
  ----------------------------------------------------------------------*/
integer  swap_fltois.rfr_arrears_days_ois_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_rfr_arr_days_leg2(error) ;
}
/*-----------------------------------------------------------------------
  coupon_freq   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.coupon_freq(	out integer  cpn_freq_flt_leg, 
								out integer  cpn_freq_ois_leg, 
								error_info option(nullable) error ) 
{
	swap_gen.coupon_freq(cpn_freq_flt_leg,cpn_freq_ois_leg,error);
	return;
}
/*-----------------------------------------------------------------------
  effective_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.effective_date(	out date  effective_date_flt_leg, 
									out date  effective_date_ois_leg, 
									error_info option(nullable) error) 
{
	swap_gen.effective_date(effective_date_flt_leg,effective_date_ois_leg,error);
	return;
}

/*-----------------------------------------------------------------------
  next_cpn_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.next_cpn_date(	out date  next_cpn_date_flt_leg, 
									out date  next_cpn_date_ois_leg, 
									error_info option(nullable) error) 
{
	swap_gen.next_cpn_date(next_cpn_date_flt_leg,next_cpn_date_ois_leg,error) ;
	return;
}
/*-----------------------------------------------------------------------
  previous_cpn_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.previous_cpn_date(out date  prev_cpn_date_flt_leg, 
									out date  prev_cpn_date_ois_leg, 
									error_info option(nullable) error) 
{
	swap_gen.previous_cpn_date(prev_cpn_date_flt_leg,prev_cpn_date_ois_leg,error) ;
	return;
}
/*-----------------------------------------------------------------------
  calendar_name   	
  ----------------------------------------------------------------------*/
void  swap_fltois.calendar_name(out string  cal_name_flt_leg, 
								out string  cal_name_ois_leg, 
								error_info option(nullable) error ) 
{	
	swap_gen.calendar_name(cal_name_flt_leg, cal_name_ois_leg,  error );
	return;
}

/*-----------------------------------------------------------------------
  pmt_lag   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.pmt_lag(	out	integer 	pmt_lag_flt_leg,
							out	integer 	mat_pmt_lag_flt_leg,
							out	integer 	pmt_lag_prin_flt_leg,
							out	integer 	mat_pmt_lag_prin_flt_leg,
							out	integer 	pmt_lag_ois_leg,
							out	integer 	mat_pmt_lag_ois_leg,
							out	integer 	pmt_lag_prin_ois_leg,
							out	integer 	mat_pmt_lag_prin_ois_leg,	
							error_info option(nullable) error) 
{
	swap_gen.swap_pmt_lag(	pmt_lag_flt_leg, mat_pmt_lag_flt_leg, pmt_lag_prin_flt_leg, mat_pmt_lag_prin_flt_leg,
								pmt_lag_ois_leg, mat_pmt_lag_ois_leg, pmt_lag_prin_ois_leg, mat_pmt_lag_prin_ois_leg,error);
	return;
}

/*-----------------------------------------------------------------------
  settle_code  EXT SWAP: ok
  ----------------------------------------------------------------------*/
string swap_fltois.settle_code(error_info option(nullable) error ) 
{	
	return swap_gen.settle_code(error);
}
/*-----------------------------------------------------------------------
  dc_method   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.dc_method(	out day_count_method  dc_method_flt_leg, 
								out day_count_method  dc_method_ois_leg, 
								error_info option(nullable) error ) 
{
	swap_gen.dc_method(dc_method_flt_leg,dc_method_ois_leg,error);
	return;

}
/*-----------------------------------------------------------------------
  pmt_bus_day 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.pmt_bus_day(	out bd_convention  pmt_bus_day_flt_leg, 
								out bd_convention  pmt_bus_day_ois_leg, 
								error_info option(nullable) error) 
{
	swap_gen.pmt_bus_day(pmt_bus_day_flt_leg, pmt_bus_day_ois_leg,  error ) ;
	return;
}
/*-----------------------------------------------------------------------
  eom	EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical swap_fltois.eom(error_info option(nullable) error) option(hidden)
{
	logical e1,e2;
	swap_gen.eom(e1,e2,  error ) ;
	return e1;		
}
/*-----------------------------------------------------------------------
  eom   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.eom(	out logical   eom_flt_leg, 
						out logical  eom_ois_leg, 
						error_info option(nullable) error) 
{
	swap_gen.eom(eom_flt_leg, eom_ois_leg,  error ) ;
	return;
	
}

/*-----------------------------------------------------------------------
  cal   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.calendar(	out ..calendar   cal_flt_leg, 
							out ..calendar  cal_ois_leg, 
							error_info option(nullable) error) 
{
	swap_gen.calendar(cal_flt_leg, cal_ois_leg,  error ) ;
	return;
}
/*-----------------------------------------------------------------------
  is_cross_currency
  ----------------------------------------------------------------------*/
logical	 swap_fltois.is_cross_currency(error_info option(nullable) error )
{
	try{
		QL_FAIL_COND(null(ccy_swap_),"init error");
		return ccy_swap_;	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.is_cross_currency");
		return null<logical>;
	}
}
/*-----------------------------------------------------------------------
  quote 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.quote(	out number  spread_flt_leg, 
							out number  spread_ois_leg, 
							error_info option(nullable) error ) 
{	
	swap_gen.quote(spread_flt_leg,  spread_ois_leg, error);
}
/*-----------------------------------------------------------------------
  quote   
  ----------------------------------------------------------------------*/
number  swap_fltois.quote(error_info option(nullable) error)
{	
	return swap_gen.quote(error);
}
/*-----------------------------------------------------------------------
  pay_fix  EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical	 swap_fltois.pay_float(error_info option(nullable) error )
{
	return swap_gen.swap_payleg1(error);
}
/*-----------------------------------------------------------------------
  start_date	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
date  swap_fltois.start_date(error_info option(nullable) error ) 
{
	return this.issue_date(error);
}
/*-----------------------------------------------------------------------
  notional	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.notional(	out number  notional_flt_leg, 
							out number  notional_ois_leg, 
							error_info option(nullable) error ) 
{	
	swap_gen.notional( notional_flt_leg,notional_ois_leg, error ) ;
	return;
}
/*-----------------------------------------------------------------------
  notional	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fltois.notional(error_info option(nullable) error ) 
{	
	return swap_gen.nominal(error);
}
/*-----------------------------------------------------------------------
  currency	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.currency(	out string  curr_flt_leg, 
							out string  curr_ois_leg, 
							error_info option(nullable) error) 
{	
	swap_gen.currency(curr_flt_leg,  curr_ois_leg,  error);
	return;
}
/*-----------------------------------------------------------------------
  currency(leg1- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
string  swap_fltois.currency(error_info option(nullable) error) option(hidden)
{
	string c1,  c2;
	swap_gen.currency(c1,  c2,  error);
	return c1;
	
}
/*-----------------------------------------------------------------------
  reset_freq   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.reset_freq(	out integer  reset_freq_flt_leg, 
								out integer  reset_freq_ois_leg, 
								error_info option(nullable) error) 
{	
	try{	
		error_info ee = error_info(true,true);
		ql_float_leg flt = this.float_leg(false,ee);
		QL_FAIL_COND(null(flt),"invalid swap_fltois", this, true);
			
		reset_freq_flt_leg = reset_freq_to_int(flt.float_def().reset_freq());
		reset_freq_ois_leg = 365;
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.reset_freq");		
		reset_freq_flt_leg = reset_freq_ois_leg = err_freq();
		return ;
	}
}

/*-----------------------------------------------------------------------
  swap_leg
  ----------------------------------------------------------------------*/
vector(ql_swap_leg) swap_fltois.legs(logical clone,error_info option(nullable) error)
{	
	return swap_gen.swap_leg(clone,error);
}

/*-----------------------------------------------------------------------
  float_leg
  ----------------------------------------------------------------------*/
ql_float_leg swap_fltois.float_leg(logical clone,error_info option(nullable) error)
{	
	vector(ql_float_leg) l = swap_gen.swap_float_leg(clone,error);
	return !null(l) ? l[0] : null<ql_float_leg>;
}

/*-----------------------------------------------------------------------
  ois_leg
  ----------------------------------------------------------------------*/
ql_ois_leg swap_fltois.ois_leg(logical clone,error_info option(nullable) error)
{	
	vector(ql_ois_leg) l = swap_gen.swap_ois_leg(clone,error);
	return !null(l) ? l[0] : null<ql_ois_leg>;
}
/*-----------------------------------------------------------------------
  get_legs	EXT SWAP: ok  prot
  ----------------------------------------------------------------------*/
void  swap_fltois.get_legs(	out ql_float_leg  leg1, 
							out ql_ois_leg  leg2) 
{	
	leg1 = float_leg(false);
	leg2 = ois_leg(false);
}
/*-----------------------------------------------------------------------
  swap_fltois: ir_index
  ----------------------------------------------------------------------*/
ir_index swap_fltois.ir_index_flt_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_ir_index_leg1(error);
}

/*-----------------------------------------------------------------------
  index_tenor_flat_leg
  ----------------------------------------------------------------------*/
string swap_fltois.index_tenor_flt_leg(error_info option(nullable) error) 
{	
	..ir_index ir = this.ir_index_flt_leg(error) ;
	if(error.is_error()) return null<string>;
	return ir.tenor();
}

/*-----------------------------------------------------------------------
  swap_fltois: ir_index
  ----------------------------------------------------------------------*/
ir_index swap_fltois.ir_index_ois_leg(error_info option(nullable) error)
{	
	return swap_gen.swap_ir_index_leg2(error);
}
/*-----------------------------------------------------------------------
  index_tenor_code_ois_leg		EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_code swap_fltois.index_tenor_code_ois_leg(error_info option(nullable) error ) 
{
	
	return swap_gen.swap_index_tenor_code_leg2(error);
}
/*-----------------------------------------------------------------------
  index_tenor_ois_leg		EXT SWAP: ok
  ----------------------------------------------------------------------*/
string swap_fltois.index_tenor_ois_leg(error_info option(nullable) error ) 
{
	
	return swap_gen.swap_index_tenor_leg2(error);
}
/*-----------------------------------------------------------------------
  current_fixings_ois_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fltois.current_fixings_ois_leg(	logical only_fixed,
											out vector(date) reset_dates,
											out vector(number) rates,
											out vector(logical) is_fixed,
											error_info option(nullable) error)
{
	try{
		error_info ee = error_info(true,true);
		ql_ois_leg ois = this.ois_leg(false,ee);
		ois.current_fixing_rates(only_fixed,reset_dates,rates,is_fixed);
		
		return ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.current_fixings_flt_leg");		
		return ;
	}
}
/*-----------------------------------------------------------------------
  index_dates_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.index_dates_flt_leg(	logical 			post_settle,
										out vector(date) 	index_start_dates,									
										out vector(date) 	index_end_dates,
										out vector(logical)  index_regular,
										error_info option(nullable) 		error ) 
{	
	try{
		
		instr_error_type t;
   		string 			s;
		logical  all_dates = false;
		i().__swap_index_dates(post_settle,index_start_dates,index_end_dates,index_regular, true,all_dates,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois.index_dates_flt_leg");
		if(e) {
			index_start_dates = index_end_dates = null<vector(date)>; 
			index_regular = null<vector(logical)>;
		}			
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.index_dates_flt_leg");
		index_start_dates = index_end_dates = null<vector(date)>; 
		index_regular = null<vector(logical)>; 
		return ;
	}
}
/*-----------------------------------------------------------------------
  index_dates_ois_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.index_dates_ois_leg(	logical 			post_settle,
										logical 			all_dates,
										out vector(date) 	index_start_dates,									
										out vector(date) 	index_end_dates,
										out vector(logical)  index_regular,
										error_info option(nullable) 		error ) 
{	
	try{
		
		instr_error_type t;
   		string 			s;	
		i().__swap_index_dates(post_settle,index_start_dates,index_end_dates,index_regular, false,all_dates,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois.index_dates_ois_leg");
		if(e) {
			index_start_dates = index_end_dates = null<vector(date)>; 
			index_regular = null<vector(logical)>;
		}			
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.index_dates_ois_leg");
		index_start_dates = index_end_dates = null<vector(date)>; 
		index_regular = null<vector(logical)>; 
		return ;
	}
}
/*-----------------------------------------------------------------------
  present_value_fee
  ----------------------------------------------------------------------*/
number swap_fltois.present_value_fee(disc_func option(nullable)	disc_func_flt_leg,
									disc_func option(nullable) 	disc_func_ois_leg,
									out number  				pv_fee_flt_leg,
									out number  				pv_fee_ois_leg,
									date option(nullable) 		pv_date,
									date option(nullable) 		settle_date,
									logical  					incl_issue_cf,
									logical  					incl_mat_cf,	
									error_info option(nullable) error )
{

	return swap_gen.present_value_fee(disc_func_flt_leg,disc_func_ois_leg,pv_fee_flt_leg,pv_fee_ois_leg,pv_date, settle_date ,incl_issue_cf,incl_mat_cf,error );
}
/*-----------------------------------------------------------------------
  present_value
  ----------------------------------------------------------------------*/
number swap_fltois.present_value(	disc_func option(nullable)disc_func_flt_leg,
									disc_func option(nullable) 	disc_func_ois_leg,
									out number pv_flt_leg,
									out number pv_ois_leg,
									number option(nullable) notional,
									logical option(nullable) 	trade_date_pv,																								
									error_info option(nullable) error)
{	
	return swap_gen.present_value(disc_func_flt_leg,disc_func_ois_leg,pv_flt_leg,pv_ois_leg,notional,trade_date_pv,error);
}

number swap_fltois.present_value(	disc_func option(nullable)	disc_func_flt_leg,
									disc_func option(nullable) 	disc_func_ois_leg,
									out number pv_flt_leg,
									out number pv_ois_leg,
									date option(nullable) pv_date,
									date option(nullable) settle_date,
									logical  	incl_issue_cf,
									logical  	incl_mat_cf,	
									error_info option(nullable) error)
{	
	return swap_gen.present_value(disc_func_flt_leg,disc_func_ois_leg,pv_flt_leg,pv_ois_leg,pv_date, settle_date ,incl_issue_cf,incl_mat_cf,error );
}

number swap_fltois.present_value(	out number pv_flt_leg,
									out number pv_ois_leg,
									logical option(nullable) 	trade_date_pv,
									error_info option(nullable) error)
{	
	return swap_gen.present_value(pv_flt_leg,pv_ois_leg,trade_date_pv ,error );
}

/*-----------------------------------------------------------------------
  accrued	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fltois.accrued(logical 					in_pcnt,
							out number  accr_flt_leg,									
							out number  accr_ois_leg,
							error_info option(nullable) error ) 
option(com_name: 'accrued_ext')
{	
	return swap_gen.accrued(in_pcnt, accr_flt_leg, accr_ois_leg, error ) ;
}

/*-----------------------------------------------------------------------
  accrued_period  EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fltois.accrued_period(	out number  period_flt_leg,
									out number  period_ois_leg,
									out integer 				n_days_flt_leg,
									out integer 				n_days_ois_leg,
									error_info option(nullable) error ) 
{	
	swap_gen.accrued_period(period_flt_leg,period_ois_leg,n_days_flt_leg,n_days_ois_leg, error ) ;
	return;
}
/*-----------------------------------------------------------------------
  cash_flow_dates	EXT SWAP: ok   <PUBLIC>   interest payment dates, not principal pmt dates
  ----------------------------------------------------------------------*/
void  swap_fltois.cash_flow_dates(	logical 			post_settle, 
									out vector(date) 	pmt_dates_flt_leg,									
									out vector(date) 	pmt_dates_ois_leg,
									error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_ir_pmt_dates(post_settle,pmt_dates_flt_leg,pmt_dates_ois_leg, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois.cash_flow_dates");
		if(e) {
			pmt_dates_flt_leg = pmt_dates_ois_leg = null<vector(date)>;  
		}
		return;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.cash_flow_dates");		
		pmt_dates_flt_leg = pmt_dates_ois_leg = null<vector(date)>; 
		return ;
	}
}
/*-----------------------------------------------------------------------
  prin_cash_flow_dates	EXT SWAP: ok   <PUBLIC>   
  ----------------------------------------------------------------------*/
void  swap_fltois.prin_cash_flow_dates(	logical 			post_settle, 
										out vector(date) 	pmt_dates_flt_leg,									
										out vector(date) 	pmt_dates_ois_leg,
										error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_prin_pmt_dates(post_settle,pmt_dates_flt_leg,pmt_dates_ois_leg, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois.prin_cash_flow_dates");
		if(e) {
			pmt_dates_flt_leg = pmt_dates_ois_leg = null<vector(date)>;  
		}
		return;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.prin_cash_flow_dates");		
		pmt_dates_flt_leg = pmt_dates_ois_leg = null<vector(date)>; 
		return ;
	}
}

/*-----------------------------------------------------------------------
  accr_dates_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.accr_dates_flt_leg(logical 		post_settle, 
									out vector(date) 	accr_start_date,									
									out vector(date) 	accr_end_date,
									out vector(number)  accr_period,
									error_info option(nullable) 		error ) 
{	
	vector(date) accr_start_date_leg2;
	vector(date) accr_end_date_leg2;
	vector(number) accr_period_leg2;
	swap_gen.accr_dates(post_settle,
						accr_start_date,accr_end_date,accr_period,
						accr_start_date_leg2,accr_end_date_leg2,accr_period_leg2,
						error ) ;
	return;
}
/*-----------------------------------------------------------------------
  accr_dates_ois_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.accr_dates_ois_leg(	logical 			post_settle, 
										out vector(date) 	accr_start_date,									
										out vector(date) 	accr_end_date,
										out vector(number)  accr_period,
										error_info option(nullable) error ) 
{	
	vector(date) accr_start_date_leg1;
	vector(date) accr_end_date_leg1;
	vector(number) accr_period_leg1;
	swap_gen.accr_dates(post_settle,
						accr_start_date_leg1,accr_end_date_leg1,accr_period_leg1,
						accr_start_date,accr_end_date,accr_period,
						error ) ;
	return;
}
/*-----------------------------------------------------------------------
  fixing_data_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.fixing_data_flt_leg(	logical 					post_trade_date,
										logical option(nullable)	only_fixed, 
										out vector(date) 			reset_date,									
										out vector(number)  		rate,
										out vector(logical)  		is_fixed,
										error_info option(nullable) error ) 
{	
	try{
		error_info ee = error_info(true,true);
		ql_float_leg flt = this.float_leg(false,ee);
		
		date cut_off = post_trade_date ? this.trade_date(): null<date>;
		flt.fixing_data(only_fixed,reset_date,rate,is_fixed,cut_off);

		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.fixing_data_flt_leg");
		reset_date = null<vector(date)>; 
		rate = null<vector(number)>; 
		is_fixed = null<vector(logical)>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  fixing_data_ois_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.fixing_data_ois_leg(	logical 					post_trade_date,
										logical option(nullable)	only_fixed, 
										out vector(date)  			reset_date,									
										out vector(number)  		rate,
										out vector(logical)  		is_fixed,
										error_info option(nullable) 		error ) 
{	
	try{
		error_info ee = error_info(true,true);
		ql_ois_leg ois = this.ois_leg(false,ee);
		
		date cut_off = post_trade_date ? this.trade_date(): null<date>;
		ois.fixing_data(only_fixed,reset_date,rate,is_fixed,cut_off);

		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.fixing_data_flt_leg");
		reset_date = null<vector(date)>; 
		rate = null<vector(number)>; 
		is_fixed = null<vector(logical)>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  is_endog_df	EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical  swap_fltois.is_endog_df(error_info option(nullable) error ) 
{	
	try{
		
		error_info ee = error_info(true,true);		
		ql_ois_leg ois = this.ois_leg(false,ee);
		return ois.is_endog_df();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.is_endog_df");
		return null<logical >;
	}
}

/*-----------------------------------------------------------------------
  is_approx_calc	EXT SWAP: ok 
  ----------------------------------------------------------------------*/
logical  swap_fltois.is_approx_calc(error_info option(nullable) error ) 
{	
	try{
		
		error_info ee = error_info(true,true);		
		ql_ois_leg ois = this.ois_leg(false,ee);
		return ois.approx_calc();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.is_approx_calc");
		return null<logical >;
	}
}
/*-----------------------------------------------------------------------
  reset_freq_ois_leg	
  ----------------------------------------------------------------------*/
integer  swap_fltois.reset_freq_ois_leg(error_info option(nullable) error ) 
{
	return 365;
}
/*-----------------------------------------------------------------------
  currency_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
string swap_fltois.currency_flt_leg( error_info option(nullable) error ) 
{
	string c,  curr_flt_leg;
	swap_gen.currency(curr_flt_leg,  c,  error);
	return curr_flt_leg;

}
/*-----------------------------------------------------------------------
  currency_ois_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
string swap_fltois.currency_ois_leg( error_info option(nullable) error ) 
{
	string c,  curr_ois_leg;
	swap_gen.currency(c,  curr_ois_leg,  error);
	return curr_ois_leg;

}
/*-----------------------------------------------------------------------
  dc_method   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
day_count_method  swap_fltois.dc_method_flt_leg( error_info option(nullable) error ) 
{
	day_count_method d,dc_method_flt_leg;
	swap_gen.dc_method(dc_method_flt_leg,d,error);
	return dc_method_flt_leg;
}
/*-----------------------------------------------------------------------
  dc_method   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
day_count_method  swap_fltois.dc_method_ois_leg( error_info option(nullable) error ) 
{
	day_count_method d,dc_method_ois_leg;
	swap_gen.dc_method(d,dc_method_ois_leg,error);
	return dc_method_ois_leg;
}
/*-----------------------------------------------------------------------
  imp_spread_flt_leg    EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fltois.imp_spread_flt_leg(	number 						swap_pv,							
										logical option(nullable) 	trade_date_pv,
										error_info option(nullable) error ) 
{	
	try{
		
		instr_error_type t;
   		string 			s;	
		number c = i().__swap_imp_flt_sprd(swap_pv,trade_date_pv,false,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois.imp_spread_flt_leg");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.imp_spread_flt_leg");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  imp_spread_flt_leg    EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fltois.imp_spread_ois_leg(	number 						swap_pv,							
										logical option(nullable) 	trade_date_pv,
										error_info option(nullable) error ) 
{	
	try{
		
		instr_error_type t;
   		string 			s;	
		number c = i().__swap_imp_ois_sprd(swap_pv,trade_date_pv,false,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois.imp_spread_ois_leg");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.imp_spread_ois_leg");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  spread_ois_leg 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fltois.spread_ois_leg(error_info option(nullable) error ) 
{	
	try{
		
		instr_error_type t;
   		string 			s;
		number q,quote_ois_leg;
		i().__swap_def_quote(q,quote_ois_leg,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois.spread_ois_leg");
		if( e) {
			return null<number> ;
		}
		
		..quote_style qs = i().__swap_quote_style_e_leg2(t,s);
		e = CORE_INT.add_error_info(error,t,s, "swap_fltois.spread_ois_leg");
		if(e)
			return null<number>;
		
		switch(qs) {
			case ..quote_style.SPREAD:
				return quote_ois_leg;
			case ..quote_style.SPREAD_BP:					
			default:
				return quote_ois_leg/10000;
		}
							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.spread_ois_leg");
		return null<number> ;
	}
}
/*-----------------------------------------------------------------------
  spread_flt_leg 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fltois.spread_flt_leg(error_info option(nullable) error ) 
{
	try{
		
		instr_error_type t;
   		string 			s;
		number q,quote_flt_leg;
		i().__swap_def_quote(quote_flt_leg,q,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois.spread_flt_leg");
		if( e) {
			return null<number> ;
		}
		
		..quote_style qs = i().__swap_quote_style_e_leg1(t,s);
		e = CORE_INT.add_error_info(error,t,s, "swap_fltois.spread_flt_leg");
		if(e)
			return null<number>;
		
		switch(qs) {
			case ..quote_style.SPREAD:
				return quote_flt_leg;
			case ..quote_style.SPREAD_BP:					
			default:
				return quote_flt_leg/10000;
		}
							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.spread_flt_leg");
		return null<number> ;
	}
}


/*-----------------------------------------------------------------------
  fwd_func_ois_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
fwd_func swap_fltois.fwd_func_ois_leg(error_info option(nullable) error )
{
	try{
				
		error_info ee 	= new error_info(true,true);
		ql_ois_leg l = this.ois_leg(false,ee);
		return l.fwd_func();
		}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.fwd_func_ois_leg");
		return null<fwd_func>;
	}
}


/*-----------------------------------------------------------------------
  cash_flows_cpn	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.cash_flows_cpn(	logical 			post_settle, 
									out vector(number) 	cpn_cf_flt_leg,									
									out vector(number) 	cpn_cf_ois_leg,
									error_info option(nullable) error ) 
{	
	swap_gen.cash_flows_cpn(	post_settle, cpn_cf_flt_leg,cpn_cf_ois_leg,error );
	return;
}

/*-----------------------------------------------------------------------
  cash_flows	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.cash_flows(	logical 			post_settle, 
								out vector(number) 	cf_flt_leg,									
								out vector(number) 	cf_ois_leg,
								error_info option(nullable) error ) 
{	
	swap_gen.cash_flows(post_settle, cf_flt_leg,cf_ois_leg,error ) ;
	return;
}
/*-----------------------------------------------------------------------
  cash_flow_data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.cash_flow_data(	logical 			post_settle,
									ir_cf_code 			cf_code, 
									out vector(date) 	pmt_dates_flt_leg,									
									out vector(number)  cf_flt_leg,
									out vector(date) 	pmt_dates_ois_leg,									
									out vector(number) 	cf_ois_leg,
									error_info option(nullable) 		error ) 
{	
	swap_gen.cash_flow_data(	post_settle,cf_code, pmt_dates_flt_leg,cf_flt_leg,pmt_dates_ois_leg,cf_ois_leg, error );
	return;
}

/*-----------------------------------------------------------------------
  cash_flow_data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.cash_flow_data(logical 			post_settle,
								logical option(nullable) trade_date_pv,
								out vector(date)  	pmt_date_flt_leg,
								out vector(number)  cpn_rate_flt_leg,
								out vector(number)  cpn_cashflow_flt_leg,
								out vector(number)  pv_cpn_cashflow_flt_leg,
								out vector(number)  fee_flt_leg,
								out vector(number)  pv_fee_flt_leg,
								out vector(number)  notional_flt_leg,
								out vector(date)  	pmt_date_ois_leg,
								out vector(number)  cpn_rate_ois_leg,
								out vector(number)  cpn_cashflow_ois_leg,
								out vector(number)  pv_cpn_cashflow_ois_leg,
								out vector(number)  fee_ois_leg,
								out vector(number)  pv_fee_ois_leg,
								out vector(number)  notional_ois_leg,
								error_info option(nullable) 		error ) 
{	
	swap_gen.cash_flow_data(	post_settle,trade_date_pv,pmt_date_flt_leg,cpn_rate_flt_leg,cpn_cashflow_flt_leg,pv_cpn_cashflow_flt_leg,
					fee_flt_leg,pv_fee_flt_leg,notional_flt_leg,pmt_date_ois_leg,cpn_rate_ois_leg,cpn_cashflow_ois_leg,
					pv_cpn_cashflow_ois_leg,fee_ois_leg,pv_fee_ois_leg,notional_ois_leg, error );
}

/*-----------------------------------------------------------------------
  create_tenor_surface_flt_leg	(fwd is a fwd_func)  EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_fltois.create_tenor_surface_flt_leg(disc_func df,
													   fwd_func fwdf,
													   error_info option(nullable) error)
{
	try{
		
		error_info ee 			= error_info(true,true);
		..ir_index ir			= this.ir_index_flt_leg(ee);
		CORE_INT.instr_fail_check(null(ir), "invalid ir_index", this, ee);
		
		//integer tenor_m			= integer(ir.tenor_months());	
		logical allow_extrap 	= false;		
		return tenor_surface(this.trade_date(), df,[fwdf],[ir],allow_extrap);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.create_tenor_surface_flt_leg");
		return null<tenor_surface>;
	}
}


/*-----------------------------------------------------------------------
  data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.data(	out swap_flt_leg_data 	float_leg_data,
						out swap_ois_leg_data	ois_leg_data,
						error_info option(nullable) error )
{
	try{
		error_info ee = new error_info(true,true);
		vector(ql_swap_leg) l = legs(false,ee);
		float_leg_data = new swap_flt_leg_data(l[0],true);
		ois_leg_data = new swap_ois_leg_data(l[1],true);
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.data");
		float_leg_data = null<swap_flt_leg_data>;
		ois_leg_data = null<swap_ois_leg_data>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.data(out swap_ois_leg_data ois_leg_data,
						error_info option(nullable) error )
{
	try{
		error_info ee = new error_info(true,true);
		vector(ql_swap_leg) l = legs(false,ee);
		ois_leg_data = new swap_ois_leg_data(l[1],true);
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.data");
		ois_leg_data = null<swap_ois_leg_data>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.data(out swap_flt_leg_data	float_leg_data,
						error_info option(nullable) error )
{
	try{
		error_info ee = new error_info(true,true);
		vector(ql_swap_leg) l = legs(false,ee);
		float_leg_data = new swap_flt_leg_data(l[0],true);
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.data");
		float_leg_data = null<swap_flt_leg_data>;
		return ;
	}
}


/*-----------------------------------------------------------------------
  set_quote_from_yield 
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois.set_quote_from_yield(	number 	option(nullable) yield,
											error_info option(nullable) error) 
{
	QL_FAIL("not applicable for swap_fltois" ,this,true );
}

/*-----------------------------------------------------------------------
  pv01_spread	EXT SWAP: ok  - always returns a positive number regardless of pay/receive and sign of notional
  Note: not a "true" measure of risk, does not take into account if the swap has a pv <> 0
   PV01 refers to present value of 1 basis point spread and it's the discounted value of the cashflows
  for a float rate of 0.01% 
  ----------------------------------------------------------------------*/
number  swap_fltois.pv01_spread_ois_leg(number option(nullable) notional,
									number option(nullable) delta,
									//logical option(nullable) trade_date_pv,
									disc_func option(nullable) df,
									error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	

		error_info ee 		= new error_info(true,true);
		disc_func df_orig 	= this.disc_func_ois_leg(ee);
		logical upd 		= false;
		
		if(!null(df)){
			tenor_surface ts;
			this.add_disc_func_ois_leg(df,false,ts);
			upd = true;
		}
		else if(null(df_orig)) {	
			QL_FAIL("discount function not set",this,true);
		}
		
		number c = i().__swap_pvbp_ois_leg(notional,delta, false,t, s);
		if(!null(c))
			c = abs(c);
		
		if(upd && !null(df_orig)){
			tenor_surface ts;
			this.add_disc_func_ois_leg(df_orig,false,ts);
		}

		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois.pv01_spread_ois_leg");	
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.pv01_spread_ois_leg");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  pv01_spread	EXT SWAP: ok  - always returns a positive number regardless of pay/receive and sign of notional
  Note: not a "true" measure of risk, does not take into account if the swap has a pv <> 0
   PV01 refers to present value of 1 basis point spread and it's the discounted value of the cashflows
  for a float rate of 0.01% 
  ----------------------------------------------------------------------*/
number  swap_fltois.pv01_spread_flt_leg(number option(nullable) notional,
										number option(nullable) delta,
										//logical option(nullable) trade_date_pv,
										disc_func option(nullable) df,
										error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	

		error_info ee 		= new error_info(true,true);
		disc_func df_orig 	= this.disc_func_flt_leg(ee);
		logical upd 		= false;
		
		if(!null(df)){
			this.add_disc_func_flt_leg(df);
			upd = true;
		}
		else if(null(df_orig)) {	
			QL_FAIL("discount function not set",this,true);
		}
		
		number c = i().__swap_pvbp_float_leg(notional,delta, false,t, s);
		if(!null(c))
			c = abs(c);
		
		if(upd && !null(df_orig))
			this.add_disc_func_flt_leg(df_orig);		

		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois.pv01_spread_flt_leg");	
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois.pv01_spread_flt_leg");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  payment_data_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.payment_data_flt_leg( logical 				post_settle,
									logical option(nullable) trade_date_pv,
									out vector(date)  		fixing_date,
									out vector(number)  	fixing_rate,
									out vector(logical)  	is_fixed,									
									out vector(date)  		pmt_date,
									out vector(number) 		cpn_rate,
									out vector(number)  	cpn_cashflow,
									out vector(number)  	pv_cpn_cashflow,
									out vector(number)  	fee,
									out vector(number)  	pv_fee,
									out vector(number)  	notional ,
									error_info option(nullable)  error ) 
{	
	swap_gen.payment_data_flt_leg(true, post_settle, trade_date_pv, fixing_date, fixing_rate,
						  is_fixed,pmt_date,cpn_rate,cpn_cashflow,pv_cpn_cashflow,
						  fee,pv_fee, notional, error);
						
							
	
}

/*-----------------------------------------------------------------------
  principal_data_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.principal_data_flt_leg( 	logical 				post_settle,
											logical option(nullable) trade_date_pv,
											logical 				only_real_cf,
											out vector(date) 		prin_date,
											out vector(number) 		prin_cf,	
											out vector(number) 		pv_prin_cf,
											error_info option(nullable)  error )
{
	swap_gen.principal_data_flt_leg(true, post_settle, trade_date_pv, only_real_cf,
									prin_date,prin_cf,pv_prin_cf,error);
}
/*-----------------------------------------------------------------------
  payment_data_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.payment_data_ois_leg( logical 				post_settle,
									logical option(nullable) trade_date_pv,
									out vector(date)  		fixing_date,
									out vector(number)  	fixing_rate,
									out vector(logical)  	is_fixed,									
									out vector(date)  		pmt_date,
									out vector(number) 		cpn_rate,
									out vector(number)  	cpn_cashflow,
									out vector(number)  	pv_cpn_cashflow,
									out vector(number)  	fee,
									out vector(number)  	pv_fee,
									out vector(number)  	notional ,
									error_info option(nullable)  error ) 
{	
	swap_gen.payment_data_ois_leg(true, post_settle, trade_date_pv, fixing_date, fixing_rate,
						  is_fixed,pmt_date,cpn_rate,cpn_cashflow,pv_cpn_cashflow,
						  fee,pv_fee, notional, error);
						
							
	
}

/*-----------------------------------------------------------------------
  principal_data_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.principal_data_ois_leg( logical 				post_settle,
										logical option(nullable) trade_date_pv,
										logical 				only_real_cf,
										out vector(date) 		prin_date,
										out vector(number) 		prin_cf,	
										out vector(number) 		pv_prin_cf,
										error_info option(nullable)  error )
{
	swap_gen.principal_data_ois_leg(true, post_settle, trade_date_pv, only_real_cf,
									prin_date,prin_cf,pv_prin_cf,error);
}

/*-----------------------------------------------------------------------
  final_pmt_date	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois.final_pmt_date(out date 	final_pmt_date_flt_leg,									
								out date 	final_pmt_date_ois_leg,
								error_info option(nullable) error ) 
{	
	swap_gen.final_pmt_date( final_pmt_date_flt_leg, final_pmt_date_ois_leg, error ) ;
}
