option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	-------------------------------------------------------------------- 
	swap_fltois2s,  WORK IN PROGRESS
	--------------------------------------------------------------------
*/
//----------------------------------------------------------------------
//  class swap_fltois2s
//----------------------------------------------------------------------
class swap_fltois2s: public swap_gen
option(category: "Instrument/Interest Rate Swap/Float vs ONIndex (2-swap)")
//option(allow_undeclared_mfuncs)
{
public:
    
	override instrument 	inst();
	override swap_fltois2s 	clone();
	
	override void           __dbg_print(__dbg_label);
    override void          __dbg_browse(__dbg_split);
	/*swap_fltflt 			swap_fltflt(error_info option(nullable) error = null<error_info>);*/
	void					swaps(	logical option(nullable) ,out swap_fixflt ,out swap_fixois ,
									error_info option(nullable) error = null<error_info> );

	//-----external swap specific-----
	override ql_fixed_income_swap 	swap_instrument(error_info option(nullable) error = null<error_info>) ;
	ql_fixed_income_swap 			swap_instrument_1(logical,error_info option(nullable) error = null<error_info>) ;
	ql_fixed_income_swap 			swap_instrument_2(logical,error_info option(nullable) error = null<error_info>) ;
	override instrument_type 		swap_type( error_info option(nullable) error = null<error_info> );

	logical				flat_leg_is_float_leg(error_info option(nullable) error = null<error_info> );
	logical				flat_leg_is_ois_leg(error_info option(nullable) error = null<error_info> );
	//--
	
	override number 	nominal(error_info option(nullable) error = null<error_info> );					/*hidden, visible in root*/
	override string 	currency(error_info option(nullable) error = null<error_info> );				/*hidden, visible in root*/
	override string 	calendar_name(error_info option(nullable) error = null<error_info> );			/*hidden, visible in root*/
	override string 	calendar_name(integer, error_info option(nullable) error = null<error_info> );	/*hidden, visible in root*/
	override calendar 	calendar(error_info option(nullable) error = null<error_info>  );				/*hidden, visible in root*/
	override calendar 	calendar(integer ,error_info option(nullable) error = null<error_info>  );		/*hidden, visible in root*/
	override logical 	eom(error_info option(nullable) error = null<error_info>);						/*hidden, visible in root*/
	override integer 	coupon_freq(error_info option(nullable) error = null<error_info> );				/*hidden, visible in root*/
	override day_count_method 	dc_method(error_info option(nullable) error = null<error_info> );		/*hidden, visible in root*/
	override bd_convention pmt_bus_day(error_info option(nullable) error = null<error_info> );			/*hidden, not visible in root*/
	override date 		issue_date(error_info option(nullable) error = null<error_info> ); 				/*hidden, visible in root*/	
	override string 	settle_code(error_info option(nullable) error = null<error_info>);				/*hidden, visible in root*/
	
	//--
	tenor_surface 			create_tenor_surface_flt_leg(disc_func ,fwd_func,error_info option(nullable) error = null<error_info> );
	tenor_surface 			create_tenor_surface_ois_leg(disc_func option(nullable),fwd_func option(nullable),logical,error_info option(nullable) error = null<error_info> );
	
	logical  				is_approx_calc_ois_leg(error_info option(nullable) error = null<error_info>) ;
	logical  				is_endog_df_ois_leg(error_info option(nullable) error = null<error_info>);
	logical					is_cross_currency(error_info option(nullable) error = null<error_info>);
	ir_index 				ir_index_ois_leg( error_info option(nullable) error = null<error_info> ); 
	ir_index 				ir_index_flt_leg( error_info option(nullable) error = null<error_info> ); 
	string 					index_tenor_ois_leg(error_info option(nullable) error = null<error_info>) ;
	string 					index_tenor_flt_leg(error_info option(nullable) error = null<error_info>) ;
	tenor_code 				index_tenor_code_ois_leg(error_info option(nullable) error = null<error_info>) ;
	tenor_code				index_tenor_code_flt_leg(error_info option(nullable) error = null<error_info>) ;
	//
	integer 				coupon_freq_fix_flt_leg( error_info option(nullable) error = null<error_info> );
	integer 				coupon_freq_fix_ois_leg( error_info option(nullable) error = null<error_info> ); 
	integer 				coupon_freq_ois_leg( error_info option(nullable) error = null<error_info> ); 
	integer 				coupon_freq_flt_leg( error_info option(nullable) error = null<error_info> );
	
	integer 				reset_freq_ois_leg( error_info option(nullable) error = null<error_info> ); 
	integer 				reset_freq_flt_leg( error_info option(nullable) error = null<error_info> ); 
	integer 				roll_day_ois_leg( error_info option(nullable) error = null<error_info> ); 
	integer 				roll_day_flt_leg( error_info option(nullable) error = null<error_info> ); 
	//
	day_count_method		dc_method_fix_flt_leg( error_info option(nullable) error = null<error_info> );
	day_count_method		dc_method_fix_ois_leg( error_info option(nullable) error = null<error_info> ); 
	day_count_method		dc_method_ois_leg( error_info option(nullable) error = null<error_info> ); 
	day_count_method		dc_method_flt_leg( error_info option(nullable) error = null<error_info> ); 
	//
	interest_rule			ir_rule_fix_flt_leg( error_info option(nullable) error = null<error_info> );
	interest_rule			ir_rule_fix_ois_leg( error_info option(nullable) error = null<error_info> ); 
	interest_rule			ir_rule_ois_leg( error_info option(nullable) error = null<error_info> ); 
	interest_rule			ir_rule_flt_leg( error_info option(nullable) error = null<error_info> );
	//

	bd_convention			pmt_bus_day_fix_flt_leg( error_info option(nullable) error = null<error_info> );
	bd_convention			pmt_bus_day_fix_ois_leg( error_info option(nullable) error = null<error_info> ); 
	bd_convention			pmt_bus_day_ois_leg( error_info option(nullable) error = null<error_info> ); 
	bd_convention			pmt_bus_day_flt_leg( error_info option(nullable) error = null<error_info> ); 
	//
	logical					eom_fix_flt_leg( error_info option(nullable) error = null<error_info> );
	logical					eom_fix_ois_leg( error_info option(nullable) error = null<error_info> ); 
	logical					eom_ois_leg( error_info option(nullable) error = null<error_info> ); 
	logical					eom_flt_leg( error_info option(nullable) error = null<error_info> ); 
	//
	calendar				calendar_fix_flt_leg( error_info option(nullable) error = null<error_info> );
	calendar				calendar_fix_ois_leg( error_info option(nullable) error = null<error_info> ); 
	calendar				calendar_ois_leg( error_info option(nullable) error = null<error_info> ); 
	calendar				calendar_flt_leg( error_info option(nullable) error = null<error_info> ); 
	//
	override void 			quote(out number ,out number , error_info option(nullable) error = null<error_info>) ;
	override number			quote(error_info option(nullable) error = null<error_info>);
	
	number  				present_value(	..disc_func option(nullable), out number ,
											out number ,number option(nullable) = null<number>, logical option(nullable) trade_date_pv = false,		
											error_info option(nullable) error = null<error_info> );
	
	number  				present_value(	..disc_func option(nullable),out number ,
											out number,date option(nullable) ,date option(nullable) ,
											logical,logical  ,error_info option(nullable) error = null<error_info> );
	
	override number  		present_value(	out number ,out number ,
											logical option(nullable) ,error_info option(nullable) error = null<error_info>   );
	//
	logical 				normalize(disc_func option(nullable), error_info option(nullable) error = null<error_info> ) ;
	number 					implied_spread( error_info option(nullable) error = null<error_info>);

	void 		add_quote(number,..quote_style );
	override void add_quote(number);
	void 		add_notional(number );
	void 		add_disc_func(disc_func,logical ,out tenor_surface  ); 
	void 		add_surface_ois_leg(tenor_surface option(nullable));
	void 		add_surface_flt_leg(tenor_surface option(nullable));
	void		add_fixing_ois_leg(vector(date) ,vector(number) ,logical option(nullable) fixing_as_fwd = false);
	void		add_fixing_flt_leg(vector(date) ,vector(number) ,logical option(nullable) fixing_as_fwd = false);
	void		add_fixing_ois_leg(number ,logical option(nullable) fixing_as_fwd = false);
	void		add_fixing_flt_leg(number ,logical option(nullable) fixing_as_fwd = false);
	//void 		add_data( 	number,disc_func,tenor_surface ,vector(date),vector(number) ,
	//						tenor_surface ,vector(date),vector(number) ,logical option(nullable) fixing_as_fwd = false,							
	//						 logical upd_null_crv = false,logical upd_null_fix = false);
	//
	disc_func 	disc_func(error_info option(nullable) error = null<error_info> ) ;
	//disc_func 	disc_func_flt_leg(error_info option(nullable) error = null<error_info> ) ;
	number		solver(number,swap_solver_code ,logical,logical option(nullable) trade_date_pv ,
						error_info option(nullable) error = null<error_info> );
	//
	
	/*---set functions-required--*/
	override swap_fltois2s	set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);
	override swap_fltois2s	set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);

	swap_fltois2s(__instrument);	
	swap_fltois2s(swap_fltois2s);

protected:
	
	override swap_fltois2s		create(__instrument option(nullable),out instr_error option(nullable) ,
									   error_type type = E_INVALID_ARG); 
					
	override swap_fltois2s		set_date(date,date option(nullable) s=null<date> ,logical r = true,logical rq = true ,
										 error_info option(nullable) error = null<error_info> );	
	override swap_fltois2s		set_date(date,logical ,error_info option(nullable) error = null<error_info>);			/*legacy*/
	override swap_fltois2s		move_date(	date,date option(nullable) s=null<date> ,
											error_info option(nullable) error = null<error_info> );						/*legacy*/

	override number  			present_value(	..disc_func option(nullable),..disc_func option(nullable), out number ,
												out number ,number option(nullable) = null<number>, logical option(nullable) trade_date_pv = false,		
												error_info option(nullable) error = null<error_info> );
	
	override number  			present_value(	..disc_func option(nullable),..disc_func option(nullable),out number ,
												out number,date option(nullable) ,date option(nullable) ,
												logical,logical  ,error_info option(nullable) error = null<error_info> );

	override number				solver(	number,swap_solver_code ,logical option(nullable) trade_date_pv = false,
										error_info option(nullable) error = null<error_info> );
};
//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
swap_fltois2s.swap_fltois2s(__instrument i) option(hidden): swap_gen(i)
{
	error_info ee 	= new error_info(true,true);
	if(!this.is_valid(ee)) {
		ext_swap_ = ccy_swap_ = full_swap_ = false;
		return;
	}
	ext_swap_ 		= this.is_ext_swap(ee);
	ccy_swap_ 		= false;//this.is_ccy_swap(ee);
	full_swap_ 		= false;//this.verify_full_swap(ee);
	return;	
}
//------------------------------------------------
// copy constructor
//------------------------------------------------
swap_fltois2s.swap_fltois2s(swap_fltois2s c) : swap_gen(c)/*,
						  ext_swap_(c.ext_swap_), ccy_swap_(c.ccy_swap_), full_swap_(c.full_swap_)*/ {}
//------------------------------------------------
// __dbg_print
//------------------------------------------------
void swap_fltois2s.__dbg_print(__dbg_label l)
{
    error_info ee 	= new error_info(true,false);
    l.set_text(strcat([
						"name: ",
						name(ee),
						",  ext_swap: ",
						null(ext_swap_) ? "" : string(ext_swap_),
                        ", ccy_swap: ",
						null(ccy_swap_) ? "" : string(ccy_swap_),
						", valid: ",
						null(this.is_valid(ee)) ? "" : string(this.is_valid(ee))
					]));
}

//------------------------------------------------
// __dbg_browse
//------------------------------------------------
void swap_fltois2s.__dbg_browse(__dbg_split s)
{
    s.resize(4);

	error_info e = error_info(true,false);
    s.set_text(0, "name");
    s.set_value(0, this.name(e));

    s.set_text(1, "ext_swap");
    s.set_value(1, ext_swap_);

    s.set_text(2, "ccy_swap");
    s.set_value(2, ccy_swap_);

	s.set_text(3, "valid");
    s.set_value(3, is_valid(e));
}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
swap_fltois2s swap_fltois2s(swap_fltois2s b)	{ return new swap_fltois2s(b);}
//------------------------------------------------
// clone
//------------------------------------------------
swap_fltois2s swap_fltois2s.clone() 	{ return new swap_fltois2s(this);}

/*-----------------------------------------------------------------------
  member inst()
  ----------------------------------------------------------------------*/
instrument 	swap_fltois2s.inst()		{ return this;}
//------------------------------------------------
// create  [PROTECTED]
// create swap_fltois2s from internal instrument
//------------------------------------------------
swap_fltois2s swap_fltois2s.create(	__instrument option(nullable) c,
									out instr_error option(nullable) error ,
									error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_fltois2s>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.SWAP_FLTOIS2S, "invalid instrument type",type );//should not happen
	
	return new swap_fltois2s(c);
}
//-----------------------------------------------
// dynamic cast <FUNCTION>   
//-----------------------------------------------
swap_fltois2s swap_fltois2s(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex (2-swap)')
option(com_name: 'swap_fltois2s_dyncast')
{ 
	try {
		swap_fltois2s d = dynamic_cast<swap_fltois2s>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a swap_fltois2s)","swap_fltois2s" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s");
		return null<swap_fltois2s>;
	}
}
/*-----------------------------------------------------------------------
  function: create_swap_fltois2s
  ----------------------------------------------------------------------*/
swap_fltois2s create_swap_fltois2s(	__instrument option(nullable) c,									
									out instr_error option(nullable) error ,
									error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_swap_fltois2s')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_fltois2s>; 
		
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.SWAP_FLTOIS2S, "invalid instrument type",type );//should not happen
	
	return new swap_fltois2s(c);
}

swap_fltois2s create_swap_fltois2s(	__instrument option(nullable) 		c,
								error_info option(nullable) 		error,
								error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_swap_fltois2s_ei')
{
	instr_error ee 	= instr_error();
	swap_fltois2s b 	= create_swap_fltois2s(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_swap_fltois2s");
	return b;
}

/*-----------------------------------------------------------------------
  swap_fixflt
  not normalized:
	swap2: fix2 cpn = fix_sprd		vs flt2 flat  --> the spread is on the flat swap
	swap1: fix1 cpn = 0				vs flt1 flat
	
  normalized:
	swap2: fix2 cpn = fixr2			vs flt2 flat (pv=0) 				--> fixr2 = the flat swap rate
	swap1: fix1 cpn = fixr1 		vs flt1 flat (pv=pv for both swaps) --> fixr1 = the sprd swap rate excl. spread

	fixr2 - fixr1 = sprd
	or fixr1 + sprd = fixr2
  ----------------------------------------------------------------------*/

void swap_fltois2s.swaps(	logical option(nullable) clone,
							out swap_fixflt  fix_flt1,
							out swap_fixois  fix_ois2,
							error_info option(nullable) 	error)
{
	try {
		SWAP_ENTRY_FUNC();
		//this.normalize(	null<disc_func>,error);
		//QL_FAIL_COND(error.is_error(), error.message());
		
		ql_fixed_income_swap sw1,sw2;

		instr_error_type t;
   		string 			s;	
		i().__swap_2swap_instruments(clone,sw1,sw2,t, s);

		error_info ee = new error_info(true,true);
		logical is_e = CORE_INT.add_error_info(ee,t,s, "swap_fltois2s.swaps");
		QL_FAIL_COND(is_e, ee.message(), this, true);
		
		__instrument c1 = __instrument_swap(sw1);
		__instrument c2 = __instrument_swap(sw2);

		instr_error e = instr_error();
		if(c1.is_valid(e))			
			fix_flt1 = create_swap_fixflt(c1, e);	
		else
			fix_flt1 = create_null_swap_fixflt();

		QL_FAIL_COND(null(fix_flt1), e.message(), this, true);
		
		if(c2.is_valid(e))			
			fix_ois2 = create_swap_fixois(c2, e);	
		else
			fix_ois2 = create_null_swap_fixois();
		
		QL_FAIL_COND(null(fix_ois2), e.message(), this, true);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s.swaps");		
		return  ;
	}
}

/*-----------------------------------------------------------------------
  set_date <protected>
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
swap_fltois2s swap_fltois2s.set_date(	date  				trade_date, 
										date  option(nullable)	settle_date,
										logical 			re_init_static, 
										logical 			re_init_quote, 
										error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,null<date>,true,re_init_quote,error);
	return null(cc) ? null<swap_fltois2s>: dynamic_cast<swap_fltois2s>(cc);
	
}

/*-----------------------------------------------------------------------
  set_date <protected/legacy>
	quote is NOT kept even if trade_date is unchanged
  ----------------------------------------------------------------------*/
swap_fltois2s swap_fltois2s.set_date(	date  				trade_date, 
										logical 			re_init_static, 
										error_info option(nullable) error) 

{	
	instrument cc = instrument._set_date(trade_date,true,error);
	return null(cc) ? null<swap_fltois2s>: dynamic_cast<swap_fltois2s>(cc);	
}

/*-----------------------------------------------------------------------
   move_date  <protected/legacy>
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	if trade date is the same --> the settle date will be preserved	
  ----------------------------------------------------------------------*/
swap_fltois2s swap_fltois2s.move_date(	date  				trade_date, 
										date option(nullable) settle_date,
										error_info option(nullable) error) 
{	
	instrument cc = instrument._move_date(trade_date,null<date>,error);
	return null(cc) ? null<swap_fltois2s>: dynamic_cast<swap_fltois2s>(cc);
}
/*-----------------------------------------------------------------------
  swap_fltois2s: set_quote 
  ----------------------------------------------------------------------*/
swap_fltois2s swap_fltois2s.set_quote(	number 	option(nullable) quote,									
										error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, false,error);
	return null(cc) ? null<swap_fltois2s>: dynamic_cast<swap_fltois2s>(cc);
}

/*-----------------------------------------------------------------------
  swap_fltois2s: set_quote
  ----------------------------------------------------------------------*/
swap_fltois2s swap_fltois2s.set_quote(	string 	option(nullable) quote_side,								
										error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, false,error);
	return null(cc) ? null<swap_fltois2s>: dynamic_cast<swap_fltois2s>(cc);
}

/*-----------------------------------------------------------------------
  nominal	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_fltois2s.nominal(error_info option(nullable) error ) option(hidden)
{
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return instrument.nominal(error);
	}
}

/*-----------------------------------------------------------------------
  currency(fix leg- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
string  swap_fltois2s.currency(error_info option(nullable) error ) option(hidden) 
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return instrument.currency(error);
	}
}
/*-----------------------------------------------------------------------
  eom	EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical swap_fltois2s.eom(error_info option(nullable) error )  option(hidden) 
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return instrument.eom(error);
	}
}
/*-----------------------------------------------------------------------
  calendar_name  	
  ----------------------------------------------------------------------*/
string swap_fltois2s.calendar_name(error_info option(nullable) error )  option(hidden) 
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return instrument.calendar_name(error);
	}
}
/*-----------------------------------------------------------------------
  calendar_name  	
  ----------------------------------------------------------------------*/
string swap_fltois2s.calendar_name(	integer index,
								 error_info option(nullable) error )  option(hidden) 
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return instrument.calendar_name(index,error);
	}
}
/*-----------------------------------------------------------------------
  calendar  	EXT SWAP: ok
  ----------------------------------------------------------------------*/
..calendar swap_fltois2s.calendar(error_info option(nullable) error )  option(hidden) 
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return instrument.calendar(error);
	}
}
/*-----------------------------------------------------------------------
  issue_date	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
date  swap_fltois2s.issue_date(error_info option(nullable) error ) 
{
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return instrument.issue_date(error);
	}
}
/*-----------------------------------------------------------------------
  settle_code  EXT SWAP: ok
  ----------------------------------------------------------------------*/
string swap_fltois2s.settle_code(error_info option(nullable) error )  
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return instrument.settle_code(error);
	}
}
/*-----------------------------------------------------------------------
  pmt_bus_day   (leg1- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
bd_convention swap_fltois2s.pmt_bus_day(error_info option(nullable) error )  
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return instrument.pmt_bus_day(error);
	}
}
/*-----------------------------------------------------------------------
  calendar
  ----------------------------------------------------------------------*/
calendar swap_fltois2s.calendar(integer index,
								error_info option(nullable) error) option(hidden)
{
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return instrument.calendar(index,error);
	}
}
/*-----------------------------------------------------------------------
  coupon_freq   (leg1- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
integer  swap_fltois2s.coupon_freq(error_info option(nullable) error )  option(hidden)
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return instrument.coupon_freq(error);
	}
}

/*-----------------------------------------------------------------------
  dc_method   (leg1- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
day_count_method  swap_fltois2s.dc_method(error_info option(nullable) error )  option(hidden)
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return instrument.dc_method(error);
	}
}

/*-----------------------------------------------------------------------
  swap_fltois2s: coupon_freq_fix_flt_leg
  ----------------------------------------------------------------------*/
integer swap_fltois2s.coupon_freq_fix_flt_leg(error_info option(nullable) error)
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		integer fixleg_flat_cpn_freq,fltleg_flat_cpn_freq,fixleg_sprd_cpn_freq,oisleg_sprd_cpn_freq;
		this.instr_def().swap_cpn_freq_fltois2s(	fixleg_flat_cpn_freq, fltleg_flat_cpn_freq,
												fixleg_sprd_cpn_freq, oisleg_sprd_cpn_freq,error);
		
		return fixleg_flat_cpn_freq;
	}
} 

/*-----------------------------------------------------------------------
  swap_fltois2s: coupon_freq_fix_ois_leg
  ----------------------------------------------------------------------*/
integer swap_fltois2s.coupon_freq_fix_ois_leg(error_info option(nullable) error)
{
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		integer fixleg_flat_cpn_freq,fltleg_flat_cpn_freq,fixleg_sprd_cpn_freq,oisleg_sprd_cpn_freq;
		this.instr_def().swap_cpn_freq_fltois2s(	fixleg_flat_cpn_freq, fltleg_flat_cpn_freq,
												fixleg_sprd_cpn_freq, oisleg_sprd_cpn_freq,error);
		
		return fixleg_sprd_cpn_freq;
	}
}

/*-----------------------------------------------------------------------
  swap_fltois2s: dc_method_fix_ois_leg
  ----------------------------------------------------------------------*/
day_count_method swap_fltois2s.dc_method_fix_ois_leg(error_info option(nullable) error)
{
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		day_count_method fixleg_flat_dc, fltleg_flat_dc, fixleg_sprd_dc, oisleg_sprd_dc;
		this.instr_def().swap_dc_method_fltois2s(fixleg_flat_dc,fltleg_flat_dc,fixleg_sprd_dc,oisleg_sprd_dc,error);

		return fixleg_sprd_dc ;
	}
}
/*-----------------------------------------------------------------------
  swap_fltois2s: dc_method_fix_flt_leg
  ----------------------------------------------------------------------*/
day_count_method swap_fltois2s.dc_method_fix_flt_leg(error_info option(nullable) error)
{
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		day_count_method fixleg_flat_dc, fltleg_flat_dc, fixleg_sprd_dc, oisleg_sprd_dc;
		this.instr_def().swap_dc_method_fltois2s(fixleg_flat_dc,fltleg_flat_dc,fixleg_sprd_dc,oisleg_sprd_dc,error);
	
		return fixleg_flat_dc;
	}
} 
/*-----------------------------------------------------------------------
  swap_fltois2s: dc_method_ois_leg
  ----------------------------------------------------------------------*/
day_count_method swap_fltois2s.dc_method_ois_leg(error_info option(nullable) error)
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return this.instr_def().swap_dc_method_leg2(error);
	}
} 

/*-----------------------------------------------------------------------
  swap_fltois2s: dc_method_flt_leg
  ----------------------------------------------------------------------*/
day_count_method 	swap_fltois2s.dc_method_flt_leg(error_info option(nullable) error)
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return this.instr_def().swap_dc_method_leg1(error);
	}
}

/*-----------------------------------------------------------------------
  swap_fltois2s: coupon_freq_ois_leg  (a float leg freq)
  ----------------------------------------------------------------------*/
integer swap_fltois2s.coupon_freq_ois_leg(error_info option(nullable) error)
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return this.instr_def().swap_coupon_freq_leg2(error);
	}
} 

/*-----------------------------------------------------------------------
  swap_fltois2s: coupon_freq_flt_leg  (a float leg freq)
  ----------------------------------------------------------------------*/
integer 	swap_fltois2s.coupon_freq_flt_leg(error_info option(nullable) error)
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return this.instr_def().swap_coupon_freq_leg1(error);
	}
} 
/*-----------------------------------------------------------------------
  swap_fltois2s: reset_freq_ois_leg
  ----------------------------------------------------------------------*/
integer swap_fltois2s.reset_freq_ois_leg(error_info option(nullable) error)
{	
	return 365;
} 

/*-----------------------------------------------------------------------
  swap_fltois2s: reset_freq_flt_leg
  ----------------------------------------------------------------------*/
integer  swap_fltois2s.reset_freq_flt_leg(error_info option(nullable) error)
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return this.instr_def().swap_reset_freq_leg1(error);
	}
} 
/*-----------------------------------------------------------------------
  swap_fltois2s: roll_day_ois_leg
  ----------------------------------------------------------------------*/
integer swap_fltois2s.roll_day_ois_leg(error_info option(nullable) error)
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return this.instr_def().swap_roll_day_leg2(error);
	}
} 

/*-----------------------------------------------------------------------
  swap_fltois2s: roll_day_flt_leg
  ----------------------------------------------------------------------*/
integer swap_fltois2s.roll_day_flt_leg(error_info option(nullable) error)
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return this.instr_def().swap_roll_day_leg1(error);
	}
} 

/*-----------------------------------------------------------------------
  ir_rule_fix_ois_leg
  ----------------------------------------------------------------------*/
interest_rule  swap_fltois2s.ir_rule_fix_ois_leg(error_info option(nullable) error)
{	
	return this.ir_rule_ois_leg(error);
}

/*-----------------------------------------------------------------------
  ir_rule_fix_flt_leg
  ----------------------------------------------------------------------*/
interest_rule  swap_fltois2s.ir_rule_fix_flt_leg(error_info option(nullable) error)
{	
	return this.ir_rule_flt_leg(error);
}
/*-----------------------------------------------------------------------
  ir_rule_ois_leg
  ----------------------------------------------------------------------*/
interest_rule  swap_fltois2s.ir_rule_ois_leg(error_info option(nullable) error)
{
	if(!ext_swap_){
		return this.instr_def().swap_ir_rule_leg2(error);
	}
	
	try{	
		instr_error_type t;
   		string 			s;	
		interest_rule ir_rule_leg2 = i().__swap_int_rule_leg4(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois2s.ir_rule_ois_leg");
		return e ? null : ir_rule_leg2;				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s.ir_rule_ois_leg");
		return null;
	}
}
/*-----------------------------------------------------------------------
  ir_rule_flt_leg
  ----------------------------------------------------------------------*/
interest_rule  swap_fltois2s.ir_rule_flt_leg(error_info option(nullable) error)
{
	if(!ext_swap_){
		return this.instr_def().swap_ir_rule_leg1(error);
	}
	
	try{	
		instr_error_type t;
   		string 			s;	
		interest_rule ir_rule_leg2 = i().__swap_int_rule_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois2s.ir_rule_flt_leg");
		return e ? null : ir_rule_leg2;				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s.ir_rule_flt_leg");
		return null;
	}
}

/*-----------------------------------------------------------------------
  swap_fltois2s: pmt_bus_day_fix_flt_leg
  ----------------------------------------------------------------------*/
bd_convention swap_fltois2s.pmt_bus_day_fix_flt_leg(error_info option(nullable) error)
{	
	return this.pmt_bus_day_flt_leg(error);
} 
/*-----------------------------------------------------------------------
  swap_fltois2s: pmt_bus_day_fix_ois_leg
  ----------------------------------------------------------------------*/
bd_convention swap_fltois2s.pmt_bus_day_fix_ois_leg(error_info option(nullable) error)
{	
	return this.pmt_bus_day_ois_leg(error);
} 
/*-----------------------------------------------------------------------
  swap_fltois2s: pmt_bus_day_ois_leg
  ----------------------------------------------------------------------*/
bd_convention swap_fltois2s.pmt_bus_day_ois_leg(error_info option(nullable) error)
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return this.instr_def().swap_pmt_bus_day_leg2(error);
	}
} 

/*-----------------------------------------------------------------------
  swap_fltois2s: pmt_bus_day_flt_leg
  ----------------------------------------------------------------------*/
bd_convention 	swap_fltois2s.pmt_bus_day_flt_leg(error_info option(nullable) error)
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return this.instr_def().swap_pmt_bus_day_leg1(error);
	}
} 

/*-----------------------------------------------------------------------
  swap_fltois2s: eom_fix_flt_leg
  ----------------------------------------------------------------------*/
logical swap_fltois2s.eom_fix_flt_leg(error_info option(nullable) error)
{	
	return this.eom_flt_leg(error);
} 
/*-----------------------------------------------------------------------
  swap_fltois2s: eom_fix_ois_leg
  ----------------------------------------------------------------------*/
logical swap_fltois2s.eom_fix_ois_leg(error_info option(nullable) error)
{	
	return this.eom_ois_leg(error);
} 
/*-----------------------------------------------------------------------
  swap_fltois2s: eom_ois_leg
  ----------------------------------------------------------------------*/
logical swap_fltois2s.eom_ois_leg(error_info option(nullable) error)
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return this.instr_def().swap_eom_leg2(error);
	}
} 

/*-----------------------------------------------------------------------
  swap_fltois2s: eom_flt_leg
  ----------------------------------------------------------------------*/
logical  	swap_fltois2s.eom_flt_leg(error_info option(nullable) error)
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return this.instr_def().swap_eom_leg1(error);
	}
} 

/*-----------------------------------------------------------------------
  swap_fltois2s: calendar_fix_flt_leg
  ----------------------------------------------------------------------*/
calendar swap_fltois2s.calendar_fix_flt_leg(error_info option(nullable) error)
{	
	return this.calendar_flt_leg(error);
} 
/*-----------------------------------------------------------------------
  swap_fltois2s: calendar_fix_ois_leg
  ----------------------------------------------------------------------*/
calendar swap_fltois2s.calendar_fix_ois_leg(error_info option(nullable) error)
{	
	return this.calendar_ois_leg(error);
} 
/*-----------------------------------------------------------------------
  swap_fltois2s: calendar_ois_leg
  ----------------------------------------------------------------------*/
calendar swap_fltois2s.calendar_ois_leg(error_info option(nullable) error)
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return this.instr_def().swap_calendar_leg2(error);
	}
} 

/*-----------------------------------------------------------------------
  swap_fltois2s: calendar_flt_leg
  ----------------------------------------------------------------------*/
calendar  	swap_fltois2s.calendar_flt_leg(error_info option(nullable) error)
{	
	if(ext_swap_){
		QL_FAIL("non-db swap not supported yet");
	}
	else {
		return this.instr_def().swap_calendar_leg1(error);
	}
} 

/*-----------------------------------------------------------------------
  ir_index_flt_leg
  ----------------------------------------------------------------------*/
ir_index swap_fltois2s.ir_index_flt_leg(error_info option(nullable) error)
{	
	if(ext_swap_){
		instr_error_type t;
   		string 			s;	
		..ir_index c = i().__swap_def_ir_index_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois2s.ir_index_flt_leg");
		return e ? null<..ir_index >: c;
	}
	else {
		return instr_def().swap_ir_index_leg1(error);
	}
}

/*-----------------------------------------------------------------------
  index_tenor_code_flt_leg
  ----------------------------------------------------------------------*/
tenor_code swap_fltois2s.index_tenor_code_flt_leg(error_info option(nullable) error) 
{	
	if(ext_swap_) {
		..ir_index ir = this.ir_index_flt_leg(error);
		return null(ir) ? null: ir.tenor_code();
	}
	else {
		return instr_def().swap_index_tenor_code_leg1(error);
	}
}

/*-----------------------------------------------------------------------
  index_tenor_flt_leg
  ----------------------------------------------------------------------*/
string swap_fltois2s.index_tenor_flt_leg(error_info option(nullable) error) 
{	
	if(ext_swap_) {
		..ir_index ir = this.ir_index_flt_leg(error);
		return null(ir) ? null: ir.tenor();
	}
	else {
		return instr_def().swap_index_tenor_leg1(error);
	}
}

/*-----------------------------------------------------------------------
  ir_index_ois_leg
  ----------------------------------------------------------------------*/
ir_index swap_fltois2s.ir_index_ois_leg(error_info option(nullable) error)
{	
	if(ext_swap_){
		instr_error_type t;
   		string 			s;	
		..ir_index c = i().__swap_ir_index_leg4(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois2s.ir_index_ois_leg");
		return e ? null<..ir_index >: c;
	}
	else {
		return instr_def().swap_ir_index_leg2(error);
	}
}

/*-----------------------------------------------------------------------
  index_tenor_ois_leg
  ----------------------------------------------------------------------*/
string swap_fltois2s.index_tenor_ois_leg(error_info option(nullable) error) 
{	
	if(ext_swap_) {
		..ir_index ir = this.ir_index_ois_leg(error);
		return null(ir) ? null: ir.tenor();
	}
	else {
		return instr_def().swap_index_tenor_leg1(error);
	}
}

/*-----------------------------------------------------------------------
  index_tenor_code_flt_leg
  ----------------------------------------------------------------------*/
tenor_code swap_fltois2s.index_tenor_code_ois_leg(error_info option(nullable) error) 
{	
	if(ext_swap_) {
		..ir_index ir = this.ir_index_ois_leg(error);
		return null(ir) ? null: ir.tenor_code();
	}
	else {
		return instr_def().swap_index_tenor_code_leg1(error);
	}
}

/*-----------------------------------------------------------------------
  is_cross_currency
  ----------------------------------------------------------------------*/
logical	 swap_fltois2s.is_cross_currency(error_info option(nullable) error )
{
	return false;
}


/*-----------------------------------------------------------------------
  quote 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_fltois2s.quote(	out number  quote_leg1, 
							out number  quote_leg2, 
							error_info option(nullable) error ) 
{
	if(ext_swap_)
		QL_FAIL("non-db swap not supported yet");
	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		i().__swap_def_quote(quote_leg1,quote_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois2s.quote");
		if(e)
			quote_leg1 = quote_leg2 = null<number>;
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s.quote");
		quote_leg1 = quote_leg2 = null<number>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  quote   
  ----------------------------------------------------------------------*/
number  swap_fltois2s.quote(error_info option(nullable) error)

{	
	try{
		error_info 	ee = new error_info(true,false);
		number quote_leg1, quote_leg2;
		this.quote(	quote_leg1, quote_leg2,  ee) ;
		if(ee.is_error())
			QL_FAIL( ee.message(),this,true);

		logical l = this.leg1_is_quote(ee);
		
		return l ? quote_leg1: quote_leg2;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s.quote");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  create_tenor_surface_flat_leg	(fwd is a fwd_func)  EXT SWAP: ok
  ----------------------------------------------------------------------*/
..tenor_surface swap_fltois2s.create_tenor_surface_flt_leg(..disc_func df,
															fwd_func fwdf,
															error_info option(nullable) error)
{
	try{
		
		error_info ee 			= error_info(true,true);
		..ir_index ir			= this.ir_index_flt_leg(ee);
		CORE_INT.instr_fail_check(null(ir), "invalid ir_index", this, ee);
		logical allow_extrap 	= false;		
		return tenor_surface(this.trade_date(), df,[fwdf],[ir],allow_extrap);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s.create_tenor_surface_flt_leg");
		return null<tenor_surface>;
	}
}

/*-----------------------------------------------------------------------
  create_tenor_surface_ois_leg	(fwd is a fwd_func)  EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_fltois2s.create_tenor_surface_ois_leg(..disc_func option(nullable) fwddf,
														fwd_func option(nullable) fwdf1d,
														logical		sync_endog_ok,
														error_info option(nullable) error)
{
	error_info ee 	= new error_info(true,true);
	logical is_proxy = this.is_approx_calc_ois_leg(ee);

	..ir_index ir			= this.ir_index_ois_leg(ee);
	CORE_INT.instr_fail_check(null(ir), "invalid ir_index", this, ee);
		
	return swap_gen.create_tenor_surface_ois_leg(ir,is_proxy ,fwddf,fwdf1d,sync_endog_ok,error);	
}

/*-----------------------------------------------------------------------
  add_notional
  ----------------------------------------------------------------------*/
void swap_fltois2s.add_notional(number notional)
{
	SWAP_ENTRY_FUNC();
	//i().__swap_add_notional_leg1(notional);
	swap_gen.swap_add_notional(notional);//add to all 4 legs
}
/*-----------------------------------------------------------------------
  add_disc_func
  ----------------------------------------------------------------------*/
void swap_fltois2s.add_disc_func(..disc_func df,
								 logical add_surf_if_endog,
								 out tenor_surface ts )
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_disc_func(df);//add to all 4 legs

	error_info ee = new error_info(true,true);
	
	if(add_surf_if_endog && this.is_endog_df_ois_leg(ee) ){
		if(null(ts)) {				
			ts = create_tenor_surface_ois_leg(df,null,true,ee);
		}
		this.add_surface_ois_leg(ts);
	}
	else {
		ts = null;
	}
}
/*-----------------------------------------------------------------------
  add_surface_flt_leg
  ----------------------------------------------------------------------*/
void swap_fltois2s.add_surface_flt_leg(tenor_surface option(nullable) tenor_surface)
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_surface_leg2(tenor_surface);
}
/*-----------------------------------------------------------------------
  add_surface_ois_leg
  no sync of disc_func
  ----------------------------------------------------------------------*/
void swap_fltois2s.add_surface_ois_leg(tenor_surface option(nullable) tenor_surface)
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_surface_leg4(tenor_surface);
}
/*-----------------------------------------------------------------------
  add_fixing
  ----------------------------------------------------------------------*/
void swap_fltois2s.add_fixing_ois_leg(	vector(date) fixing_dates,
										vector(number) fixings,
										logical option(nullable) fixing_as_fwd )
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_fixing_leg4(fixing_dates,fixings,fixing_as_fwd);					
}

void swap_fltois2s.add_fixing_flt_leg(	vector(date) fixing_dates,
										vector(number) fixings,
										logical option(nullable) fixing_as_fwd )
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_fixing_leg2(fixing_dates,fixings,fixing_as_fwd);					
}

void swap_fltois2s.add_fixing_ois_leg(number fixing_proxy,
									logical option(nullable) fixing_as_fwd ) 
{			
	SWAP_ENTRY_FUNC();
	i().__swap_add_fixing_leg4(fixing_proxy, fixing_as_fwd);						
}

void swap_fltois2s.add_fixing_flt_leg(number fixing_proxy,
									logical option(nullable) fixing_as_fwd ) 
{			
	SWAP_ENTRY_FUNC();
	i().__swap_add_fixing_leg2(fixing_proxy, fixing_as_fwd);					
}
/*-----------------------------------------------------------------------
   add_quote		EXT SWAP FLTFLT: NOT ok
  ----------------------------------------------------------------------*/
void swap_fltois2s.add_quote(	number  quote ) 
{	
	if(ext_swap_)
		QL_FAIL("non-db swap not supported yet");//for now
	
	if(is_ext_swap())
		i().__swap_add_quote(quote);//fltflt2s and fltois2s will throw as of now	
	else
		i().__add_quote(quote, false);
	return ;
}
/*-----------------------------------------------------------------------
  add_quote		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_fltois2s.add_quote(	number  quote,
							..quote_style quote_style) 
{
	error_info ee = new error_info(true,true);
	..quote_style qs = swap_gen.quote_style_e(ee);
	
	if(quote_style == qs)
		this.add_quote(quote);
	else{
		if(quote_style == ..quote_style.SPREAD_BP)
			this.add_quote(quote*10000);//instr quotestyle must be bp
		else if(quote_style == ..quote_style.SPREAD)
			this.add_quote(quote/10000);//instr quotestyle is not bp
		else
			QL_FAIL("invalid quote style",this,true);
	}					
}

/*-----------------------------------------------------------------------
  disc_func
  //note: assumes always single currency
  ----------------------------------------------------------------------*/
disc_func swap_fltois2s.disc_func(error_info option(nullable) error)
{
	try{
		SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		..disc_func c = i().__swap_disc_func_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois2s.disc_func");
		return e ? null<..disc_func>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s.disc_func");
		return null<..disc_func >;
	}
}

/*-----------------------------------------------------------------------
  swap_type
  ----------------------------------------------------------------------*/
instrument_type swap_fltois2s.swap_type(error_info option(nullable) error) 
{
	//QL_FAIL("underlying swap type for a fltois2s is not available");
	return swap_gen.swap_type(error);
}
/*-----------------------------------------------------------------------
  swap_instrument
  ----------------------------------------------------------------------*/
ql_fixed_income_swap swap_fltois2s.swap_instrument(error_info option(nullable) error) option(hidden)
{
	return swap_gen.swap_instrument(error);

}
/*-----------------------------------------------------------------------
  swap_instrument_1
  ----------------------------------------------------------------------*/
ql_fixed_income_swap swap_fltois2s.swap_instrument_1(logical clone,error_info option(nullable) error) option(hidden)
{
	try {
		SWAP_ENTRY_FUNC();
		instr_error_type t;
		string 			s;	
		ql_fixed_income_swap sw = i().__swap_2swap_swap1(clone,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois2s.swap_instrument_1");
		return e ? null : sw;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s.swap_instrument_1");		
		return null ;
	}
}
/*-----------------------------------------------------------------------
  swap_fixflt
  ----------------------------------------------------------------------*/
/*swap_fixflt swap_fltois2s.swap_fixflt(logical clone,error_info option(nullable) error)
{
	try {
		SWAP_ENTRY_FUNC();
		instr_error_type t;
		string s;	
		ql_fixed_income_swap _sw	= i().__swap_2swap_swap1(clone,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois2s.swap_fixflt");
		QL_FAIL_COND(e, error.message());
				
		__instrument c 				= __instrument_swap(_sw);
		QL_FAIL_COND(null(c), "invalid/unknown (null) instrument" );
		instr_error ee	= new instr_error();
		if(!c.is_valid(ee))
			QL_FAIL(ee.message());
	
		return new ..swap_fixflt(c);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s.swap_fixflt");		
		return null ;
	}
}*/
/*-----------------------------------------------------------------------
  swap_instrument_2
  ----------------------------------------------------------------------*/
ql_fixed_income_swap swap_fltois2s.swap_instrument_2(logical clone,error_info option(nullable) error) option(hidden)
{
	try {
		SWAP_ENTRY_FUNC();
		instr_error_type t;
		string s;	
		ql_fixed_income_swap sw = i().__swap_2swap_swap2(clone,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois2s.swap_instrument_2");
		return e ? null : sw;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s.swap_instrument_2");		
		return null ;
	}
}
/*-----------------------------------------------------------------------
  swap_fixois
  ----------------------------------------------------------------------*/
/*swap_fixois swap_fltois2s.swap_fixois(logical clone,error_info option(nullable) error)
{
	try {
		SWAP_ENTRY_FUNC();
		instr_error_type t;
		string 			s;	
		ql_fixed_income_swap _sw	= i().__swap_2swap_swap2(clone,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois2s.swap_fixois");
		QL_FAIL_COND(e, error.message());		
		__instrument c 				= __instrument_swap(_sw);
		QL_FAIL_COND(null(c), "invalid/unknown (null) instrument" );
		instr_error ee	= new instr_error();
		if(!c.is_valid(ee))
			QL_FAIL(ee.message());
	
		return new ..swap_fixois(c);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s.swap_fixois");		
		return null ;
	}
}*/
/*-----------------------------------------------------------------------
  is_approx_calc_ois_leg1	EXT SWAP: ok (defaults to true for all db swaps)
  ----------------------------------------------------------------------*/
logical  swap_fltois2s.is_approx_calc_ois_leg(error_info option(nullable) error ) 
{	
	try{
		//QL_REQUIRE(leg1_is_ois(),"invalid function call");
		error_info ee = error_info(true,true);
		vector(ql_ois_leg) l = swap_gen.swap_ois_leg(false,ee);
		if(null(l))
			return null<logical >;
				
		return l[0].approx_calc();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s.is_approx_calc_ois_leg");
		return null<logical >;
	}
}
/*-----------------------------------------------------------------------
  is_endog_df	EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical  swap_fltois2s.is_endog_df_ois_leg(error_info option(nullable) error ) 
{	
	try{
		
		error_info ee = error_info(true,true);		
		vector(ql_ois_leg) l = swap_gen.swap_ois_leg(false,ee);
		if(null(l))
			return null<logical >;
		return l[0].is_endog_df();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s.is_endog_df_ois_leg");
		return null<logical >;
	}
}
/*-----------------------------------------------------------------------
  flat_leg_is_float_leg
  ----------------------------------------------------------------------*/
logical	swap_fltois2s.flat_leg_is_float_leg(error_info option(nullable) error  )
{	
	return !swap_gen.leg1_is_quote(error);
}
/*-----------------------------------------------------------------------
  flat_leg_is_ois_leg
  ----------------------------------------------------------------------*/
logical	swap_fltois2s.flat_leg_is_ois_leg(error_info option(nullable) error )
{	
	return swap_gen.leg1_is_quote(error);
}
/*-----------------------------------------------------------------------
  normalize
  ----------------------------------------------------------------------*/
logical swap_fltois2s.normalize(..disc_func option(nullable) disc_func,
								error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_normalize_2swap(disc_func,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois2s.normalize");
		return !e;		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s.normalize");		
		return false;
	}
}

/*-----------------------------------------------------------------------
  implied_spread
  ----------------------------------------------------------------------*/
number swap_fltois2s.implied_spread( error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__swap_2swap_imp_spread(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois2s.implied_spread");
		return e?null:c;		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s.implied_spread");		
		return null;
	}
}


/*-----------------------------------------------------------------------
  present_value  protected (because we have 2 disc_funcs and it overrides the root)
  ----------------------------------------------------------------------*/
number swap_fltois2s.present_value(	..disc_func option(nullable)	df,
									..disc_func option(nullable) 	df_not_used,
									out number 					pv_sprd_swap,
									out number 					pv_flat_swap,
									number option(nullable) 	notional,
									logical option(nullable) 	trade_date_pv,																								
									error_info option(nullable) error)
{	
	return this.present_value(df,pv_sprd_swap, pv_flat_swap,notional,trade_date_pv,error);
}

/*-----------------------------------------------------------------------
  present_value  protected
  ----------------------------------------------------------------------*/
number swap_fltois2s.present_value(	..disc_func option(nullable)	df,
									..disc_func option(nullable) 	df_not_used,
									out number 						pv_sprd_swap,
									out number 						pv_flat_swap,
									date option(nullable) 			pv_date,
									date option(nullable) 			settle_date,
									logical  						incl_issue_cf,
									logical  						incl_mat_cf,	
									error_info option(nullable) 	error)
{	
	return this.present_value(	df,pv_sprd_swap,pv_flat_swap,pv_date,
								settle_date ,incl_issue_cf,incl_mat_cf,error );
}

/*-----------------------------------------------------------------------
  present_value  assumes single cuurency
  ----------------------------------------------------------------------*/
number swap_fltois2s.present_value(	..disc_func option(nullable)	df,
									out number 						pv_sprd_swap,
									out number 						pv_flat_swap,
									number option(nullable) 		notional,
									logical option(nullable) 		trade_date_pv,																								
									error_info option(nullable) 	error)
{	
	return swap_gen.present_value(df,df,pv_sprd_swap,pv_flat_swap,notional,trade_date_pv,error);
}


number swap_fltois2s.present_value(	..disc_func option(nullable)	df,									
									out number 						pv_sprd_swap,
									out number 						pv_flat_swap,
									date option(nullable) 			pv_date,
									date option(nullable) 			settle_date,
									logical  						incl_issue_cf,
									logical  						incl_mat_cf,	
									error_info option(nullable) 	error)
{	
	return swap_gen.present_value(df,df,pv_sprd_swap,pv_flat_swap,pv_date, settle_date ,incl_issue_cf,incl_mat_cf,error );
}

number swap_fltois2s.present_value(	out number 	pv_sprd_swap,
									out number 	pv_flat_swap,
									logical option(nullable) 	trade_date_pv,																								
									error_info option(nullable) error)
{	
	return swap_gen.present_value(pv_sprd_swap,pv_flat_swap,trade_date_pv ,error );
}

/*-----------------------------------------------------------------------
  solver  
  ----------------------------------------------------------------------*/
number swap_fltois2s.solver(	number 				pv,
								swap_solver_code 	solver_code,
								logical option(nullable) trade_date_pv,
								error_info option(nullable) error)
{
	return this.solver(	pv, solver_code,true, trade_date_pv, error);
	
}
/*-----------------------------------------------------------------------
  solver  
  ----------------------------------------------------------------------*/
number swap_fltois2s.solver(	number 				pv,
								swap_solver_code 	solver_code,
								logical  			swap1,
								logical option(nullable) trade_date_pv,
								error_info option(nullable) error)
{
	try{	
		instr_error_type t;
   		string 			s;	
		number  c = i().__swap_solver_2swap(pv, solver_code,trade_date_pv ,swap1,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fltois2s.swap_solver");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s.swap_solver");
		return null<number  >;
	}
	
}