option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	fra
	--------------------------------------------------------------------
*/

//-----------------------------------------------------------------------
//  class fra
//----------------------------------------------------------------------
class fra : public instrument
option(category: "Instrument/Fra")
//option(allow_undeclared_mfuncs)
{
public:

	//override string			instr_type_s();	
	override instrument 	inst();

	//-----add-funcs-----			
	override void 			add_nominal(number );										
	override void 			add_quote(number,logical option(nullable) = null<logical> );
	//void 					add_quote_from_rate(number,logical option(nullable) l = null<logical>);
	override void 			add_quote_from_yield(number,logical option(nullable) l = null<logical>);
	
	//-----general-----	
	override logical 		eom(error_info option(nullable) error = null<error_info> );	
	override string 		maturity_code(error_info option(nullable) error = null<error_info> );
	override bd_convention 	pmt_bus_day(error_info option(nullable) error = null<error_info>);
	override day_count_method dc_method(error_info option(nullable) error = null<error_info> );
	number 					contract_rate(error_info option(nullable) error = null<error_info> );
	//-----price-----
	
	number 					rate(logical dr = false,error_info option(nullable) error = null<error_info> );	
	number 					rate(disc_func,logical disable_rounding = false ,error_info option(nullable) error = null<error_info>);
	number					par_rate(disc_func, error_info option(nullable) error = null<error_info> );
	number					par_rate(fwd_func, error_info option(nullable) error = null<error_info> );
	//-----
	override calendar 		fixing_calendar(error_info option(nullable) error = null<error_info>);					
	override string 		fixing_calendar_name(error_info option(nullable) error = null<error_info> );			
	override string 		fixing_code(error_info option(nullable) error = null<error_info> );			
	override date 			index_maturity(error_info option(nullable) error = null<error_info> );	
	override ir_index 		ir_index(error_info option(nullable) error = null<error_info> ); 
	override date			fixing_date(error_info option(nullable) error = null<error_info>);	
	override string 		fixing_curve(error_info option(nullable) error = null<error_info>) ;	
	override string 		fixing_instr(error_info option(nullable) error = null<error_info>) ;	
	override string 		fixing_instr_qs(error_info option(nullable) error = null<error_info>) ;	
	override string 		index_tenor(error_info option(nullable) error = null<error_info>) ;
	override tenor_code 	index_tenor_code(error_info option(nullable) error = null<error_info>) ;


	number 	settle_amount(	number,number option(nullable),number option(nullable),logical,
							disc_func option(nullable),logical option(nullable) l=null<logical>,
							error_info option(nullable) error = null<error_info>);

	number 	settle_amount(	number,number option(nullable),number option(nullable),logical,
							date option(nullable),number option(nullable),logical option(nullable) l=null<logical>,
							error_info option(nullable) error = null<error_info>);

	number 	settle_amount_df(disc_func,number option(nullable)	contract_rate = null<number>,
							number option(nullable)	nominal = 100,
							logical	disc_to_trade = false,		
							disc_func option(nullable)	disc_func_disc = null<disc_func>,logical option(nullable) l=null<logical>,										
							error_info option(nullable) error = null<error_info>);

	number 	settle_amount_df(fwd_func,number option(nullable)	contract_rate = null<number>,
							number option(nullable)	nominal = 100,
							logical	disc_to_trade = false,		
							disc_func option(nullable)	disc_func_disc = null<disc_func>,logical option(nullable) l=null<logical>,										
							error_info option(nullable) error = null<error_info>);
	
	number 	settle_amount_to_market_rate(number, number option(nullable),logical option(nullable),
										 error_info option(nullable) error = null<error_info>);	
	number 	settle_amount_to_contract_rate(number, number option(nullable),logical option(nullable),
										   error_info option(nullable) error = null<error_info>);	

	void 	risk_ladder_fwd(logical,vector(fwd_func),fwd_func,fwd_func option(nullable),number,out vector(number) ,
							out number, error_info option(nullable) error = null<error_info> ) ;
	//-----cashflow-funcs-----
	vector(date) 			cash_flow_dates(error_info option(nullable) error = null<error_info> );
	vector(number) 			cash_flows(logical,number option(nullable),logical,error_info option(nullable) error = null<error_info>);
	vector(number) 			cash_flows_cpn(logical,number option(nullable),error_info option(nullable) error = null<error_info> );
	void  					cash_flow_data(logical	,number option(nullable),logical,out vector(date)   option(nullable),
										out vector(number)  	,error_info option(nullable) error = null<error_info>);	//here to hide cash_flow_data in root

	/*---set functions-required--*/	
	fra 				set_date(date,logical,logical ,error_info option(nullable) error = null<error_info>);						
	override fra		set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);
	override fra		set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);

	//local set
	fra					set_rate(number option(nullable) ,error_info option(nullable) error = null<error_info>);

	fra					set_rate( 	number option(nullable) ,date option(nullable),
									logical option(nullable) set_to_par = true, error_info option(nullable) error = null<error_info>);

	fra					set_quote(	number option(nullable),date option(nullable) trade_date , 
									logical option(nullable) set_to_par= true, error_info option(nullable) error = null<error_info>);
	
	fra					set_quote(string option(nullable),date  option(nullable) ,logical option(nullable),
										error_info option(nullable) error = null<error_info>);

	fra					set_quote_from_rate(number option(nullable),logical option(nullable) set_to_par = true, 
											error_info option(nullable) error = null<error_info> );
	
	/*hidden*/
	override date 		maturity_blend(error_info option(nullable) error = null<error_info>);
	
	fra(__instrument);	
	override fra clone();
	fra(fra);
protected:

	
	override fra 			create(__instrument option(nullable),out instr_error option(nullable),
									error_type type = E_INVALID_ARG);

	

	override fra			set_yield(number option(nullable) ,error_info option(nullable) error = null<error_info>);
						
	override fra  			set_date(date,date option(nullable) s=null<date> ,logical r = true,logical rq = true ,
									error_info option(nullable) error = null<error_info>);
	
	override fra  			set_date(date,logical ,error_info option(nullable) error = null<error_info>);									/*legacy*/

	override fra  			move_date(	date,date option(nullable) s=null<date> , error_info option(nullable) error = null<error_info>);	/*legacy*/
	
	override vector(date)	cash_flow_dates(logical ,logical, logical, error_info option(nullable) error = null<error_info>);
	
	override vector(number)	cash_flows_cpn(number option(nullable) nom = null<number>,logical posts = true,
											logical  k=false,error_info option(nullable) error = null<error_info>);
	
	override vector(number)	cash_flows(number option(nullable) nom = null<number>,logical posts = true,
										logical k= false,error_info option(nullable) error = null<error_info>);

	override void 			cash_flow_data(	number option(nullable) ,logical ,ir_cf_code ,logical ,
											logical,out vector(date)   ,
											out vector(number)   ,error_info option(nullable) error = null<error_info>);

	//override number 		dirty_price_to_yield(number ,logical,out instr_error option(nullable));		
	//override number 		clean_price_to_yield(number ,logical,out instr_error option(nullable));	
	//override number 		price_to_yield(number ,..quote_style.quote_style, out instr_error option(nullable));	
	//-----price-----
	//override number 		yield(logical dr=false,out instr_error option(nullable) );	
	//override number 		yield(disc_func,logical dr=false ,out instr_error option(nullable));   
};

//------------------------------------------------
// create  [PROTECTED]
// create bond from internal instrument
//------------------------------------------------
fra fra.create(	__instrument option(nullable) c,
					out instr_error option(nullable) error,
					error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<fra>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.FRA, "invalid instrument type",type );//should not happen
	
	return new fra(c);
}

/*-----------------------------------------------------------------------
  create_fra <FUNCTION>
  ----------------------------------------------------------------------*/

fra create_fra(	__instrument option(nullable) c,
				out instr_error option(nullable) error,
				error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_fra')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<fra>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.FRA, "invalid instrument type",type );//should not happen
	
	return new fra(c);
}

fra create_fra(	__instrument option(nullable) 		c,
				error_info option(nullable) 		error,
				error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_fra_ei')
{
	instr_error ee 	= instr_error();
	fra b 	= create_fra(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_fra");
	return b;
}
//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
fra.fra(__instrument i) option(hidden) : instrument(i) {}
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string fra.instr_type_s() 	{ return string(..instr_type.FRA);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	fra.inst()		{ return this;}
//------------------------------------------------
// copy constructor
//------------------------------------------------
fra.fra(fra c) : instrument(c) {}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
fra fra(fra f)				{ return new fra(f);}
//------------------------------------------------
// clone
//------------------------------------------------
fra fra.clone()				{ return new fra(this);}

//-----------------------------------------------
// dynamic cast <FUNCTION>
//-----------------------------------------------
fra	fra(instrument i, error_info option(nullable) error = null<error_info>) 
option (category: 'Instrument/Fra')
option(com_name: 'fra_dyncast') 
{ 
	try {
		fra d = dynamic_cast<fra>(i); 
		if(null(d))
			 CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a fra)","fra" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra");
		return null<fra>;
	}
}
/*-----------------------------------------------------------------------
  add_nominal 
  ----------------------------------------------------------------------*/
void fra.add_nominal(number nominal) 
{			
	instrument.add_nominal(nominal );
	return ;						
}

/*-----------------------------------------------------------------------
  add_quote
  ----------------------------------------------------------------------*/
void fra.add_quote(	number  quote,
						logical option(nullable) set_to_par ) 
{	
	instrument.add_quote(quote, set_to_par);
	return ;						
}
/*-----------------------------------------------------------------------
  add_quote_from_yield
  ----------------------------------------------------------------------*/
void fra.add_quote_from_yield(	number  quote,
								logical option(nullable) set_to_par ) 
{	
	instrument.add_quote_from_yield(quote, set_to_par);
	return ;						
}
/*-----------------------------------------------------------------------
  add_quote_from_rate
  ----------------------------------------------------------------------*/
/*void fra.add_quote_from_rate(	number  quote,
								logical option(nullable) set_to_par ) 
{	
	instrument.add_quote_from_yield(quote, set_to_par );
	return ;						
}*/

/*-----------------------------------------------------------------------
  hidden in root members
  ----------------------------------------------------------------------*/
logical fra.eom(error_info option(nullable) error)					{ return instrument.eom(error);}
string 	fra.maturity_code(error_info option(nullable) error) 		{ return instrument.maturity_code(error);}
number  fra.contract_rate(error_info option(nullable) error)		{ return instrument.coupon(error);}
bd_convention fra.pmt_bus_day(error_info option(nullable) error) 	{ return instrument.pmt_bus_day(error);}
day_count_method fra.dc_method(error_info option(nullable) error) 	{ return instrument.dc_method(error);}
number  fra.rate(logical disable_rounding,
				 error_info option(nullable) error) 				{ return instrument.yield( disable_rounding,error);}
number  fra.rate(disc_func disc_func,
				 logical disable_rounding,
				 error_info option(nullable) error)  option(com_name: 'rate_fit') {	return instrument.yield( disc_func,disable_rounding,error);}

string fra.fixing_code(error_info option(nullable) error) 			{ return instrument.fixing_code(error) ;}
ir_index fra.ir_index(error_info option(nullable) error) 			{ return instrument.ir_index(error) ;}
string fra.index_tenor(error_info option(nullable) error)			{ return instrument.index_tenor(error) ;}
tenor_code fra.index_tenor_code(error_info option(nullable) error) 	{ return instrument.index_tenor_code(error);}
calendar fra.fixing_calendar(error_info option(nullable) error) 	{ return instrument.fixing_calendar(error) ;}
string fra.fixing_calendar_name(error_info option(nullable) error) option(hidden)	{ return instrument.fixing_calendar_name(error) ;}
date fra.index_maturity(error_info option(nullable) error) 			{ return instrument.index_maturity(error) ;}
date fra.fixing_date(error_info option(nullable) error) 			{ return instrument.fixing_date(error);}
string fra.fixing_curve(error_info option(nullable) error) 			{ return instrument.fixing_curve(error);}
string fra.fixing_instr(error_info option(nullable) error) 			{ return instrument.fixing_instr(error);}
string fra.fixing_instr_qs(error_info option(nullable) error) 		{ return instrument.fixing_instr_qs(error);}

/*-----------------------------------------------------------------------
  maturity_blend   <hidden>  
  ----------------------------------------------------------------------*/
date fra.maturity_blend(error_info option(nullable) error)  option(hidden)
{	
	return index_maturity(error) ;
}

/*-----------------------------------------------------------------------
  contract_size
  ----------------------------------------------------------------------*/
/*number  fra.contract_size(error_info option(nullable) error)
{	
	return fut_contract_size(error);
}
*/
//-----------------------------------------------------------------------
//  fra: settle_amount
//----------------------------------------------------------------------
number  fra.settle_amount(	number  				market_rate,
							number option(nullable)	contract_rate,
							number option(nullable)	nominal,											
							logical					disc_to_trade,
							disc_func option(nullable)	disc_func,
							logical option(nullable) sign_lend,
							error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__fra_settle_amount(market_rate,contract_rate,nominal,disc_to_trade,disc_func,sign_lend,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fra.settle_amount");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra.settle_amount");	
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  fra: settle_amount
	useful for nasdaq/omx monthly settlement calculations
	(NASDAQ employs monthly cash settlement for STIBOR-FRA forwards, the position 
	is marked to market on the final business day of each month.) 
  ----------------------------------------------------------------------*/
number  fra.settle_amount(	number  				market_rate,
							number option(nullable)	contract_rate,
							number option(nullable)	nominal,	
							logical					disc,
							date option(nullable)	disc_date,
							number option(nullable)	disc_rate,
							logical option(nullable) sign_lend,
							error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__fra_settle_amount(market_rate,contract_rate,nominal,disc,disc_date,disc_rate, sign_lend,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fra.settle_amount");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra.settle_amount");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  fra: settle_amount_df
  ----------------------------------------------------------------------*/
number  fra.settle_amount_df(	disc_func 				disc_func,
								number option(nullable)	contract_rate,
								number option(nullable)	nominal,											
								logical					disc_to_trade,
								disc_func option(nullable)	disc_func_disc,
								logical option(nullable) sign_lend,
								error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__fra_settle_amount_df(disc_func,contract_rate,nominal,disc_to_trade,disc_func_disc,sign_lend,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fra.settle_amount_df");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra.settle_amount_df");
		return null<number>;
	}	
}


/*-----------------------------------------------------------------------
  fra: settle_amount_df
  ----------------------------------------------------------------------*/
number  fra.settle_amount_df(	fwd_func 				fwd_func,
								number option(nullable)	contract_rate,
								number option(nullable)	nominal,											
								logical					disc_to_trade,
								disc_func option(nullable)	disc_func_disc,
								logical option(nullable) sign_lend,
								error_info option(nullable) error)
option(com_name: 'settle_amount_df_fwd_func')	
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__fra_settle_amount_df(fwd_func,contract_rate,nominal,disc_to_trade,disc_func_disc,sign_lend,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fra.settle_amount_df");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra.settle_amount_df");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  fra: cash_flow_dates
  ----------------------------------------------------------------------*/
vector(date) fra.cash_flow_dates(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;
		vector(date) dates;	
		vector(number) a;	
		i().__fra_cash_flows(100,true,true,false,dates,a,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fra.cash_flow_dates");	
		return e ? null<vector(date)>: dates;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra.cash_flow_dates");
		return null<vector(date)>;
	}
}

/*-----------------------------------------------------------------------
  fra: cash_flow_dates
  ----------------------------------------------------------------------*/
vector(date) fra.cash_flow_dates(	logical post_settle,
									logical adj_dates, 
									logical keep_size,
									error_info option(nullable) error)
{	
	return this.cash_flow_dates(error );
}

/*-----------------------------------------------------------------------
  fra: cash_flows

  ----------------------------------------------------------------------*/
/*void fra.cash_flows(	logical					borrow,
						number option(nullable) nominal,
						logical					imp_loan_flow,
						out vector(date)   option(nullable)	dates,
						out vector(number)  	amounts,	
						error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__fra_cash_flows(nominal,borrow,imp_loan_flow,false,dates,amounts,t, s);
		set_error(error,t,s);
		if(error.is_error()){ 
			dates = null<vector(date)>;
			amounts = null<vector(number)>;
		}		
		return ;						
	}
	catch {
		set_error(error,ERR_T_CALC,err.message());
		return ;
	}
}

*/
/*-----------------------------------------------------------------------
  fra: cash_flows
  ----------------------------------------------------------------------*/
vector(number) fra.cash_flows(	logical					borrow,
								number option(nullable) nominal,
								logical					imp_loan_flow,
								error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;
		vector(date) d;	
		vector(number) amounts;	
		i().__fra_cash_flows(nominal,borrow,imp_loan_flow,false,d,amounts,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fra.cash_flows");	
		return e ? null<vector(number)>: amounts;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra.cash_flows");
		return null<vector(number)>;
	}
}

/*-----------------------------------------------------------------------
  fra: cash_flows_cpn
  ----------------------------------------------------------------------*/
vector(number) fra.cash_flows_cpn(	logical					borrow,
									number option(nullable) nominal,
									error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;
		vector(date) d;	
		vector(number) amounts;	
		i().__fra_cash_flows(nominal,borrow,true,true,d,amounts,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fra.cash_flows_cpn");	
		return e ? null<vector(number)>: amounts;				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra.cash_flows_cpn");
		return null<vector(number)>;
	}
}

/*-----------------------------------------------------------------------
  fra: cash_flows_cpn
  ----------------------------------------------------------------------*/
vector(number) fra.cash_flows_cpn(number option(nullable) nominal ,
										logical post_settle, 
										logical keep_size,
										error_info option(nullable) error)
{	
	return this.cash_flows_cpn(false,nominal,error);
}

/*-----------------------------------------------------------------------
  fra: cash_flows
  ----------------------------------------------------------------------*/
vector(number) fra.cash_flows(number option(nullable) nominal ,
										logical post_settle, 
										logical keep_size,
										error_info option(nullable) error)
{	
	return this.cash_flows(false,nominal,true,error);
}


/*-----------------------------------------------------------------------
  fra: cash_flow_data
  ----------------------------------------------------------------------*/
void fra.cash_flow_data(	logical					borrow,
							number option(nullable) nominal,
							logical					imp_loan_flow,						
							out vector(date)   dates,
							out vector(number)   amounts,								
							error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__fra_cash_flows(nominal,borrow,imp_loan_flow,false,dates,amounts,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fra.cash_flow_data");	
		if(e){ 
			dates = null<vector(date)>;
			amounts = null<vector(number)>;
		}		
		return ;						
	}
	catch {
		dates = null<vector(date)>;
		amounts = null<vector(number)>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra.cash_flow_data");
		return ;
	}
}

/*-----------------------------------------------------------------------
  fra: cash_flow_data
  ----------------------------------------------------------------------*/
void fra.cash_flow_data(	number option(nullable) nominal,
							logical 				post_settle,
							ir_cf_code 				cf_code,
							logical 				adj_dates, 
							logical 				keep_size,
							out vector(date)   		dates,
							out vector(number)   	amounts,								
							error_info option(nullable) error)
{	
	try {
		error_info ee = error_info(true,true);
		dates = this.cash_flow_dates(ee);			

		if(cf_code == ir_cf_code.COUPON){
			amounts = this.cash_flows_cpn(false,nominal,ee);
		}
		else if(cf_code == ir_cf_code.PRINCIPAL){
			vector(number) cpn = this.cash_flows_cpn(false,nominal,ee);
			amounts = this.cash_flows(false,nominal,true,ee);
			amounts[1] -= cpn[1]; 
		}
		else {
			amounts = this.cash_flows(false,nominal,true,ee);
		}
	}
	catch {
		dates = null<vector(date)>;
		amounts = null<vector(number)>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra.cash_flow_data");
		return;
	}
}

/*-----------------------------------------------------------------------
  fra: settle_amount_to_market_rate 
  ----------------------------------------------------------------------*/
number fra.settle_amount_to_market_rate(number amount_pcnt,
										number option(nullable)	contract_rate,								
										logical option(nullable) sign_lend,
										error_info option(nullable) error)	
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__fra_settle_amount_to_mkt_rate(amount_pcnt,contract_rate,sign_lend,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fra.settle_amount_to_market_rate");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra.settle_amount_to_market_rate");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  fra: settle_amount_to_rate 
  ----------------------------------------------------------------------*/
number  fra.settle_amount_to_contract_rate(	number amount_pcnt,
											number option(nullable)	market_rate,								
											logical option(nullable) sign_lend,
											error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__fra_settle_amount_to_contract_rate(amount_pcnt,market_rate,sign_lend,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fra.settle_amount_to_contract_rate");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra.settle_amount_to_contract_rate");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
   par_rate
  ----------------------------------------------------------------------*/
number  fra.par_rate(	disc_func		disc_func,
						error_info option(nullable) error)
{
	try{
		instr_error_type t;
   		string 			s;	
		number c = i().__df_to_par_coupon(disc_func,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fra.par_rate");
		return e ? null<number>: c;	
		
		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra.par_rate");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
   par_rate
  ----------------------------------------------------------------------*/
number  fra.par_rate(	fwd_func		fwd_func,
						error_info option(nullable) error)
{
	try{
		instr_error_type t;
   		string 			s;	
		number c = i().__f_to_par_coupon(fwd_func,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fra.par_rate");
		return e ? null<number>: c;	
		
		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra.par_rate");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  set_date  (a version without settledate as argument)
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
fra fra.set_date(	date  				trade_date, 					
					logical 			re_init_static, 
					logical 			re_init_quote, 
					error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,null<date>,re_init_static,re_init_quote,error);
	return null(cc) ? null<fra>: dynamic_cast<fra>(cc);
	
}

/*-----------------------------------------------------------------------
  bill: set_date <protected>
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
fra fra.set_date(	date  				trade_date, 
					date  option(nullable)	settle_date,
					logical 			re_init_static, 
					logical 			re_init_quote, 
					error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,null<date>,re_init_static,re_init_quote,error);
	return null(cc) ? null<fra>: dynamic_cast<fra>(cc);
	
}

/*-----------------------------------------------------------------------
  set_date <protected/legacy>
	quote is NOT kept even if trade_date is unchanged
  ----------------------------------------------------------------------*/
fra fra.set_date(	date  				trade_date, 
					logical 			re_init_static, 
					error_info option(nullable) error) 

{	
	instrument cc = instrument._set_date(trade_date,re_init_static,error);
	return null(cc) ? null<fra>: dynamic_cast<fra>(cc);	
}

/*-----------------------------------------------------------------------
   move_date  <protected/legacy>
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	if trade date is the same --> the settle date will be preserved	
  ----------------------------------------------------------------------*/
fra fra.move_date(	date  				trade_date, 
					date option(nullable) settle_date,
					error_info option(nullable) error) 
{	
	instrument cc = instrument._move_date(trade_date,null<date>,error);
	return null(cc) ? null<fra>: dynamic_cast<fra>(cc);
}

/*-----------------------------------------------------------------------
  fra: set_yield
  ----------------------------------------------------------------------*/
fra fra.set_yield(	number 	option(nullable) rate,
					error_info option(nullable) error)
{	
	instrument cc = instrument._set_yield(	rate, null<date>, null<date>,true, error);
	return null(cc) ? null<fra>: dynamic_cast<fra>(cc);
}


/*-----------------------------------------------------------------------
  fra: set_rate
  ----------------------------------------------------------------------*/
fra fra.set_rate(	number 	option(nullable) rate,
					error_info option(nullable) error)
{	
	instrument cc = instrument._set_yield(	rate, null<date>, null<date>,true, error);
	return null(cc) ? null<fra>: dynamic_cast<fra>(cc);
}


/*-----------------------------------------------------------------------
  fra: set_rate
  ----------------------------------------------------------------------*/
fra fra.set_rate(	number 	option(nullable) rate,
					date  	option(nullable) trade_date, 
					logical option(nullable) set_to_par,
					error_info option(nullable) error) option(com_name: 'set_rate_ext')
{	
	instrument cc = instrument._set_yield(	rate, trade_date,  null<date>,set_to_par, error);
	return null(cc) ? null<fra>: dynamic_cast<fra>(cc);
}



/*-----------------------------------------------------------------------
  fra: set_quote_from_rate
  ----------------------------------------------------------------------*/
fra fra.set_quote_from_rate(	number 	option(nullable) rate,
								logical option(nullable) set_to_par,
								error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote_from_yield(rate,  set_to_par,error);
	return null(cc) ? null<fra>: dynamic_cast<fra>(cc);
}


/*-----------------------------------------------------------------------
  fra: set_quote 
  ----------------------------------------------------------------------*/
fra fra.set_quote(	number 	option(nullable) quote,
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, true,error);
	return null(cc) ? null<fra>: dynamic_cast<fra>(cc);
}


/*-----------------------------------------------------------------------
  fra: set_quote 
  ----------------------------------------------------------------------*/
fra fra.set_quote(	number 	option(nullable) quote,
							date  	option(nullable) trade_date, 
							//date  	option(nullable) settle_date, 
							logical option(nullable) set_to_par,
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,trade_date, null<date>, set_to_par,error);
	return null(cc) ? null<fra>: dynamic_cast<fra>(cc);
}

/*-----------------------------------------------------------------------
  fra: set_quote 
  ----------------------------------------------------------------------*/
fra fra.set_quote(	string 	option(nullable) quote_side,
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, true,error);
	return null(cc) ? null<fra>: dynamic_cast<fra>(cc);
}

/*-----------------------------------------------------------------------
  fra: set_quote
  ----------------------------------------------------------------------*/
fra fra.set_quote(	string 	option(nullable) quote_side,
					date  	option(nullable) trade_date, 
					//date  	option(nullable) settle_date, 
					logical option(nullable) set_to_par,
					error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,trade_date, null<date>, set_to_par,error);
	return null(cc) ? null<fra>: dynamic_cast<fra>(cc);
}


module CORE_INT_FRA
{
	
	/*-----------------------------------------------------------------------
	  risk_ladder_fwd
	  ----------------------------------------------------------------------*/
	void  risk_ladder_fwd(	fra 				f,
							logical 			sign_borrow,
							number 				nominal,
							vector(fwd_func) 	f_v_pert,
							fwd_func 			f_base,
							fwd_func option(nullable) f_all,
							out vector(number) 	pv_diff_pert,
							out number 			pv_diff_all,
							number				y_shift,
							error_info option(nullable) error ) 
	{
		error_info ee 			= new error_info(true,true);
		//number sign 			= sign_borrow ? 1.0:-1.0; 
				
		integer size = v_size(f_v_pert);
		resize(pv_diff_pert,size);
		pv_diff_pert = 0;

		date d 					= f.trade_date();
		date stl				= f.settle_date();
		number per 				= (stl-d)/365.0;
		
		number  market_rate 	= f_base.fwd(per) ;
		number  contract_rate 	= market_rate;
		number pv_base 			= f.settle_amount(market_rate,contract_rate, nominal,false, null<disc_func> ,!sign_borrow, ee);

		number shift_mult 		= 0.0001 / y_shift;	
		number mult 			= /*sign**/shift_mult;
		
		QL_FAIL_COND(ee.is_error(), ee.message(), f.name(), true);
		
		for(integer i=0;i<size;i++){
			QL_FAIL_COND(null(f_v_pert[i]), "fwd_func in vector not valid", f.name(), true);
			
			market_rate = f_v_pert[i].fwd(per) ;
			number pvi 	= f.settle_amount(market_rate,contract_rate, nominal,false, null<disc_func> ,!sign_borrow, ee);
			QL_FAIL_COND(ee.is_error(), ee.message(), f.name(), true);			
			pv_diff_pert[i] = (pvi - pv_base)*mult;			
		
		}
		if(!null(f_all)){

			market_rate 	= f_all.fwd(per) ;
			number pv_all 	= f.settle_amount(market_rate,contract_rate, nominal,false, null<disc_func> ,!sign_borrow, ee);
			QL_FAIL_COND(ee.is_error(), ee.message(), f.name(), true);			
			pv_diff_all = (pv_all - pv_base)*mult;
		}
		else {
			pv_diff_all = null<number>;
		}
			
	}
}

/*-----------------------------------------------------------------------
  risk_ladder_fwd
  ----------------------------------------------------------------------*/
void  fra.risk_ladder_fwd(	logical 					is_long,
							vector(fwd_func) 			f_v_pert,
							fwd_func 					f_base,
							fwd_func option(nullable) 	f_all,
							number 						y_shift,
							out vector(number) 			pv_diff_pert,
							out number 					pv_diff_all,								
							error_info option(nullable) error ) 
{
	error_info ee = new error_info(true,true);
	number nom = nominal(ee);
	CORE_INT_FRA.risk_ladder_fwd(this,is_long, nom,f_v_pert, f_base, f_all, pv_diff_pert, pv_diff_all, y_shift, error );

	
	
}