option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	frn
	--------------------------------------------------------------------
*/

//-----------------------------------------------------------------------
//  class frn
//----------------------------------------------------------------------
class frn : public instrument
option(category: "Instrument/Frn")
//option(allow_undeclared_mfuncs)
{
public:

	//override string			instr_type_s();
	override instrument 	inst();

	/*---add funcs---*/
	override void 			add_nominal(number );	
	void 					add_quote(number,number  option(nullable) ,number );
	void 					add_fixing(	vector(date) option(nullable),vector(number) option(nullable) ,number option(nullable) ,
				    					number option(nullable) ,number option(nullable) ,number option(nullable) ,logical  option(nullable));
	void 					add_zero_floor_value(number  option(nullable) );
	void					add_zero_floor_model(cap_model ,number ,number  option(nullable) =null<number>);

	//--general--	
	override logical 		eom(error_info option(nullable) = null<error_info>);	
	override string 		maturity_code(error_info option(nullable) = null<error_info>);
	override bd_convention 	pmt_bus_day(error_info option(nullable) = null<error_info>);	
	override date 			next_cpn_date(error_info option(nullable) = null<error_info>);
	override date 			previous_cpn_date(error_info option(nullable) = null<error_info>);		
	override date 			first_cpn_date(error_info option(nullable) = null<error_info>);
	override date 			first_settle_date(error_info option(nullable) = null<error_info>);
	override day_count_method accr_dc_method(error_info option(nullable) = null<error_info>);			
	override number 		first_coupon_rate(error_info option(nullable) = null<error_info>);
	number 					current_coupon_rate(error_info option(nullable) = null<error_info>);	
	override  number 		first_cpn_amount(error_info option(nullable) = null<error_info>);		
	override  number 		last_cpn_amount(error_info option(nullable) = null<error_info>);			
	override  number 		next_cpn_amount(error_info option(nullable) = null<error_info>);		/*hidden*/
	number 					current_cpn_amount(error_info option(nullable) = null<error_info>);
	override  date 			cpn_start_date(error_info option(nullable) = null<error_info>);				
	override  date 			next_excpn_date(error_info option(nullable) = null<error_info>);				
	override  date 			last_reg_cpn_date(error_info option(nullable) = null<error_info> );		
	override  logical 		is_regular_first(error_info option(nullable) = null<error_info>);			
	override  logical 		is_regular_last(error_info option(nullable) = null<error_info>);					
	override  number 		redemp_price(error_info option(nullable) = null<error_info>);			
	override  integer 		roll_day(error_info option(nullable) = null<error_info>);							
	override  string 		excpn_code(error_info option(nullable) = null<error_info>);			
	override  number 		issued_amount(error_info option(nullable) error = null<error_info> );

	number 					zero_floor_value_ext(error_info option(nullable) = null<error_info>);	
	number 					zero_floor_vol(error_info option(nullable)= null<error_info>);		

	integer 				rfr_pmt_lag(error_info option(nullable) = null<error_info>);
	integer 				rfr_pmt_lag_prin(error_info option(nullable) = null<error_info>);
	rfr_arrears_type 		rfr_arr_type(error_info option(nullable) error = null<error_info>);
	integer 				rfr_arr_days(error_info option(nullable) error = null<error_info>);
	logical 				is_rfr(error_info option(nullable) error = null<error_info>);
	logical					is_rfr_idx(error_info option(nullable) error = null<error_info>);
	//-----cashflow-funcs-----
	//cashflows override funcs (without suffix) are based on available fixing data
	//cashflows with _crv suffix will calculate cashflows based on curve input (both fwd_func and disc_func versions are provided)
	//cashflows with _dm suffix will calculate cashflows as they are implied from the discount margin calculation (per mkt standard)
	
	void 					cash_flow_data(	number option(nullable) ,logical ,ir_cf_code ,logical,logical,
												logical ,out vector(date)   ,
												out vector(number)   ,error_info option(nullable)= null<error_info>);
	
	vector(number) 			cash_flows(	number option(nullable) ,logical ,ir_cf_code ,logical,
										logical,error_info option(nullable)= null<error_info>);

	vector(number) 			cash_flows_crv(	disc_func option(nullable),number option(nullable) fwd_spread = 0,
											number option(nullable) nominal = 100,logical from_settle = true, ir_cf_code cf = ir_cf_code.TOTAL,
											logical incl_floor_fixed = true,logical incl_floor_fwd = true,logical keep_size = false,
											error_info option(nullable) error = null<error_info>);
	
	vector(number) 			cash_flows_crv(	fwd_func option(nullable),number option(nullable) fwd_spread = 0,
											number option(nullable) nominal = 100,logical from_settle = true,ir_cf_code cf = ir_cf_code.TOTAL, 
											logical incl_floor_fixed = true,logical incl_floor_fwd = true,logical keep_size = false,
											error_info option(nullable) error = null<error_info>);

	number 					zero_floor_value(fwd_func option(nullable),number option(nullable),disc_func option(nullable), 
											number option(nullable),number option(nullable),number option(nullable),
											 error_info option(nullable) error= null<error_info>);
	
	void					cash_flow_data_crv(	fwd_func option(nullable),number option(nullable) ,number option(nullable) ,logical ,
											ir_cf_code ,logical ,logical ,logical ,logical,out vector(date)   ,
											out vector(number), out vector(string)  ,error_info option(nullable) = null<error_info>);

	void					cash_flow_data_crv(	disc_func option(nullable),number option(nullable) ,number option(nullable) ,logical ,
											ir_cf_code ,logical ,logical ,logical ,logical,out vector(date)   ,
											out vector(number),out vector(string)   ,error_info option(nullable)= null<error_info> );

	vector(number) 			cash_flows_dm(	number option(nullable),number option(nullable),number option(nullable) ,ir_cf_code ,
											logical ,error_info option(nullable) = null<error_info>);

	
	//----risk----
	override number 		mac_dur(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) = null<error_info>); 
	override number 		mod_dur(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) = null<error_info>); 
	override number 		dol_dur(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) = null<error_info>); 
	override number 		convexity(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) = null<error_info>); 
	override number 		dol_convexity(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) = null<error_info>); 
	override number 		sensitivity(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) = null<error_info>); 

	number 					mac_dur_dm(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) = null<error_info>); 
	number 					mod_dur_dm(/*number option(nullable) delta = 0.0001,*/error_info option(nullable) = null<error_info>); 
	number 					pvbp_r(number option(nullable),number  option(nullable),error_info option(nullable)= null<error_info>);
	number 					pvbp_dm(number option(nullable),number  option(nullable),error_info option(nullable)= null<error_info>);
	number 					pvbp_dm(number ,number ,number option(nullable) ,number option(nullable) ,
									error_info option(nullable) = null<error_info>);
	number 					pvbp_r(	number ,number ,number option(nullable) ,number option(nullable) ,
									error_info option(nullable) = null<error_info>);

	number 					dirty_diff_crv(	number option(nullable),..quote_style option(nullable),disc_func option(nullable) ,number ,disc_func,
											number,out number  option(nullable),out number  option(nullable) ,
											error_info option(nullable)= null<error_info>);
	number 					dirty_diff_crv(	number option(nullable),..quote_style option(nullable),fwd_func option(nullable) ,number ,disc_func,
											number,out number  option(nullable),out number  option(nullable) ,
											error_info option(nullable)= null<error_info>);


	//----price----	
	override number 		yield(logical disable_rounding,error_info option(nullable)= null<error_info> );
	override number 		clean_price(logical disable_rounding = false ,logical in_pcnt = true,error_info option(nullable)= null<error_info>);
	override number 		dirty_price(logical disable_rounding = false ,logical in_pcnt = true,error_info option(nullable)= null<error_info>);
	number 					yield(number ,number option(nullable) ,number option(nullable),error_info option(nullable) = null<error_info>);
	/*number 					accrued_dm(logical in_pcnt, 
										number option(nullable) fallback_index_rate,
										error_info option(nullable) = null<error_info>);//EXPERIMENTAL, insecurity regarding rfr style frn's*/ 
	
	number 					accrued(logical ,number option(nullable),error_info option(nullable)= null<error_info>);
	override number 		accrued(logical disable_rounding = false,logical in_pcnt = true,
									error_info option(nullable) error = null<error_info>);									
	override number 		accrued_chg(integer,out number,out date ,out date ,		
											logical in_pcnt = true,error_info option(nullable) error = null<error_info>) ; 
	override number 		accrued_period(error_info option(nullable)= null<error_info>);
	override integer		accrued_days(error_info option(nullable) error= null<error_info>);
	number 					disc_margin(error_info option(nullable) = null<error_info>);
	number 					disc_margin(number ,number option(nullable) ,number option(nullable) ,
										error_info option(nullable) = null<error_info>);
	
	number 					zero_floor_strike(	logical, error_info option(nullable) = null<error_info>);

	number 					zero_floor_intrinsic(fwd_func option(nullable) ,number option(nullable) ,disc_func,number option(nullable) ,number option(nullable),
									out vector(number)   ,out vector(number)   ,logical keep_size = false,
									error_info option(nullable) error = null<error_info>);

	number 					zero_floor_intrinsic_dm(number ,number option(nullable),number option(nullable) ,													
													out vector(number),out vector(number),
													logical disable_rounding = false,error_info option(nullable) error = null<error_info> );

	number 					disc_spread_crv(number option(nullable),..quote_style option(nullable) ,disc_func option(nullable) ,number option(nullable),
											disc_func,number option(nullable),number option(nullable),error_info option(nullable)= null<error_info>);
	
	number 					disc_spread_crv(number option(nullable),..quote_style option(nullable) ,fwd_func option(nullable) ,number option(nullable),
											disc_func,number option(nullable),number option(nullable),error_info option(nullable)= null<error_info>);

	number 					yield_crv(	number option(nullable) ,..quote_style option(nullable) ,fwd_func  option(nullable) ,
										number  option(nullable),number option(nullable),disc_func,number option(nullable),
										error_info option(nullable)= null<error_info>);

	
	number 					dirty_price(number ,number option(nullable),number option(nullable) ,
										logical disable_rounding = false,error_info option(nullable) error = null<error_info> );

	number 					clean_price(number ,number option(nullable),number option(nullable) ,
										logical disable_rounding = false,error_info option(nullable) error = null<error_info> );

	void					price_data_crv(fwd_func  option(nullable),number option(nullable),out vector(number) ,
    										out vector(number),out vector(number),out vector(logical) ,	
											error_info option(nullable) error= null<error_info>);

	void 					price_crv(disc_func option(nullable),number option(nullable),disc_func,number option(nullable),
										disc_func  option(nullable),number option(nullable),number option(nullable),
										number option(nullable),number option(nullable)	,
										out number,out number,out number	,
										out number,logical disable_rounding = false ,									
										error_info option(nullable) error = null<error_info>);
	
	void 					price_crv(fwd_func option(nullable),number option(nullable),disc_func,number option(nullable),
										disc_func  option(nullable),number option(nullable),
										number option(nullable),number option(nullable)	,number option(nullable),out number,
										out number,out number	,
										out number,logical disable_rounding = false ,									
										error_info option(nullable) error = null<error_info>);

	void					price_crv(	fwd_func  option(nullable),number  option(nullable),disc_func , number	option(nullable),							
										number option(nullable),number option(nullable),out number,out number,out number, logical ,																	
										error_info option(nullable) = null<error_info>);

	void					price_crv(	disc_func  option(nullable),number  option(nullable),disc_func , number	option(nullable),							
										number option(nullable),number option(nullable),out number,out number,out number, logical ,																	
										error_info option(nullable) = null<error_info>);
	
	number 					asw_par_spread(	fwd_func,number option(nullable) ,disc_func,number option(nullable) ,disc_func option(nullable),
									    	number option(nullable) ,number option(nullable) ,day_count_method 	,bd_convention ,integer ,
											logical ,..calendar ,fwd_func option(nullable) ,disc_func option(nullable) , 
											out number,out number ,out number,
											out number,error_info option(nullable)= null<error_info> );

	number 					present_value_crv(	fwd_func option(nullable),number option(nullable) ,
												disc_func,number option(nullable),number option(nullable) ,	
												disc_func option(nullable),number option(nullable) 	,number option(nullable)  ,
												out number	option(nullable) ,error_info option(nullable)= null<error_info>);

	number 					present_value_crv(	disc_func option(nullable),number option(nullable) ,
												disc_func,number option(nullable),number option(nullable) ,	
												disc_func option(nullable),number option(nullable) 	,number option(nullable)  ,
												out number	option(nullable),error_info option(nullable)= null<error_info>);


	void					disc_margin_rates(fwd_func ,number,disc_func,number,out number,
											out number	,error_info option(nullable) = null<error_info>);


	void					disc_margin_rates(disc_func ,number,disc_func,number,out number,
											out number	,error_info option(nullable)= null<error_info> );

	//oadm
	number 					disc_margin_opt_adj(number ,..quote_style option(nullable),number option(nullable) ,
												number option(nullable),fwd_func option(nullable),
												number option(nullable) ,disc_func ,number option(nullable),number  option(nullable)  ,	
												out number  option(nullable),error_info option(nullable) = null<error_info>);


	number 					dirty_price_oadm(	number ,number option(nullable) ,number option(nullable),fwd_func  option(nullable),
									number option(nullable) ,disc_func ,number option(nullable),number  option(nullable) ,logical, 	
									error_info option(nullable)= null<error_info> );

	number 					clean_price_oadm(	number ,number option(nullable) ,number option(nullable),fwd_func  option(nullable),
									number option(nullable) ,disc_func ,number option(nullable),number  option(nullable) ,logical, 	
									error_info option(nullable) = null<error_info>);


	//--------
	override calendar 		fixing_calendar(error_info option(nullable) = null<error_info>);				
	override string 		fixing_calendar_name(error_info option(nullable) = null<error_info>);		
	override string 		fixing_code(error_info option(nullable) = null<error_info>);			
	override string 		fixing_curve(error_info option(nullable) error= null<error_info>) ;	
	override string 		fixing_instr(error_info option(nullable) error= null<error_info>) ;
	override string 		fixing_instr_qs(error_info option(nullable) error= null<error_info>) ;

	//override date 			index_maturity(error_info option(nullable) );	

	override ir_index 		ir_index(error_info option(nullable) = null<error_info>); 	
	override date			fixing_date(error_info option(nullable)= null<error_info>);
	date					current_fixing_date(error_info option(nullable)= null<error_info>);
	override string 		index_tenor(error_info option(nullable) error= null<error_info>) ;
	override tenor_code 	index_tenor_code(error_info option(nullable) error= null<error_info>) ;
	string 					roll_method(error_info option(nullable)= null<error_info> ) ;
	frn_neg_rate_rule 		neg_rate_rule(error_info option(nullable)= null<error_info>);

	vector(date) 			fixing_dates(	logical from_settle = true,logical keep_size = false,error_info option(nullable) error = null<error_info>);
	vector(number ) 		fixing_rates(	logical from_settle = true,logical keep_size = false,error_info option(nullable) error = null<error_info>);

	void					current_fixing_dates_rfr(out vector(date) ,out vector(date) ,error_info option(nullable));
	//vector(number)			current_fixing_rates_rfr(error_info option(nullable));
	
	
	void 					coupon_data(out vector(date)  ,out vector(date)  	,
										out vector(number)  	,out vector(number)  ,
										logical from_settle = false,logical keep_size = false ,	
										error_info option(nullable) error = null<error_info> );

	number 					fix_margin(error_info option(nullable) error = null<error_info>);
	number 					assumed_index_rate(error_info option(nullable) error = null<error_info>);
	number 					next_index_rate(error_info option(nullable) error = null<error_info>);

	/*
		convexity_cf, pl_intraday
	*/

	/*---set functions-required--*/		
	override frn 			set_quote(number option(nullable),error_info option(nullable));
	override frn 			set_quote(string option(nullable),error_info option(nullable));

	//local set
	frn 					set_quote(number option(nullable) ,number option(nullable),number ,date option(nullable) trade_date  = null<date>, 
										date option(nullable) settle_date = null<date>,error_info option(nullable) error = null<error_info>);

	frn 					set_quote(string option(nullable) ,number option(nullable),number ,date option(nullable) trade_date  = null<date>, 
										date option(nullable) settle_date = null<date>,error_info option(nullable) error = null<error_info>);

	/*---set functions-if applicable--*/						
	override frn  			set_date(date,date option(nullable) s = null<date>,logical r = true,logical rq = true ,error_info option(nullable) error = null<error_info>);
	
	override frn			set_settle_date(date,logical re_initialize /*= true*/, error_info option(nullable) error = null<error_info> );

	override frn 			set_clean_price(number option(nullable),date option(nullable) trade_date  = null<date>,date option(nullable) settle_date = null<date>, 
											error_info option(nullable) error = null<error_info>);

	override frn 			set_dirty_price(number option(nullable),date option(nullable) trade_date  = null<date>,date option(nullable) settle_date = null<date>, 
											error_info option(nullable) error = null<error_info>);
	//local
	frn 					set_disc_margin(number option(nullable) ,date  	option(nullable) trade_date  = null<date>, 
										date option(nullable) settle_date = null<date>,error_info option(nullable) error = null<error_info>);

	frn						set_fixing(	vector(date) option(nullable),vector(number) option(nullable) ,number option(nullable) ,
				    					number option(nullable),number option(nullable) ,number option(nullable) ,logical  option(nullable) , 
										error_info option(nullable));
	fwd_func 				create_fwd_func(disc_func ,error_info option(nullable));
	disc_func 				create_disc_func(fwd_func ,error_info option(nullable));

	frn(__instrument);	
	override frn clone();
	frn(frn);
protected:

	
	override frn 			create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);

	override frn 			set_date(date,logical ,error_info option(nullable) error);								/*legacy*/
	override frn	 		move_date(date,date option(nullable) s = null<date>, error_info option(nullable) error = null<error_info>);  		/*legacy*/  

	override number 		frn_fix_margin(error_info option(nullable) ); 
	override number 		frn_assumed_index_rate(error_info option(nullable) ); 
	override number 		frn_disc_rate_next(error_info option(nullable) ); 
	override number 		frn_disc_margin(error_info option(nullable) ); 
	override number 		frn_disc_margin(number ,number option(nullable) ,number option(nullable) ,
											number option(nullable) next_index_rate = null<number>,error_info option(nullable) error = null<error_info> );
	
	override number 		frn_accrued(number option(nullable),error_info option(nullable));
	override number 		frn_disc_margin_risk_bp(number ,number ,number option(nullable) ,number option(nullable) ,number option(nullable) ,error_info option(nullable) );
	override number 		frn_rate_risk_bp(number ,number ,number option(nullable) ,number option(nullable) ,number option(nullable) ,error_info option(nullable) );

	override number 		frn_dirty_from_disc_margin(number ,number option(nullable),number option(nullable) ,number option(nullable) next_index_rate = null<number>,
										logical disable_rounding = false,error_info option(nullable) error = null<error_info> );
	
	override number 		frn_clean_from_disc_margin(number ,number option(nullable),number option(nullable) ,number option(nullable) next_index_rate = null<number>,
										logical disable_rounding = false,error_info option(nullable) error = null<error_info>);
	
	override string 		frn_roll_method(error_info option(nullable) ) ;

	override vector(number) frn_cash_flows(	disc_func option(nullable),number option(nullable) fwd_spread = 0,
											number option(nullable) nominal = 100,logical from_settle = true,
											logical incl_floor_fixed = true,logical incl_floor_fwd = true,logical keep_size = false,
											error_info option(nullable) error = null<error_info>);
	
	override vector(number) frn_cash_flows(	fwd_func option(nullable),number option(nullable) fwd_spread = 0,
											number option(nullable) nominal = 100,logical from_settle = true,
											logical incl_floor_fixed = true,logical incl_floor_fwd = true,logical keep_size = false,
											error_info option(nullable) error = null<error_info>);
	
	override vector(number) frn_cash_flows_cpn(	disc_func option(nullable),number option(nullable) fwd_spread = 0,
											number option(nullable) nominal = 100,logical from_settle = true,
											logical incl_floor_fixed = true,logical incl_floor_fwd = true,logical keep_size = false,
											error_info option(nullable) error = null<error_info>);
	
	override vector(number) frn_cash_flows_cpn(	fwd_func option(nullable),number option(nullable) fwd_spread = 0,
											number option(nullable) nominal = 100,logical from_settle = true,
											logical incl_floor_fixed = true,logical incl_floor_fwd = true,logical keep_size = false,
											error_info option(nullable) error = null<error_info>);
	
	override ..frn_neg_rate_rule frn_neg_rate_rule(error_info option(nullable));

	override void 			frn_curve_to_price(disc_func,disc_func,number,out number,
										out number	,out number,
										out number,out number	,
										logical disable_rounding = false ,									
										error_info option(nullable) error = null<error_info>);
	
	override void 			frn_curve_to_price(fwd_func,disc_func,number,out number,
										out number	,out number,
										out number,out number	,
										logical disable_rounding = false ,									
										error_info option(nullable) error = null<error_info>);
	
	override void 			frn_coupon_data(out vector(date)  ,out vector(date)  	,
										out vector(number)  	,out vector(number)  ,
										logical from_settle = false,logical keep_size = false ,	
										error_info option(nullable) error = null<error_info> );
	
	override vector(date) 	frn_fixing_dates(error_info option(nullable) error = null<error_info>);
	override logical 		frn_is_odd_first(error_info option(nullable) error = null<error_info>);	/*legacy*/
	override logical 		frn_is_odd_last(error_info option(nullable) error = null<error_info>);	/*legacy*/

	
	
	//---analytic versions of risk funcs are all legacy 
	override number 		mac_dur_analytic(error_info option(nullable));														/*legacy*/
	override number 		mod_dur_analytic(error_info option(nullable));														/*legacy*/
	override number 		dol_dur_analytic(error_info option(nullable));														/*legacy*/
	override number 		pvbp_analytic(number option(nullable) nom = null<number>,
										error_info option(nullable) error = null<error_info>); 									/*legacy*/
	override number 		convexity_analytic(error_info option(nullable));													/*legacy*/
	override number 		dol_convexity_analytic(error_info option(nullable));												/*legacy*/
	override number 		sensitivity_analytic(error_info option(nullable));													/*legacy*/

	//void err_for_rfr();
	//index_instr idx_instr_;
};


//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
frn.frn(__instrument i) option(hidden) : instrument(i)
{
	return; //for now ... since we handle fixings on the dll side
	
	/*error_info ee 		= new error_info(true,true);

	if(!this.is_valid(ee)) {
		idx_instr_ = null<index_instr>;
		return;
	}
	
	..instr_def def 	= instrument.instr_def(ee);
	string idx_instr 	= def.fixing_instr(ee);
	//QL_FAIL_COND(null(idx_instr), "invalid fixing instrument");
	if(null(idx_instr))
		return;
		
	index_map m = get_gl_index_map();

	if(null(m))
		return;
	idx_instr_ 	= m.get_index_instr(idx_instr);
	
	if(null(idx_instr_))
		return;

	logical is_rfr = def.is_frn_rfr();
	
	
	instr_error_type t;
	string 			s;
		
	date td = i.__trade_date(t, s);
	if(null(td) || t != instr_error_type.ERR_T_NONE)
		return;
		
	//date td 	= instrument.trade_date(ee);
	if(!is_rfr) {

		//1. get fixing rates/dates from the instrument
		//2. update current index instrument with valid rates (if no proxy is defined)
		//change this when the dbtool index functionality is done
		//OBS! first and last fixing requires specific handling
		
		number prox_h = i.__frn_fix_proxy_hist(t,s);
		if(t != instr_error_type.ERR_T_NONE || !null(prox_h))
			return;
		
		vector(date) fd = i.__frn_ib_fixing_dates(false,false,t, s);//fixdate==pubdate for ibor style
		if(t != instr_error_type.ERR_T_NONE)
			return;
		
		vector(number) fr = i.__frn_fixing_rates(false,false,t, s);
		if(t != instr_error_type.ERR_T_NONE)
			return;

		integer size = v_size(fd);
		vector(number) r_upd[0];
		vector(date) pd_upd[0];
		vector(number) r_i_upd[0];
		vector(date) pd_i_upd[0];
		for(integer j=0;j<size;j++) {
			if(fd[j] > td)
				break;

			if(null(fr[j])) {//fixing in instrument not available
				number r = idx_instr_.fixing_rate(td,fd[j],true,true);
				if(!null(r)){
					push_back(r_i_upd,r);
					push_back(pd_i_upd,fd[j]);
				}
			}
			else {
				push_back(r_upd,fr[j]);
				push_back(pd_upd,fd[j]);
			}
		}

		if(v_size(pd_upd) > 0)//from instrument to index_instr
			idx_instr_.add_fixing(pd_upd, r_upd, true);
		
		if(v_size(pd_i_upd) > 0) {//from index_instr to instrument
			number first_fixing = null<number>;	//null --> will not update __instrument
			number last_fixing = null<number>;	//null --> will not update __instrument
			number fix_proxy_hist = null<number>;
			number fix_proxy_fwd = null<number>;
			logical allow_fwd_fix = false;
			
			i.__frn_add_fixing(pd_i_upd,r_i_upd,first_fixing,last_fixing,fix_proxy_hist,fix_proxy_fwd,allow_fwd_fix);
			
		}
	}
	else {
		//logical is_rfr_idx = def.instr_def.is_frn_rfr_idx();
		
		vector(date) fd,pd;
		i.__frn_rfr_curr_fixing_dates(fd,pd,t, s);
		if(null(pd) || t != instr_error_type.ERR_T_NONE)
			return;
				
		integer size = v_size(pd);
		vector(number) r_upd[0];
		vector(date) pd_upd[0];
		for(integer j=0;j<size;j++) {
			if(pd[j] > td)
				break;
			if(j>0 && pd[j] == pd[j-1])//with lockout we can have equal dates in vector
				continue;
			number r = idx_instr_.fixing_rate(td,pd[j],true,true);
			if(!null(r)){
				push_back(r_upd,r);
				push_back(pd_upd,pd[j]);
			}
		}
		integer size_upd = v_size(r_upd);
		
		if(size_upd == 0)
			return;

		number first_fixing = null<number>;//not applicable for rfr
		number last_fixing = null<number>;//not applicable for rfr
		number fix_proxy_hist = null<number>;
		number fix_proxy_fwd = null<number>;
		logical allow_fwd_fix = false;
		
		i.__frn_add_fixing(pd_upd,r_upd,first_fixing,last_fixing,fix_proxy_hist,fix_proxy_fwd,allow_fwd_fix);
		
	}*/
}

//------------------------------------------------
// create  [PROTECTED]
// create frn from internal instrument
//------------------------------------------------
frn frn.create(	__instrument option(nullable) c,
				out instr_error option(nullable) error,
				error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<frn>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.FRN, "invalid instrument type",type );//should not happen	
	
	return new frn(c);
}
/*-----------------------------------------------------------------------
  create_frn <FUNCTION>
  ----------------------------------------------------------------------*/

frn create_frn(	__instrument option(nullable) c,
					out instr_error option(nullable) error,
					error_type type = E_INIT)
option(com_name: 'INTERNAL_create_frn')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if(!valid && INSTR_CREATE_NULL_ERR)
		return null<frn>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.FRN, "invalid instrument type",type );//should not happen
	
	return new frn(c);
}

frn create_frn(	__instrument option(nullable) 		c,
				error_info option(nullable) 		error,
				error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_frn_ei')
{
	instr_error ee 	= instr_error();
	frn b 	= create_frn(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_frn");
	return b;
}


//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string frn.instr_type_s()  	{ return string(..instr_type.FRN);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	frn.inst()		{ return this;}
//------------------------------------------------
// copy constructor
//------------------------------------------------
frn.frn(frn c) : instrument(c) {}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
frn frn(frn b)			{ return new frn(b);}
//------------------------------------------------
// clone
//------------------------------------------------
frn frn.clone()				{ return new frn(this);}
//-----------------------------------------------
// dynamic cast <FUNCTION>
//-----------------------------------------------
frn frn(instrument i, error_info option(nullable) error = null<error_info>) 
option (category: 'Instrument/Frn')
option(com_name: 'frn_dyncast') 
{ 
	try {
		frn d = dynamic_cast<frn>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a frn)","frn" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn");
		return null<frn>;
	}
}

/*-----------------------------------------------------------------------
  add_nominal 
  ----------------------------------------------------------------------*/
void frn.add_nominal(number nominal) 
{			
	instrument.add_nominal(nominal );
	return ;						
}
/*-----------------------------------------------------------------------
  add_quote
  ----------------------------------------------------------------------*/
void frn.add_quote(		number  quote,
						number  option(nullable) next_index_rate,
						number  assumed_index_rate)
{	
	i().__frn_add_quote(quote, next_index_rate, assumed_index_rate);
	return ;						
}
/*-----------------------------------------------------------------------
  is_rfr
  ----------------------------------------------------------------------*/
logical frn.is_rfr(error_info option(nullable) error)
{
	try{
		logical c = i().__is_frn_rfr();
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.is_rfr");
		return false;
	}
}

/*-----------------------------------------------------------------------
  is_rfr_idx
  ----------------------------------------------------------------------*/
logical frn.is_rfr_idx(error_info option(nullable) error)
{
	try{
		logical c = i().__is_frn_rfr_idx();
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.is_frn_rfr_idx");
		return false;
	}
}

/*-----------------------------------------------------------------------
  hidden in root members
  ----------------------------------------------------------------------*/


logical frn.eom(error_info option(nullable) error)					{ return instrument.eom(error);}
string 	frn.maturity_code(error_info option(nullable) error)		{ return instrument.maturity_code(error);}
date  	frn.next_cpn_date(error_info option(nullable) error) 		{ return instrument.next_cpn_date(error);}
date  	frn.previous_cpn_date(error_info option(nullable) error) 	{ return instrument.previous_cpn_date(error);}
date  	frn.first_cpn_date(error_info option(nullable) error)		{ return instrument.first_cpn_date(error);}
date  	frn.first_settle_date(error_info option(nullable) error)	{ return instrument.first_settle_date(error);}
bd_convention frn.pmt_bus_day(error_info option(nullable) error) 	{ return instrument.pmt_bus_day(error);}
number  frn.accrued_period(error_info option(nullable) error) 		{ return instrument.accrued_period(error);}
integer	frn.accrued_days(error_info option(nullable) error)			{ return instrument.accrued_days(error);}	
day_count_method frn.accr_dc_method(error_info option(nullable) error) 				{ return instrument.accr_dc_method(error);}
number  frn.first_coupon_rate(error_info option(nullable) error)	{ return instrument.first_coupon_rate(error);}
number  frn.current_coupon_rate(error_info option(nullable) error)		{ return instrument.coupon_rate(error);}
date frn.last_reg_cpn_date(error_info option(nullable) error)		{ return instrument.last_reg_cpn_date(error);}
string frn.excpn_code(error_info option(nullable) error) 			{ return instrument.excpn_code(error);}
logical frn.is_regular_first(error_info option(nullable) error) 	{ return instrument.is_regular_first(error);}
logical frn.is_regular_last(error_info option(nullable) error) 		{ return instrument.is_regular_last(error);}
number  frn.last_cpn_amount(error_info option(nullable) error)		{ return instrument.last_cpn_amount(error);}
number  frn.first_cpn_amount(error_info option(nullable) error)		{ return instrument.first_cpn_amount(error);}
number  frn.current_cpn_amount(error_info option(nullable) error)	{ return next_cpn_amount(error);}
number  frn.next_cpn_amount(error_info option(nullable) error)	option(hidden)	{ return instrument.next_cpn_amount(error);}
number  frn.redemp_price(error_info option(nullable) error)			{ return instrument.redemp_price(error);}
number frn.issued_amount(error_info option(nullable) error)			{ return instrument.issued_amount(error);}
number  frn.accrued_chg(integer 	bus_days_fwd,
						out	number option(nullable)	cpn_cashflow,
						out date 	settle,
						out date 	settle_next,	
						logical 	in_pcnt,								
						error_info option(nullable) error) 		{ return instrument.accrued_chg(bus_days_fwd, cpn_cashflow,settle,settle_next,in_pcnt,error);}
integer  frn.roll_day(error_info option(nullable) error) 		{ return instrument.roll_day( error);}
date frn.next_excpn_date(error_info option(nullable) error) 	{ return instrument.next_excpn_date(error);}
date frn.cpn_start_date(error_info option(nullable) error)		{ return instrument.cpn_start_date(error);}
string frn.fixing_code(error_info option(nullable) error) 		{ return instrument.fixing_code(error) ;} /*Err for RFR*/
string frn.fixing_curve(error_info option(nullable) error) 		{ return instrument.fixing_curve(error);}
string frn.fixing_instr(error_info option(nullable) error) 		{ return instrument.fixing_instr(error);}
string frn.fixing_instr_qs(error_info option(nullable) error) 	{ return instrument.fixing_instr_qs(error);}
ir_index frn.ir_index(error_info option(nullable) error)		{ return instrument.ir_index(error) ;}
string frn.index_tenor(error_info option(nullable) error) 		{ return instrument.index_tenor(error) ;}
tenor_code frn.index_tenor_code(error_info option(nullable) error) 	{ return instrument.index_tenor_code(error);}
calendar frn.fixing_calendar(error_info option(nullable) error) 	{ return instrument.fixing_calendar(error) ;}
string frn.fixing_calendar_name(error_info option(nullable) error) option(hidden) 	{ return instrument.fixing_calendar_name(error) ;}
date frn.fixing_date(error_info option(nullable) error) option(hidden)				{ return instrument.fixing_date(error);}  	/*Err for RFR*/
date frn.current_fixing_date(error_info option(nullable) error) 				{ return this.fixing_date(error);}  			/*Err for RFR*/
logical frn.frn_is_odd_first(error_info option(nullable) error) 				{ return !instrument.is_regular_first(error);}	/*legacy*/
logical frn.frn_is_odd_last(error_info option(nullable) error) 					{ return !instrument.is_regular_last(error);}	/*legacy*/
number frn.frn_fix_margin(error_info option(nullable) error)					{ return this.fix_margin(error);}
number frn.frn_assumed_index_rate(error_info option(nullable) error)  			{ return this.assumed_index_rate(error);}
number frn.frn_disc_rate_next(error_info option(nullable) error) option(hidden) { return this.next_index_rate(error);}
number frn.frn_disc_margin(error_info option(nullable) error)					{ return this.disc_margin(error);}
number frn.frn_accrued(	number option(nullable) fallback_index_rate,
						error_info option(nullable) error)						{ return this.accrued(true,fallback_index_rate,error);}
vector(date) frn.frn_fixing_dates(error_info option(nullable) error)			{ return this.fixing_dates(true ,false , error );}/*Err for RFR*/
string frn.frn_roll_method(error_info option(nullable) error)					{ return this.roll_method(error);}
..frn_neg_rate_rule frn.frn_neg_rate_rule(error_info option(nullable) error) 	{ return this.neg_rate_rule(error);}




vector(number) frn.frn_cash_flows(	disc_func option(nullable)	index_func,
									number option(nullable) 	index_sprd,
									number option(nullable) 	nominal,
									logical 					from_settle,
									logical 					incl_floor_fixed,
									logical 					incl_floor_fwd,
									logical 					keep_size,
									error_info option(nullable) error) { return this.cash_flows_crv(index_func,index_sprd , nominal ,from_settle,
																									ir_cf_code.TOTAL,incl_floor_fixed,incl_floor_fwd,
																									keep_size ,error);}

vector(number) frn.frn_cash_flows(	fwd_func option(nullable)	index_func,
									number option(nullable) 	index_sprd,
									number option(nullable) 	nominal,
									logical 					from_settle,
									logical 					incl_floor_fixed,
									logical 					incl_floor_fwd,
									logical 					keep_size,
									error_info option(nullable) error) 	{ return this.cash_flows_crv(index_func,index_sprd , nominal ,from_settle,
																									ir_cf_code.TOTAL,incl_floor_fixed,incl_floor_fwd,
																									keep_size ,error);}

vector(number) frn.frn_cash_flows_cpn(	disc_func option(nullable)	index_func,
										number option(nullable) 	index_sprd ,
										number option(nullable) 	nominal,
										logical 					from_settle,
										logical 					incl_floor_fixed,
										logical 					incl_floor_fwd,
										logical 					keep_size ,
										error_info option(nullable) error)	{ return this.cash_flows_crv(index_func,index_sprd ,nominal,from_settle,
																									   ir_cf_code.COUPON, incl_floor_fixed , incl_floor_fwd,
																									   keep_size ,error);	}

vector(number) frn.frn_cash_flows_cpn(	fwd_func option(nullable)	index_func,
										number option(nullable) 	index_sprd ,
										number option(nullable) 	nominal,
										logical 					from_settle,
										logical 					incl_floor_fixed,
										logical 					incl_floor_fwd,
										logical 					keep_size ,
										error_info option(nullable) error)	{ return this.cash_flows_crv(index_func,index_sprd ,nominal,from_settle,
																									   ir_cf_code.COUPON,incl_floor_fixed , incl_floor_fwd,
																									   keep_size ,error);}

void frn.frn_coupon_data(	out vector(date)  		fixing_dates,
							out vector(date)  		payment_dates,
							out vector(number)  	fixing_rates,
							out vector(number)  	coupon_rates,
							logical 				from_settle,
							logical 				keep_size ,																
							error_info option(nullable) error) 	{ this.coupon_data(	fixing_dates,payment_dates,fixing_rates,coupon_rates,
																					from_settle,keep_size ,error);	}

//------------------------------------------------
// err_for_rfr
//------------------------------------------------
/*void frn.err_for_rfr()
{
	error_info ee = error_info(true,true);
	logical c = is_frn_rfr(ee);
	if(null(c) || c)
		throw(E_INVALID_ARG,"inapplicable function call for frn-rfr's");
}*/



/*-----------------------------------------------------------------------
  rfr_pmt_lag
  ----------------------------------------------------------------------*/
integer frn.rfr_pmt_lag(error_info option(nullable) error)
{

	try {
		error_info ee = error_info(true,true);
		if(!is_rfr(ee))
			QL_FAIL("function only applicable for frn-rfr's", this, true, E_INIT);
		integer c = this.instr_def(ee).frn_rfr_pmt_lag(ee);
		return c;	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.rfr_pmt_lag");	
		return err_int();
	}
}
/*-----------------------------------------------------------------------
  rfr_pmt_lag_prin
  ----------------------------------------------------------------------*/
integer frn.rfr_pmt_lag_prin(error_info option(nullable) error)
{

	try {
		error_info ee = error_info(true,true);
		if(!is_rfr(ee))
			QL_FAIL("function only applicable for frn-rfr's", this, true, E_INIT);
		   
		integer c = this.instr_def(ee).frn_rfr_pmt_lag_prin(ee);
		return c;	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.rfr_pmt_lag_prin");	
		return err_int();
	}
}

/*-----------------------------------------------------------------------
  rfr_arr_type
  ----------------------------------------------------------------------*/
rfr_arrears_type frn.rfr_arr_type(error_info option(nullable) error) 
{	
	try{
		error_info ee = error_info(true,true);
		if(!is_rfr(ee))
			QL_FAIL("function only applicable for frn-rfr's", this, true, E_INIT);
		rfr_arrears_type c = this.instr_def(ee).frn_rfr_arr_type(ee);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.rfr_arr_type");
		return null<rfr_arrears_type>;
	}
}

/*-----------------------------------------------------------------------
  rfr_arr_days
  ----------------------------------------------------------------------*/
integer frn.rfr_arr_days(error_info option(nullable) error) 
{	
	try{
		error_info ee = error_info(true,true);
		if(!is_rfr(ee))
			QL_FAIL("function only applicable for frn-rfr's", this, true, E_INIT);
		integer c = this.instr_def(ee).frn_rfr_arr_days(ee);
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.rfr_arr_days");
		return err_int();
	}
}

/*-----------------------------------------------------------------------
  create_fwd_func
  ----------------------------------------------------------------------*/
fwd_func frn.create_fwd_func(disc_func df, error_info option(nullable) error)
{

	try {
		error_info ee = error_info(true,true);
		..ir_index ir = this.ir_index(ee);
		CORE_INT.instr_fail_check(null(ir), "invalid ir_index", this, ee);
		integer freq = ir.tenor_code().frequency();
		fwd_func c = fwd_func(	df, freq, this.trade_date(), ir.day_count_method(),
								ir.fixing_calendar(), ir.bd_convention(), ir.eom());
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.create_fwd_func");	
		return null<fwd_func>;
	}
}
/*-----------------------------------------------------------------------
  create_disc_func
  ----------------------------------------------------------------------*/
disc_func frn.create_disc_func(fwd_func f, error_info option(nullable) error)
{

	try {
		error_info ee = error_info(true,true);
		..ir_index ir = this.ir_index(ee);
		CORE_INT.instr_fail_check(null(ir), "invalid ir_index", this, ee);
		integer freq = ir.tenor_code().frequency();
		disc_func c;
		if(freq == 365){
			c = CORE_INT.create_disc_func_from_fwd_on( this.trade_date(),this.maturity(),f,ir.day_count_method(),
									   ir.fixing_calendar(),true);
		}
		else 
			c = disc_func_fwd_roll(f,this.trade_date(),this.maturity(), freq, ir.eom(),
								  ir.fixing_calendar(), ir.bd_convention(), ir.day_count_method());
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.create_disc_func");	
		return null<disc_func>;
	}
}

/*-----------------------------------------------------------------------
  zero_floor_value_ext
  ----------------------------------------------------------------------*/
number frn.zero_floor_value_ext(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_ext_zero_floor_value(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.zero_floor_value_ext");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.zero_floor_value_ext");
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  current_fixing_dates_rfr
  ----------------------------------------------------------------------*/
void frn.current_fixing_dates_rfr(out vector(date) val_dates,out vector(date) pub_dates,error_info option(nullable) error)
{
	try{
		error_info ee = error_info(true,true);
		if(!is_rfr(ee))
			QL_FAIL("function only applicable for frn-rfr's", this, true, E_INIT);

		instr_error_type t;
		string 			s;
		i().__frn_rfr_curr_fixing_dates(val_dates,pub_dates,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.current_fixing_dates_rfr");
		if(e) {
			val_dates = pub_dates = null<vector(date)>;
		}
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.current_fixing_dates_rfr");
		val_dates = pub_dates = null<vector(date)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  current_fixing_dates_rfr
  ----------------------------------------------------------------------*/
/*vector(number) frn.current_fixing_rates_rfr(error_info option(nullable) error)
{
	try{
		error_info ee = error_info(true,true);
		if(!is_rfr(ee))
				QL_FAIL("function only applicable for frn-rfr's");

		instr_error_type t;
		string 			s;
		i().__frn_rfr_curr_fixing_rates(val_dates,pub_dates,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.current_fixing_rates_rfr");
		if(e) {
			val_dates = pub_dates = null<vector(date)>;
		}
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.current_fixing_rates_rfr");
		val_dates = pub_dates = null<vector(date)>;
		return ;
	}
}*/


/*-----------------------------------------------------------------------
  zero_floor_vol
  ----------------------------------------------------------------------*/
number frn.zero_floor_vol(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_zero_floor_vol(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.zero_floor_vol");
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.zero_floor_vol");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  frn: fix_margin
  ----------------------------------------------------------------------*/
number frn.fix_margin(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_fix_margin(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.fix_margin");
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.fix_margin");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  frn: assumed_index_rate
  ----------------------------------------------------------------------*/
number frn.assumed_index_rate(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_assumed_index(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.assumed_index_rate");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.assumed_index_rate");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  next_index_rate
  ----------------------------------------------------------------------*/
number frn.next_index_rate(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_disc_rate_next(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.next_index_rate");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.next_index_rate");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  frn: disc_margin
  ----------------------------------------------------------------------*/
number frn.disc_margin(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_disc_margin(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.disc_margin");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.disc_margin");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  frn: frn_disc_margin
  ----------------------------------------------------------------------*/
number frn.frn_disc_margin(	number clean_price_pcnt,
						number option(nullable) disc_rate_next,
						number option(nullable) assumed_index_rate,
						number option(nullable) next_index_rate,							
						error_info option(nullable) error)
{	
	if(!null(disc_rate_next) && !null(next_index_rate) &&  disc_rate_next != next_index_rate) {
		CORE_INT.catch_error_info(error,E_INVALID_ARG,"disc_rate_next <> next_index_rate is no longer supported", "frn.frn_disc_margin");
		return null<number >;
	}
	if(null(disc_rate_next))
		disc_rate_next = next_index_rate ;
	if(null(next_index_rate))
		next_index_rate = disc_rate_next  ;
	return this.disc_margin(clean_price_pcnt,disc_rate_next,assumed_index_rate, error);
}

/*-----------------------------------------------------------------------
  frn: disc_margin
  ----------------------------------------------------------------------*/
number frn.disc_margin(	number clean_price_pcnt,
						number option(nullable) next_index_rate,
						number option(nullable) assumed_index_rate,
						error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_disc_margin(clean_price_pcnt,next_index_rate,assumed_index_rate,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.disc_margin");
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.disc_margin");
		return null<number >;
	}
}
/*-----------------------------------------------------------------------
  frn: yield
  ----------------------------------------------------------------------*/
number frn.yield(number clean_price_pcnt,
				number option(nullable) next_index_rate,
				number option(nullable) assumed_index_rate,
				error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_yield(clean_price_pcnt,next_index_rate,assumed_index_rate,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.yield");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.yield");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  frn: zero_floor_strike
  ----------------------------------------------------------------------*/
number frn.zero_floor_strike(	logical index_strike,
								error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_zero_floor_strike(index_strike,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.zero_floor_strike");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.zero_floor_strike");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  frn: zero_floor_intrinsic
  ----------------------------------------------------------------------*/
number frn.zero_floor_intrinsic(	fwd_func option(nullable) 	index_func,
									number option(nullable) 	index_sprd,
									disc_func 					disc_func, 
									number option(nullable) 	disc_sprd,  
									number option(nullable) 	nominal,
									out vector(number)   		cpn_r_incl_floor,
									out vector(number)   		cpn_r_excl_floor,
									logical 					keep_size,
									error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_zero_floor_intrins_value(index_func,index_sprd,disc_func,disc_sprd,
													nominal,cpn_r_incl_floor,cpn_r_excl_floor,keep_size,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.zero_floor_intrinsic");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.zero_floor_intrinsic");
		return null<number >;
	}

}

/*-----------------------------------------------------------------------
  zero_floor_intrinsic_dm
  ----------------------------------------------------------------------*/
number frn.zero_floor_intrinsic_dm(	number 					disc_margin,
									number option(nullable) next_index_rate,
									number option(nullable) assumed_index_rate,
									out vector(number)   	cpn_r_incl_floor,
									out vector(number)   	cpn_r_excl_floor,				
									logical					disable_rounding,						
									error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_intrins_from_disc_margin(	disc_margin,next_index_rate,assumed_index_rate,
														disable_rounding,cpn_r_incl_floor,cpn_r_excl_floor,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.zero_floor_intrinsic_dm");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.zero_floor_intrinsic_dm");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  frn: disc_spread_crv  disc_func
  ----------------------------------------------------------------------*/
number frn.disc_spread_crv(	number option(nullable) 		quote,
							..quote_style option(nullable) 	quote_style,
							disc_func  	option(nullable) 	index_disc_func,
							number		option(nullable) 	index_sprd,
							disc_func  						disc_func,
							number	option(nullable)		zero_floor_vol,
							number	option(nullable)		disc_sprd_zero_floor,
							error_info option(nullable) 	error)
{	
	try{
		
		error_info ee = new error_info(true,true);
		fwd_func f = null(index_disc_func) ? null<fwd_func>: create_fwd_func(index_disc_func, ee);
		CORE_INT.instr_fail_check(null(f), "invalid fwd_func", this, ee);
				
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_disc_spread(quote,quote_style,f,index_sprd,disc_func,zero_floor_vol,null<disc_func>,disc_sprd_zero_floor,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.disc_spread_crv");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.disc_spread_crv");	
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  frn: disc_spread_crv fwd_func
  ----------------------------------------------------------------------*/
number frn.disc_spread_crv(	number option(nullable) 	quote,
						..quote_style option(nullable) 	quote_style,
						fwd_func  	option(nullable) 	index_func,
						number	option(nullable)		index_sprd,
						disc_func  						disc_func,
						number	option(nullable)		zero_floor_vol,
    					number	option(nullable)		disc_sprd_zero_floor,
						error_info option(nullable) 	error)
option(com_name: 'disc_spread_crv_fwd_func')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_disc_spread(quote,quote_style,index_func,index_sprd,disc_func,zero_floor_vol,
										 null<disc_func>,disc_sprd_zero_floor,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.disc_spread_crv");
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.disc_spread_crv");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  frn: yield fwd_func
  ----------------------------------------------------------------------*/
number frn.yield_crv(number option(nullable) 		quote,
					..quote_style option(nullable) 	quote_style,
					fwd_func  	option(nullable)	index_func,
					number	option(nullable)		index_sprd,
					number	option(nullable)		zero_floor_vol,
					disc_func  						disc_func_zero_floor,
    				number	option(nullable)		disc_sprd_zero_floor,
					error_info option(nullable) 	error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		//disc_func dfzero = disc_func_interp([1],[1], ip_linear(),RT_CONT);
		number c = i().__frn_disc_spread(quote,quote_style,index_func,index_sprd,null<disc_func>,zero_floor_vol,
										disc_func_zero_floor,disc_sprd_zero_floor,t, s);/*spread vs 0 --> yield*/
		logical e = CORE_INT.add_error_info(error,t,s, "frn.yield_crv");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.yield_crv");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  frn: accrued
  ----------------------------------------------------------------------*/
number frn.accrued(	logical in_pcnt, 
					number option(nullable) fallback_index_rate,
					error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_accrued(in_pcnt,fallback_index_rate,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.accrued");
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.accrued");
		return null<number >;
	}
}

number  frn.accrued(logical disable_rounding,logical in_pcnt,error_info option(nullable) error) 
{	
	return this.accrued(in_pcnt,null<number>,error);
}

/*-----------------------------------------------------------------------
  frn: accrued_dm  EXPERIMENTAL
  ----------------------------------------------------------------------*/
/*number frn.accrued_dm(	logical in_pcnt, 
						number option(nullable) fallback_index_rate,						
						error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;
		logical dm_style = true;
		number c = i().__frn_accrued_ext(in_pcnt,fallback_index_rate,dm_style,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.accrued_ext");
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.accrued_ext");
		return null<number >;
	}
}
*/
/*-----------------------------------------------------------------------
  frn: fixing_dates  only for frn-ib
  ----------------------------------------------------------------------*/
vector(date) frn.fixing_dates(	logical from_settle, 
								logical keep_size ,
								error_info option(nullable) error)
{	
	try{
		if(is_rfr(error))
			return fin_instr.err_type(null<vector(date)>, error,"inapplicable function call for frn-rfr's");
		
		instr_error_type t;
   		string 			s;	
		vector(date) c = i().__frn_ib_fixing_dates(from_settle,keep_size,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.fixing_dates");
		return e ? null<vector(date)>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.fixing_dates");
		return null<vector(date)>;
	}
}

/*-----------------------------------------------------------------------
  frn: fixing_rates  for frn-rfr's we get the comp/avg rate ex spread
  ----------------------------------------------------------------------*/
vector(number) frn.fixing_rates(logical from_settle, 
								logical keep_size ,
								error_info option(nullable) error)
{	
	try{
		//if(is_frn_rfr(error))
			//return fin_instr.err_type(null<vector(number)>, error,"inapplicable function call for frn-rfr's");
		
		instr_error_type t;
   		string 			s;	
		vector(number) c = i().__frn_fixing_rates(from_settle,keep_size,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.fixing_rates");
		return e ? null<vector(number)>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.fixing_rates");
		return null<vector(number)>;
	}
}

/*-----------------------------------------------------------------------
  dirty_diff_crv
FIX_ME: TO BE DECIDED ... scaling of output and signs, normal pvbp is scaled to always return risk per bp (with 
positive sign for positve nominal) but here it is difficult to do the same scaling since we have two independent deltas as input i.e.
it should be possible to have unequal shifts for fwd rates and discounting rates
  ----------------------------------------------------------------------*/
number frn.dirty_diff_crv(	number option(nullable)			quote,
							..quote_style option(nullable) 	quote_style,
							disc_func	option(nullable) 	index_disc_func,
							number 							delta_index_r,
							disc_func						disc_func,
							number 							delta_disc_r,	
							out number 	option(nullable)	fwd_val,
							out number 	option(nullable)	disc_val,						
							error_info option(nullable) 	error)
{	
	try{	
		error_info ee = error_info(true,true);
		fwd_func f = create_fwd_func(index_disc_func, ee);
		CORE_INT.instr_fail_check(null(f), "invalid fwd_func", this, ee);
				
		instr_error_type t;
   		string 			s;
		number c = i().__frn_dirty_diff_crv(quote,quote_style,f,delta_index_r,disc_func,delta_disc_r,fwd_val,disc_val,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.dirty_diff_crv");
		if(e) {
			fwd_val = disc_val = null<number >;
			return null<number >;
		}
		return c;						
	}
	catch {
		fwd_val = disc_val = null<number >;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.dirty_diff_crv");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  dirty_diff_crv	fwd_func
  ----------------------------------------------------------------------*/
number frn.dirty_diff_crv(	number option(nullable)			quote,
							..quote_style option(nullable) 	quote_style,
							fwd_func	option(nullable) 	index_func,
							number 							delta_index_r,
							disc_func						disc_func,
							number 							delta_disc_r,	
							out number 	option(nullable)	fwd_val,
							out number 	option(nullable)	disc_val,						
							error_info option(nullable) 	error)
option(com_name: 'dirty_diff_crv_fwd_func')	
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_dirty_diff_crv(quote,quote_style,index_func,delta_index_r,disc_func,delta_disc_r,fwd_val,disc_val,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.dirty_diff_crv");
		if(e) {
			fwd_val = disc_val = null<number >;
			return null<number >;
		}
		return c;						
	}
	catch {
		fwd_val = disc_val = null<number >;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.dirty_diff_crv");
		return null<number >;
	}
}


/*-----------------------------------------------------------------------
  frn: frn_dirty_from_disc_margin
  ----------------------------------------------------------------------*/
number frn.frn_dirty_from_disc_margin(	number disc_margin,
										number option(nullable) disc_rate_next,
										number option(nullable) assumed_index_rate,
										number option(nullable) next_index_rate,
										logical disable_rounding,
										error_info option(nullable) error) 
{
	if(!null(disc_rate_next) && !null(next_index_rate) &&  disc_rate_next != next_index_rate) {		
		CORE_INT.catch_error_info(error,E_INVALID_ARG,"disc_rate_next <> next_index_rate is no longer supported", "frn.frn_dirty_from_disc_margin");
		return null<number >;
	}
	if(null(disc_rate_next))
		disc_rate_next = next_index_rate ;
	if(null(next_index_rate))
		next_index_rate = disc_rate_next  ;
	return this.dirty_price(disc_margin,next_index_rate,assumed_index_rate,disable_rounding,	error);
}

/*-----------------------------------------------------------------------
  frn: dirty_price
  ----------------------------------------------------------------------*/
number frn.dirty_price(	number 					disc_margin,
						number option(nullable) next_index_rate,
						number option(nullable) assumed_index_rate,
						logical 				disable_rounding,									
						error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_dirty_from_disc_margin(disc_margin,next_index_rate,assumed_index_rate,
													disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.dirty_price");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.dirty_price");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  frn: frn_clean_from_disc_margin
  ----------------------------------------------------------------------*/
number frn.frn_clean_from_disc_margin(	number 					disc_margin,
										number option(nullable) disc_rate_next,
										number option(nullable) assumed_index_rate,
										number option(nullable) next_index_rate,
										logical 				disable_rounding,
										error_info option(nullable) error) 
{
	if(!null(disc_rate_next) && !null(next_index_rate) &&  disc_rate_next != next_index_rate) {
		CORE_INT.catch_error_info(error,E_INVALID_ARG,"disc_rate_next <> next_index_rate is no longer supported", "frn.frn_dirty_from_disc_margin");
		return null<number >;
	}
	if(null(disc_rate_next))
		disc_rate_next = next_index_rate ;
	if(null(next_index_rate))
		next_index_rate = disc_rate_next  ;
	return this.clean_price(disc_margin,next_index_rate,assumed_index_rate,disable_rounding,	error);
}

/*-----------------------------------------------------------------------
  frn: clean_price
  ----------------------------------------------------------------------*/
number  frn.clean_price(	logical 	disable_rounding,
							logical 	in_pcnt,									
							error_info option(nullable) error)
{	
	return instrument.clean_price(disable_rounding, in_pcnt, error);
}
/*-----------------------------------------------------------------------
  frn: dirty_price
  ----------------------------------------------------------------------*/
number  frn.dirty_price(	logical 	disable_rounding,
							logical 	in_pcnt,									
							error_info option(nullable) error)
{	
	return instrument.dirty_price(disable_rounding, in_pcnt, error);
}
/*-----------------------------------------------------------------------
  frn: yield
  ----------------------------------------------------------------------*/
number frn.yield(logical disable_rounding,
				 error_info option(nullable) error)
{	
	return instrument.yield(disable_rounding,error);
}
/*-----------------------------------------------------------------------
  frn: clean_price
  ----------------------------------------------------------------------*/
number frn.clean_price(	number disc_margin,
						number option(nullable) next_index_rate,
						number option(nullable) assumed_index_rate,
						logical disable_rounding,										
						error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_clean_from_disc_margin(disc_margin,next_index_rate,assumed_index_rate,disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.clean_price");
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.clean_price");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  frn: roll_method
  ----------------------------------------------------------------------*/
string frn.roll_method(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		string c = i().__frn_roll_method(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.roll_method");
		return e ? null<string>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.roll_method");
		return null<string >;
	}
}

/*-----------------------------------------------------------------------
  cash_flows_cpn override
  ----------------------------------------------------------------------*/
/*vector(number) frn.cash_flows_cpn(	number option(nullable) nominal,
									logical from_settle,
									logical keep_size, 
									error_info option(nullable) error)
option(com_name: 'cash_flows_cpn_e')
{	
	return instrument.cash_flows_cpn(nominal, from_settle, keep_size,error);
}
*/

/*-----------------------------------------------------------------------
  cash_flow_data 
  ----------------------------------------------------------------------*/
void frn.cash_flow_data(	number option(nullable) nominal,
							logical 				from_settle,
							ir_cf_code 				cf_code,
							logical 				adj_dates,
							logical 				incl_floor,
							//logical 				allow_fwd_fix,
							logical 				keep_size, 
							out vector(date)   		dates, 
							out vector(number)   	amounts,								
							error_info option(nullable) error) 
{	
	//instrument.cash_flow_data(nominal,from_settle, cf_code,adj_dates,keep_size,dates,amounts, error);
	try{	
		instr_error_type t;
   		string 			s;	
		i().__frn_cash_flow_data(	nominal,from_settle,cf_code,adj_dates,incl_floor,
									keep_size,dates,amounts,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.cash_flow_data");
		if(e) {
			dates = null<vector(date)>;
			amounts = null<vector(number)>;
		}
		return ;	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.cash_flow_data");
		dates = null<vector(date)>;
		amounts = null<vector(number)>;		
		return;
	}						
}

/*-----------------------------------------------------------------------
  cash_flows 
  ----------------------------------------------------------------------*/
vector(number) frn.cash_flows(	number option(nullable) nominal,
								logical 				from_settle,
								ir_cf_code 				cf_code,								
								logical 				incl_floor,
								//logical 				allow_fwd_fix,
								logical 				keep_size,							
								error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		vector(date)  dates; 
		vector(number)  amounts;
		logical adj_dates = true;
		i().__frn_cash_flow_data(	nominal,from_settle,cf_code,adj_dates,incl_floor,
									keep_size,dates,amounts,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.cash_flows");
		return e ? null<vector(number)>: amounts;	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.cash_flows");
		return null<vector(number)>;
	}						
}

/*-----------------------------------------------------------------------
  cash_flows override
  ----------------------------------------------------------------------*/
/*vector(number) frn.cash_flows(	number option(nullable) nominal,
								logical from_settle,
								logical keep_size, 
								error_info option(nullable) error)
option(com_name: 'cash_flows_e')
{	
	return instrument.cash_flows(nominal, from_settle, keep_size,error);
}
*/


/*-----------------------------------------------------------------------
  frn: cash_flows_crv  fwd_func
  ----------------------------------------------------------------------*/
vector(number) frn.cash_flows_crv(	fwd_func option(nullable)		index_func,
									number option(nullable) 		index_sprd ,
									number option(nullable) 		nominal ,
									logical 						from_settle ,
									ir_cf_code 						cf_code,
									logical 						incl_floor_fixed ,
									logical 						incl_floor_fwd ,
									logical 						keep_size ,
									error_info option(nullable) 	error)
{	
	try{	
		instr_error_type t;
   		string 			s;
		vector(string)  err_v;
		vector(number) c = i().__frn_cash_flows_crv(index_func,index_sprd,nominal,from_settle,cf_code,
													incl_floor_fixed,incl_floor_fwd,keep_size,err_v,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.cash_flows_crv");
		return e ? null<vector(number) >: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.cash_flows_crv");
		return null<vector(number) >;
	}
}
/*-----------------------------------------------------------------------
  frn: cash_flows_crv
  ----------------------------------------------------------------------*/
vector(number) frn.cash_flows_crv(	disc_func option(nullable)	index_disc_func,
									number option(nullable) 	index_sprd ,
									number option(nullable) 	nominal ,
									logical 					from_settle ,
									ir_cf_code 					cf_code,
									logical 					incl_floor_fixed ,
									logical 					incl_floor_fwd ,
									logical 					keep_size ,
									error_info option(nullable) error)
option(com_name: 'cash_flows_crv_fwd_func')	
{	
	try{
		error_info ee = error_info(true,true);
		fwd_func f = create_fwd_func(index_disc_func, ee);
		CORE_INT.instr_fail_check(null(f), "invalid fwd_func", this, ee);

		instr_error_type t;
   		string 			s;
		vector(string)  err_v;
		vector(number) c = i().__frn_cash_flows_crv(f,index_sprd,nominal,from_settle,cf_code,
													incl_floor_fixed,incl_floor_fwd,keep_size,err_v,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.cash_flows_crv");
		return e ? null<vector(number)>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.cash_flows_crv");
		return null<vector(number) >;
	}
}

/*-----------------------------------------------------------------------
  present_value  fwd_func
  ----------------------------------------------------------------------*/
number frn.present_value_crv(	fwd_func option(nullable)	index_func,
								number option(nullable) 	index_sprd ,
								disc_func					disc_func,
								number option(nullable) 	disc_sprd ,	
								number option(nullable) 	nominal ,															
								disc_func option(nullable)	zero_floor_disc_func,
								number option(nullable) 	zero_floor_disc_sprd ,	
								number option(nullable) 	zero_floor_vol ,
								out number	option(nullable) zero_floor_value,	
								error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;
		number  c= i().__frn_curve_to_pv(index_func,index_sprd,disc_func,disc_sprd, nominal,
										zero_floor_disc_func,zero_floor_disc_sprd,zero_floor_vol,zero_floor_value,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.present_value_crv");
		if(e){
			zero_floor_value = null<number>;
			return null<number  >;
		}		
		return c;					
	}
	catch {
		zero_floor_value = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.present_value_crv");
		return null<number  >;
	}
}

/*-----------------------------------------------------------------------
  present_value  disc_func
  ----------------------------------------------------------------------*/
number frn.present_value_crv(	disc_func option(nullable)	index_disc_func,
								number option(nullable) 	index_sprd ,
								disc_func					disc_func,
								number option(nullable) 	disc_sprd ,		
								number option(nullable) 	nominal ,														
								disc_func option(nullable)	zero_floor_disc_func,
								number option(nullable) 	zero_floor_disc_sprd ,	
								number option(nullable) 	zero_floor_vol ,								
								out number	option(nullable) zero_floor_value,	
								error_info option(nullable) error)
option(com_name: 'present_value_crv_fwd_func')	
{	
	try{			
		error_info ee = error_info(true,true);
		fwd_func f = create_fwd_func(index_disc_func, ee);
		CORE_INT.instr_fail_check(null(f), "invalid fwd_func", this, ee);
		
		instr_error_type t;
   		string 			s;			
		number  c = i().__frn_curve_to_pv(f,index_sprd,disc_func,disc_sprd, nominal,zero_floor_disc_func,
										zero_floor_disc_sprd,zero_floor_vol,zero_floor_value,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.present_value_crv");
		if(e){
			zero_floor_value = null<number>;
			return null<number >;
		}		
		return c;							
	}
	catch {
		zero_floor_value = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.present_value_crv");
		return null<number  >;
	}
}



/*-----------------------------------------------------------------------
  frn: cash_flow_cpn
  ----------------------------------------------------------------------*/
/*vector(number) frn.cash_flows_cpn_crv(	disc_func option(nullable)	index_func,
								number option(nullable) index_sprd ,
								number option(nullable) nominal ,
								logical from_settle ,
								logical incl_floor_fixed ,
								logical incl_floor_fwd ,
								logical keep_size ,
								error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(number) c = i().__frn_cash_flows_cpn_crv(index_func,index_sprd,nominal,from_settle, incl_floor_fixed,incl_floor_fwd,keep_size ,t, s);
		set_error(error,t,s);
		return c;						
	}
	catch {
		set_error(error,ERR_T_CALC,err.message());
		return null<vector(number) >;
	}
}

*/



/*-----------------------------------------------------------------------
  frn: cash_flow_cpn  fwd_func
  ----------------------------------------------------------------------*/
/*vector(number) frn.cash_flows_cpn_crv(	fwd_func option(nullable)	index_func,
										number option(nullable) index_sprd ,
										number option(nullable) nominal ,
										logical from_settle ,
										logical incl_floor_fixed ,
										logical incl_floor_fwd ,
										logical keep_size ,
										error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(number) c = i().__frn_cash_flows_cpn_crv(index_func,index_sprd,nominal,from_settle, incl_floor_fixed,incl_floor_fwd,keep_size ,t, s);
		set_error(error,t,s);
		return c;						
	}
	catch {
		set_error(error,ERR_T_CALC,err.message());
		return null<vector(number) >;
	}
}

*/

/*-----------------------------------------------------------------------
  frn: cash_flow_data_crv
  ----------------------------------------------------------------------*/
void frn.cash_flow_data_crv(fwd_func option(nullable)	index_func,										
							number option(nullable) 	index_sprd ,
							number option(nullable) 	nominal,
							logical 					from_settle,
							ir_cf_code 					cf_code,
							logical 					adj_dates,
							logical 					incl_floor_fixed ,
							logical 					incl_floor_fwd ,
							logical 					keep_size ,
							out vector(date)   			dates,
							out vector(number)   		amounts,
							out vector(string)   		err_v,
							error_info option(nullable) error)
{	
	try {
		instr_error_type t;
   		string 			s;	
		i().__frn_cash_flow_data_crv(index_func,index_sprd,nominal,from_settle,cf_code, adj_dates,
									incl_floor_fixed,incl_floor_fwd,dates,amounts,keep_size ,err_v, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.cash_flow_data_crv");
		if( e ) {
			dates = null<vector(date)>;
			amounts = null<vector(number)>;
		}
		return;
	}
	catch {
		dates = null<vector(date)>;
		amounts = null<vector(number)>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.cash_flow_data_crv");
		return;
	}
}

/*-----------------------------------------------------------------------
  frn: cash_flow_data_crv
  ----------------------------------------------------------------------*/
void frn.cash_flow_data_crv(disc_func option(nullable)	index_disc_func,										
							number option(nullable) 	index_sprd ,
							number option(nullable) 	nominal,
							logical 					from_settle,
							ir_cf_code 					cf_code,
							logical 					adj_dates,
							logical 					incl_floor_fixed ,
							logical 					incl_floor_fwd ,
							logical 					keep_size ,
							out vector(date)   			dates,
							out vector(number)   		amounts,
							out vector(string)   		err_v,
							error_info option(nullable) error)
option(com_name: 'present_value_crv_fwd_func')	
{	
	try{			
		error_info ee = error_info(true,true);
		fwd_func f = create_fwd_func(index_disc_func, ee);
		CORE_INT.instr_fail_check(null(f), "invalid fwd_func", this, ee);
		
		instr_error_type t;
   		string 			s;	
		i().__frn_cash_flow_data_crv(f,index_sprd,nominal,from_settle,cf_code, adj_dates,
									incl_floor_fixed,incl_floor_fwd,dates,amounts,keep_size ,err_v,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.cash_flow_data_crv");
		if( e ) {
			dates = null<vector(date)>;
			amounts = null<vector(number)>;
		}
		return;
		
	}
	catch {
		dates = null<vector(date)>;
		amounts = null<vector(number)>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.cash_flow_data_crv");
		return;
	}
}

/*-----------------------------------------------------------------------
  frn: cash_flow_cpn  fwd_func
  ----------------------------------------------------------------------*/
vector(number) frn.cash_flows_dm(	number option(nullable) nominal ,
									number option(nullable) index_next ,//only for frn-rfr
									number option(nullable) assumed_index ,
									ir_cf_code 				cf_code,
									logical 				keep_size ,
									error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		vector(number) c = i().__frn_cash_flows_dm(nominal,index_next,assumed_index,cf_code,keep_size ,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.cash_flows_dm");
		return e ? null<vector(number) >: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.cash_flows_dm");
		return null<vector(number) >;
	}
}

/*-----------------------------------------------------------------------
  zero_floor_value
  ----------------------------------------------------------------------*/
number frn.zero_floor_value(	fwd_func option(nullable)	index_func,
								number option(nullable) 	index_sprd ,
								disc_func option(nullable) 	disc_func,
								number option(nullable) 	disc_sprd ,								
								number  option(nullable) 	zero_floor_vol,
								number option(nullable) 	nominal ,
								error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_zfloor_value(index_func,index_sprd,disc_func,disc_sprd,zero_floor_vol,nominal,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.zero_floor_value");
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.zero_floor_value");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  frn: neg_rate_rule
  ----------------------------------------------------------------------*/
frn_neg_rate_rule frn.neg_rate_rule(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..frn_neg_rate_rule c = i().__frn_neg_floor_rule(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.neg_rate_rule");
		return e ? null<..frn_neg_rate_rule >: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.neg_rate_rule");
		return null<..frn_neg_rate_rule>;
	}
}


/*-----------------------------------------------------------------------
  frn: frn_curve_to_price	disc_func
  ----------------------------------------------------------------------*/
void frn.frn_curve_to_price(	disc_func  		index_disc_func,
								//number index_sprd,
								disc_func  		disc_func,
								number			disc_sprd,						
								out number		next_index_rate,
								out number		assumed_index_rate,
								out number		disc_margin,
								out number		clean_price,
								out number		dirty_price,
								logical 		disable_rounding ,							
								error_info option(nullable) 	error) 
{
	try{
		error_info ee = error_info(true,true);
		fwd_func f = create_fwd_func(index_disc_func, ee);
		CORE_INT.instr_fail_check(null(f), "invalid fwd_func", this, ee);
				
		instr_error_type t;
   		string 			s;
		
		i().__frn_curve_to_price_legacy(f,0,disc_func,disc_sprd,next_index_rate,assumed_index_rate,disc_margin,
										clean_price,dirty_price,disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.frn_curve_to_price");		
		if(e){ 
			next_index_rate = assumed_index_rate = disc_margin = clean_price = dirty_price = null<number>;
		}		
		return ;						
	}
	catch {
		next_index_rate = assumed_index_rate = disc_margin = clean_price = dirty_price = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.frn_curve_to_price");
		return ;
	}
}


/*-----------------------------------------------------------------------
  frn: frn_curve_to_price	fwd_func
  ----------------------------------------------------------------------*/
void frn.frn_curve_to_price(	fwd_func  		index_func,
								//number index_sprd,
								disc_func  		disc_func,
								number			disc_sprd,						
								out number		next_index_rate,
								out number		assumed_index_rate,
								out number		disc_margin,
								out number		clean_price,
								out number		dirty_price,
								logical 		disable_rounding ,							
								error_info option(nullable) 	error)
{
	try{	
		instr_error_type t;
   		string 			s;	
		i().__frn_curve_to_price_legacy(index_func,0,disc_func,disc_sprd,next_index_rate,assumed_index_rate,disc_margin,
								clean_price,dirty_price,disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.frn_curve_to_price");		
		if(e){ 
			next_index_rate = assumed_index_rate = disc_margin = clean_price = dirty_price = null<number>;
		}		
		return ;						
	}
	catch {
		next_index_rate = assumed_index_rate = disc_margin = clean_price = dirty_price = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.frn_curve_to_price");
		return ;
	}
}

/*-----------------------------------------------------------------------
  frn: price_crv	disc_func
1) 	calculate a proper pv using all curve info (i.e. fwd rates from index_func and discounting from disc_func)
	it is possible to use separate disc_func for discounting the zero floor (zero_floor_disc_func)
2) based on pv calculate dirty, clean, disc_margin and floor value (disc_margin needs next_index_rate and assumed_index_rate) 
  ----------------------------------------------------------------------*/
void frn.price_crv(	disc_func option(nullable)		index_disc_func,
					number 	option(nullable)		index_sprd,
					disc_func  						disc_func,
					number	option(nullable)		disc_sprd,
					disc_func  option(nullable)		zero_floor_disc_func,
					number	option(nullable)		zero_floor_disc_sprd,
					number option(nullable)			zero_floor_vol,		
					number option(nullable)			next_index_rate,		//only for dm calculation
					number option(nullable)			assumed_index_rate,		//only for dm calculation					
					out number						disc_margin_opt_adj,
					out number						clean_price_pcnt,
					out number						dirty_price_pcnt,
					out number						zero_floor_value_pcnt,		
					logical 						disable_rounding ,											
					error_info option(nullable) 	error)
{	
	try{
		error_info ee = error_info(true,true);
		fwd_func f = create_fwd_func(index_disc_func, ee);
		CORE_INT.instr_fail_check(null(f), "invalid fwd_func", this, ee);
				
		instr_error_type t;
   		string 			s;
		return ;	
		i().__frn_price_crv(f,index_sprd,disc_func,disc_sprd,zero_floor_disc_func,zero_floor_disc_sprd,
							next_index_rate,assumed_index_rate,zero_floor_vol,disc_margin_opt_adj,
							clean_price_pcnt,dirty_price_pcnt,zero_floor_value_pcnt,disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.price_crv");		
		if(e){
			next_index_rate = assumed_index_rate = disc_margin_opt_adj = clean_price_pcnt = dirty_price_pcnt = zero_floor_value_pcnt = null<number>;
		}		
		return ;						
	}
	catch {
		next_index_rate = assumed_index_rate = disc_margin_opt_adj = clean_price_pcnt = dirty_price_pcnt = zero_floor_value_pcnt = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.price_crv");
		return ;
	}
									
}
/*-----------------------------------------------------------------------
  price_crv fwd_func
  ----------------------------------------------------------------------*/
void frn.price_crv(	fwd_func  option(nullable)		index_func,
					number 		option(nullable)	index_sprd,
					disc_func  						disc_func,
					number	option(nullable)		disc_sprd,						
					disc_func  option(nullable)		zero_floor_disc_func,
					number	option(nullable)		zero_floor_disc_sprd,
					number option(nullable)			zero_floor_vol,		
					number option(nullable)			next_index_rate,
					number option(nullable)			assumed_index_rate,
					out number						disc_margin_opt_adj,
					out number						clean_price_pcnt,
					out number						dirty_price_pcnt,
					out number						zero_floor_value_pcnt,		
					logical 						disable_rounding ,																	
					error_info option(nullable) error)
option(com_name: 'price_crv_fwd_func')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__frn_price_crv(index_func,index_sprd,disc_func,disc_sprd,zero_floor_disc_func,zero_floor_disc_sprd,
							next_index_rate,assumed_index_rate,zero_floor_vol,
							disc_margin_opt_adj,clean_price_pcnt,dirty_price_pcnt,zero_floor_value_pcnt,disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.price_crv");		
		if(e){
			next_index_rate = assumed_index_rate = disc_margin_opt_adj = clean_price_pcnt = dirty_price_pcnt = zero_floor_value_pcnt = null<number>;
		}
		return;
	}
	catch {
		next_index_rate = assumed_index_rate = disc_margin_opt_adj = clean_price_pcnt = dirty_price_pcnt = zero_floor_value_pcnt = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.price_crv");
		return ;
	}
									
}

/*-----------------------------------------------------------------------
  price_crv fwd_func
  ----------------------------------------------------------------------*/
void frn.price_crv(	fwd_func  option(nullable)		index_func,
					number 		option(nullable)	index_sprd,
					disc_func  						disc_func,
					number	option(nullable)		disc_sprd,						
					//disc_func  option(nullable)		zero_floor_disc_func,
					//number	option(nullable)		zero_floor_disc_sprd,
					//number option(nullable)			zero_floor_vol,		
					number option(nullable)			next_index_rate,
					number option(nullable)			assumed_index_rate,
					out number						disc_margin,
					out number						clean_price_pcnt,
					out number						dirty_price_pcnt,
					//out number						zero_floor_value_pcnt,		
					logical 						disable_rounding ,																	
					error_info option(nullable) error)
option(com_name: 'price_crv_fwd_func_no_floor')
{	
	try{	
		instr_error_type t;
   		string 			s;
		number zero_floor_value_pcnt;
		i().__frn_price_crv(index_func,index_sprd,disc_func,disc_sprd,null<disc_func>,0,
							next_index_rate,assumed_index_rate,null<number>,
							disc_margin,clean_price_pcnt,dirty_price_pcnt,zero_floor_value_pcnt,disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.price_crv");
		if(!CORE_INT.is_equal_zero(zero_floor_value_pcnt)) {
			e = true;
			QL_FAIL("inapplicable function call (floor seems to have a positive value), use overloaded price_crv() with floor input",this,true);
		}
					
		if(e){
			next_index_rate = assumed_index_rate = disc_margin = clean_price_pcnt = dirty_price_pcnt = null<number>;
		}
		return;
	}
	catch {
		next_index_rate = assumed_index_rate = disc_margin = clean_price_pcnt = dirty_price_pcnt = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.price_crv");
		return ;
	}
									
}
/*-----------------------------------------------------------------------
  price_crv fwd_func
  ----------------------------------------------------------------------*/
void frn.price_crv(	disc_func  option(nullable)		index_disc_func,
					number 		option(nullable)	index_sprd,
					disc_func  						disc_func,
					number	option(nullable)		disc_sprd,						
					//disc_func  option(nullable)		zero_floor_disc_func,
					//number	option(nullable)		zero_floor_disc_sprd,
					//number option(nullable)			zero_floor_vol,		
					number option(nullable)			next_index_rate,
					number option(nullable)			assumed_index_rate,
					out number						disc_margin,
					out number						clean_price_pcnt,
					out number						dirty_price_pcnt,
					//out number						zero_floor_value_pcnt,		
					logical 						disable_rounding ,																	
					error_info option(nullable) error)
option(com_name: 'price_crv_disc_func_no_floor')
{	
	try{
		error_info ee = error_info(true,true);
		fwd_func f = create_fwd_func(index_disc_func, ee);
		CORE_INT.instr_fail_check(null(f), "invalid fwd_func", this, ee);
		
		instr_error_type t;
   		string 			s;
		number zero_floor_value_pcnt;
		i().__frn_price_crv(f,index_sprd,disc_func,disc_sprd,null<disc_func>,0,
							next_index_rate,assumed_index_rate,null<number>,
							disc_margin,clean_price_pcnt,dirty_price_pcnt,zero_floor_value_pcnt,disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.price_crv");
		if(!CORE_INT.is_equal_zero(zero_floor_value_pcnt)) {
			e = true;
			QL_FAIL("inapplicable function call (floor seems to have a positive value), use overloaded price_crv() with floor input",this,true);
		}
					
		if(e){
			next_index_rate = assumed_index_rate = disc_margin = clean_price_pcnt = dirty_price_pcnt = null<number>;
		}
		return;
	}
	catch {
		next_index_rate = assumed_index_rate = disc_margin = clean_price_pcnt = dirty_price_pcnt = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.price_crv");
		return ;
	}
									
}

/*-----------------------------------------------------------------------
  price_data_crv
  ----------------------------------------------------------------------*/
void frn.price_data_crv(fwd_func  option(nullable)		index_func,
						number 		option(nullable)	index_sprd,
						out vector(number) 				index_rates,
    					out vector(number) 				cpn_rates,
    					out vector(number) 				intrinsic,
    					out vector(logical) 			is_fixed,	
						error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__frn_price_data_crv(index_func,index_sprd, index_rates,cpn_rates,intrinsic,is_fixed,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.price_data_crv");		
		if(e){
			index_rates = cpn_rates = intrinsic = null<vector(number)>;
			is_fixed = null<vector(logical)>;
		}		
		return ;						
	}
	catch {
		index_rates = cpn_rates = intrinsic = null<vector(number)>;
		is_fixed = null<vector(logical)>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.price_data_crv");
		return ;
	}
									
}

/*-----------------------------------------------------------------------
  disc_margin_rates fwd_func
  note:
  index_func + index_sprd --> assumed_index_rate
  index_disc_func_next + index_disc_sprd_next --> next_index_rate, normally a broken period meaning we may like an interpolated rate here  
  ----------------------------------------------------------------------*/
void frn.disc_margin_rates(	fwd_func  		index_func,
							number 			index_sprd,
							disc_func  		index_disc_func_next,
							number			index_disc_sprd_next,						
							out number		next_index_rate,
							out number		assumed_index_rate,													
							error_info option(nullable) 	error)
option(com_name: 'disc_margin_rates_fwd_func')	
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__frn_disc_marg_rates(index_func,index_sprd,index_disc_func_next,index_disc_sprd_next,
								  next_index_rate,assumed_index_rate,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.disc_margin_rates");		
		if(e){
			next_index_rate = assumed_index_rate = null<number>;
		}		
		return ;						
	}
	catch {
		next_index_rate = assumed_index_rate = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.disc_margin_rates");
		return ;
	}
									
}

/*-----------------------------------------------------------------------
  disc_margin_rates disc_func
  note:
  index_func + index_sprd --> assumed_index_rate
  index_disc_func_next + index_disc_sprd_next --> next_index_rate, normally a broken period meaning we may like an interpolated rate here  
  ----------------------------------------------------------------------*/
void frn.disc_margin_rates(	disc_func  		index_func,
							number 			index_sprd,
							disc_func  		index_disc_func_next,
							number			index_disc_sprd_next,							
							out number		next_index_rate,
							out number		assumed_index_rate,													
							error_info option(nullable) 	error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__frn_disc_marg_rates(index_func,index_sprd,index_disc_func_next,index_disc_sprd_next,
								  next_index_rate,assumed_index_rate,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.disc_margin_rates");		
		if(e){
			next_index_rate = assumed_index_rate = null<number>;
		}		
		return ;						
	}
	catch {
		next_index_rate = assumed_index_rate = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.disc_margin_rates");
		return ;
	}
									
}

/*-----------------------------------------------------------------------
  frn: coupon_data

  ----------------------------------------------------------------------*/
void frn.coupon_data(	out vector(date)  		fixing_dates,//last fix date for frn-rfr's
						out vector(date)  		payment_dates,
						out vector(number)  	fixing_rates,//comp/avg rate for frn-rfr's
						out vector(number)  	coupon_rates,
						logical 				from_settle,
						logical 				keep_size ,																
						error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__frn_coupon_data(fixing_dates,payment_dates,fixing_rates,coupon_rates,from_settle,keep_size,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.coupon_data");		
		if(e){
			fixing_rates = coupon_rates = null<vector(number)>;
			fixing_dates = payment_dates = null<vector(date)>;
		}		
		return ;						
	}
	catch {
		fixing_rates = coupon_rates = null<vector(number)>;
		fixing_dates = payment_dates = null<vector(date)>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.coupon_data");
		return ;
	}
}

/*-----------------------------------------------------------------------
  frn: asw_par_spread
  ----------------------------------------------------------------------*/
number frn.asw_par_spread(	fwd_func 				index_func_frn,
						 	number option(nullable) index_sprd_frn, 
						    disc_func 				disc_func_frn,
						    number option(nullable) disc_sprd_frn, 
						    disc_func option(nullable) disc_func_zero_floor_frn,
						    number option(nullable) disc_sprd_zero_floor_frn,
							number option(nullable) first_fix, 
							day_count_method 		flt_day_count_method,
							bd_convention 			flt_bd_convention,
							integer 				flt_freq,
							logical 				flt_eom,
							..calendar 				flt_calendar,							
							fwd_func option(nullable) index_func_swap, 
    						disc_func option(nullable) disc_func_swap, 
							out number				upfront_pmt, 
							out number 				pv_flt_leg,  
							out number				pv_frn_leg,
							out number 				zero_floor_value,
							error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	

		number c = i().__frn_asw_par_spread(index_func_frn,index_sprd_frn,disc_func_frn,disc_sprd_frn,disc_func_zero_floor_frn,disc_sprd_zero_floor_frn,
											first_fix, flt_day_count_method,flt_bd_convention,flt_freq,flt_eom,flt_calendar,
											index_func_swap,disc_func_swap,
											upfront_pmt, pv_flt_leg, pv_frn_leg,zero_floor_value, t,s );
		logical e = CORE_INT.add_error_info(error,t,s, "frn.asw_par_spread");
		if(e){
			upfront_pmt = pv_flt_leg = pv_frn_leg = zero_floor_value = null<number>;
			return null<number >;
		}
		return c;						
	}
	catch {
		upfront_pmt = pv_flt_leg = pv_frn_leg = zero_floor_value = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.asw_par_spread");		
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  frn: set_date
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	
  ----------------------------------------------------------------------*/
frn frn.set_date(	date  				trade_date, 
					date  option(nullable)	settle_date,
					logical 			re_init_static, 
					logical 			re_init_quote, 
					error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,settle_date,re_init_static,re_init_quote,error);
	return null(cc) ? null<frn>: dynamic_cast<frn>(cc);
	
}

/*-----------------------------------------------------------------------
  set_date  <protected/legacy>
	quote is NOT kept even if trade_date is unchanged
  ----------------------------------------------------------------------*/
frn frn.set_date(	date  				trade_date, 
					logical 			re_initialize, 
					error_info option(nullable) error) 
{	
	instrument cc = instrument._set_date(trade_date,re_initialize,error);
	return null(cc) ? null<frn>: dynamic_cast<frn>(cc);	
}

/*-----------------------------------------------------------------------
  frn: move_date  <protected/legacy>
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	if trade date is the same --> the settle date will be preserved
  ----------------------------------------------------------------------*/
frn frn.move_date(	date  				trade_date, 
					date option(nullable) settle_date,
					error_info option(nullable) error)
{	
	instrument cc = instrument._move_date(trade_date,settle_date,error);
	return null(cc) ? null<frn>: dynamic_cast<frn>(cc);
}

/*-----------------------------------------------------------------------
  frn: set_settle_date
  ----------------------------------------------------------------------*/
frn frn.set_settle_date(	date  				settle_date, 
							logical 			re_init_static, 
							error_info option(nullable) error)
{		
	instrument cc = instrument._set_settle_date(settle_date, re_init_static, error);
	return null(cc) ? null<frn>: dynamic_cast<frn>(cc);
}

/*-----------------------------------------------------------------------
  frn: set_quote 
  ----------------------------------------------------------------------*/
frn frn.set_quote(	number 	option(nullable) quote,
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, false,error);
	return null(cc) ? null<frn>: dynamic_cast<frn>(cc);
}

/*-----------------------------------------------------------------------
  frn : set_quote 
  ----------------------------------------------------------------------*/
frn frn.set_quote(	string 	option(nullable) quote_side,
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, false,error);
	return null(cc) ? null<frn>: dynamic_cast<frn>(cc);
}


/*-----------------------------------------------------------------------
  frn: set_quote
  ----------------------------------------------------------------------*/
frn frn.set_quote(	number 	option(nullable) quote,
					number 	option(nullable) next_index_rate,
					number 					 assumed_index_rate,
					date  	option(nullable) trade_date, 
					date  	option(nullable) settle_date, 
					error_info option(nullable) error)
{		
	try {
		//instrument c = frn_set_quote(quote, disc_rate_next, assumed_index_rate, trade_date, settle_date, error) ;		
		__instrument  cc 	= i().__frn_set_quote(quote, next_index_rate, assumed_index_rate, trade_date, settle_date);
		instr_error e 		= instr_error();
		frn c 				= create_frn(cc,e,E_INIT);
		CORE_INT.instr_fail_check(null(c), "invalid frn", this, e);
		
		if(!c.is_valid(error))
			return null<frn>;		
		return c; 
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.set_quote");
		return null<frn>;
	}
}


/*-----------------------------------------------------------------------
  frn: set_quote
  ----------------------------------------------------------------------*/
frn frn.set_quote(	string 	option(nullable) quote_side,
					number 	option(nullable) next_index_rate,
					number 	assumed_index_rate,
					date  	option(nullable) trade_date, 
					date  	option(nullable) settle_date, 
					error_info option(nullable) error)
{	
	try {
		//instrument c = frn_set_quote(quote_side, disc_rate_next, assumed_index_rate, trade_date, settle_date, error) ;
		__instrument  cc 	= i().__frn_set_quote(quote_side, next_index_rate, assumed_index_rate, trade_date, settle_date);
		instr_error e 		= instr_error();
		frn c 				= create_frn(cc,e,E_INIT);
		CORE_INT.instr_fail_check(null(c), "invalid frn", this, e);
		
		if(!c.is_valid(error))
			return null<frn>;
		return c; 
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.set_quote");
		return null<frn>;
	}/*
	try{				
		__instrument  c 	= i().__frn_set_quote(quote_side, disc_rate_next, assumed_index_rate, trade_date, settle_date);		
		frn cc 		= create_frn( c, error, E_INIT);
		if(!cc.is_valid(error))
			QL_FAIL(error.message(),E_INIT);
		return cc ;					
	}
	catch (E_INIT) {
		set_error(error,ERR_T_INIT,err.message());
		return null<frn>;
	}
	catch {
		set_error(error,ERR_T_CALC,err.message());
		return null<frn>;
	}*/
}

/*-----------------------------------------------------------------------
  frn : set_clean_price
  ----------------------------------------------------------------------*/
frn frn.set_clean_price(	number 	option(nullable) clean_pct,
							date  	option(nullable) trade_date, 
							date  	option(nullable) settle_date, 
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_clean_price(	clean_pct,trade_date, settle_date,error);
	return null(cc) ? null<frn>: dynamic_cast<frn>(cc);
}

/*-----------------------------------------------------------------------
  frn: set_dirty_price
  ----------------------------------------------------------------------*/
frn frn.set_dirty_price(	number 	option(nullable) dirty_pct,
							date  	option(nullable) trade_date, 
							date  	option(nullable) settle_date, 
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_dirty_price(	dirty_pct,trade_date, settle_date,error);
	return null(cc) ? null<frn>: dynamic_cast<frn>(cc);
}

/*-----------------------------------------------------------------------
  frn: set_disc_margin
  ----------------------------------------------------------------------*/
frn frn.set_disc_margin(number 	option(nullable) disc_margin,									
							date  	option(nullable) trade_date, 
							date  	option(nullable) settle_date, 
							error_info option(nullable) error)
{	
	try {
		//instrument c = frn_set_disc_margin(disc_margin, trade_date, settle_date, error) ;
		__instrument  cc 	= i().__frn_set_disc_margin(disc_margin,trade_date,settle_date);
		instr_error e 		= instr_error();
		frn c 				= create_frn(cc,e,E_INIT);
		CORE_INT.instr_fail_check(null(c), "invalid frn", this, e);
		
		if(!c.is_valid(error))
			return null<frn>;	
		return c; 
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.set_disc_margin");
		return null<frn>;
	}
}

/*-----------------------------------------------------------------------
  add_zero_floor_value
  ----------------------------------------------------------------------*/
void frn.add_zero_floor_value(number  option(nullable) zero_floor_value_pcnt)
{	
	i().__frn_add_use_zero_floor_value(zero_floor_value_pcnt);
	return ;						
}

/*-----------------------------------------------------------------------
  add_zero_floor_model
  ----------------------------------------------------------------------*/
void frn.add_zero_floor_model(	cap_model cap_model,
								number   			vol,
								number  option(nullable) displacement)
{	
	i().__frn_add_use_zero_floor_model(cap_model,vol,displacement);
	return ;						
}

/*-----------------------------------------------------------------------
  frn: add_fixing
  ----------------------------------------------------------------------*/
void frn.add_fixing(vector(date) option(nullable) fixing_dates,	
					vector(number) option(nullable) fixing_rates,
					number option(nullable) first_fixing,
				    number option(nullable) last_fixing,
				    number option(nullable) fix_proxy_hist,
					number option(nullable) fix_proxy_fwd,
				    logical  option(nullable) allow_fwd_fix)
{
	error_info ee = error_info(true,true);
	if(this.is_rfr(ee)){
		QL_FAIL_COND(!null(first_fixing), "first_fixing not applicable for non frn-rfr's", this, true, E_INIT);
		QL_FAIL_COND(!null(last_fixing), "first_fixing not applicable for non frn-rfr's", this, true, E_INIT);
	}
	
	i().__frn_add_fixing(fixing_dates,fixing_rates,first_fixing,last_fixing,fix_proxy_hist,fix_proxy_fwd,allow_fwd_fix);
	return ;						
}
/*-----------------------------------------------------------------------
  frn: set_fixing
  ----------------------------------------------------------------------*/
frn frn.set_fixing(	vector(date) option(nullable) fixing_dates,	
					vector(number) option(nullable) fixing_rates,
					number option(nullable) first_fixing,
				    number option(nullable) last_fixing,
				    number option(nullable) fix_proxy_hist,
					number option(nullable) fix_proxy_fwd, 
				    logical  option(nullable) allow_fwd_fix, 
					error_info option(nullable) error)
{	
	try {
		error_info ee = error_info(true,true);
		
		if(this.is_rfr(ee)){
			QL_FAIL_COND(!null(first_fixing), "first_fixing not applicable for non frn-rfr's", this, true, E_INIT);
			QL_FAIL_COND(!null(last_fixing), "first_fixing not applicable for non frn-rfr's", this, true, E_INIT);
		}
		
		__instrument  cc 	= i().__frn_set_fixing(fixing_dates,fixing_rates,first_fixing,last_fixing,
												   fix_proxy_hist,fix_proxy_fwd,allow_fwd_fix);
		
		instr_error e 		= instr_error();
		frn c 				= create_frn(cc,e,E_INIT);
		CORE_INT.instr_fail_check(null(c), "invalid frn", this, e);
		
		if(!c.is_valid(error))
			return null<frn>;
		return c; 
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.set_fixing");
		return null<frn>;
	}
}

/*-----------------------------------------------------------------------
  mac_dur_dm
  ----------------------------------------------------------------------*/
number  frn.mac_dur_dm( error_info option(nullable) error) 
{	
	try{	
		number delta = 0.0001;
		//delta	= conv_null_number_com(delta) ;
		//if(null(delta)) delta = 0.0001;
		instr_error_type t;
   		string 			s;		
		number c = i().__frn_mac_dur_dm(delta, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.mac_dur_dm");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.mac_dur_dm");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  mac_dur
  ----------------------------------------------------------------------*/
number  frn.mac_dur(error_info option(nullable) error) 
{	
	try{	
		number delta = 0.0001;
		//delta	= conv_null_number_com(delta) ;
		//if(null(delta)) delta = 0.0001;
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_mac_dur(delta, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.mac_dur");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.mac_dur");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  mod_dur_dm
  ----------------------------------------------------------------------*/
number  frn.mod_dur_dm(error_info option(nullable) error) 
{	
	try{	
		number delta = 0.0001;
		//delta	= conv_null_number_com(delta) ;
		//if(null(delta)) delta = 0.0001;
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_mod_dur_dm(delta, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.mod_dur_dm");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.mod_dur_dm");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  mod_dur
  ----------------------------------------------------------------------*/
number  frn.mod_dur(error_info option(nullable) error) 
{	
	try{	
		number delta = 0.0001;
		//delta	= conv_null_number_com(delta) ;
		//if(null(delta)) delta = 0.0001;
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_mod_dur(delta, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.mod_dur");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.mod_dur");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  dol_dur
  ----------------------------------------------------------------------*/
number  frn.dol_dur(error_info option(nullable) error) 
{	
	try{	
		number delta = 0.0001;
		//delta	= conv_null_number_com(delta) ;
		//if(null(delta)) delta = 0.0001;
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_dol_dur(delta, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.dol_dur");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.dol_dur");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  dol_convexity
  ----------------------------------------------------------------------*/
number  frn.dol_convexity(error_info option(nullable) error) 
{	
	try{	
		number delta = 0.0001;
		//delta	= conv_null_number_com(delta) ;
		//if(null(delta)) delta = 0.0001;
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_dol_convexity(delta, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.dol_convexity");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.dol_convexity");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  convexity
  ----------------------------------------------------------------------*/
number  frn.convexity(error_info option(nullable) error) 
{	
	try{	
		number delta = 0.0001;
		//delta	= conv_null_number_com(delta) ;
		//if(null(delta)) delta = 0.0001;
		instr_error_type t;
   		string 			s;		
		number c = i().__frn_convexity(delta, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.convexity");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.convexity");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  sensitivity
  ----------------------------------------------------------------------*/
number  frn.sensitivity(error_info option(nullable) error) 
{	
	try{	
		number delta = 0.0001;
		//delta	= conv_null_number_com(delta) ;
		//if(null(delta)) delta = 0.0001;
		instr_error_type t;
   		string 			s;	
		
		number c= i().__frn_sensitivity(delta, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.sensitivity");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.sensitivity");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  pvbp_r
  ----------------------------------------------------------------------*/
number  frn.pvbp_r(	number 	option(nullable) nominal,
					number  option(nullable) delta,					
					error_info option(nullable) error) 
{	
	try{	
		nominal	= conv_null_number_com(nominal) ;
		delta	= conv_null_number_com(delta) ;
		instr_error_type t;
   		string 			s;	
		if(null(delta)) delta = 0.0001;
		number c = i().__frn_pvbp(nominal,delta, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.pvbp_r");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.pvbp_r");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  pvbp_dm
  ----------------------------------------------------------------------*/
number  frn.pvbp_dm(number 	option(nullable) nominal,
					number  option(nullable) delta,					
					error_info option(nullable) error) 
{	
	try{	
		nominal	= conv_null_number_com(nominal) ;
		delta	= conv_null_number_com(delta) ;
		instr_error_type t;
   		string 			s;	
		if(null(delta)) delta = 0.0001;
		number c = i().__frn_pvbp_dm(nominal,delta, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.pvbp_dm");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.pvbp_dm");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  frn: frn_disc_margin_risk_bp
  ----------------------------------------------------------------------*/
number frn.frn_disc_margin_risk_bp(	number delta,
									number clean_price_pcnt,
									number option(nullable) disc_rate_next,
									number option(nullable) assumed_index_rate,
									number option(nullable) next_index_rate,											
									error_info option(nullable) error)
{	
	if(!null(disc_rate_next) && !null(next_index_rate) &&  disc_rate_next != next_index_rate) {
		CORE_INT.catch_error_info(error,E_INVALID_ARG,"disc_rate_next <> next_index_rate is no longer supported", "frn.frn_disc_margin_risk_bp");
		return null<number >;		
	}
	if(null(disc_rate_next))
		disc_rate_next = next_index_rate ;
	if(null(next_index_rate))
		next_index_rate = disc_rate_next  ;
	return this.pvbp_dm(delta,clean_price_pcnt,next_index_rate,assumed_index_rate,error);	
}

/*-----------------------------------------------------------------------
  pvbp_dm
  ----------------------------------------------------------------------*/
number frn.pvbp_dm(	number delta,
					number clean_price_pcnt,
					number option(nullable) next_index_rate,
					number option(nullable) assumed_index_rate,
					//number option(nullable) next_index_rate,									
					error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_disc_margin_risk_bp(delta,clean_price_pcnt,next_index_rate,
											assumed_index_rate, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.pvbp_dm");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.pvbp_dm");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  frn: frn_disc_margin_risk_bp
  ----------------------------------------------------------------------*/
number frn.frn_rate_risk_bp(	number delta,
								number clean_price_pcnt,
								number option(nullable) disc_rate_next,
								number option(nullable) assumed_index_rate,
								number option(nullable) next_index_rate,											
								error_info option(nullable) error)
{	
	if(!null(disc_rate_next) && !null(next_index_rate) &&  disc_rate_next != next_index_rate) {
		CORE_INT.catch_error_info(error,E_INVALID_ARG,"disc_rate_next <> next_index_rate is no longer supported", "frn.frn_disc_margin_risk_bp");
		return null<number >;	
	}
	if(null(disc_rate_next))
		disc_rate_next = next_index_rate ;
	if(null(next_index_rate))
		next_index_rate = disc_rate_next  ;
	return this.pvbp_r(delta,clean_price_pcnt,next_index_rate,assumed_index_rate,error);	
}

/*-----------------------------------------------------------------------
  pvbp_r
  ----------------------------------------------------------------------*/
number frn.pvbp_r(	number delta,
					number clean_price_pcnt,
					number option(nullable) next_index_rate,
					number option(nullable) assumed_index_rate,
					//number option(nullable) next_index_rate,							
					error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_rate_risk_bp(delta,clean_price_pcnt, next_index_rate, assumed_index_rate, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.pvbp_r");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.pvbp_r");
		return null<number >;
	}
}


/*-----------------------------------------------------------------------
  frn: mac_dur_analytic
  ----------------------------------------------------------------------*/
number  frn.mac_dur_analytic(error_info option(nullable) error) 
{	
	return fin_instr.err_type(null<number>, error,"mac_dur_analytic");
}

/*-----------------------------------------------------------------------
  frn: mod_dur_analytic
  ----------------------------------------------------------------------*/
number  frn.mod_dur_analytic(error_info option(nullable) error)  
{	
	return fin_instr.err_type(null<number>, error,"mod_dur_analytic");
}

/*-----------------------------------------------------------------------
  frn: dol_dur_analytic
  ----------------------------------------------------------------------*/
number  frn.dol_dur_analytic(error_info option(nullable) error)  
{	
	return fin_instr.err_type(null<number>, error,"dol_dur_analytic");
}

/*-----------------------------------------------------------------------
  frn: pvbp_analytic
  ----------------------------------------------------------------------*/
number  frn.pvbp_analytic(number option(nullable) nom,
								error_info option(nullable) error)
{	
	return fin_instr.err_type(null<number>, error,"pvbp_analytic");
}

/*-----------------------------------------------------------------------
  frn: convexity_analytic
  ----------------------------------------------------------------------*/
number  frn.convexity_analytic(error_info option(nullable) error) 
{	
	return fin_instr.err_type(null<number>, error,"convexity_analytic");
}

/*-----------------------------------------------------------------------
  frn: dol_convexity_analytic
  ----------------------------------------------------------------------*/
number  frn.dol_convexity_analytic(error_info option(nullable) error) 
{	
	return fin_instr.err_type(null<number>, error,"dol_convexity_analytic");
}
/*-----------------------------------------------------------------------
  frn: sensitivity_analytic
  ----------------------------------------------------------------------*/
number  frn.sensitivity_analytic(error_info option(nullable) error) 
{	
	return fin_instr.err_type(null<number>, error,"sensitivity_analytic");
}

/*-----------------------------------------------------------------------
  frn: dirty_price_oadm
  ----------------------------------------------------------------------*/
number frn.dirty_price_oadm(number 					oadm,
							number option(nullable) next_index_rate,
							number option(nullable) assumed_index_rate,
							fwd_func option(nullable) index_func,
							number option(nullable) index_sprd ,
							disc_func  				disc_func,
							number option(nullable) disc_sprd ,								
							number  option(nullable) zero_floor_vol,
							logical 				disable_rounding,									
							error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_dirty_from_oadm(oadm,next_index_rate,assumed_index_rate,index_func,
											index_sprd,disc_func,disc_sprd,zero_floor_vol,disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.dirty_price_oadm");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.dirty_price_oadm");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  frn: clean_price_oadm
  ----------------------------------------------------------------------*/
number frn.clean_price_oadm(number 					oadm,
							number option(nullable) next_index_rate,
							number option(nullable) assumed_index_rate,
							fwd_func option(nullable) index_func,
							number option(nullable) index_sprd ,
							disc_func  				disc_func,
							number option(nullable) disc_sprd ,								
							number  option(nullable) zero_floor_vol,
							logical 				disable_rounding,									
							error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_clean_from_oadm(oadm,next_index_rate,assumed_index_rate,index_func,
											index_sprd,disc_func,disc_sprd,zero_floor_vol,disable_rounding,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.clean_price_oadm");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.clean_price_oadm");
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  frn: disc_margin_opt_adj
  ----------------------------------------------------------------------*/
number frn.disc_margin_opt_adj(	number 							quote,
								..quote_style option(nullable)	quote_style,
								number option(nullable) 		next_index_rate,
								number option(nullable) 		assumed_index_rate,
								fwd_func option(nullable)		index_func,
								number option(nullable) 		index_sprd ,
								disc_func  						disc_func,
								number option(nullable) 		disc_sprd ,								
								number  option(nullable) 		zero_floor_vol,
								out number  option(nullable) 	zero_floor_value,										
								error_info option(nullable) 	error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__frn_oadm(quote,quote_style,next_index_rate,assumed_index_rate,index_func,
								index_sprd,disc_func,disc_sprd,zero_floor_vol,zero_floor_value,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "frn.disc_margin_opt_adj");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn.disc_margin_opt_adj");
		return null<number >;
	}
}



