option(null: hard);	// Throw error if a null value is used in a non-nullable context

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	fxspot
	--------------------------------------------------------------------
*/


module CORE_INT_FX
{	
	/*-----------------------------------------------------------------------
	  Name :  	fx_inst_name	
	  ----------------------------------------------------------------------*/
	instrument_name fx_inst_name(	string base_ccy, 
									string price_ccy)

	{		
		return strcat([str_to_upper(base_ccy), str_to_upper(price_ccy)]);
	}
}


//-----------------------------------------------------------------------
//  class fx_spot
//----------------------------------------------------------------------
class fx_spot: public instrument
option(category: "Instrument/FX")
//option(allow_undeclared_mfuncs)
{
public:
    //override string	instr_type_s();
	override instrument 	inst();

	void 		nominal(out number, out number,error_info option(nullable) error = null<error_info> );

	date 		spot_date(error_info option(nullable) error = null<error_info>) ;
	integer  	pip_decimals(error_info option(nullable) error = null<error_info> );
	integer 	quote_dec(error_info option(nullable) error = null<error_info> ); 
	integer 	scale(error_info option(nullable) error = null<error_info> );
	integer 	spot_days(error_info option(nullable) error = null<error_info> ); 
	logical 	reverse_ric(error_info option(nullable) error = null<error_info> ); 
	string 		base_ccy(error_info option(nullable) error = null<error_info> ) ;
	string 		price_ccy(error_info option(nullable) error = null<error_info>) ;
	string 		spot_name(error_info option(nullable) error = null<error_info> ) ;
	string 		spot_code(error_info option(nullable) error = null<error_info> ) ;
	calendar 	base_ccy_calendar(error_info option(nullable) error = null<error_info> ) ;
	calendar 	price_ccy_calendar(error_info option(nullable) error = null<error_info> ) ;
	calendar 	usd_calendar(error_info option(nullable) error = null<error_info> ) ;
	string 		base_ccy_calendar_name(error_info option(nullable) error = null<error_info> ) ;
	string 		price_ccy_calendar_name(error_info option(nullable) error = null<error_info> ) ;
	string 		usd_calendar_name(error_info option(nullable) error = null<error_info> ) ;
	fx_spot_rule spot_rule(error_info option(nullable) error = null<error_info> );
	
	//global quote funcs
	override number 	quote(error_info option(nullable) error = null<error_info>);
	override number 	quote(..quote_style option(nullable),error_info option(nullable) error = null<error_info>);			
	
	//FIX_ME: following 3 quote funcs return err but should be implemented
	//override number 	quote(date option(nullable) ,  string option(nullable) , out instr_error option(nullable));
	//override number 	quote(integer,  string option(nullable) quote_side = null<string>, out instr_error option(nullable));
	//override vector(number) quote(vector(date) ,  string option(nullable) quote_side = null<string>, out instr_error option(nullable));

	//local quote funcs
	number 				quote(	logical	,logical ,error_info option(nullable) error = null<error_info>);
	number 				quote_inv(number option(nullable)	,logical,error_info option(nullable) error = null<error_info>);
	//number			quote(	string,logical,logical  );/*hidden*/
	
	number 				convert_cash(number ,string,error_info option(nullable) error = null<error_info>);
	integer 			scale_inv(error_info option(nullable) error = null<error_info>);
	number 				pips(number ,number ,error_info option(nullable) error = null<error_info>);
	number 				points(number ,number);											//backward compat

	number 				cross_quote(number option(nullable) ,fx_spot,number option(nullable) ,logical ,integer,integer ,logical ,									
									out string,out string, error_info option(nullable) error = null<error_info>);
		
	void 				cross_quote(number  ,number ,fx_spot,number ,number  ,out number ,out number ,
									logical fx2_is_base = false,integer cross_scale = 1,integer cross_decimals = 15,
									logical	cross_fix_spread = false,number option(nullable) cross_bid_spread = null<number>,
									number option(nullable) cross_ask_spread = null<number>,logical cross_unit_quote = false,
									error_info option(nullable) error = null<error_info>); 

	//void 				cross_quote(number option(nullable) ,fx_spot 	,number option(nullable) ,logical,out fx_spot	,	
		//							error_info option(nullable) error = null<error_info> );
	
	void 				cross_quote(number option(nullable) ,fx_spot 	,number option(nullable) ,logical,INSTR_TMPL.fx_spot_def_tmpl option(nullable),
									out fx_spot,error_info option(nullable) error = null<error_info> );
	
	void				cross_quote(	number  bid_quote,
							number  ask_quote,
							fx_spot 				fx2,
							number  fx2_bid_quote,
							number  fx2_ask_quote,
							logical 				fx2_is_base,
							INSTR_TMPL.fx_spot_def_tmpl option(nullable) fx_tmpl,
							out fx_spot 			cross_bid,
							out fx_spot 			cross_ask,														
							logical					cross_fix_spread,
							number option(nullable) cross_bid_spread,
							number option(nullable) cross_ask_spread,								
							error_info option(nullable) error = null<error_info>) ;

	fx_spot				set_quote(number option(nullable) ,date  option(nullable) ,logical option(nullable) ,
								  error_info option(nullable) error = null<error_info>);
	fx_spot				set_quote(number option(nullable) ,logical option(nullable) ,
								  error_info option(nullable) error = null<error_info>);

	override void 		add_quote(number,logical option(nullable));//OBS! second arg is not the same as root FIX_ME

	fx_spot 			set_date(date,logical,logical ,error_info option(nullable) error = null<error_info>);							
	
	fx_spot(__instrument);	
	override fx_spot clone();
	fx_spot(fx_spot);
	
protected:

	override fx_spot		create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);
							
	override fx_spot 		set_date(date,date option(nullable) s=null<date> ,logical r = true,logical rq = true ,
									 error_info option(nullable) error = null<error_info>);	
	override fx_spot 		set_date(date,logical ,error_info option(nullable) error = null<error_info>);						/*legacy*/

	override fx_spot 		move_date(	date,date option(nullable) s=null<date> ,
										error_info option(nullable) error = null<error_info>);									/*legacy*/
	/*err funcs*/
	//override number 		quote(..quote_style ,out instr_error option(nullable));

	override number 		quote(disc_func,..quote_style option(nullable),error_info option(nullable) error = null<error_info>);
	void 					currencies(	out string , out string );
	override date 			maturity_adj(error_info option(nullable) error = null<error_info> );
	    
};


//------------------------------------------------
// create  [PROTECTED]
// create fx_spot from internal instrument
//------------------------------------------------

fx_spot fx_spot.create(	__instrument option(nullable) c,
						out instr_error option(nullable) error,
						error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<fx_spot>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.FX_SPOT, "invalid instrument type",type );//should not happen
	
	return new fx_spot(c);
}


/*-----------------------------------------------------------------------
  create_fx_spot  <FUNCTION>
  ----------------------------------------------------------------------*/
fx_spot create_fx_spot(	__instrument option(nullable) c,
						out instr_error option(nullable) error,
						error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_fx_spot')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<fx_spot>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.FX_SPOT, "invalid instrument type",type );//should not happen
	
	
	return new fx_spot(c);
}

fx_spot create_fx_spot(	__instrument option(nullable) 		c,
						error_info option(nullable) 		error,
						error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_fx_spot_ei')
{
	instr_error ee 	= instr_error();
	fx_spot b 	= create_fx_spot(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_fx_spot");
	return b;
}
//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
fx_spot.fx_spot(__instrument i) option(hidden) : instrument(i)	{}
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string fx_spot.instr_type_s() 	{ return string(..instr_type.FX_SPOT);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	fx_spot.inst()		{ return this;}
//------------------------------------------------
// copy constructor
//------------------------------------------------
fx_spot.fx_spot(fx_spot c) : instrument(c) {}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
//------------------------------------------------
fx_spot fx_spot(fx_spot b)		{ return new fx_spot(b);}
//------------------------------------------------
// clone
//------------------------------------------------
fx_spot fx_spot.clone()			{ return new fx_spot(this);}

//-----------------------------------------------
// dynamic cast <FUNCTION>
//-----------------------------------------------
fx_spot fx_spot(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/FX')
option(com_name: 'fx_spot_dyncast') 
{ 
	try {
		fx_spot d = dynamic_cast<fx_spot>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a fx_spot)","fx_spot" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot");
		return null<fx_spot>;
	}
}


/*-----------------------------------------------------------------------
  set_date  (a version without settledate as argument)
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
fx_spot fx_spot.set_date(	date  				trade_date, 					
							logical 			re_init_static, 
							logical 			re_init_quote, 
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,null<date>,re_init_static,re_init_quote,error);
	return null(cc) ? null<fx_spot>: dynamic_cast<fx_spot>(cc);
	
}
/*-----------------------------------------------------------------------
  bill: set_date <protected>
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
fx_spot fx_spot.set_date(	date  				trade_date, 
							date  option(nullable)	settle_date,
							logical 			re_init_static, 
							logical 			re_init_quote, 
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,null<date>,re_init_static,re_init_quote,error);
	return null(cc) ? null<fx_spot>: dynamic_cast<fx_spot>(cc);
	
}

/*-----------------------------------------------------------------------
  set_date <protected/legacy>
	quote is NOT kept even if trade_date is unchanged
  ----------------------------------------------------------------------*/
fx_spot fx_spot.set_date(	date  				trade_date, 
							logical 			re_init_static, 
							error_info option(nullable) error) 

{	
	instrument cc = instrument._set_date(trade_date,re_init_static,error);
	return null(cc) ? null<fx_spot>: dynamic_cast<fx_spot>(cc);	
}

/*-----------------------------------------------------------------------
   move_date  <protected/legacy>
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	if trade date is the same --> the settle date will be preserved	
  ----------------------------------------------------------------------*/
fx_spot fx_spot.move_date(	date  				trade_date, 
							date option(nullable) settle_date,
							error_info option(nullable) error) 
{	
	instrument cc = instrument._move_date(trade_date,null<date>,error);
	return null(cc) ? null<fx_spot>: dynamic_cast<fx_spot>(cc);
}

/*-----------------------------------------------------------------------
  fx_spot: nominal
  ----------------------------------------------------------------------*/
void  fx_spot.nominal(	out number base_ccy_nominal,
						out number price_ccy_nominal,	
						error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__fx_nominal(base_ccy_nominal,price_ccy_nominal,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fx_spot.nominal");	
		if(e)
			base_ccy_nominal = price_ccy_nominal = null<number>;
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot.nominal");	
		base_ccy_nominal = price_ccy_nominal = null<number>;
		return ;
	}
}

date 	fx_spot.spot_date(error_info option(nullable) error) 				{ return fx_spot_date(error) ;}
integer fx_spot.pip_decimals(error_info option(nullable) error)				{ return fx_pip_decimals(error);}
integer fx_spot.quote_dec(error_info option(nullable) error) 				{ return fx_quote_dec(error);}
integer fx_spot.scale(error_info option(nullable) error)					{ return fx_scale(error);}
integer fx_spot.spot_days(error_info option(nullable) error)				{ return fx_spot_days(error);}
logical fx_spot.reverse_ric(error_info option(nullable) error)				{ return fx_reverse_ric(error);}
string  fx_spot.base_ccy(error_info option(nullable) error)					{ return fx_base_ccy(error);}
string  fx_spot.price_ccy(error_info option(nullable) error)				{ return fx_price_ccy(error);}
string  fx_spot.spot_name(error_info option(nullable) error)				{ return fx_spot_name(error);}
string  fx_spot.spot_code(error_info option(nullable) error)				{ return fx_spot_code(error);}
string  fx_spot.price_ccy_calendar_name(error_info option(nullable) error)	{ return fx_price_ccy_calendar_name(error);}
string  fx_spot.base_ccy_calendar_name(error_info option(nullable) error)	{ return fx_base_ccy_calendar_name(error);}
string  fx_spot.usd_calendar_name(error_info option(nullable) error)		{ return fx_usd_calendar_name(error);}
calendar fx_spot.price_ccy_calendar(error_info option(nullable) error)		{ return fx_price_ccy_calendar(error);}
calendar fx_spot.base_ccy_calendar(error_info option(nullable) error)		{ return fx_base_ccy_calendar(error);}
calendar fx_spot.usd_calendar(error_info option(nullable) error)			{ return fx_usd_calendar(error);}
fx_spot_rule fx_spot.spot_rule(error_info option(nullable) error)			{ return fx_rule(error);}
date  fx_spot.maturity_adj(error_info option(nullable) error)  				{ return maturity(error);}

/*-----------------------------------------------------------------------
  fx_spot: set_quote
  the quote is a proper quote i.e. it should not be the inverse if it has the inverse flag set to true
  ----------------------------------------------------------------------*/
fx_spot fx_spot.set_quote(	number 	option(nullable) quote,
							date  	option(nullable) trade_date, 
							logical option(nullable) quote_is_unit,								
							error_info option(nullable) error) 
{	
	try{				
		__instrument  c = i().__fx_set_quote(quote, trade_date,quote_is_unit);
		instr_error e 	= instr_error();
		fx_spot  cc 	= create( c, e, E_INIT);

		CORE_INT.instr_fail_check(null(cc), "invalid fx_spot", this, e);
		
		if(!cc.is_valid(error))
			return null<fx_spot>;
		
		return cc ;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot.set_quote");
		return null<fx_spot>;
	}
}

fx_spot fx_spot.set_quote(	number 		option(nullable) quote,							
							logical 	option(nullable) quote_is_unit,
							error_info option(nullable) error )  
{
	return this.set_quote(	quote,null<date>  ,quote_is_unit, error ) ;
}

/*-----------------------------------------------------------------------
  fx_spot: quote
  	this is a proper quote in that it handles reverse_ric
	--> base_currency is always the underlying 
	 (OBS if reverse_ric = true --> bid-ask fields in realtime link must be changed accordingly) 
  ----------------------------------------------------------------------*/
number  fx_spot.quote(	logical		unit_quote,
						logical 	no_rnd,	
						error_info option(nullable) error)
{	
	return instrument.fx_quote(unit_quote,no_rnd,error);
}
/*-----------------------------------------------------------------------
  fx_spot: quote   
  ----------------------------------------------------------------------*/
number  fx_spot.quote(error_info option(nullable) error)
{	
	return this.quote(false,false, error);
}
/*-----------------------------------------------------------------------
  fx_spot: quote   
  ----------------------------------------------------------------------*/
number  fx_spot.quote(..quote_style option(nullable) qs, error_info option(nullable) error)
{
	try {
		QL_FAIL_COND(!null(qs) && qs != ..quote_style.FX_RATE, "invalid quote style (only FX_RATE is applicable)", this, true) ;			
		return this.quote(false,false, error);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot.quote");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  quote_inv
	--> price_currency is always the underlying
  ----------------------------------------------------------------------*/
number  fx_spot.quote_inv(	number option(nullable)		inv_scale,//multiplier of the inverse
							logical 					no_rnd,		
							error_info option(nullable) error)
{
	try {
		if(!null(inv_scale) && inv_scale > 0)		
			return fx_quote_inv(inv_scale,no_rnd,error);
		else {
			error_info ee = error_info(true,true);
			integer s = scale_inv(ee);
			if(s == err_int()) s = 1;
			return fx_quote_inv(s,no_rnd,error);
		}
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot.quote_inv");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  currencies  internal
  ----------------------------------------------------------------------*/
void fx_spot.currencies(	out string b_ccy,
							out string p_ccy)
{
	
	error_info ee = error_info(true,true);
	
	p_ccy = price_ccy(ee);		
	CORE_INT.instr_fail_check(null(p_ccy), "invalid price currency", this, ee);

	b_ccy = base_ccy(ee);
	CORE_INT.instr_fail_check(null(b_ccy), "invalid base currency", this, ee);
		
}
	
/*-----------------------------------------------------------------------
  convert_cash
  ----------------------------------------------------------------------*/
number fx_spot.convert_cash(number amount,
							string amount_ccy,
							error_info option(nullable) error)
{
	try {
		string bc,pc;
		currencies(	bc,pc);
		
		error_info ee = error_info(true,true);	
		number q;
		if(equal_casei(amount_ccy, pc))  
			q = quote_inv(1, false, ee);			
		else if(equal_casei(amount_ccy, bc)) 
			q = quote(true, false, ee);
		else
			QL_FAIL("incompatible currency",this,true);

		CORE_INT.instr_fail_check(null(q), "invalid quote", this, ee);			
		
		return q * amount;
	}
	catch {		
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot.convert_cash");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  quote
  ----------------------------------------------------------------------*/
/*number fx_spot.quote(	string base_c,
						logical unit_quote,
						logical no_rnd ) option(hidden)
{
	if(base_c == base_ccy())
		return quote(unit_quote, no_rnd, false);
	else if(base_c == price_ccy())
		return quote_inv(unit_quote ? 1:null<number>, no_rnd, false);
	else
		return null<number>;
}*/

/*-----------------------------------------------------------------------
  scale_inv 
	number of units of base currency in inverted pair 
  ----------------------------------------------------------------------*/
integer  fx_spot.scale_inv(error_info option(nullable) error)
{	
	try{
		string bc,pc;
		currencies(	bc,pc);
		
		instrument_name name = CORE_INT_FX.fx_inst_name(pc, bc);			
		__instrument c = __instrument(name,this.trade_date(),1, null<date> );
		
		instr_error e = new instr_error();
		fx_spot fxs_inv = create_fx_spot( c, e);
		CORE_INT.instr_fail_check(null(fxs_inv), "invalid fx_spot inverted", this, e);
		return fxs_inv.scale(error);

	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot.scale_inv");
		return err_int();
	}
}

/*-----------------------------------------------------------------------
  add_quote
  ----------------------------------------------------------------------*/
void fx_spot.add_quote(	number  quote,
						logical option(nullable) quote_is_unit)
{		
	instrument.fx_add_quote(quote,quote_is_unit);						
}

/*-----------------------------------------------------------------------
  pips
  ----------------------------------------------------------------------*/
number 	fx_spot.pips(number fx_quote1,
					number fx_quote2,	
					error_info option(nullable) error)	
{ 
	return (fx_quote2-fx_quote1)*pow(10.0, fx_pip_decimals(error));
}

number 	fx_spot.points(	number fx_quote1,
						number fx_quote2)	 option(hidden)
{
	return (fx_quote2-fx_quote1)*pow(10.0, fx_pip_decimals());
}
/*-----------------------------------------------------------------------
  fx_spot: cross_quote
  fx_cross must be defined in database
  ----------------------------------------------------------------------*/
/*void  fx_spot.cross_quote(	number option(nullable) quote,
							fx_spot 				fx2,
							number option(nullable) fx2_quote,
							logical 				fx2_is_base,							
							out fx_spot				cross,							
							error_info option(nullable) error)
{	
	try{	
		integer	cross_scale 		= 1;
		integer 	cross_decimals 	= 15;
		logical cross_unit_quote 	= true;
		
		instr_error_type t;
   		string cross_base, cross_price,s;	
		number q_unit = i().__fx_cross_quote(quote,fx2.i(), fx2_quote,fx2_is_base,cross_scale,cross_decimals,
									cross_unit_quote,cross_base,cross_price,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fx_spot.cross_quote");			
		if(e) {
			cross = null<fx_spot>;
			return;
		}
				
		instrument_name name 	= CORE_INT_FX.fx_inst_name(cross_base,cross_price);			
		__instrument ci 		= __instrument(name,this.trade_date(),null<number>, null<date> );
		instr_error ee 			= new instr_error();
		if(null(ci)){			
			CORE_INT.instr_fail_check(true, strcat(["created fx-cross (",name," ) not defined in database"]), this, ee);	
		}
		cross 					= create_fx_spot( ci, ee);
		CORE_INT.instr_fail_check(null(cross), "invalid cross", this, ee);							
		cross 					= cross.set_quote(q_unit,this.trade_date(),cross_unit_quote, error) ;
				
		return ;						
	}
	catch {
		cross = null<fx_spot>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot.cross_quote");
		return ;
	}
}*/

/*-----------------------------------------------------------------------
  fx_spot: cross_quote
  fx_cross defined from template
  ----------------------------------------------------------------------*/
void  fx_spot.cross_quote(	number option(nullable) quote,
							fx_spot 				fx2,
							number option(nullable) fx2_quote,
							logical 				fx2_is_base,
							INSTR_TMPL.fx_spot_def_tmpl option(nullable) fx_tmpl,
							out fx_spot				cross,							
							error_info option(nullable) error)
{	
	try{	
		integer	cross_scale 		= 1;
		integer 	cross_decimals 	= 15;
		logical cross_unit_quote 	= true;
		
		instr_error_type t;
   		string cross_base, cross_price,s;	
		number q_unit = i().__fx_cross_quote(quote,fx2.i(), fx2_quote,fx2_is_base,cross_scale,cross_decimals,
									cross_unit_quote,cross_base,cross_price,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fx_spot.cross_quote");			
		if(e) {
			cross = null<fx_spot>;
			return;
		}

		__instrument ci;
		instr_error ee = new instr_error();
		instrument_name name 	= CORE_INT_FX.fx_inst_name(cross_base,cross_price);		
		
		if(!null(fx_tmpl)){
			
			CORE_INT.instr_fail_check(fx_tmpl.base_ccy() != cross_base, "invalid template (base currency mismatch)", this, ee);
			CORE_INT.instr_fail_check(fx_tmpl.price_ccy() != cross_price, "invalid template (price currency mismatch)", this, ee);
					
			error_info er 		= new error_info(true,true);
			..instr_def def 	= instr_def_fx_spot(fx_tmpl,er);
			if(null(def) || !def.is_valid()) {			
				CORE_INT.instr_fail_check(true, strcat(["error creating fx-cross instr_def (",fx_tmpl.name()," )"]), this, ee);
			}
			ci 	= __instrument_fxspot_nodb(def,name,this.trade_date(),null<number>, null<number> );
			if(null(ci)|| !ci.is_valid(ee)) {			
				CORE_INT.instr_fail_check(true, strcat(["error creating fx-cross (",fx_tmpl.name()," )"]), this, ee);
			}
		}
		else {
					
			ci  = __instrument(name,this.trade_date(),null<number>, null<date> );
			
			if(null(ci)|| !ci.is_valid(ee)){			
				CORE_INT.instr_fail_check(true, strcat(["created fx-cross (",name," ) not defined in database"]), this, ee);	
			}
		}

		
		cross 				= create_fx_spot( ci, ee);
		CORE_INT.instr_fail_check(null(cross)|| !cross.is_valid(), "invalid cross", this, ee);

		integer sp_days 	= this.spot_days();
		integer sp2_days 	= fx2.spot_days();
		integer cr_sp_days 	= cross.spot_days();
		if(cr_sp_days != max(sp_days,sp2_days))
			CORE_INT.instr_fail_check(true, strcat(["invalid spot days for cross (",name," )"]), this, ee);
		
		cross 				= cross.set_quote(q_unit,this.trade_date(),cross_unit_quote, error) ;
				
		return ;						
	}
	catch {
		cross = null<fx_spot>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot.cross_quote");
		return ;
	}
}

/*-----------------------------------------------------------------------
  cross_quote
  ----------------------------------------------------------------------*/
number  fx_spot.cross_quote(number option(nullable) quote,
							fx_spot 				fx2,
							number option(nullable) fx2_quote,
							logical 				fx2_is_base,
							integer					cross_scale,
							integer 				cross_decimals,	
							logical 				cross_unit_quote,
							out string				cross_base,
							out string				cross_price,	
							error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__fx_cross_quote(quote,fx2.i(), fx2_quote,fx2_is_base,cross_scale,cross_decimals,
									cross_unit_quote,cross_base,cross_price,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fx_spot.cross_quote");
		if(e){
			cross_base = cross_price = null<string>;
			return null<number>;
		}
		return c;						
	}
	catch {
		cross_base = cross_price = null<string>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot.cross_quote");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  cross_quote
  fx_cross defined from template
  ----------------------------------------------------------------------*/
void  fx_spot.cross_quote(	number   	bid_quote,
							number   	ask_quote,
							fx_spot 	fx2,
							number   	fx2_bid_quote,
							number   	fx2_ask_quote,
							logical 	fx2_is_base,
							INSTR_TMPL.fx_spot_def_tmpl option(nullable) fx_tmpl,
							out fx_spot 			cross_bid,
							out fx_spot 			cross_ask,														
							logical					cross_fix_spread,
							number option(nullable) cross_bid_spread,
							number option(nullable) cross_ask_spread,								
							error_info option(nullable) error) 

{	
	try{
		integer	cross_scale 		= 1;
		integer cross_decimals 		= 15;
		logical cross_unit_quote 	= true;

		number cross_bidq,cross_askq;
		instr_error_type t;
   		string 	cross_base, cross_price,s;
		i().__fx_cross_quote(bid_quote,ask_quote,fx2.i(), fx2_bid_quote,fx2_ask_quote,cross_bidq,cross_askq,
							fx2_is_base,cross_scale,cross_decimals,cross_fix_spread,cross_bid_spread,
							cross_ask_spread, cross_unit_quote,cross_base, cross_price,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fx_spot.cross_quote");	
		if(e) {			
			cross_bid = cross_ask = null<fx_spot>;
			return;
		}	
		
		instr_error ee 	= new instr_error();
		instrument_name name 	= CORE_INT_FX.fx_inst_name(cross_base,cross_price);	
		__instrument ci;
		
		if(!null(fx_tmpl)){
			CORE_INT.instr_fail_check(fx_tmpl.base_ccy() != cross_base, "invalid template (base currency mismatch)", this, ee);
			CORE_INT.instr_fail_check(fx_tmpl.price_ccy() != cross_price, "invalid template (price currency mismatch)", this, ee);
					
			error_info er 	= new error_info(true,true);
			..instr_def def = instr_def_fx_spot(fx_tmpl,er);
			if(null(def) || !def.is_valid()) {			
				CORE_INT.instr_fail_check(true, strcat(["error creating fx-cross instr_def (",fx_tmpl.name()," )"]), this, ee);
			}
			ci 	= __instrument_fxspot_nodb(def,name,this.trade_date(),null<number>, null<number> );
			if(null(ci)|| !ci.is_valid(ee)) {			
				CORE_INT.instr_fail_check(true, strcat(["error creating fx-cross (",fx_tmpl.name()," )"]), this, ee);
			}
		}
		else {
					
			ci = __instrument(name,this.trade_date(),null<number>, null<date> );
			
			if(null(ci)|| !ci.is_valid(ee)){			
				CORE_INT.instr_fail_check(true, strcat(["created fx-cross (",name," ) not defined in database"]), this, ee);	
			}
		}
		cross_bid 		= create_fx_spot( ci, ee);
		CORE_INT.instr_fail_check(null(cross_bid)|| !cross_bid.is_valid(), "invalid bid cross", this, ee);

		integer sp_days 	= this.spot_days();
		integer sp2_days 	= fx2.spot_days();
		integer cr_sp_days 	= cross_bid.spot_days();
		if(cr_sp_days != max(sp_days,sp2_days))
			CORE_INT.instr_fail_check(true, strcat(["invalid spot days for cross (",name," )"]), this, ee);
		
		cross_ask 		= create_fx_spot( ci, ee);
		CORE_INT.instr_fail_check(null(cross_ask)|| !cross_ask.is_valid(), "invalid ask cross", this, ee);							
		cross_bid 		= cross_bid.set_quote(cross_bidq,this.trade_date(),cross_unit_quote, error) ;
		cross_ask 		= cross_ask.set_quote(cross_askq,this.trade_date(),cross_unit_quote, error) ;
		
		return ;						
	}
	catch {
		cross_bid = cross_ask = null<fx_spot>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot.cross_quote");
		return ;
	}
}



/*-----------------------------------------------------------------------
  fx_spot: cross_quote
  ----------------------------------------------------------------------*/
void  fx_spot.cross_quote(	number  	bid_quote,
							number  	ask_quote,
							fx_spot 	fx2,
							number  	fx2_bid_quote,
							number  	fx2_ask_quote,
							out number 				cross_bid,
							out number 				cross_ask,
							logical 				fx2_is_base,
							integer					cross_scale,
							integer 				cross_decimals,
							logical					cross_fix_spread,
							number option(nullable) cross_bid_spread,
							number option(nullable) cross_ask_spread,	
							logical 				cross_unit_quote,
							error_info option(nullable) error) 

{	
	try{	
		instr_error_type t;
   		string 	cross_base, cross_price,s;	
		i().__fx_cross_quote(bid_quote,ask_quote,fx2.i(), fx2_bid_quote,fx2_ask_quote,cross_bid,cross_ask,
										fx2_is_base,cross_scale,cross_decimals,cross_fix_spread,cross_bid_spread,
										cross_ask_spread, cross_unit_quote,cross_base, cross_price,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fx_spot.cross_quote");	
		if(e) {			
			cross_bid = cross_ask = null<number>;
		}
		return ;						
	}
	catch {
		cross_bid = cross_ask = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot.cross_quote");
		return ;
	}
}


/*-----------------------------------------------------------------------
  err funcs  
  ----------------------------------------------------------------------*/
//number fx_spot.quote(..quote_style.quote_style quote_style,error_info option(nullable) error) 	{ fin_instr.err_type(1, error);}
number fx_spot.quote(disc_func	disc_func,..quote_style	option(nullable) quote_style,									
					error_info option(nullable) error) 							{ return fin_instr.err_type(1.0, error);}

/****************
/****************
/****************
/****************
/****************/

/*-----------------------------------------------------------------------
  fx_spot: quote
  ----------------------------------------------------------------------*/
/*number  fx_spot.quote(	logical 		base_currency,
						logical		unit_quote=false,
						logical 	no_rnd=false,	
						error_info option(nullable) error)
{	
	return fx_quote(unit_quote,no_rnd,error);
}
*/



