option(null: hard);	// Throw error if a null value is used in a non-nullable context

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	fx_swap
	--------------------------------------------------------------------
*/

//-----------------------------------------------------------------------
//  class fx_swap
//----------------------------------------------------------------------
class fx_swap: public instrument
option(category: "Instrument/FX")
//option(allow_undeclared_mfuncs)
{
public:
    //override string			instr_type_s();
	override instrument 	inst();
	
	//fx_swap					create_fx_swap(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);
	
	date 			spot_date(error_info option(nullable) error = null<error_info>) ;
	override date 	first_settle_date(error_info option(nullable) error = null<error_info>) ;
	integer  		pip_decimals(error_info option(nullable) error = null<error_info> );
	integer 		quote_dec(error_info option(nullable) error = null<error_info> ); 
	integer 		scale(error_info option(nullable) error = null<error_info> ); 
	logical 		reverse_ric(error_info option(nullable) error = null<error_info> ); 
	logical 		is_post_spot(instrument,error_info option(nullable) error = null<error_info> ) ;
	string 			base_ccy(error_info option(nullable) error = null<error_info> ) ;
	string 			price_ccy(error_info option(nullable) error = null<error_info> ) ;
	string 			spot_name(error_info option(nullable) error = null<error_info> ) ;
	string 			spot_code(error_info option(nullable) error = null<error_info> ) ;
	calendar 		base_ccy_calendar(error_info option(nullable) error = null<error_info> ) ;
	calendar 		price_ccy_calendar(error_info option(nullable) error = null<error_info> ) ;
	calendar 		usd_calendar(error_info option(nullable) error = null<error_info> ) ;
	string 			base_ccy_calendar_name(error_info option(nullable) error = null<error_info> ) ;
	string 			price_ccy_calendar_name(error_info option(nullable) error = null<error_info> ) ;
	string 			usd_calendar_name(error_info option(nullable) error = null<error_info> ) ;
	fx_spot_rule 	spot_rule(error_info option(nullable) error = null<error_info> );
	
	logical 		is_post_spot(..fx_spot ,error_info option(nullable) error = null<error_info>) ;

	number 			rate_base(	..fx_spot,day_count_method,rate_type ,number ,day_count_method ,
								rate_type ,fx_swap option(nullable) ,error_info option(nullable) error = null<error_info>);

	number 			rate_base(	number,day_count_method,rate_type ,number ,day_count_method ,
								rate_type ,number option(nullable) ,error_info option(nullable) error = null<error_info>);
		
	number 			rate_price(	..fx_spot,day_count_method,rate_type ,number ,day_count_method ,
								rate_type ,fx_swap option(nullable) ,error_info option(nullable) error = null<error_info>);

	number 			rate_price(	number,day_count_method,rate_type ,number ,day_count_method ,
								rate_type ,number option(nullable) ,error_info option(nullable) error = null<error_info>);
	
	number			df_to_swap(	disc_func ,disc_func,..fx_spot ,fx_swap option(nullable) ,
									logical	unit_quote = false,logical no_rnd = false,error_info option(nullable) error = null<error_info>) ;

	number			df_to_swap(	disc_func ,disc_func,number ,number option(nullable) ,
									logical	unit_quote = false,logical no_rnd = false,error_info option(nullable) error = null<error_info>) ;

	
	void			tail(number,number option(nullable) ,logical ,disc_func	,disc_func,
							..fx_spot ,fx_swap option(nullable) ,logical,logical ,out number,
							out number ,error_info option(nullable) error = null<error_info>) ;

	void			tail(number,number option(nullable) ,logical ,disc_func	,disc_func,
							number ,number option(nullable) ,logical,logical ,out number,
							out number ,error_info option(nullable) error = null<error_info>) ;
	
	void 			cashflow(number ,number option(nullable) ,logical ,disc_func,
								..fx_spot ,fx_swap option(nullable) ,logical,out vector(number)   ,
								out vector(number)   ,error_info option(nullable) error = null<error_info>) ;

	void 			cashflow(number ,number option(nullable) ,logical ,disc_func,
								number ,number option(nullable) ,logical,out vector(number)   ,
								out vector(number)   ,error_info option(nullable) error = null<error_info>) ;
	
	number 			outright(number option(nullable) ,..fx_spot,fx_swap option(nullable),logical unit_quote = false,
								logical no_rnd = false,error_info option(nullable) error = null<error_info>);

	number 			outright(number option(nullable) ,number,number option(nullable),logical unit_quote = false,
								logical no_rnd = false,error_info option(nullable) error = null<error_info>);

	//number 			cross_quote(number option(nullable) ,fx_swap,number option(nullable) ,logical,integer,integer ,logical,	
		//						out string	,out string	,error_info option(nullable) error = null<error_info> );
	
	fx_swap			set_quote(number option(nullable) ,date  option(nullable) ,logical option(nullable) ,
							  error_info option(nullable) error = null<error_info> );
	fx_swap			set_quote(number option(nullable) ,logical option(nullable) ,
							  error_info option(nullable) error = null<error_info> );
	override void 	add_quote(number,logical option(nullable));

	instrument  	synt_depo(instrument,day_count_method,number,day_count_method,logical ,instrument option(nullable),
								error_info option(nullable) error = null<error_info> ) ;

	instrument  	synt_depo(number,day_count_method,number,day_count_method,logical ,number option(nullable),
								error_info option(nullable) error = null<error_info> ) ;
	
	..fx_spot 		create_fx_spot(number option(nullable) quote = null<number> ,error_info option(nullable) error = null<error_info>);
	..fx_spot 		create_fx_spot(string option(nullable) ,error_info option(nullable) error = null<error_info>);

	override number quote(error_info option(nullable) error = null<error_info>);
	override number quote(..quote_style option(nullable),error_info option(nullable) error = null<error_info>);			
	//FIX_ME: following 3 quote funcs return err but should be implemented
	//override number 	quote(date option(nullable) ,  string option(nullable) , error_info option(nullable) error = null<error_info>);
	//override number 	quote(integer,  string option(nullable) , out instr_error option(nullable));
	//override vector(number) quote(vector(date) ,  string option(nullable) , out instr_error option(nullable));	

	number 			quote(	logical	,logical ,error_info option(nullable) error = null<error_info>);		
	fx_swap			set_date(date,logical,logical ,error_info option(nullable) error = null<error_info>);						

	override string	__curve_sort_maturity() ;
	
	fx_swap(__instrument);	
	override fx_swap clone();
	fx_swap(fx_swap);
protected:
	
	override fx_swap		create(	__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);
					
	override fx_swap		set_date(date,date option(nullable) s=null<date> ,logical r = true,logical rq = true ,
									 error_info option(nullable) error = null<error_info>);	
	override fx_swap		set_date(date,logical ,error_info option(nullable) error = null<error_info>);							/*legacy*/
	override fx_swap		move_date(	date,date option(nullable) s=null<date> ,
										error_info option(nullable) error = null<error_info>);	/*legacy*/
	override instrument  	fx_synt_depo(instrument,day_count_method,number,day_count_method,logical ,instrument option(nullable),
										error_info option(nullable) error = null<error_info> ) ;

	/*err funcs*/
	//override number 		quote(..quote_style ,out instr_error option(nullable));
	override number 		quote(disc_func,..quote_style option(nullable),error_info option(nullable) error = null<error_info>);
	void 					currencies(	out string , out string );
};

//------------------------------------------------
// create  [PROTECTED]
// create fx_swap from internal instrument
//------------------------------------------------
fx_swap fx_swap.create(	__instrument option(nullable) c,
						out instr_error option(nullable) error,
						error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<fx_swap>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.FX_SWAP, "invalid instrument type",type );//should not happen
	
	
	return new fx_swap(c);
}
/*-----------------------------------------------------------------------
  create_fx_swap
  ----------------------------------------------------------------------*/
fx_swap create_fx_swap(	__instrument option(nullable) c,
						out instr_error option(nullable) error,
						error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_fx_swap')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<fx_swap>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.FX_SWAP, "invalid instrument type",type );//should not happen
	
	return new fx_swap(c);
}

fx_swap create_fx_swap(	__instrument option(nullable) 		c,
						error_info option(nullable) 		error,
						error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_fx_swap_ei')
{
	instr_error ee 	= instr_error();
	fx_swap b 	= create_fx_swap(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_fx_swap");
	return b;
}
//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
fx_swap.fx_swap(__instrument i) option(hidden): instrument(i){}
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string fx_swap.instr_type_s() 	{ return string(..instr_type.FX_SWAP);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	fx_swap.inst()		{ return this;}
//------------------------------------------------
// copy constructor
//------------------------------------------------
fx_swap.fx_swap(fx_swap c) : instrument(c) {}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
fx_swap fx_swap(fx_swap b)		{ return new fx_swap(b);}
//------------------------------------------------
// clone
//------------------------------------------------
fx_swap fx_swap.clone()			{ return new fx_swap(this);}
//-----------------------------------------------
// dynamic cast <FUNCTION>
//-----------------------------------------------
fx_swap fx_swap(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/FX')
option(com_name: 'fx_swap_dyncast') 
{ 
	try {
		fx_swap d = dynamic_cast<fx_swap>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a fx_swap)","fx_swap" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap");
		return null<fx_swap>;
	}
}


/*-----------------------------------------------------------------------
  __curve_sort_maturity
  ----------------------------------------------------------------------*/
string fx_swap.__curve_sort_maturity() option(hidden)
{
	try {
		instr_error_type t;
   		string 			s;
		date m;
		try {
			m = i().__fx_curve_sort_date(t,s);
			if(null(m))
				m = maturity_adj();
		}
		catch {
			m = maturity_adj();
		}
		return strcat(string(m), name());
	}
	catch {
		return "";
	}
}

/*-----------------------------------------------------------------------
  set_date  (a version without settledate as argument)
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
fx_swap fx_swap.set_date(	date  				trade_date, 					
							logical 			re_init_static, 
							logical 			re_init_quote, 
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,null<date>,re_init_static,re_init_quote,error);
	return null(cc) ? null<fx_swap>: dynamic_cast<fx_swap>(cc);
	
}

/*-----------------------------------------------------------------------
  bill: set_date <protected>
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
fx_swap fx_swap.set_date(	date  				trade_date, 
							date  option(nullable)	settle_date,
							logical 			re_init_static, 
							logical 			re_init_quote, 
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,null<date>,re_init_static,re_init_quote,error);
	return null(cc) ? null<fx_swap>: dynamic_cast<fx_swap>(cc);
	
}

/*-----------------------------------------------------------------------
  set_date <protected/legacy>
	quote is NOT kept even if trade_date is unchanged
  ----------------------------------------------------------------------*/
fx_swap fx_swap.set_date(	date  				trade_date, 
							logical 			re_init_static, 
							error_info option(nullable) error) 

{	
	instrument cc = instrument._set_date(trade_date,re_init_static,error);
	return null(cc) ? null<fx_swap>: dynamic_cast<fx_swap>(cc);	
}


/*-----------------------------------------------------------------------
   move_date  <protected/legacy>
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	if trade date is the same --> the settle date will be preserved	
  ----------------------------------------------------------------------*/
fx_swap fx_swap.move_date(	date  				trade_date, 
							date option(nullable) settle_date,
							error_info option(nullable) error) 
{	
	instrument cc = instrument._move_date(trade_date,null<date>,error);
	return null(cc) ? null<fx_swap>: dynamic_cast<fx_swap>(cc);
}

date 	fx_swap.spot_date(error_info option(nullable) error) 				{ return fx_spot_date(error) ;}
date 	fx_swap.first_settle_date(error_info option(nullable) error) 		{ return first_settle_date(error) ;}
integer fx_swap.pip_decimals(error_info option(nullable) error)				{ return fx_pip_decimals(error);}
integer fx_swap.quote_dec(error_info option(nullable) error)				{ return fx_quote_dec(error);}
integer fx_swap.scale(error_info option(nullable) error)					{ return fx_scale(error);}
logical fx_swap.reverse_ric(error_info option(nullable) error)				{ return fx_reverse_ric(error);}
logical fx_swap.is_post_spot(instrument fxs,error_info option(nullable) error) { return fx_is_post_spot(fxs,error);} 
string  fx_swap.base_ccy(error_info option(nullable) error)					{ return fx_base_ccy(error);}
string  fx_swap.price_ccy(error_info option(nullable) error)				{ return fx_price_ccy(error);}
string  fx_swap.spot_name(error_info option(nullable) error)				{ return fx_spot_name(error);}
string  fx_swap.spot_code(error_info option(nullable) error)				{ return fx_spot_code(error);}
string  fx_swap.price_ccy_calendar_name(error_info option(nullable) error)	{ return fx_price_ccy_calendar_name(error);}
string  fx_swap.base_ccy_calendar_name(error_info option(nullable) error)	{ return fx_base_ccy_calendar_name(error);}
string  fx_swap.usd_calendar_name(error_info option(nullable) error)		{ return fx_usd_calendar_name(error);}
calendar fx_swap.price_ccy_calendar(error_info option(nullable) error)		{ return fx_price_ccy_calendar(error);}
calendar fx_swap.base_ccy_calendar(error_info option(nullable) error)		{ return fx_base_ccy_calendar(error);}
calendar fx_swap.usd_calendar(error_info option(nullable) error)			{ return fx_usd_calendar(error);}
fx_spot_rule fx_swap.spot_rule(error_info option(nullable) error)			{ return fx_rule(error);}

/*-----------------------------------------------------------------------
  fx_swap: set_quote
  ----------------------------------------------------------------------*/
fx_swap fx_swap.set_quote(	number 	option(nullable) quote,
							date  	option(nullable) trade_date, 
							logical option(nullable) quote_is_unit,								
							error_info option(nullable) error) 
{	
	try{				
		__instrument  c = i().__fx_set_quote(quote, trade_date,quote_is_unit);
		instr_error e 	= instr_error();
		fx_swap cc 		= create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid fx_swap", this, e);
		
		if(!cc.is_valid(error))
			return null<fx_swap>;
				
		return cc ;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap.set_quote");
		return null<fx_swap>;
	}
}

fx_swap fx_swap.set_quote(	number 		option(nullable) quote,							
							logical 	option(nullable) quote_is_unit,
							error_info option(nullable) error )  
{
	return this.set_quote(	quote,null<date>  ,quote_is_unit, error ) ;
}


/*-----------------------------------------------------------------------
  currencies  internal
  ----------------------------------------------------------------------*/
void fx_swap.currencies(	out string b_ccy,
							out string p_ccy)
{
	
	error_info ee = error_info(true,true);
	
	p_ccy = price_ccy(ee);		
	CORE_INT.instr_fail_check(null(p_ccy), "invalid price currency", this, ee);

	b_ccy = base_ccy(ee);
	CORE_INT.instr_fail_check(null(b_ccy), "invalid base currency", this, ee);
		
}
/*-----------------------------------------------------------------------
  fx_swap: synt_depo
  ----------------------------------------------------------------------*/
instrument  fx_swap.synt_depo(instrument 			fx_spot,
							day_count_method 		dc_synt,
							number 					rate,
							day_count_method 		dc,
							logical 				synt_is_base,	
							instrument option(nullable)	fx_swap_tn,
							error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		__instrument tn = null(fx_swap_tn) ? null<__instrument> : fx_swap_tn.i();
		__instrument c 	= i().__fx_synt_depo(fx_spot.i(),dc_synt,rate,dc,synt_is_base,tn,t, s);
		logical e 		= CORE_INT.add_error_info(error,t,s, "fx_swap.synt_depo");				
		return e ? null<deposit> : new deposit(c);		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap.synt_depo");
		return null<deposit>;
	}
}
/*-----------------------------------------------------------------------
  fx_swap: synt_depo
  ----------------------------------------------------------------------*/
instrument  fx_swap.synt_depo(number 				fx_spot_quote,
							day_count_method 		dc_synt,
							number 					rate,
							day_count_method 		dc,
							logical 				synt_is_base,	
							number option(nullable)	fx_swap_tn_quote,
							error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		
		__instrument c 	= i().__fx_synt_depo(fx_spot_quote,dc_synt,rate,dc,synt_is_base,fx_swap_tn_quote,t, s);
		logical e 		= CORE_INT.add_error_info(error,t,s, "fx_swap.synt_depo");				
		return e ? null<deposit> : new deposit(c);		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap.synt_depo");
		return null<deposit>;
	}
}
/*-----------------------------------------------------------------------
  fx_swap: fx_synt_depo
  ----------------------------------------------------------------------*/
instrument  fx_swap.fx_synt_depo(instrument 			fx_spot,
								day_count_method 		dc_synt,
								number 					rate,
								day_count_method 		dc,
								logical 				synt_is_base,	
								instrument option(nullable)	fx_swap_tn,
								error_info option(nullable) error) option(hidden) 
{
	return this.synt_depo(fx_spot,dc_synt,rate,dc,synt_is_base,fx_swap_tn,error) ;
}
/*-----------------------------------------------------------------------
  fx_swap: create_fx_spot
  ----------------------------------------------------------------------*/
..fx_spot fx_swap.create_fx_spot(string option(nullable) quote_side,
						error_info option(nullable) error)
{	
	try{
		string bc,pc;
		currencies(	bc,pc);
		
		instrument_name name 	= CORE_INT_FX.fx_inst_name(bc, pc);			
		__instrument c 			= __instrument(name,this.trade_date(),quote_side, null<date> );

		instr_error e 			= new instr_error();	
		fx_spot fxs 			= ..create_fx_spot( c, e);
		CORE_INT.instr_fail_check(null(fxs), "invalid fx_spot", this, e);
		return fxs;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap.create_fx_spot");
		return null<..fx_spot>;
	}
}

/*-----------------------------------------------------------------------
  fx_swap: create_fx_spot
  ----------------------------------------------------------------------*/
..fx_spot fx_swap.create_fx_spot(number option(nullable) quote,
						error_info option(nullable) error)
{	
	try{
		string bc,pc;
		currencies(	bc,pc);
		
		instrument_name name = CORE_INT_FX.fx_inst_name(bc, pc);
		__instrument c;
		
		if(null(quote))
			c = __instrument(name,this.trade_date(), null<string>, null<date> );					
		else 
			c = __instrument(name,this.trade_date(), quote, null<date> );
							
		instr_error e 	= new instr_error();	
		fx_spot fxs 	= ..create_fx_spot( c, e);
		CORE_INT.instr_fail_check(null(fxs), "invalid fx_spot", this, e);
		return fxs;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap.create_fx_spot");
		return null<..fx_spot>;
	}
}

/*-----------------------------------------------------------------------
  add_quote
  ----------------------------------------------------------------------*/
void fx_swap.add_quote(	number  quote,
						logical option(nullable) quote_is_unit)
{		
	instrument.fx_add_quote(quote,quote_is_unit);						
}

/*-----------------------------------------------------------------------
  is_post_spot
  ----------------------------------------------------------------------*/
logical  fx_swap.is_post_spot(	..fx_spot fx_spot,
								error_info option(nullable) error) 
{	
	return instrument.fx_is_post_spot(fx_spot, error);
}

/*-----------------------------------------------------------------------
  rate_base
  ----------------------------------------------------------------------*/
number fx_swap.rate_base(	..fx_spot 					fx_spot,
							day_count_method 			dc_base,
							rate_type 					rt_base,
							number 						rate_price,
							day_count_method 			dc_price,
							rate_type 					rt_price,
							fx_swap option(nullable) 	fx_swap_tn,								
							error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		__instrument tn = null(fx_swap_tn) ? null<__instrument> : fx_swap_tn.i();
		number c = i().__fx_swap_rate_base(	fx_spot.i(),dc_base,rt_base,rate_price,
											dc_price,rt_price,tn,t,s);

		logical e = CORE_INT.add_error_info(error,t,s, "fx_swap.rate_base");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap.rate_base");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  rate_base
  ----------------------------------------------------------------------*/
number fx_swap.rate_base(	number 						fx_spot_quote,
							day_count_method 			dc_base,
							rate_type 					rt_base,
							number 						rate_price,
							day_count_method 			dc_price,
							rate_type 					rt_price,
							number option(nullable) 	fx_swap_tn_quote,								
							error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		number c = i().__fx_swap_rate_base(	fx_spot_quote,dc_base,rt_base,rate_price,
											dc_price,rt_price,fx_swap_tn_quote,t,s);

		logical e = CORE_INT.add_error_info(error,t,s, "fx_swap.rate_base");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap.rate_base");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  rate_price
  ----------------------------------------------------------------------*/
number fx_swap.rate_price(	..fx_spot 					fx_spot,
							day_count_method 			dc_price,
							rate_type 					rt_price,
							number 						rate_base,
							day_count_method 			dc_base,
							rate_type 					rt_base,
							fx_swap option(nullable) 	fx_swap_tn,								
							error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		__instrument tn = null(fx_swap_tn) ? null<__instrument> : fx_swap_tn.i();
		number c = i().__fx_swap_rate_price(	fx_spot.i(),dc_price,rt_price,rate_base,
												dc_base,rt_base, tn,t,s);
		logical e = CORE_INT.add_error_info(error,t,s, "fx_swap.rate_price");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap.rate_price");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  rate_price
  ----------------------------------------------------------------------*/
number fx_swap.rate_price(	number 					fx_spot_quote,
							day_count_method 			dc_price,
							rate_type 					rt_price,
							number 						rate_base,
							day_count_method 			dc_base,
							rate_type 					rt_base,
							number option(nullable) 	fx_swap_tn_quote,								
							error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		number c = i().__fx_swap_rate_price(fx_spot_quote,dc_price,rt_price,rate_base,
												dc_base,rt_base, fx_swap_tn_quote,t,s);
		logical e = CORE_INT.add_error_info(error,t,s, "fx_swap.rate_price");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap.rate_price");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  fx_df_to_swap
  ----------------------------------------------------------------------*/
number  fx_swap.df_to_swap(disc_func 					disc_func_base, 
    						disc_func 					disc_func_price,									
							..fx_spot 					fx_spot,
							fx_swap option(nullable) 	fx_swap_tn,
							logical						unit_quote,
							logical 					no_rnd,	
							error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		__instrument tn = null(fx_swap_tn) ? null<__instrument> : fx_swap_tn.i();
		number c = i().__fx_df_to_swap(	disc_func_base,disc_func_price,fx_spot.i(),
										tn ,unit_quote,no_rnd,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fx_swap.df_to_swap");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap.df_to_swap");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  fx_df_to_swap
  ----------------------------------------------------------------------*/
number  fx_swap.df_to_swap(disc_func 					disc_func_base, 
    						disc_func 					disc_func_price,									
							number 						fx_spot_quote,
							number option(nullable) 	fx_swap_tn_quote,
							logical						unit_quote,
							logical 					no_rnd,	
							error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		number c = i().__fx_df_to_swap(	disc_func_base,disc_func_price,fx_spot_quote,
										fx_swap_tn_quote,unit_quote,no_rnd,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fx_swap.df_to_swap");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap.df_to_swap");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  swap_tail
  ----------------------------------------------------------------------*/
void  fx_swap.tail(	number 		nom_base,
						number option(nullable) nom_base_out,
						logical 	buy_base,
						disc_func	disc_func_base,
						disc_func	disc_func_price,
						..fx_spot 	fx_spot,
						fx_swap option(nullable) fx_swap_tn,
						logical		hdg_is_price,
						logical 	matched_prin,
						out number tail_base,
						out number tail_price,
						error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		__instrument tn = null(fx_swap_tn) ? null<__instrument> : fx_swap_tn.i();
		i().__fx_swap_tail(	nom_base, nom_base_out, buy_base, disc_func_base,disc_func_price,fx_spot.i(),
							tn,hdg_is_price,matched_prin,tail_base,tail_price,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fx_swap.tail");	
		if(e){
			tail_base = tail_base = null<number>;			
		}
		return ;							
	}
	catch {
		tail_base = tail_base = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap.tail");
		return ;
	}
}
/*-----------------------------------------------------------------------
  swap_tail
  ----------------------------------------------------------------------*/
void  fx_swap.tail(	number 		nom_base,
						number option(nullable) nom_base_out,
						logical 	buy_base,
						disc_func	disc_func_base,
						disc_func	disc_func_price,
						number 	fx_spot_quote,
						number option(nullable) fx_swap_tn_quote,
						logical		hdg_is_price,
						logical 	matched_prin,
						out number tail_base,
						out number tail_price,
						error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		i().__fx_swap_tail(	nom_base, nom_base_out, buy_base, disc_func_base,disc_func_price,fx_spot_quote,
							fx_swap_tn_quote,hdg_is_price,matched_prin,tail_base,tail_price,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fx_swap.tail");	
		if(e){
			tail_base = tail_base = null<number>;			
		}
		return ;							
	}
	catch {
		tail_base = tail_base = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap.tail");
		return ;
	}
}
/*-----------------------------------------------------------------------
  swap_cashflow
  ----------------------------------------------------------------------*/
void  fx_swap.cashflow(number 		nom_base,
						number option(nullable) nom_base_out,
						logical 	buy_base,
						disc_func	disc_func_base,
						..fx_spot 	fx_spot,
						fx_swap option(nullable) fx_swap_tn,
						logical 	matched_prin,
						out vector(number)   cf_base_amounts,
						out vector(number)   cf_price_amounts,
						error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		__instrument tn = null(fx_swap_tn) ? null<__instrument> : fx_swap_tn.i();
		i().__fx_swap_cashflow(	nom_base, nom_base_out, buy_base, disc_func_base,fx_spot.i(),
								tn,	matched_prin,cf_base_amounts,cf_price_amounts,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fx_swap.cashflow");	
		if(e){
			cf_base_amounts = cf_price_amounts = null<vector(number)>;			
		}
		return ;							
	}
	catch {
		cf_base_amounts = cf_price_amounts = null<vector(number)>;	
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap.cashflow");
		return ;
	}
}
/*-----------------------------------------------------------------------
  swap_cashflow
  ----------------------------------------------------------------------*/
void  fx_swap.cashflow(number 		nom_base,
						number option(nullable) nom_base_out,
						logical 	buy_base,
						disc_func	disc_func_base,
						number 	fx_spot_quote,
						number option(nullable) fx_swap_tn_quote,
						logical 	matched_prin,
						out vector(number)   cf_base_amounts,
						out vector(number)   cf_price_amounts,
						error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		i().__fx_swap_cashflow(	nom_base, nom_base_out, buy_base, disc_func_base,fx_spot_quote,
								fx_swap_tn_quote,	matched_prin,cf_base_amounts,cf_price_amounts,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fx_swap.cashflow");	
		if(e){
			cf_base_amounts = cf_price_amounts = null<vector(number)>;			
		}
		return ;							
	}
	catch {
		cf_base_amounts = cf_price_amounts = null<vector(number)>;	
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap.cashflow");
		return ;
	}
}
/*-----------------------------------------------------------------------
  synt_depo
  ----------------------------------------------------------------------*/
/*deposit  fx_swap.synt_depo(	..fx_spot 				fx_spot,
								day_count_method 		dc_synt,
								number 					rate,
								day_count_method 		dc,
								logical 				synt_is_base,	
								fx_swap option(nullable)	fx_swap_tn,
								error_info option(nullable) error) 
{	
	instrument dep = this.synt_depo(fx_spot,dc_synt,rate,dc,synt_is_base,fx_swap_tn,error) ;
	return deposit(dep);
}


*/



/*-----------------------------------------------------------------------
  fx_swap: outright
  ----------------------------------------------------------------------*/
number  fx_swap.outright(	number option(nullable) quote,
							..fx_spot				fx_spot,
							fx_swap option(nullable) fx_swap_tn,
							logical					unit_quote,
							logical 				no_rnd,	
							error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;
		__instrument tn = null(fx_swap_tn) ? null<__instrument> : fx_swap_tn.i();
		number c = i().__fx_swap_to_fwd(quote,fx_spot.i(),tn,
										unit_quote,no_rnd,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fx_swap.outright");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap.outright");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  fx_swap: outright
  ----------------------------------------------------------------------*/
number  fx_swap.outright(	number option(nullable) quote,
							number					fx_spot_quote,
							number option(nullable) fx_swap_tn_quote,
							logical					unit_quote,
							logical 				no_rnd,	
							error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;
		number c = i().__fx_swap_to_fwd(quote,fx_spot_quote,fx_swap_tn_quote,
										unit_quote,no_rnd,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "fx_swap.outright");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap.outright");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  fx_swap: quote
  ----------------------------------------------------------------------*/
number  fx_swap.quote(	logical		unit_quote,
						logical 	no_rnd,	
						error_info option(nullable) error)
{	
	return instrument.fx_quote(unit_quote,no_rnd,error);
}

/*-----------------------------------------------------------------------
  fx_swap: quote   
  ----------------------------------------------------------------------*/
number  fx_swap.quote(error_info option(nullable) error)
{	
	return this.quote(false,false, error);
}

/*-----------------------------------------------------------------------
  fx_swap: quote   
  ----------------------------------------------------------------------*/
number  fx_swap.quote(..quote_style option(nullable) qs,
					  error_info option(nullable) error)
{	
	try {
		QL_FAIL_COND(!null(qs) && qs != ..quote_style.FX_PIPS, "invalid quote style (only FX_PIPS is applicable)", this, true) ;			
		return this.quote(false,false, error);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap.quote");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  err funcs  
  ----------------------------------------------------------------------*/
//number fx_swap.quote(..quote_style.quote_style quote_style,error_info option(nullable) error) 	{ fin_instr.err_type(1, error);}

number fx_swap.quote(disc_func	disc_func,
					 ..quote_style	option(nullable) quote_style,
					error_info option(nullable) error) 							{ return fin_instr.err_type(1.0, error);}
