option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	generic
	--------------------------------------------------------------------
*/


//----------------------------------------------------------------------
//  class generic
//----------------------------------------------------------------------
class generic: public instrument
option(category: "Instrument/Generic")
//option(allow_undeclared_mfuncs)
{
public:
    //override string	instr_type_s();
	override instrument 	inst();
	
	generic(__instrument);	
	override generic clone();

	/*---set functions-required--*/	
	override generic		set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);
	override generic		set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);

	//local set
	generic				set_quote(	number option(nullable),date option(nullable) trade_date , date option(nullable) settle_date = null<date>,
									error_info option(nullable) error = null<error_info>);
	generic				set_quote(	string option(nullable),date option(nullable) trade_date  , date option(nullable) settle_date = null<date>,
									error_info option(nullable) error = null<error_info>);

	/*---set functions-if applicable--*/
					
	override generic		set_date(date,date option(nullable) s = null<date>,logical r = true,logical rq = true ,
									 error_info option(nullable) error = null<error_info>);

	override generic		set_settle_date(date ,logical re_initialize = false, error_info option(nullable) error = null<error_info> );
	override string 	__curve_sort_maturity();
	
	generic(generic);
protected:
	
	override generic 		create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG); 

	override generic		set_date(date,logical ,error_info option(nullable) error = null<error_info>);
	override generic		move_date(date,date option(nullable) s = null<date>, error_info option(nullable) error = null<error_info>);
   
};

//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
generic.generic(__instrument i) option(hidden) : instrument(i){}
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string generic.instr_type_s() { return string(..instr_type.GENERIC);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	generic.inst()		{ return this;}
//------------------------------------------------
// copy constructor
//------------------------------------------------
generic.generic(generic c) : instrument(c) {}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
generic generic(generic b)	{ return new generic(b);}
//------------------------------------------------
// clone
//------------------------------------------------
generic generic.clone() 	{ return new generic(this);}
//-----------------------------------------------
// dynamic cast <FUNCTION>
//-----------------------------------------------
generic generic(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Generic')
option(com_name: 'generic_dyncast') 
{ 
	try {
		generic d = dynamic_cast<generic>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a generic)","generic" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "generic");
		return null<generic>;
	}
}
//------------------------------------------------
// create  [PROTECTED]
// create generic from internal instrument
//------------------------------------------------
generic generic.create(	__instrument option(nullable) c,
						out instr_error option(nullable) error,
						error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<generic>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.GENERIC, "invalid instrument type",type );//should not happen
	
	return new generic(c);
}

/*-----------------------------------------------------------------------
  create_generic  <FUNCTION>
  ----------------------------------------------------------------------*/
generic create_generic(	__instrument option(nullable) c,
						out instr_error option(nullable) error,
						error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_generic')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if(!valid && INSTR_CREATE_NULL_ERR)
		return null<generic>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.GENERIC, "invalid instrument type",type );//should not happen
	
	return new generic(c);
}

generic create_generic(	__instrument option(nullable) 		c,
						error_info option(nullable) 		error,
						error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_generic_ei')
{
	instr_error ee 	= instr_error();
	generic b 	= create_generic(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_generic");
	return b;
}
/*-----------------------------------------------------------------------
  generic: set_date
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
generic generic.set_date(	date  				trade_date, 
					date  option(nullable)	settle_date,
					logical 			re_init_static, 
					logical 			re_init_quote, 
					error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,settle_date,re_init_static,re_init_quote,error);
	return null(cc) ? null<generic>: dynamic_cast<generic>(cc);
	
}


/*-----------------------------------------------------------------------
  generic: set_date
	quote is NOT kept even if trade_date is unchanged
  ----------------------------------------------------------------------*/
generic generic.set_date(		date  				trade_date, 
							logical 			re_initialize, 
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(	trade_date,re_initialize,error);
	return null(cc) ? null<generic>: dynamic_cast<generic>(cc);	
}


/*-----------------------------------------------------------------------
  generic: move_date
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	if trade date is the same --> the settle date will be preserved	
  ----------------------------------------------------------------------*/
generic generic.move_date(date  				trade_date, 
						date option(nullable) settle_date,
						error_info option(nullable) error)
{	
	instrument cc = instrument._move_date(trade_date,settle_date,error);
	return null(cc) ? null<generic>: dynamic_cast<generic>(cc);
}


/*-----------------------------------------------------------------------
  generic: set_quote 
  ----------------------------------------------------------------------*/
generic generic.set_quote(	number 	option(nullable) quote,
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, false,error);
	return null(cc) ? null<generic>: dynamic_cast<generic>(cc);
}


/*-----------------------------------------------------------------------
  generic: set_quote 
  ----------------------------------------------------------------------*/
generic generic.set_quote(	string 	option(nullable) quote_side,
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, false,error);
	return null(cc) ? null<generic>: dynamic_cast<generic>(cc);
}


/*-----------------------------------------------------------------------
  generic: set_quote 
  ----------------------------------------------------------------------*/
generic generic.set_quote(	number 	option(nullable) quote,
						date  	option(nullable) trade_date, 
						date  	option(nullable) settle_date, 
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,trade_date, settle_date, false,error);
	return null(cc) ? null<generic>: dynamic_cast<generic>(cc);
}

/*-----------------------------------------------------------------------
  generic: set_quote
  ----------------------------------------------------------------------*/
generic generic.set_quote(	string 	option(nullable) quote_side,
						date  	option(nullable) trade_date, 
						date  	option(nullable) settle_date, 
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,trade_date, settle_date, false,error);
	return null(cc) ? null<generic>: dynamic_cast<generic>(cc);
}


/*-----------------------------------------------------------------------
  generic: set_settle_date
  ----------------------------------------------------------------------*/
generic generic.set_settle_date(	date  				settle_date, 
							logical 			re_initialize, 
							error_info option(nullable) error)
{	
	
	instrument cc = instrument._set_settle_date(	settle_date, re_initialize, error);
	return null(cc) ? null<generic>: dynamic_cast<generic>(cc);
}

/*-----------------------------------------------------------------------
  __curve_sort_maturity
  ----------------------------------------------------------------------*/
string generic.__curve_sort_maturity() option(hidden)
{
	try {
		date m;
		try {
			m = maturity_adj();
		}
		catch {
			m = null;
		}
		return null(m) ? name() : strcat(string(m), name());
	}
	catch {
		return "";
	}
}